/*
 * tegra30_apbif_alt.h - Tegra30 APBIF registers
 *
 * Copyright (c) 2011-2014 NVIDIA CORPORATION.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __TEGRA_APBIF_ALT_H__
#define __TEGRA_APBIF_ALT_H__

#define TEGRA_APBIF_CHANNEL0_STRIDE	0x20
#define TEGRA_APBIF_CHANNEL0_COUNT	4

#define TEGRA_APBIF_AUDIOCIF_STRIDE		0x20
#define TEGRA_APBIF_AUDIOCIF_COUNT		4

/* TEGRA_AHUB_CHANNEL_CTRL */

#define TEGRA_AHUB_CHANNEL_CTRL			0x0
#define TEGRA_AHUB_CHANNEL_CTRL_STRIDE		0x20
#define TEGRA_AHUB_CHANNEL_CTRL_COUNT			4
#define TEGRA_AHUB_CHANNEL_CTRL_TX_EN			(1 << 31)
#define TEGRA_AHUB_CHANNEL_CTRL_RX_EN			(1 << 30)
#define TEGRA_AHUB_CHANNEL_CTRL_LOOPBACK		(1 << 29)

#define TEGRA_AHUB_CHANNEL_CTRL_TX_THRESHOLD_SHIFT	16
#define TEGRA_AHUB_CHANNEL_CTRL_TX_THRESHOLD_MASK_US	0xff
#define TEGRA_AHUB_CHANNEL_CTRL_TX_THRESHOLD_MASK	(TEGRA_AHUB_CHANNEL_CTRL_TX_THRESHOLD_MASK_US << TEGRA_AHUB_CHANNEL_CTRL_TX_THRESHOLD_SHIFT)

#define TEGRA_AHUB_CHANNEL_CTRL_RX_THRESHOLD_SHIFT	8
#define TEGRA_AHUB_CHANNEL_CTRL_RX_THRESHOLD_MASK_US	0xff
#define TEGRA_AHUB_CHANNEL_CTRL_RX_THRESHOLD_MASK	(TEGRA_AHUB_CHANNEL_CTRL_RX_THRESHOLD_MASK_US << TEGRA_AHUB_CHANNEL_CTRL_RX_THRESHOLD_SHIFT)

#define TEGRA_AHUB_CHANNEL_CTRL_TX_PACK_EN		(1 << 6)

#define PACK_NOP				0
#define PACK_8_4				2
#define PACK_16					3

#define TEGRA_AHUB_CHANNEL_CTRL_TX_PACK_SHIFT		4
#define TEGRA_AHUB_CHANNEL_CTRL_TX_PACK_MASK_US	3
#define TEGRA_AHUB_CHANNEL_CTRL_TX_PACK_MASK		(TEGRA_AHUB_CHANNEL_CTRL_TX_PACK_MASK_US << TEGRA_AHUB_CHANNEL_CTRL_TX_PACK_SHIFT)
#define TEGRA_AHUB_CHANNEL_CTRL_TX_PACK_8_4		(PACK_8_4 << TEGRA_AHUB_CHANNEL_CTRL_TX_PACK_SHIFT)
#define TEGRA_AHUB_CHANNEL_CTRL_TX_PACK_16		(PACK_16 << TEGRA_AHUB_CHANNEL_CTRL_TX_PACK_SHIFT)

#define TEGRA_AHUB_CHANNEL_CTRL_RX_PACK_EN		(1 << 2)

#define TEGRA_AHUB_CHANNEL_CTRL_RX_PACK_SHIFT		0
#define TEGRA_AHUB_CHANNEL_CTRL_RX_PACK_MASK_US	3
#define TEGRA_AHUB_CHANNEL_CTRL_RX_PACK_MASK		(TEGRA_AHUB_CHANNEL_CTRL_RX_PACK_MASK_US << TEGRA_AHUB_CHANNEL_CTRL_RX_PACK_SHIFT)
#define TEGRA_AHUB_CHANNEL_CTRL_RX_PACK_8_4		(PACK_8_4 << TEGRA_AHUB_CHANNEL_CTRL_RX_PACK_SHIFT)
#define TEGRA_AHUB_CHANNEL_CTRL_RX_PACK_16		(PACK_16 << TEGRA_AHUB_CHANNEL_CTRL_RX_PACK_SHIFT)

/* TEGRA_AHUB_CHANNEL_CLEAR */

#define TEGRA_AHUB_CHANNEL_CLEAR			0x4
#define TEGRA_AHUB_CHANNEL_CLEAR_STRIDE		0x20
#define TEGRA_AHUB_CHANNEL_CLEAR_COUNT		4
#define TEGRA_AHUB_CHANNEL_CLEAR_TX_SOFT_RESET	(1 << 31)
#define TEGRA_AHUB_CHANNEL_CLEAR_RX_SOFT_RESET	(1 << 30)

/* TEGRA_AHUB_CHANNEL_STATUS */

#define TEGRA_AHUB_CHANNEL_STATUS			0x8
#define TEGRA_AHUB_CHANNEL_STATUS_STRIDE		0x20
#define TEGRA_AHUB_CHANNEL_STATUS_COUNT		4
#define TEGRA_AHUB_CHANNEL_STATUS_TX_FREE_SHIFT	24
#define TEGRA_AHUB_CHANNEL_STATUS_TX_FREE_MASK_US	0xff
#define TEGRA_AHUB_CHANNEL_STATUS_TX_FREE_MASK	(TEGRA_AHUB_CHANNEL_STATUS_TX_FREE_MASK_US << TEGRA_AHUB_CHANNEL_STATUS_TX_FREE_SHIFT)
#define TEGRA_AHUB_CHANNEL_STATUS_RX_FREE_SHIFT	16
#define TEGRA_AHUB_CHANNEL_STATUS_RX_FREE_MASK_US	0xff
#define TEGRA_AHUB_CHANNEL_STATUS_RX_FREE_MASK	(TEGRA_AHUB_CHANNEL_STATUS_RX_FREE_MASK_US << TEGRA_AHUB_CHANNEL_STATUS_RX_FREE_SHIFT)
#define TEGRA_AHUB_CHANNEL_STATUS_TX_TRIG		(1 << 1)
#define TEGRA_AHUB_CHANNEL_STATUS_RX_TRIG		(1 << 0)

/* TEGRA_AHUB_CHANNEL_TXFIFO */

#define TEGRA_AHUB_CHANNEL_TXFIFO			0xc
#define TEGRA_AHUB_CHANNEL_TXFIFO_STRIDE		0x20
#define TEGRA_AHUB_CHANNEL_TXFIFO_COUNT		4

/* TEGRA_AHUB_CHANNEL_RXFIFO */

#define TEGRA_AHUB_CHANNEL_RXFIFO			0x10
#define TEGRA_AHUB_CHANNEL_RXFIFO_STRIDE		0x20
#define TEGRA_AHUB_CHANNEL_RXFIFO_COUNT		4

/* TEGRA_AHUB_CIF_TX_CTRL */

#define TEGRA_AHUB_CIF_TX_CTRL			0x14
#define TEGRA_AHUB_CIF_TX_CTRL_STRIDE			0x20
#define TEGRA_AHUB_CIF_TX_CTRL_COUNT			4
/* Uses field from AUDIOCIF_CTRL_* */

/* TEGRA_AHUB_CIF_RX_CTRL */

#define TEGRA_AHUB_CIF_RX_CTRL			0x18
#define TEGRA_AHUB_CIF_RX_CTRL_STRIDE			0x20
#define TEGRA_AHUB_CIF_RX_CTRL_COUNT			4
/* Uses field from AUDIOCIF_CTRL_* */

/* TEGRA_AHUB_CONFIG_LINK_CTRL */

#define TEGRA_AHUB_CONFIG_LINK_CTRL					0x80
#define TEGRA_AHUB_CONFIG_LINK_CTRL_MASTER_FIFO_FULL_CNT_SHIFT	28
#define TEGRA_AHUB_CONFIG_LINK_CTRL_MASTER_FIFO_FULL_CNT_MASK_US	0xf
#define TEGRA_AHUB_CONFIG_LINK_CTRL_MASTER_FIFO_FULL_CNT_MASK		(TEGRA_AHUB_CONFIG_LINK_CTRL_MASTER_FIFO_FULL_CNT_MASK_US << TEGRA_AHUB_CONFIG_LINK_CTRL_MASTER_FIFO_FULL_CNT_SHIFT)
#define TEGRA_AHUB_CONFIG_LINK_CTRL_TIMEOUT_CNT_SHIFT			16
#define TEGRA_AHUB_CONFIG_LINK_CTRL_TIMEOUT_CNT_MASK_US		0xfff
#define TEGRA_AHUB_CONFIG_LINK_CTRL_TIMEOUT_CNT_MASK			(TEGRA_AHUB_CONFIG_LINK_CTRL_TIMEOUT_CNT_MASK_US << TEGRA_AHUB_CONFIG_LINK_CTRL_TIMEOUT_CNT_SHIFT)
#define TEGRA_AHUB_CONFIG_LINK_CTRL_IDLE_CNT_SHIFT			4
#define TEGRA_AHUB_CONFIG_LINK_CTRL_IDLE_CNT_MASK_US			0xfff
#define TEGRA_AHUB_CONFIG_LINK_CTRL_IDLE_CNT_MASK			(TEGRA_AHUB_CONFIG_LINK_CTRL_IDLE_CNT_MASK_US << TEGRA_AHUB_CONFIG_LINK_CTRL_IDLE_CNT_SHIFT)
#define TEGRA_AHUB_CONFIG_LINK_CTRL_CG_EN				(1 << 2)
#define TEGRA_AHUB_CONFIG_LINK_CTRL_CLEAR_TIMEOUT_CNTR		(1 << 1)
#define TEGRA_AHUB_CONFIG_LINK_CTRL_SOFT_RESET			(1 << 0)

/* TEGRA_AHUB_MISC_CTRL */

#define TEGRA_AHUB_MISC_CTRL				0x84
#define TEGRA_AHUB_MISC_CTRL_AUDIO_ACTIVE		(1 << 31)
#define TEGRA_AHUB_MISC_CTRL_AUDIO_CG_EN		(1 << 8)
#define TEGRA_AHUB_MISC_CTRL_AUDIO_OBS_SEL_SHIFT	0
#define TEGRA_AHUB_MISC_CTRL_AUDIO_OBS_SEL_MASK	(0x1f << TEGRA_AHUB_MISC_CTRL_AUDIO_OBS_SEL_SHIFT)

/* TEGRA_AHUB_APBDMA_LIVE_STATUS */

#define TEGRA_AHUB_APBDMA_LIVE_STATUS				0x88
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH3_RX_CIF_FIFO_FULL	(1 << 31)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH3_TX_CIF_FIFO_FULL	(1 << 30)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH2_RX_CIF_FIFO_FULL	(1 << 29)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH2_TX_CIF_FIFO_FULL	(1 << 28)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH1_RX_CIF_FIFO_FULL	(1 << 27)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH1_TX_CIF_FIFO_FULL	(1 << 26)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH0_RX_CIF_FIFO_FULL	(1 << 25)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH0_TX_CIF_FIFO_FULL	(1 << 24)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH3_RX_CIF_FIFO_EMPTY	(1 << 23)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH3_TX_CIF_FIFO_EMPTY	(1 << 22)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH2_RX_CIF_FIFO_EMPTY	(1 << 21)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH2_TX_CIF_FIFO_EMPTY	(1 << 20)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH1_RX_CIF_FIFO_EMPTY	(1 << 19)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH1_TX_CIF_FIFO_EMPTY	(1 << 18)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH0_RX_CIF_FIFO_EMPTY	(1 << 17)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH0_TX_CIF_FIFO_EMPTY	(1 << 16)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH3_RX_DMA_FIFO_FULL	(1 << 15)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH3_TX_DMA_FIFO_FULL	(1 << 14)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH2_RX_DMA_FIFO_FULL	(1 << 13)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH2_TX_DMA_FIFO_FULL	(1 << 12)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH1_RX_DMA_FIFO_FULL	(1 << 11)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH1_TX_DMA_FIFO_FULL	(1 << 10)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH0_RX_DMA_FIFO_FULL	(1 << 9)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH0_TX_DMA_FIFO_FULL	(1 << 8)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH3_RX_DMA_FIFO_EMPTY	(1 << 7)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH3_TX_DMA_FIFO_EMPTY	(1 << 6)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH2_RX_DMA_FIFO_EMPTY	(1 << 5)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH2_TX_DMA_FIFO_EMPTY	(1 << 4)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH1_RX_DMA_FIFO_EMPTY	(1 << 3)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH1_TX_DMA_FIFO_EMPTY	(1 << 2)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH0_RX_DMA_FIFO_EMPTY	(1 << 1)
#define TEGRA_AHUB_APBDMA_LIVE_STATUS_CH0_TX_DMA_FIFO_EMPTY	(1 << 0)

/* TEGRA_AHUB_I2S_LIVE_STATUS */

#define TEGRA_AHUB_I2S_LIVE_STATUS				0x8c
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S4_RX_FIFO_FULL		(1 << 29)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S4_TX_FIFO_FULL		(1 << 28)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S3_RX_FIFO_FULL		(1 << 27)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S3_TX_FIFO_FULL		(1 << 26)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S2_RX_FIFO_FULL		(1 << 25)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S2_TX_FIFO_FULL		(1 << 24)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S1_RX_FIFO_FULL		(1 << 23)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S1_TX_FIFO_FULL		(1 << 22)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S0_RX_FIFO_FULL		(1 << 21)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S0_TX_FIFO_FULL		(1 << 20)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S4_RX_FIFO_ENABLED	(1 << 19)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S4_TX_FIFO_ENABLED	(1 << 18)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S3_RX_FIFO_ENABLED	(1 << 17)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S3_TX_FIFO_ENABLED	(1 << 16)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S2_RX_FIFO_ENABLED	(1 << 15)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S2_TX_FIFO_ENABLED	(1 << 14)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S1_RX_FIFO_ENABLED	(1 << 13)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S1_TX_FIFO_ENABLED	(1 << 12)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S0_RX_FIFO_ENABLED	(1 << 11)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S0_TX_FIFO_ENABLED	(1 << 10)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S4_RX_FIFO_EMPTY		(1 << 9)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S4_TX_FIFO_EMPTY		(1 << 8)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S3_RX_FIFO_EMPTY		(1 << 7)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S3_TX_FIFO_EMPTY		(1 << 6)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S2_RX_FIFO_EMPTY		(1 << 5)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S2_TX_FIFO_EMPTY		(1 << 4)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S1_RX_FIFO_EMPTY		(1 << 3)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S1_TX_FIFO_EMPTY		(1 << 2)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S0_RX_FIFO_EMPTY		(1 << 1)
#define TEGRA_AHUB_I2S_LIVE_STATUS_I2S0_TX_FIFO_EMPTY		(1 << 0)

/* TEGRA_AHUB_DAM0_LIVE_STATUS */

#define TEGRA_AHUB_DAM_LIVE_STATUS				0x90
#define TEGRA_AHUB_DAM_LIVE_STATUS_STRIDE			0x8
#define TEGRA_AHUB_DAM_LIVE_STATUS_COUNT			3
#define TEGRA_AHUB_DAM_LIVE_STATUS_TX_ENABLED			(1 << 26)
#define TEGRA_AHUB_DAM_LIVE_STATUS_RX1_ENABLED		(1 << 25)
#define TEGRA_AHUB_DAM_LIVE_STATUS_RX0_ENABLED		(1 << 24)
#define TEGRA_AHUB_DAM_LIVE_STATUS_TXFIFO_FULL		(1 << 15)
#define TEGRA_AHUB_DAM_LIVE_STATUS_RX1FIFO_FULL		(1 << 9)
#define TEGRA_AHUB_DAM_LIVE_STATUS_RX0FIFO_FULL		(1 << 8)
#define TEGRA_AHUB_DAM_LIVE_STATUS_TXFIFO_EMPTY		(1 << 7)
#define TEGRA_AHUB_DAM_LIVE_STATUS_RX1FIFO_EMPTY		(1 << 1)
#define TEGRA_AHUB_DAM_LIVE_STATUS_RX0FIFO_EMPTY		(1 << 0)

/* TEGRA_AHUB_SPDIF_LIVE_STATUS */

#define TEGRA_AHUB_SPDIF_LIVE_STATUS				0xa8
#define TEGRA_AHUB_SPDIF_LIVE_STATUS_USER_TX_ENABLED		(1 << 11)
#define TEGRA_AHUB_SPDIF_LIVE_STATUS_USER_RX_ENABLED		(1 << 10)
#define TEGRA_AHUB_SPDIF_LIVE_STATUS_DATA_TX_ENABLED		(1 << 9)
#define TEGRA_AHUB_SPDIF_LIVE_STATUS_DATA_RX_ENABLED		(1 << 8)
#define TEGRA_AHUB_SPDIF_LIVE_STATUS_USER_TXFIFO_FULL		(1 << 7)
#define TEGRA_AHUB_SPDIF_LIVE_STATUS_USER_RXFIFO_FULL		(1 << 6)
#define TEGRA_AHUB_SPDIF_LIVE_STATUS_DATA_TXFIFO_FULL		(1 << 5)
#define TEGRA_AHUB_SPDIF_LIVE_STATUS_DATA_RXFIFO_FULL		(1 << 4)
#define TEGRA_AHUB_SPDIF_LIVE_STATUS_USER_TXFIFO_EMPTY	(1 << 3)
#define TEGRA_AHUB_SPDIF_LIVE_STATUS_USER_RXFIFO_EMPTY	(1 << 2)
#define TEGRA_AHUB_SPDIF_LIVE_STATUS_DATA_TXFIFO_EMPTY	(1 << 1)
#define TEGRA_AHUB_SPDIF_LIVE_STATUS_DATA_RXFIFO_EMPTY	(1 << 0)

/* TEGRA_AHUB_I2S_INT_MASK */

#define TEGRA_AHUB_I2S_INT_MASK				0xb0

/* TEGRA_AHUB_DAM_INT_MASK */

#define TEGRA_AHUB_DAM_INT_MASK				0xb4

/* TEGRA_AHUB_SPDIF_INT_MASK */

#define TEGRA_AHUB_SPDIF_INT_MASK				0xbc

/* TEGRA_AHUB_APBIF_INT_MASK */

#define TEGRA_AHUB_APBIF_INT_MASK				0xc0

/* TEGRA_AHUB_I2S_INT_STATUS */

#define TEGRA_AHUB_I2S_INT_STATUS				0xc8

/* TEGRA_AHUB_DAM_INT_STATUS */

#define TEGRA_AHUB_DAM_INT_STATUS				0xcc

/* TEGRA_AHUB_SPDIF_INT_STATUS */

#define TEGRA_AHUB_SPDIF_INT_STATUS				0xd4

/* TEGRA_AHUB_APBIF_INT_STATUS */

#define TEGRA_AHUB_APBIF_INT_STATUS				0xd8

/* TEGRA_AHUB_I2S_INT_SOURCE */

#define TEGRA_AHUB_I2S_INT_SOURCE				0xe0

/* TEGRA_AHUB_DAM_INT_SOURCE */

#define TEGRA_AHUB_DAM_INT_SOURCE				0xe4

/* TEGRA_AHUB_SPDIF_INT_SOURCE */

#define TEGRA_AHUB_SPDIF_INT_SOURCE				0xec

/* TEGRA_AHUB_APBIF_INT_SOURCE */

#define TEGRA_AHUB_APBIF_INT_SOURCE				0xf0

/* TEGRA_AHUB_I2S_INT_SET */

#define TEGRA_AHUB_I2S_INT_SET				0xf8

/* TEGRA_AHUB_DAM_INT_SET */

#define TEGRA_AHUB_DAM_INT_SET				0xfc

/* TEGRA_AHUB_SPDIF_INT_SET */

#define TEGRA_AHUB_SPDIF_INT_SET				0x100

/* TEGRA_AHUB_APBIF_INT_SET */

#define TEGRA_AHUB_APBIF_INT_SET				0x104

/* TEGRA_AHUB_CIF_RX9_CTRL */
#define TEGRA_AHUB_CIF_RX9_CTRL				0xb8

int tegra30_apbif_i2s_rx_fifo_is_enabled(int i2s_id);
int tegra30_apbif_i2s_tx_fifo_is_enabled(int i2s_id);
int tegra30_apbif_i2s_rx_fifo_is_empty(int i2s_id);
int tegra30_apbif_i2s_tx_fifo_is_empty(int i2s_id);

struct tegra30_apbif_soc_data {
	unsigned int num_ch;
	unsigned int clk_list_mask;
	void (*set_audio_cif)(struct regmap *map,
			unsigned int reg,
			struct tegra30_xbar_cif_conf *cif_conf);
};

struct tegra30_apbif {
	struct clk *clk;
	/* regmap for APBIF */
	struct regmap *regmap[2];
	struct tegra_alt_pcm_dma_params *capture_dma_data;
	struct tegra_alt_pcm_dma_params *playback_dma_data;
	const struct tegra30_apbif_soc_data *soc_data;
};

#endif
