/*
 * max98090.h -- MAX98090 ALSA SoC Audio driver
 *
 * Copyright 2011-2012 Maxim Integrated Products
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef _MAX98090_H
#define _MAX98090_H

#include <linux/version.h>

/* One can override the Linux version here with an explicit version number */
#define M98090_LINUX_VERSION LINUX_VERSION_CODE

/*
 * Driver revision
 */
#define MAX98090_REVISION			"0.01.00"

/*
 * MAX98090 Register Definitions
 */

#define M98090_REG_00_SW_RESET			0x00
#define M98090_REG_01_IRQ_STATUS		0x01
#define M98090_REG_02_JACK_STATUS		0x02
#define M98090_REG_03_IRQ_ENABLE		0x03
#define M98090_REG_04_QCFG_SYS_CLK		0x04
#define M98090_REG_05_QCFG_RATE			0x05
#define M98090_REG_06_QCFG_DAI			0x06
#define M98090_REG_07_QCFG_DAC			0x07
#define M98090_REG_08_QCFG_MIC_PATH		0x08
#define M98090_REG_09_QCFG_LINE_PATH		0x09
#define M98090_REG_0A_QCFG_MIC_LOOP		0x0A
#define M98090_REG_0B_QCFG_LINE_LOOP		0x0B
#define M98090_REG_0C_RESERVED			0x0C
#define M98090_REG_0D_CFG_INPUT			0x0D
#define M98090_REG_0E_LVL_LINE			0x0E
#define M98090_REG_0F_CFG_LINE			0x0F
#define M98090_REG_10_LVL_MIC1			0x10
#define M98090_REG_11_LVL_MIC2			0x11
#define M98090_REG_12_MIC_BIAS			0x12
#define M98090_REG_13_MIC_CFG1			0x13
#define M98090_REG_14_MIC_CFG2			0x14
#define M98090_REG_15_MIX_ADC_L			0x15
#define M98090_REG_16_MIX_ADC_R			0x16
#define M98090_REG_17_LVL_ADC_L			0x17
#define M98090_REG_18_LVL_ADC_R			0x18
#define M98090_REG_19_LVL_BIQUAD		0x19
#define M98090_REG_1A_LVL_SIDETONE		0x1A
#define M98090_REG_1B_SYS_CLOCK			0x1B
#define M98090_REG_1C_CLOCK_MODE		0x1C
#define M98090_REG_1D_CLOCK_DAI1_NI_HI		0x1D
#define M98090_REG_1E_CLOCK_DAI2_NI_LO		0x1E
#define M98090_REG_1F_CLOCK_DAI3_MI_HI		0x1F
#define M98090_REG_20_CLOCK_DAI4_MI_LO		0x20
#define M98090_REG_21_CLOCK_MAS_MODE		0x21
#define M98090_REG_22_DAI_INTERFACE_FORMAT	0x22
#define M98090_REG_23_DAI_TDM_CONTROL		0x23
#define M98090_REG_24_DAI_TDM_FORMAT		0x24
#define M98090_REG_25_DAI_IOCFG			0x25
#define M98090_REG_26_DAI_FILTERS		0x26
#define M98090_REG_27_DAI_LVL			0x27
#define M98090_REG_28_DAI_LVL_EQ		0x28
#define M98090_REG_29_MIX_HP_LEFT		0x29
#define M98090_REG_2A_MIX_HP_RIGHT		0x2A
#define M98090_REG_2B_MIX_HP_CNTL		0x2B
#define M98090_REG_2C_LVL_HP_LEFT		0x2C
#define M98090_REG_2D_LVL_HP_RIGHT		0x2D
#define M98090_REG_2E_MIX_SPK_LEFT		0x2E
#define M98090_REG_2F_MIX_SPK_RIGHT		0x2F
#define M98090_REG_30_MIX_SPK_CNTL		0x30
#define M98090_REG_31_LVL_SPK_LEFT		0x31
#define M98090_REG_32_LVL_SPK_RIGHT		0x32
#define M98090_REG_33_ALC_TIMING		0x33
#define M98090_REG_34_ALC_CMPR			0x34
#define M98090_REG_35_ALC_EXP			0x35
#define M98090_REG_36_LVL_ALC			0x36
#define M98090_REG_37_MIX_RCV_LEFT		0x37
#define M98090_REG_38_MIX_RCV_CTRL_LEFT		0x38
#define M98090_REG_39_LVL_RCV_LEFT		0x39
#define M98090_REG_3A_MIX_RCV_RIGHT		0x3A
#define M98090_REG_3B_MIX_RCV_CNTL_RIGHT	0x3B
#define M98090_REG_3C_LVL_RCV_RIGHT		0x3C
#define M98090_REG_3D_CFG_JACK			0x3D
#define M98090_REG_3E_PWR_EN_IN			0x3E
#define M98090_REG_3F_PWR_EN_OUT		0x3F
#define M98090_REG_40_CFG_LVL			0x40
#define M98090_REG_41_DSP_EQ_EN			0x41
#define M98090_REG_42_BIAS_CNTL			0x42
#define M98090_REG_43_DAC_CFG			0x43
#define M98090_REG_44_ADC_CFG			0x44
#define M98090_REG_45_PWR_SYS			0x45
#define M98090_REG_46_EQ_BASE			0x46
#define M98090_REG_AF_BIQUAD_BASE		0xAF
#define M98090_REG_BE_DMIC3_VOLUME		0xBE
#define M98090_REG_BF_DMIC4_VOLUME		0xBF
#define M98090_REG_C0_DMIC34_BQ_PREATTEN	0xC0
#define M98090_REG_C1_RECORD_TDM_SLOT		0xC1
#define M98090_REG_C2_SAMPLE_RATE		0xC2
#define M98090_REG_C3_DMIC34_BIQUAD_BASE	0xC3
#define M98090_REG_FF_REV_ID			0xFF

#define M98090_REG_CNT				(0xFF+1)


/* MAX98090 Register Bit Fields */

/*
 * M98090_REG_00_SW_RESET
 */
#define M98090_SWRESET_MASK		(1<<7)
#define M98090_SWRESET_SHIFT		7
#define M98090_SWRESET_WIDTH		1

/*
 * M98090_REG_01_IRQ_STATUS
 */
#define M98090_IRQ_CLD_MASK		(1<<7)
#define M98090_IRQ_CLD_SHIFT		7
#define M98090_IRQ_CLD_WIDTH		1
#define M98090_IRQ_SLD_MASK		(1<<6)
#define M98090_IRQ_SLD_SHIFT		6
#define M98090_IRQ_SLD_WIDTH		1
#define M98090_IRQ_ULK_MASK		(1<<5)
#define M98090_IRQ_ULK_SHIFT		5
#define M98090_IRQ_ULK_WIDTH		1
#define M98090_IRQ_JDET_MASK		(1<<2)
#define M98090_IRQ_JDET_SHIFT		2
#define M98090_IRQ_JDET_WIDTH		1
#define M98090_IRQ_ALCACT_MASK		(1<<1)
#define M98090_IRQ_ALCACT_SHIFT		1
#define M98090_IRQ_ALCACT_WIDTH		1
#define M98090_IRQ_ALCCLP_MASK		(1<<0)
#define M98090_IRQ_ALCCLP_SHIFT		0
#define M98090_IRQ_ALCCLP_WIDTH		1

/*
 * M98090_REG_02_JACK_STATUS
 */
#define M98090_LSNS_MASK		(1<<2)
#define M98090_LSNS_SHIFT		2
#define M98090_LSNS_WIDTH		1
#define M98090_JKSNS_MASK		(1<<1)
#define M98090_JKSNS_SHIFT		1
#define M98090_JKSNS_WIDTH		1

/*
 * M98090_REG_03_IRQ_ENABLE
 */
#define M98090_IRQ_ICLD_MASK		(1<<7)
#define M98090_IRQ_ICLD_SHIFT		7
#define M98090_IRQ_ICLD_WIDTH		1
#define M98090_IRQ_ISLD_MASK		(1<<6)
#define M98090_IRQ_ISLD_SHIFT		6
#define M98090_IRQ_ISLD_WIDTH		1
#define M98090_IRQ_IULK_MASK		(1<<5)
#define M98090_IRQ_IULK_SHIFT		5
#define M98090_IRQ_IULK_WIDTH		1
#define M98090_IRQ_IJDET_MASK		(1<<2)
#define M98090_IRQ_IJDET_SHIFT		2
#define M98090_IRQ_IJDET_WIDTH		1
#define M98090_IRQ_IALCACT_MASK		(1<<1)
#define M98090_IRQ_IALCACT_SHIFT	1
#define M98090_IRQ_IALCACT_WIDTH	1
#define M98090_IRQ_IALCCLP_MASK		(1<<0)
#define M98090_IRQ_IALCCLP_SHIFT	0
#define M98090_IRQ_IALCCLP_WIDTH	1

/*
 * M98090_REG_04_QCFG_SYS_CLK
 */
#define M98090_CLK_26M_MASK		(1<<7)
#define M98090_CLK_26M_SHIFT		7
#define M98090_CLK_26M_WIDTH		1
#define M98090_CLK_19P2M_MASK		(1<<6)
#define M98090_CLK_19P2M_SHIFT		6
#define M98090_CLK_19P2M_WIDTH		1
#define M98090_CLK_13M_MASK		(1<<5)
#define M98090_CLK_13M_SHIFT		5
#define M98090_CLK_13M_WIDTH		1
#define M98090_CLK_12P288M_MASK		(1<<4)
#define M98090_CLK_12P288M_SHIFT	4
#define M98090_CLK_12P288M_WIDTH	1
#define M98090_CLK_12M_MASK		(1<<3)
#define M98090_CLK_12M_SHIFT		3
#define M98090_CLK_12M_WIDTH		1
#define M98090_CLK_11P2896M_MASK	(1<<2)
#define M98090_CLK_11P2896M_SHIFT	2
#define M98090_CLK_11P2896M_WIDTH	1
#define M98090_CLK_256FS_MASK		(1<<0)
#define M98090_CLK_256FS_SHIFT		0
#define M98090_CLK_256FS_WIDTH		1
#define M98090_CLK_ALL_SHIFT		0
#define M98090_CLK_ALL_WIDTH		8
#define M98090_CLK_ALL_NUM		(1<<M98090_CLK_ALL_WIDTH)

/*
 * M98090_REG_05_QCFG_RATE
 */
#define M98090_SR_96K_MASK		(1<<5)
#define M98090_SR_96K_SHIFT		5
#define M98090_SR_96K_WIDTH		1
#define M98090_SR_32K_MASK		(1<<4)
#define M98090_SR_32K_SHIFT		4
#define M98090_SR_32K_WIDTH		1
#define M98090_SR_48K_MASK		(1<<3)
#define M98090_SR_48K_SHIFT		3
#define M98090_SR_48K_WIDTH		1
#define M98090_SR_44K1_MASK		(1<<2)
#define M98090_SR_44K1_SHIFT		2
#define M98090_SR_44K1_WIDTH		1
#define M98090_SR_16K_MASK		(1<<1)
#define M98090_SR_16K_SHIFT		1
#define M98090_SR_16K_WIDTH		1
#define M98090_SR_8K_MASK		(1<<0)
#define M98090_SR_8K_SHIFT		0
#define M98090_SR_8K_WIDTH		1
#define M98090_SR_MASK			0x3F
#define M98090_SR_ALL_SHIFT		0
#define M98090_SR_ALL_WIDTH		8
#define M98090_SR_ALL_NUM		(1<<M98090_SR_ALL_WIDTH)

/*
 * M98090_REG_06_QCFG_DAI
 */
#define M98090_DAI_RJ_M_MASK		(1<<5)
#define M98090_DAI_RJ_M_SHIFT		5
#define M98090_DAI_RJ_M_WIDTH		1
#define M98090_DAI_RJ_S_MASK		(1<<4)
#define M98090_DAI_RJ_S_SHIFT		4
#define M98090_DAI_RJ_S_WIDTH		1
#define M98090_DAI_LJ_M_MASK		(1<<3)
#define M98090_DAI_LJ_M_SHIFT		3
#define M98090_DAI_LJ_M_WIDTH		1
#define M98090_DAI_LJ_S_MASK		(1<<2)
#define M98090_DAI_LJ_S_SHIFT		2
#define M98090_DAI_LJ_S_WIDTH		1
#define M98090_DAI_I2S_M_MASK		(1<<1)
#define M98090_DAI_I2S_M_SHIFT		1
#define M98090_DAI_I2S_M_WIDTH		1
#define M98090_DAI_I2S_S_MASK		(1<<0)
#define M98090_DAI_I2S_S_SHIFT		0
#define M98090_DAI_I2S_S_WIDTH		1
#define M98090_DAI_ALL_SHIFT		0
#define M98090_DAI_ALL_WIDTH		8
#define M98090_DAI_ALL_NUM		(1<<M98090_DAI_ALL_WIDTH)

/*
 * M98090_REG_07_QCFG_DAC
 */
#define M98090_DIG2_HP_MASK		(1<<7)
#define M98090_DIG2_HP_SHIFT		7
#define M98090_DIG2_HP_WIDTH		1
#define M98090_DIG2_EAR_MASK		(1<<6)
#define M98090_DIG2_EAR_SHIFT		6
#define M98090_DIG2_EAR_WIDTH		1
#define M98090_DIG2_SPK_MASK		(1<<5)
#define M98090_DIG2_SPK_SHIFT		5
#define M98090_DIG2_SPK_WIDTH		1
#define M98090_DIG2_LOUT_MASK		(1<<4)
#define M98090_DIG2_LOUT_SHIFT		4
#define M98090_DIG2_LOUT_WIDTH		1
#define M98090_DIG2_ALL_SHIFT		0
#define M98090_DIG2_ALL_WIDTH		8
#define M98090_DIG2_ALL_NUM		(1<<M98090_DIG2_ALL_WIDTH)

/*
 * M98090_REG_08_QCFG_MIC_PATH
 */
#define M98090_IN12_MIC1_MASK		(1<<7)
#define M98090_IN12_MIC1_SHIFT		7
#define M98090_IN12_MIC1_WIDTH		1
#define M98090_IN34_MIC2_MASK		(1<<6)
#define M98090_IN34_MIC2_SHIFT		6
#define M98090_IN34_MIC2_WIDTH		1
#define M98090_IN56_MIC1_MASK		(1<<5)
#define M98090_IN56_MIC1_SHIFT		5
#define M98090_IN56_MIC1_WIDTH		1
#define M98090_IN56_MIC2_MASK		(1<<4)
#define M98090_IN56_MIC2_SHIFT		4
#define M98090_IN56_MIC2_WIDTH		1
#define M98090_IN12_DADC_MASK		(1<<3)
#define M98090_IN12_DADC_SHIFT		3
#define M98090_IN12_DADC_WIDTH		1
#define M98090_IN34_DADC_MASK		(1<<2)
#define M98090_IN34_DADC_SHIFT		2
#define M98090_IN34_DADC_WIDTH		1
#define M98090_IN56_DADC_MASK		(1<<1)
#define M98090_IN56_DADC_SHIFT		1
#define M98090_IN56_DADC_WIDTH		1
#define M98090_MIC_ALL_SHIFT		0
#define M98090_MIC_ALL_WIDTH		8
#define M98090_MIC_ALL_NUM		(1<<M98090_MIC_ALL_WIDTH)

/*
 * M98090_REG_09_QCFG_LINE_PATH
 */
#define M98090_IN12S_AB_MASK		(1<<7)
#define M98090_IN12S_AB_SHIFT		7
#define M98090_IN12S_AB_WIDTH		1
#define M98090_IN34S_AB_MASK		(1<<6)
#define M98090_IN34S_AB_SHIFT		6
#define M98090_IN34S_AB_WIDTH		1
#define M98090_IN56S_AB_MASK		(1<<5)
#define M98090_IN56S_AB_SHIFT		5
#define M98090_IN56S_AB_WIDTH		1
#define M98090_IN34D_A_MASK		(1<<4)
#define M98090_IN34D_A_SHIFT		4
#define M98090_IN34D_A_WIDTH		1
#define M98090_IN56D_B_MASK		(1<<3)
#define M98090_IN56D_B_SHIFT		3
#define M98090_IN56D_B_WIDTH		1
#define M98090_LINE_ALL_SHIFT		0
#define M98090_LINE_ALL_WIDTH		8
#define M98090_LINE_ALL_NUM		(1<<M98090_LINE_ALL_WIDTH)

/*
 * M98090_REG_0A_QCFG_MIC_LOOP
 */
#define M98090_IN12_M1HPL_MASK		(1<<7)
#define M98090_IN12_M1HPL_SHIFT		7
#define M98090_IN12_M1HPL_WIDTH		1
#define M98090_IN12_M1SPKL_MASK		(1<<6)
#define M98090_IN12_M1SPKL_SHIFT	6
#define M98090_IN12_M1SPKL_WIDTH	1
#define M98090_IN12_M1EAR_MASK		(1<<5)
#define M98090_IN12_M1EAR_SHIFT		5
#define M98090_IN12_M1EAR_WIDTH		1
#define M98090_IN12_M1LOUTL_MASK	(1<<4)
#define M98090_IN12_M1LOUTL_SHIFT	4
#define M98090_IN12_M1LOUTL_WIDTH	1
#define M98090_IN34_M2HPR_MASK		(1<<3)
#define M98090_IN34_M2HPR_SHIFT		3
#define M98090_IN34_M2HPR_WIDTH		1
#define M98090_IN34_M2SPKR_MASK		(1<<2)
#define M98090_IN34_M2SPKR_SHIFT	2
#define M98090_IN34_M2SPKR_WIDTH	1
#define M98090_IN34_M2EAR_MASK		(1<<1)
#define M98090_IN34_M2EAR_SHIFT		1
#define M98090_IN34_M2EAR_WIDTH		1
#define M98090_IN34_M2LOUTR_MASK	(1<<0)
#define M98090_IN34_M2LOUTR_SHIFT	0
#define M98090_IN34_M2LOUTR_WIDTH	1
#define M98090_AMIC_ALL_SHIFT		0
#define M98090_AMIC_ALL_WIDTH		8
#define M98090_AMIC_ALL_NUM		(1<<M98090_AMIC_ALL_WIDTH)

/*
 * M98090_REG_0B_QCFG_LINE_LOOP
 */
#define M98090_IN12S_ABHP_MASK		(1<<7)
#define M98090_IN12S_ABHP_SHIFT		7
#define M98090_IN12S_ABHP_WIDTH		1
#define M98090_IN34D_ASPKL_MASK		(1<<6)
#define M98090_IN34D_ASPKL_SHIFT	6
#define M98090_IN34D_ASPKL_WIDTH	1
#define M98090_IN34D_AEAR_MASK		(1<<5)
#define M98090_IN34D_AEAR_SHIFT		5
#define M98090_IN34D_AEAR_WIDTH		1
#define M98090_IN12S_ABLOUT_MASK	(1<<4)
#define M98090_IN12S_ABLOUT_SHIFT	4
#define M98090_IN12S_ABLOUT_WIDTH	1
#define M98090_IN34S_ABHP_MASK		(1<<3)
#define M98090_IN34S_ABHP_SHIFT		3
#define M98090_IN34S_ABHP_WIDTH		1
#define M98090_IN56D_BSPKR_MASK		(1<<2)
#define M98090_IN56D_BSPKR_SHIFT	2
#define M98090_IN56D_BSPKR_WIDTH	1
#define M98090_IN56D_BEAR_MASK		(1<<1)
#define M98090_IN56D_BEAR_SHIFT		1
#define M98090_IN56D_BEAR_WIDTH		1
#define M98090_IN34S_ABLOUT_MASK	(1<<0)
#define M98090_IN34S_ABLOUT_SHIFT	0
#define M98090_IN34S_ABLOUT_WIDTH	1
#define M98090_ALIN_ALL_SHIFT		0
#define M98090_ALIN_ALL_WIDTH		8
#define M98090_ALIN_ALL_NUM		(1<<M98090_ALIN_ALL_WIDTH)

/*
 * M98090_REG_0C_RESERVED
 */

/*
 * M98090_REG_0D_CFG_INPUT
 */
#define M98090_IN34DIFF_MASK		(1<<7)
#define M98090_IN34DIFF_SHIFT		7
#define M98090_IN34DIFF_WIDTH		1
#define M98090_IN56DIFF_MASK		(1<<6)
#define M98090_IN56DIFF_SHIFT		6
#define M98090_IN56DIFF_WIDTH		1
#define M98090_IN1SEEN_MASK		(1<<5)
#define M98090_IN1SEEN_SHIFT		5
#define M98090_IN1SEEN_WIDTH		1
#define M98090_IN2SEEN_MASK		(1<<4)
#define M98090_IN2SEEN_SHIFT		4
#define M98090_IN2SEEN_WIDTH		1
#define M98090_IN3SEEN_MASK		(1<<3)
#define M98090_IN3SEEN_SHIFT		3
#define M98090_IN3SEEN_WIDTH		1
#define M98090_IN4SEEN_MASK		(1<<2)
#define M98090_IN4SEEN_SHIFT		2
#define M98090_IN4SEEN_WIDTH		1
#define M98090_IN5SEEN_MASK		(1<<1)
#define M98090_IN5SEEN_SHIFT		1
#define M98090_IN5SEEN_WIDTH		1
#define M98090_IN6SEEN_MASK		(1<<0)
#define M98090_IN6SEEN_SHIFT		0
#define M98090_IN6SEEN_WIDTH		1

/*
 * M98090_REG_0E_LVL_LINE
 */
#define M98090_MIXG135_MASK		(1<<7)
#define M98090_MIXG135_SHIFT		7
#define M98090_MIXG135_WIDTH		1
#define M98090_MIXT246_MASK		(1<<6)
#define M98090_MIXT246_SHIFT		6
#define M98090_MIXT246_WIDTH		1
#define M98090_LINAPGA_MASK		(7<<3)
#define M98090_LINAPGA_SHIFT		3
#define M98090_LINAPGA_WIDTH		3
#define M98090_LINAPGA_NUM		6
#define M98090_LINBPGA_MASK		(7<<0)
#define M98090_LINBPGA_SHIFT		0
#define M98090_LINBPGA_WIDTH		3
#define M98090_LINBPGA_NUM		6

/*
 * M98090_REG_0F_CFG_LINE
 */
#define M98090_EXTBUFA_MASK		(1<<7)
#define M98090_EXTBUFA_SHIFT		7
#define M98090_EXTBUFA_WIDTH		1
#define M98090_EXTBUFA_NUM		(1<<M98090_EXTBUFA_WIDTH)
#define M98090_EXTBUFB_MASK		(1<<6)
#define M98090_EXTBUFB_SHIFT		6
#define M98090_EXTBUFB_WIDTH		1
#define M98090_EXTBUFB_NUM		(1<<M98090_EXTBUFB_WIDTH)
#define M98090_EXTMIC_MASK		(3<<0)
#define M98090_EXTMIC_SHIFT		0
#define M98090_EXTMIC1_SHIFT		0
#define M98090_EXTMIC2_SHIFT		1
#define M98090_EXTMIC_WIDTH		2
#define M98090_EXTMIC_NONE		(0<<0)
#define M98090_EXTMIC_MIC1		(1<<0)
#define M98090_EXTMIC_MIC2		(2<<0)

/*
 * M98090_REG_10_LVL_MIC1
 */
#define M98090_MIC_PA1EN_MASK		(3<<5)
#define M98090_MIC_PA1EN_SHIFT		5
#define M98090_MIC_PA1EN_WIDTH		2
#define M98090_MIC_PA1EN_NUM		3
#define M98090_MIC_PGAM1_MASK		(31<<0)
#define M98090_MIC_PGAM1_SHIFT		0
#define M98090_MIC_PGAM1_WIDTH		5
#define M98090_MIC_PGAM1_NUM		21

/*
 * M98090_REG_11_LVL_MIC2
 */
#define M98090_MIC_PA2EN_MASK		(3<<5)
#define M98090_MIC_PA2EN_SHIFT		5
#define M98090_MIC_PA2EN_WIDTH		2
#define M98090_MIC_PA2EN_NUM		3
#define M98090_MIC_PGAM2_MASK		(31<<0)
#define M98090_MIC_PGAM2_SHIFT		0
#define M98090_MIC_PGAM2_WIDTH		5
#define M98090_MIC_PGAM2_NUM		21

/*
 * M98090_REG_12_MIC_BIAS
 */
#define M98090_MBVSEL_MASK		(3<<0)
#define M98090_MBVSEL_SHIFT		0
#define M98090_MBVSEL_WIDTH		2
#define M98090_MBVSEL_2V8		(3<<0)
#define M98090_MBVSEL_2V55		(2<<0)
#define M98090_MBVSEL_2V4		(1<<0)
#define M98090_MBVSEL_2V2		(0<<0)

/*
 * M98090_REG_13_MIC_CFG1
 */
#define M98090_MICCLK_MASK		(7<<4)
#define M98090_MICCLK_SHIFT		4
#define M98090_MICCLK_WIDTH		3
#define M98090_DIGMIC4_MASK		(1<<3)
#define M98090_DIGMIC4_SHIFT		3
#define M98090_DIGMIC4_WIDTH		1
#define M98090_DIGMIC4_NUM		(1<<M98090_DIGMIC4_WIDTH)
#define M98090_DIGMIC3_MASK		(1<<2)
#define M98090_DIGMIC3_SHIFT		2
#define M98090_DIGMIC3_WIDTH		1
#define M98090_DIGMIC3_NUM		(1<<M98090_DIGMIC3_WIDTH)
#define M98090_DIGMICR_MASK		(1<<1)
#define M98090_DIGMICR_SHIFT		1
#define M98090_DIGMICR_WIDTH		1
#define M98090_DIGMICR_NUM		(1<<M98090_DIGMICR_WIDTH)
#define M98090_DIGMICL_MASK		(1<<0)
#define M98090_DIGMICL_SHIFT		0
#define M98090_DIGMICL_WIDTH		1
#define M98090_DIGMICL_NUM		(1<<M98090_DIGMICL_WIDTH)

/*
 * M98090_REG_14_MIC_CFG2
 */
#define M98090_DMIC_COMP_MASK		(15<<4)
#define M98090_DMIC_COMP_SHIFT		4
#define M98090_DMIC_COMP_WIDTH		4
#define M98090_DMIC_COMP_NUM		(1<<M98090_DMIC_COMP_WIDTH)
#define M98090_DMIC_FREQ_MASK		(3<<0)
#define M98090_DMIC_FREQ_SHIFT		0
#define M98090_DMIC_FREQ_WIDTH		2

/*
 * M98090_REG_15_MIX_ADC_L
 */
#define M98090_MIXADL_MIC2_MASK		(1<<6)
#define M98090_MIXADL_MIC2_SHIFT	6
#define M98090_MIXADL_MIC2_WIDTH	1
#define M98090_MIXADL_MIC1_MASK		(1<<5)
#define M98090_MIXADL_MIC1_SHIFT	5
#define M98090_MIXADL_MIC1_WIDTH	1
#define M98090_MIXADL_LINEB_MASK	(1<<4)
#define M98090_MIXADL_LINEB_SHIFT	4
#define M98090_MIXADL_LINEB_WIDTH	1
#define M98090_MIXADL_LINEA_MASK	(1<<3)
#define M98090_MIXADL_LINEA_SHIFT	3
#define M98090_MIXADL_LINEA_WIDTH	1
#define M98090_MIXADL_IN65DIFF_MASK	(1<<2)
#define M98090_MIXADL_IN65DIFF_SHIFT	2
#define M98090_MIXADL_IN65DIFF_WIDTH	1
#define M98090_MIXADL_IN34DIFF_MASK	(1<<1)
#define M98090_MIXADL_IN34DIFF_SHIFT	1
#define M98090_MIXADL_IN34DIFF_WIDTH	1
#define M98090_MIXADL_IN12DIFF_MASK	(1<<0)
#define M98090_MIXADL_IN12DIFF_SHIFT	0
#define M98090_MIXADL_IN12DIFF_WIDTH	1
#define M98090_MIXADL_MASK		(255<<0)
#define M98090_MIXADL_SHIFT		0
#define M98090_MIXADL_WIDTH		8

/*
 * M98090_REG_16_MIX_ADC_R
 */
#define M98090_MIXADR_MIC2_MASK		(1<<6)
#define M98090_MIXADR_MIC2_SHIFT	6
#define M98090_MIXADR_MIC2_WIDTH	1
#define M98090_MIXADR_MIC1_MASK		(1<<5)
#define M98090_MIXADR_MIC1_SHIFT	5
#define M98090_MIXADR_MIC1_WIDTH	1
#define M98090_MIXADR_LINEB_MASK	(1<<4)
#define M98090_MIXADR_LINEB_SHIFT	4
#define M98090_MIXADR_LINEB_WIDTH	1
#define M98090_MIXADR_LINEA_MASK	(1<<3)
#define M98090_MIXADR_LINEA_SHIFT	3
#define M98090_MIXADR_LINEA_WIDTH	1
#define M98090_MIXADR_IN65DIFF_MASK	(1<<2)
#define M98090_MIXADR_IN65DIFF_SHIFT	2
#define M98090_MIXADR_IN65DIFF_WIDTH	1
#define M98090_MIXADR_IN34DIFF_MASK	(1<<1)
#define M98090_MIXADR_IN34DIFF_SHIFT	1
#define M98090_MIXADR_IN34DIFF_WIDTH	1
#define M98090_MIXADR_IN12DIFF_MASK	(1<<0)
#define M98090_MIXADR_IN12DIFF_SHIFT	0
#define M98090_MIXADR_IN12DIFF_WIDTH	1
#define M98090_MIXADR_MASK		(255<<0)
#define M98090_MIXADR_SHIFT		0
#define M98090_MIXADR_WIDTH		8

/*
 * M98090_REG_17_LVL_ADC_L
 */
#define M98090_ADC_AVLG_MASK		(7<<4)
#define M98090_ADC_AVLG_SHIFT		4
#define M98090_ADC_AVLG_WIDTH		3
#define M98090_ADC_AVLG_NUM		(1<<M98090_ADC_AVLG_WIDTH)
#define M98090_ADC_AVL_MASK		(15<<0)
#define M98090_ADC_AVL_SHIFT		0
#define M98090_ADC_AVL_WIDTH		4
#define M98090_ADC_AVL_NUM		(1<<M98090_ADC_AVL_WIDTH)

/*
 * M98090_REG_18_LVL_ADC_R
 */
#define M98090_ADC_AVRG_MASK		(7<<4)
#define M98090_ADC_AVRG_SHIFT		4
#define M98090_ADC_AVRG_WIDTH		3
#define M98090_ADC_AVRG_NUM		(1<<M98090_ADC_AVRG_WIDTH)
#define M98090_ADC_AVR_MASK		(15<<0)
#define M98090_ADC_AVR_SHIFT		0
#define M98090_ADC_AVR_WIDTH		4
#define M98090_ADC_AVR_NUM		(1<<M98090_ADC_AVR_WIDTH)

/*
 * M98090_REG_19_LVL_BIQUAD
 */
#define M98090_AVBQ_MASK		(15<<0)
#define M98090_AVBQ_SHIFT		0
#define M98090_AVBQ_WIDTH		4
#define M98090_AVBQ_NUM			(1<<M98090_AVBQ_WIDTH)

/*
 * M98090_REG_1A_LVL_SIDETONE
 */
#define M98090_DSTS_MASK		(3<<6)
#define M98090_DSTS_SHIFT		6
#define M98090_DSTS_WIDTH		2
#define M98090_DVST_MASK		(31<<0)
#define M98090_DVST_SHIFT		0
#define M98090_DVST_WIDTH		5
#define M98090_DVST_NUM			31

/*
 * M98090_REG_1B_SYS_CLOCK
 */
#define M98090_CLK_PSCLK_MASK		(3<<4)
#define M98090_CLK_PSCLK_SHIFT		4
#define M98090_CLK_PSCLK_WIDTH		2
#define M98090_CLK_PSCLK_DISABLED	(0<<4)
#define M98090_CLK_PSCLK_DIV1		(1<<4)
#define M98090_CLK_PSCLK_DIV2		(2<<4)
#define M98090_CLK_PSCLK_DIV4		(3<<4)

/*
 * M98090_REG_1C_CLOCK_MODE
 */
#define M98090_CLK_FREQ1_MASK		(15<<4)
#define M98090_CLK_FREQ1_SHIFT		4
#define M98090_CLK_FREQ1_WIDTH		4
#define M98090_CLK_USE_M1_MASK		(1<<0)
#define M98090_CLK_USE_M1_SHIFT		0
#define M98090_CLK_USE_M1_WIDTH		1
#define M98090_CLK_USE_M1_NUM		(1<<M98090_CLK_USE_M1_WIDTH)

/*
 * M98090_REG_1D_CLOCK_DAI1_NI_HI
 */
#define M98090_CLK_NI_HI_MASK		(127<<0)
#define M98090_CLK_NI_HI_SHIFT		0
#define M98090_CLK_NI_HI_WIDTH		7
#define M98090_CLK_NI_HI_NUM		(1<<M98090_CLK_NI_HI_WIDTH)

/*
 * M98090_REG_1E_CLOCK_DAI2_NI_LO
 */
#define M98090_CLK_NI_LO_MASK		(255<<0)
#define M98090_CLK_NI_LO_SHIFT		0
#define M98090_CLK_NI_LO_WIDTH		8
#define M98090_CLK_NI_LO_NUM		(1<<M98090_CLK_NI_LO_WIDTH)

/*
 * M98090_REG_1F_CLOCK_DAI3_MI_HI
 */
#define M98090_CLK_MI_HI_MASK		(255<<0)
#define M98090_CLK_MI_HI_SHIFT		0
#define M98090_CLK_MI_HI_WIDTH		8
#define M98090_CLK_MI_HI_NUM		(1<<M98090_CLK_MI_HI_WIDTH)

/*
 * M98090_REG_20_CLOCK_DAI4_MI_LO
 */
#define M98090_CLK_MI_LO_MASK		(255<<0)
#define M98090_CLK_MI_LO_SHIFT		0
#define M98090_CLK_MI_LO_WIDTH		8
#define M98090_CLK_MI_LO_NUM		(1<<M98090_CLK_MI_LO_WIDTH)

/*
 * M98090_REG_21_CLOCK_MAS_MODE
 */
#define M98090_CLK_MAS_MASK		(1<<7)
#define M98090_CLK_MAS_SHIFT		7
#define M98090_CLK_MAS_WIDTH		1
#define M98090_CLK_BSEL_MASK		(1<<0)
#define M98090_CLK_BSEL_SHIFT		0
#define M98090_CLK_BSEL_WIDTH		1
#define M98090_CLK_BSEL_32		(1<<0)
#define M98090_CLK_BSEL_48		(2<<0)
#define M98090_CLK_BSEL_64		(3<<0)

/*
 * M98090_REG_22_DAI_INTERFACE_FORMAT
 */
#define M98090_DAI_RJ_MASK		(1<<5)
#define M98090_DAI_RJ_SHIFT		5
#define M98090_DAI_RJ_WIDTH		1
#define M98090_DAI_WCI_MASK		(1<<4)
#define M98090_DAI_WCI_SHIFT		4
#define M98090_DAI_WCI_WIDTH		1
#define M98090_DAI_BCI_MASK		(1<<3)
#define M98090_DAI_BCI_SHIFT		3
#define M98090_DAI_BCI_WIDTH		1
#define M98090_DAI_DLY_MASK		(1<<2)
#define M98090_DAI_DLY_SHIFT		2
#define M98090_DAI_DLY_WIDTH		1
#define M98090_DAI_WS_MASK		(3<<0)
#define M98090_DAI_WS_SHIFT		0
#define M98090_DAI_WS_WIDTH		2
#define M98090_DAI_WS_NUM		(1<<M98090_DAI_WS_WIDTH)

/*
 * M98090_REG_23_DAI_TDM_CONTROL
 */
#define M98090_DAI_FSW_MASK		(1<<1)
#define M98090_DAI_FSW_SHIFT		1
#define M98090_DAI_FSW_WIDTH		1
#define M98090_DAI_TDM_MASK		(1<<0)
#define M98090_DAI_TDM_SHIFT		0
#define M98090_DAI_TDM_WIDTH		1
#define M98090_DAI_TDM_NUM		(1<<M98090_DAI_TDM_WIDTH)

/*
 * M98090_REG_24_DAI_TDM_FORMAT
 */
#define M98090_DAI_TDM_SLOTL_MASK	(3<<6)
#define M98090_DAI_TDM_SLOTL_SHIFT	6
#define M98090_DAI_TDM_SLOTL_WIDTH	2
#define M98090_DAI_TDM_SLOTL_NUM	(1<<M98090_DAI_TDM_SLOTL_WIDTH)
#define M98090_DAI_TDM_SLOTR_MASK	(3<<4)
#define M98090_DAI_TDM_SLOTR_SHIFT	4
#define M98090_DAI_TDM_SLOTR_WIDTH	2
#define M98090_DAI_TDM_SLOTR_NUM	(1<<M98090_DAI_TDM_SLOTR_WIDTH)
#define M98090_DAI_TDM_SLOTDLY_MASK	(15<<0)
#define M98090_DAI_TDM_SLOTDLY_SHIFT	0
#define M98090_DAI_TDM_SLOTDLY_WIDTH	4
#define M98090_DAI_TDM_SLOTDLY_NUM	(1<<M98090_DAI_TDM_SLOTDLY_WIDTH)

/*
 * M98090_REG_25_DAI_IOCFG
 */
#define M98090_DAI_LTEN_MASK		(1<<5)
#define M98090_DAI_LTEN_SHIFT		5
#define M98090_DAI_LTEN_WIDTH		1
#define M98090_DAI_LTEN_NUM		(1<<M98090_DAI_LTEN_WIDTH)
#define M98090_DAI_LBEN_MASK		(1<<4)
#define M98090_DAI_LBEN_SHIFT		4
#define M98090_DAI_LBEN_WIDTH		1
#define M98090_DAI_LBEN_NUM		(1<<M98090_DAI_LBEN_WIDTH)
#define M98090_DAI_DMONO_MASK		(1<<3)
#define M98090_DAI_DMONO_SHIFT		3
#define M98090_DAI_DMONO_WIDTH		1
#define M98090_DAI_DMONO_NUM		(1<<M98090_DAI_DMONO_WIDTH)
#define M98090_DAI_HIZOFF_MASK		(1<<2)
#define M98090_DAI_HIZOFF_SHIFT		2
#define M98090_DAI_HIZOFF_WIDTH		1
#define M98090_DAI_SDOEN_MASK		(1<<1)
#define M98090_DAI_SDOEN_SHIFT		1
#define M98090_DAI_SDOEN_WIDTH		1
#define M98090_DAI_SDIEN_MASK		(1<<0)
#define M98090_DAI_SDIEN_SHIFT		0
#define M98090_DAI_SDIEN_WIDTH		1

/*
 * M98090_REG_26_DAI_FILTERS
 */
#define M98090_DAI_FLT_MODE_MASK	(1<<7)
#define M98090_DAI_FLT_MODE_SHIFT	7
#define M98090_DAI_FLT_MODE_WIDTH	1
#define M98090_DAI_FLT_AHPF_MASK	(1<<6)
#define M98090_DAI_FLT_AHPF_SHIFT	6
#define M98090_DAI_FLT_AHPF_WIDTH	1
#define M98090_DAI_FLT_AHPF_NUM		(1<<M98090_DAI_FLT_AHPF_WIDTH)
#define M98090_DAI_FLT_DHPF_MASK	(1<<5)
#define M98090_DAI_FLT_DHPF_SHIFT	5
#define M98090_DAI_FLT_DHPF_WIDTH	1
#define M98090_DAI_FLT_DHPF_NUM		(1<<M98090_DAI_FLT_DHPF_WIDTH)
#define M98090_DAI_FLT_DHF_MASK		(1<<4)
#define M98090_DAI_FLT_DHF_SHIFT	4
#define M98090_DAI_FLT_DHF_WIDTH	1
#define M98090_DAI_FLT_DMIC34MODE_MASK	(1<<3)
#define M98090_DAI_FLT_DMIC34MODE_SHIFT	3
#define M98090_DAI_FLT_DMIC34MODE_WIDTH	1
#define M98090_DAI_FLT_DMIC34HPF_MASK	(1<<2)
#define M98090_DAI_FLT_DMIC34HPF_SHIFT	2
#define M98090_DAI_FLT_DMIC34HPF_WIDTH	1
#define M98090_DAI_FLT_DMIC34HPF_NUM	(1<<M98090_DAI_FLT_DMIC34HPF_WIDTH)

/*
 * M98090_REG_27_DAI_LVL
 */
#define M98090_DAI_LVL_DVM_MASK		(1<<7)
#define M98090_DAI_LVL_DVM_SHIFT	7
#define M98090_DAI_LVL_DVM_WIDTH	1
#define M98090_DAI_LVL_DVG_MASK		(3<<4)
#define M98090_DAI_LVL_DVG_SHIFT	4
#define M98090_DAI_LVL_DVG_WIDTH	2
#define M98090_DAI_LVL_DVG_NUM		(1<<M98090_DAI_LVL_DVG_WIDTH)
#define M98090_DAI_LVL_DV_MASK		(15<<0)
#define M98090_DAI_LVL_DV_SHIFT		0
#define M98090_DAI_LVL_DV_WIDTH		4
#define M98090_DAI_LVL_DV_NUM		(1<<M98090_DAI_LVL_DV_WIDTH)

/*
 * M98090_REG_28_DAI_LVL_EQ
 */
#define M98090_DAI_LVL_EQCLPN_MASK	(1<<4)
#define M98090_DAI_LVL_EQCLPN_SHIFT	4
#define M98090_DAI_LVL_EQCLPN_WIDTH	1
#define M98090_DAI_LVL_DVEQ_MASK	(15<<0)
#define M98090_DAI_LVL_DVEQ_SHIFT	0
#define M98090_DAI_LVL_DVEQ_WIDTH	4
#define M98090_DAI_LVL_DVEQ_NUM		(1<<M98090_DAI_LVL_DVEQ_WIDTH)

/*
 * M98090_REG_29_MIX_HP_LEFT
 */
#define M98090_MIXHPL_MIC2_MASK		(1<<5)
#define M98090_MIXHPL_MIC2_SHIFT	5
#define M98090_MIXHPL_MIC2_WIDTH	1
#define M98090_MIXHPL_MIC1_MASK		(1<<4)
#define M98090_MIXHPL_MIC1_SHIFT	4
#define M98090_MIXHPL_MIC1_WIDTH	1
#define M98090_MIXHPL_LINEB_MASK	(1<<3)
#define M98090_MIXHPL_LINEB_SHIFT	3
#define M98090_MIXHPL_LINEB_WIDTH	1
#define M98090_MIXHPL_LINEA_MASK	(1<<2)
#define M98090_MIXHPL_LINEA_SHIFT	2
#define M98090_MIXHPL_LINEA_WIDTH	1
#define M98090_MIXHPL_DACR_MASK		(1<<1)
#define M98090_MIXHPL_DACR_SHIFT	1
#define M98090_MIXHPL_DACR_WIDTH	1
#define M98090_MIXHPL_DACL_MASK		(1<<0)
#define M98090_MIXHPL_DACL_SHIFT	0
#define M98090_MIXHPL_DACL_WIDTH	1
#define M98090_MIXHPL_MASK		(63<<0)
#define M98090_MIXHPL_SHIFT		0
#define M98090_MIXHPL_WIDTH		6

/*
 * M98090_REG_2A_MIX_HP_RIGHT
 */
#define M98090_MIXHPR_MIC2_MASK		(1<<5)
#define M98090_MIXHPR_MIC2_SHIFT	5
#define M98090_MIXHPR_MIC2_WIDTH	1
#define M98090_MIXHPR_MIC1_MASK		(1<<4)
#define M98090_MIXHPR_MIC1_SHIFT	4
#define M98090_MIXHPR_MIC1_WIDTH	1
#define M98090_MIXHPR_LINEB_MASK	(1<<3)
#define M98090_MIXHPR_LINEB_SHIFT	3
#define M98090_MIXHPR_LINEB_WIDTH	1
#define M98090_MIXHPR_LINEA_MASK	(1<<2)
#define M98090_MIXHPR_LINEA_SHIFT	2
#define M98090_MIXHPR_LINEA_WIDTH	1
#define M98090_MIXHPR_DACR_MASK		(1<<1)
#define M98090_MIXHPR_DACR_SHIFT	1
#define M98090_MIXHPR_DACR_WIDTH	1
#define M98090_MIXHPR_DACL_MASK		(1<<0)
#define M98090_MIXHPR_DACL_SHIFT	0
#define M98090_MIXHPR_DACL_WIDTH	1
#define M98090_MIXHPR_MASK		(63<<0)
#define M98090_MIXHPR_SHIFT		0
#define M98090_MIXHPR_WIDTH		6

/*
 * M98090_REG_2B_MIX_HP_CNTL
 */
#define M98090_MIXHPRSEL_MASK		(1<<5)
#define M98090_MIXHPRSEL_SHIFT		5
#define M98090_MIXHPRSEL_WIDTH		1
#define M98090_MIXHPLSEL_MASK		(1<<4)
#define M98090_MIXHPLSEL_SHIFT		4
#define M98090_MIXHPLSEL_WIDTH		1
#define M98090_MIXHPRG_MASK		(3<<2)
#define M98090_MIXHPRG_SHIFT		2
#define M98090_MIXHPRG_WIDTH		2
#define M98090_MIXHPRG_NUM		(1<<M98090_MIXHPRG_WIDTH)
#define M98090_MIXHPLG_MASK		(3<<0)
#define M98090_MIXHPLG_SHIFT		0
#define M98090_MIXHPLG_WIDTH		2
#define M98090_MIXHPLG_NUM		(1<<M98090_MIXHPLG_WIDTH)

/*
 * M98090_REG_2C_LVL_HP_LEFT
 */
#define M98090_HPLM_MASK		(1<<7)
#define M98090_HPLM_SHIFT		7
#define M98090_HPLM_WIDTH		1
#define M98090_HPVOLL_MASK		(31<<0)
#define M98090_HPVOLL_SHIFT		0
#define M98090_HPVOLL_WIDTH		5
#define M98090_HPVOLL_NUM		(1<<M98090_HPVOLL_WIDTH)

/*
 * M98090_REG_2D_LVL_HP_RIGHT
 */
#define M98090_HPRM_MASK		(1<<7)
#define M98090_HPRM_SHIFT		7
#define M98090_HPRM_WIDTH		1
#define M98090_HPVOLR_MASK		(31<<0)
#define M98090_HPVOLR_SHIFT		0
#define M98090_HPVOLR_WIDTH		5
#define M98090_HPVOLR_NUM		(1<<M98090_HPVOLR_WIDTH)

/*
 * M98090_REG_2E_MIX_SPK_LEFT
 */
#define M98090_MIXSPL_MIC2_MASK		(1<<5)
#define M98090_MIXSPL_MIC2_SHIFT	5
#define M98090_MIXSPL_MIC2_WIDTH	1
#define M98090_MIXSPL_MIC1_MASK		(1<<4)
#define M98090_MIXSPL_MIC1_SHIFT	4
#define M98090_MIXSPL_MIC1_WIDTH	1
#define M98090_MIXSPL_LINEB_MASK	(1<<3)
#define M98090_MIXSPL_LINEB_SHIFT	3
#define M98090_MIXSPL_LINEB_WIDTH	1
#define M98090_MIXSPL_LINEA_MASK	(1<<2)
#define M98090_MIXSPL_LINEA_SHIFT	2
#define M98090_MIXSPL_LINEA_WIDTH	1
#define M98090_MIXSPL_DACR_MASK		(1<<1)
#define M98090_MIXSPL_DACR_SHIFT	1
#define M98090_MIXSPL_DACR_WIDTH	1
#define M98090_MIXSPL_DACL_MASK		(1<<0)
#define M98090_MIXSPL_DACL_SHIFT	0
#define M98090_MIXSPL_DACL_WIDTH	1
#define M98090_MIXSPL_MASK		(63<<0)
#define M98090_MIXSPL_SHIFT		0
#define M98090_MIXSPL_WIDTH		6
#define M98090_MIXSPR_DACR_MASK		(1<<1)
#define M98090_MIXSPR_DACR_SHIFT	1
#define M98090_MIXSPR_DACR_WIDTH	1


/*
 * M98090_REG_2F_MIX_SPK_RIGHT
 */
#define M98090_SPK_SLAVE_MASK		(1<<6)
#define M98090_SPK_SLAVE_SHIFT		6
#define M98090_SPK_SLAVE_WIDTH		1
#define M98090_MIXSPR_MIC2_MASK		(1<<5)
#define M98090_MIXSPR_MIC2_SHIFT	5
#define M98090_MIXSPR_MIC2_WIDTH	1
#define M98090_MIXSPR_MIC1_MASK		(1<<4)
#define M98090_MIXSPR_MIC1_SHIFT	4
#define M98090_MIXSPR_MIC1_WIDTH	1
#define M98090_MIXSPR_LINEB_MASK	(1<<3)
#define M98090_MIXSPR_LINEB_SHIFT	3
#define M98090_MIXSPR_LINEB_WIDTH	1
#define M98090_MIXSPR_LINEA_MASK	(1<<2)
#define M98090_MIXSPR_LINEA_SHIFT	2
#define M98090_MIXSPR_LINEA_WIDTH	1
#define M98090_MIXSPR_DACR_MASK		(1<<1)
#define M98090_MIXSPR_DACR_SHIFT	1
#define M98090_MIXSPR_DACR_WIDTH	1
#define M98090_MIXSPR_DACL_MASK		(1<<0)
#define M98090_MIXSPR_DACL_SHIFT	0
#define M98090_MIXSPR_DACL_WIDTH	1
#define M98090_MIXSPR_MASK		(63<<0)
#define M98090_MIXSPR_SHIFT		0
#define M98090_MIXSPR_WIDTH		6

/*
 * M98090_REG_30_MIX_SPK_CNTL
 */
#define M98090_MIXSPRG_MASK		(3<<2)
#define M98090_MIXSPRG_SHIFT		2
#define M98090_MIXSPRG_WIDTH		2
#define M98090_MIXSPRG_NUM		(1<<M98090_MIXSPRG_WIDTH)
#define M98090_MIXSPLG_MASK		(3<<0)
#define M98090_MIXSPLG_SHIFT		0
#define M98090_MIXSPLG_WIDTH		2
#define M98090_MIXSPLG_NUM		(1<<M98090_MIXSPLG_WIDTH)

/*
 * M98090_REG_31_LVL_SPK_LEFT
 */
#define M98090_SPLM_MASK		(1<<7)
#define M98090_SPLM_SHIFT		7
#define M98090_SPLM_WIDTH		1
#define M98090_SPVOLL_MASK		(63<<0)
#define M98090_SPVOLL_SHIFT		0
#define M98090_SPVOLL_WIDTH		6
#define M98090_SPVOLL_NUM		40

/*
 * M98090_REG_32_LVL_SPK_RIGHT
 */
#define M98090_SPRM_MASK		(1<<7)
#define M98090_SPRM_SHIFT		7
#define M98090_SPRM_WIDTH		1
#define M98090_SPVOLR_MASK		(63<<0)
#define M98090_SPVOLR_SHIFT		0
#define M98090_SPVOLR_WIDTH		6
#define M98090_SPVOLR_NUM		40

/*
 * M98090_REG_33_ALC_TIMING
 */
#define M98090_ALCEN_MASK		(1<<7)
#define M98090_ALCEN_SHIFT		7
#define M98090_ALCEN_WIDTH		1
#define M98090_ALCEN_NUM		(1<<M98090_ALCEN_WIDTH)
#define M98090_ALCRLS_MASK		(7<<4)
#define M98090_ALCRLS_SHIFT		4
#define M98090_ALCRLS_WIDTH		3
#define M98090_ALCATK_MASK		(7<<0)
#define M98090_ALCATK_SHIFT		0
#define M98090_ALCATK_WIDTH		3

/*
 * M98090_REG_34_ALC_CMPR
 */
#define M98090_ALCCMP_MASK		(7<<5)
#define M98090_ALCCMP_SHIFT		5
#define M98090_ALCCMP_WIDTH		3
#define M98090_ALCTHC_MASK		(31<<0)
#define M98090_ALCTHC_SHIFT		0
#define M98090_ALCTHC_WIDTH		5
#define M98090_ALCTHC_NUM		(1<<M98090_ALCTHC_WIDTH)

/*
 * M98090_REG_35_ALC_EXP
 */
#define M98090_ALCEXP_MASK		(7<<5)
#define M98090_ALCEXP_SHIFT		5
#define M98090_ALCEXP_WIDTH		3
#define M98090_ALCTHE_MASK		(31<<0)
#define M98090_ALCTHE_SHIFT		0
#define M98090_ALCTHE_WIDTH		5
#define M98090_ALCTHE_NUM		(1<<M98090_ALCTHE_WIDTH)

/*
 * M98090_REG_36_LVL_ALC
 */
#define M98090_ALCG_MASK		(31<<0)
#define M98090_ALCG_SHIFT		0
#define M98090_ALCG_WIDTH		5
#define M98090_ALCG_NUM			13

/*
 * M98090_REG_37_MIX_RCV_LEFT
 */
#define M98090_MIXRCVL_MIC2_MASK	(1<<5)
#define M98090_MIXRCVL_MIC2_SHIFT	5
#define M98090_MIXRCVL_MIC2_WIDTH	1
#define M98090_MIXRCVL_MIC1_MASK	(1<<4)
#define M98090_MIXRCVL_MIC1_SHIFT	4
#define M98090_MIXRCVL_MIC1_WIDTH	1
#define M98090_MIXRCVL_LINEB_MASK	(1<<3)
#define M98090_MIXRCVL_LINEB_SHIFT	3
#define M98090_MIXRCVL_LINEB_WIDTH	1
#define M98090_MIXRCVL_LINEA_MASK	(1<<2)
#define M98090_MIXRCVL_LINEA_SHIFT	2
#define M98090_MIXRCVL_LINEA_WIDTH	1
#define M98090_MIXRCVL_DACR_MASK	(1<<1)
#define M98090_MIXRCVL_DACR_SHIFT	1
#define M98090_MIXRCVL_DACR_WIDTH	1
#define M98090_MIXRCVL_DACL_MASK	(1<<0)
#define M98090_MIXRCVL_DACL_SHIFT	0
#define M98090_MIXRCVL_DACL_WIDTH	1
#define M98090_MIXRCVL_MASK		(63<<0)
#define M98090_MIXRCVL_SHIFT		0
#define M98090_MIXRCVL_WIDTH		6

/*
 * M98090_REG_38_MIX_RCV_CTRL_LEFT
 */
#define M98090_MIXRCVLG_MASK		(3<<0)
#define M98090_MIXRCVLG_SHIFT		0
#define M98090_MIXRCVLG_WIDTH		2
#define M98090_MIXRCVLG_NUM		(1<<M98090_MIXRCVLG_WIDTH)

/*
 * M98090_REG_39_LVL_RCV_LEFT
 */
#define M98090_RCVLM_MASK		(1<<7)
#define M98090_RCVLM_SHIFT		7
#define M98090_RCVLM_WIDTH		1
#define M98090_RCVLVOL_MASK		(31<<0)
#define M98090_RCVLVOL_SHIFT		0
#define M98090_RCVLVOL_WIDTH		5
#define M98090_RCVLVOL_NUM		(1<<M98090_RCVLVOL_WIDTH)

/*
 * M98090_REG_3A_MIX_RCV_RIGHT
 */
#define M98090_LINMOD_MASK		(1<<7)
#define M98090_LINMOD_SHIFT		7
#define M98090_LINMOD_WIDTH		1
#define M98090_MIXRCVR_MIC2_MASK	(1<<5)
#define M98090_MIXRCVR_MIC2_SHIFT	5
#define M98090_MIXRCVR_MIC2_WIDTH	1
#define M98090_MIXRCVR_MIC1_MASK	(1<<4)
#define M98090_MIXRCVR_MIC1_SHIFT	4
#define M98090_MIXRCVR_MIC1_WIDTH	1
#define M98090_MIXRCVR_LINEB_MASK	(1<<3)
#define M98090_MIXRCVR_LINEB_SHIFT	3
#define M98090_MIXRCVR_LINEB_WIDTH	1
#define M98090_MIXRCVR_LINEA_MASK	(1<<2)
#define M98090_MIXRCVR_LINEA_SHIFT	2
#define M98090_MIXRCVR_LINEA_WIDTH	1
#define M98090_MIXRCVR_DACR_MASK	(1<<1)
#define M98090_MIXRCVR_DACR_SHIFT	1
#define M98090_MIXRCVR_DACR_WIDTH	1
#define M98090_MIXRCVR_DACL_MASK	(1<<0)
#define M98090_MIXRCVR_DACL_SHIFT	0
#define M98090_MIXRCVR_DACL_WIDTH	1
#define M98090_MIXRCVR_MASK		(63<<0)
#define M98090_MIXRCVR_SHIFT		0
#define M98090_MIXRCVR_WIDTH		6

/*
 * M98090_REG_3B_MIX_RCV_CNTL_RIGHT
 */
#define M98090_MIXRCVRG_MASK		(3<<0)
#define M98090_MIXRCVRG_SHIFT		0
#define M98090_MIXRCVRG_WIDTH		2
#define M98090_MIXRCVRG_NUM		(1<<M98090_MIXRCVRG_WIDTH)

/*
 * M98090_REG_3C_LVL_RCV_RIGHT
 */
#define M98090_RCVRM_MASK		(1<<7)
#define M98090_RCVRM_SHIFT		7
#define M98090_RCVRM_WIDTH		1
#define M98090_RCVRVOL_MASK		(31<<0)
#define M98090_RCVRVOL_SHIFT		0
#define M98090_RCVRVOL_WIDTH		5
#define M98090_RCVRVOL_NUM		(1<<M98090_RCVRVOL_WIDTH)

/*
 * M98090_REG_3D_CFG_JACK
 */
#define M98090_JDETEN_MASK		(1<<7)
#define M98090_JDETEN_SHIFT		7
#define M98090_JDETEN_WIDTH		1
#define M98090_JDWK_MASK		(1<<6)
#define M98090_JDWK_SHIFT		6
#define M98090_JDWK_WIDTH		1
#define M98090_JDEB_MASK		(3<<0)
#define M98090_JDEB_SHIFT		0
#define M98090_JDEB_WIDTH		2
#define M98090_JDEB_25MS		(0<<0)
#define M98090_JDEB_50MS		(1<<0)
#define M98090_JDEB_100MS		(2<<0)
#define M98090_JDEB_200MS		(3<<0)

/*
 * M98090_REG_3E_PWR_EN_IN
 */
#define M98090_PWR_MBEN_MASK		(1<<4)
#define M98090_PWR_MBEN_SHIFT		4
#define M98090_PWR_MBEN_WIDTH		1
#define M98090_PWR_LINEAEN_MASK		(1<<3)
#define M98090_PWR_LINEAEN_SHIFT	3
#define M98090_PWR_LINEAEN_WIDTH	1
#define M98090_PWR_LINEBEN_MASK		(1<<2)
#define M98090_PWR_LINEBEN_SHIFT	2
#define M98090_PWR_LINEBEN_WIDTH	1
#define M98090_PWR_ADREN_MASK		(1<<1)
#define M98090_PWR_ADREN_SHIFT		1
#define M98090_PWR_ADREN_WIDTH		1
#define M98090_PWR_ADLEN_MASK		(1<<0)
#define M98090_PWR_ADLEN_SHIFT		0
#define M98090_PWR_ADLEN_WIDTH		1

/*
 * M98090_REG_3F_PWR_EN_OUT
 */
#define M98090_PWR_HPREN_MASK		(1<<7)
#define M98090_PWR_HPREN_SHIFT		7
#define M98090_PWR_HPREN_WIDTH		1
#define M98090_PWR_HPLEN_MASK		(1<<6)
#define M98090_PWR_HPLEN_SHIFT		6
#define M98090_PWR_HPLEN_WIDTH		1
#define M98090_PWR_SPREN_MASK		(1<<5)
#define M98090_PWR_SPREN_SHIFT		5
#define M98090_PWR_SPREN_WIDTH		1
#define M98090_PWR_SPLEN_MASK		(1<<4)
#define M98090_PWR_SPLEN_SHIFT		4
#define M98090_PWR_SPLEN_WIDTH		1
#define M98090_PWR_RCVLEN_MASK		(1<<3)
#define M98090_PWR_RCVLEN_SHIFT		3
#define M98090_PWR_RCVLEN_WIDTH		1
#define M98090_PWR_RCVREN_MASK		(1<<2)
#define M98090_PWR_RCVREN_SHIFT		2
#define M98090_PWR_RCVREN_WIDTH		1
#define M98090_PWR_DAREN_MASK		(1<<1)
#define M98090_PWR_DAREN_SHIFT		1
#define M98090_PWR_DAREN_WIDTH		1
#define M98090_PWR_DALEN_MASK		(1<<0)
#define M98090_PWR_DALEN_SHIFT		0
#define M98090_PWR_DALEN_WIDTH		1

/*
 * M98090_REG_40_CFG_LVL
 */
#define M98090_ZDENN_MASK		(1<<2)
#define M98090_ZDENN_SHIFT		2
#define M98090_ZDENN_WIDTH		1
#define M98090_VS2ENN_MASK		(1<<1)
#define M98090_VS2ENN_SHIFT		1
#define M98090_VS2ENN_WIDTH		1
#define M98090_VSENN_MASK		(1<<0)
#define M98090_VSENN_SHIFT		0
#define M98090_VSENN_WIDTH		1

/*
 * M98090_REG_41_DSP_EQ_EN
 */
#define M98090_DMIC34BQEN_MASK		(1<<4)
#define M98090_DMIC34BQEN_SHIFT		4
#define M98090_DMIC34BQEN_WIDTH		1
#define M98090_DMIC34BQEN_NUM		(1<<M98090_DMIC34BQEN_WIDTH)
#define M98090_ADCBQEN_MASK		(1<<3)
#define M98090_ADCBQEN_SHIFT		3
#define M98090_ADCBQEN_WIDTH		1
#define M98090_ADCBQEN_NUM		(1<<M98090_ADCBQEN_WIDTH)
#define M98090_EQ3BANDEN_MASK		(1<<2)
#define M98090_EQ3BANDEN_SHIFT		2
#define M98090_EQ3BANDEN_WIDTH		1
#define M98090_EQ3BANDEN_NUM		(1<<M98090_EQ3BANDEN_WIDTH)
#define M98090_EQ5BANDEN_MASK		(1<<1)
#define M98090_EQ5BANDEN_SHIFT		1
#define M98090_EQ5BANDEN_WIDTH		1
#define M98090_EQ5BANDEN_NUM		(1<<M98090_EQ5BANDEN_WIDTH)
#define M98090_EQ7BANDEN_MASK		(1<<0)
#define M98090_EQ7BANDEN_SHIFT		0
#define M98090_EQ7BANDEN_WIDTH		1
#define M98090_EQ7BANDEN_NUM		(1<<M98090_EQ7BANDEN_WIDTH)

/*
 * M98090_REG_42_BIAS_CNTL
 */
#define M98090_VCM_MODE_MASK		(1<<0)
#define M98090_VCM_MODE_SHIFT		0
#define M98090_VCM_MODE_WIDTH		1
#define M98090_VCM_MODE_NUM		(1<<M98090_VCM_MODE_WIDTH)

/*
 * M98090_REG_43_DAC_CFG
 */
#define M98090_DAC_PERFMODE_MASK	(1<<1)
#define M98090_DAC_PERFMODE_SHIFT	1
#define M98090_DAC_PERFMODE_WIDTH	1
#define M98090_DAC_PERFMODE_NUM		(1<<M98090_DAC_PERFMODE_WIDTH)
#define M98090_DACHP_MASK		(1<<0)
#define M98090_DACHP_SHIFT		0
#define M98090_DACHP_WIDTH		1
#define M98090_DACHP_NUM		(1<<M98090_DACHP_WIDTH)

/*
 * M98090_REG_44_ADC_CFG
 */
#define M98090_ADC_OSR128_MASK		(1<<2)
#define M98090_ADC_OSR128_SHIFT		2
#define M98090_ADC_OSR128_WIDTH		1
#define M98090_ADCDITHER_MASK		(1<<1)
#define M98090_ADCDITHER_SHIFT		1
#define M98090_ADCDITHER_WIDTH		1
#define M98090_ADCDITHER_NUM		(1<<M98090_ADCDITHER_WIDTH)
#define M98090_ADCHP_MASK		(1<<0)
#define M98090_ADCHP_SHIFT		0
#define M98090_ADCHP_WIDTH		1
#define M98090_ADCHP_NUM		(1<<M98090_ADCHP_WIDTH)

/*
 * M98090_REG_45_PWR_SYS
 */
#define M98090_PWR_SHDNN_MASK		(1<<7)
#define M98090_PWR_SHDNN_SHIFT		7
#define M98090_PWR_SHDNN_WIDTH		1

/*
 * M98090_REG_46_EQ_BASE
 */
#define M98090_B0_1_HI_MASK		(255<<0)
#define M98090_B0_1_HI_SHIFT		0
#define M98090_B0_1_HI_WIDTH		8
#define M98090_B0_1_MID_MASK		(255<<0)
#define M98090_B0_1_MID_SHIFT		0
#define M98090_B0_1_MID_WIDTH		8
#define M98090_B0_1_LO_MASK		(255<<0)
#define M98090_B0_1_LO_SHIFT		0
#define M98090_B0_1_LO_WIDTH		8
#define M98090_B1_1_HI_MASK		(255<<0)
#define M98090_B1_1_HI_SHIFT		0
#define M98090_B1_1_HI_WIDTH		8
#define M98090_B1_1_MID_MASK		(255<<0)
#define M98090_B1_1_MID_SHIFT		0
#define M98090_B1_1_MID_WIDTH		8
#define M98090_B1_1_LO_MASK		(255<<0)
#define M98090_B1_1_LO_SHIFT		0
#define M98090_B1_1_LO_WIDTH		8
#define M98090_B2_1_HI_MASK		(255<<0)
#define M98090_B2_1_HI_SHIFT		0
#define M98090_B2_1_HI_WIDTH		8
#define M98090_B2_1_MID_MASK		(255<<0)
#define M98090_B2_1_MID_SHIFT		0
#define M98090_B2_1_MID_WIDTH		8
#define M98090_B2_1_LO_MASK		(255<<0)
#define M98090_B2_1_LO_SHIFT		0
#define M98090_B2_1_LO_WIDTH		8
#define M98090_A1_1_HI_MASK		(255<<0)
#define M98090_A1_1_HI_SHIFT		0
#define M98090_A1_1_HI_WIDTH		8
#define M98090_A1_1_MID_MASK		(255<<0)
#define M98090_A1_1_MID_SHIFT		0
#define M98090_A1_1_MID_WIDTH		8
#define M98090_A1_1_LO_MASK		(255<<0)
#define M98090_A1_1_LO_SHIFT		0
#define M98090_A1_1_LO_WIDTH		8
#define M98090_A2_1_HI_MASK		(255<<0)
#define M98090_A2_1_HI_SHIFT		0
#define M98090_A2_1_HI_WIDTH		8
#define M98090_A2_1_MID_MASK		(255<<0)
#define M98090_A2_1_MID_SHIFT		0
#define M98090_A2_1_MID_WIDTH		8
#define M98090_A2_1_LO_MASK		(255<<0)
#define M98090_A2_1_LO_SHIFT		0
#define M98090_A2_1_LO_WIDTH		8

#define M98090_COEFS_PER_BAND		5
#define M98090_COEFS_BLK_SZ		(M98090_COEFS_PER_BAND * 3)
#define M98090_COEFS_MAX_SZ		(M98090_COEFS_BLK_SZ * 7)

/*
 * M98090_REG_AF_BIQUAD_BASE
 */
#define M98090_ADC_B0_HI_MASK		(255<<0)
#define M98090_ADC_B0_HI_SHIFT		0
#define M98090_ADC_B0_HI_WIDTH		8
#define M98090_ADC_B0_MID_MASK		(255<<0)
#define M98090_ADC_B0_MID_SHIFT		0
#define M98090_ADC_B0_MID_WIDTH		8
#define M98090_ADC_B0_LO_MASK		(255<<0)
#define M98090_ADC_B0_LO_SHIFT		0
#define M98090_ADC_B0_LO_WIDTH		8
#define M98090_ADC_B1_HI_MASK		(255<<0)
#define M98090_ADC_B1_HI_SHIFT		0
#define M98090_ADC_B1_HI_WIDTH		8
#define M98090_ADC_B1_MID_MASK		(255<<0)
#define M98090_ADC_B1_MID_SHIFT		0
#define M98090_ADC_B1_MID_WIDTH		8
#define M98090_ADC_B1_LO_MASK		(255<<0)
#define M98090_ADC_B1_LO_SHIFT		0
#define M98090_ADC_B1_LO_WIDTH		8
#define M98090_ADC_B2_HI_MASK		(255<<0)
#define M98090_ADC_B2_HI_SHIFT		0
#define M98090_ADC_B2_HI_WIDTH		8
#define M98090_ADC_B2_MID_MASK		(255<<0)
#define M98090_ADC_B2_MID_SHIFT		0
#define M98090_ADC_B2_MID_WIDTH		8
#define M98090_ADC_B2_LO_MASK		(255<<0)
#define M98090_ADC_B2_LO_SHIFT		0
#define M98090_ADC_B2_LO_WIDTH		8
#define M98090_ADC_A1_HI_MASK		(255<<0)
#define M98090_ADC_A1_HI_SHIFT		0
#define M98090_ADC_A1_HI_WIDTH		8
#define M98090_ADC_A1_MID_MASK		(255<<0)
#define M98090_ADC_A1_MID_SHIFT		0
#define M98090_ADC_A1_MID_WIDTH		8
#define M98090_ADC_A1_LO_MASK		(255<<0)
#define M98090_ADC_A1_LO_SHIFT		0
#define M98090_ADC_A1_LO_WIDTH		8
#define M98090_ADC_A2_HI_MASK		(255<<0)
#define M98090_ADC_A2_HI_SHIFT		0
#define M98090_ADC_A2_HI_WIDTH		8
#define M98090_ADC_A2_MID_MASK		(255<<0)
#define M98090_ADC_A2_MID_SHIFT		0
#define M98090_ADC_A2_MID_WIDTH		8
#define M98090_ADC_A2_LO_MASK		(255<<0)
#define M98090_ADC_A2_LO_SHIFT		0
#define M98090_ADC_A2_LO_WIDTH		8

/*
 * M98090_REG_BE_DMIC3_VOLUME
 */
#define M98090_DMIC_AV3G_MASK		(7<<4)
#define M98090_DMIC_AV3G_SHIFT		4
#define M98090_DMIC_AV3G_WIDTH		3
#define M98090_DMIC_AV3G_NUM		(1<<M98090_DMIC_AV3G_WIDTH)
#define M98090_DMIC_AV3_MASK		(15<<0)
#define M98090_DMIC_AV3_SHIFT		0
#define M98090_DMIC_AV3_WIDTH		4
#define M98090_DMIC_AV3_NUM		(1<<M98090_DMIC_AV3_WIDTH)

/*
 * M98090_REG_BF_DMIC4_VOLUME
 */
#define M98090_DMIC_AV4G_MASK		(7<<4)
#define M98090_DMIC_AV4G_SHIFT		4
#define M98090_DMIC_AV4G_WIDTH		3
#define M98090_DMIC_AV4G_NUM		(1<<M98090_DMIC_AV4G_WIDTH)
#define M98090_DMIC_AV4_MASK		(15<<0)
#define M98090_DMIC_AV4_SHIFT		0
#define M98090_DMIC_AV4_WIDTH		4
#define M98090_DMIC_AV4_NUM		(1<<M98090_DMIC_AV4_WIDTH)

/*
 * M98090_REG_C0_DMIC34_BQ_PREATTEN
 */
#define M98090_AV34BQ_MASK		(15<<0)
#define M98090_AV34BQ_SHIFT		0
#define M98090_AV34BQ_WIDTH		4
#define M98090_AV34BQ_NUM		(1<<M98090_AV34BQ_WIDTH)

/*
 * M98090_REG_C1_RECORD_TDM_SLOT
 */
#define M98090_DAI_TDM_SLOTADCL_MASK	(3<<6)
#define M98090_DAI_TDM_SLOTADCL_SHIFT	6
#define M98090_DAI_TDM_SLOTADCL_WIDTH	2
#define M98090_DAI_TDM_SLOTADCL_NUM	(1<<M98090_DAI_TDM_SLOTADCL_WIDTH)
#define M98090_DAI_TDM_SLOTADCR_MASK	(3<<4)
#define M98090_DAI_TDM_SLOTADCR_SHIFT	4
#define M98090_DAI_TDM_SLOTADCR_WIDTH	2
#define M98090_DAI_TDM_SLOTADCR_NUM	(1<<M98090_DAI_TDM_SLOTADCR_WIDTH)
#define M98090_DAI_TDM_SLOTDMIC3_MASK	(3<<2)
#define M98090_DAI_TDM_SLOTDMIC3_SHIFT	2
#define M98090_DAI_TDM_SLOTDMIC3_WIDTH	2
#define M98090_DAI_TDM_SLOTDMIC3_NUM	(1<<M98090_DAI_TDM_SLOTDMIC3_WIDTH)
#define M98090_DAI_TDM_SLOTDMIC4_MASK	(3<<0)
#define M98090_DAI_TDM_SLOTDMIC4_SHIFT	0
#define M98090_DAI_TDM_SLOTDMIC4_WIDTH	2
#define M98090_DAI_TDM_SLOTDMIC4_NUM	(1<<M98090_DAI_TDM_SLOTDMIC4_WIDTH)

/*
 * M98090_REG_C2_SAMPLE_RATE
 */
#define M98090_DMIC34_ZEROPAD_MASK	(1<<4)
#define M98090_DMIC34_ZEROPAD_SHIFT	4
#define M98090_DMIC34_ZEROPAD_WIDTH	1
#define M98090_DMIC34_ZEROPAD_NUM	(1<<M98090_DIGMIC4_WIDTH)
#define M98090_DMIC34_SRDIV_MASK	(7<<0)
#define M98090_DMIC34_SRDIV_SHIFT	0
#define M98090_DMIC34_SRDIV_WIDTH	3

/*
 * M98090_REG_C3_DMIC34_BIQUAD_BASE
 */
#define M98090_DMIC34_B0_HI_MASK	(255<<0)
#define M98090_DMIC34_B0_HI_SHIFT	0
#define M98090_DMIC34_B0_HI_WIDTH	8
#define M98090_DMIC34_B0_MID_MASK	(255<<0)
#define M98090_DMIC34_B0_MID_SHIFT	0
#define M98090_DMIC34_B0_MID_WIDTH	8
#define M98090_DMIC34_B0_LO_MASK	(255<<0)
#define M98090_DMIC34_B0_LO_SHIFT	0
#define M98090_DMIC34_B0_LO_WIDTH	8
#define M98090_DMIC34_B1_HI_MASK	(255<<0)
#define M98090_DMIC34_B1_HI_SHIFT	0
#define M98090_DMIC34_B1_HI_WIDTH	8
#define M98090_DMIC34_B1_MID_MASK	(255<<0)
#define M98090_DMIC34_B1_MID_SHIFT	0
#define M98090_DMIC34_B1_MID_WIDTH	8
#define M98090_DMIC34_B1_LO_MASK	(255<<0)
#define M98090_DMIC34_B1_LO_SHIFT	0
#define M98090_DMIC34_B1_LO_WIDTH	8
#define M98090_DMIC34_B2_HI_MASK	(255<<0)
#define M98090_DMIC34_B2_HI_SHIFT	0
#define M98090_DMIC34_B2_HI_WIDTH	8
#define M98090_DMIC34_B2_MID_MASK	(255<<0)
#define M98090_DMIC34_B2_MID_SHIFT	0
#define M98090_DMIC34_B2_MID_WIDTH	8
#define M98090_DMIC34_B2_LO_MASK	(255<<0)
#define M98090_DMIC34_B2_LO_SHIFT	0
#define M98090_DMIC34_B2_LO_WIDTH	8
#define M98090_DMIC34_A1_HI_MASK	(255<<0)
#define M98090_DMIC34_A1_HI_SHIFT	0
#define M98090_DMIC34_A1_HI_WIDTH	8
#define M98090_DMIC34_A1_MID_MASK	(255<<0)
#define M98090_DMIC34_A1_MID_SHIFT	0
#define M98090_DMIC34_A1_MID_WIDTH	8
#define M98090_DMIC34_A1_LO_MASK	(255<<0)
#define M98090_DMIC34_A1_LO_SHIFT	0
#define M98090_DMIC34_A1_LO_WIDTH	8
#define M98090_DMIC34_A2_HI_MASK	(255<<0)
#define M98090_DMIC34_A2_HI_SHIFT	0
#define M98090_DMIC34_A2_HI_WIDTH	8
#define M98090_DMIC34_A2_MID_MASK	(255<<0)
#define M98090_DMIC34_A2_MID_SHIFT	0
#define M98090_DMIC34_A2_MID_WIDTH	8
#define M98090_DMIC34_A2_LO_MASK	(255<<0)
#define M98090_DMIC34_A2_LO_SHIFT	0
#define M98090_DMIC34_A2_LO_WIDTH	8

#define M98090_JACK_STATE_NO_HEADSET	0
#define M98090_JACK_STATE_NO_HEADSET_2	1
#define M98090_JACK_STATE_HEADPHONE	2
#define M98090_JACK_STATE_HEADSET	3

/*
 * M98090_REG_FF_REV_ID
 */
#define M98090_REVID_MASK		(255<<0)
#define M98090_REVID_SHIFT		0
#define M98090_REVID_WIDTH		8
#define M98090_REVID_NUM		(1<<M98090_REVID_WIDTH)

#define M98090_BYTE1(w) ((w >> 8) & 0xff)
#define M98090_BYTE0(w) (w & 0xff)

/* Silicon revision number */
#define M98090_REVA			0x40
#define M98091_REVA			0x50

enum max98090_type {
	MAX98090,
	MAX98091,
};

struct max98090_cdata {
	unsigned int rate;
	unsigned int fmt;
	int eq_sel;
	int eq_num_bands;
	int bq_sel;
	int dmic34bq_sel;
};

struct max98090_priv {
	struct snd_soc_codec *codec;
	enum max98090_type devtype;
	void *control_data;
	struct max98090_pdata *pdata;
	unsigned int sysclk;
	unsigned int bclk;
	unsigned int lrclk;
	struct max98090_cdata dai[1];
	int jack_state;
	struct delayed_work jack_work;
	struct snd_soc_jack *jack;
	unsigned int dai_fmt;
	int tdm_slots;
	int tdm_width;
	const char **eq_texts;
	const char **bq_texts;
	const char **dmic34bq_texts;
	struct soc_enum eq_enum;
	struct soc_enum bq_enum;
	struct soc_enum dmic34bq_enum;
	int eq_textcnt;
	int bq_textcnt;
	int dmic34bq_textcnt;
	u8 lin_state;
	unsigned int mic1pre;
	unsigned int mic2pre;
	unsigned int extmic_mux;
	unsigned int sidetone;
	int irq;
};

#endif
