/*
 * max97236.h -- MAX97236 Jack Detection Driver
 *
 * Copyright 2012-2013 Maxim Integrated Products
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef _MAX97236_H
#define _MAX97236_H

/* Controls detection mode, either DETECT0 or DETECT1 */
#undef MAX97236_AUTOMODE1_JACK_DETECTION

/* Define depending on the type of switch in the jack receptacle */
#define M97236_JACK_SWITCH_NORMALLY_CLOSED

/*
 * Driver major.minor.build number
 */
#define MAX97236_REVISION			"0.00.0581"

/* EXTCLK frequency default value */
#define EXTCLK_FREQUENCY			19200000
#define EXTCLK_FREQUENCY_SUSPEND	19200000

/*
 * MAX97236 Register Definitions
 */

#define M97236_REG_00_STATUS1				0x00
#define M97236_REG_01_STATUS2				0x01
#define M97236_REG_02_STATUS3				0x02
#define M97236_REG_04_IRQ_MASK1				0x04
#define M97236_REG_05_IRQ_MASK2				0x05
#define M97236_REG_07_LEFT_VOLUME			0x07
#define M97236_REG_08_RIGHT_VOLUME			0x08
#define M97236_REG_09_MICROPHONE			0x09
#define M97236_REG_0B_REV_ID				0x0B
#define M97236_REG_12_KEYSCAN_CLK_DIV_HI	0x12
#define M97236_REG_13_KEYSCAN_CLK_DIV_LO	0x13
#define M97236_REG_14_KEYSCAN_CLK_DIV_ADC	0x14
#define M97236_REG_15_KEYSCAN_DEBOUNCE		0x15
#define M97236_REG_16_KEYSCAN_DELAY			0x16
#define M97236_REG_17_PASSIVE_MBH_KEYSCAN_DATA	0x17
#define M97236_REG_18_DC_TEST_SLEW_CONTROL	0x18
#define M97236_REG_19_STATE_FORCING			0x19
#define M97236_REG_1A_AC_TEST_CONTROL		0x1A
#define M97236_REG_1D_ENABLE_1				0x1D
#define M97236_REG_1E_ENABLE_2				0x1E

#define M97236_REG_1F_TEST_ENABLE_1			0x1F
#define M97236_REG_20_TEST_ENABLE_2			0x20
#define M97236_REG_21_TEST_DATA_1			0x21
#define M97236_REG_23_TEST_DATA_3			0x23

#define MAX97236_MAX_REGISTER				0x23


/* MAX97236 Register Bit Fields */

/*
 * M97236_REG_00_STATUS1
 */
#define M97236_JKIN_MASK		(1<<7)
#define M97236_JKIN_SHIFT		7
#define M97236_JKIN_WIDTH		1
#define M97236_JKIN_NUM			(1<<M97236_JKIN_WIDTH)
#define M97236_DDONE_MASK		(1<<6)
#define M97236_DDONE_SHIFT		6
#define M97236_DDONE_WIDTH		1
#define M97236_DDONE_NUM		(1<<M97236_DDONE_WIDTH)
#define M97236_VOL_MASK			(1<<5)
#define M97236_VOL_SHIFT		5
#define M97236_VOL_WIDTH		1
#define M97236_VOL_NUM			(1<<M97236_VOL_WIDTH)
#define M97236_VID_IN_MASK		(1<<4)
#define M97236_VID_IN_SHIFT		4
#define M97236_VID_IN_WIDTH		1
#define M97236_VID_IN_NUM		(1<<M97236_VID_IN_WIDTH)
#define M97236_MIC_IN_MASK		(1<<3)
#define M97236_MIC_IN_SHIFT		3
#define M97236_MIC_IN_WIDTH		1
#define M97236_MIC_IN_NUM		(1<<M97236_MIC_IN_WIDTH)
#define M97236_JACKSW_MASK		(1<<2)
#define M97236_JACKSW_SHIFT		2
#define M97236_JACKSW_WIDTH		1
#define M97236_JACKSW_NUM		(1<<M97236_JACKSW_WIDTH)
#define M97236_MCSW_MASK		(1<<1)
#define M97236_MCSW_SHIFT		1
#define M97236_MCSW_WIDTH		1
#define M97236_MCSW_NUM			(1<<M97236_MCSW_WIDTH)
#define M97236_MBH_MASK			(1<<0)
#define M97236_MBH_SHIFT		0
#define M97236_MBH_WIDTH		1
#define M97236_MBH_NUM			(1<<M97236_MBH_WIDTH)


/*
 * M97236_REG_01_STATUS2
 */
#define M97236_LINE_L_MASK		(1<<7)
#define M97236_LINE_L_SHIFT		7
#define M97236_LINE_L_WIDTH		1
#define M97236_LINE_L_NUM		(1<<M97236_LINE_L_WIDTH)
#define M97236_LINE_R_MASK		(1<<6)
#define M97236_LINE_R_SHIFT		6
#define M97236_LINE_R_WIDTH		1
#define M97236_LINE_R_NUM		(1<<M97236_LINE_R_WIDTH)
#define M97236_HP_L_MASK		(1<<5)
#define M97236_HP_L_SHIFT		5
#define M97236_HP_L_WIDTH		1
#define M97236_HP_L_NUM			(1<<M97236_HP_L_WIDTH)
#define M97236_HP_R_MASK		(1<<4)
#define M97236_HP_R_SHIFT		4
#define M97236_HP_R_WIDTH		1
#define M97236_HP_R_NUM			(1<<M97236_HP_R_WIDTH)
#define M97236_JACKSWINC_MASK		(1<<3)
#define M97236_JACKSWINC_SHIFT		3
#define M97236_JACKSWINC_WIDTH		1
#define M97236_JACKSWINC_NUM		(1<<M97236_JACKSWINC_WIDTH)
#define M97236_KEY_MASK			(1<<2)
#define M97236_KEY_SHIFT		2
#define M97236_KEY_WIDTH		1
#define M97236_KEY_NUM			(1<<M97236_JACKSW_WIDTH)


/*
 * M97236_REG_02_STATUS3
 */
#define M97236_GND_MASK			(3<<0)
#define M97236_GND_SHIFT		0
#define M97236_GND_WIDTH		2
#define M97236_GND_NUM			(1<<M97236_GND_WIDTH)


/*
 * M97236_REG_04_IRQ_MASK1
 */
#define M97236_IJKIN_MASK		(1<<7)
#define M97236_IJKIN_SHIFT		7
#define M97236_IJKIN_WIDTH		1
#define M97236_IJKIN_NUM		(1<<M97236_IJKIN_WIDTH)
#define M97236_IDDONE_MASK		(1<<6)
#define M97236_IDDONE_SHIFT		6
#define M97236_IDDONE_WIDTH		1
#define M97236_IDDONE_NUM		(1<<M97236_IDDONE_WIDTH)
#define M97236_IVOL_MASK		(1<<5)
#define M97236_IVOL_SHIFT		5
#define M97236_IVOL_WIDTH		1
#define M97236_IVOL_NUM			(1<<M97236_IVOL_WIDTH)
#define M97236_IVID_MASK		(1<<4)
#define M97236_IVID_SHIFT		4
#define M97236_IVID_WIDTH		1
#define M97236_IVID_NUM			(1<<M97236_IVID_WIDTH)
#define M97236_IMIC_MASK		(1<<3)
#define M97236_IMIC_SHIFT		3
#define M97236_IMIC_WIDTH		1
#define M97236_IMIC_NUM			(1<<M97236_IMIC_WIDTH)
#define M97236_IJACKSW_MASK		(1<<2)
#define M97236_IJACKSW_SHIFT		2
#define M97236_IJACKSW_WIDTH		1
#define M97236_IJACKSW_NUM		(1<<M97236_IJACKSW_WIDTH)
#define M97236_IMCSW_MASK		(1<<1)
#define M97236_IMCSW_SHIFT		1
#define M97236_IMCSW_WIDTH		1
#define M97236_IMCSW_NUM		(1<<M97236_IMCSW_WIDTH)
#define M97236_IMBH_MASK		(1<<0)
#define M97236_IMBH_SHIFT		0
#define M97236_IMBH_WIDTH		1
#define M97236_IMBH_NUM			(1<<M97236_IMBH_WIDTH)


/*
 * M97236_REG_05_IRQ_MASK2
 */
#define M97236_ILINE_L_MASK		(1<<7)
#define M97236_ILINE_L_SHIFT		7
#define M97236_ILINE_L_WIDTH		1
#define M97236_ILINE_L_NUM		(1<<M97236_ILINE_L_WIDTH)
#define M97236_ILINE_R_MASK		(1<<6)
#define M97236_ILINE_R_SHIFT		6
#define M97236_ILINE_R_WIDTH		1
#define M97236_ILINE_R_NUM		(1<<M97236_ILINE_R_WIDTH)
#define M97236_IHP_L_MASK			(1<<5)
#define M97236_IHP_L_SHIFT		5
#define M97236_IHP_L_WIDTH		1
#define M97236_IHP_L_NUM		(1<<M97236_IHP_L_WIDTH)
#define M97236_IHP_R_MASK		(1<<4)
#define M97236_IHP_R_SHIFT		4
#define M97236_IHP_R_WIDTH		1
#define M97236_IHP_R_NUM		(1<<M97236_IHP_R_WIDTH)
#define M97236_IJACKSWINC_MASK		(1<<3)
#define M97236_IJACKSWINC_SHIFT		3
#define M97236_IJACKSWINC_WIDTH		1
#define M97236_IJACKSWINC_NUM		(1<<M97236_IJACKSWINC_WIDTH)
#define M97236_IKEY_MASK		(1<<2)
#define M97236_IKEY_SHIFT		2
#define M97236_IKEY_WIDTH		1
#define M97236_IKEY_NUM			(1<<M97236_IKEY_WIDTH)


/*
 * M97236_REG_07_LEFT_VOLUME
 */
#define M97236_L_R_MASK			(1<<7)
#define M97236_L_R_SHIFT		7
#define M97236_L_R_WIDTH		1
#define M97236_L_R_NUM			(1<<M97236_L_R_WIDTH)
#define M97236_MUTEL_MASK		(1<<6)
#define M97236_MUTEL_SHIFT		6
#define M97236_MUTEL_WIDTH		1
#define M97236_MUTEL_NUM		(1<<M97236_MUTEL_WIDTH)
#define M97236_LVOL_MASK		(63<<0)
#define M97236_LVOL_SHIFT		0
#define M97236_LVOL_WIDTH		6
#define M97236_LVOL_NUM			(1<<M97236_LVOL_WIDTH)


/*
 * M97236_REG_08_RIGHT_VOLUME
 */
#define M97236_MUTER_MASK		(1<<6)
#define M97236_MUTER_SHIFT		6
#define M97236_MUTER_WIDTH		1
#define M97236_MUTER_NUM		(1<<M97236_MUTER_WIDTH)
#define M97236_RVOL_MASK		(63<<0)
#define M97236_RVOL_SHIFT		0
#define M97236_RVOL_WIDTH		6
#define M97236_RVOL_NUM			(1<<M97236_RVOL_WIDTH)


/*
 * M97236_REG_09_MICROPHONE
 */
#define M97236_GAIN_MASK		(1<<6)
#define M97236_GAIN_SHIFT		6
#define M97236_GAIN_WIDTH		1
#define M97236_GAIN_NUM			(1<<M97236_GAIN_WIDTH)
#define M97236_MICR_MASK		(7<<3)
#define M97236_MICR_SHIFT		3
#define M97236_MICR_WIDTH		3
#define M97236_MICR_NUM			(1<<M97236_MICR_WIDTH)
#define M97236_BIAS_MASK		(1<<2)
#define M97236_BIAS_SHIFT		2
#define M97236_BIAS_WIDTH		1
#define M97236_BIAS_NUM			(1<<M97236_BIAS_WIDTH)


/*
 * M97236_REG_0B_REV_ID
 */
#define M97236_ID_MASK			(15<<4)
#define M97236_ID_SHIFT			4
#define M97236_ID_WIDTH			4
#define M97236_ID_NUM			(1<<M97236_ID_WIDTH)


/*
 * M97236_REG_12_KEYSCAN_CLK_DIV_1
 */
#define M97236_KEY_DIV_HIGH_MASK	(255<<0)
#define M97236_KEY_DIV_HIGH_SHIFT	0
#define M97236_KEY_DIV_HIGH_WIDTH	8
#define M97236_KEY_DIV_HIGH_NUM		(1<<M97236_KEY_DIV_HIGH_WIDTH)


/*
 * M97236_REG_13_KEYSCAN_CLK_DIV_2
 */
#define M97236_KEY_DIV_LOW_MASK		(255<<0)
#define M97236_KEY_DIV_LOW_SHIFT	0
#define M97236_KEY_DIV_LOW_WIDTH	8
#define M97236_KEY_DIV_LOW_NUM		(1<<M97236_KEY_DIV_LOW_WIDTH)


/*
 * M97236_REG_14_KEYSCAN_CLK_DIV_ADC
 */
#define M97236_KEY_DIV_ADC_MASK		(255<<0)
#define M97236_KEY_DIV_ADC_SHIFT	0
#define M97236_KEY_DIV_ADC_WIDTH	8
#define M97236_KEY_DIV_ADC_NUM		(1<<M97236_KEY_DIV_ADC_WIDTH)


/*
 * M97236_REG_15_KEYSCAN_DEBOUNCE
 */
#define M97236_KEY_DEB_MASK		(255<<0)
#define M97236_KEY_DEB_SHIFT		0
#define M97236_KEY_DEB_WIDTH		8
#define M97236_KEY_DEB_NUM		(1<<M97236_KEY_DEB_WIDTH)


/*
 * M97236_REG_16_KEYSCAN_DELAY
 */
#define M97236_KEY_DEL_MASK		(255<<0)
#define M97236_KEY_DEL_SHIFT		0
#define M97236_KEY_DEL_WIDTH		8
#define M97236_KEY_DEL_NUM		(1<<M97236_KEY_DEL_WIDTH)


/*
 * M97236_REG_17_PASSIVE_MBH_KEYSCAN_DATA
 */
#define M97236_PRESS_MASK		(1<<7)
#define M97236_PRESS_SHIFT		7
#define M97236_PRESS_WIDTH		1
#define M97236_PRESS_NUM		(1<<M97236_PRESS_WIDTH)
#define M97236_RANGE_MASK		(1<<6)
#define M97236_RANGE_SHIFT		6
#define M97236_RANGE_WIDTH		1
#define M97236_RANGE_NUM		(1<<M97236_RANGE_WIDTH)
#define M97236_KEYDATA_MASK		(63<<0)
#define M97236_KEYDATA_SHIFT		0
#define M97236_KEYDATA_WIDTH		6
#define M97236_KEYDATA_NUM		(1<<M97236_KEYDATA_WIDTH)

#define	M97236_KEY_THRESH_0		47
#define	M97236_KEY_THRESH_1		99
#define	M97236_KEY_THRESH_2		128
#define	M97236_KEY_THRESH_3		128

/*
 * M97236_REG_18_DC_TEST_SLEW_CONTROL
 */
#define M97236_DC_SLEW_MASK		(255<<0)
#define M97236_DC_SLEW_SHIFT		0
#define M97236_DC_SLEW_WIDTH		8
#define M97236_DC_SLEW_NUM		(1<<M97236_DC_SLEW_WIDTH)
#define DEFAULT_TEST_SLEW_RATE	0x06

/*
 * M97236_REG_19_STATE_FORCING
 */
#define M97236_FORCEN_MASK		(1<<5)
#define M97236_FORCEN_SHIFT		5
#define M97236_FORCEN_WIDTH		1
#define M97236_FORCEN_NUM		(1<<M97236_FORCEN_WIDTH)
#define M97236_STATE_MASK		(31<<0)
#define M97236_STATE_SHIFT		0
#define M97236_STATE_WIDTH		5
#define M97236_STATE_NUM		(1<<M97236_STATE_WIDTH)

#define M97236_STATE_FLOAT		0x01
/*
 * M97236_REG_1A_AC_TEST_CONTROL
 */
#define M97236_AC_REPEAT_MASK		(3<<4)
#define M97236_AC_REPEAT_SHIFT		4
#define M97236_AC_REPEAT_WIDTH		2
#define M97236_AC_REPEAT_NUM		(1<<M97236_AC_REPEAT_WIDTH)
#define M97236_PULSE_WIDTH_MASK		(3<<2)
#define M97236_PULSE_WIDTH_SHIFT	2
#define M97236_PULSE_WIDTH_WIDTH	2
#define M97236_PULSE_WIDTH_NUM		(1<<M97236_PULSE_WIDTH_WIDTH)
#define M97236_PULSE_AMPLITUDE_MASK	(3<<0)
#define M97236_PULSE_AMPLITUDE_SHIFT	0
#define M97236_PULSE_AMPLITUDE_WIDTH	2
#define M97236_PULSE_AMPLITUDE_NUM	(1<<M97236_PULSE_AMPLITUDE_WIDTH)


/*
 * M97236_REG_1D_ENABLE_1
 */
#define M97236_SHDNN_MASK		(1<<7)
#define M97236_SHDNN_SHIFT		7
#define M97236_SHDNN_WIDTH		1
#define M97236_SHDNN_NUM		(1<<M97236_SHDNN_WIDTH)
#define M97236_RESET_MASK		(1<<6)
#define M97236_RESET_SHIFT		6
#define M97236_RESET_WIDTH		1
#define M97236_RESET_NUM		(1<<M97236_RESET_WIDTH)
#define M97236_MIC_BIAS_MASK		(1<<4)
#define M97236_MIC_BIAS_SHIFT		4
#define M97236_MIC_BIAS_WIDTH		1
#define M97236_MIC_BIAS_NUM		(1<<M97236_MIC_BIAS_WIDTH)
#define M97236_MIC_AMP_MASK		(1<<3)
#define M97236_MIC_AMP_SHIFT		3
#define M97236_MIC_AMP_WIDTH		1
#define M97236_MIC_AMP_NUM		(1<<M97236_MIC_AMP_WIDTH)
#define M97236_KS_MASK			(1<<2)
#define M97236_KS_SHIFT			2
#define M97236_KS_WIDTH			1
#define M97236_KS_NUM			(1<<M97236_KS_WIDTH)


/*
 * M97236_REG_1E_ENABLE_2
 */
#define M97236_LFTEN_MASK		(1<<7)
#define M97236_LFTEN_SHIFT		7
#define M97236_LFTEN_WIDTH		1
#define M97236_LFTEN_NUM		(1<<M97236_LFTEN_WIDTH)
#define M97236_RGHEN_MASK		(1<<6)
#define M97236_RGHEN_SHIFT		6
#define M97236_RGHEN_WIDTH		1
#define M97236_RGHEN_NUM		(1<<M97236_RGHEN_WIDTH)
#define M97236_VSENN_MASK		(1<<5)
#define M97236_VSENN_SHIFT		5
#define M97236_VSENN_WIDTH		1
#define M97236_VSENN_NUM		(1<<M97236_VSENN_WIDTH)
#define M97236_ZDENN_MASK		(1<<4)
#define M97236_ZDENN_SHIFT		4
#define M97236_ZDENN_WIDTH		1
#define M97236_ZDENN_NUM		(1<<M97236_ZDENN_WIDTH)
#define M97236_FAST_MASK		(1<<3)
#define M97236_FAST_SHIFT		3
#define M97236_FAST_WIDTH		1
#define M97236_FAST_NUM			(1<<M97236_FAST_WIDTH)
#define M97236_THRH_MASK		(1<<2)
#define M97236_THRH_SHIFT		2
#define M97236_THRH_WIDTH		1
#define M97236_THRH_NUM			(1<<M97236_THRH_WIDTH)
#define M97236_AUTO_MASK		(3<<0)
#define M97236_AUTO_SHIFT		0
#define M97236_AUTO_WIDTH		2
#define M97236_AUTO_NUM			(1<<M97236_AUTO_WIDTH)
#define M97236_AUTO_MODE_0		0
#define M97236_AUTO_MODE_1		1
#define M97236_AUTO_MODE_2		2

#define M97236_JACK_STATE_NONE	    0
#define M97236_JACK_STATE_UNKNOWN	0x00

#define M97236_DEFAULT_JACK_DETECT_DELAY		250
#define M97236_TEST1_DEFAULT_RETRIES			10
#define M97236_TEST2_DEFAULT_RETRIES			5

#define M97236_BYTE1(w) ((w >> 8) & 0xff)
#define M97236_BYTE0(w) (w & 0xff)

/* Silicon revision number */
#define M97236_REVA			0x09

enum max97236_type {
	MAX97036,
	MAX97236,
};

struct max97236_cdata {
};

struct max97236_priv {
	struct regmap *regmap;
	struct snd_soc_codec *codec;
	enum max97236_type devtype;
	void *control_data;
	struct max97236_pdata *pdata;
	struct max97236_cdata dai[1];
	int irq;
	int ignore_int;
	int jack_state;
	struct delayed_work jack_work;
	struct snd_soc_jack *jack;
	unsigned int dai_fmt;
	unsigned int status0;
};

int max97236_mic_detect(struct snd_soc_codec *codec,
	struct snd_soc_jack *jack);

#endif
