/*
 *  Silicon Labs C2 port Linux support
 *
 *  Copyright (c) 2007 Rodolfo Giometti <giometti@linux.it>
 *  Copyright (c) 2007 Eurotech S.p.A. <info@eurotech.it>
 *  Copyright (c) 2013, NVIDIA CORPORATION.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation
 */

#include <linux/kmemcheck.h>

#define C2PORT_NAME_LEN			32

struct device;

/*
 * C2 port basic structs
 */

/* Main struct */
struct c2port_ops;
struct c2port_device {
	kmemcheck_bitfield_begin(flags);
	unsigned int access:1;
	unsigned int flash_access:1;
	kmemcheck_bitfield_end(flags);

	int id;
	char name[C2PORT_NAME_LEN];
	struct c2port_ops *ops;
	struct mutex mutex;		/* prevent races during read/write */

	struct device *dev;

	void *private_data;
};

/* Basic operations */
struct c2port_ops {
	/* Flash layout */
	unsigned short block_size;	/* flash block size in bytes */
	unsigned short blocks_num;	/* flash blocks number */
	/* INTERNAL RAM layout */
	unsigned short ram_size;
	/* SFR layout */
	unsigned short sfr_size;
	/* XRAM layout */
	unsigned short xram_size;

	/* Enable or disable the access to C2 port */
	void (*access)(struct c2port_device *dev, int status);

	/* Set C2D data line as input/output */
	void (*c2d_dir)(struct c2port_device *dev, int dir);

	/* Read/write C2D data line */
	int (*c2d_get)(struct c2port_device *dev);
	void (*c2d_set)(struct c2port_device *dev, int status);

	/* Write C2CK clock line */
	void (*c2ck_set)(struct c2port_device *dev, int status);
};

/*
 * Exported functions
 */

extern struct c2port_device *c2port_device_register(char *name,
					struct c2port_ops *ops, void *devdata);
extern void c2port_device_unregister(struct c2port_device *dev);
