#include <linux/init.h>

#ifndef __A2220_FW_H_
#define __A2220_FW_H_

/* eS305B HPT  */
#ifdef CONFIG_USA_MODEL_SGH_I717
unsigned char hpt_init_macro[] = {
	0x80, 0x0C, 0x0A, 0x07, 0x80, 0x0D, 0x00, 0x01,
/* 0x800C:SetDeviceParmID, 0x0A:PCM0, 0x07:PCM Audio Port Mode,
 * 0x800D:SetDeviceParm, 0x0001:I2S */
	0x80, 0x0C, 0x0B, 0x07, 0x80, 0x0D, 0x00, 0x01,
/* 0x800C:SetDeviceParmID, 0x0B:PCM1, 0x07:PCM Audio Port Mode,
 * 0x800D:SetDeviceParm, 0x0001:I2S */
	0x80, 0x0C, 0x0C, 0x07, 0x80, 0x0D, 0x00, 0x01,
/* 0x800C:SetDeviceParmID, 0x0C:PCM2, 0x07:PCM Audio Port Mode,
 * 0x800D:SetDeviceParm, 0x0001:I2S */
	0x80, 0x0C, 0x0D, 0x07, 0x80, 0x0D, 0x00, 0x01,
/* 0x800C:SetDeviceParmID, 0x0D:PCM3, 0x07:PCM Audio Port Mode,
 * 0x800D:SetDeviceParm, 0x0001:I2S */
	0x80, 0x0C, 0x0A, 0x03, 0x80, 0x0D, 0x00, 0x01,
/* 0x800C:SetDeviceParmID, 0x0A:PCM0, 0x03:PCM DelFromFsRx,
 * 0x800D:SetDeviceParm, 0x0001:(1 clock) */
	0x80, 0x0C, 0x0B, 0x03, 0x80, 0x0D, 0x00, 0x01,
/* 0x800C:SetDeviceParmID, 0x0B:PCM1, 0x03:PCM DelFromFsRx,
 * 0x800D:SetDeviceParm, 0x0001:(1 clock) */
	0x80, 0x0C, 0x0C, 0x03, 0x80, 0x0D, 0x00, 0x01,
/* 0x800C:SetDeviceParmID, 0x0C:PCM2, 0x03:PCM DelFromFsRx,
 * 0x800D:SetDeviceParm, 0x0001:(1 clock) */
	0x80, 0x0C, 0x0D, 0x03, 0x80, 0x0D, 0x00, 0x01,
/* 0x800C:SetDeviceParmID, 0x0D:PCM3, 0x03:PCM DelFromFsRx,
 * 0x800D:SetDeviceParm, 0x0001:(1 clock) */
};

unsigned char hpt_sleep[] = {
	0x80, 0x52, 0x00, 0x48,	/* 0x8052: */
	0x80, 0x52, 0x00, 0x5C,	/* 0x8052: */
	0x80, 0x10, 0x00, 0x01,	/* sleep */
};
#endif

unsigned char phonecall_receiver_nson[] = {
#ifdef CONFIG_USA_MODEL_SGH_T989
	0x80, 0x1C, 0x00, 0x01,	/*; VoiceProcessing On */
	0x80, 0x17, 0x00, 0x02, 0x80, 0x18, 0x00, 0x00,
	/*; 2-mic Close Talk (CT) */
	0x80, 0x26, 0x00, 0x1A,	/*; SelectRouting,
0x001A:Pri,Sec,Fei,Zro,Zro,Zro,Zro,Zro - Snk,Snk,Snk,Snk,Csp,Snk,Feo,Snk */
	0x80, 0x1B, 0x00, 0x09,	/*; SetDigitalInputGain,
0x00:PCM-A left, 0x09:(9 dB) */
	0x80, 0x1B, 0x01, 0x03,	/*; SetDigitalInputGain,
0x01:PCM-A right, 0x06:(3 dB) */
	0x80, 0x15, 0x04, 0xF8,	/*; SetDigitalOutputGain,
0x04:PCM-C left, 0xF8:(-8 dB) */
	0x80, 0x15, 0x05, 0xF8,	/*; SetDigitalOutputGain,
0x05:PCM-C right, 0xF8:(-8 dB) */
	0x80, 0x1B, 0x02, 0x00,	/*; SetDigitalInputGain,
0x02:PCM-B left, 0x00:(0 dB) */
	0x80, 0x1B, 0x03, 0x00,	/*; SetDigitalInputGain,
0x03:PCM-B right, 0x00:(0 dB) */
	0x80, 0x15, 0x06, 0x00,	/*; SetDigitalOutputGain,
0x06:PCM-D left, 0x00:(0 dB) */
	0x80, 0x15, 0x07, 0x00,	/*; SetDigitalOutputGain,
0x07:PCM-D right, 0x00:(0 dB) */
	0x80, 0x17, 0x00, 0x42, 0x80, 0x18, 0xFF, 0xFD,
/*;Tx-in  Limiter Max Level (dB), 0x8018:SetAlgorithmParm, 0xFFFD:(-3 dB) */
	0x80, 0x17, 0x00, 0x4B, 0x80, 0x18, 0x00, 0x06,
/*; Tx Noise Suppression Level, 0x8018:SetAlgorithmParm, 0x0006:Level 6 */
	0x80, 0x17, 0x00, 0x0E, 0x80, 0x18, 0x00, 0x00,
/*;Far End Noise Suppression, 0x8018:SetAlgorithmParm,
 * 0x0000:OFF (auto select mode) */
	0x80, 0x17, 0x00, 0x4C, 0x80, 0x18, 0x00, 0x03,
/*;Rx Noise Suppression Level, 0x8018:SetAlgorithmParm, 0x0003:Level 3 */
	0x80, 0x17, 0x00, 0x04, 0x80, 0x18, 0x00, 0x00,
/*;Use AGC, 0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x28, 0x80, 0x18, 0x00, 0x00,
/*; Use Rx AGC, 0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x31, 0x80, 0x18, 0x00, 0x00,
/*;Rx MBC Mode, 0x8018:SetAlgorithmParm, 0x0000:OFF */
	0x80, 0x17, 0x00, 0x09, 0x80, 0x18, 0x00, 0x00,
/*;Speaker Enhancement Mode, 0x8018:SetAlgorithmParm,
 * 0x0000:SE Off (HPF only) */
	0x80, 0x17, 0x00, 0x20, 0x80, 0x18, 0x00, 0x01,
/*;Tx PostEq Mode, 0x8018:SetAlgorithmParm, 0x0001:On */
	0x80, 0x17, 0x00, 0x1F, 0x80, 0x18, 0x00, 0x00,
/*;Rx PostEq Mode, 0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x1A, 0x80, 0x18, 0x00, 0x00,
/*;Use Tx ComfortNoise, 0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x03, 0x80, 0x18, 0x00, 0x01,
/*; AEC Mode, 0x8018:SetAlgorithmParm, 0x0001:AEC On (auto select mode) */
	0x80, 0x17, 0x00, 0x12, 0x80, 0x18, 0xFF, 0xFF,
/*; Downlink Speaker Volume, 0x8018:SetAlgorithmParm, 0xFFFF:(-1 dB) */
	0x80, 0x17, 0x00, 0x34, 0x80, 0x18, 0x00, 0x01,
/*; Echo Suppression Enhancement, 0x8018:SetAlgorithmParm, 0x0001:(1 dB) */
	0x80, 0x17, 0x00, 0x23, 0x80, 0x18, 0x00, 0x00,
/*; aec comfortnoise off */
	0x80, 0x17, 0x00, 0x1E, 0x80, 0x18, 0x00, 0x02,	/*; PST2 */
#elif defined CONFIG_USA_MODEL_SGH_I717
	0x80, 0x00, 0x00, 0x00,	/* 0x8000:Sync, 0x0000:None */
	0x80, 0x1C, 0x00, 0x01,	/* 0x801C:VoiceProcessingOn, 0x0001:On */
	0x80, 0x17, 0x00, 0x02, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0002:Microphone Configuration,
 * 0x8018:SetAlgorithmParm, 0x0000:2-mic Close Talk (CT) */
	0x80, 0x26, 0x00, 0x1A,	/* 0x8026:SelectRouting,
0x001A:Pri,Sec,Fei,Zro,Zro,Zro,Zro,Zro - Snk,Snk,Snk,Snk,Csp,Snk,Feo,Snk */
	0x80, 0x1B, 0x00, 0x0c,
/* 0x801B:SetDigitalInputGain, 0x00:PCM-A left, 0x12:(18 dB) */
	0x80, 0x1B, 0x01, 0x08,
/* 0x801B:SetDigitalInputGain, 0x01:PCM-A right, 0x0F:(15 dB) */
	0x80, 0x15, 0x04, 0xF5,
/* 0x8015:SetDigitaloutGain, 0x04:PCM-C left, 0xEF:(-17 dB) */
	0x80, 0x15, 0x05, 0xF5,
/* 0x8015:SetDigitaloutGain, 0x05:PCM-C right, 0xEF:(-17 dB) */
	0x80, 0x1B, 0x02, 0x00,
/* 0x801B:SetDigitalInputGain, 0x02:PCM-B left, 0x00:(0 dB) */
	0x80, 0x1B, 0x03, 0x00,
/* 0x801B:SetDigitalInputGain, 0x03:PCM-B right, 0x00:(0 dB) */
	0x80, 0x15, 0x06, 0x00,
/* 0x801B:SetDigitaloutGain, 0x06:PCM-D left, 0x00:(0 dB) */
	0x80, 0x15, 0x07, 0x00,
/* 0x801B:SetDigitaloutGain, 0x07:PCM-D right, 0x00:(0 dB) */
	0x80, 0x17, 0x00, 0x42, 0x80, 0x18, 0xFF, 0xFD,
/* 0x8017:SetAlgorithmParmID, 0x0042:Tx-in  Limiter Max Level (dB),
 * 0x8018:SetAlgorithmParm, 0xFFFD:(-3 dB) */
	0x80, 0x17, 0x00, 0x4B, 0x80, 0x18, 0x00, 0x06,
/* 0x8017:SetAlgorithmParmID, 0x004B:Tx Noise Suppression Level,
 * 0x8018:SetAlgorithmParm, 0x0006:Level 6 */
	0x80, 0x17, 0x00, 0x15, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0015:Side Tone Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0003:AEC Mode, 0x8018:SetAlgorithmParm,
 * 0x0000:AEC Off */
	0x80, 0x17, 0x00, 0x04, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0004:Use AGC,
 * 0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x28, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0028:Use Rx AGC,
 * 0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x09, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0009:Speaker Enhancement Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:SE Off (HPF only) */
	0x80, 0x17, 0x00, 0x0E, 0x80, 0x18, 0x00, 0x01,
/* 0x8017:SetAlgorithmParmID, 0x000E:Far End Noise Suppression,
 * 0x8018:SetAlgorithmParm, 0x0001:On (auto select mode) */
	0x80, 0x17, 0x00, 0x4C, 0x80, 0x18, 0x00, 0x03,
/* 0x8017:SetAlgorithmParmID, 0x004C:   Rx Noise Suppression Level,
 * 0x8018:SetAlgorithmParm, 0x0003:Level 3 */
	0x80, 0x17, 0x00, 0x20, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0020:Tx PostEq Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x1F, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x001F:Rx PostEq Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x30, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0030:Tx MBC Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x31, 0x80, 0x18, 0x00, 0x01,
/* 0x8017:SetAlgorithmParmID, 0x0031:Rx MBC Mode,
 * 0x8018:SetAlgorithmParm, 0x0001:On */
	0x80, 0x17, 0x00, 0x1A, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x001A:Use Tx ComfortNoise,
 * 0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x1E, 0x80, 0x18, 0x00, 0x01,
/*; 0x8017:SetAlgorithmParmID, 0x001E:Position/Suppression Tradeoff,
 * 0x8018:SetAlgorithmParm,0x0001:(1) */
#else
	0x80, 0x00, 0x00, 0x00,	/* 0x8000:Sync, 0x0000:None */
	0x80, 0x1C, 0x00, 0x01,	/* 0x801C:VoiceProcessingOn, 0x0001:On */
	0x80, 0x17, 0x00, 0x02, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0002:Microphone Configuration,
 * 0x8018:SetAlgorithmParm, 0x0000:2-mic Close Talk (CT) */
	0x80, 0x26, 0x00, 0x1A, /* 0x8026:SelectRouting,
0x001A:Pri,Sec,Fei,Zro,Zro,Zro,Zro,Zro - Snk,Snk,Snk,Snk,Csp,Snk,Feo,Snk */
	0x80, 0x1B, 0x00, 0x0c,	/* 0x801B:SetDigitalInputGain,
0x00:PCM-A left, 0x12:(18 dB) */
	0x80, 0x1B, 0x01, 0x08,	/* 0x801B:SetDigitalInputGain,
0x01:PCM-A right, 0x0F:(15 dB) */
	0x80, 0x15, 0x04, 0xF5,	/* 0x8015:SetDigitaloutGain,
0x04:PCM-C left, 0xEF:(-17 dB) */
	0x80, 0x15, 0x05, 0xF5,	/* 0x8015:SetDigitaloutGain,
0x05:PCM-C right, 0xEF:(-17 dB) */
	0x80, 0x1B, 0x02, 0x00,	/* 0x801B:SetDigitalInputGain,
0x02:PCM-B left, 0x00:(0 dB) */
	0x80, 0x1B, 0x03, 0x00,	/* 0x801B:SetDigitalInputGain,
0x03:PCM-B right, 0x00:(0 dB) */
	0x80, 0x15, 0x06, 0x00,	/* 0x801B:SetDigitaloutGain,
0x06:PCM-D left, 0x00:(0 dB) */
	0x80, 0x15, 0x07, 0x00,	/* 0x801B:SetDigitaloutGain,
0x07:PCM-D right, 0x00:(0 dB) */
	0x80, 0x17, 0x00, 0x42, 0x80, 0x18, 0xFF, 0xFD,
/* 0x8017:SetAlgorithmParmID, 0x0042:Tx-in  Limiter Max Level (dB),
 * 0x8018:SetAlgorithmParm, 0xFFFD:(-3 dB) */
	0x80, 0x17, 0x00, 0x4B, 0x80, 0x18, 0x00, 0x06,
/* 0x8017:SetAlgorithmParmID, 0x004B:Tx Noise Suppression Level,
 * 0x8018:SetAlgorithmParm, 0x0006:Level 6 */
	0x80, 0x17, 0x00, 0x15, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0015:Side Tone Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0003:AEC Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:AEC Off */
	0x80, 0x17, 0x00, 0x04, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0004:Use AGC,
 * 0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x28, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0028:Use Rx AGC,
 * 0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x09, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0009:Speaker Enhancement Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:SE Off (HPF only) */
	0x80, 0x17, 0x00, 0x0E, 0x80, 0x18, 0x00, 0x01,
/* 0x8017:SetAlgorithmParmID, 0x000E:Far End Noise Suppression,
 * 0x8018:SetAlgorithmParm, 0x0001:On (auto select mode) */
	0x80, 0x17, 0x00, 0x4C, 0x80, 0x18, 0x00, 0x03,
/* 0x8017:SetAlgorithmParmID, 0x004C:   Rx Noise Suppression Level,
 * 0x8018:SetAlgorithmParm, 0x0003:Level 3 */
	0x80, 0x17, 0x00, 0x20, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0020:Tx PostEq Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x1F, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x001F:Rx PostEq Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x30, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0030:Tx MBC Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x31, 0x80, 0x18, 0x00, 0x01,
/* 0x8017:SetAlgorithmParmID, 0x0031:Rx MBC Mode,
 * 0x8018:SetAlgorithmParm, 0x0001:On */
	0x80, 0x17, 0x00, 0x1A, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x001A:Use Tx ComfortNoise,
 * 0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x1E, 0x80, 0x18, 0x00, 0x01,
/*; 0x8017:SetAlgorithmParmID, 0x001E:Position/Suppression Tradeoff,
 * 0x8018:SetAlgorithmParm,0x0001:(1) */
#endif
};

unsigned char phonecall_receiver_nsoff[] = {
#ifdef CONFIG_USA_MODEL_SGH_T989
	0x80, 0x1C, 0x00, 0x01,	/*; VoiceProcessing On */
	0x80, 0x17, 0x00, 0x02, 0x80, 0x18, 0x00, 0x00,
/*; 2-mic Close Talk (CT) */
	0x80, 0x26, 0x00, 0x1A,	/*; SelectRouting,
0x001A:Pri,Sec,Fei,Zro,Zro,Zro,Zro,Zro - Snk,Snk,Snk,Snk,Csp,Snk,Feo,Snk */
	0x80, 0x1B, 0x00, 0x09,	/*; SetDigitalInputGain,
0x00:PCM-A left, 0x09:(9 dB) */
	0x80, 0x1B, 0x01, 0x03,	/*; SetDigitalInputGain,
0x01:PCM-A right, 0x06:(3 dB) */
	0x80, 0x15, 0x04, 0xF8,	/*; SetDigitalOutputGain,
0x04:PCM-C left, 0xF8:(-8 dB) */
	0x80, 0x15, 0x05, 0xF8,	/*; SetDigitalOutputGain,
0x05:PCM-C right, 0xF8:(-8 dB) */
	0x80, 0x1B, 0x02, 0x00,	/*; SetDigitalInputGain,
0x02:PCM-B left, 0x00:(0 dB) */
	0x80, 0x1B, 0x03, 0x00,	/*; SetDigitalInputGain,
0x03:PCM-B right, 0x00:(0 dB) */
	0x80, 0x15, 0x06, 0x00,	/*; SetDigitalOutputGain,
0x06:PCM-D left, 0x00:(0 dB) */
	0x80, 0x15, 0x07, 0x00,	/*; SetDigitalOutputGain,
0x07:PCM-D right, 0x00:(0 dB) */
	0x80, 0x17, 0x00, 0x42, 0x80, 0x18, 0xFF, 0xFD,
/*;Tx-in  Limiter Max Level (dB), 0x8018:SetAlgorithmParm, 0xFFFD:(-3 dB) */
	0x80, 0x17, 0x00, 0x4B, 0x80, 0x18, 0x00, 0x03,
/*; Tx Noise Suppression Level, 0x8018:SetAlgorithmParm, 0x0003:Level 3 */
	0x80, 0x17, 0x00, 0x0E, 0x80, 0x18, 0x00, 0x00,
/*;Far End Noise Suppression, 0x8018:SetAlgorithmParm,
 * 0x0000:OFF (auto select mode) */
	0x80, 0x17, 0x00, 0x4C, 0x80, 0x18, 0x00, 0x03,
/*;Rx Noise Suppression Level, 0x8018:SetAlgorithmParm, 0x0003:Level 3 */
	0x80, 0x17, 0x00, 0x04, 0x80, 0x18, 0x00, 0x00,
/*;Use AGC, 0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x28, 0x80, 0x18, 0x00, 0x00,
/*; Use Rx AGC, 0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x31, 0x80, 0x18, 0x00, 0x00,
/*;Rx MBC Mode, 0x8018:SetAlgorithmParm, 0x0000:OFF */
	0x80, 0x17, 0x00, 0x09, 0x80, 0x18, 0x00, 0x00,
/*;Speaker Enhancement Mode, 0x8018:SetAlgorithmParm,
 * 0x0000:SE Off (HPF only) */
	0x80, 0x17, 0x00, 0x20, 0x80, 0x18, 0x00, 0x01,
/*;Tx PostEq Mode, 0x8018:SetAlgorithmParm, 0x0001:On */
	0x80, 0x17, 0x00, 0x1F, 0x80, 0x18, 0x00, 0x00,
/*;Rx PostEq Mode, 0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x1A, 0x80, 0x18, 0x00, 0x00,
/*;Use Tx ComfortNoise, 0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x03, 0x80, 0x18, 0x00, 0x01,
/*; AEC Mode, 0x8018:SetAlgorithmParm, 0x0001:AEC On (auto select mode) */
	0x80, 0x17, 0x00, 0x12, 0x80, 0x18, 0xFF, 0xFF,
/*; Downlink Speaker Volume, 0x8018:SetAlgorithmParm, 0xFFFF:(-1 dB) */
	0x80, 0x17, 0x00, 0x34, 0x80, 0x18, 0x00, 0x01,
/*; Echo Suppression Enhancement, 0x8018:SetAlgorithmParm, 0x0001:(1 dB) */
	0x80, 0x17, 0x00, 0x23, 0x80, 0x18, 0x00, 0x00,
/*; aec comfortnoise off */
	0x80, 0x17, 0x00, 0x1E, 0x80, 0x18, 0x00, 0x02,	/*; PST2 */
#elif defined CONFIG_USA_MODEL_SGH_I717
	0x80, 0x00, 0x00, 0x00,	/* 0x8000:Sync, 0x0000:None */
	0x80, 0x1C, 0x00, 0x01,	/* 0x801C:VoiceProcessingOn, 0x0001:On */
	0x80, 0x17, 0x00, 0x02, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0002:Microphone Configuration,
 * 0x8018:SetAlgorithmParm, 0x0000:2-mic Close Talk (CT) */
	0x80, 0x26, 0x00, 0x1A,	/* 0x8026:SelectRouting,
0x001A:Pri,Sec,Fei,Zro,Zro,Zro,Zro,Zro - Snk,Snk,Snk,Snk,Csp,Snk,Feo,Snk */
	0x80, 0x1B, 0x00, 0x0c,	/* 0x801B:SetDigitalInputGain,
0x00:PCM-A left, 0x12:(18 dB) */
	0x80, 0x1B, 0x01, 0x08,	/* 0x801B:SetDigitalInputGain,
0x01:PCM-A right, 0x0F:(15 dB) */
	0x80, 0x15, 0x04, 0xF5,	/* 0x8015:SetDigitalInputGain,
0x04:PCM-C left, 0xEF:(-17 dB) */
	0x80, 0x15, 0x05, 0xF5,	/* 0x8015:SetDigitalInputGain,
0x05:PCM-C right, 0xEF:(-17 dB) */
	0x80, 0x1B, 0x02, 0x00,	/* 0x801B:SetDigitalInputGain,
0x02:PCM-B left, 0x00:(0 dB) */
	0x80, 0x1B, 0x03, 0x00,	/* 0x801B:SetDigitalInputGain,
0x03:PCM-B right, 0x00:(0 dB) */
	0x80, 0x15, 0x06, 0x00,	/* 0x801B:SetDigitalInputGain,
0x06:PCM-D left, 0x00:(0 dB) */
	0x80, 0x15, 0x07, 0x00,	/* 0x801B:SetDigitalInputGain,
0x07:PCM-D right, 0x00:(0 dB) */
	0x80, 0x17, 0x00, 0x42, 0x80, 0x18, 0xFF, 0xFD,
/* 0x8017:SetAlgorithmParmID, 0x0042:Tx-in  Limiter Max Level (dB),
 * 0x8018:SetAlgorithmParm, 0xFFFD:(-3 dB) */
	0x80, 0x17, 0x00, 0x4B, 0x80, 0x18, 0x00, 0x03,
/* 0x8017:SetAlgorithmParmID, 0x004B:Tx Noise Suppression Level,
 * 0x8018:SetAlgorithmParm, 0x0006:Level 6 */
	0x80, 0x17, 0x00, 0x15, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0015:Side Tone Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0003:AEC Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:AEC Off */
	0x80, 0x17, 0x00, 0x04, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0004:Use AGC,
 * 0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x28, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0028:Use Rx AGC,
 * 0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x09, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0009:Speaker Enhancement Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:SE Off (HPF only) */
	0x80, 0x17, 0x00, 0x0E, 0x80, 0x18, 0x00, 0x01,
/* 0x8017:SetAlgorithmParmID, 0x000E:Far End Noise Suppression,
 * 0x8018:SetAlgorithmParm, 0x0001:On (auto select mode) */
	0x80, 0x17, 0x00, 0x4C, 0x80, 0x18, 0x00, 0x03,
/* 0x8017:SetAlgorithmParmID, 0x004C:   Rx Noise Suppression Level,
 * 0x8018:SetAlgorithmParm, 0x0003:Level 3 */
	0x80, 0x17, 0x00, 0x20, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0020:Tx PostEq Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x1F, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x001F:Rx PostEq Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x30, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0030:Tx MBC Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x31, 0x80, 0x18, 0x00, 0x01,
/* 0x8017:SetAlgorithmParmID, 0x0031:Rx MBC Mode,
 * 0x8018:SetAlgorithmParm, 0x0001:On */
	0x80, 0x17, 0x00, 0x1A, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x001A:Use Tx ComfortNoise,
 * 0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x1E, 0x80, 0x18, 0x00, 0x01,
/*; 0x8017:SetAlgorithmParmID, 0x001E:Position/Suppression Tradeoff,
 * 0x8018:SetAlgorithmParm,0x0001:(1) */
#else
	0x80, 0x00, 0x00, 0x00,	/* 0x8000:Sync, 0x0000:None */
	0x80, 0x1C, 0x00, 0x01,	/* 0x801C:VoiceProcessingOn, 0x0001:On */
	0x80, 0x17, 0x00, 0x02, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0002:Microphone Configuration,
 * 0x8018:SetAlgorithmParm, 0x0000:2-mic Close Talk (CT) */
	0x80, 0x26, 0x00, 0x1A,	/* 0x8026:SelectRouting,
0x001A:Pri,Sec,Fei,Zro,Zro,Zro,Zro,Zro - Snk,Snk,Snk,Snk,Csp,Snk,Feo,Snk */
	0x80, 0x1B, 0x00, 0x0c,	/* 0x801B:SetDigitalInputGain,
0x00:PCM-A left, 0x12:(18 dB) */
	0x80, 0x1B, 0x01, 0x08,	/* 0x801B:SetDigitalInputGain,
0x01:PCM-A right, 0x0F:(15 dB) */
	0x80, 0x15, 0x04, 0xF5,	/* 0x8015:SetDigitalInputGain,
0x04:PCM-C left, 0xEF:(-17 dB) */
	0x80, 0x15, 0x05, 0xF5,	/* 0x8015:SetDigitalInputGain,
0x05:PCM-C right, 0xEF:(-17 dB) */
	0x80, 0x1B, 0x02, 0x00,	/* 0x801B:SetDigitalInputGain,
0x02:PCM-B left, 0x00:(0 dB) */
	0x80, 0x1B, 0x03, 0x00,	/* 0x801B:SetDigitalInputGain,
0x03:PCM-B right, 0x00:(0 dB) */
	0x80, 0x15, 0x06, 0x00,	/* 0x801B:SetDigitalInputGain,
0x06:PCM-D left, 0x00:(0 dB) */
	0x80, 0x15, 0x07, 0x00,	/* 0x801B:SetDigitalInputGain,
0x07:PCM-D right, 0x00:(0 dB) */
	0x80, 0x17, 0x00, 0x42, 0x80, 0x18, 0xFF, 0xFD,
/* 0x8017:SetAlgorithmParmID, 0x0042:Tx-in  Limiter Max Level (dB),
 * 0x8018:SetAlgorithmParm, 0xFFFD:(-3 dB) */
	0x80, 0x17, 0x00, 0x4B, 0x80, 0x18, 0x00, 0x03,
/* 0x8017:SetAlgorithmParmID, 0x004B:Tx Noise Suppression Level,
 * 0x8018:SetAlgorithmParm, 0x0006:Level 6 */
	0x80, 0x17, 0x00, 0x15, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0015:Side Tone Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0003:AEC Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:AEC Off */
	0x80, 0x17, 0x00, 0x04, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0004:Use AGC,
 * 0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x28, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0028:Use Rx AGC,
 * 0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x09, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0009:Speaker Enhancement Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:SE Off (HPF only) */
	0x80, 0x17, 0x00, 0x0E, 0x80, 0x18, 0x00, 0x01,
/* 0x8017:SetAlgorithmParmID, 0x000E:Far End Noise Suppression,
 * 0x8018:SetAlgorithmParm, 0x0001:On (auto select mode) */
	0x80, 0x17, 0x00, 0x4C, 0x80, 0x18, 0x00, 0x03,
/* 0x8017:SetAlgorithmParmID, 0x004C:   Rx Noise Suppression Level,
 * 0x8018:SetAlgorithmParm, 0x0003:Level 3 */
	0x80, 0x17, 0x00, 0x20, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0020:Tx PostEq Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x1F, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x001F:Rx PostEq Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x30, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x0030:Tx MBC Mode,
 * 0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x31, 0x80, 0x18, 0x00, 0x01,
/* 0x8017:SetAlgorithmParmID, 0x0031:Rx MBC Mode,
 * 0x8018:SetAlgorithmParm, 0x0001:On */
	0x80, 0x17, 0x00, 0x1A, 0x80, 0x18, 0x00, 0x00,
/* 0x8017:SetAlgorithmParmID, 0x001A:Use Tx ComfortNoise,
 * 0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x1E, 0x80, 0x18, 0x00, 0x01,
/*; 0x8017:SetAlgorithmParmID, 0x001E:Position/Suppression Tradeoff,
 * 0x8018:SetAlgorithmParm,0x0001:(1) */
#endif
};

#ifdef CONFIG_VP_A2220
unsigned char bypass_multimedia[] = {
#ifdef CONFIG_USA_MODEL_SGH_I717
	0x80, 0x0C, 0x0A, 0x07, 0x80, 0x0D, 0x00, 0x01,
/* 0x800C:SetDeviceParmID, 0x0A:PCM0, 0x07:PCM Audio Port Mode,
 * 0x800D:SetDeviceParm, 0x0001:I2S */
	0x80, 0x0C, 0x0B, 0x07, 0x80, 0x0D, 0x00, 0x01,
/* 0x800C:SetDeviceParmID, 0x0B:PCM1, 0x07:PCM Audio Port Mode,
 * 0x800D:SetDeviceParm, 0x0001:I2S */
	0x80, 0x0C, 0x0C, 0x07, 0x80, 0x0D, 0x00, 0x01,
/* 0x800C:SetDeviceParmID, 0x0C:PCM2, 0x07:PCM Audio Port Mode,
 * 0x800D:SetDeviceParm, 0x0001:I2S */
	0x80, 0x0C, 0x0D, 0x07, 0x80, 0x0D, 0x00, 0x01,
/* 0x800C:SetDeviceParmID, 0x0D:PCM3, 0x07:PCM Audio Port Mode,
 * 0x800D:SetDeviceParm, 0x0001:I2S */
	0x80, 0x0C, 0x0A, 0x03, 0x80, 0x0D, 0x00, 0x01,
/* 0x800C:SetDeviceParmID, 0x0A:PCM0, 0x03:PCM DelFromFsRx,
 * 0x800D:SetDeviceParm, 0x0001:(1 clock) */
	0x80, 0x0C, 0x0B, 0x03, 0x80, 0x0D, 0x00, 0x01,
/* 0x800C:SetDeviceParmID, 0x0B:PCM1, 0x03:PCM DelFromFsRx,
 * 0x800D:SetDeviceParm, 0x0001:(1 clock) */
	0x80, 0x0C, 0x0C, 0x03, 0x80, 0x0D, 0x00, 0x01,
/* 0x800C:SetDeviceParmID, 0x0C:PCM2, 0x03:PCM DelFromFsRx,
 * 0x800D:SetDeviceParm, 0x0001:(1 clock) */
	0x80, 0x0C, 0x0D, 0x03, 0x80, 0x0D, 0x00, 0x01,
/* 0x800C:SetDeviceParmID, 0x0D:PCM3, 0x03:PCM DelFromFsRx,
 * 0x800D:SetDeviceParm, 0x0001:(1 clock) */
	0x80, 0x52, 0x00, 0x48,	/* 0x8052: */
	0x80, 0x52, 0x00, 0x5C,	/* 0x8052: */
	0x80, 0x10, 0x00, 0x01,	/* sleep */
#else
	/*hercules_eS305_SPK[1].txt */
	0x80, 0x1C, 0x00, 0x00,	/*; 0x801C:VoiceProcessingOn, 0x0000:off */
	0x80, 0x26, 0x00, 0x1F,	/* ; 0x8015:SetDigitalOutputGain,
0x05:PCM-B right, 0xA6:(30 dB) */
	0x80, 0x0C, 0x0B, 0x03, 0x80, 0x0D, 0x00, 0x01,
/* ; PCM B Din delay 1bit */
	0x80, 0x0C, 0x0A, 0x03, 0x80, 0x0D, 0x00, 0x01,
/* ; PCM A Din delay 1bit */
#endif
};
#endif



unsigned char phonecall_headset[] = {
#ifdef CONFIG_USA_MODEL_SGH_T989
	0x80, 0x1C, 0x00, 0x01,	/*; 0x801C:VoiceProcessingOn, 0x0001:On */
	0x80, 0x17, 0x00, 0x02, 0x80, 0x18, 0x00, 0x03,
/*; 0x8017:SetAlgorithmParmID, 0x0002:Microphone Configuration,
 * 0x8018:SetAlgorithmParm, 0x0003:1-mic MD */
	0x80, 0x26, 0x00, 0x1A,	/*; 0x8026:SelectRouting, 0x001A:(26) */
	0x80, 0x1B, 0x00, 0x00,	/*;port a left in gain 0db */
	0x80, 0x1B, 0x01, 0xA6,	/*;port a right -90db */
	0x80, 0x15, 0x04, 0x00,	/*; port c left out odb */
	0x80, 0x15, 0x05, 0x00,	/*; port c Rout 0db */
	0x80, 0x1B, 0x02, 0x00,	/*; Port B Lin 0db */
	0x80, 0x1B, 0x03, 0x00,	/*; Port B Rin 0db */
	0x80, 0x15, 0x06, 0x00,	/*; Port D Lout 0db */
	0x80, 0x15, 0x07, 0x00,	/*; Port D Rout 0db */
	0x80, 0x17, 0x00, 0x4B, 0x80, 0x18, 0x00, 0x00,	/*; Ns level 0 */
	0x80, 0x17, 0x00, 0x15, 0x80, 0x18, 0x00, 0x00,	/*;side tone OFF */
	0x80, 0x17, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00,	/*; AEC OFF */
	0x80, 0x17, 0x00, 0x04, 0x80, 0x18, 0x00, 0x00,	/*; Tx AGC Off */
	0x80, 0x17, 0x00, 0x28, 0x80, 0x18, 0x00, 0x00,	/*; Rx AGC Off */
	0x80, 0x17, 0x00, 0x29, 0x80, 0x18, 0xFF, 0xE6,/*; Target level -26db */
	0x80, 0x17, 0x00, 0x2A, 0x80, 0x18, 0xFF, 0xC5,/*; noise floor; -59db */
	0x80, 0x17, 0x00, 0x2B, 0x80, 0x18, 0x00, 0x00,	/*; SNR 0 */
	0x80, 0x17, 0x00, 0x2C, 0x80, 0x18, 0x00, 0x00,	/*; up 0 */
	0x80, 0x17, 0x00, 0x2C, 0x80, 0x18, 0x00, 0x00,	/*; down 0 */
	0x80, 0x17, 0x01, 0x02, 0x80, 0x18, 0x00, 0x05,	/*; max gain 5 */
	0x80, 0x17, 0x00, 0x3F, 0x80, 0x18, 0x00, 0x0A,	/*; guar 10dB */

	0x80, 0x17, 0x00, 0x09, 0x80, 0x18, 0x00, 0x00,	/*; VEQ OFF */
	0x80, 0x17, 0x00, 0x0E, 0x80, 0x18, 0x00, 0x00,	/*;Rx NS Off */
	0x80, 0x17, 0x00, 0x4C, 0x80, 0x18, 0x00, 0x03,	/*;Rx NS levle 3 */
	0x80, 0x17, 0x00, 0x20, 0x80, 0x18, 0x00, 0x00,	/*; Tx post EQ off */
	0x80, 0x17, 0x00, 0x1F, 0x80, 0x18, 0x00, 0x00,	/*; Rx post EQ off */
	0x80, 0x17, 0x00, 0x1A, 0x80, 0x18, 0x00, 0x00,	/*; Tx comport noise
off */
/*	0x80, 0x17, 0x00, 0x4F, 0x80, 0x18, 0x00, 0x00, */ /* ;BWE OFF */
	0x80, 0x17, 0x00, 0x30, 0x80, 0x18, 0x00, 0x00,	/*; Tx MBC Off */
	0x80, 0x17, 0x00, 0x31, 0x80, 0x18, 0x00, 0x00,	/*; Rx MBC Off */
#elif defined CONFIG_USA_MODEL_SGH_I717
	0x80, 0x1C, 0x00, 0x00,	/*; 0x801C:VoiceProcessingOn, 0x0000:OFF */
	0x80, 0x17, 0x00, 0x02, 0x80, 0x18, 0x00, 0x03,	/*; Microphone
Configuration,0x0003:1-mic External (MD) */
	0x80, 0x26, 0x00, 0x1A,	/*;0x8026:SelectRouting, 0x001A:(26) */
	0x80, 0x1B, 0x00, 0x00,	/*;port a left in gain 0db */
	0x80, 0x1B, 0x01, 0x00,	/*;port a right 0db */
	0x80, 0x15, 0x04, 0x00,	/*; port c left out odb */
	0x80, 0x15, 0x05, 0x00,	/*; port c Rout 0db */
	0x80, 0x1B, 0x02, 0x00,	/*; Port B Lin 0db */
	0x80, 0x1B, 0x03, 0x00,	/*; Port B Rin 0db */
	0x80, 0x15, 0x06, 0x00,	/*; Port D Lout 0db */
	0x80, 0x15, 0x07, 0x00,	/*; Port D Rout 0db */
	0x80, 0x17, 0x00, 0x4B, 0x80, 0x18, 0x00, 0x00,	/*; Tx Noise
Suppression Level, 0x8018:SetAlgorithmParm, 0x0006:Level 6 */
	0x80, 0x17, 0x00, 0x15, 0x80, 0x18, 0x00, 0x00,	/*; Side Tone Mode,
0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00,	/*; AEC Mode,
0x8018:SetAlgorithmParm, 0x0001:AEC On (auto select mode) */
	0x80, 0x17, 0x00, 0x12, 0x80, 0x18, 0x00, 0x00,	/*; Downlink Speaker
Volume, 0x8018:SetAlgorithmParm, 0x0000:(0 dB) */
	0x80, 0x17, 0x00, 0x34, 0x80, 0x18, 0x00, 0x00,	/*; Echo Suppression
Enhancement, 0x8018:SetAlgorithmParm, 0x0000:(0 dB) */
	0x80, 0x17, 0x00, 0x04, 0x80, 0x18, 0x00, 0x00,	/*; Use AGC,
0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x28, 0x80, 0x18, 0x00, 0x00,	/*; Use Rx AGC,
0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x09, 0x80, 0x18, 0x00, 0x00,	/*; Speaker Enhancement
Mode, 0x8018:SetAlgorithmParm, 0x0000:SE Off (HPF only) */
	0x80, 0x17, 0x00, 0x0E, 0x80, 0x18, 0x00, 0x00,	/*; Far End Noise
Suppression, 0x8018:SetAlgorithmParm, 0x0002:On */
	0x80, 0x17, 0x00, 0x4C, 0x80, 0x18, 0x00, 0x00,	/*; Rx Noise
Suppression Level, 0x8018:SetAlgorithmParm, 0x0003:Level 3 */
	0x80, 0x17, 0x00, 0x20, 0x80, 0x18, 0x00, 0x00,	/*; Tx PostEq Mode,
0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x1F, 0x80, 0x18, 0x00, 0x00,	/*; Rx PostEq Mode,
0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x30, 0x80, 0x18, 0x00, 0x00,	/*; Tx MBC Mode,
0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x31, 0x80, 0x18, 0x00, 0x01,	/*; Rx MBC Mode,
0x8018:SetAlgorithmParm, 0x0001:On */
	0x80, 0x17, 0x00, 0x1A, 0x80, 0x18, 0x00, 0x00,	/*; Use Tx ComfortNoise,
0x8018:SetAlgorithmParm, 0x0000:No */
#else
	0x80, 0x1C, 0x00, 0x00,	/*; 0x801C:VoiceProcessingOn, 0x0000:OFF */
	0x80, 0x17, 0x00, 0x02, 0x80, 0x18, 0x00, 0x03,	/*; Microphone
Configuration,0x0003:1-mic External (MD) */
	0x80, 0x26, 0x00, 0x1A,	/*;0x8026:SelectRouting, 0x001A:(26) */
	0x80, 0x1B, 0x00, 0x00,	/*;port a left in gain 0db */
	0x80, 0x1B, 0x01, 0x00,	/*;port a right 0db */
	0x80, 0x15, 0x04, 0x00,	/*; port c left out odb */
	0x80, 0x15, 0x05, 0x00,	/*; port c Rout 0db */
	0x80, 0x1B, 0x02, 0x00,	/*; Port B Lin 0db */
	0x80, 0x1B, 0x03, 0x00,	/*; Port B Rin 0db */
	0x80, 0x15, 0x06, 0x00,	/*; Port D Lout 0db */
	0x80, 0x15, 0x07, 0x00,	/*; Port D Rout 0db */
	0x80, 0x17, 0x00, 0x4B, 0x80, 0x18, 0x00, 0x00,	/*; Tx Noise
Suppression Level, 0x8018:SetAlgorithmParm, 0x0006:Level 6 */
	0x80, 0x17, 0x00, 0x15, 0x80, 0x18, 0x00, 0x00,	/*; Side Tone Mode,
0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00,	/*; AEC Mode,
0x8018:SetAlgorithmParm, 0x0001:AEC On (auto select mode) */
	0x80, 0x17, 0x00, 0x12, 0x80, 0x18, 0x00, 0x00,	/*; Downlink Speaker
Volume, 0x8018:SetAlgorithmParm, 0x0000:(0 dB) */
	0x80, 0x17, 0x00, 0x34, 0x80, 0x18, 0x00, 0x00,	/*; Echo Suppression
Enhancement, 0x8018:SetAlgorithmParm, 0x0000:(0 dB) */
	0x80, 0x17, 0x00, 0x04, 0x80, 0x18, 0x00, 0x00,	/*; Use AGC,
0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x28, 0x80, 0x18, 0x00, 0x00,	/*; Use Rx AGC,
0x8018:SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x09, 0x80, 0x18, 0x00, 0x00,	/*; Speaker Enhancement
Mode, 0x8018:SetAlgorithmParm, 0x0000:SE Off (HPF only) */
	0x80, 0x17, 0x00, 0x0E, 0x80, 0x18, 0x00, 0x00,	/*; Far End Noise
Suppression, 0x8018:SetAlgorithmParm, 0x0002:On */
	0x80, 0x17, 0x00, 0x4C, 0x80, 0x18, 0x00, 0x00,	/*; Rx Noise
Suppression Level, 0x8018:SetAlgorithmParm, 0x0003:Level 3 */
	0x80, 0x17, 0x00, 0x20, 0x80, 0x18, 0x00, 0x00,	/*; Tx PostEq Mode,
0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x1F, 0x80, 0x18, 0x00, 0x00,	/*; Rx PostEq Mode,
0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x30, 0x80, 0x18, 0x00, 0x00,	/*; Tx MBC Mode,
0x8018:SetAlgorithmParm, 0x0000:Off */
	0x80, 0x17, 0x00, 0x31, 0x80, 0x18, 0x00, 0x01,	/*; Rx MBC Mode,
0x8018:SetAlgorithmParm, 0x0001:On */
	0x80, 0x17, 0x00, 0x1A, 0x80, 0x18, 0x00, 0x00,	/*; Use Tx
ComfortNoise, 0x8018:SetAlgorithmParm, 0x0000:No */
#endif
};

unsigned char phonecall_speaker[] = {

#ifdef CONFIG_USA_MODEL_SGH_T989
	0x80, 0x1C, 0x00, 0x00,	/*; 0x801C:VoiceProcessingOn, 0x0000:OFF */
	0x80, 0x17, 0x00, 0x02, 0x80, 0x18, 0x00, 0x02,
/*; 0x8017:SetAlgorithmParmID, 0x0002:Microphone Configuration,
 * 0x8018:SetAlgorithmParm, 0x0002:1-mic SPK */
	0x80, 0x26, 0x00, 0x1B,	/*; 0x8026:SelectRouting, 0x001B:(27) */
	0x80, 0x1B, 0x00, 0x00,	/*;port a left in gain -0db */
	0x80, 0x1B, 0x01, 0x00,	/*;port a right -0db */
	0x80, 0x15, 0x04, 0x00,	/*; port c left out -0db */
	0x80, 0x15, 0x05, 0x00,	/*; port c Rout -0db */
	0x80, 0x1B, 0x02, 0x00,	/*; Port B Lin 0db */
	0x80, 0x1B, 0x03, 0x00,	/*; Port B Rin 0db */
	0x80, 0x15, 0x06, 0x00,	/*; Port D Lout 0 */
	0x80, 0x15, 0x07, 0x00,	/*; Port D Rout 0db */
	0x80, 0x17, 0x00, 0x4B, 0x80, 0x18, 0x00, 0x06,	/*;NS level 6 */
	0x80, 0x17, 0x00, 0x0E, 0x80, 0x18, 0x00, 0x02,	/*; Rx Ns On */
	0x80, 0x17, 0x00, 0x4C, 0x80, 0x18, 0x00, 0x07,	/*; Rx NS levle 7 */
	0x80, 0x17, 0x00, 0x15, 0x80, 0x18, 0x00, 0x00,	/*;side tone OFF */
	0x80, 0x17, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00,	/*;AEC OFF */
	0x80, 0x17, 0x00, 0x04, 0x80, 0x18, 0x00, 0x00,	/*;Tx AGC Off */
	0x80, 0x17, 0x00, 0x28, 0x80, 0x18, 0x00, 0x00,	/*;Rx AGC Off */
	0x80, 0x17, 0x00, 0x09, 0x80, 0x18, 0x00, 0x00,	/*;VEQ OFF */
	0x80, 0x17, 0x00, 0x20, 0x80, 0x18, 0x00, 0x00,	/*;Tx post EQ off */
	0x80, 0x17, 0x00, 0x1F, 0x80, 0x18, 0x00, 0x00,	/*;Rx post EQ off */
	0x80, 0x17, 0x00, 0x1A, 0x80, 0x18, 0x00, 0x00,	/*;Tx comport
noise off */
	0x80, 0x17, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00,	/*; AEC OFF */
	0x80, 0x17, 0x00, 0x12, 0x80, 0x18, 0xFF, 0xFF,	/*; DSV -1 */
	0x80, 0x17, 0x00, 0x34, 0x80, 0x18, 0xFF, 0xFF,	/*; ESE -1 */
#elif defined CONFIG_USA_MODEL_SGH_I717
	0x80, 0x1C, 0x00, 0x01,	/*; 0x801C:VoiceProcessingOn, 0x0001:On */
	0x80, 0x17, 0x00, 0x02, 0x80, 0x18, 0x00, 0x02,
/*; 0x8017:SetAlgorithmParmID, 0x0002:Microphone Configuration,
 * 0x8018:SetAlgorithmParm, 0x0002:1-mic FT */
	0x80, 0x26, 0x00, 0x1B,	/*; 0x8026:SelectRouting, 0x001B:(27) */
	0x80, 0x1B, 0x00, 0xa6,	/*;port a left in gain -90db */
	0x80, 0x1B, 0x01, 0x00,	/*;port a right 0db */
	0x80, 0x15, 0x04, 0x00,	/*; port c left out 0db */
	0x80, 0x15, 0x05, 0x00,	/*; port c Rout 0db */
	0x80, 0x1B, 0x02, 0x00,	/*; Port B Lin 0db */
	0x80, 0x1B, 0x03, 0x00,	/*; Port B Rin 0db */
	0x80, 0x15, 0x06, 0x03,	/*; Port D Lout 3db */
	0x80, 0x15, 0x07, 0x03,	/*; Port D Rout 3db */
	0x80, 0x17, 0x00, 0x4B, 0x80, 0x18, 0x00, 0x03,	/*; NS level 6 */
	0x80, 0x17, 0x00, 0x15, 0x80, 0x18, 0x00, 0x00,	/*;side tone OFF */
	0x80, 0x17, 0x00, 0x03, 0x80, 0x18, 0x00, 0x01,	/*; AEC On */
	0x80, 0x17, 0x00, 0x12, 0x80, 0x18, 0xFF, 0xF5,	/*; DSV -11 */
	0x80, 0x17, 0x00, 0x23, 0x80, 0x18, 0x00, 0x00,	/*;EC comfort
noise off */
	0x80, 0x17, 0x00, 0x34, 0x80, 0x18, 0x00, 0x10,	/*; ese 16 */
	0x80, 0x17, 0x00, 0x04, 0x80, 0x18, 0x00, 0x00,	/*; Tx AGC Off */
	0x80, 0x17, 0x00, 0x28, 0x80, 0x18, 0x00, 0x00,	/*; Rx AGC Off */
	0x80, 0x17, 0x00, 0x09, 0x80, 0x18, 0x00, 0x00,	/*; VEQ OFF */
	0x80, 0x17, 0x00, 0x0E, 0x80, 0x18, 0x00, 0x02,	/*;Rx NS on */
	0x80, 0x17, 0x00, 0x4C, 0x80, 0x18, 0x00, 0x00,	/*; Rx NS 3 */
	0x80, 0x17, 0x00, 0x20, 0x80, 0x18, 0x00, 0x00,	/*; Tx post EQ off */
	0x80, 0x17, 0x00, 0x1F, 0x80, 0x18, 0x00, 0x00,	/*; Rx post EQ off */
	0x80, 0x17, 0x00, 0x30, 0x80, 0x18, 0x00, 0x00,	/*; Tx MBC Mode, Off */
	0x80, 0x17, 0x00, 0x31, 0x80, 0x18, 0x00, 0x00,	/*; Rx MBC Mode, On */
	0x80, 0x17, 0x00, 0x1A, 0x80, 0x18, 0x00, 0x00, /*; Tx comport
noise off */
#else
	0x80, 0x1C, 0x00, 0x01,	/*; 0x801C:VoiceProcessingOn, 0x0001:On */
	0x80, 0x17, 0x00, 0x02, 0x80, 0x18, 0x00, 0x02,
/*; 0x8017:SetAlgorithmParmID, 0x0002:Microphone Configuration,
 * 0x8018:SetAlgorithmParm, 0x0002:1-mic FT */
	0x80, 0x26, 0x00, 0x1B,	/*; 0x8026:SelectRouting, 0x001B:(27) */
	0x80, 0x1B, 0x00, 0xa6,	/*;port a left in gain -90db */
	0x80, 0x1B, 0x01, 0x00,	/*;port a right 0db */
	0x80, 0x15, 0x04, 0x00,	/*; port c left out 0db */
	0x80, 0x15, 0x05, 0x00,	/*; port c Rout 0db */
	0x80, 0x1B, 0x02, 0x00,	/*; Port B Lin 0db */
	0x80, 0x1B, 0x03, 0x00,	/*; Port B Rin 0db */
	0x80, 0x15, 0x06, 0x03,	/*; Port D Lout 3db */
	0x80, 0x15, 0x07, 0x03,	/*; Port D Rout 3db */
	0x80, 0x17, 0x00, 0x4B, 0x80, 0x18, 0x00, 0x03,	/*; NS level 6 */
	0x80, 0x17, 0x00, 0x15, 0x80, 0x18, 0x00, 0x00,	/*;side tone OFF */
	0x80, 0x17, 0x00, 0x03, 0x80, 0x18, 0x00, 0x01,	/*; AEC On */
	0x80, 0x17, 0x00, 0x12, 0x80, 0x18, 0xFF, 0xF5,	/*; DSV -11 */
	0x80, 0x17, 0x00, 0x23, 0x80, 0x18, 0x00, 0x00,	/*;EC comfort
noise off */
	0x80, 0x17, 0x00, 0x34, 0x80, 0x18, 0x00, 0x10,	/*; ese 16 */
	0x80, 0x17, 0x00, 0x04, 0x80, 0x18, 0x00, 0x00,	/*; Tx AGC Off */
	0x80, 0x17, 0x00, 0x28, 0x80, 0x18, 0x00, 0x00,	/*; Rx AGC Off */
	0x80, 0x17, 0x00, 0x09, 0x80, 0x18, 0x00, 0x00,	/*; VEQ OFF */
	0x80, 0x17, 0x00, 0x0E, 0x80, 0x18, 0x00, 0x02,	/*;Rx NS on */
	0x80, 0x17, 0x00, 0x4C, 0x80, 0x18, 0x00, 0x00,	/*; Rx NS 3 */
	0x80, 0x17, 0x00, 0x20, 0x80, 0x18, 0x00, 0x00,	/*; Tx post EQ off */
	0x80, 0x17, 0x00, 0x1F, 0x80, 0x18, 0x00, 0x00,	/*; Rx post EQ off */
	0x80, 0x17, 0x00, 0x30, 0x80, 0x18, 0x00, 0x00,	/*; Tx MBC Mode, Off */
	0x80, 0x17, 0x00, 0x31, 0x80, 0x18, 0x00, 0x00,	/*; Rx MBC Mode, On */
	0x80, 0x17, 0x00, 0x1A, 0x80, 0x18, 0x00, 0x00,	/*; Tx comport
noise off */
#endif

};

unsigned char phonecall_bt[] = {
	0x80, 0x17, 0x00, 0x02,	/* SetAlgorithmParmID, 0x0002:Microphone
Configuration */
	0x80, 0x18, 0x00, 0x03,	/* SetAlgorithmParm, 0x0003:1-mic External(MD)*/
	0x80, 0x26, 0x00, 0x06,	/* SelectRouting,
0x0006:Snk,Snk,Fei,Pri - Zro,Csp,Feo (PCM0->PCM1+ADCs) */
	0x80, 0x1C, 0x00, 0x00,	/* VoiceProcessingOn, 0x0000:No */
	0x80, 0x1B, 0x00, 0x00,	/* SetDigitalInputGain,
0x00:Primay Mic (Tx), 0x00:(0 dB) */
	0x80, 0x15, 0x00, 0x00,	/* SetDigitalOutputGain,
0x00:Tx, 0x00:(0 dB) */
};

unsigned char phonecall_tty[] = {
	0x80, 0x26, 0x00, 0x15,	/* SelectRouting,
0x0015:Snk,Pri,Snk,Snk - Csp,Zro,Zro (none) */
	0x80, 0x1C, 0x00, 0x00,	/* VoiceProcessingOn, 0x0000:No */
	0x80, 0x1B, 0x00, 0x00,	/* SetDigitalInputGain,
0x00:Primay Mic (Tx), 0x00:(0 dB) */
	0x80, 0x15, 0x00, 0xFB,	/* SetDigitalOutputGain,
0x00:Tx, 0xFB:(-5 dB) */
};

unsigned char INT_MIC_recording_receiver[] = {
	0x80, 0x26, 0x00, 0x07,	/* SelectRouting,
0x0007:Pri,Snk,Snk,Snk - Csp,Zro,Zro (none) */
	0x80, 0x1C, 0x00, 0x00,	/* VoiceProcessingOn, 0x0000:No */
	0x80, 0x1B, 0x00, 0x12,	/* SetDigitalInputGain,
0x00:Primay Mic (Tx), 0x12:(18 dB) */
	0x80, 0x15, 0x00, 0x00,	/* SetDigitalOutputGain,
0x00:Tx, 0x00:(0 dB) */
};

unsigned char EXT_MIC_recording[] = {
	0x80, 0x26, 0x00, 0x15,	/* SelectRouting,
0x0015:Snk,Pri,Snk,Snk - Csp,Zro,Zro (none) */
	0x80, 0x1C, 0x00, 0x00,	/* VoiceProcessingOn, 0x0000:No */
	0x80, 0x1B, 0x00, 0x12,	/* SetDigitalInputGain,
0x00:Primay Mic (Tx), 0x12:(18 dB) */
	0x80, 0x15, 0x00, 0x00,	/* SetDigitalOutputGain,
0x00:Tx, 0x00:(0 dB) */
};

unsigned char INT_MIC_recording_speaker[] = {
	0x80, 0x17, 0x00, 0x02,	/* SetAlgorithmParmID,
0x0002:Microphone Configuration */
	0x80, 0x18, 0x00, 0x02,	/* SetAlgorithmParm,
0x0002:1-mic Desktop/Vehicle (DV) */
	0x80, 0x1C, 0x00, 0x00,	/* VoiceProcessingOn,
0x0000:No */
	0x80, 0x1B, 0x00, 0x12,	/* SetDigitalInputGain,
0x00:Primay Mic (Tx), 0x12:(18 dB) */
	0x80, 0x15, 0x00, 0x00,	/* SetDigitalOutputGain,
0x00:Tx, 0x00:(0 dB) */
};

unsigned char BACK_MIC_recording[] = {
	0x80, 0x17, 0x00, 0x02,	/* SetAlgorithmParmID,
0x0002:Microphone Configuration */
	0x80, 0x18, 0x00, 0x02,	/* SetAlgorithmParm,
0x0002:1-mic Desktop/Vehicle (DV) */
	0x80, 0x26, 0x00, 0x15,	/* SelectRouting,
0x0015:Snk,Pri,Snk,Snk - Csp,Zro,Zro (none) */
	0x80, 0x1C, 0x00, 0x01,	/* VoiceProcessingOn,0x0001:Yes */
	0x80, 0x17, 0x00, 0x04,	/* SetAlgorithmParmID, 0x0004:Use AGC */
	0x80, 0x18, 0x00, 0x01,	/* SetAlgorithmParm, 0x0001:Yes */
	0x80, 0x17, 0x00, 0x1A,	/* SetAlgorithmParmID,
0x001A:Use ComfortNoise */
	0x80, 0x18, 0x00, 0x00,	/* SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x00,	/* SetAlgorithmParmID,
0x0000:Suppression Strength */
	0x80, 0x18, 0x00, 0x00,	/* SetAlgorithmParm, 0x0000:No Suppression */
	0x80, 0x1B, 0x00, 0x12,	/* SetDigitalInputGain, 0x00:Primay Mic (Tx),
0x12:(18 dB) */
	0x80, 0x15, 0x00, 0x06,	/* SetDigitalOutputGain, 0x00:Tx, 0x06:(6 dB) */
};

unsigned char vr_no_ns_receiver[] = {
	0x80, 0x17, 0x00, 0x02,	/* SetAlgorithmParmID, 0x0002:Microphone
Configuration */
	0x80, 0x18, 0x00, 0x00,	/* SetAlgorithmParm, 0x0000:2-mic Close Talk
(CT) */
	0x80, 0x1C, 0x00, 0x00,	/* VoiceProcessingOn, 0x0000:No */
	0x80, 0x1B, 0x00, 0x0C,	/* SetDigitalInputGain, 0x00:Primay Mic(Tx),
0x0C:(12 dB) */
	0x80, 0x1B, 0x01, 0x0C,	/* SetDigitalInputGain, 0x01:Secondary Mic(Tx),
0x09:(12 dB) */
	0x80, 0x15, 0x00, 0x00,	/* SetDigitalOutputGain, 0x00:Tx, 0x00:(0 dB) */
};

unsigned char vr_no_ns_headset[] = {
	0x80, 0x17, 0x00, 0x02,	/* SetAlgorithmParmID, 0x0002:Microphone
Configuration */
	0x80, 0x18, 0x00, 0x03,	/* SetAlgorithmParm, 0x0003:1M-DG
(1-mic digital input) */
	0x80, 0x26, 0x00, 0x15,	/* SelectRouting,
0x0015:Snk,Pri,Snk,Snk - Csp,Zro,Zro (none) */
	0x80, 0x1C, 0x00, 0x00,	/* VoiceProcessingOn, 0x0000:No */
	0x80, 0x1B, 0x00, 0x12,	/* SetDigitalInputGain, 0x00:Primay Mic (Tx),
0x12:(18 dB) */
	0x80, 0x15, 0x00, 0x00,	/* SetDigitalOutputGain, 0x00:Tx, 0x00:(0 dB) */
};

unsigned char vr_no_ns_speaker[] = {
	0x80, 0x17, 0x00, 0x02,	/* SetAlgorithmParmID, 0x0002:Microphone
Configuration */
	0x80, 0x18, 0x00, 0x02,	/* SetAlgorithmParm, 0x0002:1-mic
Desktop/Vehicle (DV) */
	0x80, 0x1C, 0x00, 0x00,	/* VoiceProcessingOn, 0x0000:No */
	0x80, 0x1B, 0x00, 0x0C,	/* SetDigitalInputGain, 0x00:Primay Mic (Tx),
0x0C:(12 dB) */
	0x80, 0x15, 0x00, 0x00,	/* SetDigitalOutputGain, 0x00:Tx, 0x00:(0 dB) */
};

unsigned char vr_no_ns_bt[] = {
	0x80, 0x26, 0x00, 0x06,	/* SelectRouting,
0x0006:Snk,Snk,Fei,Pri - Zro,Csp,Feo (PCM0->PCM1+ADCs) */
	0x80, 0x1C, 0x00, 0x00,	/* VoiceProcessingOn, 0x0000:No */
	0x80, 0x1B, 0x00, 0x00,	/* SetDigitalInputGain, 0x00:Primay Mic (Tx),
0x00:(0 dB) */
	0x80, 0x15, 0x00, 0x00,	/* SetDigitalOutputGain, 0x00:Tx, 0x00:(0 dB) */
};

unsigned char vr_ns_receiver[] = {
	0x80, 0x17, 0x00, 0x02,	/* SetAlgorithmParmID, 0x0002:Microphone
Configuration */
	0x80, 0x18, 0x00, 0x00,	/* SetAlgorithmParm, 0x0000:2-mic Close Talk
(CT) */
	0x80, 0x1C, 0x00, 0x01,	/* VoiceProcessingOn, 0x0001:Yes */
	0x80, 0x17, 0x00, 0x1A,	/* SetAlgorithmParmID,
0x001A:Use ComfortNoise */
	0x80, 0x18, 0x00, 0x00,	/* SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x04,	/* SetAlgorithmParmID, 0x0004:Use AGC */
	0x80, 0x18, 0x00, 0x00,	/* SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x00,	/* SetAlgorithmParmID, 0x0000:Suppression
Strength */
	0x80, 0x18, 0x00, 0x04,	/* SetAlgorithmParm, 0x0004:20dB Max
Suppression */
	0x80, 0x1B, 0x00, 0x0C,	/* SetDigitalInputGain, 0x00:Primay Mic (Tx),
0x0C:(12 dB) */
	0x80, 0x1B, 0x01, 0x0C,	/* SetDigitalInputGain,0x01:Secondary Mic (Tx),
0x0C:(12 dB) */
	0x80, 0x15, 0x00, 0x00,	/* SetDigitalOutputGain, 0x00:Tx, 0x00:(0 dB) */
};

unsigned char vr_ns_headset[] = {
	0x80, 0x17, 0x00, 0x02,	/* SetAlgorithmParmID, 0x0002:Microphone
Configuration */
	0x80, 0x18, 0x00, 0x03,	/* SetAlgorithmParm, 0x0003:1-mic
External (MD) */
	0x80, 0x26, 0x00, 0x15,	/* SelectRouting,
0x0015:Snk,Pri,Snk,Snk - Csp,Zro,Zro (none) */
	0x80, 0x1C, 0x00, 0x01,	/* VoiceProcessingOn, 0x0001:Yes */
	0x80, 0x17, 0x00, 0x00,	/* SetAlgorithmParmID, 0x0000:Suppression
Strength */
	0x80, 0x18, 0x00, 0x02,	/* SetAlgorithmParm, 0x0002:20dB Max
Suppression */
	0x80, 0x17, 0x00, 0x1A,	/* SetAlgorithmParmID, 0x001A:Use ComfortNoise*/
	0x80, 0x18, 0x00, 0x00,	/* SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x04,	/* SetAlgorithmParmID, 0x0004:Use AGC */
	0x80, 0x18, 0x00, 0x00,	/* SetAlgorithmParm, 0x0000:No */
	0x80, 0x1B, 0x00, 0x12,	/* SetDigitalInputGain, 0x00:Primay Mic (Tx),
0x12:(18 dB) */
	0x80, 0x15, 0x00, 0x00,	/* SetDigitalOutputGain, 0x00:Tx, 0x00:(0 dB) */
};

unsigned char vr_ns_speaker[] = {
	0x80, 0x17, 0x00, 0x02,	/* SetAlgorithmParmID, 0x0002:Microphone
Configuration */
	0x80, 0x18, 0x00, 0x02,	/* SetAlgorithmParm,
0x0002:1-mic Desktop/Vehicle (DV) */
	0x80, 0x1C, 0x00, 0x01,	/* VoiceProcessingOn, 0x0001:Yes */
	0x80, 0x17, 0x00, 0x00,	/* SetAlgorithmParmID, 0x0000:Suppression
Strength */
	0x80, 0x18, 0x00, 0x04,	/* SetAlgorithmParm, 0x0004:20dB Max
Suppression */
	0x80, 0x17, 0x00, 0x04,	/* SetAlgorithmParmID, 0x0004:Use AGC */
	0x80, 0x18, 0x00, 0x00,	/* SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x1A,	/* SetAlgorithmParmID, 0x001A:Use
ComfortNoise */
	0x80, 0x18, 0x00, 0x00,	/* SetAlgorithmParm, 0x0000:No */
	0x80, 0x1B, 0x00, 0x0C,	/* SetDigitalInputGain, 0x00:Primay Mic (Tx),
0x0C:(12 dB) */
	0x80, 0x15, 0x00, 0x00,	/* SetDigitalOutputGain, 0x00:Tx, 0x00:(0 dB) */
};

unsigned char vr_ns_bt[] = {
	0x80, 0x26, 0x00, 0x06,	/* SelectRouting,
0x0006:Snk,Snk,Fei,Pri - Zro,Csp,Feo (PCM0->PCM1+ADCs) */
	0x80, 0x1C, 0x00, 0x01,	/* VoiceProcessingOn, 0x0001:Yes */
	0x80, 0x17, 0x00, 0x00,	/* SetAlgorithmParmID,
0x0000:Suppression Strength */
	0x80, 0x18, 0x00, 0x02,	/* SetAlgorithmParm, 0x0002:20dB Max
Suppression */
	0x80, 0x17, 0x00, 0x04,	/* SetAlgorithmParmID, 0x0004:Use AGC */
	0x80, 0x18, 0x00, 0x00,	/* SetAlgorithmParm, 0x0000:No */
	0x80, 0x17, 0x00, 0x1A,	/* SetAlgorithmParmID,0x001A:Use ComfortNoise */
	0x80, 0x18, 0x00, 0x00,	/* SetAlgorithmParm, 0x0000:No */
	0x80, 0x1B, 0x00, 0x00,	/* SetDigitalInputGain, 0x00:Primay Mic (Tx),
0x00:(0 dB) */
	0x80, 0x15, 0x00, 0x00,	/* SetDigitalOutputGain, 0x00:Tx, 0x00:(0 dB) */
};


static u8 a2220_firmware_buf[] = {
	0x41, 0x55, 0x44, 0x49, 0x45, 0x4E, 0x43, 0x45, 0x00, 0x00, 0x00, 0x00,
	0x06, 0x00, 0x00, 0x00, 0x84, 0x03, 0x08, 0x20, 0x9C, 0x01, 0x00, 0x00,
	0x00, 0x01, 0x05, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xD8, 0xE3, 0x07, 0x20, 0xD3, 0x75, 0xB5, 0xD3, 0x04, 0x00, 0x00, 0x00,
	0x90, 0x18, 0x05, 0x20, 0x60, 0x0C, 0x05, 0x20, 0x00, 0x20, 0x00, 0x40,
	0x1C, 0x09, 0x18, 0x20, 0x00, 0x00, 0x00, 0x00, 0x42, 0x4F, 0x53, 0x4B,
	0x4F, 0x5F, 0x4C, 0x41, 0x42, 0x45, 0x4C, 0x3A, 0x42, 0x4F, 0x53, 0x4B,
	0x4F, 0x5F, 0x36, 0x30, 0x2E, 0x30, 0x33, 0x2E, 0x34, 0x30, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x48, 0x57, 0x43, 0x3A, 0x24, 0x43, 0x68, 0x61,
	0x6E, 0x67, 0x65, 0x3A, 0x20, 0x31, 0x31, 0x33, 0x37, 0x31, 0x37, 0x20,
	0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x68, 0x77, 0x63, 0x5F, 0x4E, 0x56, 0x69, 0x64, 0x69, 0x61, 0x5F, 0x57,
	0x61, 0x79, 0x6E, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x6E, 0x6F, 0x3A,
	0x31, 0x33, 0x38, 0x31, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x90, 0x01, 0x90, 0x01, 0x90, 0x01, 0x90, 0x01, 0x78, 0x00, 0x78, 0x00,
	0x90, 0x01, 0x90, 0x01, 0x78, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x44, 0x0B, 0x08, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x34, 0x07, 0x08, 0x20, 0x98, 0x0A, 0x08, 0x20, 0xA4, 0x09, 0x08, 0x20,
	0x44, 0x08, 0x08, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xAC, 0x0E, 0x08, 0x20, 0x30, 0x0E, 0x08, 0x20, 0x5C, 0x04, 0x08, 0x20,
	0x10, 0x06, 0x08, 0x20, 0xAC, 0x05, 0x08, 0x20, 0x78, 0x05, 0x08, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x40, 0x05, 0x08, 0x20, 0x28, 0x05, 0x08, 0x20,
	0xB8, 0x04, 0x08, 0x20, 0x74, 0x04, 0x08, 0x20, 0xF4, 0x0D, 0x08, 0x20,
	0xBC, 0x0D, 0x08, 0x20, 0xC4, 0x03, 0x08, 0x20, 0xA4, 0x03, 0x08, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x64, 0x0A, 0x08, 0x20, 0xE4, 0x03, 0x08, 0x20, 0x0C, 0x0A, 0x08, 0x20,
	0x4C, 0x0A, 0x08, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xE4, 0x09, 0x08, 0x20, 0x00, 0x00, 0x00, 0x00,
	0xCC, 0x09, 0x08, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1C, 0x08, 0x08, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x05, 0x08, 0x20,
	0x9C, 0x04, 0x08, 0x20, 0x54, 0x0E, 0x08, 0x20, 0x58, 0x0D, 0x08, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x28, 0x0D, 0x08, 0x20, 0x38, 0x0D, 0x08, 0x20, 0x90, 0x58, 0x08, 0x20,
	0xF0, 0x57, 0x08, 0x20, 0x14, 0x07, 0x08, 0x20, 0xF4, 0x06, 0x08, 0x20,
	0xD4, 0x06, 0x08, 0x20, 0x50, 0x07, 0x08, 0x20, 0xDC, 0x07, 0x08, 0x20,
	0x5C, 0x0B, 0x08, 0x20, 0xA0, 0x06, 0x08, 0x20, 0x84, 0x06, 0x08, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x94, 0x03, 0x08, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x06, 0x08, 0x20,
	0x58, 0x06, 0x08, 0x20, 0x0C, 0x0D, 0x08, 0x20, 0xF4, 0x0C, 0x08, 0x20,
	0xDC, 0x0C, 0x08, 0x20, 0xC8, 0x0C, 0x08, 0x20, 0x98, 0x0A, 0x08, 0x20,
	0xA4, 0x09, 0x08, 0x20, 0x44, 0x08, 0x08, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x1C, 0x0D, 0x05, 0x20, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1F, 0x00, 0x24, 0x0D, 0x05, 0x20, 0x00, 0x00, 0x20, 0x00,
	0x28, 0x0D, 0x05, 0x20, 0x00, 0x00, 0x20, 0x00, 0x38, 0x0D, 0x05, 0x20,
	0x00, 0x00, 0x03, 0x00, 0x38, 0x0D, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00,
	0x38, 0x0D, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00, 0x38, 0x0D, 0x05, 0x20,
	0x00, 0x00, 0x01, 0x00, 0x5C, 0x0F, 0x05, 0x20, 0x00, 0x00, 0x1F, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x64, 0x0F, 0x05, 0x20,
	0x00, 0x00, 0x20, 0x00, 0x68, 0x0F, 0x05, 0x20, 0x00, 0x00, 0x20, 0x00,
	0x78, 0x0F, 0x05, 0x20, 0x00, 0x00, 0x03, 0x00, 0x78, 0x0F, 0x05, 0x20,
	0x00, 0x00, 0x01, 0x00, 0x78, 0x0F, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00,
	0x78, 0x0F, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00, 0x9C, 0x11, 0x05, 0x20,
	0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00,
	0xA4, 0x11, 0x05, 0x20, 0x00, 0x00, 0x20, 0x00, 0xA8, 0x11, 0x05, 0x20,
	0x00, 0x00, 0x20, 0x00, 0xB8, 0x11, 0x05, 0x20, 0x00, 0x00, 0x03, 0x00,
	0xB8, 0x11, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00, 0xB8, 0x11, 0x05, 0x20,
	0x00, 0x00, 0x01, 0x00, 0xB8, 0x11, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00,
	0xDC, 0x13, 0x05, 0x20, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1F, 0x00, 0xE4, 0x13, 0x05, 0x20, 0x00, 0x00, 0x20, 0x00,
	0xE8, 0x13, 0x05, 0x20, 0x00, 0x00, 0x20, 0x00, 0xF8, 0x13, 0x05, 0x20,
	0x00, 0x00, 0x03, 0x00, 0xF8, 0x13, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00,
	0xF8, 0x13, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00, 0xF8, 0x13, 0x05, 0x20,
	0x00, 0x00, 0x01, 0x00, 0xB0, 0x0B, 0x05, 0x20, 0x00, 0x00, 0x0E, 0x00,
	0xBC, 0x0B, 0x05, 0x20, 0x00, 0x00, 0x0E, 0x00, 0xC8, 0x0B, 0x05, 0x20,
	0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xD8, 0x0B, 0x05, 0x20, 0x00, 0x00, 0x0E, 0x00, 0xE0, 0x0B, 0x05, 0x20,
	0x00, 0x00, 0x09, 0x00, 0xE4, 0x0B, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00,
	0x40, 0x0C, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00, 0x48, 0x0C, 0x05, 0x20,
	0x00, 0x00, 0x10, 0x00, 0x4C, 0x0C, 0x05, 0x20, 0x00, 0x00, 0x04, 0x00,
	0x50, 0x0C, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00, 0x38, 0x0C, 0x05, 0x20,
	0x00, 0x00, 0x01, 0x00, 0xD4, 0x0B, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00,
	0xDC, 0x0B, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00, 0xE8, 0x0B, 0x05, 0x20,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xF0, 0x0B, 0x05, 0x20, 0x00, 0x00, 0x0E, 0x00, 0xF8, 0x0B, 0x05, 0x20,
	0x00, 0x00, 0x09, 0x00, 0xFC, 0x0B, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00,
	0x44, 0x0C, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00, 0x48, 0x0C, 0x05, 0x20,
	0x00, 0x00, 0x10, 0x00, 0x4C, 0x0C, 0x05, 0x20, 0x00, 0x00, 0x04, 0x00,
	0x50, 0x0C, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00, 0x3C, 0x0C, 0x05, 0x20,
	0x00, 0x00, 0x01, 0x00, 0xEC, 0x0B, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00,
	0xF4, 0x0B, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00, 0x00, 0x0C, 0x05, 0x20,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x30, 0x0C, 0x05, 0x20, 0x00, 0x00, 0x0E, 0x00, 0x2C, 0x0C, 0x05, 0x20,
	0x00, 0x00, 0x01, 0x00, 0x48, 0x0C, 0x05, 0x20, 0x00, 0x00, 0x10, 0x00,
	0x50, 0x0C, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00, 0x24, 0x0C, 0x05, 0x20,
	0x00, 0x00, 0x01, 0x00, 0x28, 0x0C, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00,
	0x34, 0x0C, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x0C, 0x05, 0x20, 0x00, 0x00, 0x0E, 0x00,
	0x0C, 0x0C, 0x05, 0x20, 0x00, 0x00, 0x04, 0x00, 0x40, 0x0C, 0x05, 0x20,
	0x00, 0x00, 0x01, 0x00, 0x50, 0x0C, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00,
	0x38, 0x0C, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00, 0x04, 0x0C, 0x05, 0x20,
	0x00, 0x00, 0x01, 0x00, 0x10, 0x0C, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x0C, 0x05, 0x20,
	0x00, 0x00, 0x0E, 0x00, 0x1C, 0x0C, 0x05, 0x20, 0x00, 0x00, 0x04, 0x00,
	0x44, 0x0C, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00, 0x50, 0x0C, 0x05, 0x20,
	0x00, 0x00, 0x01, 0x00, 0x3C, 0x0C, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00,
	0x14, 0x0C, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00, 0x20, 0x0C, 0x05, 0x20,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x03, 0x05, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x03, 0x05, 0x20,
	0x08, 0x00, 0x00, 0x00, 0xD0, 0x03, 0x05, 0x20, 0x08, 0x00, 0x00, 0x00,
	0x10, 0x04, 0x05, 0x20, 0x08, 0x00, 0x00, 0x00, 0x50, 0x04, 0x05, 0x20,
	0x08, 0x00, 0x00, 0x00, 0x90, 0x04, 0x05, 0x20, 0x01, 0x00, 0x00, 0x00,
	0x98, 0x04, 0x05, 0x20, 0x01, 0x00, 0x00, 0x00, 0xB0, 0x04, 0x05, 0x20,
	0x0B, 0x00, 0x00, 0x00, 0x10, 0x05, 0x05, 0x20, 0x0B, 0x00, 0x00, 0x00,
	0x70, 0x05, 0x05, 0x20, 0x07, 0x00, 0x00, 0x00, 0xA0, 0x04, 0x05, 0x20,
	0x01, 0x00, 0x00, 0x00, 0xB0, 0x05, 0x05, 0x20, 0x07, 0x00, 0x00, 0x00,
	0xF0, 0x05, 0x05, 0x20, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0C, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00,
	0x05, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x41, 0x36, 0x30, 0x2E, 0x30, 0x33, 0x2E, 0x34, 0x30, 0x5F, 0x42, 0x31,
	0x33, 0x38, 0x31, 0x32, 0x5F, 0x4E, 0x56, 0x69, 0x64, 0x69, 0x61, 0x5F,
	0x57, 0x61, 0x79, 0x6E, 0x65, 0x5F, 0x4E, 0x42, 0x5F, 0x57, 0x42, 0x5F,
	0x49, 0x32, 0x43, 0x5F, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4D, 0x49, 0x4E,
	0x47, 0x5F, 0x4D, 0x43, 0x46, 0x46, 0x69, 0x6C, 0x6C, 0x49, 0x6E, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xB4, 0x54, 0xA8, 0x3A, 0xC3, 0x43, 0x20, 0x34,
	0x40, 0x1A, 0x05, 0x20, 0x28, 0x82, 0x05, 0x20, 0xD4, 0x00, 0x00, 0x00,
	0x70, 0x07, 0x05, 0x20, 0x50, 0x1A, 0x05, 0x20, 0x20, 0x07, 0x05, 0x20,
	0x00, 0x0F, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00,
	0x44, 0x6F, 0x05, 0x20, 0xC4, 0x6E, 0x05, 0x20, 0x00, 0xF0, 0x00, 0x00,
	0x00, 0x20, 0x00, 0x00, 0xF4, 0x14, 0x05, 0x20, 0x00, 0x0E, 0x00, 0x00,
	0x00, 0x0C, 0x00, 0x00, 0xC0, 0x0A, 0x05, 0x20, 0x00, 0x10, 0x00, 0x00,
	0x04, 0x15, 0x05, 0x20, 0x06, 0x1C, 0x05, 0x20, 0xFF, 0x7F, 0x00, 0x00,
	0x00, 0x80, 0x00, 0x00, 0x34, 0x04, 0x05, 0x20, 0xD0, 0x0B, 0x05, 0x20,
	0xF8, 0x13, 0x05, 0x20, 0x14, 0x05, 0x05, 0x20, 0xCC, 0x16, 0x05, 0x20,
	0xE0, 0x14, 0x05, 0x20, 0xE0, 0x0A, 0x05, 0x20, 0x04, 0x05, 0x05, 0x20,
	0xFC, 0x0B, 0x05, 0x20, 0x0E, 0x18, 0x05, 0x20, 0x38, 0x04, 0x05, 0x20,
	0x00, 0x00, 0x05, 0x20, 0xE4, 0xE4, 0x00, 0x00, 0x00, 0xFE, 0xFF, 0x0F,
	0xDC, 0x14, 0x05, 0x20, 0xD0, 0x0A, 0x05, 0x20, 0xCD, 0xAB, 0x00, 0x00,
	0xDE, 0xBC, 0x00, 0x00, 0x00, 0xFE, 0xFF, 0x3F, 0x40, 0x1A, 0x05, 0x20,
	0xD4, 0x0A, 0x05, 0x20, 0xFF, 0xFF, 0x00, 0x00, 0x94, 0x6F, 0x05, 0x20,
	0x92, 0x18, 0x05, 0x20, 0xA2, 0x18, 0x05, 0x20, 0x6B, 0x80, 0x00, 0x00,
	0x7C, 0xFF, 0x02, 0x20, 0x24, 0x80, 0x00, 0x00, 0x2C, 0x80, 0x00, 0x00,
	0x32, 0x80, 0x00, 0x00, 0x33, 0x80, 0x00, 0x00, 0x34, 0x80, 0x00, 0x00,
	0x35, 0x80, 0x00, 0x00, 0x36, 0x80, 0x00, 0x00, 0x37, 0x80, 0x00, 0x00,
	0x38, 0x80, 0x00, 0x00, 0x3D, 0x80, 0x00, 0x00, 0x3E, 0x80, 0x00, 0x00,
	0x3F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x30, 0x00,
	0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x20, 0x00,
	0xAB, 0xAA, 0x02, 0x00, 0x0A, 0xE7, 0x02, 0x00, 0x33, 0x33, 0x58, 0x00,
	0x55, 0x55, 0x05, 0x00, 0x14, 0xCE, 0x05, 0x00, 0x9A, 0x19, 0x2C, 0x00,
	0x00, 0x01, 0x05, 0x20, 0x10, 0x01, 0x05, 0x20, 0x64, 0x05, 0x05, 0x20,
	0xF0, 0x14, 0x05, 0x20, 0xEC, 0x14, 0x05, 0x20, 0x00, 0x0E, 0x00, 0x10,
	0x60, 0x0C, 0x05, 0x20, 0xD4, 0x1C, 0x08, 0x20, 0xE8, 0x14, 0x05, 0x20,
	0x12, 0x34, 0x00, 0x00, 0x0C, 0x17, 0x05, 0x20, 0xEC, 0x17, 0x05, 0x20,
	0xDC, 0x17, 0x05, 0x20, 0x40, 0x1F, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x40,
	0x80, 0x3E, 0x00, 0x00, 0x44, 0xAC, 0x00, 0x00, 0x80, 0xBB, 0x00, 0x00,
	0x20, 0x01, 0x05, 0x20, 0x04, 0x1C, 0x05, 0x20, 0xE0, 0x59, 0x05, 0x20,
	0x60, 0x1D, 0x05, 0x20, 0x70, 0x46, 0x00, 0x00, 0x44, 0x17, 0x05, 0x20,
	0xA0, 0x23, 0x05, 0x20, 0x40, 0x6D, 0x05, 0x20, 0xB4, 0x6F, 0x05, 0x20,
	0x6E, 0xDB, 0xFE, 0xFF, 0x6E, 0xDB, 0xDE, 0x00, 0xC8, 0x6E, 0x05, 0x20,
	0xC2, 0x18, 0x05, 0x20, 0x20, 0x14, 0x05, 0x20, 0x08, 0x18, 0x05, 0x20,
	0x80, 0x69, 0x05, 0x20, 0x74, 0x17, 0x05, 0x20, 0x7C, 0x18, 0x05, 0x20,
	0xC0, 0x60, 0x05, 0x20, 0x00, 0x62, 0x05, 0x20, 0x40, 0x68, 0x05, 0x20,
	0x40, 0x63, 0x05, 0x20, 0x80, 0x64, 0x05, 0x20, 0x70, 0x56, 0x00, 0x00,
	0xF0, 0x55, 0x00, 0x00, 0x74, 0x6F, 0x05, 0x20, 0x70, 0x55, 0x00, 0x00,
	0x00, 0x19, 0x05, 0x20, 0x20, 0x1D, 0x05, 0x20, 0x80, 0x2C, 0x05, 0x20,
	0x40, 0x60, 0x05, 0x20, 0xC0, 0x6F, 0x05, 0x20, 0x90, 0x19, 0x05, 0x20,
	0x70, 0x71, 0x05, 0x20, 0x30, 0x72, 0x05, 0x20, 0xD0, 0x72, 0x05, 0x20,
	0xFF, 0xF7, 0xFF, 0xFF, 0xCC, 0x14, 0x05, 0x20, 0xF0, 0x0C, 0x05, 0x20,
	0xB0, 0x01, 0x05, 0x20, 0x12, 0x83, 0x00, 0x40, 0x18, 0x16, 0x05, 0x20,
	0x70, 0x19, 0x05, 0x20, 0x03, 0x20, 0x00, 0x00, 0xEC, 0x15, 0x08, 0x20,
	0xE4, 0x3A, 0x08, 0x20, 0x40, 0x1A, 0x08, 0x20, 0xB0, 0x34, 0x08, 0x20,
	0xBC, 0x1A, 0x08, 0x20, 0xC0, 0x11, 0x08, 0x20, 0x64, 0x11, 0x08, 0x20,
	0x64, 0x0F, 0x08, 0x20, 0xF4, 0x40, 0x08, 0x20, 0xB8, 0x23, 0x08, 0x20,
	0x74, 0x24, 0x08, 0x20, 0x78, 0x1A, 0x05, 0x20, 0x7C, 0x11, 0x08, 0x20,
	0x00, 0x2C, 0x08, 0x20, 0x7C, 0x26, 0x08, 0x20, 0xB0, 0x14, 0x08, 0x20,
	0x64, 0x2A, 0x05, 0x20, 0x80, 0x1A, 0x05, 0x20, 0x00, 0xF8, 0x24, 0x01,
	0xDC, 0x1A, 0x08, 0x20, 0xF8, 0x1A, 0x08, 0x20, 0xC0, 0x70, 0x05, 0x20,
	0x46, 0x5F, 0x05, 0x20, 0x40, 0x71, 0x05, 0x20, 0xD0, 0x19, 0x05, 0x20,
	0x44, 0x1A, 0x05, 0x20, 0x91, 0x1A, 0x05, 0x20, 0x00, 0x08, 0x00, 0x00,
	0x00, 0x12, 0x00, 0x00, 0xCC, 0x6F, 0x05, 0x20, 0xB0, 0x55, 0xFF, 0xFF,
	0xF0, 0x23, 0x00, 0x00, 0xC0, 0xC7, 0xFF, 0xFF, 0x80, 0x0C, 0x00, 0x00,
	0xE0, 0xE3, 0xFF, 0xFF, 0xFE, 0x17, 0x05, 0x20, 0x00, 0x00, 0x01, 0x00,
	0x58, 0x0C, 0x05, 0x20, 0x88, 0x0C, 0x05, 0x20, 0x1C, 0x0B, 0x05, 0x20,
	0x2C, 0x16, 0x05, 0x20, 0xEC, 0x0A, 0x05, 0x20, 0xE8, 0x57, 0x08, 0x20,
	0xD0, 0x0E, 0x08, 0x20, 0x00, 0x00, 0x11, 0x00, 0xC4, 0x14, 0x05, 0x20,
	0x04, 0x17, 0x05, 0x20, 0xE0, 0x15, 0x05, 0x20, 0x00, 0x09, 0x00, 0x00,
	0x8C, 0x03, 0x08, 0x20, 0x06, 0x00, 0x44, 0x00, 0x07, 0x00, 0x19, 0x00,
	0x3C, 0xF4, 0xFD, 0x3F, 0xF0, 0x49, 0x18, 0x20, 0x90, 0x1B, 0x08, 0x20,
	0x70, 0x1A, 0x05, 0x20, 0x14, 0x4A, 0x08, 0x20, 0x20, 0x5A, 0x08, 0x20,
	0x28, 0x57, 0x08, 0x20, 0xCC, 0x21, 0x08, 0x20, 0x40, 0x1A, 0x05, 0x20,
	0x28, 0x82, 0x05, 0x20, 0x70, 0x07, 0x05, 0x20, 0x40, 0x1A, 0x05, 0x20,
	0x48, 0x60, 0x08, 0x20, 0x68, 0x6B, 0x08, 0x20, 0x18, 0x5E, 0x08, 0x20,
	0x14, 0x23, 0x08, 0x20, 0x00, 0x00, 0x18, 0x20, 0x00, 0x00, 0x02, 0x00,
	0x20, 0x82, 0x05, 0x20, 0x28, 0x62, 0x08, 0x20, 0x34, 0x63, 0x08, 0x20,
	0x20, 0x66, 0x08, 0x20, 0x60, 0x67, 0x08, 0x20, 0xB8, 0x64, 0x08, 0x20,
	0xB0, 0x67, 0x08, 0x20, 0x24, 0x82, 0x05, 0x20, 0x63, 0x72, 0x73, 0x61,
	0x00, 0x00, 0x10, 0x01, 0xF0, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x50, 0x01,
	0x02, 0x00, 0x00, 0x00, 0xC0, 0x0A, 0x05, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xDC, 0x03, 0x00, 0x00, 0xD0, 0x0A, 0x05, 0x20,
	0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0xFF, 0xFF, 0xFE, 0x87, 0x00, 0x00, 0x01, 0x68, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xF0, 0xFF, 0x00, 0x00, 0xFC, 0xFF, 0xD0, 0x6F, 0x30, 0x06, 0x00, 0x00,
	0x30, 0x06, 0x00, 0x00, 0xB5, 0xD3, 0x75, 0xB5, 0x04, 0x00, 0x00, 0x00,
	0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
	0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0x00, 0x00, 0x00, 0x8F, 0x6F, 0x03, 0x00, 0x96, 0x8F, 0x0C, 0x00,
	0xBF, 0xE6, 0x00, 0x00, 0x44, 0x4D, 0x07, 0x00, 0x05, 0xD3, 0x02, 0x00,
	0xE8, 0x3A, 0x08, 0x00, 0x43, 0x84, 0x0C, 0x00, 0x66, 0x5D, 0x0F, 0x00,
	0x57, 0xC6, 0x00, 0x00, 0xFA, 0x83, 0x05, 0x00, 0x48, 0x99, 0x0A, 0x00,
	0x84, 0x0D, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xD5, 0x75, 0xB5, 0xD3, 0x0C, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x75, 0x75, 0x75, 0xB5, 0x0C, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x75, 0x75, 0xD3, 0xDF, 0x0C, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x75, 0x75, 0x75, 0xD3, 0x01, 0x00, 0x00, 0x00,
	0x0C, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x0C, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0xD3, 0x75, 0x75, 0xB5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xAF, 0x01, 0x00, 0x00, 0xFA, 0x01, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00,
	0x8C, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x75, 0xD3, 0x75, 0xB5,
	0x00, 0xF8, 0x24, 0x01, 0x01, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
	0x10, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
	0x19, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0xFA, 0x00, 0x00, 0x00,
	0x02, 0x00, 0x00, 0x00, 0x10, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
	0x18, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
	0x18, 0x00, 0x00, 0x00, 0xD5, 0x75, 0x75, 0xB5, 0x1A, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
	0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
	0x1F, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x0B, 0x00, 0x00, 0x00,
	0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00,
	0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00,
	0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00,
	0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00,
	0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00,
	0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
	0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00,
	0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00,
	0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00,
	0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00,
	0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00,
	0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00,
	0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00,
	0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x13, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00,
	0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00,
	0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x00,
	0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00,
	0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00,
	0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00,
	0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00,
	0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00,
	0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
	0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00,
	0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00,
	0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00,
	0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00,
	0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00,
	0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00,
	0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00,
	0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x13, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00,
	0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00,
	0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x00,
	0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00,
	0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00,
	0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00,
	0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00,
	0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00,
	0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
	0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00,
	0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00,
	0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00,
	0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00,
	0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00,
	0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00,
	0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00,
	0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x13, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00,
	0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00,
	0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x00,
	0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00,
	0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00,
	0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00,
	0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00,
	0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00,
	0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
	0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00,
	0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00,
	0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00,
	0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00,
	0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00,
	0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00,
	0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00,
	0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x13, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00,
	0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x03, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x35, 0x0F, 0x00, 0x00,
	0x82, 0x00, 0x00, 0x00, 0x0C, 0x17, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
	0x18, 0x0D, 0x05, 0x20, 0x58, 0x0F, 0x05, 0x20, 0x98, 0x11, 0x05, 0x20,
	0xD8, 0x13, 0x05, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x10, 0x00,
	0x20, 0x00, 0x10, 0x00, 0x20, 0x00, 0x10, 0x00, 0x20, 0x00, 0x10, 0x00,
	0x20, 0x00, 0x10, 0x00, 0x20, 0x00, 0x10, 0x00, 0x20, 0x00, 0x10, 0x00,
	0x20, 0x00, 0x10, 0x00, 0xF0, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0x0D, 0x00, 0x0D, 0x00, 0x0B, 0x00, 0x0B, 0x00,
	0x0C, 0x00, 0x0C, 0x00, 0x0A, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x40, 0x01, 0x00, 0x00, 0x40, 0x01, 0x00, 0x00, 0xA0, 0x00, 0x00, 0x00,
	0xA0, 0x00, 0x00, 0x00, 0xA0, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x00,
	0x40, 0x1F, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x1C, 0x09, 0x18, 0x20,
	0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0xA0, 0xE6, 0x07, 0x20, 0xE0, 0xE5, 0x07, 0x20, 0x64, 0x00, 0x00, 0x00,
	0x74, 0x88, 0x18, 0x20, 0x98, 0x8B, 0x18, 0x20, 0x01, 0x00, 0x00, 0x00,
	0x80, 0xE5, 0x07, 0x20, 0xA0, 0xE5, 0x07, 0x20, 0x50, 0xE5, 0x07, 0x20,
	0x19, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x00, 0x40, 0x1F, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0x00, 0x00, 0x00,
	0x80, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x20, 0x01, 0x1C, 0x0F, 0x15, 0x00, 0x28, 0x01, 0x03, 0x01, 0x1A, 0x00,
	0x09, 0x01, 0x02, 0x02, 0x30, 0x00, 0x0E, 0x01, 0x04, 0x01, 0x31, 0x00,
	0x00, 0x06, 0x1F, 0x01, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x80, 0x00, 0x00,
	0x1B, 0x80, 0x00, 0x01, 0x1B, 0x80, 0x00, 0x02, 0x1B, 0x80, 0x00, 0x03,
	0x15, 0x80, 0x00, 0x00, 0x26, 0x80, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x1C, 0x0F, 0x15, 0x00, 0x28, 0x01,
	0x03, 0x00, 0x1A, 0x01, 0x09, 0x00, 0x02, 0x03, 0x30, 0x00, 0x0E, 0x01,
	0x04, 0x01, 0x31, 0x00, 0x00, 0x06, 0x1F, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x1B, 0x80, 0x00, 0x00, 0x1B, 0x80, 0x00, 0x01, 0x1B, 0x80, 0x00, 0x02,
	0x1B, 0x80, 0x00, 0x03, 0x15, 0x80, 0x00, 0x00, 0x26, 0x80, 0x12, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x1C, 0x0F,
	0x15, 0x01, 0x28, 0x01, 0x03, 0x00, 0x1A, 0x01, 0x09, 0x01, 0x02, 0x00,
	0x30, 0x00, 0x0E, 0x01, 0x04, 0x01, 0x31, 0x00, 0x00, 0x06, 0x1F, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x1B, 0x80, 0x00, 0x00, 0x1B, 0x80, 0x00, 0x01,
	0x1B, 0x80, 0x00, 0x02, 0x1B, 0x80, 0x00, 0x03, 0x15, 0x80, 0x00, 0x00,
	0x26, 0x80, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x20, 0x01, 0x1C, 0x0F, 0x15, 0x02, 0x28, 0x01, 0x03, 0x00, 0x1A, 0x01,
	0x09, 0x00, 0x02, 0x03, 0x30, 0x00, 0x0E, 0x01, 0x04, 0x01, 0x31, 0x00,
	0x00, 0x06, 0x1F, 0x01, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x80, 0x00, 0x00,
	0x1B, 0x80, 0x00, 0x01, 0x1B, 0x80, 0x00, 0x02, 0x1B, 0x80, 0x00, 0x03,
	0x15, 0x80, 0x00, 0x00, 0x26, 0x80, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x06, 0x00,
	0x90, 0x17, 0x05, 0x20, 0x00, 0x00, 0x00, 0x00, 0xB0, 0x17, 0x05, 0x20,
	0x03, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x06, 0x00, 0xD0, 0x17, 0x05, 0x20,
	0x00, 0x00, 0x00, 0x00, 0xF0, 0x17, 0x05, 0x20, 0x00, 0x00, 0x0E, 0x00,
	0x00, 0x00, 0x06, 0x00, 0x10, 0x18, 0x05, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x30, 0x18, 0x05, 0x20, 0x02, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x06, 0x00,
	0x50, 0x18, 0x05, 0x20, 0x00, 0x00, 0x00, 0x00, 0x70, 0x18, 0x05, 0x20,
	0xB5, 0xD3, 0x75, 0xD3, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0xAA, 0xA2, 0xAA,
	0xB7, 0xBB, 0xB6, 0xBB, 0x62, 0x62, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0xA0, 0xAA, 0xA2, 0xAA, 0xB7, 0xBB, 0xB6, 0xBB, 0x62, 0x62, 0x00, 0x00,
	0x09, 0x00, 0x00, 0x00, 0xAA, 0x54, 0xAA, 0xAA, 0xBB, 0xBB, 0xBB, 0x98,
	0x56, 0x26, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x93, 0x00, 0x00, 0x00,
	0xE0, 0x2C, 0x05, 0x20, 0x20, 0x33, 0x05, 0x20, 0x60, 0x39, 0x05, 0x20,
	0xA0, 0x3F, 0x05, 0x20, 0xE0, 0x45, 0x05, 0x20, 0xC0, 0x47, 0x05, 0x20,
	0xA0, 0x49, 0x05, 0x20, 0xE0, 0x4F, 0x05, 0x20, 0x20, 0x56, 0x05, 0x20,
	0x00, 0x58, 0x05, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
	0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x04, 0x00, 0x05, 0x00, 0x08, 0x00, 0x09, 0x00, 0x0C, 0x00, 0x0D, 0x00,
	0x02, 0x00, 0x03, 0x00, 0x06, 0x00, 0x07, 0x00, 0x0A, 0x00, 0x0B, 0x00,
	0x0E, 0x00, 0x0F, 0x00, 0x40, 0x01, 0x40, 0x01, 0x40, 0x01, 0x40, 0x01,
	0x40, 0x01, 0x40, 0x01, 0x40, 0x01, 0x40, 0x01, 0x00, 0x00, 0x01, 0x00,
	0x02, 0x00, 0x03, 0x00, 0x04, 0x00, 0x05, 0x00, 0x06, 0x00, 0x07, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00, 0x04, 0x00, 0x05, 0x00,
	0x06, 0x00, 0x07, 0x00, 0x0A, 0x00, 0x0A, 0x00, 0x0B, 0x00, 0x0B, 0x00,
	0x0C, 0x00, 0x0C, 0x00, 0x0D, 0x00, 0x0D, 0x00, 0x0A, 0x00, 0x0A, 0x00,
	0x0B, 0x00, 0x0B, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0D, 0x00, 0x0D, 0x00,
	0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00,
	0x0B, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x08, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
	0x05, 0x00, 0x00, 0x00, 0xFA, 0x19, 0x00, 0x00, 0x80, 0x03, 0x08, 0x20,
	0x48, 0x60, 0x08, 0x20, 0x21, 0xFF, 0xFF, 0xA0, 0x02, 0x00, 0x00, 0x00,
	0x36, 0x41, 0x00, 0x0C, 0x02, 0x1D, 0xF0, 0x00, 0x36, 0x41, 0x00, 0x4D,
	0x02, 0x28, 0x12, 0x29, 0x04, 0x0C, 0x72, 0x1D, 0xF0, 0x00, 0x00, 0x00,
	0x36, 0x41, 0x00, 0x61, 0xF2, 0x40, 0x42, 0x26, 0xB1, 0x32, 0x26, 0xB0,
	0x1B, 0x84, 0x4A, 0x33, 0x32, 0x03, 0x00, 0x39, 0x02, 0x0C, 0x72, 0x8C,
	0x13, 0x82, 0x66, 0xB1, 0x1D, 0xF0, 0x00, 0x00, 0x36, 0x41, 0x00, 0x0C,
	0x16, 0x4D, 0x02, 0x31, 0xE9, 0x40, 0x21, 0xE9, 0x40, 0x22, 0x63, 0xB0,
	0x52, 0x02, 0x00, 0x0C, 0x72, 0x59, 0x04, 0x50, 0x56, 0x93, 0x52, 0x63,
	0xB1, 0x1D, 0xF0, 0x00, 0x36, 0x61, 0x00, 0xA8, 0x02, 0xA5, 0x31, 0x05,
	0x2D, 0x0A, 0x26, 0x0A, 0x65, 0x1C, 0x9A, 0x0C, 0x4C, 0xD1, 0xE0, 0x40,
	0x31, 0xDE, 0x40, 0xED, 0x01, 0x88, 0x03, 0x0C, 0x0B, 0x82, 0x28, 0x10,
	0xB9, 0x01, 0xE0, 0x08, 0x00, 0xAD, 0x02, 0x65, 0x36, 0x00, 0x8C, 0x5A,
	0x98, 0x01, 0x2C, 0xCA, 0xA7, 0x19, 0x3F, 0x1C, 0x9A, 0x0C, 0x0B, 0x0C,
	0x4C, 0xD1, 0xD7, 0x40, 0x4B, 0xE1, 0x88, 0x03, 0x0C, 0x19, 0x82, 0x28,
	0x10, 0x99, 0x11, 0xE0, 0x08, 0x00, 0xA8, 0x11, 0xF8, 0x03, 0x9C, 0x2A,
	0xED, 0x02, 0x1C, 0x9A, 0x0C, 0x0B, 0x0C, 0x4C, 0x82, 0x2F, 0x10, 0xD1,
	0xD0, 0x40, 0xE0, 0x08, 0x00, 0x86, 0x02, 0x00, 0xCD, 0x02, 0x0C, 0x1A,
	0x88, 0xFF, 0x1C, 0x9B, 0xE0, 0x08, 0x00, 0x0C, 0x72, 0x1D, 0xF0, 0x0C,
	0x82, 0x1D, 0xF0, 0x00, 0x36, 0x41, 0x00, 0xB8, 0x02, 0x00, 0xAB, 0x23,
	0xB0, 0xB8, 0x74, 0x65, 0x35, 0x04, 0x0C, 0x7C, 0x0C, 0x82, 0xA0, 0x2C,
	0x83, 0x1D, 0xF0, 0x00, 0x36, 0x41, 0x00, 0x48, 0x02, 0x0C, 0x88, 0xF6,
	0x84, 0x11, 0x31, 0xC1, 0x40, 0xC0, 0x44, 0x11, 0x4A, 0x33, 0x0C, 0x04,
	0x32, 0x93, 0x7F, 0x39, 0x02, 0x46, 0x00, 0x00, 0x7C, 0xF4, 0x0C, 0x72,
	0x40, 0x28, 0xA3, 0x1D, 0xF0, 0x00, 0x00, 0x00, 0x36, 0x41, 0x00, 0x0C,
	0x13, 0x51, 0xB3, 0x40, 0x4D, 0x02, 0x58, 0x35, 0x58, 0x35, 0x0C, 0x02,
	0x50, 0x23, 0x83, 0x29, 0x04, 0x0C, 0x72, 0x1D, 0xF0, 0x00, 0x00, 0x00,
	0x36, 0x41, 0x00, 0xA8, 0x02, 0xE5, 0x51, 0x05, 0x81, 0xAC, 0x40, 0x0C,
	0x1A, 0x88, 0x08, 0x1C, 0x9B, 0x88, 0xF8, 0x7C, 0xFC, 0xE0, 0x08, 0x00,
	0x0C, 0x72, 0x1D, 0xF0, 0x36, 0x41, 0x00, 0x51, 0xA6, 0x40, 0x88, 0x75,
	0x42, 0x28, 0x3E, 0x40, 0x44, 0x04, 0xCC, 0x28, 0x0C, 0x02, 0x1D, 0xF0,
	0xF6, 0x92, 0x1F, 0x81, 0xA6, 0x40, 0x80, 0x22, 0xA0, 0xA2, 0x22, 0x7F,
	0x0C, 0x09, 0x96, 0x9A, 0x02, 0xBD, 0x03, 0x65, 0x41, 0x05, 0xD6, 0xCA,
	0x01, 0x7C, 0xF9, 0x92, 0x62, 0x7F, 0x0C, 0x09, 0x46, 0x00, 0x00, 0x0C,
	0x09, 0xA2, 0x25, 0x92, 0x0C, 0x02, 0x8C, 0x6A, 0x8C, 0x09, 0x8C, 0x24,
	0x0C, 0x12, 0x1D, 0xF0, 0x1D, 0xF0, 0x0C, 0x19, 0x46, 0xFA, 0xFF, 0x86,
	0xF9, 0xFF, 0x00, 0x00, 0x36, 0x41, 0x00, 0xB8, 0x02, 0x00, 0xAB, 0x23,
	0xB0, 0xB8, 0x74, 0x25, 0x2D, 0x04, 0x0C, 0x7C, 0x0C, 0x82, 0xA0, 0x2C,
	0x83, 0x1D, 0xF0, 0x00, 0x36, 0x41, 0x00, 0x48, 0x02, 0x0C, 0x88, 0xF6,
	0x84, 0x11, 0x31, 0x8F, 0x40, 0xC0, 0x44, 0x11, 0x4A, 0x33, 0x0C, 0x04,
	0x32, 0x93, 0x7F, 0x39, 0x02, 0x46, 0x00, 0x00, 0x7C, 0xF4, 0x0C, 0x72,
	0x40, 0x28, 0xA3, 0x1D, 0xF0, 0x00, 0x00, 0x00, 0x36, 0x61, 0x00, 0x4D,
	0x02, 0x28, 0x01, 0x29, 0x04, 0x0C, 0x72, 0x1D, 0xF0, 0x00, 0x00, 0x00,
	0x36, 0x41, 0x00, 0xC1, 0x7D, 0x40, 0x92, 0x2C, 0xAF, 0x0C, 0x0A, 0x82,
	0xD9, 0xF0, 0xCC, 0x18, 0x06, 0x02, 0x00, 0x8C, 0xE9, 0xA2, 0xD9, 0xE0,
	0x8C, 0x9A, 0x7C, 0xFA, 0x0C, 0x7B, 0x0C, 0x82, 0xA0, 0x2B, 0x83, 0x1D,
	0xF0, 0xA2, 0x2C, 0xAE, 0xB2, 0x92, 0x00, 0xE5, 0x36, 0x05, 0x86, 0xFA,
	0xFF, 0x00, 0x00, 0x00, 0x36, 0x61, 0x00, 0xA1, 0x77, 0x40, 0x38, 0x02,
	0x51, 0x77, 0x40, 0xA0, 0x43, 0x10, 0x82, 0xD4, 0xF0, 0xCC, 0x38, 0x0C,
	0x7B, 0x06, 0x05, 0x00, 0xA7, 0x03, 0x02, 0x57, 0x94, 0x0C, 0xEC, 0x64,
	0x30, 0xA0, 0xB4, 0xBD, 0x01, 0x65, 0x03, 0x00, 0xC6, 0x08, 0x00, 0x0C,
	0x8B, 0x66, 0x7B, 0x13, 0xA1, 0x65, 0x40, 0x57, 0x94, 0x04, 0x98, 0x02,
	0x86, 0x00, 0x00, 0x30, 0x90, 0xB4, 0x42, 0x6A, 0xAF, 0x92, 0x6A, 0xAE,
	0x2D, 0x0B, 0x1D, 0xF0, 0xAD, 0x03, 0xBD, 0x01, 0xE5, 0x00, 0x00, 0x0C,
	0x7C, 0x0C, 0x8B, 0xA0, 0xBC, 0x83, 0xC6, 0xF4, 0xFF, 0x00, 0x00, 0x00,
	0x36, 0x41, 0x00, 0x0C, 0x02, 0x1D, 0xF0, 0x00, 0x36, 0x61, 0x00, 0xB1,
	0x5E, 0x40, 0xC8, 0x02, 0xB0, 0xAC, 0x10, 0x82, 0xDA, 0xF0, 0xCC, 0x68,
	0x98, 0x01, 0x99, 0x02, 0x0C, 0x72, 0x1D, 0xF0, 0xB7, 0x0C, 0x04, 0xB2,
	0xDA, 0xE0, 0xEC, 0x0B, 0xCC, 0x9A, 0xC0, 0xA0, 0xB4, 0xBD, 0x01, 0x25,
	0xFD, 0xFF, 0x86, 0x01, 0x00, 0xAD, 0x0C, 0xBD, 0x01, 0x65, 0xFC, 0xFF,
	0x8C, 0x2A, 0x0C, 0x82, 0x1D, 0xF0, 0xC8, 0x01, 0xC9, 0x02, 0x0C, 0x72,
	0x1D, 0xF0, 0x0C, 0x82, 0x1D, 0xF0, 0x00, 0x00, 0x36, 0x41, 0x00, 0x4D,
	0x02, 0x21, 0x4D, 0x40, 0x22, 0x22, 0x7F, 0x29, 0x04, 0x0C, 0x72, 0x1D,
	0xF0, 0x00, 0x00, 0x00, 0x36, 0x41, 0x00, 0x48, 0x02, 0x0C, 0x82, 0xB6,
	0x24, 0x01, 0x1D, 0xF0, 0x31, 0x47, 0x40, 0x0C, 0x72, 0x42, 0x63, 0x7F,
	0x1D, 0xF0, 0x00, 0x00, 0x36, 0x41, 0x00, 0xED, 0x02, 0x1C, 0x7A, 0x81,
	0x39, 0x40, 0x0C, 0x0B, 0x88, 0x08, 0x0C, 0x4C, 0x82, 0x28, 0x10, 0x0C,
	0x8D, 0xE0, 0x08, 0x00, 0x0C, 0x72, 0x1D, 0xF0, 0x36, 0x41, 0x00, 0x31,
	0x33, 0x40, 0xD8, 0x03, 0xC8, 0x02, 0xD8, 0xFD, 0x9C, 0x7C, 0x1C, 0xCA,
	0x1C, 0x9B, 0x1C, 0x4C, 0xE0, 0x0D, 0x00, 0xC8, 0x02, 0x88, 0x03, 0x0C,
	0x1A, 0x88, 0xF8, 0x1C, 0x7B, 0xE0, 0x08, 0x00, 0x86, 0x01, 0x00, 0x0C,
	0x1A, 0x1C, 0x7B, 0xE0, 0x0D, 0x00, 0x0C, 0x72, 0x1D, 0xF0, 0x00, 0x00,
	0x36, 0x41, 0x00, 0xED, 0x02, 0x1C, 0x9A, 0x81, 0x25, 0x40, 0x0C, 0x0B,
	0x88, 0x08, 0x0C, 0x4C, 0x82, 0x28, 0x10, 0xD1, 0x2C, 0x40, 0xE0, 0x08,
	0x00, 0x0C, 0x72, 0x1D, 0xF0, 0x00, 0x00, 0x00, 0x36, 0x41, 0x00, 0xE8,
	0x02, 0x1C, 0x9A, 0x81, 0x1D, 0x40, 0x0C, 0x0B, 0x88, 0x08, 0x0C, 0x4C,
	0x82, 0x28, 0x10, 0xD1, 0x25, 0x40, 0xE0, 0x08, 0x00, 0x0C, 0x72, 0x1D,
	0xF0, 0x00, 0x00, 0x00, 0x36, 0x41, 0x00, 0xED, 0x02, 0x1C, 0x9A, 0x81,
	0x15, 0x40, 0x0C, 0x0B, 0x88, 0x08, 0x0C, 0x4C, 0x82, 0x28, 0x10, 0xD1,
	0x15, 0x40, 0xE0, 0x08, 0x00, 0x0C, 0x72, 0x1D, 0xF0, 0x00, 0x00, 0x00,
	0x36, 0x41, 0x00, 0x38, 0x02, 0x0C, 0x84, 0x66, 0x13, 0x0B, 0x81, 0x18,
	0x40, 0x0C, 0x74, 0x88, 0x18, 0x89, 0x02, 0xC6, 0xFF, 0xFF, 0x2D, 0x04,
	0x1D, 0xF0, 0x00, 0x00, 0x36, 0x41, 0x00, 0xED, 0x02, 0x1C, 0x9A, 0x81,
	0x06, 0x40, 0x0C, 0x0B, 0x88, 0x08, 0x0C, 0x4C, 0x82, 0x28, 0x10, 0xD1,
	0x05, 0x40, 0xE0, 0x08, 0x00, 0x0C, 0x72, 0x1D, 0xF0, 0x00, 0x00, 0x00,
	0x36, 0x41, 0x00, 0x51, 0xFF, 0x3F, 0x0C, 0x06, 0x58, 0x75, 0x66, 0x02,
	0x1C, 0x42, 0x25, 0xC5, 0x22, 0x25, 0xC6, 0x0C, 0x48, 0x0C, 0x05, 0x76,
	0xA8, 0x0B, 0x98, 0x02, 0xA8, 0x04, 0x4B, 0x22, 0x4B, 0x44, 0x6A, 0x6A,
	0x5A, 0x59, 0x46, 0x0D, 0x00, 0x00, 0x42, 0x15, 0x16, 0x38, 0x15, 0xC0,
	0x22, 0x11, 0x2A, 0x23, 0x28, 0x02, 0xA6, 0x14, 0x21, 0x0C, 0x06, 0x0C,
	0x05, 0x76, 0x94, 0x17, 0x20, 0x40, 0x34, 0x20, 0x24, 0x21, 0x32, 0xC4,
	0xFC, 0xF6, 0x23, 0x04, 0x1B, 0x55, 0x06, 0x01, 0x00, 0xF6, 0x44, 0x01,
	0x1B, 0x66, 0x3D, 0xF0, 0xC6, 0x00, 0x00, 0x0C, 0x05, 0x0C, 0x06, 0x0C,
	0x02, 0x8C, 0x35, 0x0C, 0x18, 0x60, 0x28, 0x83, 0x1D, 0xF0, 0x00, 0x00,
	0x36, 0x41, 0x00, 0xE8, 0x02, 0x2C, 0xC3, 0x26, 0x8E, 0x0E, 0x26, 0xBE,
	0x0B, 0x3C, 0x08, 0x87, 0x1E, 0x06, 0x37, 0x1E, 0x03, 0x0C, 0x82, 0x1D,
	0xF0, 0x7C, 0xFA, 0xA5, 0xF7, 0xFF, 0xE8, 0x02, 0x8C, 0x1A, 0x37, 0x1E,
	0xEF, 0x1C, 0x9A, 0x81, 0xDB, 0x3F, 0x0C, 0x0B, 0x88, 0x08, 0x0C, 0x4C,
	0x82, 0x28, 0x10, 0xD1, 0xE5, 0x3F, 0xE0, 0x08, 0x00, 0x0C, 0x72, 0x1D,
	0xF0, 0x00, 0x00, 0x00, 0x36, 0x41, 0x00, 0xC8, 0x02, 0x0C, 0x82, 0xC0,
	0x81, 0x64, 0xDC, 0x68, 0xC0, 0x98, 0x74, 0xF6, 0xA9, 0x11, 0x81, 0xD0,
	0x3F, 0x88, 0x08, 0x1C, 0x3A, 0x88, 0xF8, 0x0C, 0x8B, 0xE0, 0x08, 0x00,
	0x0C, 0x72, 0x1D, 0xF0, 0x1D, 0xF0, 0x00, 0x00, 0x36, 0x41, 0x00, 0x31,
	0xD9, 0x3F, 0x41, 0xD7, 0x3F, 0xB2, 0x13, 0x7F, 0xA2, 0x24, 0x7F, 0xA5,
	0x22, 0x00, 0xCC, 0x2A, 0x0C, 0x02, 0x1D, 0xF0, 0xF8, 0x02, 0xD2, 0x13,
	0x7F, 0xB2, 0x24, 0x7F, 0xC1, 0xD5, 0x3F, 0xD0, 0xAB, 0x11, 0xCA, 0xAA,
	0xA2, 0x2A, 0x7F, 0x81, 0xD0, 0x3F, 0xA0, 0xAD, 0xB0, 0xC2, 0x9A, 0x02,
	0xF7, 0xA8, 0x04, 0x91, 0xCE, 0x3F, 0x9A, 0xFF, 0xC7, 0x2F, 0x2B, 0xE2,
	0x9A, 0x03, 0x21, 0xBA, 0x3F, 0xF7, 0x2E, 0x22, 0xB6, 0x9B, 0x04, 0x0C,
	0xD8, 0xB7, 0xB8, 0x1E, 0xE1, 0xCA, 0x3F, 0x98, 0x0A, 0x1C, 0x53, 0xF2,
	0x59, 0x00, 0xF6, 0xBB, 0x02, 0x86, 0x22, 0x00, 0xB7, 0xB3, 0x02, 0x06,
	0x21, 0x00, 0xCD, 0x0E, 0x46, 0x20, 0x00, 0x0C, 0x82, 0x1D, 0xF0, 0xE1,
	0xC3, 0x3F, 0xE0, 0xAB, 0x11, 0xB6, 0x4D, 0x3E, 0xEA, 0x9A, 0x92, 0x29,
	0x7F, 0xB2, 0xCD, 0xFC, 0x98, 0x89, 0x16, 0xDB, 0x0A, 0x0C, 0x0B, 0xC2,
	0xCD, 0xFB, 0x16, 0x0C, 0x0B, 0x82, 0xCD, 0xFA, 0x16, 0xA8, 0x0B, 0x66,
	0x7D, 0x19, 0xB1, 0xBA, 0x3F, 0xD2, 0xAE, 0x70, 0xC1, 0xBA, 0x3F, 0xD0,
	0x99, 0x10, 0xCA, 0xCA, 0xF2, 0x6C, 0x7F, 0xB0, 0x8F, 0xA0, 0x82, 0x28,
	0x7F, 0x90, 0x98, 0x20, 0xFD, 0x09, 0x0C, 0x7D, 0xD2, 0x53, 0x7F, 0xC1,
	0xB4, 0x3F, 0xEA, 0xBA, 0xCA, 0xCA, 0xC2, 0x2C, 0x45, 0xB2, 0x2B, 0x7F,
	0x98, 0x0C, 0x0C, 0x0A, 0xA6, 0x19, 0x0E, 0xB0, 0xBD, 0xA0, 0x1B, 0xAA,
	0xF9, 0x1B, 0xD8, 0x0C, 0xB2, 0xCB, 0x34, 0xD7, 0x2A, 0xF3, 0x0C, 0x1A,
	0x88, 0x02, 0x1C, 0x9B, 0x88, 0xF8, 0x7C, 0xFC, 0xE0, 0x08, 0x00, 0x0C,
	0x42, 0x1D, 0xF0, 0x0C, 0x0C, 0xB6, 0xBB, 0x36, 0xB7, 0x33, 0x33, 0xFC,
	0x0D, 0x1C, 0x0A, 0x0C, 0x0B, 0x0C, 0x4C, 0x0C, 0x6D, 0x91, 0xA3, 0x3F,
	0x88, 0x02, 0xF2, 0x69, 0x3E, 0xF2, 0x69, 0x44, 0xF2, 0x69, 0x54, 0xF2,
	0x69, 0x4A, 0x82, 0x28, 0x10, 0xF2, 0x69, 0x4E, 0xE0, 0x08, 0x00, 0x0C,
	0x1A, 0x88, 0x02, 0x1C, 0x9B, 0x88, 0xF8, 0x7C, 0xFC, 0xE0, 0x08, 0x00,
	0xC6, 0xEF, 0xFF, 0x88, 0x02, 0x88, 0xF8, 0x0C, 0x1A, 0xE0, 0x08, 0x00,
	0xC6, 0xEC, 0xFF, 0x7C, 0x3B, 0xB0, 0x99, 0x10, 0xB1, 0x96, 0x3F, 0x06,
	0xDA, 0xFF, 0x6C, 0xFC, 0x1C, 0x0D, 0xF0, 0xBD, 0x93, 0xC0, 0x99, 0x10,
	0xB0, 0x99, 0x20, 0x46, 0xD8, 0xFF, 0xC2, 0xAF, 0xDF, 0x2C, 0x0D, 0xF0,
	0xBD, 0x93, 0xC0, 0x99, 0x10, 0xB0, 0x99, 0x20, 0x06, 0xD4, 0xFF, 0x00,
	0x36, 0x41, 0x00, 0x38, 0x02, 0x30, 0x48, 0x74, 0xAD, 0x04, 0x30, 0x30,
	0x74, 0xBD, 0x03, 0xA5, 0x0C, 0x00, 0x8C, 0xEA, 0x0C, 0x72, 0x81, 0x7C,
	0x3F, 0x91, 0x7A, 0x3F, 0x32, 0x58, 0x7F, 0x42, 0x69, 0x7F, 0x1D, 0xF0,
	0x0C, 0x02, 0x1D, 0xF0, 0x36, 0x61, 0x00, 0xA8, 0x02, 0x0C, 0x0B, 0xCD,
	0x01, 0x25, 0x87, 0x02, 0x0C, 0x78, 0x0C, 0x82, 0xA0, 0x28, 0x83, 0x1D,
	0xF0, 0x00, 0x00, 0x00, 0x36, 0x41, 0x00, 0xE8, 0x02, 0x82, 0xA1, 0xFF,
	0xE7, 0xB8, 0x03, 0x0C, 0x82, 0x1D, 0xF0, 0x0C, 0x7A, 0x81, 0x5E, 0x3F,
	0x0C, 0x0B, 0x88, 0x08, 0x0C, 0x4C, 0x82, 0x28, 0x10, 0x0C, 0x0D, 0xE0,
	0x08, 0x00, 0x0C, 0x72, 0x1D, 0xF0, 0x00, 0x00, 0x36, 0x41, 0x00, 0x38,
	0x02, 0x4D, 0x02, 0x66, 0x13, 0x0B, 0x51, 0x70, 0x3F, 0x52, 0x15, 0x7E,
	0x59, 0x04, 0x0C, 0x72, 0x1D, 0xF0, 0x21, 0x53, 0x3F, 0x28, 0x72, 0x51,
	0x6D, 0x3F, 0x82, 0x22, 0x40, 0x22, 0x22, 0x41, 0x8C, 0xC8, 0xC0, 0x82,
	0x11, 0x8A, 0x55, 0x52, 0x95, 0x7F, 0x50, 0x50, 0xF4, 0xC6, 0xF6, 0xFF,
	0x21, 0x64, 0x3F, 0x22, 0x22, 0x86, 0x06, 0xFA, 0xFF, 0x00, 0x00, 0x00,
	0x36, 0x41, 0x00, 0x81, 0x48, 0x3F, 0xC8, 0x02, 0x88, 0x08, 0x1C, 0xCA,
	0x88, 0xF8, 0x1C, 0x9B, 0xE0, 0x08, 0x00, 0x0C, 0x72, 0x1D, 0xF0, 0x00,
	0x36, 0x41, 0x00, 0x81, 0x42, 0x3F, 0xC8, 0x02, 0x88, 0x08, 0x0C, 0x1A,
	0x88, 0xF8, 0x1C, 0x7B, 0xE0, 0x08, 0x00, 0x0C, 0x72, 0x1D, 0xF0, 0x00,
	0x36, 0x41, 0x00, 0x1C, 0x94, 0x27, 0x34, 0x0F, 0x51, 0x57, 0x3F, 0x50,
	0x52, 0xB0, 0x52, 0x25, 0x7F, 0x0C, 0x12, 0x57, 0xA3, 0x01, 0x1D, 0xF0,
	0x0C, 0x02, 0x1D, 0xF0, 0x36, 0x41, 0x00, 0x38, 0x02, 0x30, 0x48, 0x74,
	0xAD, 0x04, 0x30, 0x30, 0x74, 0xBD, 0x03, 0x65, 0xFD, 0xFF, 0xCC, 0x2A,
	0x0C, 0x02, 0x1D, 0xF0, 0xB1, 0x42, 0x3F, 0xD0, 0xA4, 0x11, 0xBA, 0xAA,
	0xA2, 0x2A, 0x7F, 0xA0, 0xA3, 0xB0, 0xA8, 0x0A, 0xCC, 0x2A, 0x0C, 0x82,
	0x1D, 0xF0, 0xB6, 0x94, 0x04, 0x0C, 0xDC, 0x47, 0xBC, 0x11, 0x92, 0x9A,
	0x00, 0xD6, 0x29, 0x00, 0x92, 0xD9, 0x80, 0x90, 0xD0, 0xF4, 0xD9, 0x02,
	0x0C, 0x72, 0x1D, 0xF0, 0x91, 0x38, 0x3F, 0xE0, 0xB4, 0x11, 0x9A, 0x9B,
	0x92, 0x29, 0x7F, 0xB6, 0x43, 0x1A, 0xA8, 0x89, 0x0C, 0x09, 0x26, 0x43,
	0x26, 0x26, 0x53, 0x33, 0x26, 0x63, 0x18, 0x66, 0x73, 0x18, 0x91, 0x32,
	0x3F, 0x9A, 0x9B, 0x92, 0x19, 0xFE, 0x46, 0x03, 0x00, 0x90, 0xA3, 0xA0,
	0xA2, 0x1A, 0x02, 0xA9, 0x02, 0xC6, 0xF1, 0xFF, 0xA0, 0x95, 0x04, 0x99,
	0x02, 0xC6, 0xEF, 0xFF, 0x0C, 0xCC, 0xC0, 0xBA, 0x10, 0x26, 0x4B, 0xF2,
	0xC7, 0x8A, 0x0A, 0x0C, 0x19, 0x86, 0xFA, 0xFF, 0xA0, 0x94, 0x04, 0x06,
	0xF9, 0xFF, 0x66, 0xAB, 0x04, 0x0C, 0x29, 0x06, 0xF7, 0xFF, 0x66, 0x8B,
	0x9E, 0x0C, 0x39, 0x06, 0xF5, 0xFF, 0x00, 0x00, 0x36, 0x41, 0x00, 0x31,
	0x27, 0x3F, 0x4D, 0x02, 0x28, 0x02, 0x20, 0x20, 0xF4, 0x3A, 0x22, 0x22,
	0x02, 0x00, 0x29, 0x04, 0x0C, 0x72, 0x1D, 0xF0, 0x36, 0x61, 0x00, 0x98,
	0x02, 0x0C, 0x34, 0x90, 0x89, 0x41, 0x90, 0x20, 0x94, 0x29, 0x01, 0x56,
	0x08, 0x09, 0x90, 0x36, 0x14, 0x66, 0x23, 0x02, 0xC6, 0x21, 0x00, 0x56,
	0x83, 0x09, 0x81, 0xFD, 0x3E, 0x0C, 0x1A, 0x88, 0x08, 0x1C, 0x9B, 0x88,
	0xF8, 0x7C, 0xFC, 0xE0, 0x08, 0x00, 0xA1, 0x17, 0x3F, 0x06, 0x21, 0x00,
	0xC0, 0x20, 0x00, 0xC2, 0x2E, 0xB1, 0x20, 0x84, 0x14, 0xF0, 0xB8, 0x11,
	0x00, 0x1B, 0x40, 0x00, 0x94, 0xA1, 0xF0, 0x99, 0x30, 0x90, 0xCC, 0x10,
	0x00, 0x1B, 0x40, 0x20, 0x92, 0x14, 0x00, 0xA9, 0xA1, 0xA0, 0xCC, 0x20,
	0xF0, 0xA9, 0x11, 0x92, 0xC9, 0x11, 0x00, 0x1A, 0x40, 0x00, 0xB4, 0xA1,
	0xF0, 0xBB, 0x30, 0x00, 0x1A, 0x40, 0xB0, 0xCC, 0x10, 0x00, 0xB8, 0xA1,
	0xC0, 0xBB, 0x20, 0x00, 0x19, 0x40, 0x82, 0xC8, 0x11, 0x00, 0xCD, 0xA1,
	0x00, 0x18, 0x40, 0x00, 0xAD, 0xA1, 0xC0, 0xAA, 0x20, 0xB0, 0xAA, 0x20,
	0x66, 0x33, 0x21, 0x20, 0xD2, 0x14, 0x20, 0xC4, 0x14, 0xD7, 0x1C, 0x0E,
	0x20, 0xB0, 0x14, 0xC0, 0x8B, 0xC0, 0x16, 0x68, 0x09, 0xD0, 0x9B, 0xC0,
	0x16, 0xA9, 0x08, 0x0C, 0x82, 0x1D, 0xF0, 0x26, 0x13, 0x89, 0x26, 0x33,
	0x86, 0xC0, 0x20, 0x00, 0xA2, 0x6E, 0xB1, 0x0C, 0x72, 0x1D, 0xF0, 0x0C,
	0x0A, 0x0C, 0x1D, 0x7C, 0xFF, 0xE1, 0xF4, 0x3E, 0x20, 0xB8, 0x14, 0x66,
	0x1B, 0xE0, 0x26, 0x13, 0x02, 0x66, 0x33, 0xE0, 0xC0, 0x20, 0x00, 0x20,
	0x92, 0x14, 0x20, 0xB4, 0x14, 0xF0, 0xC9, 0x11, 0x92, 0xC9, 0x11, 0x00,
	0x1C, 0x40, 0x00, 0x84, 0xA1, 0xF0, 0x88, 0x30, 0x00, 0x1C, 0x40, 0x00,
	0xBB, 0xA1, 0xC2, 0x2E, 0xB1, 0x00, 0x19, 0x40, 0x00, 0xAD, 0xA1, 0x80,
	0xCC, 0x10, 0xC0, 0xBB, 0x20, 0xB0, 0xAA, 0x20, 0x66, 0x33, 0xAD, 0x20,
	0xD2, 0x14, 0x20, 0xC4, 0x14, 0xD7, 0x1C, 0x9A, 0x20, 0xB0, 0x14, 0xC7,
	0x1B, 0x05, 0xD7, 0x9B, 0x91, 0xC7, 0x9B, 0x98, 0x0C, 0x88, 0x80, 0x8D,
	0x90, 0x00, 0x18, 0x40, 0x00, 0xC4, 0xA1, 0xF0, 0xCC, 0x30, 0xC0, 0xCA,
	0x10, 0x00, 0xAB, 0xA1, 0xC0, 0xAA, 0x20, 0x86, 0xDF, 0xFF, 0xC7, 0x1B,
	0x02, 0x06, 0xDE, 0xFF, 0x0C, 0x82, 0x20, 0x8C, 0x90, 0x20, 0x2D, 0x90,
	0x00, 0x12, 0x40, 0x00, 0x94, 0xA1, 0xF0, 0x99, 0x30, 0x00, 0x18, 0x40,
	0x90, 0x9A, 0x10, 0x00, 0xA4, 0xA1, 0xF0, 0xAA, 0x30, 0x00, 0x12, 0x40,
	0x00, 0x2B, 0xA1, 0xA0, 0x99, 0x10, 0x00, 0x18, 0x40, 0x90, 0x22, 0x20,
	0x00, 0xAB, 0xA1, 0x20, 0xAA, 0x20, 0xC6, 0xD0, 0xFF, 0x00, 0x00, 0x00,
	0x36, 0x41, 0x00, 0x4D, 0x02, 0x21, 0xC8, 0x3E, 0x22, 0x22, 0x7F, 0x29,
	0x04, 0x0C, 0x72, 0x1D, 0xF0, 0x00, 0x00, 0x00, 0x36, 0x41, 0x00, 0x48,
	0x02, 0x0C, 0x82, 0xB6, 0x24, 0x01, 0x1D, 0xF0, 0x31, 0xC2, 0x3E, 0x0C,
	0x72, 0x42, 0x63, 0x7F, 0x1D, 0xF0, 0x00, 0x00, 0x36, 0x41, 0x00, 0x38,
	0x02, 0x0C, 0x82, 0x8C, 0x03, 0x1D, 0xF0, 0x0C, 0x72, 0x91, 0x9B, 0x3E,
	0x0C, 0x08, 0x82, 0x69, 0x96, 0x1D, 0xF0, 0x00, 0x36, 0x41, 0x00, 0x38,
	0x02, 0x0C, 0x84, 0xCC, 0xB3, 0x81, 0x96, 0x3E, 0x0C, 0x74, 0x82, 0x28,
	0x96, 0x89, 0x02, 0xC6, 0xFF, 0xFF, 0x2D, 0x04, 0x1D, 0xF0, 0x00, 0x00,
	0x36, 0x41, 0x00, 0x38, 0x02, 0x0C, 0x82, 0xB6, 0x23, 0x01, 0x1D, 0xF0,
	0x0C, 0x72, 0x1D, 0xF0, 0x36, 0x41, 0x00, 0x41, 0xAE, 0x3E, 0x0C, 0x05,
	0x38, 0x04, 0x59, 0x02, 0x8C, 0x63, 0x59, 0x02, 0x59, 0x04, 0x0C, 0x72,
	0x1D, 0xF0, 0x0C, 0x16, 0x69, 0x04, 0x4D, 0x02, 0x06, 0xFC, 0xFF, 0x00,
	0x36, 0x41, 0x00, 0x51, 0xA7, 0x3E, 0x38, 0x02, 0x59, 0x02, 0x30, 0x50,
	0x74, 0x30, 0x38, 0x74, 0xCC, 0x83, 0x1C, 0x38, 0x91, 0xA4, 0x3E, 0x99,
	0x02, 0x57, 0xB8, 0x03, 0x0C, 0x82, 0x1D, 0xF0, 0xD1, 0xA3, 0x3E, 0x0C,
	0x08, 0x89, 0x02, 0x61, 0xA0, 0x3E, 0x91, 0xA1, 0x3E, 0x60, 0x65, 0xA0,
	0xC0, 0x20, 0x00, 0x42, 0x26, 0x80, 0xB8, 0x09, 0x0C, 0x1A, 0xC8, 0x0D,
	0x59, 0x0D, 0xC0, 0xC5, 0xC0, 0xC0, 0xAB, 0x83, 0x8C, 0xFA, 0x89, 0x09,
	0x40, 0x40, 0xF5, 0x49, 0x02, 0xC0, 0x20, 0x00, 0x82, 0x66, 0x80, 0x0C,
	0x72, 0x1D, 0xF0, 0x40, 0x40, 0xF4, 0x0C, 0x1A, 0xA9, 0x09, 0x46, 0xFA,
	0xFF, 0x00, 0x00, 0x00, 0x36, 0x41, 0x00, 0x4D, 0x02, 0x28, 0x02, 0x51,
	0x6B, 0x3E, 0x9C, 0xD2, 0x26, 0x12, 0x08, 0x51, 0x90, 0x3E, 0x59, 0x04,
	0x0C, 0x72, 0x1D, 0xF0, 0x58, 0x35, 0x28, 0x75, 0x82, 0x95, 0x04, 0x20,
	0x56, 0x21, 0x80, 0x55, 0xD1, 0x50, 0x56, 0x21, 0x86, 0xF9, 0xFF, 0x58,
	0x35, 0x0C, 0x09, 0x28, 0x65, 0x99, 0x65, 0x46, 0xF9, 0xFF, 0x00, 0x00,
	0x36, 0x41, 0x00, 0x41, 0x5E, 0x3E, 0x28, 0x02, 0x0C, 0x79, 0x9C, 0x22,
	0x26, 0x52, 0x1D, 0xA6, 0x92, 0x08, 0x38, 0x34, 0x0C, 0x04, 0x29, 0x43,
	0x86, 0x02, 0x00, 0x7C, 0xF4, 0x46, 0x01, 0x00, 0x88, 0x34, 0x0C, 0x04,
	0x49, 0x48, 0x0C, 0x82, 0x40, 0x29, 0x83, 0x1D, 0xF0, 0xA2, 0xA3, 0xE8,
	0xB8, 0x34, 0x0C, 0x04, 0xA9, 0x4B, 0x06, 0xFB, 0xFF, 0x00, 0x00, 0x00,
	0x36, 0x41, 0x00, 0xA8, 0x02, 0xF6, 0xBA, 0x14, 0x81, 0x4E, 0x3E, 0x88,
	0x18, 0x0C, 0x0B, 0x82, 0x28, 0x31, 0x1C, 0x0C, 0xE0, 0x08, 0x00, 0xA9,
	0x02, 0x0C, 0x72, 0x1D, 0xF0, 0x0C, 0x82, 0x1D, 0xF0, 0x00, 0x00, 0x00,
	0x36, 0x41, 0x00, 0x61, 0x6E, 0x3E, 0x8D, 0x02, 0x78, 0x02, 0x0C, 0x72,
	0xE6, 0x67, 0x25, 0x0C, 0x05, 0x62, 0xC6, 0xE0, 0x0C, 0x83, 0x76, 0xA3,
	0x15, 0x42, 0x26, 0x7F, 0x4B, 0x66, 0x77, 0x94, 0x0B, 0x41, 0x67, 0x3E,
	0x40, 0x45, 0x90, 0x42, 0x14, 0x7F, 0xC6, 0x07, 0x00, 0x1B, 0x55, 0x7C,
	0xF4, 0x06, 0x06, 0x00, 0x00, 0x0C, 0x05, 0x0C, 0x89, 0x76, 0xA9, 0x16,
	0xA2, 0x26, 0x7F, 0x4B, 0x66, 0x77, 0x9A, 0x0C, 0x41, 0x60, 0x3E, 0x40,
	0x45, 0x90, 0x42, 0x14, 0x7F, 0x49, 0x08, 0x1D, 0xF0, 0x1B, 0x55, 0x7C,
	0xF4, 0x06, 0xFD, 0xFF, 0x36, 0x41, 0x00, 0xA8, 0x02, 0xF6, 0xBA, 0x14,
	0x81, 0x2F, 0x3E, 0x88, 0x18, 0x0C, 0x0B, 0x82, 0x28, 0x30, 0x1C, 0x0C,
	0xE0, 0x08, 0x00, 0xA9, 0x02, 0x0C, 0x72, 0x1D, 0xF0, 0x0C, 0x82, 0x1D,
	0xF0, 0x00, 0x00, 0x00, 0x36, 0x41, 0x00, 0x61, 0x4E, 0x3E, 0x20, 0x50,
	0xF5, 0x20, 0x90, 0xF4, 0x81, 0x35, 0x3E, 0x99, 0x04, 0x57, 0xA8, 0x11,
	0xA1, 0x4E, 0x3E, 0xB1, 0x4E, 0x3E, 0x57, 0x2A, 0x08, 0xB0, 0xB5, 0xA0,
	0xB2, 0x2B, 0x95, 0x46, 0x00, 0x00, 0x0C, 0x0B, 0x8C, 0xCB, 0xAD, 0x04,
	0xE0, 0x0B, 0x00, 0x2D, 0x0A, 0x26, 0x8A, 0x58, 0x59, 0x03, 0x1D, 0xF0,
	0xC1, 0x47, 0x3E, 0xD1, 0x47, 0x3E, 0xC7, 0x15, 0x42, 0xD7, 0x15, 0x3F,
	0xE1, 0x46, 0x3E, 0xF1, 0x46, 0x3E, 0xE7, 0x15, 0x36, 0xF7, 0x15, 0x33,
	0x81, 0x45, 0x3E, 0x91, 0x45, 0x3E, 0x87, 0x15, 0x2A, 0x97, 0x15, 0x27,
	0xA1, 0x44, 0x3E, 0xB1, 0x44, 0x3E, 0xA7, 0x15, 0x1E, 0xB7, 0x15, 0x1B,
	0xC1, 0x43, 0x3E, 0xD1, 0x43, 0x3E, 0xC7, 0x15, 0x12, 0xD7, 0x15, 0x0F,
	0xE1, 0x42, 0x3E, 0xF1, 0x42, 0x3E, 0xE7, 0x15, 0x06, 0xF7, 0x15, 0x03,
	0x0C, 0x02, 0x1D, 0xF0, 0x69, 0x03, 0x0C, 0x72, 0x3D, 0x04, 0x86, 0xE9,
	0xFF, 0x69, 0x03, 0x3D, 0x04, 0xC6, 0xE7, 0xFF, 0x36, 0x81, 0x00, 0xA2,
	0x12, 0x16, 0xE6, 0x1A, 0x02, 0xC6, 0x2C, 0x00, 0x0C, 0x03, 0x0C, 0x07,
	0x0C, 0x06, 0x41, 0xFE, 0x3D, 0x0C, 0x0D, 0xD9, 0x51, 0x52, 0x22, 0x23,
	0xE8, 0x92, 0x3A, 0x55, 0x3A, 0xEE, 0xE8, 0x0E, 0x58, 0x05, 0x16, 0x3E,
	0x08, 0x0C, 0x09, 0x0C, 0x1B, 0x0C, 0x08, 0xA6, 0x65, 0x04, 0x26, 0x95,
	0x01, 0x0C, 0x19, 0x90, 0x8B, 0x83, 0x16, 0xF8, 0x06, 0x88, 0x14, 0x82,
	0x28, 0x3F, 0xAD, 0x05, 0xE0, 0x08, 0x00, 0x16, 0xFA, 0x05, 0xD2, 0x22,
	0x33, 0x66, 0x95, 0x71, 0xA6, 0x1D, 0x56, 0x0C, 0x05, 0xA8, 0x92, 0x88,
	0x04, 0x3A, 0xAA, 0x88, 0x78, 0xA8, 0x0A, 0xE0, 0x08, 0x00, 0x92, 0x22,
	0x33, 0x1B, 0x55, 0x97, 0x25, 0xEA, 0x06, 0x0F, 0x00, 0xA2, 0x22, 0x10,
	0xC2, 0x22, 0x12, 0xA0, 0xA5, 0x90, 0xA2, 0x9A, 0x00, 0xC0, 0xC5, 0x90,
	0xB0, 0xAA, 0xC0, 0xA2, 0x5C, 0x00, 0xD2, 0x22, 0x12, 0x9A, 0x9D, 0xC2,
	0x99, 0x00, 0xD6, 0x4C, 0x00, 0x0C, 0x0E, 0xE2, 0x59, 0x00, 0xA8, 0x41,
	0xD2, 0x12, 0x3A, 0xE2, 0x12, 0x3B, 0xC2, 0x22, 0x1B, 0x88, 0x14, 0x7A,
	0xCC, 0x82, 0x28, 0x2F, 0xC2, 0x1C, 0x00, 0xE0, 0x08, 0x00, 0xA2, 0x12,
	0x16, 0x2B, 0x77, 0x4B, 0x33, 0xD8, 0x51, 0x1B, 0x66, 0xD2, 0xCD, 0x10,
	0xD9, 0x51, 0xA7, 0xA6, 0x02, 0x06, 0xD6, 0xFF, 0x1D, 0xF0, 0xD9, 0x01,
	0xD9, 0x31, 0xAD, 0x02, 0x0C, 0x1B, 0xCD, 0x06, 0x98, 0xC2, 0x88, 0x14,
	0x90, 0x95, 0xA0, 0x82, 0x28, 0x3C, 0x98, 0x09, 0x99, 0x41, 0xE0, 0x95,
	0x11, 0x99, 0x21, 0xE0, 0x08, 0x00, 0xD2, 0x22, 0x36, 0x9D, 0x0A, 0xA2,
	0xCD, 0xD0, 0x16, 0xCA, 0x09, 0x99, 0x11, 0xB2, 0xCD, 0xD4, 0x16, 0x4B,
	0x09, 0x88, 0x14, 0xBD, 0x09, 0x82, 0x28, 0x48, 0xAD, 0x02, 0xE0, 0x08,
	0x00, 0x56, 0x5A, 0x08, 0x92, 0x22, 0x36, 0xA2, 0x22, 0x37, 0x66, 0xB9,
	0x0F, 0x66, 0x8A, 0x0C, 0xC2, 0x22, 0x30, 0xB2, 0x22, 0x33, 0xC9, 0x41,
	0xF0, 0xBB, 0x11, 0xB9, 0x31, 0xB8, 0x41, 0xC8, 0x31, 0xA8, 0x92, 0x88,
	0x02, 0x3A, 0xAA, 0x88, 0x98, 0xA8, 0x0A, 0xE0, 0x08, 0x00, 0xA8, 0x41,
	0x88, 0x14, 0x98, 0x31, 0xC2, 0x22, 0x10, 0xBD, 0x09, 0xC0, 0xC5, 0x90,
	0x82, 0x28, 0x17, 0x92, 0x5C, 0x00, 0xE0, 0x08, 0x00, 0xE8, 0x21, 0xD2,
	0x22, 0x22, 0xEA, 0xDD, 0xD8, 0x0D, 0x96, 0x5D, 0x00, 0xF2, 0x22, 0x3E,
	0x47, 0x6F, 0x16, 0xA8, 0x41, 0xB8, 0x31, 0xE8, 0x51, 0xD2, 0x22, 0x18,
	0xC8, 0x74, 0x88, 0x14, 0xC8, 0x3C, 0x82, 0x28, 0x2D, 0xEA, 0xDD, 0xE0,
	0x08, 0x00, 0xD8, 0x11, 0xE8, 0x11, 0xD2, 0xCD, 0xF0, 0xF6, 0x3D, 0x3C,
	0xA2, 0x22, 0x16, 0x88, 0x14, 0xB8, 0x41, 0x82, 0x28, 0x21, 0xC8, 0x31,
	0xE0, 0x08, 0x00, 0xC6, 0x0F, 0x00, 0xF0, 0x95, 0x11, 0xB8, 0x01, 0xA2,
	0xC5, 0xFD, 0x56, 0x7A, 0xED, 0xC2, 0x22, 0xDC, 0x56, 0x6C, 0xEE, 0xF2,
	0xAF, 0x60, 0xD2, 0x22, 0x10, 0xE2, 0x22, 0x12, 0xD0, 0xD5, 0x90, 0xD2,
	0x9D, 0x00, 0xE0, 0xE5, 0x90, 0xFA, 0xDD, 0xD2, 0x5E, 0x00, 0x06, 0xB3,
	0xFF, 0xE2, 0xCE, 0xF2, 0xF6, 0x2E, 0x0E, 0xA2, 0x22, 0xDD, 0x88, 0x14,
	0xB8, 0x41, 0x82, 0x28, 0x21, 0xC8, 0x31, 0xE0, 0x08, 0x00, 0x92, 0x22,
	0x36, 0xA2, 0x22, 0x37, 0x66, 0xB9, 0x27, 0x66, 0x8A, 0x24, 0x0C, 0x0B,
	0xA2, 0x22, 0x2E, 0xB9, 0x01, 0xAA, 0xA3, 0xA8, 0x0A, 0x9C, 0x6A, 0xB8,
	0x41, 0xED, 0x01, 0xF8, 0x21, 0xC8, 0xC2, 0xD8, 0x31, 0x88, 0x24, 0xD0,
	0xD0, 0xF4, 0x88, 0xE8, 0xFA, 0xCC, 0xC8, 0x0C, 0xE0, 0x08, 0x00, 0xB8,
	0x01, 0x46, 0xA4, 0xFF, 0x36, 0x41, 0x00, 0xE6, 0x42, 0x02, 0xD6, 0x52,
	0x00, 0xE6, 0x82, 0x06, 0xA6, 0x62, 0x03, 0x0C, 0x12, 0x1D, 0xF0, 0x0C,
	0x02, 0x1D, 0xF0, 0x00, 0x36, 0x61, 0x00, 0xD1, 0x7C, 0x3D, 0x81, 0x84,
	0x3D, 0xAD, 0x02, 0x82, 0x28, 0x7F, 0x28, 0xC1, 0xDC, 0x28, 0xAD, 0x03,
	0xBD, 0x04, 0x88, 0x2D, 0x60, 0xC2, 0x43, 0x88, 0x88, 0xC9, 0x07, 0xE0,
	0x08, 0x00, 0x0C, 0x02, 0x1D, 0xF0, 0xBD, 0x03, 0xCD, 0x04, 0xDD, 0x05,
	0x81, 0x72, 0x3D, 0x29, 0x01, 0x88, 0x78, 0xED, 0x06, 0x82, 0x28, 0xBE,
	0xFD, 0x07, 0xE0, 0x08, 0x00, 0x2D, 0x0A, 0x1D, 0xF0, 0x00, 0x00, 0x00,
	0x36, 0x41, 0x00, 0x62, 0x12, 0x75, 0x42, 0x12, 0x76, 0x67, 0x23, 0x0F,
	0x37, 0x24, 0x0C, 0x42, 0x22, 0xC6, 0x60, 0x23, 0xC0, 0x40, 0x22, 0xA0,
	0x28, 0x02, 0x1D, 0xF0, 0x0C, 0x02, 0x1D, 0xF0, 0x36, 0x61, 0x00, 0xAD,
	0x02, 0x0C, 0x19, 0x51, 0x62, 0x3D, 0x32, 0x22, 0x46, 0x88, 0x15, 0x38,
	0x33, 0x82, 0x28, 0x51, 0x30, 0x39, 0x93, 0xE0, 0x08, 0x00, 0x39, 0x01,
	0xC2, 0x12, 0x75, 0x0C, 0xE8, 0x87, 0xAC, 0x6A, 0x71, 0x94, 0x3D, 0x0C,
	0x04, 0x0C, 0x03, 0x6D, 0x02, 0x88, 0x15, 0xCA, 0xB4, 0x82, 0x28, 0x39,
	0xAD, 0x02, 0xE0, 0x08, 0x00, 0x62, 0xC6, 0x40, 0x1B, 0x44, 0x0C, 0xE9,
	0x1C, 0x0B, 0x2C, 0x0D, 0xCD, 0x0A, 0x0C, 0x0E, 0x4C, 0x0A, 0xE2, 0x66,
	0x59, 0xE2, 0x66, 0x5A, 0xE2, 0x66, 0x5B, 0xE2, 0x66, 0x5C, 0xE2, 0x66,
	0x5D, 0xD2, 0x66, 0x5E, 0xE2, 0x66, 0x51, 0xE2, 0x66, 0x52, 0xE2, 0x66,
	0x53, 0xE2, 0x66, 0x54, 0xE2, 0x66, 0x55, 0xD2, 0x66, 0x56, 0xC0, 0xAB,
	0x93, 0xA2, 0x66, 0x57, 0xA2, 0x66, 0x58, 0xA2, 0x66, 0x4F, 0xA2, 0x66,
	0x50, 0xC2, 0x12, 0x75, 0xA2, 0x22, 0x28, 0xC0, 0x99, 0xC0, 0x3A, 0xAA,
	0x79, 0x0A, 0x4B, 0x33, 0x97, 0x24, 0x9D, 0xA2, 0x12, 0x16, 0x3C, 0x07,
	0xE6, 0x1A, 0x02, 0x86, 0x37, 0x00, 0x0C, 0x04, 0x0C, 0x03, 0x82, 0x22,
	0x23, 0x3A, 0x88, 0x88, 0x08, 0xF6, 0x68, 0x57, 0xAD, 0x02, 0x88, 0x15,
	0x0C, 0x1B, 0x82, 0x28, 0x3C, 0xCD, 0x04, 0xE0, 0x08, 0x00, 0x88, 0x15,
	0xBD, 0x0A, 0x82, 0x28, 0x48, 0xAD, 0x02, 0xE0, 0x08, 0x00, 0xDC, 0xAA,
	0x92, 0x22, 0x36, 0x77, 0x19, 0x11, 0xA2, 0x22, 0x23, 0x3A, 0xAA, 0xA8,
	0x0A, 0x0C, 0x19, 0xA2, 0xCA, 0xFC, 0xF6, 0x2A, 0x02, 0x46, 0x00, 0x00,
	0x0C, 0x09, 0xAC, 0x89, 0xB2, 0x12, 0x72, 0xA2, 0x12, 0x54, 0xC2, 0x22,
	0x29, 0xB7, 0xBA, 0x10, 0xC0, 0xCA, 0xA0, 0x1B, 0xDA, 0xD2, 0x52, 0x54,
	0xD2, 0x22, 0x2B, 0xC8, 0x0C, 0x3A, 0xDD, 0xC9, 0x0D, 0xA2, 0x12, 0x16,
	0x4B, 0x33, 0x1B, 0x44, 0xA7, 0x24, 0x96, 0x86, 0x1B, 0x00, 0x88, 0x15,
	0xA2, 0x22, 0x23, 0x82, 0x28, 0x3F, 0x3A, 0xAA, 0xA8, 0x0A, 0xE0, 0x08,
	0x00, 0x16, 0x0A, 0xFE, 0xA2, 0x22, 0x36, 0x2C, 0xC9, 0x97, 0x1A, 0x34,
	0x77, 0x1A, 0x31, 0x66, 0xBA, 0xD2, 0xA2, 0x22, 0x37, 0x66, 0x8A, 0xCC,
	0xB2, 0x12, 0x73, 0xC2, 0x12, 0x5A, 0xB7, 0xBC, 0xC3, 0xA2, 0x22, 0x2C,
	0x92, 0x22, 0x2E, 0x1B, 0xBC, 0x88, 0x25, 0xB2, 0x52, 0x5A, 0x7C, 0xFB,
	0x88, 0xC8, 0x3A, 0x99, 0xA0, 0xAC, 0xA0, 0xA8, 0x0A, 0xA9, 0x09, 0xE0,
	0x08, 0x00, 0xC6, 0xE8, 0xFF, 0xC2, 0x12, 0x72, 0xA2, 0x12, 0x54, 0xC7,
	0xBA, 0x9A, 0x1B, 0xEA, 0xD2, 0x22, 0x29, 0xE2, 0x52, 0x54, 0xE2, 0x22,
	0x2B, 0xD0, 0xDA, 0xA0, 0xD8, 0x0D, 0x3A, 0xEE, 0xD9, 0x0E, 0xC6, 0xE0,
	0xFF, 0xA2, 0x12, 0x17, 0x0C, 0x03, 0xE6, 0x1A, 0x02, 0xC6, 0x51, 0x00,
	0x0C, 0x04, 0x82, 0x22, 0x24, 0x3A, 0x88, 0x88, 0x08, 0xA6, 0x98, 0x02,
	0x86, 0x4B, 0x00, 0xAD, 0x02, 0x88, 0x15, 0x0C, 0x0B, 0x82, 0x28, 0x3C,
	0xCD, 0x04, 0xE0, 0x08, 0x00, 0x6D, 0x0A, 0x88, 0x15, 0xAD, 0x02, 0x82,
	0x28, 0x48, 0xBD, 0x06, 0xE0, 0x08, 0x00, 0xDC, 0x0A, 0xA2, 0x22, 0x24,
	0x3A, 0xAA, 0xA8, 0x0A, 0x26, 0x7A, 0x07, 0x26, 0x8A, 0x04, 0x0C, 0x9B,
	0xB7, 0x9A, 0x29, 0xC2, 0x12, 0x72, 0xA2, 0x12, 0x54, 0xF2, 0x22, 0x2B,
	0xC7, 0xBA, 0x16, 0xD2, 0x22, 0x29, 0x1B, 0xEA, 0xE2, 0x52, 0x54, 0xD0,
	0xDA, 0xA0, 0xE2, 0x12, 0x16, 0xD8, 0x0D, 0xEA, 0xE4, 0xF0, 0xEE, 0xA0,
	0xD9, 0x0E, 0xA2, 0x22, 0x24, 0x3A, 0xAA, 0xA8, 0x0A, 0xB2, 0xCA, 0xF9,
	0x56, 0xBB, 0x0C, 0x88, 0x15, 0xBD, 0x06, 0x82, 0x28, 0x48, 0xAD, 0x02,
	0xE0, 0x08, 0x00, 0x56, 0xCA, 0x0B, 0xA2, 0x22, 0x36, 0x92, 0x22, 0x37,
	0x66, 0x8A, 0x37, 0x66, 0x89, 0x05, 0xA2, 0x22, 0x3E, 0x37, 0xEA, 0x05,
	0xB2, 0xC9, 0xF0, 0x56, 0x4B, 0x0A, 0xB2, 0x22, 0x2C, 0x92, 0x12, 0x16,
	0x88, 0x25, 0xA2, 0x12, 0x5A, 0x88, 0xC8, 0x1B, 0xCA, 0x9A, 0x94, 0xB0,
	0xAA, 0xA0, 0xC2, 0x52, 0x5A, 0xB2, 0x22, 0x2E, 0xA8, 0x0A, 0xB0, 0x99,
	0xA0, 0xA9, 0x09, 0x7C, 0xFB, 0xE0, 0x08, 0x00, 0xC6, 0x1E, 0x00, 0x66,
	0xBA, 0x37, 0xD2, 0x22, 0x37, 0x66, 0x8D, 0x72, 0x92, 0x22, 0x3E, 0x37,
	0x69, 0x02, 0x47, 0x69, 0x69, 0xB2, 0x22, 0x2C, 0x92, 0x12, 0x16, 0x88,
	0x25, 0xA2, 0x12, 0x5A, 0x88, 0xC8, 0x1B, 0xCA, 0x9A, 0x94, 0xB0, 0xAA,
	0xA0, 0xC2, 0x52, 0x5A, 0xB2, 0x22, 0x2E, 0xA8, 0x0A, 0xB0, 0x99, 0xA0,
	0xA9, 0x09, 0x0C, 0x1B, 0xE0, 0x08, 0x00, 0x06, 0x10, 0x00, 0x2C, 0xCD,
	0xD7, 0x1A, 0x02, 0x77, 0x9A, 0x38, 0xE8, 0x01, 0xBC, 0x3E, 0xF2, 0x22,
	0x37, 0x66, 0x8F, 0x2E, 0x92, 0x22, 0x3E, 0x37, 0x69, 0x02, 0x47, 0x69,
	0x25, 0xB2, 0x22, 0x2C, 0x92, 0x12, 0x16, 0x88, 0x25, 0xA2, 0x12, 0x5A,
	0x88, 0xC8, 0x1B, 0xCA, 0x9A, 0x94, 0xB0, 0xAA, 0xA0, 0xC2, 0x52, 0x5A,
	0xB2, 0x22, 0x2E, 0xA8, 0x0A, 0xB0, 0x99, 0xA0, 0xA9, 0x09, 0x0C, 0x1B,
	0xE0, 0x08, 0x00, 0xA2, 0x12, 0x17, 0x4B, 0x33, 0x1B, 0x44, 0xA7, 0xA4,
	0x02, 0x46, 0xAE, 0xFF, 0x1D, 0xF0, 0x00, 0x00, 0x36, 0x41, 0x00, 0x32,
	0x62, 0x2F, 0x26, 0x03, 0x65, 0x62, 0x12, 0x75, 0x3C, 0x09, 0x67, 0x23,
	0x0B, 0x42, 0x12, 0x76, 0x60, 0x53, 0xC0, 0x37, 0x24, 0x02, 0xC6, 0x2D,
	0x00, 0x0C, 0x07, 0x60, 0x53, 0xC0, 0x62, 0x22, 0x36, 0xE0, 0x85, 0x11,
	0x2A, 0xC8, 0x16, 0x27, 0x0B, 0x97, 0x96, 0x05, 0x51, 0xDD, 0x3C, 0x06,
	0x05, 0x00, 0x66, 0xB6, 0x05, 0x51, 0xDB, 0x3C, 0xC6, 0x02, 0x00, 0x71,
	0xDB, 0x3C, 0x51, 0xD8, 0x3C, 0x92, 0xC6, 0xF8, 0x90, 0x57, 0x83, 0x61,
	0xD6, 0x3C, 0x46, 0x01, 0x00, 0x61, 0xD7, 0x3C, 0x51, 0xD8, 0x3C, 0x52,
	0x6C, 0x47, 0xB2, 0x12, 0x75, 0xB0, 0xB3, 0xC0, 0x20, 0xBB, 0xA0, 0x62,
	0x6B, 0x4B, 0xA2, 0x22, 0x3E, 0x17, 0x6A, 0x02, 0x26, 0xB3, 0x01, 0x1D,
	0xF0, 0xB2, 0x12, 0x75, 0xE0, 0xBB, 0x11, 0xB0, 0xB2, 0xC0, 0x52, 0x6B,
	0x58, 0xA2, 0x12, 0x75, 0xE0, 0xAA, 0x11, 0xA0, 0xA2, 0xC0, 0x52, 0x6A,
	0x59, 0x92, 0x12, 0x75, 0x0C, 0x0F, 0xE0, 0x99, 0x11, 0x90, 0x92, 0xC0,
	0xF2, 0x69, 0x5B, 0x82, 0x12, 0x75, 0xE0, 0x88, 0x11, 0x80, 0x82, 0xC0,
	0xF2, 0x68, 0x5C, 0x42, 0x12, 0x75, 0xE0, 0x44, 0x11, 0x40, 0x42, 0xC0,
	0xF2, 0x64, 0x5C, 0x32, 0x12, 0x75, 0xE0, 0x33, 0x11, 0x30, 0x32, 0xC0,
	0xF2, 0x63, 0x5D, 0xE2, 0x12, 0x75, 0xE0, 0xEE, 0x11, 0xE0, 0xE2, 0xC0,
	0x62, 0x6E, 0x5F, 0xD2, 0x12, 0x75, 0xE0, 0xDD, 0x11, 0xD0, 0xD2, 0xC0,
	0x62, 0x6D, 0x60, 0x1D, 0xF0, 0x72, 0x22, 0xC6, 0x70, 0x75, 0xA0, 0x78,
	0x07, 0x46, 0xD0, 0xFF, 0x97, 0x96, 0x0E, 0x52, 0x22, 0x37, 0x66, 0x85,
	0x28, 0x61, 0xB3, 0x3C, 0x51, 0xB0, 0x3C, 0x06, 0xD9, 0xFF, 0x2C, 0xC9,
	0x97, 0x96, 0x0E, 0x52, 0x22, 0x37, 0x66, 0x85, 0x20, 0x61, 0xAF, 0x3C,
	0x51, 0xB0, 0x3C, 0x06, 0xD4, 0xFF, 0xA2, 0xC6, 0xF0, 0x16, 0x4A, 0xF4,
	0x51, 0xA6, 0x3C, 0x06, 0xCE, 0xFF, 0x66, 0xB5, 0x14, 0x61, 0xAB, 0x3C,
	0x51, 0xA4, 0x3C, 0x06, 0xCE, 0xFF, 0x66, 0xB5, 0x11, 0x61, 0xA9, 0x3C,
	0x51, 0xAA, 0x3C, 0x06, 0xCB, 0xFF, 0x61, 0x9E, 0x3C, 0x51, 0x9D, 0x3C,
	0xC6, 0xC8, 0xFF, 0x61, 0x9C, 0x3C, 0x51, 0x9B, 0x3C, 0x86, 0xC6, 0xFF,
	0x36, 0xA1, 0x00, 0x39, 0x91, 0xAD, 0x01, 0xB1, 0xA3, 0x3C, 0x1C, 0x0C,
	0x25, 0x40, 0x05, 0xA2, 0xC1, 0x10, 0xB1, 0xA1, 0x3C, 0x1C, 0x0C, 0xA5,
	0x3F, 0x05, 0xA2, 0x22, 0x3E, 0x27, 0x6A, 0x06, 0xAD, 0x02, 0x7C, 0xFB,
	0xE5, 0xE9, 0xFF, 0x0C, 0x0A, 0x0C, 0x09, 0x0C, 0xAB, 0x76, 0xAB, 0x0F,
	0xC2, 0x22, 0xBF, 0xD2, 0x22, 0x46, 0xAA, 0xCC, 0xAA, 0xDD, 0x99, 0x0D,
	0x99, 0x0C, 0x4B, 0xAA, 0x0C, 0x0A, 0xD2, 0xA0, 0x04, 0x76, 0xAD, 0x0F,
	0xE2, 0x22, 0xC6, 0xF2, 0x22, 0xC5, 0xAA, 0xEE, 0xAA, 0xFF, 0x99, 0x0F,
	0x99, 0x0E, 0x4B, 0xAA, 0x31, 0x4B, 0x3C, 0xF2, 0x12, 0x16, 0x78, 0x91,
	0x68, 0x12, 0xC0, 0x77, 0x11, 0x79, 0x81, 0x7A, 0x66, 0x68, 0x06, 0x0C,
	0x07, 0xE6, 0x1F, 0x02, 0x06, 0x32, 0x00, 0x0C, 0x04, 0x0C, 0x05, 0x92,
	0x22, 0x23, 0x60, 0xA0, 0x34, 0x4A, 0x99, 0xA9, 0x09, 0xB6, 0x6A, 0x0E,
	0xB2, 0xCA, 0xF4, 0xB6, 0x2B, 0x08, 0x26, 0x9A, 0x05, 0x0C, 0xAC, 0xC9,
	0x09, 0xA8, 0x09, 0xD2, 0x22, 0x3E, 0x27, 0x6D, 0x1D, 0xDC, 0xAA, 0xAD,
	0x02, 0x88, 0x13, 0x0C, 0x1B, 0x82, 0x28, 0x3C, 0xCD, 0x07, 0xE0, 0x08,
	0x00, 0xBD, 0x0A, 0xAD, 0x02, 0x65, 0xE1, 0xFF, 0xA2, 0x22, 0x23, 0x4A,
	0xAA, 0xA8, 0x0A, 0xF6, 0x6A, 0x24, 0xC2, 0x22, 0x46, 0xB2, 0x22, 0x21,
	0xC0, 0xCA, 0xA0, 0x5A, 0xBB, 0xA2, 0x22, 0x23, 0xB2, 0x1B, 0x00, 0xB9,
	0x0C, 0x4A, 0xAA, 0xC2, 0x22, 0xBF, 0xB8, 0x92, 0xA8, 0x0A, 0x4A, 0xBB,
	0xC0, 0xCA, 0xA0, 0xB8, 0x0B, 0xB9, 0x0C, 0x88, 0x13, 0x82, 0x28, 0x3F,
	0xE0, 0x08, 0x00, 0x9C, 0x6A, 0x0C, 0x19, 0xA2, 0x22, 0x21, 0xC2, 0x12,
	0x75, 0x5A, 0xAA, 0xA2, 0x1A, 0x00, 0xB2, 0x22, 0xC5, 0xC0, 0xAA, 0xC0,
	0xB0, 0xAA, 0xA0, 0x99, 0x0A, 0x88, 0x13, 0xA2, 0x22, 0x23, 0x82, 0x28,
	0x3E, 0x4A, 0xAA, 0xA8, 0x0A, 0xE0, 0x08, 0x00, 0x9C, 0x6A, 0x0C, 0x19,
	0xA2, 0x22, 0x21, 0xC2, 0x12, 0x75, 0x5A, 0xAA, 0xA2, 0x1A, 0x00, 0xB2,
	0x22, 0xC6, 0xC0, 0xAA, 0xC0, 0xB0, 0xAA, 0xA0, 0x99, 0x0A, 0x60, 0x64,
	0x21, 0x4B, 0x44, 0x2B, 0x55, 0xB2, 0x12, 0x16, 0x1B, 0x77, 0xB7, 0xA7,
	0x02, 0x86, 0xCE, 0xFF, 0xC2, 0x22, 0x3E, 0x27, 0x6C, 0x17, 0x88, 0x13,
	0x82, 0x28, 0x45, 0xAD, 0x02, 0xE0, 0x08, 0x00, 0x66, 0x0A, 0x0A, 0xA2,
	0x12, 0x16, 0x0C, 0x0C, 0xA6, 0x1A, 0x02, 0xC6, 0xB3, 0x00, 0x0C, 0x06,
	0x88, 0x81, 0x78, 0x12, 0x0C, 0x09, 0x92, 0x62, 0xC3, 0x92, 0x62, 0xC1,
	0x8A, 0x77, 0x92, 0x12, 0x17, 0x78, 0x17, 0xE6, 0x19, 0x02, 0x46, 0x42,
	0x00, 0x0C, 0x04, 0x0C, 0x05, 0x0C, 0x0C, 0x0C, 0x0D, 0x70, 0xA0, 0x34,
	0x70, 0x74, 0x21, 0xE2, 0x22, 0x24, 0xB2, 0xCA, 0xFA, 0x4A, 0xEE, 0xA9,
	0x0E, 0xB6, 0x4B, 0x10, 0xF2, 0xCA, 0xF4, 0xB6, 0x2F, 0x0A, 0x0C, 0xB8,
	0x87, 0x1A, 0x05, 0x0C, 0xB9, 0x99, 0x0E, 0xA8, 0x0E, 0x0C, 0x19, 0x66,
	0x7A, 0x19, 0xE2, 0x22, 0xC1, 0xF2, 0x22, 0xC2, 0x1B, 0x8E, 0x82, 0x62,
	0xC1, 0xF0, 0xEE, 0xA0, 0x69, 0x0E, 0xC2, 0x22, 0xC1, 0x0C, 0x1A, 0x0B,
	0xCC, 0xC0, 0xCA, 0x93, 0x0C, 0x0A, 0xC0, 0xA9, 0x83, 0x16, 0x0A, 0x0A,
	0xB2, 0x22, 0x24, 0x4A, 0xBB, 0xB8, 0x0B, 0x0C, 0x1A, 0x66, 0x6B, 0x17,
	0xE2, 0x22, 0xC3, 0xF2, 0x22, 0xC4, 0x1B, 0x8E, 0x82, 0x62, 0xC3, 0xF0,
	0xEE, 0xA0, 0x69, 0x0E, 0xD2, 0x22, 0xC3, 0x0B, 0xDD, 0xD0, 0xD9, 0x93,
	0x0C, 0x09, 0xD0, 0x9A, 0x83, 0x16, 0x49, 0x07, 0x92, 0x22, 0x24, 0xD2,
	0x22, 0x21, 0x4A, 0x99, 0xA8, 0x09, 0x5A, 0xDD, 0xE6, 0x9A, 0x1A, 0xC2,
	0x22, 0xBF, 0xD2, 0x1D, 0x08, 0xB8, 0xA2, 0xE2, 0x22, 0x46, 0x4A, 0xBB,
	0xE0, 0xEA, 0xA0, 0xD9, 0x0E, 0xA8, 0x09, 0xB8, 0x0B, 0xC0, 0xCA, 0xA0,
	0xB9, 0x0C, 0x88, 0x13, 0x82, 0x28, 0x3F, 0xE0, 0x08, 0x00, 0x9C, 0x6A,
	0x0C, 0x19, 0xA2, 0x22, 0x21, 0xC2, 0x12, 0x75, 0x5A, 0xAA, 0xA2, 0x1A,
	0x08, 0xB2, 0x22, 0xC5, 0xC0, 0xAA, 0xC0, 0xB0, 0xAA, 0xA0, 0x99, 0x0A,
	0x88, 0x13, 0xA2, 0x22, 0x24, 0x82, 0x28, 0x3E, 0x4A, 0xAA, 0xA8, 0x0A,
	0xE0, 0x08, 0x00, 0x9C, 0x6A, 0x0C, 0x19, 0xA2, 0x22, 0x21, 0xC2, 0x12,
	0x75, 0x5A, 0xAA, 0xA2, 0x1A, 0x08, 0xB2, 0x22, 0xC6, 0xC0, 0xAA, 0xC0,
	0xB0, 0xAA, 0xA0, 0x99, 0x0A, 0x2B, 0x55, 0x4B, 0x44, 0x0C, 0x0C, 0x0C,
	0x0D, 0x70, 0xA0, 0x34, 0xB2, 0x12, 0x17, 0x1B, 0x66, 0xB7, 0xA6, 0x02,
	0x06, 0xC0, 0xFF, 0xD2, 0x12, 0x16, 0xE2, 0x22, 0x3E, 0xF2, 0xA0, 0x80,
	0xF0, 0xEE, 0x20, 0xE2, 0x62, 0x3E, 0xA6, 0x1D, 0x19, 0xA2, 0x22, 0x23,
	0x0C, 0x0C, 0xF2, 0xAF, 0x7F, 0x1B, 0xCC, 0x88, 0x0A, 0x4B, 0xAA, 0xE6,
	0x68, 0x05, 0xF0, 0xEE, 0x10, 0xE2, 0x62, 0x3E, 0xD7, 0x2C, 0xED, 0xE0,
	0x97, 0x04, 0x56, 0xA9, 0x08, 0x0C, 0x07, 0x0C, 0x05, 0x0C, 0x06, 0xE2,
	0xC1, 0x10, 0xDD, 0x01, 0xB2, 0x22, 0xC5, 0x0C, 0x04, 0xFD, 0x0B, 0x2B,
	0x66, 0x1B, 0x77, 0xA8, 0x0F, 0x4B, 0xFF, 0xCC, 0x7A, 0xC2, 0x22, 0xC6,
	0x5A, 0xCC, 0xC8, 0x0C, 0xAC, 0x7C, 0x0C, 0x28, 0xC2, 0x22, 0x23, 0xA2,
	0x22, 0x24, 0x4A, 0xCC, 0x4A, 0xAA, 0x76, 0xA8, 0x19, 0x88, 0x0C, 0x0C,
	0x19, 0x26, 0x98, 0x01, 0x99, 0x0D, 0x4B, 0xCC, 0x0C, 0xB9, 0x88, 0x0A,
	0x4B, 0xAA, 0x97, 0x18, 0x03, 0x0C, 0x18, 0x89, 0x0E, 0x3D, 0xF0, 0x8B,
	0x44, 0x4B, 0x55, 0x4B, 0xDD, 0x4B, 0xEE, 0x66, 0x47, 0xB8, 0x0C, 0x0D,
	0xCD, 0x01, 0xA2, 0xC1, 0x10, 0x0C, 0x49, 0x76, 0xA9, 0x20, 0xE8, 0x0B,
	0x4B, 0xBB, 0xCC, 0x7E, 0xF2, 0x22, 0xC6, 0xDA, 0xFF, 0xF8, 0x0F, 0x8C,
	0xAF, 0x98, 0x0A, 0x88, 0x0C, 0x97, 0x98, 0x04, 0x0C, 0x09, 0x06, 0x03,
	0x00, 0x4B, 0xDD, 0x4B, 0xAA, 0x4B, 0xCC, 0x0C, 0x19, 0x46, 0x00, 0x00,
	0x0C, 0x09, 0x3C, 0x0D, 0x2C, 0x7C, 0x1C, 0x7E, 0x16, 0x99, 0x0C, 0xC2,
	0x62, 0xD7, 0xA2, 0x22, 0x36, 0x86, 0x00, 0x00, 0xE2, 0x62, 0xD7, 0xD7,
	0x1A, 0x16, 0x2C, 0xCB, 0xB7, 0x1A, 0x11, 0x66, 0xBA, 0x06, 0x0C, 0xFC,
	0x46, 0x02, 0x00, 0x00, 0x00, 0xC2, 0xCA, 0xF8, 0x56, 0x0C, 0x0A, 0x0C,
	0x7C, 0xC2, 0x62, 0xD7, 0xAD, 0x02, 0xB8, 0x91, 0xE5, 0x87, 0xFF, 0x0C,
	0x09, 0x0C, 0x0A, 0x0C, 0x6D, 0x76, 0xAD, 0x19, 0x82, 0x22, 0x10, 0xF2,
	0x22, 0x11, 0xE2, 0x22, 0x12, 0xAA, 0xFF, 0xAA, 0xEE, 0xAA, 0x88, 0x92,
	0x58, 0x00, 0x2B, 0xAA, 0x92, 0x5F, 0x00, 0x92, 0x5E, 0x00, 0x0C, 0xCA,
	0x0C, 0x48, 0x76, 0xA8, 0x18, 0xC8, 0xE2, 0xD2, 0x22, 0x10, 0xB2, 0x22,
	0x12, 0xAA, 0xDD, 0xAA, 0xBB, 0xAA, 0xCC, 0xC2, 0x9C, 0x00, 0x2B, 0xAA,
	0xC2, 0x5D, 0x00, 0x92, 0x5B, 0x00, 0xE2, 0x22, 0x3E, 0x17, 0x6E, 0x09,
	0x88, 0x13, 0x82, 0x28, 0x32, 0xAD, 0x02, 0xE0, 0x08, 0x00, 0x1C, 0xFC,
	0x0C, 0x0A, 0x0C, 0x1E, 0xD1, 0xB3, 0x3B, 0xE0, 0x00, 0xF3, 0xD2, 0x2D,
	0x7F, 0x6F, 0xF4, 0x00, 0x22, 0x44, 0x0C, 0x0C, 0x11, 0xEF, 0xFA, 0x00,
	0x22, 0x02, 0x0B, 0x04, 0x00, 0xAF, 0xE0, 0x0A, 0x22, 0xA4, 0x00, 0x80,
	0x00, 0x0F, 0x6C, 0xA7, 0x42, 0x40, 0x00, 0x01, 0x01, 0xBA, 0xB2, 0x4F,
	0x00, 0x04, 0x28, 0x44, 0x0C, 0x0C, 0x11, 0x80, 0x0B, 0x0D, 0xA2, 0x62,
	0xDC, 0x1D, 0xF0, 0x00, 0xCD, 0x0E, 0xC6, 0xD6, 0xFF, 0xF8, 0x73, 0xF2,
	0x2F, 0x46, 0xF8, 0x3F, 0xA2, 0x22, 0x36, 0x16, 0x1F, 0xF3, 0x82, 0xCA,
	0xD0, 0x56, 0xB8, 0xF2, 0xC2, 0x62, 0xD7, 0x06, 0xCA, 0xFF, 0x92, 0x22,
	0x23, 0x76, 0x9A, 0x1E, 0xA8, 0x09, 0x4B, 0x99, 0x66, 0x4A, 0x15, 0x88,
	0x13, 0xAD, 0x02, 0x82, 0x28, 0x3C, 0x0C, 0x1B, 0xE0, 0x08, 0x00, 0xBD,
	0x0A, 0xAD, 0x02, 0xE5, 0xA7, 0xFF, 0x06, 0x43, 0xFF, 0x1B, 0xCC, 0xC6,
	0x41, 0xFF, 0x00, 0x00, 0x36, 0xE1, 0x00, 0x42, 0x61, 0x10, 0x30, 0xC0,
	0xF4, 0x71, 0x49, 0x3B, 0xAD, 0x02, 0x88, 0x17, 0x0C, 0x0B, 0x82, 0x28,
	0x3B, 0xDD, 0x01, 0xE0, 0x08, 0x00, 0xA0, 0x90, 0xF4, 0xA6, 0x19, 0x59,
	0x5D, 0x01, 0x50, 0x49, 0x90, 0xB2, 0x95, 0x00, 0x26, 0x0B, 0x49, 0xA8,
	0xA2, 0xA0, 0xAB, 0xA0, 0xA8, 0x0A, 0x0C, 0xBD, 0xBC, 0xDA, 0xC2, 0x22,
	0x24, 0xC0, 0xCB, 0xA0, 0xC8, 0x0C, 0xD7, 0x9C, 0x33, 0xD2, 0x21, 0x10,
	0x6D, 0x0D, 0x66, 0x0D, 0x0E, 0x88, 0x07, 0x88, 0x98, 0xE0, 0x08, 0x00,
	0x62, 0x12, 0x74, 0xA0, 0x66, 0xC0, 0x0B, 0x66, 0xA6, 0x16, 0x19, 0x0C,
	0x03, 0x0C, 0x0B, 0xC8, 0xA2, 0x88, 0x07, 0xA2, 0x95, 0x00, 0x88, 0x68,
	0xC0, 0xAA, 0xA0, 0xA8, 0x0A, 0xE0, 0x08, 0x00, 0x1B, 0x33, 0x37, 0x96,
	0xE7, 0x2B, 0x55, 0x47, 0x95, 0xAA, 0x1D, 0xF0, 0x36, 0x41, 0x00, 0x62,
	0x12, 0x75, 0x42, 0x12, 0x76, 0x67, 0x23, 0x0F, 0x37, 0x24, 0x0C, 0x42,
	0x22, 0xC5, 0x60, 0x23, 0xC0, 0x40, 0x22, 0xA0, 0x28, 0x02, 0x1D, 0xF0,
	0x0C, 0x02, 0x1D, 0xF0, 0x36, 0x41, 0x00, 0x0C, 0x09, 0xA1, 0x42, 0x3B,
	0xC0, 0x20, 0x00, 0x81, 0x69, 0x3B, 0x82, 0x28, 0x7F, 0x92, 0x6A, 0x9C,
	0xE0, 0x08, 0x00, 0x1D, 0xF0, 0x00, 0x00, 0x00, 0x36, 0x41, 0x00, 0x0C,
	0x09, 0xA1, 0x3B, 0x3B, 0xC0, 0x20, 0x00, 0x81, 0x63, 0x3B, 0x82, 0x28,
	0x7F, 0x92, 0x6A, 0x9C, 0xE0, 0x08, 0x00, 0x1D, 0xF0, 0x00, 0x00, 0x00,
	0x36, 0x41, 0x00, 0x0C, 0x0B, 0x21, 0x2D, 0x3B, 0x31, 0x5E, 0x3B, 0xC0,
	0x20, 0x00, 0xB2, 0x63, 0x9B, 0xF2, 0x22, 0x69, 0xC0, 0x20, 0x00, 0x0C,
	0xCD, 0xF2, 0x63, 0x82, 0xE2, 0x22, 0x68, 0x0C, 0x4C, 0xE0, 0xCD, 0x83,
	0xC0, 0x20, 0x00, 0xC2, 0x63, 0x80, 0xC0, 0x20, 0x00, 0xB2, 0x63, 0x8C,
	0xA2, 0x22, 0x60, 0xC0, 0x20, 0x00, 0xA2, 0x63, 0x8E, 0x92, 0x22, 0x61,
	0xC0, 0x20, 0x00, 0x92, 0x63, 0x8F, 0x82, 0x22, 0x62, 0xC0, 0x20, 0x00,
	0x82, 0x63, 0x85, 0x72, 0x22, 0x63, 0xC0, 0x20, 0x00, 0x72, 0x63, 0x86,
	0x62, 0x22, 0x64, 0xC0, 0x20, 0x00, 0x62, 0x63, 0x87, 0x52, 0x22, 0x65,
	0xC0, 0x20, 0x00, 0x52, 0x63, 0x88, 0x42, 0x22, 0x66, 0xC0, 0x20, 0x00,
	0x42, 0x63, 0x89, 0x22, 0x22, 0x67, 0xC0, 0x20, 0x00, 0x22, 0x63, 0x8A,
	0x1D, 0xF0, 0x00, 0x00, 0x36, 0x41, 0x00, 0x61, 0xF7, 0x3A, 0x16, 0xE3,
	0x06, 0x26, 0x13, 0x7D, 0x0C, 0x17, 0x82, 0xC3, 0xFE, 0x16, 0x78, 0x0F,
	0xC2, 0xC3, 0xFD, 0x16, 0x2C, 0x0D, 0xD2, 0xC3, 0xFC, 0x16, 0x6D, 0x08,
	0xE2, 0xC3, 0xF9, 0x16, 0x7E, 0x09, 0x1C, 0x8F, 0xF7, 0x93, 0x5C, 0x40,
	0x80, 0x74, 0x66, 0x78, 0x56, 0xB2, 0xA0, 0x80, 0x0C, 0x09, 0x70, 0x64,
	0x00, 0x82, 0x26, 0xAA, 0xA2, 0x26, 0xA6, 0x88, 0x68, 0x92, 0x66, 0xA8,
	0xE0, 0x08, 0x00, 0x82, 0x26, 0xAA, 0xA2, 0x26, 0xA6, 0x88, 0x68, 0x2C,
	0xFB, 0xE0, 0x08, 0x00, 0x82, 0x26, 0xAA, 0xA2, 0x26, 0xA6, 0x88, 0x68,
	0x50, 0xB8, 0x74, 0xE0, 0x08, 0x00, 0x82, 0x26, 0xAA, 0xA2, 0x26, 0xA6,
	0x88, 0x68, 0x50, 0xB0, 0x74, 0xE0, 0x08, 0x00, 0x70, 0xE6, 0x13, 0x20,
	0x20, 0x00, 0x1D, 0xF0, 0x52, 0x66, 0xAA, 0x98, 0x22, 0xA8, 0x12, 0xA2,
	0x66, 0xA6, 0x92, 0x66, 0xA7, 0xE5, 0xEF, 0xFF, 0x1D, 0xF0, 0x40, 0xC0,
	0x74, 0x66, 0x7C, 0xF7, 0x8C, 0xE5, 0xBD, 0x05, 0x82, 0x26, 0xAA, 0xA1,
	0x1C, 0x3B, 0x82, 0x28, 0x20, 0x2C, 0x8C, 0xE0, 0x08, 0x00, 0x25, 0xEE,
	0xFF, 0x1D, 0xF0, 0x40, 0x90, 0x74, 0x56, 0xA9, 0xFD, 0xA0, 0x64, 0x00,
	0x72, 0x66, 0xA8, 0x52, 0x66, 0xA9, 0xA0, 0xE6, 0x13, 0x20, 0x20, 0x00,
	0x1D, 0xF0, 0xA2, 0x26, 0xA6, 0x16, 0x3A, 0xFC, 0x82, 0x26, 0xAA, 0x88,
	0x98, 0xE0, 0x08, 0x00, 0xB6, 0x4A, 0xB8, 0x0C, 0x6A, 0x0C, 0x0B, 0x0C,
	0x4C, 0x50, 0x64, 0x00, 0x82, 0x26, 0xAA, 0x0C, 0x1D, 0x82, 0x28, 0x10,
	0x0C, 0x0E, 0xE0, 0x08, 0x00, 0x50, 0xE6, 0x13, 0x20, 0x20, 0x00, 0x1D,
	0xF0, 0x1C, 0x09, 0xF0, 0x64, 0x00, 0xA0, 0xE4, 0x03, 0x90, 0xAA, 0x20,
	0x90, 0xAA, 0x30, 0xA0, 0xE4, 0x13, 0xF0, 0xE6, 0x13, 0x10, 0x20, 0x00,
	0x90, 0xE3, 0x13, 0xE5, 0xE7, 0xFF, 0x1D, 0xF0, 0x1C, 0x05, 0x65, 0xE7,
	0xFF, 0xB1, 0xFC, 0x3A, 0xC2, 0xA0, 0x64, 0x41, 0xFD, 0x3A, 0x0C, 0x43,
	0x2D, 0x07, 0x00, 0x50, 0x00, 0x50, 0xE3, 0x13, 0xF0, 0x64, 0x00, 0xD0,
	0xE4, 0x03, 0x50, 0xDD, 0x20, 0xD0, 0xE4, 0x13, 0xF0, 0xE6, 0x13, 0x10,
	0x20, 0x00, 0xC0, 0x20, 0x00, 0xC2, 0x6B, 0x8C, 0xC0, 0x20, 0x00, 0x72,
	0x6B, 0x9B, 0x1D, 0xF0, 0x36, 0x81, 0x00, 0x0C, 0x04, 0x31, 0xA5, 0x3A,
	0x21, 0xEE, 0x3A, 0xA1, 0xC3, 0x3A, 0xC0, 0x20, 0x00, 0x42, 0x6A, 0x9C,
	0xC0, 0x20, 0x00, 0x92, 0x22, 0x8D, 0xC0, 0x20, 0x00, 0x99, 0x01, 0x49,
	0x11, 0x49, 0x21, 0x1C, 0x7A, 0xBD, 0x04, 0x0C, 0x4C, 0x82, 0x23, 0xAA,
	0x0C, 0x0D, 0x82, 0x28, 0x10, 0x8B, 0xE1, 0xE0, 0x08, 0x00, 0x61, 0xE5,
	0x3A, 0xC2, 0x26, 0x7F, 0xC0, 0x20, 0x00, 0xB8, 0x01, 0xC7, 0x8B, 0x02,
	0x86, 0x45, 0x00, 0x0C, 0x47, 0xC0, 0x20, 0x00, 0xD8, 0x01, 0xE8, 0x21,
	0xD0, 0xD5, 0x04, 0x16, 0xBD, 0x07, 0x56, 0x6E, 0x10, 0xF2, 0x23, 0xA6,
	0x98, 0x11, 0x16, 0xCF, 0x12, 0x0C, 0x6A, 0x0C, 0x0B, 0x0C, 0x4C, 0x82,
	0x23, 0xAA, 0x0C, 0x1D, 0x82, 0x28, 0x10, 0x0C, 0x1E, 0xE0, 0x08, 0x00,
	0x82, 0x23, 0xAA, 0x88, 0x98, 0xA2, 0x23, 0xA6, 0xE0, 0x08, 0x00, 0x9D,
	0x0A, 0xA9, 0x11, 0x46, 0x3D, 0x00, 0x49, 0x31, 0x1C, 0x7A, 0x0C, 0x0B,
	0x0C, 0x4C, 0x82, 0x23, 0xAA, 0x0C, 0x5D, 0x82, 0x28, 0x10, 0xCB, 0xE1,
	0xE0, 0x08, 0x00, 0xD8, 0x31, 0xD0, 0xD0, 0x74, 0xC0, 0x20, 0x00, 0xD2,
	0x62, 0x84, 0xC8, 0x31, 0xC0, 0xC8, 0x74, 0xC0, 0x20, 0x00, 0xC2, 0x62,
	0x84, 0xB8, 0x31, 0xB0, 0xB0, 0x75, 0xC0, 0x20, 0x00, 0xB2, 0x62, 0x84,
	0x98, 0x31, 0x90, 0x98, 0x75, 0xC0, 0x20, 0x00, 0x92, 0x62, 0x84, 0xC0,
	0x20, 0x00, 0xE2, 0x22, 0x94, 0xC0, 0x20, 0x00, 0xE9, 0x01, 0xC0, 0x20,
	0x00, 0xF8, 0x01, 0x27, 0x6F, 0x57, 0xC0, 0x20, 0x00, 0x52, 0x22, 0x9E,
	0xBC, 0x75, 0xC0, 0x20, 0x00, 0x82, 0x22, 0x84, 0x80, 0x80, 0x74, 0xC0,
	0x20, 0x00, 0xA2, 0x23, 0xA7, 0x89, 0x41, 0x9C, 0xFA, 0x92, 0x23, 0xA8,
	0x66, 0x29, 0x0D, 0xC0, 0x20, 0x00, 0xA8, 0x41, 0x65, 0x43, 0x01, 0xC6,
	0x03, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x20, 0x00, 0x82, 0x23, 0xAA, 0x88,
	0x68, 0xB8, 0x41, 0xE0, 0x08, 0x00, 0x0B, 0x55, 0x56, 0x65, 0xFC, 0x82,
	0x23, 0xAA, 0x82, 0x28, 0x18, 0xE0, 0x08, 0x00, 0x0C, 0x7B, 0x82, 0x23,
	0xAA, 0xCD, 0x0A, 0x88, 0xF8, 0x0C, 0x7A, 0xE0, 0x08, 0x00, 0xC0, 0x20,
	0x00, 0x98, 0x01, 0x67, 0x69, 0x0A, 0xC0, 0x20, 0x00, 0xB2, 0x22, 0x95,
	0xC0, 0x20, 0x00, 0xB9, 0x01, 0xC0, 0x20, 0x00, 0xE2, 0x22, 0x8D, 0xC0,
	0x20, 0x00, 0xE9, 0x01, 0xC0, 0x20, 0x00, 0xD8, 0x01, 0xC2, 0x26, 0x7F,
	0xD7, 0x0C, 0x02, 0x86, 0xBA, 0xFF, 0x1D, 0xF0, 0x49, 0x11, 0x1C, 0x7A,
	0x0C, 0x0B, 0x0C, 0x4C, 0x82, 0x23, 0xAA, 0x0C, 0x2D, 0x82, 0x28, 0x10,
	0x4B, 0xE1, 0xE0, 0x08, 0x00, 0x98, 0x11, 0xE0, 0x99, 0x11, 0x99, 0x11,
	0xE6, 0x49, 0x11, 0x0C, 0x4B, 0x76, 0xAB, 0x05, 0xC0, 0x20, 0x00, 0x42,
	0x62, 0x84, 0x46, 0xCE, 0xFF, 0x00, 0x86, 0xFA, 0xFF, 0xC8, 0x21, 0xD2,
	0x23, 0xA6, 0x56, 0xCC, 0xEE, 0xBC, 0xED, 0x0C, 0x05, 0xAC, 0x09, 0x26,
	0x45, 0x1E, 0x82, 0x23, 0xAA, 0x88, 0x78, 0xA2, 0x23, 0xA6, 0xE0, 0x08,
	0x00, 0xA0, 0xB0, 0x74, 0xC0, 0x20, 0x00, 0xB2, 0x62, 0x84, 0x98, 0x11,
	0x1B, 0x55, 0x0B, 0x99, 0x99, 0x11, 0xC6, 0xF6, 0xFF, 0xA2, 0x23, 0xA8,
	0x50, 0x97, 0xC0, 0x66, 0x1A, 0x12, 0x42, 0x63, 0x91, 0xC2, 0x23, 0xA9,
	0x1B, 0xDA, 0xD2, 0x63, 0xA8, 0xC2, 0x63, 0x90, 0x46, 0x00, 0x00, 0x0C,
	0x49, 0x76, 0xA9, 0x05, 0xC0, 0x20, 0x00, 0x42, 0x62, 0x84, 0x46, 0xB7,
	0xFF, 0x00, 0x00, 0x00, 0x36, 0x41, 0x00, 0x68, 0x02, 0x38, 0x12, 0x48,
	0x32, 0x58, 0x03, 0x60, 0x44, 0xA0, 0x4B, 0x33, 0x39, 0x12, 0x47, 0x33,
	0x01, 0x69, 0x12, 0x2D, 0x05, 0x1D, 0xF0, 0x00, 0x36, 0x41, 0x00, 0x51,
	0x71, 0x3A, 0x48, 0x02, 0x61, 0x23, 0x3A, 0x1B, 0x44, 0x47, 0x23, 0x1C,
	0xA2, 0x26, 0x9A, 0x25, 0xFD, 0xFF, 0xA0, 0xB0, 0xF4, 0x57, 0x9B, 0x09,
	0x49, 0x02, 0xA0, 0x20, 0x31, 0x80, 0x22, 0x23, 0x1D, 0xF0, 0x16, 0x1B,
	0xFE, 0x7C, 0xE2, 0x1D, 0xF0, 0x49, 0x02, 0x7C, 0xF2, 0x1D, 0xF0, 0x00,
	0x36, 0x41, 0x00, 0x68, 0x12, 0x58, 0x22, 0x28, 0x32, 0x67, 0x35, 0x0C,
	0x60, 0x35, 0xC0, 0x3B, 0x23, 0x30, 0x23, 0xB3, 0x20, 0x22, 0x21, 0x1D,
	0xF0, 0x50, 0x86, 0xC0, 0x3B, 0x38, 0x80, 0x38, 0xB3, 0x30, 0x32, 0x21,
	0x30, 0x22, 0xC0, 0x1D, 0xF0, 0x00, 0x00, 0x00, 0x36, 0x41, 0x00, 0x3D,
	0x02, 0x21, 0x0B, 0x3A, 0x82, 0x22, 0x97, 0x1C, 0x4A, 0x82, 0x28, 0x1D,
	0x0C, 0x4B, 0xE0, 0x08, 0x00, 0x0C, 0x4B, 0x82, 0x22, 0x97, 0x2D, 0x0A,
	0x82, 0x28, 0x1D, 0xE0, 0xA3, 0x11, 0xE0, 0x08, 0x00, 0x39, 0x32, 0xA9,
	0x02, 0xA9, 0x12, 0xA9, 0x22, 0x0C, 0x09, 0x99, 0x42, 0x1D, 0xF0, 0x00,
	0x36, 0x41, 0x00, 0xA1, 0xFF, 0x39, 0x82, 0x2A, 0x9A, 0xA2, 0x2A, 0x99,
	0x20, 0xA8, 0x93, 0x25, 0xF4, 0xFF, 0x2D, 0x0A, 0x1D, 0xF0, 0x00, 0x00,
	0x36, 0x41, 0x00, 0x80, 0xA2, 0x23, 0xA5, 0xF0, 0x00, 0x8C, 0x4A, 0x0C,
	0x02, 0x39, 0x1A, 0x1D, 0xF0, 0x0C, 0x22, 0x1D, 0xF0, 0x00, 0x00, 0x00,
	0x36, 0x41, 0x00, 0xA1, 0xF3, 0x39, 0x82, 0x2A, 0x9A, 0xA2, 0x2A, 0x99,
	0x20, 0xA8, 0x93, 0x25, 0xF6, 0xFF, 0x2D, 0x0A, 0x1D, 0xF0, 0x00, 0x00,
	0x36, 0x61, 0x00, 0x31, 0xED, 0x39, 0x82, 0x23, 0x9E, 0x0C, 0x0B, 0x8C,
	0x28, 0x7C, 0xE2, 0x1D, 0xF0, 0xB9, 0x01, 0xA2, 0x23, 0x9A, 0x25, 0xF4,
	0xFF, 0x4D, 0x0A, 0x16, 0xDA, 0x09, 0x0C, 0x26, 0xB2, 0x23, 0x9F, 0x0C,
	0x37, 0x16, 0x3B, 0x0A, 0xC2, 0xCB, 0xFE, 0x16, 0x5C, 0x0B, 0x66, 0x3B,
	0x02, 0x22, 0x23, 0xA1, 0xB8, 0x01, 0x47, 0xAB, 0x70, 0x0C, 0x05, 0x0B,
	0x22, 0x96, 0x42, 0x03, 0xA2, 0x23, 0x9A, 0x1B, 0xDB, 0xD9, 0x01, 0x25,
	0xEC, 0xFF, 0xB2, 0x23, 0xA3, 0x9C, 0x0B, 0xE8, 0x5B, 0x66, 0x1E, 0x0C,
	0xF8, 0x6B, 0x88, 0x4B, 0x1B, 0x9F, 0x99, 0x6B, 0x80, 0xFF, 0xA0, 0xA9,
	0x0F, 0xC8, 0x2B, 0xA8, 0x6B, 0xC0, 0xC2, 0x21, 0xC7, 0x9A, 0x39, 0xD2,
	0x23, 0xA4, 0x59, 0x6B, 0x1B, 0xDD, 0xD2, 0x63, 0xA4, 0x52, 0x63, 0x9F,
	0xAD, 0x01, 0xBD, 0x04, 0x65, 0xEA, 0xFF, 0x2D, 0x0A, 0x96, 0xBA, 0x03,
	0xA2, 0x63, 0xA0, 0x80, 0xAA, 0x23, 0x65, 0xE5, 0x00, 0xE8, 0x01, 0xA2,
	0x63, 0xA3, 0x1B, 0xBE, 0x47, 0xAE, 0x21, 0xB9, 0x01, 0xA2, 0x23, 0x9A,
	0xA5, 0xE6, 0xFF, 0xA0, 0x22, 0x21, 0x22, 0x63, 0xA1, 0xB8, 0x01, 0x47,
	0x2B, 0x90, 0x8C, 0x42, 0x72, 0x63, 0x9F, 0x22, 0x63, 0xA1, 0x0C, 0x02,
	0x1D, 0xF0, 0x00, 0x00, 0x00, 0x62, 0x63, 0x9F, 0x7C, 0xF2, 0x1D, 0xF0,
	0x7C, 0xEF, 0xF7, 0x9A, 0xEE, 0x0C, 0x18, 0x82, 0x63, 0x9E, 0x1D, 0xF0,
	0xAD, 0x01, 0xBD, 0x04, 0x25, 0xE5, 0xFF, 0x2D, 0x0A, 0xD6, 0x3A, 0x02,
	0x7C, 0xE9, 0x97, 0x9A, 0xD6, 0x0C, 0x1A, 0xA2, 0x63, 0x9E, 0x1D, 0xF0,
	0xA2, 0x23, 0x9A, 0x25, 0xE2, 0xFF, 0xB8, 0x01, 0xA0, 0x22, 0x21, 0x1B,
	0xBB, 0xB9, 0x01, 0x22, 0x63, 0xA1, 0x72, 0x63, 0x9F, 0x46, 0xCE, 0xFF,
	0xA2, 0x63, 0xA0, 0x62, 0x63, 0x9F, 0x80, 0xAA, 0x23, 0xA5, 0xDD, 0x00,
	0xC8, 0x01, 0xA2, 0x63, 0xA3, 0x1B, 0xBC, 0x47, 0xAC, 0xA9, 0xB9, 0x01,
	0xA2, 0x23, 0x9A, 0x25, 0xDF, 0xFF, 0xA0, 0x22, 0x21, 0xB8, 0x01, 0x06,
	0xF4, 0xFF, 0x00, 0x00, 0x36, 0x41, 0x00, 0x21, 0xA4, 0x39, 0x22, 0x22,
	0x98, 0x0C, 0x03, 0xBC, 0x62, 0x88, 0x32, 0xEC, 0xD8, 0xA2, 0x92, 0x11,
	0x92, 0x92, 0x10, 0x1B, 0xBA, 0xB2, 0x52, 0x11, 0xA7, 0x99, 0x20, 0x40,
	0x64, 0x00, 0x0C, 0x4A, 0xBD, 0x02, 0x25, 0xD5, 0x00, 0x0C, 0x4A, 0x8B,
	0xB2, 0xA5, 0xD4, 0x00, 0xA8, 0x22, 0xB8, 0x42, 0x25, 0xD4, 0x00, 0x40,
	0xE6, 0x13, 0x20, 0x20, 0x00, 0x32, 0x52, 0x11, 0x28, 0x72, 0x56, 0x72,
	0xFC, 0x1D, 0xF0, 0x00, 0x36, 0x41, 0x00, 0x0C, 0x14, 0x71, 0x91, 0x39,
	0x80, 0x64, 0x00, 0x52, 0x27, 0x9B, 0x0C, 0x03, 0x52, 0xC5, 0xFE, 0x50,
	0x34, 0x83, 0x27, 0x93, 0x02, 0x56, 0xF2, 0x05, 0x0C, 0x05, 0x1C, 0x0D,
	0xB1, 0xA3, 0x39, 0xA2, 0x27, 0x99, 0x0C, 0x1E, 0x6D, 0x02, 0x20, 0x6E,
	0x93, 0x48, 0x0A, 0xC8, 0x1B, 0xC2, 0x67, 0x9C, 0x49, 0x1A, 0x49, 0x2A,
	0xB8, 0x2B, 0x92, 0xC4, 0x40, 0x76, 0xAD, 0x03, 0x59, 0x04, 0x4B, 0x44,
	0x99, 0x2A, 0x9C, 0x5B, 0xA2, 0x27, 0x9A, 0x1C, 0x0F, 0x48, 0x0A, 0x49,
	0x1A, 0x49, 0x2A, 0x92, 0xC4, 0x40, 0x76, 0xAF, 0x03, 0x59, 0x04, 0x4B,
	0x44, 0x99, 0x2A, 0x9C, 0x62, 0x0C, 0x29, 0x8C, 0xFB, 0x52, 0x67, 0xA1,
	0x52, 0x67, 0xA2, 0x52, 0x67, 0x9F, 0x52, 0x67, 0x9E, 0x7C, 0xF3, 0x32,
	0x67, 0xA0, 0xC0, 0x69, 0x83, 0x62, 0x67, 0x9B, 0x80, 0xE6, 0x13, 0x20,
	0x20, 0x00, 0x1D, 0xF0, 0x36, 0x41, 0x00, 0xA8, 0x02, 0xA0, 0xA2, 0x21,
	0xA5, 0xD8, 0xFF, 0x31, 0x6F, 0x39, 0xB8, 0x22, 0xA2, 0x63, 0x99, 0x8C,
	0x9B, 0xA8, 0x02, 0xA0, 0xA2, 0x21, 0xA5, 0xD7, 0xFF, 0xA2, 0x63, 0x9A,
	0x1D, 0xF0, 0x00, 0x00, 0x36, 0x41, 0x00, 0x2D, 0x05, 0xA1, 0x7F, 0x39,
	0x51, 0x67, 0x39, 0x16, 0x93, 0x0D, 0x0C, 0x06, 0x26, 0x13, 0x59, 0x26,
	0x43, 0x25, 0x26, 0x73, 0x76, 0x82, 0xC3, 0xEB, 0x16, 0xF8, 0x09, 0x1C,
	0x69, 0x97, 0x93, 0x46, 0x92, 0x25, 0x9B, 0x66, 0x19, 0x40, 0xA2, 0x25,
	0x9C, 0x0C, 0x2B, 0x0B, 0xAA, 0xA2, 0x65, 0x9C, 0xA0, 0x9B, 0x83, 0x92,
	0x65, 0x9B, 0x1D, 0xF0, 0x16, 0x04, 0x0B, 0x0B, 0xB4, 0x16, 0xCB, 0x09,
	0xC2, 0xC4, 0xFE, 0x16, 0x5C, 0x0B, 0xD2, 0xC4, 0xFD, 0x16, 0xFD, 0x0D,
	0xE2, 0xC4, 0xFC, 0x16, 0x5E, 0x0E, 0xF2, 0xC4, 0xFB, 0x16, 0x5F, 0x0B,
	0x82, 0xC4, 0xFA, 0x16, 0x18, 0x0C, 0x92, 0xC4, 0xF9, 0x16, 0x09, 0x0C,
	0x26, 0x84, 0x75, 0x1D, 0xF0, 0x1C, 0x7B, 0x40, 0xA0, 0x74, 0xB7, 0x9A,
	0xF5, 0xAD, 0x02, 0x25, 0xEE, 0xFF, 0x56, 0xD2, 0xFE, 0x62, 0x65, 0x9D,
	0x1C, 0xDA, 0x82, 0x25, 0x97, 0x1C, 0x8B, 0x88, 0xF8, 0x0C, 0x0C, 0xE0,
	0x08, 0x00, 0x1D, 0xF0, 0x92, 0x25, 0x9B, 0xB8, 0x2A, 0x66, 0x29, 0xD2,
	0x16, 0xFB, 0xFC, 0x25, 0xD5, 0xFF, 0xC2, 0x25, 0xA4, 0x66, 0x3C, 0xC6,
	0xA2, 0x25, 0xA5, 0x62, 0x65, 0xA4, 0x8C, 0x1A, 0xE0, 0x0A, 0x00, 0x1C,
	0x5A, 0x82, 0x25, 0x97, 0x0C, 0x0B, 0x88, 0xF8, 0x0C, 0x0C, 0xE0, 0x08,
	0x00, 0x1D, 0xF0, 0x92, 0x25, 0x9B, 0x66, 0x29, 0xA5, 0xA5, 0xE4, 0xFF,
	0xA2, 0x25, 0x9D, 0x56, 0xCA, 0xF9, 0x1C, 0xDA, 0x1C, 0x8B, 0x82, 0x25,
	0x97, 0x0C, 0x1C, 0x88, 0xF8, 0xC2, 0x65, 0x9D, 0xE0, 0x08, 0x00, 0x1D,
	0xF0, 0x92, 0x25, 0x9B, 0x99, 0x02, 0x1D, 0xF0, 0x22, 0x65, 0x97, 0x25,
	0xEF, 0xFF, 0x1D, 0xF0, 0xB2, 0x25, 0x9B, 0x0C, 0x1A, 0xB2, 0xCB, 0xFE,
	0xB0, 0x6A, 0x83, 0x9D, 0x06, 0xC6, 0xF8, 0xFF, 0xA8, 0x02, 0xA0, 0xA0,
	0xF4, 0xA6, 0x2A, 0x02, 0xC6, 0xD7, 0xFF, 0xA5, 0xCC, 0xFF, 0xA9, 0x02,
	0x1D, 0xF0, 0xA8, 0x02, 0xA0, 0xA0, 0xF4, 0xA6, 0x2A, 0x02, 0x46, 0xD3,
	0xFF, 0x65, 0xC8, 0xFF, 0xA9, 0x02, 0x1D, 0xF0, 0x22, 0x65, 0xA5, 0x1D,
	0xF0, 0x20, 0xB0, 0xF4, 0xB9, 0x1A, 0x1D, 0xF0, 0xA8, 0x02, 0x0C, 0x1B,
	0xA0, 0xA0, 0xF4, 0x65, 0xC8, 0xFF, 0x1D, 0xF0, 0xA8, 0x02, 0xBD, 0x06,
	0xA0, 0xA0, 0xF4, 0xA5, 0xC7, 0xFF, 0x1D, 0xF0, 0x36, 0x41, 0x00, 0xED,
	0x03, 0xA1, 0x2C, 0x39, 0xF0, 0x64, 0x00, 0x92, 0xDA, 0xF6, 0x92, 0x29,
	0x86, 0x81, 0x60, 0x39, 0xC0, 0x99, 0x11, 0x9A, 0x88, 0x92, 0xC2, 0xF6,
	0x82, 0x28, 0x7F, 0xE0, 0x99, 0x11, 0x00, 0x09, 0x40, 0x91, 0x5C, 0x39,
	0x80, 0x80, 0xB1, 0x80, 0x80, 0x34, 0x42, 0xC9, 0xE8, 0xEC, 0xD8, 0xC2,
	0x2A, 0x7F, 0x40, 0xB2, 0xB0, 0xB2, 0x2B, 0x7F, 0xC0, 0xCB, 0xA0, 0xD8,
	0x0C, 0xE0, 0xBB, 0x11, 0x66, 0x2D, 0x3D, 0xD2, 0x2A, 0x80, 0x90, 0x82,
	0xA0, 0xD0, 0xBB, 0xA0, 0xA8, 0x1B, 0x0C, 0x0D, 0xAC, 0xDA, 0xA2, 0x68,
	0x7F, 0xD9, 0x1B, 0x0C, 0x18, 0x89, 0x0C, 0x86, 0x08, 0x00, 0x90, 0x92,
	0xA0, 0x92, 0x29, 0x7F, 0x0C, 0x2D, 0x9C, 0x79, 0x82, 0x2A, 0x7F, 0x40,
	0x32, 0xB0, 0x32, 0x23, 0x7F, 0xC2, 0x2A, 0x80, 0xE0, 0xB3, 0x11, 0xC0,
	0xBB, 0xA0, 0x80, 0x33, 0xA0, 0xD9, 0x03, 0x99, 0x1B, 0xF0, 0xE6, 0x13,
	0x20, 0x20, 0x00, 0x0C, 0x8A, 0x0C, 0x0B, 0x81, 0xF3, 0x38, 0x0C, 0x4C,
	0x88, 0x08, 0xD2, 0xA2, 0x00, 0x82, 0x28, 0x10, 0xD0, 0xD2, 0x20, 0xE0,
	0x08, 0x00, 0x1D, 0xF0, 0x36, 0xE1, 0x00, 0x72, 0x12, 0x75, 0x82, 0x12,
	0x76, 0x77, 0xA8, 0x02, 0x06, 0x2A, 0x00, 0x61, 0xEA, 0x38, 0x72, 0x61,
	0x10, 0x88, 0x16, 0xAD, 0x02, 0x82, 0x28, 0x39, 0xBD, 0x07, 0xE0, 0x08,
	0x00, 0x16, 0x0A, 0x08, 0xAD, 0x02, 0x0C, 0x1B, 0xDD, 0x01, 0x88, 0x16,
	0xC2, 0x21, 0x10, 0x82, 0x28, 0x3B, 0xC0, 0xC0, 0xF4, 0xE0, 0x08, 0x00,
	0xA0, 0x90, 0xF4, 0xA6, 0x19, 0x66, 0x3D, 0x01, 0x4D, 0x01, 0x40, 0x49,
	0x90, 0xB2, 0x93, 0x00, 0x26, 0x0B, 0x54, 0x52, 0x22, 0x23, 0x88, 0x16,
	0x50, 0x5B, 0xA0, 0x58, 0x05, 0x82, 0x28, 0x3F, 0xAD, 0x05, 0xE0, 0x08,
	0x00, 0xBC, 0xFA, 0xF2, 0x22, 0x11, 0xF0, 0x95, 0x11, 0x9A, 0x9F, 0x66,
	0x35, 0x18, 0x82, 0x22, 0xDC, 0xEC, 0x48, 0xB2, 0x22, 0x11, 0xB0, 0xB5,
	0x90, 0xA2, 0x9B, 0x00, 0xC2, 0xAF, 0x60, 0xCA, 0xAA, 0xA2, 0x5B, 0x00,
	0x46, 0x04, 0x00, 0xD2, 0x22, 0x11, 0xE2, 0x22, 0x33, 0xD0, 0xD5, 0x90,
	0xC2, 0x9D, 0x00, 0xE0, 0xCC, 0xC0, 0xC2, 0x5D, 0x00, 0xE2, 0x99, 0x00,
	0xD6, 0x4E, 0x00, 0x0C, 0x08, 0x82, 0x59, 0x00, 0x2B, 0x33, 0x47, 0x93,
	0x9F, 0x1B, 0x77, 0xA2, 0x21, 0x10, 0x92, 0x12, 0x76, 0x1B, 0xAA, 0xA2,
	0x61, 0x10, 0x77, 0x29, 0x02, 0x06, 0xD7, 0xFF, 0x1D, 0xF0, 0x00, 0x00,
	0x36, 0x41, 0x00, 0xA2, 0x12, 0x16, 0x0C, 0x03, 0xE6, 0x1A, 0x02, 0xC6,
	0x2E, 0x00, 0x71, 0xBB, 0x38, 0x0C, 0x05, 0x42, 0x22, 0x23, 0xC8, 0x92,
	0x3A, 0x44, 0x3A, 0xCC, 0xC8, 0x0C, 0x48, 0x04, 0x16, 0xCC, 0x09, 0x88,
	0x17, 0x82, 0x28, 0x3F, 0xAD, 0x04, 0xE0, 0x08, 0x00, 0x16, 0xCA, 0x08,
	0xF0, 0x64, 0x11, 0x66, 0x34, 0x18, 0x92, 0x22, 0xDC, 0xEC, 0x49, 0xB2,
	0x22, 0x10, 0xB0, 0xB4, 0x90, 0xA2, 0x9B, 0x00, 0xC2, 0xAF, 0x60, 0xCA,
	0xAA, 0xA2, 0x5B, 0x00, 0x46, 0x04, 0x00, 0xD2, 0x22, 0x10, 0xE2, 0x22,
	0x33, 0xD0, 0xD4, 0x90, 0xC2, 0x9D, 0x00, 0xE0, 0xCC, 0xC0, 0xC2, 0x5D,
	0x00, 0x92, 0x22, 0x10, 0x6A, 0x99, 0xC2, 0x99, 0x00, 0xD6, 0x6C, 0x00,
	0x0C, 0x0C, 0xC2, 0x59, 0x00, 0x0C, 0x0C, 0x66, 0x34, 0x22, 0xD2, 0x22,
	0xDC, 0xFC, 0x8D, 0xA2, 0xA2, 0x80, 0xB8, 0xC2, 0x88, 0x27, 0xB0, 0xB4,
	0xA0, 0xB8, 0x0B, 0x88, 0x88, 0xAA, 0xAB, 0xE0, 0x08, 0x00, 0xC2, 0x22,
	0x10, 0x6A, 0xCC, 0xC2, 0x9C, 0x00, 0xC6, 0x06, 0x00, 0xA2, 0x22, 0x33,
	0xB8, 0xC2, 0x88, 0x27, 0xB0, 0xB4, 0xA0, 0xB8, 0x0B, 0x88, 0x88, 0xB0,
	0xAA, 0xA0, 0xE0, 0x08, 0x00, 0xC2, 0x22, 0x10, 0x6A, 0xCC, 0xC2, 0x9C,
	0x00, 0xD2, 0x22, 0x11, 0x6A, 0xDD, 0xC2, 0x5D, 0x00, 0xA2, 0x12, 0x16,
	0x4B, 0x33, 0x1B, 0x55, 0xA7, 0xA5, 0x02, 0x06, 0xD2, 0xFF, 0x1D, 0xF0,
	0x36, 0x41, 0x00, 0x0C, 0xD7, 0x0C, 0x08, 0x80, 0x00, 0xF3, 0x6F, 0xE9,
	0x08, 0x22, 0x44, 0x0C, 0x0C, 0x11, 0x6F, 0xE7, 0x0A, 0x22, 0x44, 0x0C,
	0x0C, 0x11, 0xAF, 0xE0, 0x0A, 0x22, 0xC2, 0x69, 0x04, 0x00, 0xAF, 0xE0,
	0x0A, 0x22, 0xC2, 0x69, 0x05, 0x00, 0xAF, 0xE0, 0x0A, 0x22, 0x48, 0x40,
	0x30, 0x11, 0xAF, 0xE0, 0x0A, 0x22, 0xD4, 0xE0, 0x21, 0x03, 0xAF, 0xE0,
	0x0A, 0x22, 0x44, 0x3C, 0x70, 0x09, 0xCF, 0x21, 0x74, 0x43, 0x44, 0x0C,
	0x0C, 0x11, 0xAF, 0xE0, 0x0A, 0x22, 0x40, 0x31, 0x18, 0x40, 0xAF, 0xE0,
	0x0A, 0x22, 0xA8, 0xA0, 0xD8, 0x01, 0xCF, 0x44, 0x92, 0x43, 0xC8, 0xD0,
	0x20, 0x05, 0xAF, 0xE0, 0x0A, 0x22, 0x44, 0x3C, 0x68, 0x09, 0xAF, 0xE0,
	0x0A, 0x22, 0x80, 0x40, 0x18, 0x40, 0xAF, 0xE0, 0x0A, 0x22, 0xFC, 0xC0,
	0x21, 0x03, 0xAF, 0xE0, 0x0A, 0x22, 0x44, 0x3C, 0x60, 0x09, 0xAF, 0xE0,
	0x0A, 0x22, 0xC0, 0x33, 0x18, 0x40, 0xAF, 0xE0, 0x0A, 0x22, 0xA8, 0xA0,
	0xD8, 0x01, 0xAF, 0xE0, 0x0A, 0x22, 0xF8, 0xA0, 0x20, 0x05, 0xAF, 0xE0,
	0x0A, 0x22, 0x44, 0x3C, 0x50, 0x09, 0xAF, 0xE0, 0x0A, 0x22, 0x80, 0x43,
	0x18, 0x40, 0xAF, 0xE0, 0x0A, 0x22, 0xF4, 0x90, 0x30, 0x02, 0xAF, 0xE0,
	0x0A, 0x22, 0x44, 0x3C, 0x48, 0x09, 0xAF, 0xE0, 0x0A, 0x22, 0x40, 0x13,
	0x18, 0x40, 0xAF, 0xE0, 0x0A, 0x22, 0xF0, 0x80, 0x09, 0x03, 0xAF, 0xE0,
	0x0A, 0x22, 0x44, 0x3C, 0x40, 0x09, 0x6F, 0x41, 0xA1, 0x42, 0x00, 0x73,
	0x18, 0x40, 0xEF, 0x2D, 0x0B, 0x62, 0xA8, 0x50, 0xB0, 0x03, 0x48, 0x76,
	0xEF, 0x0D, 0x05, 0x62, 0xEC, 0x40, 0xA0, 0x02, 0xEF, 0xED, 0x08, 0x62,
	0x44, 0x3C, 0x20, 0x09, 0x90, 0x90, 0x31, 0xEF, 0xE0, 0x62, 0x43, 0xC0,
	0x22, 0x18, 0x40, 0xEF, 0x2E, 0x69, 0x43, 0x30, 0x0C, 0x08, 0x01, 0x58,
	0x36, 0xEF, 0x4D, 0x0C, 0x62, 0x82, 0x02, 0x04, 0x11, 0x2F, 0x01, 0x28,
	0x48, 0x44, 0x0C, 0x0C, 0x11, 0x9A, 0x88, 0x8A, 0x55, 0x7A, 0x35, 0x8C,
	0x02, 0xCC, 0x34, 0x2D, 0x03, 0x46, 0x03, 0x00, 0x00, 0x04, 0x40, 0x30,
	0x92, 0xC0, 0x90, 0x90, 0xB1, 0x90, 0x22, 0xC0, 0x3D, 0x02, 0x39, 0x66,
	0x1D, 0xF0, 0x00, 0x00, 0x36, 0x41, 0x01, 0x82, 0x22, 0x35, 0x56, 0x08,
	0x08, 0x61, 0x3A, 0x38, 0x88, 0x16, 0xAD, 0x02, 0x82, 0x28, 0x39, 0xBD,
	0x03, 0xE0, 0x08, 0x00, 0x16, 0xEA, 0x06, 0x88, 0x16, 0xAD, 0x02, 0x82,
	0x28, 0x48, 0xBD, 0x03, 0xE0, 0x08, 0x00, 0xCC, 0x7A, 0x92, 0x22, 0x36,
	0x26, 0x89, 0x5A, 0x26, 0xB9, 0x57, 0x92, 0x22, 0x46, 0xA8, 0x39, 0x30,
	0xAA, 0xC0, 0x56, 0xCA, 0x33, 0xB8, 0x29, 0x30, 0xBB, 0xC0, 0x56, 0x4B,
	0x33, 0xAD, 0x02, 0xBD, 0x03, 0x0C, 0x0C, 0x0C, 0x1D, 0xE5, 0x36, 0x00,
	0xA2, 0x61, 0x1B, 0xC6, 0xCB, 0x00, 0x0C, 0x0B, 0xC8, 0xA2, 0x88, 0x06,
	0xA2, 0x93, 0x00, 0x88, 0x68, 0xC0, 0xAA, 0xA0, 0xA8, 0x0A, 0xE0, 0x08,
	0x00, 0xB8, 0xA2, 0xA2, 0x93, 0x00, 0xB0, 0xAA, 0xA0, 0xA8, 0x0A, 0x88,
	0x06, 0x88, 0x98, 0xE0, 0x08, 0x00, 0x92, 0x12, 0x74, 0x0B, 0x99, 0x97,
	0x3A, 0xD3, 0xA2, 0x21, 0x1D, 0x2B, 0x33, 0xA7, 0x93, 0x1E, 0x1D, 0xF0,
	0x1C, 0x09, 0xA0, 0xB0, 0xF4, 0xA6, 0x1B, 0xF5, 0x42, 0x61, 0x1A, 0x92,
	0x61, 0x19, 0x20, 0xC3, 0xA0, 0xC2, 0x61, 0x1F, 0x32, 0xC1, 0x10, 0x30,
	0xCB, 0x90, 0xC2, 0x61, 0x1D, 0xB2, 0x93, 0x00, 0x0C, 0x0D, 0x26, 0x0B,
	0xD0, 0xE2, 0x22, 0xC1, 0x0C, 0x08, 0x66, 0x2E, 0x09, 0xF2, 0x22, 0xC2,
	0xF8, 0x1F, 0xB7, 0x9F, 0x01, 0x0C, 0x1D, 0x0C, 0x1E, 0xD0, 0x8E, 0x83,
	0x16, 0x68, 0xFB, 0x0C, 0x0D, 0x92, 0x22, 0xC3, 0x0C, 0x0C, 0x66, 0x29,
	0x09, 0xA2, 0x22, 0xC4, 0xA8, 0x1A, 0xB7, 0x9A, 0x01, 0xDD, 0x0E, 0x0C,
	0x1E, 0xD0, 0xCE, 0x83, 0x16, 0xAC, 0xF9, 0x42, 0x22, 0x24, 0xA8, 0xA2,
	0x40, 0x4B, 0xA0, 0xA0, 0xAB, 0xA0, 0xA8, 0x0A, 0x48, 0x04, 0x16, 0x8A,
	0xF8, 0x0C, 0xB8, 0x87, 0x94, 0x02, 0x46, 0xDC, 0xFF, 0xF0, 0x74, 0x11,
	0xE0, 0x94, 0x11, 0x92, 0x61, 0x1C, 0x88, 0x06, 0x88, 0x98, 0xE0, 0x08,
	0x00, 0xCC, 0xBA, 0xA2, 0x22, 0x13, 0xAA, 0xA7, 0x92, 0x9A, 0x00, 0x1B,
	0x99, 0x92, 0x5A, 0x00, 0xB8, 0xA2, 0x88, 0x06, 0xA2, 0x93, 0x00, 0x88,
	0x98, 0xB0, 0xAA, 0xA0, 0xA8, 0x0A, 0xE0, 0x08, 0x00, 0x52, 0x21, 0x1F,
	0x52, 0x25, 0xC7, 0xC2, 0x22, 0xC1, 0xA0, 0x55, 0xC0, 0x0B, 0x55, 0x66,
	0x2C, 0x28, 0xD2, 0x22, 0xC2, 0x82, 0x93, 0x00, 0x98, 0x0D, 0x97, 0x98,
	0x1D, 0xB8, 0xA2, 0x88, 0x06, 0xA8, 0x1D, 0x88, 0x98, 0xB0, 0xAA, 0xA0,
	0xA8, 0x0A, 0xE0, 0x08, 0x00, 0xC2, 0x21, 0x1F, 0xC2, 0x2C, 0xC7, 0xA0,
	0xCC, 0xC0, 0x0B, 0xCC, 0xC0, 0x55, 0x43, 0xD2, 0x22, 0xC3, 0x66, 0x2D,
	0x28, 0xD2, 0x22, 0xC4, 0xE2, 0x93, 0x00, 0xF8, 0x0D, 0xF7, 0x9E, 0x1D,
	0xB8, 0xA2, 0x88, 0x06, 0xA8, 0x1D, 0x88, 0x98, 0xB0, 0xAA, 0xA0, 0xA8,
	0x0A, 0xE0, 0x08, 0x00, 0xC2, 0x21, 0x1F, 0xC2, 0x2C, 0xC7, 0xA0, 0xCC,
	0xC0, 0x0B, 0xCC, 0x50, 0x5C, 0x43, 0x16, 0x45, 0xEE, 0xD2, 0x12, 0x7B,
	0xD7, 0xA5, 0x02, 0xC6, 0xB6, 0xFF, 0xB2, 0x12, 0x62, 0xD2, 0x21, 0x1B,
	0x57, 0xAB, 0x01, 0x5D, 0x0B, 0x66, 0x74, 0x23, 0xE2, 0x22, 0x3E, 0x37,
	0xEE, 0x1A, 0x66, 0x74, 0x1A, 0xF2, 0x22, 0x37, 0x66, 0x8F, 0x14, 0xC2,
	0x22, 0x36, 0x2C, 0xC8, 0x87, 0x1C, 0x04, 0x3C, 0x09, 0x97, 0x9C, 0x07,
	0xA2, 0x21, 0x1A, 0x8C, 0x1A, 0xF0, 0xDD, 0x11, 0x7C, 0xCC, 0xF1, 0x02,
	0x38, 0xD0, 0xE5, 0x82, 0xFA, 0xEE, 0xE0, 0xE4, 0x31, 0xD0, 0x5E, 0x93,
	0xC0, 0xC5, 0x10, 0x52, 0xCC, 0xFC, 0xE6, 0x15, 0x02, 0x46, 0xA3, 0xFF,
	0xE8, 0xE2, 0x7A, 0xEE, 0xE2, 0x9E, 0x00, 0x66, 0x74, 0x25, 0xF2, 0x22,
	0x3E, 0x37, 0xEF, 0x1A, 0x66, 0x74, 0x1C, 0x82, 0x22, 0x37, 0x66, 0x88,
	0x16, 0xC2, 0x22, 0x36, 0x2C, 0xC9, 0x97, 0x1C, 0x04, 0x3C, 0x0A, 0xA7,
	0x9C, 0x09, 0xC2, 0x21, 0x1A, 0x8C, 0x3C, 0xF2, 0x22, 0x33, 0xEA, 0xEF,
	0x92, 0x22, 0x10, 0x9A, 0x97, 0xF2, 0x99, 0x00, 0xC2, 0x21, 0x1C, 0xF0,
	0x8E, 0xC0, 0x80, 0x55, 0x43, 0xE6, 0x15, 0x02, 0x86, 0x91, 0xFF, 0x92,
	0x61, 0x16, 0xB2, 0x61, 0x17, 0xA8, 0xC2, 0xF2, 0x61, 0x15, 0xCA, 0xAA,
	0xA8, 0x0A, 0x66, 0x74, 0x22, 0xE2, 0x22, 0x3E, 0x37, 0xEE, 0x1A, 0x66,
	0x74, 0x19, 0x82, 0x22, 0x37, 0x66, 0x88, 0x13, 0xC2, 0x22, 0x36, 0x2C,
	0xC9, 0x97, 0x1C, 0x04, 0x3C, 0x0E, 0xE7, 0x9C, 0x06, 0x82, 0x21, 0x1A,
	0x8C, 0x08, 0xA8, 0xD2, 0xA2, 0x61, 0x18, 0x52, 0x61, 0x14, 0xE2, 0x12,
	0x16, 0x92, 0x93, 0x00, 0xC2, 0x22, 0x2B, 0xEA, 0x99, 0xED, 0x05, 0xC0,
	0x99, 0xA0, 0x98, 0x09, 0x92, 0x61, 0x1E, 0xAC, 0xB9, 0xA2, 0x21, 0x1E,
	0xC2, 0x21, 0x18, 0x92, 0x21, 0x17, 0xC0, 0xBF, 0xA0, 0xC2, 0x22, 0x30,
	0x99, 0x01, 0x88, 0x26, 0x50, 0xE0, 0xF4, 0x82, 0x28, 0x16, 0xF2, 0xC1,
	0x50, 0xE0, 0x08, 0x00, 0xF2, 0x22, 0x10, 0xE2, 0x21, 0x14, 0xFA, 0xF7,
	0xF2, 0x61, 0x16, 0xF2, 0x9F, 0x00, 0xBD, 0x0E, 0xC2, 0x21, 0x19, 0xA2,
	0x22, 0x30, 0x92, 0x21, 0x16, 0xFA, 0x85, 0x82, 0x59, 0x00, 0xA5, 0x5E,
	0x00, 0xB8, 0xA2, 0x88, 0x06, 0xA2, 0x93, 0x00, 0x88, 0x98, 0xB0, 0xAA,
	0xA0, 0xA8, 0x0A, 0xE0, 0x08, 0x00, 0xE2, 0x21, 0x14, 0xC2, 0xA0, 0xFF,
	0xA0, 0xCC, 0xC0, 0xE7, 0xBC, 0x1E, 0xB8, 0xA2, 0x88, 0x06, 0xA2, 0x93,
	0x00, 0x88, 0x98, 0xB0, 0xAA, 0xA0, 0xA8, 0x0A, 0xE0, 0x08, 0x00, 0x7C,
	0xCF, 0xE2, 0xA0, 0xFF, 0xA0, 0xEE, 0xC0, 0xF0, 0xEE, 0x10, 0xE2, 0x61,
	0x14, 0xCD, 0x0E, 0xB8, 0xA2, 0x88, 0x02, 0xA2, 0x93, 0x00, 0x88, 0x88,
	0xB0, 0xAA, 0xA0, 0xA8, 0x0A, 0xB2, 0x22, 0x30, 0xE0, 0x08, 0x00, 0xC2,
	0x22, 0xC1, 0x66, 0x2C, 0x20, 0xD2, 0x22, 0xC2, 0xE2, 0x93, 0x00, 0xF8,
	0x0D, 0xF7, 0x9E, 0x15, 0xB2, 0x22, 0x30, 0xC2, 0x21, 0x14, 0xE8, 0xA2,
	0x88, 0x02, 0xA8, 0x1D, 0x88, 0x88, 0xE0, 0xAA, 0xA0, 0xA8, 0x0A, 0xE0,
	0x08, 0x00, 0x92, 0x22, 0xC3, 0x66, 0x29, 0x20, 0xD2, 0x22, 0xC4, 0xA2,
	0x93, 0x00, 0xB8, 0x0D, 0xB7, 0x9A, 0x15, 0xB2, 0x22, 0x30, 0xC2, 0x21,
	0x14, 0xE8, 0xA2, 0x88, 0x02, 0xA8, 0x1D, 0x88, 0x88, 0xE0, 0xAA, 0xA0,
	0xA8, 0x0A, 0xE0, 0x08, 0x00, 0xB8, 0xA2, 0xA2, 0x93, 0x00, 0xB0, 0xAA,
	0xA0, 0xA8, 0x0A, 0xC6, 0x63, 0xFF, 0xAD, 0x02, 0xBD, 0x03, 0x0C, 0x0C,
	0x65, 0x5B, 0x00, 0xA2, 0x61, 0x1B, 0xAD, 0x02, 0x0C, 0x0B, 0x30, 0xC0,
	0xF4, 0xD2, 0xC1, 0x10, 0x48, 0x76, 0x0C, 0x19, 0x42, 0x24, 0x46, 0x88,
	0x16, 0x48, 0x34, 0x82, 0x28, 0x3B, 0x40, 0x49, 0x93, 0xE0, 0x08, 0x00,
	0x82, 0xC3, 0xF6, 0xB6, 0x48, 0x02, 0x86, 0x37, 0xFF, 0x91, 0xA1, 0x37,
	0x90, 0x93, 0xA0, 0x92, 0x29, 0x7F, 0x06, 0x35, 0xFF, 0x00, 0x00, 0x00,
	0x36, 0x41, 0x00, 0x72, 0x22, 0x26, 0x82, 0x12, 0x75, 0x62, 0x22, 0x2F,
	0x80, 0xA3, 0xC0, 0x80, 0x66, 0xC0, 0x70, 0x66, 0xA0, 0x68, 0x06, 0x70,
	0x7A, 0xA0, 0x78, 0x07, 0x20, 0xAA, 0xA0, 0x66, 0x14, 0x20, 0x92, 0x2A,
	0x4F, 0x77, 0x99, 0x08, 0xB2, 0x2A, 0x53, 0x67, 0x9B, 0x02, 0x16, 0x15,
	0x19, 0x72, 0x6A, 0x4F, 0xC2, 0x12, 0x75, 0xC0, 0xC3, 0xC0, 0x20, 0xCC,
	0xA0, 0x62, 0x6C, 0x53, 0xC6, 0x07, 0x00, 0xD2, 0x2A, 0x57, 0x77, 0x9D,
	0x0A, 0xE2, 0x2A, 0x5B, 0x67, 0x9E, 0x04, 0x22, 0x2A, 0x4B, 0x1D, 0xF0,
	0x72, 0x6A, 0x57, 0xF2, 0x12, 0x75, 0xF0, 0xF3, 0xC0, 0x20, 0xFF, 0xA0,
	0x62, 0x6F, 0x5B, 0x81, 0x35, 0x37, 0x88, 0x18, 0xAD, 0x02, 0x82, 0x28,
	0x38, 0xBD, 0x03, 0xE0, 0x08, 0x00, 0xE1, 0x31, 0x37, 0x3C, 0x0D, 0x2C,
	0xCC, 0xBC, 0x2A, 0xA2, 0x22, 0x36, 0xD7, 0x1A, 0x2D, 0xC7, 0x9A, 0x1B,
	0x70, 0x9B, 0x41, 0x70, 0x89, 0x41, 0x70, 0xA7, 0x41, 0x9A, 0x88, 0x70,
	0x96, 0x41, 0xAA, 0x99, 0x70, 0xA4, 0x41, 0xAA, 0x77, 0x9A, 0x77, 0x8A,
	0x77, 0x86, 0x03, 0x00, 0x7A, 0x97, 0x9A, 0x97, 0x66, 0xBA, 0x04, 0x7D,
	0x09, 0x86, 0x00, 0x00, 0xF0, 0x79, 0x11, 0x66, 0x15, 0x04, 0x0C, 0x05,
	0x06, 0x01, 0x00, 0x52, 0x22, 0x46, 0x58, 0x35, 0x88, 0x1E, 0xAD, 0x02,
	0x82, 0x28, 0x39, 0xBD, 0x03, 0xE0, 0x08, 0x00, 0x3C, 0x0B, 0x2C, 0xCC,
	0x9C, 0xAA, 0xA2, 0x22, 0x36, 0x57, 0x13, 0x18, 0x92, 0xCA, 0xD0, 0x56,
	0xB9, 0x09, 0x92, 0x22, 0x37, 0xD2, 0xC9, 0xF0, 0x56, 0xBD, 0x0B, 0x6A,
	0xE6, 0xEA, 0x66, 0x86, 0x00, 0x00, 0xA2, 0x22, 0x36, 0xB7, 0x9A, 0x09,
	0x57, 0x93, 0x06, 0x6A, 0xF6, 0xFA, 0xF6, 0x50, 0x6F, 0x93, 0xD2, 0x12,
	0x75, 0xC7, 0x9A, 0x0E, 0x57, 0x93, 0x0B, 0x6A, 0x86, 0x8A, 0x96, 0x90,
	0x92, 0x41, 0x9A, 0x88, 0x50, 0x68, 0x93, 0xD0, 0xD3, 0xC0, 0xA0, 0xDD,
	0x11, 0xDA, 0xD2, 0x66, 0x14, 0x2D, 0xBD, 0x07, 0xCD, 0x06, 0xA2, 0xA1,
	0x9C, 0xAA, 0xAD, 0x65, 0x9E, 0xFF, 0x92, 0x12, 0x75, 0x90, 0x93, 0xC0,
	0x20, 0xA9, 0xA0, 0xA0, 0x99, 0x11, 0x9A, 0x92, 0x92, 0x29, 0x6D, 0x92,
	0x6A, 0x47, 0x82, 0x12, 0x75, 0x80, 0x83, 0xC0, 0x20, 0x28, 0xA0, 0x22,
	0x22, 0x47, 0x1D, 0xF0, 0xBD, 0x06, 0xCD, 0x07, 0xA2, 0xA1, 0x7C, 0xAA,
	0xAD, 0x65, 0x9B, 0xFF, 0x92, 0x12, 0x75, 0x90, 0x93, 0xC0, 0x20, 0xA9,
	0xA0, 0xA0, 0x99, 0x11, 0x9A, 0x92, 0x92, 0x29, 0x65, 0x92, 0x6A, 0x4B,
	0x82, 0x12, 0x75, 0x80, 0x83, 0xC0, 0x20, 0x28, 0xA0, 0x22, 0x22, 0x4B,
	0x1D, 0xF0, 0xC7, 0x9A, 0x11, 0x92, 0x22, 0x37, 0x66, 0xB9, 0x2F, 0x6A,
	0xD6, 0x6A, 0x6D, 0x60, 0x62, 0x41, 0x6A, 0x6D, 0x46, 0xD8, 0xFF, 0x82,
	0xCA, 0xF0, 0x56, 0xB8, 0xF5, 0x92, 0x22, 0x37, 0x92, 0xC9, 0xF8, 0x56,
	0x29, 0xF5, 0x6A, 0x66, 0x46, 0xD3, 0xFF, 0xD2, 0xC9, 0xF8, 0x56, 0x7D,
	0xF4, 0x6A, 0x86, 0x8A, 0x66, 0xF0, 0x66, 0x11, 0x46, 0xCF, 0xFF, 0xD2,
	0xC9, 0xF8, 0x56, 0x7D, 0xF3, 0x60, 0x91, 0x41, 0x6A, 0x86, 0x8A, 0x88,
	0x9A, 0x66, 0x8A, 0x66, 0x46, 0xCA, 0xFF, 0x22, 0x2A, 0x47, 0x1D, 0xF0,
	0x36, 0x21, 0x01, 0x81, 0xDB, 0x36, 0x88, 0x18, 0xAD, 0x02, 0x82, 0x28,
	0x39, 0xBD, 0x03, 0xE0, 0x08, 0x00, 0x16, 0x5A, 0x21, 0x81, 0xD6, 0x36,
	0x88, 0x18, 0xAD, 0x02, 0x82, 0x28, 0x48, 0xBD, 0x03, 0xE0, 0x08, 0x00,
	0xCC, 0xDA, 0x92, 0x22, 0x36, 0xA2, 0xC9, 0xF8, 0x16, 0xBA, 0x1F, 0xB2,
	0xC9, 0xF0, 0x16, 0x5B, 0x1F, 0xB2, 0x22, 0x46, 0xC8, 0x3B, 0xD8, 0x2B,
	0x37, 0x9C, 0x02, 0x37, 0x1D, 0x0B, 0xAD, 0x02, 0xBD, 0x03, 0x0C, 0x1C,
	0xA5, 0x36, 0x00, 0xA2, 0x61, 0x17, 0xAD, 0x02, 0x81, 0xC8, 0x36, 0x0C,
	0x1B, 0x88, 0x18, 0x30, 0xC0, 0xF4, 0x82, 0x28, 0x3B, 0xD2, 0xC1, 0x10,
	0xE0, 0x08, 0x00, 0xA0, 0x90, 0xF4, 0xE6, 0x19, 0x02, 0x86, 0x6F, 0x00,
	0x42, 0xC1, 0x10, 0x40, 0xA9, 0x90, 0xA2, 0x61, 0x18, 0xE2, 0x94, 0x00,
	0x1B, 0xCE, 0x16, 0x2C, 0x1A, 0x52, 0x22, 0x23, 0xB2, 0x22, 0x46, 0x50,
	0x5E, 0xA0, 0xD8, 0x3B, 0x58, 0x05, 0x37, 0x9D, 0x29, 0x88, 0x2B, 0x37,
	0x98, 0x24, 0x66, 0x35, 0x13, 0xAD, 0x02, 0xBD, 0x03, 0x0C, 0x1C, 0x0C,
	0x2D, 0xA5, 0xD9, 0xFF, 0xA2, 0x61, 0x17, 0x06, 0x04, 0x00, 0x00, 0x00,
	0x00, 0xAD, 0x02, 0xBD, 0x03, 0x0C, 0x1C, 0x0C, 0x1D, 0x65, 0xD8, 0xFF,
	0xA2, 0x61, 0x17, 0x92, 0xC5, 0xF6, 0x16, 0x29, 0x16, 0xB8, 0x92, 0xA2,
	0x94, 0x00, 0xB0, 0xAA, 0xA0, 0xA8, 0x0A, 0xF0, 0x75, 0x11, 0x16, 0x2A,
	0x15, 0xB8, 0xE2, 0xC2, 0x22, 0x10, 0xB0, 0xB5, 0x90, 0xC0, 0xC5, 0x90,
	0xC2, 0x9C, 0x00, 0xB2, 0x9B, 0x00, 0xC0, 0xBB, 0xC0, 0xB2, 0xCB, 0xF8,
	0xE6, 0x1B, 0x02, 0x46, 0x4D, 0x00, 0x81, 0xA1, 0x36, 0x88, 0x08, 0x88,
	0x98, 0xB2, 0x61, 0x16, 0xE0, 0x08, 0x00, 0x0C, 0x1B, 0x0C, 0x1D, 0x0C,
	0x0C, 0x7C, 0xC9, 0x90, 0x6A, 0x10, 0x97, 0x0A, 0x07, 0xA2, 0x12, 0x7A,
	0xA7, 0x26, 0x01, 0x0C, 0x0B, 0xB0, 0xCD, 0x83, 0x16, 0xCC, 0x10, 0xB8,
	0x92, 0xA2, 0x94, 0x00, 0x88, 0x02, 0xC2, 0x12, 0x62, 0x88, 0x98, 0xC0,
	0x66, 0x43, 0xCD, 0x06, 0xB0, 0xAA, 0xA0, 0xA8, 0x0A, 0xB2, 0x22, 0x30,
	0xE0, 0x08, 0x00, 0x81, 0x90, 0x36, 0x88, 0x18, 0xA2, 0x22, 0x30, 0x82,
	0x28, 0x17, 0xBD, 0x06, 0xE0, 0x08, 0x00, 0xA2, 0x22, 0x23, 0xE2, 0x94,
	0x00, 0xB2, 0x22, 0x22, 0xA0, 0xAE, 0xA0, 0xA8, 0x0A, 0xB0, 0xAA, 0xA0,
	0xA8, 0x0A, 0xE0, 0x9E, 0x11, 0x96, 0x5A, 0x00, 0xB2, 0x22, 0x3E, 0x47,
	0x6B, 0x20, 0xA2, 0x22, 0x30, 0xBD, 0x06, 0xC1, 0xD4, 0x36, 0x81, 0x82,
	0x36, 0xC0, 0xEE, 0x11, 0x88, 0x18, 0xD2, 0x22, 0x18, 0x82, 0x28, 0x2D,
	0xEA, 0xDD, 0xE0, 0x08, 0x00, 0x92, 0x94, 0x00, 0xE0, 0x99, 0x11, 0xA2,
	0x22, 0x2B, 0x9A, 0xAA, 0xA8, 0x0A, 0x16, 0x6A, 0x09, 0xB2, 0x22, 0x3E,
	0xA2, 0x61, 0x15, 0x87, 0x6B, 0x2F, 0xD2, 0x22, 0x12, 0xC2, 0x12, 0x77,
	0x7A, 0xDD, 0xD2, 0x9D, 0x00, 0xD7, 0xAC, 0x21, 0x81, 0x74, 0x36, 0x88,
	0x18, 0xA2, 0x21, 0x17, 0x82, 0x28, 0x25, 0xB2, 0x22, 0x3C, 0xE0, 0x08,
	0x00, 0xB2, 0x22, 0x2B, 0x92, 0x94, 0x00, 0xA2, 0x61, 0x17, 0xB0, 0x99,
	0xA0, 0x98, 0x09, 0x92, 0x61, 0x15, 0xA2, 0x21, 0x15, 0x60, 0xE0, 0xF4,
	0xD2, 0x21, 0x17, 0x81, 0x69, 0x36, 0xB2, 0x22, 0x30, 0xF2, 0x21, 0x16,
	0x98, 0xC2, 0xC2, 0x22, 0x10, 0x90, 0x95, 0xA0, 0x7A, 0xCC, 0xC2, 0x9C,
	0x00, 0x98, 0x09, 0xF9, 0x01, 0x88, 0x28, 0x90, 0xCC, 0xA0, 0x82, 0x28,
	0x16, 0xF2, 0xC1, 0x50, 0xE0, 0x08, 0x00, 0xE2, 0x21, 0x14, 0x66, 0x8A,
	0x0C, 0xB2, 0x22, 0x14, 0xBA, 0xB7, 0xA2, 0x9B, 0x00, 0x1B, 0xAA, 0xA2,
	0x5B, 0x00, 0x82, 0x22, 0x10, 0xD2, 0x22, 0x11, 0x8A, 0x87, 0xF2, 0x98,
	0x00, 0xDA, 0xD7, 0xEA, 0xFF, 0xF2, 0x58, 0x00, 0xC2, 0x9D, 0x00, 0xEA,
	0xCC, 0xC2, 0x5D, 0x00, 0x92, 0x21, 0x18, 0x2B, 0x44, 0x90, 0x94, 0xC0,
	0x56, 0x99, 0xE4, 0x1D, 0xF0, 0x00, 0x00, 0x00, 0x36, 0x41, 0x00, 0x60,
	0x88, 0x0C, 0x50, 0x72, 0x21, 0x0C, 0x18, 0x80, 0x00, 0xF3, 0x76, 0xA7,
	0x10, 0x30, 0x43, 0x8C, 0x20, 0x03, 0x8C, 0xAF, 0xE0, 0x0A, 0x22, 0xF8,
	0x00, 0x0E, 0x09, 0x30, 0x04, 0x8D, 0x1D, 0xF0, 0x36, 0x41, 0x00, 0x0C,
	0x0A, 0x65, 0x14, 0xFF, 0xC1, 0x45, 0x36, 0x20, 0xB2, 0x21, 0xC2, 0x2C,
	0x99, 0xAA, 0x8B, 0x98, 0x3C, 0xA8, 0x2C, 0x97, 0x38, 0x03, 0x0C, 0x32,
	0x1D, 0xF0, 0x0C, 0x02, 0xA6, 0x1B, 0x1C, 0xD8, 0x0C, 0x76, 0xAB, 0x15,
	0x4B, 0xBA, 0xF8, 0x03, 0x4B, 0x33, 0xF9, 0x0A, 0xE8, 0x3C, 0xAD, 0x0D,
	0xD0, 0xEE, 0xA0, 0xE7, 0xBB, 0x01, 0xAD, 0x0B, 0x3D, 0xF0, 0xA9, 0x2C,
	0x1D, 0xF0, 0x00, 0x00, 0x36, 0x41, 0x00, 0x4D, 0x02, 0x21, 0x34, 0x36,
	0x81, 0x81, 0x36, 0x22, 0x22, 0x98, 0x00, 0x54, 0x11, 0x8C, 0xA2, 0x80,
	0x55, 0x20, 0x98, 0x02, 0x57, 0x99, 0x05, 0x0C, 0x0A, 0xA9, 0x62, 0x1D,
	0xF0, 0x28, 0x72, 0x56, 0xF2, 0xFE, 0x46, 0xFD, 0xFF, 0x00, 0x00, 0x00,
	0x36, 0x41, 0x00, 0x0C, 0x93, 0x37, 0x12, 0x23, 0x26, 0x92, 0x49, 0x0C,
	0xB4, 0x47, 0x12, 0x4E, 0x26, 0xA2, 0x50, 0x0C, 0xD8, 0x87, 0x12, 0x37,
	0x1C, 0x39, 0x97, 0x12, 0x3C, 0x1C, 0x4A, 0xA7, 0x12, 0x2D, 0x1C, 0x5B,
	0xB7, 0x12, 0x32, 0x7C, 0xF2, 0x46, 0x00, 0x00, 0x0C, 0x02, 0xF6, 0xA2,
	0x1A, 0x81, 0x70, 0x36, 0xC0, 0x32, 0x11, 0x8A, 0x33, 0xC0, 0x20, 0x00,
	0x22, 0x13, 0x85, 0x1B, 0x22, 0xC0, 0x20, 0x00, 0x32, 0x13, 0x82, 0x30,
	0x22, 0xE0, 0x1D, 0xF0, 0x0C, 0x02, 0x1D, 0xF0, 0x0C, 0x42, 0x06, 0xF6,
	0xFF, 0x0C, 0xA2, 0xC6, 0xF4, 0xFF, 0x0C, 0x22, 0x86, 0xF3, 0xFF, 0x0C,
	0x62, 0x46, 0xF2, 0xFF, 0x0C, 0x82, 0x06, 0xF1, 0xFF, 0x00, 0x00, 0x00,
	0x36, 0x41, 0x00, 0x30, 0x52, 0x21, 0x7C, 0xF6, 0x0C, 0x19, 0x1C, 0xFA,
	0x82, 0xA0, 0x20, 0x40, 0x88, 0xC0, 0x40, 0xAA, 0xC0, 0x00, 0x1A, 0x40,
	0x42, 0xA0, 0x00, 0x00, 0x99, 0xA1, 0x6F, 0xF3, 0x00, 0x22, 0x44, 0x0C,
	0x0C, 0x11, 0x00, 0x18, 0x40, 0xCF, 0x4C, 0x01, 0x22, 0x02, 0x29, 0x04,
	0x00, 0x4F, 0x01, 0x04, 0x29, 0x44, 0x0C, 0x0C, 0x11, 0xEF, 0xEC, 0x00,
	0x22, 0x44, 0x0C, 0x0C, 0x11, 0xCF, 0x00, 0x84, 0x28, 0x44, 0x0C, 0x0C,
	0x11, 0x76, 0xA5, 0x35, 0x20, 0xC8, 0x0C, 0xAF, 0xE0, 0x0A, 0x22, 0xF4,
	0x30, 0x1E, 0x09, 0xAF, 0xE0, 0x0A, 0x22, 0x02, 0x31, 0x04, 0x11, 0xAF,
	0xE0, 0x0A, 0x22, 0x02, 0x31, 0x05, 0x11, 0xAF, 0xE0, 0x0A, 0x22, 0x02,
	0x31, 0x06, 0x11, 0xAF, 0xE0, 0x0A, 0x22, 0x02, 0x31, 0x07, 0x11, 0x9F,
	0x03, 0x83, 0x61, 0x44, 0x0C, 0x0C, 0x11, 0x30, 0xC2, 0x8D, 0x1D, 0xF0,
	0x36, 0x41, 0x00, 0xAD, 0x02, 0xBD, 0x03, 0xCD, 0x04, 0x0C, 0x0D, 0xA5,
	0xA7, 0xFF, 0x2D, 0x0A, 0x1D, 0xF0, 0x00, 0x00, 0x36, 0x41, 0x00, 0x0C,
	0x0A, 0x0C, 0xAC, 0xB0, 0x84, 0x11, 0x20, 0xB5, 0xA0, 0x42, 0x2B, 0x9F,
	0x1C, 0xF7, 0x60, 0x54, 0xC0, 0xEF, 0xE9, 0x00, 0x22, 0x44, 0x0C, 0x0C,
	0x11, 0xEF, 0xEA, 0x00, 0x22, 0xC2, 0x39, 0x04, 0x00, 0xEF, 0x37, 0x67,
	0x63, 0xC2, 0x19, 0x04, 0x00, 0xEF, 0xF8, 0x02, 0x22, 0x48, 0x20, 0x18,
	0x01, 0xCF, 0x85, 0xEB, 0x62, 0xC2, 0x19, 0x05, 0x00, 0xEF, 0x77, 0x53,
	0x63, 0xA4, 0x10, 0x89, 0x08, 0xC0, 0xC3, 0xC0, 0x8F, 0x59, 0x83, 0x43,
	0xA4, 0x00, 0x08, 0x21, 0x2A, 0xCC, 0x4F, 0x90, 0x69, 0x43, 0x40, 0x00,
	0x00, 0x04, 0x8F, 0xC4, 0xBE, 0x82, 0x40, 0x00, 0x01, 0x01, 0x32, 0x22,
	0x63, 0xAF, 0x6B, 0x80, 0x42, 0xC2, 0x01, 0x00, 0x11, 0xAF, 0x00, 0x28,
	0x48, 0x44, 0x0C, 0x0C, 0x11, 0x52, 0x62, 0x62, 0x47, 0xA6, 0x3B, 0xD2,
	0x22, 0x60, 0x67, 0x2D, 0x4E, 0x0B, 0x33, 0x32, 0x62, 0x63, 0x47, 0xA6,
	0x3B, 0x32, 0x22, 0x64, 0x0B, 0x33, 0x32, 0x62, 0x64, 0x97, 0x26, 0x07,
	0x67, 0x2B, 0x04, 0x2C, 0x03, 0x46, 0x00, 0x00, 0x0C, 0x13, 0x32, 0x62,
	0x66, 0x62, 0x62, 0x60, 0x1D, 0xF0, 0xA6, 0x15, 0x39, 0xAF, 0x00, 0x28,
	0x48, 0x44, 0x0C, 0x0C, 0x11, 0x50, 0x50, 0x60, 0x46, 0xEF, 0xFF, 0x67,
	0xA4, 0x1A, 0x72, 0x22, 0x60, 0x77, 0x26, 0x27, 0x1B, 0x33, 0x46, 0xEF,
	0xFF, 0x67, 0xA4, 0x15, 0x32, 0x22, 0x64, 0x1B, 0x33, 0x46, 0xEF, 0xFF,
	0x2B, 0x33, 0x46, 0xEB, 0xFF, 0xA6, 0x13, 0x15, 0x32, 0xC3, 0xFE, 0x06,
	0xE9, 0xFF, 0x3D, 0x0A, 0x86, 0xEA, 0xFF, 0x5D, 0x0A, 0x06, 0xE3, 0xFF,
	0x32, 0xC3, 0xFE, 0x06, 0xE5, 0xFF, 0xD6, 0x43, 0xF9, 0x2B, 0x33, 0x06,
	0xE3, 0xFF, 0x00, 0x00, 0x36, 0x41, 0x00, 0x0C, 0x04, 0x81, 0xFB, 0x35,
	0x20, 0x53, 0xA0, 0xA2, 0x25, 0xC9, 0x3C, 0x06, 0x87, 0x1A, 0x3A, 0x91,
	0xFA, 0x35, 0xB1, 0xFA, 0x35, 0x97, 0x1A, 0x24, 0xB7, 0x1A, 0x13, 0xC1,
	0xF9, 0x35, 0xD2, 0xA1, 0x00, 0xC7, 0x1A, 0x0A, 0x42, 0x65, 0xDE, 0xD2,
	0x65, 0xD1, 0x42, 0x65, 0xE2, 0x1D, 0xF0, 0x42, 0x65, 0xDE, 0xE2, 0xA0,
	0x90, 0xE2, 0x65, 0xD1, 0x2C, 0x84, 0x06, 0xFB, 0xFF, 0x62, 0x65, 0xD1,
	0x42, 0x65, 0xDE, 0x1C, 0x09, 0x4D, 0x09, 0xC6, 0xF7, 0xFF, 0xA1, 0x98,
	0x35, 0x88, 0x1A, 0x82, 0x28, 0x45, 0xA8, 0x7A, 0xE0, 0x08, 0x00, 0x1C,
	0x8B, 0xAB, 0x93, 0x97, 0x1A, 0x0A, 0xA2, 0x22, 0x36, 0x2C, 0xCC, 0xC7,
	0x1A, 0x0D, 0x67, 0x1A, 0x0F, 0xB2, 0x65, 0xD1, 0x42, 0x65, 0xDE, 0x0C,
	0x89, 0x06, 0xF4, 0xFF, 0xBD, 0x06, 0xC6, 0xFB, 0xFF, 0xBD, 0x06, 0x86,
	0xFA, 0xFF, 0x00, 0x00, 0x36, 0x41, 0x00, 0x61, 0x8A, 0x35, 0x00, 0x22,
	0x11, 0x62, 0x26, 0x98, 0x41, 0xD5, 0x35, 0x9C, 0x06, 0x40, 0x22, 0x20,
	0x58, 0x06, 0x27, 0x95, 0x04, 0x0C, 0x02, 0x86, 0x01, 0x00, 0x68, 0x76,
	0x56, 0x06, 0xFF, 0x0C, 0x22, 0x26, 0x22, 0x01, 0x39, 0x26, 0x1D, 0xF0,
	0x36, 0x41, 0x00, 0x61, 0x7F, 0x35, 0x00, 0x22, 0x11, 0x62, 0x26, 0x98,
	0x41, 0xCA, 0x35, 0x9C, 0x06, 0x40, 0x22, 0x20, 0x58, 0x06, 0x27, 0x95,
	0x04, 0x0C, 0x02, 0x86, 0x01, 0x00, 0x68, 0x76, 0x56, 0x06, 0xFF, 0x0C,
	0x22, 0x26, 0x22, 0x01, 0x39, 0x46, 0x1D, 0xF0, 0x36, 0x41, 0x00, 0x51,
	0x74, 0x35, 0xB2, 0x25, 0x98, 0x91, 0xBF, 0x35, 0x9C, 0x5B, 0x00, 0x22,
	0x11, 0x90, 0x22, 0x20, 0x88, 0x0B, 0x27, 0x98, 0x03, 0x0C, 0x12, 0x1D,
	0xF0, 0xB8, 0x7B, 0x56, 0x1B, 0xFF, 0x46, 0x01, 0x00, 0x00, 0x22, 0x11,
	0x90, 0x22, 0x20, 0x82, 0x25, 0x97, 0x2C, 0x4A, 0x82, 0x28, 0x1D, 0x0C,
	0x4B, 0xE0, 0x08, 0x00, 0x39, 0x2A, 0x49, 0x4A, 0x29, 0x0A, 0x0C, 0x0B,
	0x0C, 0x19, 0x99, 0x3A, 0xB9, 0x1A, 0xB9, 0x5A, 0xB9, 0x6A, 0xB2, 0x5A,
	0x10, 0xB2, 0x5A, 0x11, 0xB9, 0x7A, 0xB2, 0x25, 0x98, 0x0C, 0x02, 0xCC,
	0x4B, 0xA2, 0x65, 0x98, 0x06, 0x03, 0x00, 0x98, 0x7B, 0x8C, 0x59, 0xBD,
	0x09, 0x98, 0x79, 0x56, 0x89, 0xFF, 0xA9, 0x7B, 0x1D, 0xF0, 0x00, 0x00,
	0x36, 0x41, 0x00, 0xD1, 0x58, 0x35, 0xA2, 0x2D, 0x91, 0x82, 0x2D, 0x90,
	0xDA, 0xCA, 0x87, 0x2A, 0x03, 0x0C, 0x12, 0x1D, 0xF0, 0x22, 0x4C, 0x40,
	0xB2, 0x2D, 0x91, 0x92, 0x2D, 0x90, 0x1B, 0xBB, 0xB2, 0x6D, 0x91, 0xB7,
	0x99, 0x10, 0x1C, 0x8A, 0x88, 0x0D, 0x1C, 0x9B, 0x88, 0xF8, 0x0C, 0x0C,
	0xE0, 0x08, 0x00, 0x0C, 0x12, 0x1D, 0xF0, 0x0C, 0x02, 0x1D, 0xF0, 0x00,
	0x36, 0x81, 0x00, 0x71, 0x9F, 0x35, 0x49, 0x41, 0x0C, 0x09, 0x99, 0x04,
	0xEC, 0x23, 0x96, 0xB2, 0x13, 0xB8, 0x27, 0xB7, 0x32, 0x02, 0xC6, 0x4C,
	0x00, 0x16, 0xBB, 0x12, 0x0C, 0x04, 0xA2, 0x27, 0x03, 0x76, 0x9B, 0x0A,
	0x92, 0x1A, 0x00, 0x97, 0x92, 0x01, 0x4D, 0x0A, 0xA2, 0xCA, 0x14, 0xC6,
	0x45, 0x00, 0x4D, 0x09, 0xCC, 0x63, 0xA2, 0x14, 0x01, 0xA9, 0x31, 0x06,
	0x04, 0x00, 0xC2, 0x03, 0x03, 0xB2, 0x03, 0x02, 0x80, 0xCC, 0x11, 0xC0,
	0xBB, 0x20, 0x80, 0xBB, 0x23, 0xB9, 0x31, 0xF8, 0x31, 0x61, 0x8C, 0x35,
	0xCC, 0x53, 0xD8, 0x24, 0xD9, 0x21, 0xC6, 0x00, 0x00, 0x8B, 0xE3, 0xE9,
	0x21, 0xA6, 0x1F, 0x1C, 0x88, 0x21, 0x2D, 0x08, 0x80, 0x5F, 0x90, 0xB2,
	0x02, 0x01, 0xA2, 0x02, 0x00, 0xA2, 0x56, 0x81, 0x00, 0xBB, 0x23, 0xB9,
	0x01, 0xE5, 0x64, 0x02, 0x2B, 0x22, 0x57, 0x92, 0xE9, 0xCC, 0x43, 0x92,
	0x14, 0x02, 0x86, 0x03, 0x00, 0xA2, 0x03, 0x05, 0x92, 0x03, 0x04, 0x80,
	0xAA, 0x11, 0xA0, 0x99, 0x20, 0x80, 0x99, 0x23, 0x0C, 0x07, 0x49, 0x61,
	0xCC, 0x53, 0xB8, 0x34, 0xB9, 0x11, 0x46, 0x03, 0x00, 0xC8, 0x31, 0x0C,
	0x0D, 0xD0, 0xCC, 0x53, 0xD8, 0x21, 0xD0, 0xCC, 0x90, 0xC9, 0x11, 0x16,
	0xA9, 0x09, 0x58, 0x11, 0x49, 0x61, 0x50, 0xA9, 0xA0, 0xA9, 0x51, 0xEC,
	0xE3, 0xC2, 0x15, 0x00, 0xC9, 0x01, 0xC0, 0xA8, 0x74, 0x26, 0x9A, 0x07,
	0x0C, 0xBB, 0xB7, 0x1A, 0x02, 0x66, 0xAA, 0x08, 0x0C, 0x1D, 0xE8, 0x41,
	0xD2, 0x66, 0x3F, 0xD9, 0x0E, 0xC0, 0x20, 0x74, 0xC0, 0x48, 0x74, 0xAD,
	0x04, 0xBD, 0x02, 0xE5, 0x74, 0xFD, 0xDC, 0x5A, 0x0C, 0x02, 0x06, 0x07,
	0x00, 0xD2, 0x05, 0x00, 0xC2, 0x05, 0x01, 0x80, 0xDD, 0x11, 0xD0, 0xCC,
	0x20, 0x80, 0xCC, 0x23, 0x06, 0xF0, 0xFF, 0x22, 0x56, 0x80, 0xE1, 0x16,
	0x35, 0x0C, 0x72, 0x42, 0x6E, 0x7F, 0x26, 0x82, 0x2B, 0xAC, 0x82, 0xDC,
	0x43, 0xB2, 0x15, 0x01, 0xB9, 0x01, 0xAD, 0x01, 0xE5, 0x4D, 0xFD, 0x1B,
	0x77, 0xF8, 0x51, 0x4B, 0x55, 0xF7, 0x95, 0x96, 0x46, 0x09, 0x00, 0xC2,
	0x05, 0x02, 0xB2, 0x05, 0x03, 0x80, 0xCC, 0x11, 0xC0, 0xBB, 0x20, 0x80,
	0xBB, 0x23, 0x86, 0xF6, 0xFF, 0x0C, 0x0D, 0xD2, 0x66, 0x3F, 0x1D, 0xF0,
	0x0C, 0x02, 0x1D, 0xF0, 0x0C, 0x04, 0x56, 0x64, 0xEE, 0x7C, 0xF2, 0x1D,
	0xF0, 0x48, 0x61, 0x0C, 0x0E, 0xE2, 0x66, 0x3F, 0xCC, 0x43, 0x52, 0x14,
	0x03, 0x86, 0x03, 0x00, 0x82, 0x03, 0x07, 0x52, 0x03, 0x06, 0x80, 0x88,
	0x11, 0x80, 0x55, 0x20, 0x80, 0x55, 0x23, 0xCC, 0x33, 0x28, 0x44, 0x06,
	0x01, 0x00, 0x28, 0x11, 0x20, 0x27, 0xA0, 0x0C, 0x04, 0x16, 0x35, 0xFC,
	0x1C, 0x2B, 0xC2, 0xA0, 0x6B, 0x71, 0x3E, 0x35, 0xCC, 0xC3, 0xD2, 0x12,
	0x00, 0x2B, 0x22, 0xD0, 0xD0, 0x74, 0xD2, 0x56, 0x81, 0xC6, 0x01, 0x00,
	0xD2, 0x02, 0x00, 0xD2, 0x56, 0x81, 0x1B, 0x22, 0xEC, 0x63, 0xA2, 0x12,
	0x00, 0xA9, 0x01, 0x2B, 0x22, 0xD7, 0xBB, 0x2F, 0xD7, 0x3C, 0x2C, 0x70,
	0x8D, 0xA0, 0x82, 0x28, 0x2C, 0xAD, 0x01, 0xE0, 0x08, 0x00, 0x1C, 0x2B,
	0xC2, 0xA0, 0x6B, 0x66, 0x7A, 0x19, 0x1B, 0x44, 0x47, 0x95, 0xC0, 0x46,
	0xDE, 0xFF, 0xE2, 0x02, 0x00, 0xA2, 0x02, 0x01, 0x80, 0xEE, 0x11, 0xE0,
	0xAA, 0x20, 0x80, 0xAA, 0x23, 0x06, 0xF2, 0xFF, 0x0C, 0x82, 0x1D, 0xF0,
	0x36, 0x41, 0x01, 0x9D, 0x01, 0x0C, 0x0A, 0xB2, 0x12, 0x17, 0x0C, 0x04,
	0x1C, 0x98, 0x76, 0xA8, 0x03, 0xA9, 0x09, 0x4B, 0x99, 0xA6, 0x1B, 0x6A,
	0x0C, 0x16, 0x71, 0xCB, 0x34, 0x0C, 0x03, 0x0C, 0x1A, 0x52, 0x22, 0x24,
	0x0C, 0x1D, 0x3A, 0x55, 0x58, 0x05, 0x0C, 0xAC, 0x57, 0x2C, 0x0A, 0x98,
	0xA2, 0x3A, 0x99, 0x98, 0x09, 0x0C, 0x08, 0x90, 0xA8, 0x93, 0x0C, 0x0C,
	0xA0, 0xCD, 0x83, 0xBC, 0x9C, 0xAD, 0x02, 0x88, 0x17, 0x0C, 0x0B, 0x82,
	0x28, 0x3C, 0xCD, 0x04, 0xE0, 0x08, 0x00, 0xBD, 0x0A, 0x9D, 0x01, 0x90,
	0x9A, 0xA0, 0xA8, 0x09, 0xDC, 0xBA, 0xA2, 0x22, 0xC8, 0x92, 0x61, 0x1C,
	0xDC, 0x3A, 0xDD, 0x05, 0xAD, 0x02, 0xE2, 0x22, 0x12, 0x0C, 0x0C, 0xE0,
	0xE5, 0x90, 0xE2, 0x9E, 0x00, 0xE5, 0xB2, 0xFF, 0x92, 0x21, 0x1C, 0xB2,
	0x12, 0x17, 0x69, 0x09, 0x4B, 0x33, 0x1B, 0x44, 0xB7, 0x24, 0x9B, 0x1D,
	0xF0, 0x00, 0x00, 0x00, 0x36, 0xC1, 0x00, 0x91, 0xAF, 0x34, 0x98, 0x79,
	0x92, 0x29, 0x46, 0x0C, 0x18, 0x98, 0x39, 0xB2, 0x12, 0x17, 0x90, 0x98,
	0x93, 0xE6, 0x1B, 0x02, 0x46, 0xFC, 0x00, 0x0C, 0x05, 0x0C, 0x07, 0x0C,
	0x0D, 0x0C, 0x04, 0x99, 0x41, 0x0C, 0x06, 0xF2, 0xA3, 0x60, 0xA1, 0xFE,
	0x34, 0xE1, 0xFC, 0x34, 0xE9, 0x51, 0xA9, 0x71, 0xFA, 0xF2, 0xF9, 0x61,
	0xA2, 0xDA, 0x5C, 0xA9, 0x81, 0x0C, 0xBF, 0x0C, 0x1E, 0x0C, 0x09, 0x32,
	0x22, 0x24, 0x82, 0x22, 0xC1, 0x4A, 0x33, 0x38, 0x03, 0x66, 0x28, 0x09,
	0x82, 0x22, 0xC2, 0x88, 0x18, 0x57, 0x98, 0x01, 0x0C, 0x16, 0x60, 0x9E,
	0x83, 0x16, 0xC9, 0x2E, 0x0C, 0x06, 0xA2, 0x22, 0xC3, 0x0C, 0x19, 0x66,
	0x2A, 0x09, 0xC2, 0x22, 0xC4, 0xC8, 0x1C, 0x57, 0x9C, 0x01, 0x6D, 0x0E,
	0x0C, 0x0E, 0x60, 0xE9, 0x83, 0x16, 0x0E, 0x2D, 0x6D, 0x09, 0x0C, 0x1E,
	0x0C, 0x0C, 0xE6, 0xA3, 0x0C, 0xA8, 0xA2, 0x4A, 0xAA, 0xA8, 0x0A, 0x0C,
	0x08, 0xA0, 0x98, 0x93, 0x6D, 0x09, 0x60, 0xCE, 0x83, 0x16, 0x4C, 0x2B,
	0xD9, 0x31, 0xE2, 0x22, 0x33, 0x68, 0xC2, 0xE0, 0x93, 0x11, 0x99, 0xD1,
	0x60, 0x63, 0xA0, 0x68, 0x06, 0xE9, 0x01, 0x66, 0x73, 0x0F, 0xA2, 0x22,
	0x3E, 0x37, 0x6A, 0x09, 0x68, 0xD2, 0x47, 0xEA, 0x04, 0xF0, 0x8E, 0x11,
	0x89, 0x01, 0xF0, 0xA3, 0xC0, 0x16, 0x8A, 0x28, 0x81, 0x7F, 0x34, 0xAD,
	0x02, 0x88, 0x18, 0x0C, 0x0B, 0x82, 0x28, 0x3C, 0xCD, 0x05, 0xE0, 0x08,
	0x00, 0xD8, 0xD1, 0x9D, 0x0A, 0xA9, 0x21, 0xB2, 0xCA, 0xEC, 0xB9, 0xA1,
	0xA2, 0xCA, 0xF6, 0xF6, 0x4A, 0x0F, 0xC1, 0xC6, 0x34, 0x99, 0x21, 0xC0,
	0xC9, 0xA0, 0xC2, 0x2C, 0x7F, 0xC9, 0x91, 0x06, 0x03, 0x00, 0x1C, 0x8F,
	0xE8, 0xA1, 0xF9, 0x91, 0xB6, 0x2E, 0x03, 0x1C, 0x08, 0x89, 0x91, 0x92,
	0x22, 0x22, 0xDA, 0x99, 0x98, 0x09, 0x96, 0x59, 0x00, 0xA2, 0x22, 0x3E,
	0x47, 0x6A, 0x19, 0xAD, 0x06, 0xB8, 0x01, 0xE8, 0x31, 0x81, 0x69, 0x34,
	0xD2, 0x22, 0x19, 0xC8, 0x78, 0x88, 0x18, 0xEA, 0xDD, 0x82, 0x28, 0x2D,
	0xC8, 0x3C, 0xE0, 0x08, 0x00, 0x92, 0x22, 0x40, 0x16, 0x59, 0x05, 0xAD,
	0x06, 0xB8, 0x01, 0xE8, 0x31, 0x81, 0x61, 0x34, 0xD2, 0x22, 0xC0, 0xC8,
	0x78, 0x88, 0x18, 0xEA, 0xDD, 0x82, 0x28, 0x2D, 0xC8, 0x3C, 0xE0, 0x08,
	0x00, 0x66, 0x73, 0x1A, 0x92, 0x22, 0xC1, 0x66, 0x29, 0x14, 0xB2, 0x22,
	0xC0, 0xC2, 0x22, 0xC2, 0xA8, 0x31, 0xC8, 0x1C, 0xBA, 0xAA, 0xA8, 0x1A,
	0xC0, 0xCC, 0x11, 0xCA, 0xBB, 0xA9, 0x1B, 0x66, 0x63, 0x1A, 0xB2, 0x22,
	0xC3, 0x66, 0x2B, 0x14, 0xD2, 0x22, 0xC0, 0xE2, 0x22, 0xC4, 0xC8, 0x31,
	0xE8, 0x1E, 0xDA, 0xCC, 0xC8, 0x1C, 0xC0, 0xEE, 0x11, 0xEA, 0xDD, 0xC9,
	0x1D, 0xAD, 0x06, 0xB8, 0x01, 0xD2, 0x12, 0x3A, 0xE2, 0x12, 0x3B, 0x81,
	0x4B, 0x34, 0xC2, 0x22, 0x1C, 0x88, 0x18, 0x7A, 0xCC, 0x82, 0x28, 0x2F,
	0xC2, 0x1C, 0x00, 0xE0, 0x08, 0x00, 0x98, 0xA1, 0xF6, 0x29, 0x11, 0x81,
	0x45, 0x34, 0xA2, 0x22, 0x17, 0x88, 0x18, 0xBD, 0x06, 0x82, 0x28, 0x21,
	0xC8, 0x01, 0xE0, 0x08, 0x00, 0xA2, 0x12, 0x16, 0xB2, 0x22, 0x2E, 0xAA,
	0xA5, 0xB0, 0xAA, 0xA0, 0xA8, 0x0A, 0x9C, 0x3A, 0xBD, 0x06, 0x81, 0x3C,
	0x34, 0xC8, 0x81, 0x88, 0x28, 0xD2, 0x11, 0x00, 0x88, 0xE8, 0xED, 0x01,
	0xE0, 0x08, 0x00, 0x68, 0x81, 0x92, 0x22, 0x46, 0x98, 0x39, 0x16, 0xE9,
	0x05, 0x66, 0x73, 0x5B, 0xA2, 0x22, 0x37, 0xD2, 0x22, 0x36, 0x66, 0x8A,
	0x1B, 0x2C, 0xCB, 0xB7, 0x1D, 0x04, 0x3C, 0x0C, 0xC7, 0x9D, 0x11, 0xAD,
	0x06, 0xB8, 0x51, 0xC8, 0xD2, 0xD8, 0x01, 0xE8, 0x61, 0x65, 0x77, 0xFF,
	0x68, 0xD2, 0x06, 0x03, 0x00, 0xAD, 0x06, 0xB8, 0x51, 0xCD, 0x06, 0xD8,
	0x01, 0xE8, 0x61, 0x65, 0x76, 0xFF, 0xD1, 0x28, 0x34, 0xD8, 0x9D, 0xF8,
	0x01, 0x9C, 0x6D, 0xF0, 0xD0, 0xF4, 0xBD, 0x06, 0xA1, 0x25, 0x34, 0xC8,
	0x71, 0x88, 0x2A, 0x4B, 0xE1, 0x88, 0xE8, 0xA8, 0xAA, 0xE0, 0x08, 0x00,
	0x06, 0x02, 0x00, 0xCD, 0x0F, 0xA8, 0x71, 0xBD, 0x06, 0xA5, 0x20, 0x02,
	0x81, 0x1E, 0x34, 0x88, 0x18, 0xAD, 0x02, 0x82, 0x28, 0x48, 0xB8, 0x21,
	0xE0, 0x08, 0x00, 0xCC, 0xBA, 0xD2, 0x22, 0x36, 0x2C, 0xC9, 0x97, 0x1D,
	0x04, 0x3C, 0x0A, 0xA7, 0x9D, 0x5A, 0xB2, 0xC3, 0xF9, 0xC8, 0xE2, 0xF0,
	0xD3, 0x11, 0xD9, 0xC1, 0xF8, 0xC1, 0xC0, 0xC3, 0x90, 0xC2, 0x9C, 0x00,
	0xC9, 0xB1, 0x56, 0x3B, 0x0E, 0xE2, 0x22, 0x3E, 0x37, 0xEE, 0x31, 0x56,
	0xAB, 0x0D, 0x82, 0x22, 0x37, 0xC2, 0xC3, 0xF9, 0x66, 0x88, 0x0B, 0x92,
	0x22, 0x36, 0x3C, 0x0A, 0xA7, 0x99, 0x03, 0xB8, 0x41, 0xDC, 0x8B, 0x56,
	0x2C, 0x0C, 0xD2, 0x22, 0x37, 0xD2, 0xCD, 0xF8, 0x56, 0x9D, 0x0B, 0xE2,
	0x22, 0x36, 0xE2, 0xCE, 0xD4, 0x56, 0x0E, 0x0B, 0x88, 0x41, 0x16, 0xB8,
	0x0A, 0x98, 0xB1, 0xA2, 0x22, 0x33, 0x9A, 0x9A, 0x99, 0xB1, 0xC6, 0x27,
	0x00, 0xAD, 0x06, 0xB8, 0x01, 0xC8, 0x91, 0xA5, 0x7B, 0xFF, 0xBD, 0x06,
	0xC8, 0x01, 0xA8, 0xA2, 0x88, 0x02, 0x4A, 0xAA, 0x88, 0x88, 0xA8, 0x0A,
	0xE0, 0x08, 0x00, 0x81, 0xF9, 0x33, 0xA8, 0xA2, 0x88, 0x08, 0x4A, 0xAA,
	0x88, 0x98, 0xA8, 0x0A, 0xE0, 0x08, 0x00, 0x92, 0x22, 0xC1, 0xF8, 0x01,
	0x66, 0x29, 0x1D, 0xD2, 0x22, 0xC2, 0xA8, 0x0D, 0x57, 0x9A, 0x15, 0xCD,
	0x0F, 0xBD, 0x06, 0xE8, 0xA2, 0x88, 0x02, 0xA8, 0x1D, 0x88, 0x88, 0xE0,
	0xAA, 0xA0, 0xA8, 0x0A, 0xE0, 0x08, 0x00, 0xF8, 0x01, 0x92, 0x22, 0xC3,
	0xD2, 0x22, 0xC4, 0x66, 0x29, 0x1A, 0xA8, 0x0D, 0x57, 0x9A, 0x15, 0xBD,
	0x06, 0xCD, 0x0F, 0xE8, 0xA2, 0x88, 0x02, 0xA8, 0x1D, 0x88, 0x88, 0xE0,
	0xAA, 0xA0, 0xA8, 0x0A, 0xE0, 0x08, 0x00, 0xF8, 0x01, 0x81, 0xE2, 0x33,
	0xB8, 0x21, 0x88, 0x18, 0xAD, 0x02, 0x82, 0x28, 0x3A, 0xCD, 0x0F, 0xE0,
	0x08, 0x00, 0xD8, 0x31, 0x0C, 0xBF, 0xB2, 0x12, 0x17, 0x2B, 0x77, 0xD2,
	0xCD, 0x10, 0x4B, 0x44, 0x0C, 0x06, 0x1B, 0x55, 0xB7, 0xA5, 0x02, 0x06,
	0x38, 0xFF, 0xC6, 0x2A, 0x00, 0xB8, 0xB1, 0xE2, 0x22, 0x10, 0xC2, 0x22,
	0x12, 0xA2, 0x22, 0x3F, 0x98, 0xE2, 0xF0, 0xAA, 0x11, 0xFA, 0x99, 0xCA,
	0xDF, 0xFA, 0xEE, 0xE2, 0x9E, 0x00, 0xFA, 0xCC, 0xE0, 0xBB, 0xC0, 0xB2,
	0x5C, 0x00, 0x92, 0x99, 0x00, 0xC2, 0x9D, 0x00, 0xA0, 0x99, 0xC0, 0xC7,
	0xB9, 0x16, 0xC8, 0xC1, 0x0C, 0x0F, 0xE2, 0x22, 0x14, 0xF2, 0x5D, 0x00,
	0xEA, 0xCC, 0xB2, 0x9C, 0x00, 0x1B, 0xBB, 0xB2, 0x5C, 0x00, 0xC2, 0x9D,
	0x00, 0xB8, 0xC1, 0x31, 0xC6, 0x33, 0xA2, 0x22, 0x10, 0x88, 0x23, 0xBA,
	0xAA, 0xB2, 0x22, 0x30, 0xA2, 0x9A, 0x00, 0x88, 0x78, 0x60, 0xAA, 0xA0,
	0xE0, 0x08, 0x00, 0xAD, 0x06, 0xB8, 0xB1, 0xD8, 0x01, 0x88, 0x23, 0xCD,
	0x0D, 0x88, 0x78, 0xD0, 0xBB, 0xC0, 0x60, 0xBB, 0xA0, 0xE0, 0x08, 0x00,
	0xA2, 0x22, 0x30, 0xF8, 0x01, 0xC2, 0x22, 0x12, 0xD8, 0xC1, 0x31, 0xB8,
	0x33, 0xB2, 0x22, 0x10, 0x88, 0x23, 0xDA, 0xBB, 0xDA, 0xCC, 0x88, 0x78,
	0xD8, 0xB1, 0xE2, 0x9C, 0x00, 0xF0, 0xDD, 0xC0, 0xE0, 0xDD, 0xC0, 0xD2,
	0x5B, 0x00, 0xB2, 0x9B, 0x00, 0xC2, 0x9C, 0x00, 0x60, 0xBB, 0xA0, 0xE0,
	0x08, 0x00, 0xD8, 0x31, 0x0C, 0xBF, 0x06, 0xCF, 0xFF, 0x1D, 0xF0, 0x00,
	0x36, 0x41, 0x00, 0x81, 0xAB, 0x33, 0x82, 0x28, 0x9B, 0x66, 0x28, 0x37,
	0x32, 0xC2, 0x1C, 0xA2, 0x92, 0x00, 0x65, 0x5C, 0xFF, 0x4D, 0x0A, 0xAC,
	0x4A, 0x98, 0x5A, 0xEC, 0x09, 0xA8, 0x1A, 0x9C, 0xCA, 0x50, 0x64, 0x00,
	0x0C, 0x4A, 0xBD, 0x04, 0xA5, 0x56, 0xFF, 0x0C, 0x4A, 0x8B, 0xB4, 0x65,
	0x56, 0xFF, 0xA8, 0x24, 0xB8, 0x44, 0xE5, 0x55, 0xFF, 0x50, 0xE6, 0x13,
	0x20, 0x20, 0x00, 0x4B, 0x22, 0x37, 0x92, 0xCA, 0x1D, 0xF0, 0x00, 0x00,
	0x36, 0x61, 0x00, 0x41, 0xF3, 0x33, 0x61, 0xF3, 0x33, 0x21, 0xBF, 0x33,
	0x31, 0x97, 0x33, 0x52, 0xC2, 0xE0, 0x88, 0x13, 0x82, 0x28, 0x3F, 0xA2,
	0x25, 0x7F, 0xE0, 0x08, 0x00, 0x9C, 0xEA, 0xA2, 0x25, 0x7F, 0xC8, 0x73,
	0x88, 0x13, 0xC2, 0x2C, 0x33, 0x82, 0x28, 0x20, 0xA0, 0xBA, 0xA0, 0xA0,
	0xBB, 0x11, 0x60, 0xAA, 0xA0, 0xA2, 0x2A, 0x7F, 0xBA, 0xB3, 0x4A, 0xBB,
	0xE0, 0x08, 0x00, 0x4B, 0x55, 0x27, 0x95, 0xCD, 0x51, 0xE7, 0x33, 0x0C,
	0x07, 0x0C, 0x0C, 0xE1, 0xE4, 0x33, 0xF1, 0xE2, 0x33, 0xF9, 0x01, 0xE9,
	0x11, 0xD2, 0x22, 0x7F, 0x0C, 0xA8, 0xD7, 0x28, 0x57, 0x0C, 0x1B, 0x0C,
	0x0A, 0x66, 0x7D, 0x0B, 0x0C, 0x1C, 0x0C, 0x19, 0xE6, 0x17, 0x01, 0x0C,
	0x0C, 0x90, 0x77, 0x53, 0xC0, 0xAB, 0x83, 0xBC, 0xEA, 0x66, 0x7D, 0x1C,
	0xE8, 0x73, 0xC2, 0x2E, 0x3E, 0x37, 0x6C, 0x14, 0xA8, 0x01, 0xB8, 0x11,
	0x88, 0x13, 0xC2, 0x2E, 0x33, 0x82, 0x28, 0x20, 0xF0, 0xCC, 0x11, 0xE0,
	0x08, 0x00, 0xC6, 0x07, 0x00, 0xE6, 0x9D, 0x1C, 0x88, 0x13, 0xC8, 0x73,
	0xD0, 0xBD, 0xA0, 0x60, 0xAD, 0xA0, 0xA2, 0x2A, 0x7F, 0xA0, 0xBB, 0x11,
	0xC2, 0x2C, 0x33, 0xBA, 0xB3, 0x82, 0x28, 0x20, 0x4A, 0xBB, 0xE0, 0x08,
	0x00, 0x0C, 0x0C, 0x4B, 0x22, 0x57, 0x92, 0x98, 0x1D, 0xF0, 0x00, 0x00,
	0x36, 0x81, 0x00, 0x0C, 0x06, 0x0C, 0x04, 0x0C, 0x87, 0x9D, 0x03, 0x0C,
	0xB3, 0x99, 0x51, 0x52, 0x22, 0x24, 0x88, 0xA2, 0x4A, 0x55, 0x4A, 0x88,
	0x88, 0x08, 0x58, 0x05, 0x16, 0xF8, 0x0E, 0x30, 0x85, 0xC0, 0x16, 0x98,
	0x0E, 0x92, 0xC5, 0xF9, 0xB6, 0x39, 0x02, 0x06, 0x38, 0x00, 0x81, 0x5E,
	0x33, 0xAD, 0x02, 0x88, 0x18, 0x0C, 0x0B, 0x82, 0x28, 0x3C, 0xCD, 0x06,
	0xE0, 0x08, 0x00, 0xA9, 0x61, 0x66, 0x75, 0x52, 0x90, 0x64, 0x00, 0x99,
	0x11, 0x81, 0x57, 0x33, 0xA8, 0xA2, 0x88, 0x08, 0x4A, 0xAA, 0x88, 0x98,
	0xA8, 0x0A, 0xE0, 0x08, 0x00, 0xA9, 0x21, 0xA8, 0x61, 0xE5, 0x49, 0xFF,
	0x81, 0x52, 0x33, 0x98, 0x21, 0xB8, 0x11, 0xAA, 0x99, 0xB0, 0xE6, 0x13,
	0x20, 0x20, 0x00, 0xA8, 0x51, 0xB2, 0x22, 0x46, 0x88, 0x18, 0xB8, 0x4B,
	0x82, 0x28, 0x48, 0xA0, 0x99, 0xC0, 0x99, 0x01, 0xAD, 0x02, 0xE0, 0x08,
	0x00, 0x8C, 0xEA, 0xAD, 0x02, 0x0C, 0x1C, 0x0C, 0x4D, 0xB2, 0x22, 0x46,
	0xE8, 0x01, 0xB8, 0x4B, 0xA5, 0x56, 0xFF, 0x66, 0x85, 0x74, 0x90, 0x64,
	0x00, 0x99, 0x31, 0x81, 0x42, 0x33, 0xA8, 0xA2, 0x88, 0x08, 0x4A, 0xAA,
	0x88, 0x98, 0xA8, 0x0A, 0xE0, 0x08, 0x00, 0x5D, 0x0A, 0xA8, 0x61, 0xA5,
	0x44, 0xFF, 0xB8, 0x61, 0x81, 0x3C, 0x33, 0xAA, 0x55, 0x98, 0x31, 0xAD,
	0x02, 0x90, 0xE6, 0x13, 0x20, 0x20, 0x00, 0x88, 0x18, 0x98, 0x51, 0x82,
	0x28, 0x48, 0x90, 0x55, 0xC0, 0xE0, 0x08, 0x00, 0x59, 0x41, 0x8C, 0xBA,
	0xED, 0x05, 0xB8, 0x61, 0xAD, 0x02, 0x0C, 0x0C, 0x0C, 0x8D, 0xE5, 0x51,
	0xFF, 0xA2, 0x22, 0x3E, 0x17, 0x6A, 0x23, 0x81, 0x2F, 0x33, 0xAD, 0x02,
	0x88, 0x18, 0xB2, 0x22, 0x46, 0x82, 0x28, 0x48, 0xB8, 0x4B, 0xE0, 0x08,
	0x00, 0x8C, 0xEA, 0xAD, 0x02, 0x0C, 0x1C, 0x0C, 0x4D, 0xB2, 0x22, 0x46,
	0xE8, 0x41, 0xB8, 0x4B, 0x25, 0x4F, 0xFF, 0x1B, 0x66, 0x4B, 0x44, 0x0B,
	0x77, 0x56, 0x67, 0xEF, 0x1D, 0xF0, 0x00, 0x00, 0x36, 0xA1, 0x00, 0xA2,
	0x12, 0x17, 0x39, 0x61, 0xE6, 0x1A, 0x02, 0xC6, 0x8E, 0x00, 0x0C, 0x05,
	0x0C, 0x07, 0x0C, 0x06, 0x0C, 0x04, 0x32, 0x22, 0x24, 0xF8, 0xA2, 0x4A,
	0x33, 0x4A, 0xFF, 0xF8, 0x0F, 0x38, 0x03, 0x16, 0x4F, 0x21, 0xA6, 0x93,
	0x02, 0x86, 0x83, 0x00, 0x0C, 0x0B, 0x0C, 0x1C, 0x82, 0x22, 0xC1, 0x0C,
	0x0D, 0x66, 0x28, 0x09, 0x92, 0x22, 0xC2, 0x98, 0x19, 0x57, 0x99, 0x01,
	0x0C, 0x1B, 0xB0, 0xDC, 0x83, 0x16, 0x2D, 0x1F, 0x0C, 0x0B, 0x0C, 0x19,
	0xE2, 0x22, 0xC3, 0x0C, 0x08, 0x66, 0x2E, 0x09, 0xF2, 0x22, 0xC4, 0xF8,
	0x1F, 0x57, 0x9F, 0x01, 0xBD, 0x0C, 0xB0, 0x89, 0x83, 0x16, 0x68, 0x1D,
	0xB2, 0xC3, 0xF9, 0xB6, 0x3B, 0x02, 0x46, 0x73, 0x00, 0x98, 0xC2, 0xD8,
	0x61, 0x90, 0xC3, 0xA0, 0xD8, 0x0D, 0xD9, 0x41, 0xC8, 0x0C, 0xC9, 0x71,
	0x66, 0x73, 0x03, 0xE8, 0x89, 0xE9, 0x71, 0xA8, 0x71, 0xC8, 0x32, 0xB8,
	0x61, 0x81, 0x00, 0x33, 0xD2, 0x22, 0x19, 0x88, 0x18, 0x6A, 0xDD, 0x82,
	0x28, 0x2D, 0xB8, 0x0B, 0xE0, 0x08, 0x00, 0x92, 0x22, 0x40, 0x9C, 0x69,
	0xA8, 0x71, 0xC8, 0x32, 0xB8, 0x61, 0x81, 0xF9, 0x32, 0xD2, 0x22, 0xC0,
	0x88, 0x18, 0x6A, 0xDD, 0x82, 0x28, 0x2D, 0xB8, 0x0B, 0xE0, 0x08, 0x00,
	0xA8, 0x71, 0xD2, 0x12, 0x3A, 0xE2, 0x12, 0x3B, 0xC2, 0x22, 0x1C, 0xB8,
	0x61, 0x81, 0xF1, 0x32, 0xB8, 0x0B, 0x88, 0x18, 0x7A, 0xCC, 0x82, 0x28,
	0x2F, 0xC2, 0x1C, 0x00, 0xE0, 0x08, 0x00, 0x81, 0xED, 0x32, 0xAD, 0x02,
	0x88, 0x18, 0x0C, 0x0B, 0x82, 0x28, 0x3C, 0xCD, 0x05, 0xE0, 0x08, 0x00,
	0x9D, 0x0A, 0xD2, 0xCA, 0xEC, 0xA2, 0xCA, 0xF6, 0xF6, 0x4A, 0x0B, 0xC1,
	0x36, 0x33, 0xC0, 0xC9, 0xA0, 0xC2, 0x2C, 0x7F, 0x86, 0x02, 0x00, 0x99,
	0x51, 0x1C, 0x8E, 0xE9, 0x81, 0xB6, 0x2D, 0x08, 0x1C, 0x0C, 0xC9, 0x81,
	0x99, 0x51, 0xF6, 0x2D, 0x13, 0xA2, 0x22, 0x17, 0x81, 0xDE, 0x32, 0xB8,
	0x71, 0x88, 0x18, 0xC8, 0x61, 0x82, 0x28, 0x21, 0xC8, 0x0C, 0xE0, 0x08,
	0x00, 0x81, 0xD9, 0x32, 0x88, 0x18, 0xAD, 0x02, 0x82, 0x28, 0x48, 0xB8,
	0x51, 0xE0, 0x08, 0x00, 0xCC, 0x7A, 0x92, 0x22, 0x36, 0x26, 0x89, 0x02,
	0x66, 0xB9, 0x5E, 0x92, 0x12, 0x16, 0x0C, 0x0A, 0xA9, 0x41, 0xA2, 0x22,
	0x2B, 0x9A, 0x95, 0xA0, 0x99, 0xA0, 0x98, 0x09, 0x16, 0x59, 0x04, 0xAD,
	0x02, 0xB8, 0x51, 0x0C, 0x0C, 0x65, 0x37, 0xFF, 0x81, 0xCC, 0x32, 0xC2,
	0x22, 0x30, 0x92, 0x12, 0x62, 0xB2, 0x22, 0x2B, 0xE8, 0x61, 0xDD, 0x0A,
	0xA2, 0x12, 0x16, 0xE2, 0x1E, 0x00, 0xAA, 0xA5, 0xB0, 0xAA, 0xA0, 0xA8,
	0x0A, 0x99, 0x01, 0x88, 0x28, 0xF2, 0xC1, 0x10, 0x82, 0x28, 0x16, 0xB8,
	0x71, 0xE0, 0x08, 0x00, 0x66, 0x8A, 0x0D, 0xC2, 0x22, 0x14, 0xC0, 0xC3,
	0x90, 0xB2, 0x9C, 0x00, 0x1B, 0xBB, 0xB2, 0x5C, 0x00, 0xD2, 0x22, 0x30,
	0xD9, 0x71, 0x81, 0xBB, 0x32, 0xA8, 0xA2, 0x88, 0x08, 0x4A, 0xAA, 0x88,
	0x98, 0xA8, 0x0A, 0xE0, 0x08, 0x00, 0xC8, 0x81, 0xCC, 0xCA, 0xA2, 0x22,
	0x13, 0xA0, 0xA3, 0x90, 0x92, 0x9A, 0x00, 0x1B, 0x99, 0x92, 0x5A, 0x00,
	0xA8, 0x71, 0xB8, 0x41, 0x65, 0x28, 0xFF, 0xC8, 0x41, 0xA6, 0xFC, 0x04,
	0xC2, 0xA0, 0xFC, 0xC9, 0x41, 0xB8, 0x71, 0xA8, 0xA2, 0x88, 0x02, 0x4A,
	0xAA, 0x88, 0x88, 0xA8, 0x0A, 0xE0, 0x08, 0x00, 0xB2, 0x22, 0xC1, 0xD2,
	0x22, 0xC2, 0x66, 0x2B, 0x18, 0xC8, 0x0D, 0x57, 0x9C, 0x13, 0xB8, 0x71,
	0xC8, 0x41, 0xE8, 0xA2, 0x88, 0x02, 0xA8, 0x1D, 0x88, 0x88, 0xE0, 0xAA,
	0xA0, 0xA8, 0x0A, 0xE0, 0x08, 0x00, 0x92, 0x22, 0xC3, 0xD2, 0x22, 0xC4,
	0x66, 0x29, 0x18, 0xA8, 0x0D, 0x57, 0x9A, 0x13, 0xB8, 0x71, 0xC8, 0x41,
	0xE8, 0xA2, 0x88, 0x02, 0xA8, 0x1D, 0x88, 0x88, 0xE0, 0xAA, 0xA0, 0xA8,
	0x0A, 0xE0, 0x08, 0x00, 0x66, 0x73, 0x10, 0x81, 0x99, 0x32, 0xB8, 0x51,
	0x88, 0x18, 0xAD, 0x02, 0x82, 0x28, 0x3A, 0xC8, 0x41, 0xE0, 0x08, 0x00,
	0xA2, 0x12, 0x17, 0x2B, 0x77, 0x62, 0xC6, 0x10, 0x4B, 0x44, 0x1B, 0x55,
	0xA7, 0xA5, 0x02, 0xC6, 0x72, 0xFF, 0xA8, 0x61, 0x98, 0x41, 0x99, 0x0A,
	0x1D, 0xF0, 0x00, 0x00, 0x36, 0x41, 0x00, 0xAD, 0x04, 0x41, 0x8C, 0x32,
	0xBD, 0x02, 0xC2, 0x24, 0xB2, 0xA5, 0xBB, 0x01, 0xAD, 0x05, 0xBD, 0x03,
	0xC2, 0x24, 0xB2, 0x25, 0xBB, 0x01, 0x0C, 0x02, 0x1D, 0xF0, 0x00, 0x00,
	0x36, 0xC1, 0x00, 0x39, 0x81, 0x88, 0x03, 0xD2, 0x12, 0x16, 0x89, 0xA1,
	0xE6, 0x1D, 0x02, 0xC6, 0x91, 0x00, 0x0C, 0x05, 0x0C, 0x06, 0x0C, 0x07,
	0x0C, 0x04, 0x80, 0xC0, 0xF4, 0xC9, 0x51, 0xE8, 0x92, 0x32, 0x22, 0x23,
	0x0C, 0x08, 0x89, 0xC1, 0x4A, 0x33, 0x4A, 0xEE, 0xE8, 0x0E, 0x38, 0x03,
	0x16, 0x7E, 0x21, 0x81, 0x79, 0x32, 0x88, 0x18, 0x82, 0x28, 0x3E, 0xAD,
	0x03, 0xE0, 0x08, 0x00, 0x16, 0x4A, 0x20, 0x81, 0x75, 0x32, 0xAD, 0x02,
	0x88, 0x18, 0x0C, 0x1B, 0x82, 0x28, 0x3C, 0xCD, 0x05, 0xE0, 0x08, 0x00,
	0x92, 0x22, 0x36, 0xA9, 0x91, 0x26, 0x89, 0x25, 0x26, 0xB9, 0x22, 0xF0,
	0xD3, 0x11, 0x0C, 0x09, 0xC8, 0xC2, 0xA2, 0x22, 0x12, 0xB2, 0x22, 0x10,
	0xA0, 0xA3, 0x90, 0xB0, 0xB3, 0x90, 0xC0, 0xC3, 0xA0, 0xC8, 0x0C, 0xC9,
	0xB1, 0x92, 0x5B, 0x00, 0x92, 0x5A, 0x00, 0xC6, 0x15, 0x00, 0xC8, 0xE2,
	0xB2, 0x22, 0x12, 0xC0, 0xC3, 0x90, 0xB0, 0xB3, 0x90, 0xF2, 0x9B, 0x00,
	0xC2, 0x9C, 0x00, 0xF0, 0xD3, 0x11, 0xF7, 0x2C, 0x02, 0xD6, 0x0F, 0x02,
	0xC8, 0xE2, 0x0C, 0x09, 0xF2, 0x22, 0x12, 0x82, 0x22, 0x14, 0xDA, 0xFF,
	0xDA, 0x88, 0x92, 0x5B, 0x00, 0xE2, 0x98, 0x00, 0xDA, 0xCC, 0x1B, 0xEE,
	0xE2, 0x58, 0x00, 0xC2, 0x9C, 0x00, 0xF2, 0x9F, 0x00, 0x0C, 0x1B, 0xF0,
	0xAC, 0xC0, 0xB9, 0xC1, 0xA2, 0xCA, 0xF8, 0xA9, 0x71, 0xA6, 0x1A, 0x0D,
	0x0C, 0x0C, 0xB8, 0x71, 0xC9, 0xC1, 0xA6, 0x1B, 0x04, 0xE2, 0x22, 0x30,
	0xE9, 0xB1, 0xD9, 0x61, 0x0C, 0x18, 0x98, 0xC1, 0x0C, 0x0F, 0x90, 0xF8,
	0x83, 0x16, 0xFF, 0x15, 0xB8, 0xB1, 0xC8, 0xA1, 0xA8, 0x92, 0x88, 0x02,
	0x4A, 0xAA, 0x88, 0x98, 0xA8, 0x0A, 0xE0, 0x08, 0x00, 0x81, 0x47, 0x32,
	0x88, 0x18, 0xA8, 0xB1, 0x82, 0x28, 0x17, 0xB8, 0xA1, 0xE0, 0x08, 0x00,
	0xA8, 0xB1, 0xB8, 0xA1, 0x81, 0x43, 0x32, 0xC8, 0x32, 0x88, 0x18, 0xD2,
	0x22, 0x18, 0x82, 0x28, 0x2D, 0x7A, 0xDD, 0xE0, 0x08, 0x00, 0x98, 0x91,
	0x92, 0xC9, 0xF0, 0xF6, 0x39, 0x14, 0x81, 0x3C, 0x32, 0xA2, 0x22, 0x16,
	0x88, 0x18, 0xB8, 0xB1, 0x82, 0x28, 0x21, 0xC8, 0xA1, 0xE0, 0x08, 0x00,
	0x46, 0x06, 0x00, 0x98, 0x91, 0x92, 0xC9, 0xF2, 0xF6, 0x29, 0x11, 0x81,
	0x35, 0x32, 0xA2, 0x22, 0xDD, 0x88, 0x18, 0xB8, 0xB1, 0x82, 0x28, 0x21,
	0xC8, 0xA1, 0xE0, 0x08, 0x00, 0x92, 0x22, 0x36, 0x26, 0xB9, 0x09, 0x26,
	0x89, 0x06, 0xB8, 0xA1, 0xB9, 0x41, 0x46, 0x29, 0x00, 0xC2, 0x22, 0x12,
	0xE8, 0x61, 0xA2, 0x22, 0x10, 0xD8, 0xC2, 0x81, 0x2A, 0x32, 0xE0, 0x93,
	0x11, 0x99, 0xD1, 0x88, 0x28, 0xD0, 0xD3, 0xA0, 0xD8, 0x0D, 0xEA, 0xAA,
	0xEA, 0xCC, 0xC2, 0x9C, 0x00, 0x88, 0x88, 0xA2, 0x9A, 0x00, 0xBD, 0x0D,
	0xD0, 0xAA, 0xA0, 0xE0, 0x08, 0x00, 0x0C, 0x0B, 0xC2, 0x22, 0x12, 0xE8,
	0x61, 0xA2, 0x22, 0x2B, 0xD2, 0x22, 0x10, 0x4A, 0xAA, 0xEA, 0xDD, 0xEA,
	0xCC, 0xC2, 0x9C, 0x00, 0xC2, 0x5D, 0x00, 0xB9, 0x41, 0xA8, 0x0A, 0x38,
	0xD1, 0x16, 0xCA, 0x04, 0xB8, 0x91, 0xAD, 0x02, 0x0C, 0x1C, 0x25, 0x0A,
	0xFF, 0xB8, 0xB1, 0x81, 0x16, 0x32, 0x98, 0x71, 0xF8, 0x61, 0xC2, 0x22,
	0x10, 0xDD, 0x0A, 0xE8, 0xC2, 0xA2, 0x22, 0x2B, 0x3A, 0xEE, 0xE8, 0x0E,
	0xFA, 0xCC, 0x4A, 0xAA, 0xF2, 0xC1, 0x10, 0xC2, 0x9C, 0x00, 0xA8, 0x0A,
	0x99, 0x01, 0x88, 0x28, 0xE0, 0xCC, 0xA0, 0x82, 0x28, 0x16, 0xE8, 0x51,
	0xE0, 0x08, 0x00, 0x66, 0x8A, 0x0E, 0x98, 0x61, 0x82, 0x22, 0x14, 0x9A,
	0x88, 0xF2, 0x98, 0x00, 0x1B, 0xFF, 0xF2, 0x58, 0x00, 0xA8, 0xC2, 0xB8,
	0x41, 0x3A, 0xAA, 0xA8, 0x0A, 0xA9, 0xB1, 0xA8, 0xB1, 0xD2, 0x12, 0x3A,
	0xE2, 0x12, 0x3B, 0x31, 0x01, 0x32, 0xC2, 0x22, 0x1B, 0x88, 0x13, 0x6A,
	0xCC, 0x82, 0x28, 0x2F, 0xC2, 0x1C, 0x00, 0xE0, 0x08, 0x00, 0xF8, 0x41,
	0x0C, 0x08, 0xA8, 0x61, 0xE2, 0x22, 0x12, 0x92, 0x22, 0x10, 0xAA, 0xEE,
	0xAA, 0x99, 0x82, 0x59, 0x00, 0xD2, 0x9E, 0x00, 0xFA, 0xDD, 0xD2, 0x5E,
	0x00, 0xE8, 0x81, 0x80, 0xDD, 0x23, 0xD9, 0x0E, 0xD2, 0x12, 0x16, 0x2B,
	0x66, 0x72, 0xC7, 0x10, 0x4B, 0x44, 0x1B, 0x55, 0xD7, 0xA5, 0x02, 0x06,
	0x71, 0xFF, 0x1D, 0xF0, 0x36, 0x41, 0x01, 0x9D, 0x01, 0x0C, 0x0A, 0x1C,
	0x98, 0x76, 0xA8, 0x03, 0xA9, 0x09, 0x4B, 0x99, 0xA2, 0x12, 0x16, 0x0C,
	0x04, 0xE6, 0x1A, 0x02, 0x86, 0x22, 0x00, 0x61, 0xE8, 0x31, 0x0C, 0x03,
	0x52, 0x22, 0x23, 0xC8, 0x92, 0x3A, 0x55, 0x3A, 0xCC, 0xC8, 0x0C, 0x58,
	0x05, 0x16, 0xBC, 0x06, 0x88, 0x16, 0x82, 0x28, 0x3F, 0xAD, 0x05, 0xE0,
	0x08, 0x00, 0x16, 0xBA, 0x05, 0xAD, 0x02, 0x88, 0x16, 0x0C, 0x1B, 0x82,
	0x28, 0x3C, 0xCD, 0x04, 0xE0, 0x08, 0x00, 0x7D, 0x0A, 0x88, 0x16, 0xAD,
	0x02, 0x82, 0x28, 0x48, 0xBD, 0x07, 0xE0, 0x08, 0x00, 0x9D, 0x01, 0x90,
	0x97, 0xA0, 0xBC, 0x3A, 0xA8, 0x09, 0xEC, 0xFA, 0xB2, 0x22, 0xC8, 0xEC,
	0xAB, 0x92, 0x61, 0x1C, 0x66, 0x35, 0x07, 0xC2, 0x22, 0xDC, 0x92, 0x61,
	0x1C, 0xDC, 0xCC, 0xBD, 0x07, 0xAD, 0x02, 0xE2, 0x22, 0x23, 0x0C, 0x1C,
	0x3A, 0xEE, 0xE8, 0x0E, 0xF2, 0x22, 0x12, 0xDD, 0x0E, 0xF0, 0xEE, 0x90,
	0xE2, 0x9E, 0x00, 0x65, 0xF8, 0xFE, 0x92, 0x21, 0x1C, 0x0C, 0x1F, 0xF9,
	0x09, 0xA2, 0x12, 0x16, 0x4B, 0x33, 0x1B, 0x44, 0xA7, 0xA4, 0x02, 0x46,
	0xDE, 0xFF, 0x1D, 0xF0, 0x36, 0x41, 0x00, 0x41, 0xC4, 0x31, 0x70, 0x64,
	0x00, 0x58, 0x74, 0xB2, 0x15, 0x17, 0x0C, 0x06, 0xA6, 0x1B, 0x7A, 0x0C,
	0x02, 0xA8, 0xA5, 0x2A, 0xAA, 0xA8, 0x0A, 0x16, 0x8A, 0x06, 0x88, 0x04,
	0x88, 0x88, 0xE0, 0x08, 0x00, 0x58, 0x74, 0xC2, 0x25, 0x24, 0x2A, 0xCC,
	0xC8, 0x0C, 0x66, 0x6C, 0x17, 0xA2, 0x25, 0x46, 0xA0, 0xAC, 0xA0, 0xA8,
	0x0A, 0x0C, 0x3B, 0x50, 0xAA, 0xA0, 0xA2, 0x2A, 0xC7, 0x65, 0x8B, 0x02,
	0x3D, 0x0A, 0x46, 0x07, 0x00, 0x66, 0x7C, 0x17, 0xA2, 0x25, 0x46, 0xA0,
	0xAC, 0xA0, 0xA8, 0x0A, 0x0C, 0x3B, 0x50, 0xAA, 0xA0, 0xA2, 0x2A, 0xC7,
	0xA5, 0x89, 0x02, 0x3D, 0x0A, 0x86, 0x00, 0x00, 0x32, 0xA1, 0x00, 0xA6,
	0x13, 0x19, 0x0C, 0x05, 0x0C, 0x0B, 0xA8, 0x74, 0x88, 0x04, 0xA8, 0xAA,
	0x88, 0x68, 0x2A, 0xAA, 0xA8, 0x0A, 0xE0, 0x08, 0x00, 0x1B, 0x55, 0x37,
	0x95, 0xE9, 0x58, 0x74, 0xB2, 0x15, 0x17, 0x4B, 0x22, 0x1B, 0x66, 0xB7,
	0x26, 0x86, 0x70, 0xE6, 0x13, 0x20, 0x20, 0x00, 0x1D, 0xF0, 0x00, 0x00,
	0x36, 0x21, 0x02, 0x52, 0x61, 0x32, 0x42, 0x61, 0x31, 0x9D, 0x03, 0x82,
	0x12, 0x16, 0x31, 0x9B, 0x31, 0x92, 0x61, 0x30, 0xE6, 0x18, 0x02, 0x46,
	0x2B, 0x00, 0x0C, 0x07, 0x0C, 0x06, 0x0C, 0x0B, 0xB2, 0x61, 0x34, 0xAD,
	0x02, 0x0C, 0x1B, 0xCD, 0x06, 0x42, 0x22, 0x23, 0x88, 0x13, 0x7A, 0x44,
	0x82, 0x28, 0x3C, 0x48, 0x04, 0xE0, 0x08, 0x00, 0x88, 0x13, 0x5D, 0x0A,
	0x82, 0x28, 0x3F, 0xAD, 0x04, 0xE0, 0x08, 0x00, 0x16, 0x0A, 0x07, 0x98,
	0x92, 0x7A, 0x99, 0x98, 0x09, 0x16, 0x79, 0x06, 0xAD, 0x02, 0x88, 0x13,
	0x92, 0x21, 0x34, 0x50, 0x50, 0xF4, 0xBD, 0x05, 0x1B, 0x99, 0x82, 0x28,
	0x48, 0x92, 0x61, 0x34, 0xE0, 0x08, 0x00, 0x9C, 0x8A, 0xA2, 0x22, 0x46,
	0xA8, 0x3A, 0x57, 0x1A, 0x46, 0xB2, 0x22, 0x11, 0xC2, 0x22, 0x33, 0xB0,
	0xB4, 0x90, 0xB2, 0x9B, 0x00, 0xC7, 0xAB, 0x37, 0x86, 0xA4, 0x00, 0xA2,
	0x22, 0x36, 0x3C, 0x0C, 0xC7, 0x1A, 0x04, 0x2C, 0xCD, 0xD7, 0x9A, 0x11,
	0xE2, 0x22, 0x11, 0xF2, 0x22, 0x34, 0xE0, 0xE4, 0x90, 0xE2, 0x9E, 0x00,
	0xF7, 0xAE, 0x18, 0xC6, 0x9C, 0x00, 0xA8, 0x92, 0x88, 0x03, 0x7A, 0xAA,
	0x88, 0x98, 0xA8, 0x0A, 0xE0, 0x08, 0x00, 0x92, 0x22, 0x34, 0x97, 0xAA,
	0x02, 0x46, 0x97, 0x00, 0x4B, 0x77, 0xA2, 0x12, 0x16, 0x1B, 0x66, 0xA7,
	0xA6, 0x02, 0x46, 0xD7, 0xFF, 0x06, 0x01, 0x00, 0x0C, 0x0B, 0xB2, 0x61,
	0x34, 0x0C, 0x1C, 0xC2, 0x61, 0x35, 0xE2, 0x21, 0x30, 0x82, 0x21, 0x34,
	0xF2, 0x21, 0x35, 0x0C, 0x09, 0x80, 0x9F, 0x93, 0x99, 0x0E, 0x66, 0x19,
	0x12, 0x92, 0x22, 0x35, 0x16, 0x29, 0x23, 0x0C, 0x1A, 0x0B, 0xB9, 0xB2,
	0x62, 0x35, 0xA2, 0x61, 0x33, 0x06, 0x01, 0x00, 0x0C, 0x0C, 0xC2, 0x61,
	0x33, 0xD2, 0x12, 0x76, 0x0C, 0x0F, 0xE2, 0x12, 0x75, 0xE2, 0x61, 0x36,
	0xF2, 0x61, 0x37, 0xE7, 0xBD, 0x02, 0xC6, 0x63, 0x00, 0x52, 0x21, 0x36,
	0x0C, 0x1F, 0xF2, 0x61, 0x35, 0x52, 0x61, 0x38, 0x0C, 0x05, 0x82, 0x21,
	0x38, 0x26, 0x08, 0x4D, 0xAD, 0x02, 0x0C, 0x1B, 0xDD, 0x01, 0x88, 0x13,
	0xC2, 0x21, 0x38, 0x82, 0x28, 0x3B, 0xC0, 0xC0, 0xF4, 0xE0, 0x08, 0x00,
	0xA0, 0x90, 0xF4, 0xA6, 0x19, 0x33, 0x6D, 0x01, 0x7D, 0x01, 0x70, 0x79,
	0x90, 0xD2, 0x96, 0x00, 0x26, 0x0D, 0x21, 0x88, 0x92, 0x80, 0x8D, 0xA0,
	0x88, 0x08, 0x9C, 0x78, 0x88, 0x13, 0xA2, 0x22, 0x23, 0x82, 0x28, 0x3E,
	0xA0, 0xAD, 0xA0, 0xA8, 0x0A, 0xE0, 0x08, 0x00, 0x8C, 0x5A, 0x0C, 0x19,
	0x06, 0x02, 0x00, 0x00, 0x00, 0x2B, 0x66, 0x77, 0x96, 0xD2, 0x0C, 0x09,
	0x16, 0xF9, 0x0E, 0x98, 0x73, 0x92, 0x29, 0x36, 0x42, 0x22, 0x32, 0x26,
	0x89, 0x02, 0x66, 0xB9, 0x7A, 0xAD, 0x02, 0x0C, 0x1B, 0xC2, 0x21, 0x38,
	0x88, 0x13, 0xD2, 0xC1, 0x7F, 0x82, 0x28, 0x3B, 0x1B, 0xDD, 0xE0, 0x08,
	0x00, 0xA0, 0xE0, 0xF4, 0x92, 0xC1, 0x7F, 0x1B, 0x99, 0x76, 0xAE, 0x2C,
	0xA2, 0x99, 0x00, 0x2B, 0x99, 0x26, 0x0A, 0x22, 0xB8, 0x92, 0xB0, 0xBA,
	0xA0, 0xB8, 0x0B, 0x9C, 0x8B, 0x82, 0x22, 0x23, 0x92, 0x22, 0x12, 0x80,
	0x8A, 0xA0, 0x88, 0x08, 0x42, 0x22, 0x32, 0x90, 0x88, 0x90, 0x82, 0x98,
	0x00, 0x80, 0x44, 0xC0, 0x46, 0x00, 0x00, 0x3D, 0xF0, 0xAD, 0x02, 0xB2,
	0x21, 0x38, 0x0C, 0x1C, 0x65, 0xCE, 0xFE, 0xAC, 0x1A, 0xB1, 0x86, 0x31,
	0x91, 0x87, 0x31, 0xBA, 0xBA, 0xB7, 0x39, 0x02, 0x86, 0x26, 0x00, 0x0C,
	0x02, 0xD2, 0x21, 0x31, 0x0C, 0x0C, 0xC9, 0x0D, 0x1D, 0xF0, 0x0C, 0x44,
	0x40, 0x4A, 0x53, 0x3B, 0x44, 0x80, 0x44, 0x10, 0xC2, 0x21, 0x38, 0xAD,
	0x02, 0x88, 0x13, 0x0C, 0x1B, 0x82, 0x28, 0x3B, 0xD2, 0xC1, 0x40, 0xE0,
	0x08, 0x00, 0xA6, 0x1A, 0x51, 0x62, 0xC1, 0x40, 0x72, 0xC1, 0x40, 0x70,
	0x7A, 0x90, 0x92, 0x96, 0x00, 0x26, 0x09, 0x3D, 0xA2, 0x22, 0x23, 0xA0,
	0xA9, 0xA0, 0xA8, 0x0A, 0xE6, 0x7A, 0x32, 0xB8, 0x92, 0xB0, 0xB9, 0xA0,
	0xB8, 0x0B, 0xAC, 0x8B, 0x88, 0x13, 0x82, 0x28, 0x3E, 0xE0, 0x08, 0x00,
	0x9C, 0xEA, 0xB8, 0x92, 0x88, 0x03, 0xA2, 0x96, 0x00, 0x88, 0x98, 0xB0,
	0xAA, 0xA0, 0xA8, 0x0A, 0xE0, 0x08, 0x00, 0x47, 0xBA, 0x09, 0x0C, 0x15,
	0x0C, 0x0C, 0xC2, 0x61, 0x35, 0x86, 0x01, 0x00, 0x0C, 0x15, 0x2B, 0x66,
	0x77, 0x96, 0xB6, 0xD2, 0x12, 0x76, 0xE2, 0x21, 0x37, 0xF2, 0x21, 0x36,
	0x1B, 0xEE, 0xE2, 0x61, 0x37, 0xFA, 0xEE, 0xE0, 0xE0, 0xF4, 0xE2, 0x61,
	0x38, 0xE7, 0x3D, 0x02, 0x86, 0xA6, 0xFF, 0x46, 0x08, 0x00, 0x7C, 0xC8,
	0xD2, 0x12, 0x62, 0xB1, 0x38, 0x31, 0x40, 0xAA, 0x82, 0xBA, 0xAA, 0xA0,
	0xA4, 0x31, 0xA7, 0x2D, 0x02, 0x46, 0xD6, 0xFF, 0x4D, 0x0D, 0x46, 0xD6,
	0xFF, 0x0C, 0x05, 0x0C, 0x1C, 0xC2, 0x61, 0x35, 0x0C, 0x09, 0x8C, 0x65,
	0xE2, 0x21, 0x35, 0x0C, 0x1D, 0xE0, 0x9D, 0x93, 0xF2, 0x21, 0x31, 0x82,
	0x21, 0x32, 0x99, 0x0F, 0x49, 0x08, 0xF8, 0x0F, 0x66, 0x1F, 0x22, 0xA2,
	0x22, 0x3E, 0x0C, 0x19, 0x57, 0x6A, 0x15, 0xB2, 0x21, 0x30, 0x0C, 0x2C,
	0xC2, 0x62, 0x35, 0xB8, 0x0B, 0x66, 0x1B, 0x0D, 0x92, 0x62, 0x35, 0x92,
	0x61, 0x33, 0x06, 0x01, 0x00, 0x0C, 0x0E, 0xE2, 0x62, 0x35, 0xF2, 0x21,
	0x33, 0x9C, 0xFF, 0xA2, 0x12, 0x17, 0xA6, 0x1A, 0x1A, 0x92, 0x22, 0x24,
	0x0C, 0x06, 0x76, 0x9A, 0x19, 0x88, 0x09, 0x4B, 0x99, 0x66, 0x68, 0x10,
	0xA2, 0x22, 0x19, 0xC0, 0xB6, 0x11, 0xBA, 0xAA, 0x98, 0x2A, 0x99, 0x1A,
	0x22, 0x21, 0x33, 0x1D, 0xF0, 0x1B, 0x66, 0x46, 0xFD, 0xFF, 0x0C, 0x0C,
	0xC2, 0x61, 0x35, 0xC6, 0x6C, 0xFF, 0x0C, 0x0D, 0xD2, 0x61, 0x33, 0x86,
	0x75, 0xFF, 0x00, 0x00, 0x36, 0x41, 0x00, 0x21, 0xFC, 0x30, 0x51, 0x34,
	0x31, 0x0C, 0xB6, 0x0C, 0x83, 0x76, 0xA3, 0x17, 0x42, 0x22, 0x7F, 0x4B,
	0x22, 0x67, 0x14, 0x0C, 0x92, 0x25, 0x80, 0x82, 0x25, 0x7F, 0x97, 0x18,
	0x03, 0x0C, 0x02, 0x1D, 0xF0, 0x52, 0xC5, 0x10, 0x0C, 0x12, 0x1D, 0xF0,
	0x36, 0x61, 0x00, 0x50, 0x64, 0x00, 0x59, 0x01, 0x21, 0xC8, 0x30, 0x51,
	0x29, 0x31, 0x88, 0x72, 0x32, 0xD2, 0x12, 0x38, 0xC3, 0x88, 0x98, 0x50,
	0x33, 0xA0, 0x52, 0x13, 0x80, 0x32, 0x13, 0x7F, 0x80, 0x55, 0xA0, 0x80,
	0x33, 0xA0, 0x38, 0x03, 0x58, 0x05, 0x16, 0xD3, 0x09, 0x16, 0xA5, 0x09,
	0xA8, 0x25, 0xC8, 0x05, 0xD8, 0x03, 0xB8, 0x23, 0x82, 0xDD, 0x02, 0x87,
	0x3B, 0x05, 0x92, 0xDC, 0x02, 0x97, 0xBA, 0x17, 0xA2, 0xDA, 0x02, 0xF2,
	0xDC, 0x04, 0xB2, 0xDB, 0x02, 0xE2, 0xDD, 0x04, 0xB7, 0xBE, 0x02, 0xB2,
	0xDB, 0xFC, 0xA7, 0xBF, 0x02, 0xA2, 0xDA, 0xFC, 0xC0, 0x9A, 0xC0, 0xD0,
	0x8B, 0xC0, 0xA1, 0xD1, 0x30, 0x3B, 0x78, 0x3B, 0x69, 0x90, 0x69, 0xB3,
	0x80, 0x78, 0xB3, 0x70, 0x72, 0x21, 0x60, 0x62, 0x21, 0x77, 0xA6, 0x2A,
	0x60, 0x97, 0xC0, 0xB2, 0x2A, 0x7F, 0x0B, 0x49, 0x9C, 0xCB, 0x26, 0x19,
	0x1D, 0x88, 0x02, 0xAD, 0x05, 0x88, 0x68, 0x0C, 0x0B, 0xE0, 0x08, 0x00,
	0x92, 0x22, 0x96, 0x0B, 0x44, 0x1B, 0x99, 0x92, 0x62, 0x96, 0xE6, 0x14,
	0xE7, 0x86, 0x00, 0x00, 0x42, 0x62, 0x96, 0xA1, 0xC1, 0x30, 0x67, 0xA7,
	0x21, 0xB2, 0x2A, 0x7F, 0x70, 0x46, 0xC0, 0xAC, 0x2B, 0x9C, 0x64, 0x88,
	0x02, 0xAD, 0x03, 0x88, 0x68, 0x0C, 0x0B, 0xE0, 0x08, 0x00, 0x92, 0x22,
	0x96, 0x0B, 0x44, 0x1B, 0x99, 0x92, 0x62, 0x96, 0xE6, 0x14, 0xE7, 0xA8,
	0x01, 0xA0, 0xE6, 0x13, 0x20, 0x20, 0x00, 0x1D, 0xF0, 0x42, 0x62, 0x96,
	0xC6, 0xFB, 0xFF, 0x00, 0x36, 0x61, 0x00, 0x82, 0x22, 0x14, 0xA2, 0x22,
	0x1C, 0x0C, 0x0B, 0xB9, 0x01, 0xB9, 0x11, 0xB9, 0x21, 0xA8, 0x0A, 0xE0,
	0x08, 0x00, 0x6D, 0x0A, 0xA6, 0x1A, 0x27, 0x0C, 0x05, 0xBD, 0x01, 0x4B,
	0xC1, 0xA2, 0x22, 0x1C, 0x8B, 0xD1, 0xA8, 0x0A, 0x65, 0x75, 0x01, 0x8C,
	0xFA, 0xB8, 0x11, 0xA8, 0x01, 0xB7, 0x93, 0x02, 0xA7, 0x14, 0x06, 0x88,
	0xF2, 0xC8, 0x21, 0xE0, 0x08, 0x00, 0x1B, 0x55, 0x57, 0x96, 0xD9, 0x1D,
	0xF0, 0x00, 0x00, 0x00, 0x36, 0x61, 0x00, 0x71, 0x80, 0x30, 0x98, 0x17,
	0x82, 0x22, 0xBD, 0x92, 0x29, 0x52, 0x99, 0x11, 0x56, 0x88, 0x05, 0xA8,
	0x11, 0x0C, 0x1B, 0xB2, 0x62, 0xBD, 0xA8, 0x0A, 0xA6, 0x1A, 0x4C, 0x58,
	0x11, 0x61, 0xDB, 0x30, 0x0C, 0x0C, 0xC9, 0x01, 0xD8, 0x15, 0x0C, 0x03,
	0xE8, 0x0D, 0x0C, 0x04, 0xA6, 0x1E, 0x2B, 0x3C, 0x4C, 0x88, 0x07, 0xB2,
	0x26, 0x7F, 0xDA, 0xA3, 0x4B, 0xAA, 0x3A, 0xBB, 0x82, 0x28, 0x20, 0x4B,
	0xBB, 0xE0, 0x08, 0x00, 0x1B, 0x44, 0xD8, 0x15, 0xC2, 0x22, 0xD7, 0xDA,
	0xE3, 0xC9, 0x7E, 0xB8, 0x0D, 0x32, 0xC3, 0x34, 0xB7, 0x24, 0xD7, 0xA8,
	0x11, 0xA8, 0x0A, 0x4B, 0x66, 0xB8, 0x01, 0x4B, 0x55, 0x1B, 0xBB, 0xB9,
	0x01, 0xA7, 0x2B, 0xBB, 0x0C, 0xAA, 0x0C, 0x0B, 0x0C, 0x1C, 0x0C, 0xAD,
	0x3C, 0x49, 0xE8, 0x11, 0x31, 0xB1, 0x30, 0xF1, 0x7A, 0x30, 0x88, 0x07,
	0xF2, 0x2F, 0x86, 0x82, 0x28, 0x10, 0xC0, 0xFF, 0x11, 0xFA, 0x33, 0xF2,
	0x23, 0x7F, 0xE8, 0x1E, 0xF0, 0xF0, 0x34, 0x90, 0xFF, 0xD1, 0xFA, 0xEE,
	0x4B, 0xEE, 0xE0, 0x08, 0x00, 0x0C, 0xBA, 0x0C, 0x0B, 0x0C, 0x1C, 0x0C,
	0xBD, 0x41, 0xBB, 0x30, 0x3C, 0x46, 0xF2, 0x23, 0x7F, 0x88, 0x07, 0xE8,
	0x11, 0x82, 0x28, 0x10, 0x98, 0x1E, 0xF0, 0x54, 0x34, 0x60, 0x55, 0xD1,
	0xE8, 0x2E, 0xF0, 0xF0, 0x34, 0x60, 0xFF, 0xD1, 0x5A, 0xEE, 0xFA, 0x99,
	0x98, 0x19, 0x4B, 0xEE, 0x1B, 0x99, 0x92, 0x64, 0x7E, 0xE0, 0x08, 0x00,
	0x0C, 0xCA, 0x0C, 0x0B, 0x0C, 0x1C, 0x0C, 0xCD, 0x3C, 0x46, 0xF2, 0x23,
	0x7F, 0x88, 0x07, 0xE8, 0x11, 0x82, 0x28, 0x10, 0x98, 0x2E, 0xF0, 0x58,
	0x34, 0x60, 0x55, 0xD1, 0xE8, 0x3E, 0xF0, 0xF4, 0x34, 0x60, 0xFF, 0xD1,
	0x5A, 0xEE, 0xFA, 0x99, 0x98, 0x19, 0x4B, 0xEE, 0x1B, 0x99, 0x92, 0x64,
	0x7F, 0xE0, 0x08, 0x00, 0x0C, 0xDA, 0x0C, 0x0B, 0x0C, 0x1C, 0x0C, 0xDD,
	0x3C, 0x46, 0xF2, 0x23, 0x7F, 0x88, 0x07, 0xE8, 0x11, 0x82, 0x28, 0x10,
	0x98, 0x3E, 0xF0, 0x5C, 0x34, 0x60, 0x55, 0xD1, 0xE8, 0x4E, 0xF0, 0xF8,
	0x34, 0x60, 0xFF, 0xD1, 0x5A, 0xEE, 0xFA, 0x99, 0x98, 0x19, 0x4B, 0xEE,
	0x1B, 0x99, 0x92, 0x64, 0x80, 0xE0, 0x08, 0x00, 0x0C, 0x2F, 0x3C, 0x4A,
	0x88, 0x11, 0x92, 0x23, 0x7F, 0x88, 0x48, 0x90, 0x9C, 0x34, 0xA0, 0x99,
	0xD1, 0x9A, 0x88, 0x88, 0x18, 0xF2, 0x62, 0xC8, 0x1B, 0x88, 0x82, 0x64,
	0x81, 0x1D, 0xF0, 0x00, 0x36, 0x61, 0x00, 0x61, 0x8E, 0x30, 0x41, 0x85,
	0x30, 0x49, 0x01, 0x41, 0x8D, 0x30, 0xF0, 0x73, 0x11, 0x52, 0xC4, 0x18,
	0x82, 0x24, 0x7F, 0x80, 0xA8, 0x23, 0x66, 0x78, 0x22, 0x66, 0x12, 0x0F,
	0xB8, 0x01, 0x65, 0xA8, 0xFE, 0xBD, 0x07, 0xA2, 0x94, 0xFE, 0x25, 0xA5,
	0xFE, 0x06, 0x05, 0x00, 0xBD, 0x06, 0x65, 0xA7, 0xFE, 0xA2, 0x94, 0xFE,
	0xBD, 0x03, 0x25, 0xA4, 0xFE, 0x06, 0x01, 0x00, 0xBD, 0x03, 0xA5, 0xA3,
	0xFE, 0x4B, 0x44, 0x57, 0x94, 0xC9, 0x1D, 0xF0, 0x36, 0x41, 0x00, 0xBD,
	0x02, 0x31, 0x7C, 0x30, 0xC1, 0x7D, 0x30, 0xA2, 0x93, 0x7A, 0xA5, 0xA7,
	0xFE, 0xA2, 0x93, 0x7C, 0xBD, 0x02, 0xC1, 0x7A, 0x30, 0xE5, 0xA6, 0xFE,
	0xA2, 0x93, 0x7E, 0xBD, 0x02, 0xC1, 0x78, 0x30, 0x25, 0xA6, 0xFE, 0xA2,
	0x93, 0x80, 0xBD, 0x02, 0xC1, 0x77, 0x30, 0xA5, 0xA5, 0xFE, 0xA2, 0x93,
	0x82, 0xF0, 0xB2, 0x11, 0xC1, 0x66, 0x30, 0xE5, 0xA4, 0xFE, 0xBD, 0x02,
	0xA2, 0x93, 0x84, 0xC1, 0x72, 0x30, 0x25, 0xA4, 0xFE, 0x1D, 0xF0, 0x00,
	0x36, 0x41, 0x00, 0x31, 0x09, 0x30, 0x0C, 0x02, 0xA2, 0x93, 0x7F, 0xBD,
	0x02, 0x65, 0x09, 0x00, 0x32, 0xC3, 0x10, 0x1B, 0x22, 0x66, 0x82, 0xEF,
	0x31, 0x03, 0x30, 0x0C, 0x02, 0xA2, 0x93, 0x7F, 0xBD, 0x02, 0xA5, 0x03,
	0x00, 0x32, 0xC3, 0x10, 0x1B, 0x22, 0x66, 0x82, 0xEF, 0x1D, 0xF0, 0x00,
	0x36, 0x41, 0x00, 0xF6, 0x83, 0x21, 0xAD, 0x02, 0x0C, 0x1B, 0xE1, 0x62,
	0x30, 0x81, 0xF4, 0x2F, 0xC0, 0xD3, 0x11, 0xC8, 0x78, 0xDA, 0xD8, 0x88,
	0x18, 0xEA, 0xDD, 0x82, 0x28, 0x2C, 0xC2, 0x2C, 0x45, 0xE0, 0x08, 0x00,
	0x0C, 0x02, 0x1D, 0xF0, 0x7C, 0xF2, 0x1D, 0xF0, 0x36, 0x41, 0x00, 0xF6,
	0x83, 0x3B, 0x41, 0xEB, 0x2F, 0xE8, 0x74, 0x82, 0x2E, 0x40, 0x0C, 0x1B,
	0xDC, 0x38, 0xA1, 0x10, 0x30, 0xBD, 0x02, 0xA0, 0xA3, 0xA0, 0xA2, 0x2A,
	0x7F, 0xA5, 0xCF, 0xFB, 0xBD, 0x0A, 0xE8, 0x74, 0xC6, 0xFF, 0xFF, 0xAD,
	0x02, 0xC2, 0x2E, 0x45, 0xF1, 0x50, 0x30, 0xC0, 0xD3, 0x11, 0x88, 0x14,
	0xDA, 0xD4, 0x82, 0x28, 0x2C, 0xFA, 0xDD, 0xE0, 0x08, 0x00, 0x0C, 0x02,
	0x1D, 0xF0, 0x7C, 0xF2, 0x1D, 0xF0, 0x00, 0x00, 0x36, 0x41, 0x00, 0xF6,
	0x83, 0x2D, 0xA1, 0x48, 0x30, 0xBD, 0x02, 0xA0, 0xA3, 0xA0, 0xA2, 0x2A,
	0x7F, 0xE5, 0xCB, 0xFB, 0xC2, 0xA0, 0xC8, 0xE1, 0x45, 0x30, 0xBD, 0x0A,
	0x81, 0xD4, 0x2F, 0xC0, 0xD3, 0x11, 0xDA, 0xD8, 0x88, 0x18, 0xAD, 0x02,
	0x82, 0x28, 0x2C, 0xEA, 0xDD, 0xE0, 0x08, 0x00, 0x0C, 0x02, 0x1D, 0xF0,
	0x7C, 0xF2, 0x1D, 0xF0, 0x36, 0x41, 0x00, 0x66, 0x03, 0x0F, 0x0C, 0x03,
	0xAD, 0x02, 0xBD, 0x03, 0x65, 0x87, 0xFE, 0x1B, 0x33, 0x66, 0x43, 0xF3,
	0x1D, 0xF0, 0x96, 0x93, 0x01, 0x66, 0x63, 0x0F, 0xAD, 0x02, 0x0C, 0xAB,
	0x25, 0x86, 0xFE, 0xAD, 0x02, 0x0C, 0xBB, 0xE5, 0x85, 0xFE, 0x1D, 0xF0,
	0xBD, 0x03, 0xAD, 0x02, 0x25, 0x85, 0xFE, 0x1D, 0xF0, 0x00, 0x00, 0x00,
	0x36, 0x41, 0x00, 0x0C, 0x88, 0xD1, 0x2E, 0x30, 0x91, 0x2F, 0x30, 0x31,
	0x2F, 0x30, 0x32, 0x62, 0x46, 0x99, 0x92, 0xD9, 0x12, 0x82, 0x52, 0x16,
	0x82, 0x52, 0x17, 0xA2, 0xD9, 0x55, 0xE2, 0xCD, 0x40, 0xB2, 0xD9, 0x43,
	0xC2, 0xC9, 0x20, 0x52, 0xC3, 0xE0, 0x62, 0xC3, 0x30, 0x42, 0xD3, 0xEE,
	0x42, 0x62, 0xDD, 0x62, 0x62, 0xBF, 0x52, 0x62, 0x15, 0xC9, 0xA2, 0xB2,
	0x62, 0x10, 0xE9, 0xC2, 0xA2, 0x62, 0x25, 0x81, 0x23, 0x30, 0x82, 0x62,
	0x18, 0xA1, 0x20, 0x30, 0xA2, 0x62, 0x11, 0xE2, 0xCA, 0x40, 0xF2, 0xCA,
	0x20, 0xB2, 0xDA, 0x11, 0xC2, 0xDA, 0x10, 0xD2, 0xCA, 0x60, 0xD2, 0x62,
	0x14, 0xC2, 0x62, 0x19, 0xB2, 0x62, 0x22, 0xF2, 0x62, 0x12, 0xE2, 0x62,
	0x13, 0x92, 0xD8, 0x01, 0x92, 0x62, 0xC0, 0xE1, 0x18, 0x30, 0xE2, 0x62,
	0x1B, 0xF2, 0xCE, 0x50, 0x32, 0xCE, 0x40, 0x52, 0xCE, 0x20, 0x62, 0xCE,
	0x10, 0x42, 0xCE, 0x30, 0x42, 0x62, 0x1F, 0x62, 0x62, 0x1C, 0x52, 0x62,
	0x1E, 0x32, 0x62, 0x20, 0xF2, 0x62, 0x21, 0xA1, 0x10, 0x30, 0xA2, 0x62,
	0x23, 0xF1, 0x0F, 0x30, 0xF2, 0x62, 0x26, 0xB2, 0xCA, 0x60, 0xC2, 0xCA,
	0x40, 0xD2, 0xCA, 0x20, 0xD2, 0x62, 0x24, 0xC2, 0x62, 0xC2, 0x32, 0xCF,
	0xE0, 0x92, 0xCF, 0x10, 0x52, 0xCF, 0x60, 0x62, 0xCF, 0x40, 0x82, 0xCF,
	0x20, 0xB2, 0x62, 0xC4, 0x42, 0xCF, 0xD0, 0x7C, 0xEB, 0x42, 0x62, 0xC5,
	0x82, 0x62, 0x28, 0x62, 0x62, 0x29, 0x52, 0x62, 0x2B, 0x92, 0x62, 0x27,
	0x32, 0x62, 0xC6, 0xC1, 0x01, 0x30, 0x0C, 0x43, 0xC2, 0x62, 0x2C, 0xA2,
	0x22, 0x3E, 0x91, 0x00, 0x30, 0x0C, 0x75, 0x3C, 0x06, 0x81, 0xFF, 0x2F,
	0x0C, 0x04, 0x42, 0x62, 0x37, 0x42, 0x62, 0xD5, 0x42, 0x52, 0x3A, 0x42,
	0x52, 0x77, 0x42, 0x52, 0x7A, 0x42, 0x52, 0x7B, 0x42, 0x62, 0xC7, 0x42,
	0x62, 0xC8, 0x89, 0x22, 0x62, 0x62, 0x38, 0x52, 0x52, 0x72, 0xD2, 0xCC,
	0x50, 0xE2, 0xCC, 0x10, 0xE2, 0x62, 0x2E, 0xD2, 0x62, 0x30, 0x92, 0x29,
	0x7F, 0xB0, 0xAA, 0x10, 0x51, 0xF4, 0x2F, 0x62, 0xA1, 0x90, 0x0C, 0xD8,
	0x82, 0x52, 0x76, 0x62, 0x52, 0x62, 0x52, 0x62, 0x3C, 0xC2, 0xAD, 0xFF,
	0x7C, 0xDB, 0x92, 0x62, 0x36, 0xD1, 0xCB, 0x2F, 0xE2, 0xA1, 0x00, 0xE2,
	0x52, 0x74, 0xD9, 0xD2, 0x0C, 0xA9, 0xB0, 0xAA, 0x10, 0x0C, 0x3F, 0xF2,
	0x52, 0x73, 0x7C, 0x7B, 0x30, 0xAA, 0x20, 0xB0, 0xAA, 0x10, 0x92, 0x52,
	0x75, 0x6C, 0xFB, 0xB0, 0xAA, 0x10, 0xB2, 0xAF, 0xDF, 0xB0, 0xAA, 0x10,
	0xB2, 0xAF, 0xBF, 0xB0, 0xAA, 0x10, 0xC0, 0xAA, 0x10, 0xB1, 0xDC, 0x2F,
	0xC1, 0xDF, 0x2F, 0xC9, 0xE2, 0xB0, 0xAA, 0x10, 0xB2, 0xAE, 0xFF, 0xB0,
	0xAA, 0x10, 0xA2, 0x62, 0x3E, 0x0C, 0x2B, 0x1C, 0x0A, 0xB2, 0x52, 0x34,
	0xA2, 0x52, 0x3B, 0x22, 0xC2, 0x28, 0x76, 0xA3, 0x07, 0x42, 0x62, 0xD4,
	0x42, 0x62, 0xD8, 0x4B, 0x22, 0x1D, 0xF0, 0x00, 0x36, 0xC1, 0x00, 0x1C,
	0x0A, 0x0C, 0x07, 0xB1, 0x6D, 0x2F, 0x61, 0x54, 0x2F, 0x9D, 0x03, 0x5C,
	0x0C, 0x3D, 0x02, 0xC9, 0xA1, 0x16, 0xA9, 0x04, 0x0C, 0x1F, 0x7C, 0x7D,
	0xC1, 0xA1, 0x2F, 0x31, 0xCE, 0x2F, 0x0B, 0x89, 0x16, 0xC8, 0x30, 0x66,
	0x29, 0x02, 0x46, 0x13, 0x02, 0x82, 0xC9, 0xFC, 0x16, 0x18, 0x37, 0xA2,
	0xC9, 0xFB, 0x16, 0x8A, 0x2F, 0xD2, 0xC9, 0xF9, 0x16, 0xCD, 0x3B, 0xA1,
	0xC7, 0x2F, 0xE2, 0xC9, 0xEA, 0x16, 0xFE, 0x3E, 0x82, 0xC9, 0xE8, 0x16,
	0xF8, 0x55, 0xB2, 0xC9, 0xE4, 0x16, 0xEB, 0x31, 0xC1, 0xC3, 0x2F, 0xC0,
	0xC9, 0xC0, 0x56, 0x4C, 0x2D, 0xF9, 0xB6, 0x1D, 0xF0, 0x00, 0x00, 0x81,
	0xC3, 0x2F, 0x51, 0xC3, 0x2F, 0xB1, 0xBF, 0x2F, 0x91, 0xC0, 0x2F, 0xC1,
	0xBD, 0x2F, 0xD1, 0xC3, 0x2F, 0xE1, 0xC1, 0x2F, 0xA8, 0x16, 0xF1, 0xBF,
	0x2F, 0xF2, 0x6A, 0x38, 0xE2, 0x6A, 0x3F, 0xD2, 0x6A, 0x34, 0xC2, 0x6A,
	0x33, 0x92, 0x6A, 0x3A, 0xB2, 0x6A, 0x41, 0x52, 0x6A, 0x39, 0x82, 0x6A,
	0x35, 0x1C, 0x05, 0x88, 0x06, 0xB1, 0xBB, 0x2F, 0x91, 0xBC, 0x2F, 0xC1,
	0xB9, 0x2F, 0xC2, 0x6A, 0x44, 0x92, 0x6A, 0x4E, 0xB2, 0x6A, 0x50, 0x82,
	0x28, 0x1D, 0xBD, 0x05, 0xA2, 0xA3, 0xA0, 0xE0, 0x08, 0x00, 0x4D, 0x0A,
	0x9D, 0x0A, 0xD2, 0xA3, 0xA0, 0x76, 0xAD, 0x04, 0x72, 0x49, 0x00, 0x1B,
	0x99, 0x49, 0x76, 0x7C, 0xFA, 0x0C, 0x0B, 0xC1, 0xB1, 0x2F, 0x88, 0x26,
	0x91, 0x3B, 0x2F, 0x49, 0x33, 0x72, 0x64, 0x40, 0x92, 0x29, 0x86, 0x88,
	0x98, 0x92, 0x64, 0x41, 0xE0, 0x08, 0x00, 0x31, 0x36, 0x2F, 0xCD, 0x04,
	0xA2, 0xC4, 0x10, 0x0C, 0x4B, 0x76, 0xAB, 0x0E, 0x52, 0x6C, 0x9F, 0x0C,
	0x8D, 0x1C, 0x8E, 0xE2, 0x6C, 0xA9, 0xD2, 0x6C, 0xB3, 0x4B, 0xCC, 0xC2,
	0xC4, 0x18, 0x92, 0xC4, 0x20, 0x0C, 0x2F, 0x3D, 0xF0, 0x76, 0xAF, 0x0E,
	0x52, 0x6C, 0x9F, 0x0C, 0x88, 0x1C, 0x8B, 0xB2, 0x6C, 0xA9, 0x82, 0x6C,
	0xB3, 0x4B, 0xCC, 0x3C, 0x8D, 0x4C, 0x0B, 0xC2, 0xA0, 0x48, 0xE2, 0xA0,
	0x02, 0x76, 0xAE, 0x0A, 0xB2, 0x6A, 0x9F, 0xC2, 0x6A, 0xA9, 0xD2, 0x6A,
	0xB3, 0x4B, 0xAA, 0x52, 0xC4, 0x28, 0xF2, 0xA0, 0x02, 0x76, 0xAF, 0x0A,
	0xB2, 0x69, 0x9F, 0xC2, 0x69, 0xA9, 0xD2, 0x69, 0xB3, 0x4B, 0x99, 0xC1,
	0x93, 0x2F, 0xF8, 0x76, 0xD8, 0x26, 0xA1, 0x93, 0x2F, 0x81, 0x93, 0x2F,
	0x98, 0x16, 0xB1, 0x90, 0x2F, 0xB2, 0x69, 0x4C, 0x82, 0x69, 0x4F, 0xA2,
	0x69, 0x4D, 0xE2, 0x2D, 0x16, 0xAD, 0x04, 0xE2, 0x6F, 0xBE, 0xC2, 0x6D,
	0x16, 0x25, 0xCF, 0xFF, 0xA1, 0x8D, 0x2F, 0x0C, 0x88, 0x76, 0xA8, 0x04,
	0x72, 0x6A, 0x7F, 0x4B, 0xAA, 0x91, 0xFC, 0x2E, 0x7C, 0xFA, 0xB2, 0xA0,
	0x0A, 0x76, 0xAB, 0x04, 0xA2, 0x69, 0x7F, 0x4B, 0x99, 0x0C, 0x1A, 0xB2,
	0xA0, 0x98, 0xC1, 0x85, 0x2F, 0x0C, 0x62, 0x00, 0x50, 0x00, 0x88, 0x16,
	0x29, 0x86, 0x82, 0x28, 0x15, 0x29, 0x04, 0xE0, 0x08, 0x00, 0x88, 0x06,
	0x0C, 0x0A, 0x82, 0x28, 0x1D, 0x0C, 0x4B, 0xE0, 0x08, 0x00, 0x0C, 0x4B,
	0x88, 0x06, 0xA0, 0xA0, 0x60, 0x98, 0xA1, 0x92, 0x66, 0xB2, 0xA2, 0x66,
	0x93, 0x82, 0x28, 0x1D, 0x0C, 0x0A, 0xE0, 0x08, 0x00, 0x88, 0x16, 0x92,
	0x26, 0x93, 0x82, 0x28, 0x46, 0xAA, 0x99, 0x92, 0x66, 0x93, 0xAD, 0x04,
	0xE0, 0x08, 0x00, 0x88, 0x06, 0x0C, 0x0A, 0x82, 0x28, 0x1D, 0x0C, 0x4B,
	0xE0, 0x08, 0x00, 0xA0, 0x90, 0x60, 0x88, 0x16, 0x92, 0x66, 0x94, 0x82,
	0x28, 0x47, 0xAD, 0x04, 0xE0, 0x08, 0x00, 0x88, 0x06, 0x0C, 0x0A, 0x82,
	0x28, 0x1D, 0x0C, 0x4B, 0xE0, 0x08, 0x00, 0x92, 0x26, 0x94, 0xAA, 0x99,
	0x92, 0x66, 0x94, 0xA2, 0x23, 0x85, 0x25, 0xAE, 0x00, 0xBD, 0x0A, 0xA2,
	0x63, 0x86, 0x66, 0x0A, 0x07, 0x72, 0x63, 0x85, 0x0C, 0x0B, 0xB2, 0x63,
	0x86, 0x88, 0x16, 0xAD, 0x04, 0x82, 0x28, 0x3D, 0xC2, 0xA0, 0x93, 0xE0,
	0x08, 0x00, 0xAD, 0x04, 0x7C, 0xFB, 0x65, 0xBF, 0xFF, 0x72, 0x66, 0x92,
	0x0C, 0x03, 0x0C, 0x0A, 0xBD, 0x03, 0x25, 0xBB, 0xFF, 0x1B, 0x33, 0x66,
	0x83, 0xF3, 0x0C, 0x03, 0x0C, 0x0A, 0xBD, 0x03, 0xA5, 0xB5, 0xFF, 0x0C,
	0x0A, 0xBD, 0x03, 0xA5, 0xB2, 0xFF, 0x1B, 0x33, 0x66, 0x83, 0xEC, 0x72,
	0x64, 0xBD, 0x72, 0x64, 0x45, 0xB2, 0xAF, 0xDF, 0xA2, 0x24, 0x3E, 0x0C,
	0x49, 0xB0, 0xAA, 0x10, 0xB2, 0xA0, 0x40, 0xB0, 0xAA, 0x20, 0xA2, 0x64,
	0x3E, 0x76, 0xA9, 0x07, 0x72, 0x65, 0xBF, 0x72, 0x65, 0xC3, 0x4B, 0x55,
	0x88, 0x16, 0x82, 0x28, 0x28, 0xA1, 0x49, 0x2F, 0xE0, 0x08, 0x00, 0x88,
	0x16, 0x3D, 0x0A, 0x82, 0x28, 0x28, 0x0C, 0x1A, 0xE0, 0x08, 0x00, 0x88,
	0x16, 0xBD, 0x0A, 0x82, 0x28, 0x26, 0xAD, 0x03, 0xE0, 0x08, 0x00, 0x88,
	0x16, 0x5D, 0x0A, 0x82, 0x28, 0x28, 0x1C, 0x4A, 0xE0, 0x08, 0x00, 0x88,
	0x16, 0x3D, 0x0A, 0x82, 0x28, 0x28, 0x0C, 0x1A, 0xE0, 0x08, 0x00, 0x88,
	0x16, 0xBD, 0x0A, 0x82, 0x28, 0x26, 0xAD, 0x03, 0xE0, 0x08, 0x00, 0x88,
	0x16, 0xBD, 0x0A, 0x82, 0x28, 0x25, 0xAD, 0x05, 0xE0, 0x08, 0x00, 0x88,
	0x16, 0x5D, 0x0A, 0x82, 0x28, 0x28, 0x1C, 0x9A, 0xE0, 0x08, 0x00, 0x88,
	0x16, 0x3D, 0x0A, 0x82, 0x28, 0x28, 0xA2, 0xA0, 0x80, 0xE0, 0x08, 0x00,
	0x88, 0x16, 0xBD, 0x0A, 0x82, 0x28, 0x26, 0xAD, 0x03, 0xE0, 0x08, 0x00,
	0x88, 0x16, 0xBD, 0x0A, 0x82, 0x28, 0x25, 0xAD, 0x05, 0xE0, 0x08, 0x00,
	0xA2, 0x64, 0xD6, 0x65, 0xA4, 0xFF, 0x0C, 0x8A, 0x0C, 0x0B, 0x0C, 0x4C,
	0x88, 0x06, 0xD2, 0xA5, 0x00, 0x82, 0x28, 0x10, 0xE1, 0x26, 0x2F, 0xE0,
	0x08, 0x00, 0x0C, 0x8A, 0x0C, 0x0B, 0x0C, 0x4C, 0x88, 0x06, 0xD2, 0xA4,
	0x00, 0x82, 0x28, 0x10, 0xE1, 0x22, 0x2F, 0xE0, 0x08, 0x00, 0x1D, 0xF0,
	0x1C, 0x9B, 0x40, 0x90, 0x74, 0xB7, 0x99, 0xF5, 0x40, 0x64, 0x00, 0x79,
	0xB6, 0x0C, 0x29, 0xF2, 0x63, 0x2E, 0xE8, 0x76, 0xF2, 0x63, 0x2F, 0x38,
	0x3E, 0x92, 0x6E, 0xC8, 0xC0, 0x83, 0xC0, 0x56, 0xB8, 0x2E, 0xA2, 0x2E,
	0x3E, 0x0C, 0x8B, 0xB2, 0x6E, 0x37, 0xD0, 0x9A, 0x10, 0xA0, 0xA9, 0x04,
	0xD0, 0xAA, 0x11, 0xA0, 0x99, 0x20, 0x92, 0x6E, 0x3E, 0xD2, 0x2E, 0x3F,
	0xC6, 0xBF, 0x00, 0x3D, 0x07, 0x4D, 0x0A, 0xF8, 0x06, 0xF2, 0x2F, 0x10,
	0x37, 0x55, 0x0F, 0x1C, 0x7A, 0x0C, 0x0B, 0x0C, 0x4C, 0x0C, 0x3D, 0xED,
	0x04, 0xE0, 0x0F, 0x00, 0x06, 0x03, 0x00, 0x1C, 0x7A, 0x0C, 0x0B, 0x0C,
	0x4C, 0x0C, 0x4D, 0xED, 0x04, 0xE0, 0x0F, 0x00, 0x4B, 0x44, 0x1B, 0x33,
	0x66, 0x73, 0xD3, 0x1D, 0xF0, 0xA1, 0x71, 0x2E, 0xA7, 0xA4, 0x02, 0x46,
	0x92, 0x00, 0x47, 0xAA, 0x02, 0x86, 0x09, 0x01, 0xE8, 0x76, 0x92, 0x2E,
	0x40, 0x16, 0x79, 0x58, 0xB6, 0x49, 0x02, 0xC6, 0xDB, 0xFF, 0x16, 0xC9,
	0xF6, 0x50, 0x84, 0x35, 0xCC, 0x78, 0xF2, 0x6E, 0x42, 0x50, 0xA0, 0xF4,
	0xA2, 0x6E, 0x41, 0x50, 0xB0, 0x35, 0x8C, 0x7B, 0xF2, 0x6E, 0x43, 0x50,
	0xC8, 0x75, 0xC2, 0x6E, 0x44, 0x66, 0x39, 0x12, 0x0C, 0x03, 0xA2, 0xAF,
	0xBF, 0xBD, 0x03, 0x25, 0x99, 0xFF, 0x0C, 0x1F, 0x1B, 0x33, 0x66, 0x83,
	0xF0, 0xE8, 0x76, 0xF2, 0x6E, 0x40, 0x1D, 0xF0, 0xB2, 0xC4, 0xF6, 0xB6,
	0x4B, 0x02, 0x06, 0xCB, 0xFF, 0xE8, 0x76, 0xD2, 0x2E, 0x46, 0xD8, 0x1D,
	0xB9, 0x51, 0x47, 0x9D, 0x06, 0xAD, 0x0E, 0x25, 0x62, 0xFF, 0xE8, 0x76,
	0x92, 0x2E, 0x40, 0x26, 0x19, 0x69, 0xE2, 0xC9, 0xFD, 0x56, 0xAE, 0x0C,
	0xA1, 0xE5, 0x2E, 0x25, 0x5E, 0xFF, 0x16, 0x1A, 0x0C, 0xF8, 0x76, 0x72,
	0x6F, 0x40, 0xA5, 0x91, 0xFF, 0x86, 0x2D, 0x00, 0x92, 0x23, 0x2F, 0x4D,
	0x0A, 0xA6, 0x19, 0x1C, 0xA1, 0xDF, 0x2E, 0xB1, 0x9C, 0x2E, 0x0B, 0xC9,
	0xC2, 0x63, 0x2F, 0x82, 0x9B, 0x4E, 0xB2, 0x9B, 0x4F, 0x82, 0xC8, 0xF0,
	0x82, 0x5A, 0x73, 0xB2, 0xCB, 0xF0, 0xB2, 0x5A, 0x74, 0x65, 0xA9, 0xFE,
	0xAD, 0x04, 0xA5, 0xA4, 0xFE, 0xA8, 0x76, 0x65, 0x63, 0xFE, 0xA8, 0x76,
	0x65, 0x5A, 0xFE, 0x88, 0x16, 0x82, 0x28, 0x4E, 0xA8, 0x76, 0xE0, 0x08,
	0x00, 0x88, 0x16, 0x82, 0x28, 0x4B, 0xA8, 0x76, 0xE0, 0x08, 0x00, 0x72,
	0x66, 0x95, 0x1D, 0xF0, 0xA1, 0xCC, 0x2E, 0xA9, 0x61, 0xA5, 0x57, 0xFF,
	0xCC, 0x6A, 0xA8, 0x76, 0xA2, 0x2A, 0xC7, 0x16, 0x4A, 0x05, 0xB1, 0xC9,
	0x2E, 0xC8, 0x61, 0xC9, 0x91, 0xB9, 0x71, 0xA2, 0xAF, 0xA6, 0x0C, 0x0B,
	0x88, 0x16, 0x0C, 0x0C, 0x82, 0x28, 0x2C, 0xD8, 0x91, 0xE0, 0x08, 0x00,
	0x98, 0x91, 0xA8, 0x71, 0x92, 0xC9, 0x10, 0x99, 0x91, 0xA7, 0x99, 0xE2,
	0xE8, 0x76, 0xB2, 0x2E, 0x43, 0x9C, 0x1B, 0xB2, 0x2E, 0x44, 0x88, 0x06,
	0x1C, 0xFA, 0x88, 0xF8, 0x0C, 0x0C, 0xE0, 0x08, 0x00, 0xE8, 0x76, 0x72,
	0x6E, 0x43, 0xC2, 0x2E, 0x41, 0x88, 0x06, 0x0C, 0x1A, 0x88, 0xF8, 0x1C,
	0x9B, 0xE0, 0x08, 0x00, 0xA8, 0x76, 0x0C, 0x29, 0x92, 0x6A, 0x40, 0xB8,
	0xB6, 0x56, 0xDB, 0xE3, 0x88, 0x16, 0x82, 0x28, 0x36, 0xA8, 0x76, 0xE0,
	0x08, 0x00, 0xE8, 0x76, 0x92, 0x2E, 0x3E, 0x90, 0x97, 0x04, 0x16, 0xB9,
	0x48, 0xB2, 0x1E, 0x16, 0x0C, 0x07, 0xA6, 0x1B, 0x44, 0x0C, 0x04, 0xA2,
	0x2E, 0x23, 0x4A, 0xAA, 0xA8, 0x0A, 0xA2, 0xCA, 0xF4, 0xB6, 0x2A, 0x2E,
	0xA8, 0x9E, 0xAA, 0xA4, 0xA8, 0x0A, 0xAC, 0x5A, 0x88, 0x06, 0x88, 0x98,
	0xE0, 0x08, 0x00, 0x5D, 0x0A, 0x0C, 0x03, 0xA6, 0x1A, 0x13, 0xA8, 0x76,
	0x88, 0x06, 0xA8, 0x9A, 0x88, 0x78, 0x4A, 0xAA, 0xA8, 0x0A, 0xE0, 0x08,
	0x00, 0x1B, 0x33, 0x57, 0x93, 0xEB, 0xE8, 0x76, 0xB2, 0x1E, 0x16, 0x4B,
	0x44, 0x1B, 0x77, 0xB7, 0x27, 0xBC, 0xB2, 0x1E, 0x17, 0x0C, 0x07, 0xE6,
	0x1B, 0x02, 0x06, 0x74, 0xFF, 0x0C, 0x04, 0xC2, 0x2E, 0x24, 0x4A, 0xCC,
	0xC8, 0x0C, 0xC2, 0xCC, 0xF4, 0xB6, 0x2C, 0x34, 0xA8, 0xAE, 0xAA, 0xA4,
	0xA8, 0x0A, 0xAC, 0xBA, 0x88, 0x06, 0x88, 0x98, 0xE0, 0x08, 0x00, 0x0C,
	0x03, 0x52, 0xA0, 0xFF, 0xA0, 0x55, 0xC0, 0xA6, 0x15, 0x15, 0x0C, 0x0B,
	0xA8, 0x76, 0x88, 0x06, 0xA8, 0xAA, 0x88, 0x68, 0x4A, 0xAA, 0xA8, 0x0A,
	0xE0, 0x08, 0x00, 0x1B, 0x33, 0x57, 0x93, 0xE9, 0xE8, 0x76, 0xB2, 0x1E,
	0x17, 0x4B, 0x44, 0x1B, 0x77, 0xB7, 0x27, 0xB6, 0x1D, 0xF0, 0x40, 0xB0,
	0x74, 0xB2, 0xCB, 0xE7, 0x56, 0xAB, 0xD7, 0x92, 0x06, 0x40, 0x90, 0xD4,
	0x04, 0x16, 0xED, 0x23, 0xA2, 0xC6, 0x40, 0xB2, 0x26, 0x90, 0x82, 0x23,
	0x2D, 0x0B, 0x3B, 0xB2, 0xCB, 0xFE, 0xE0, 0x08, 0x00, 0xB1, 0x7C, 0x2E,
	0xBA, 0xB3, 0xD2, 0x0B, 0xBF, 0xA0, 0xE0, 0x74, 0xE7, 0x9D, 0x0B, 0xD2,
	0x0B, 0xC0, 0xA0, 0xE8, 0x21, 0xE0, 0xDD, 0xC0, 0x16, 0x5D, 0x20, 0x0C,
	0x9F, 0x82, 0xA0, 0xFF, 0x82, 0x46, 0x40, 0xF9, 0x01, 0x86, 0x7E, 0x00,
	0xA2, 0xA5, 0x00, 0xA7, 0x24, 0x19, 0x47, 0xAA, 0x02, 0x06, 0xAC, 0x00,
	0x50, 0x90, 0x31, 0xB1, 0xDA, 0x2D, 0x50, 0xA0, 0xF4, 0xB0, 0xAA, 0xA0,
	0x92, 0x6A, 0x7F, 0xA5, 0x73, 0xFF, 0x1D, 0xF0, 0xA2, 0xA4, 0x00, 0xB2,
	0xA3, 0x00, 0xB7, 0xA4, 0x02, 0x46, 0x7A, 0x00, 0x47, 0xAB, 0x02, 0x46,
	0x97, 0x00, 0x6C, 0xFD, 0x50, 0xA0, 0x04, 0xE8, 0x76, 0xC0, 0xAA, 0x11,
	0x92, 0x2E, 0x3E, 0xD0, 0xB9, 0x10, 0xA0, 0xBB, 0x20, 0xB2, 0x6E, 0x3E,
	0x1D, 0xF0, 0x81, 0x19, 0x2E, 0x87, 0x93, 0x0D, 0xA2, 0x6E, 0x37, 0x92,
	0x2E, 0x3E, 0xBD, 0x0A, 0xD0, 0x99, 0x10, 0xC6, 0x44, 0xFF, 0xC9, 0x3E,
	0xA2, 0x2E, 0x3E, 0x0C, 0x88, 0xD8, 0xA1, 0xD2, 0x6E, 0x3F, 0x82, 0x6E,
	0x37, 0xBD, 0x08, 0x80, 0xAA, 0x20, 0x82, 0xA2, 0x00, 0x80, 0xAA, 0x20,
	0xA2, 0x6E, 0x3E, 0x92, 0x2E, 0x36, 0x66, 0xB9, 0x14, 0x66, 0x8B, 0x11,
	0xAD, 0x0E, 0x88, 0x16, 0xF0, 0xCD, 0x11, 0x82, 0x28, 0x42, 0x5C, 0x0B,
	0xE0, 0x08, 0x00, 0x46, 0x03, 0x00, 0xAD, 0x0E, 0x88, 0x16, 0xCD, 0x0D,
	0x82, 0x28, 0x42, 0x5C, 0x0B, 0xE0, 0x08, 0x00, 0xE8, 0x76, 0x92, 0x2E,
	0x3E, 0x07, 0x69, 0x0C, 0xB2, 0x2E, 0x36, 0x2C, 0xCA, 0xA7, 0x1B, 0x0C,
	0x3C, 0x0C, 0xC7, 0x1B, 0x07, 0x72, 0x5E, 0x7A, 0x79, 0xA1, 0x86, 0x02,
	0x00, 0xF2, 0x2E, 0x37, 0x66, 0xBF, 0xF1, 0x88, 0xA1, 0x82, 0x5E, 0x7A,
	0xAD, 0x0E, 0x50, 0xB0, 0xF4, 0xC2, 0xA0, 0x93, 0x88, 0x16, 0x98, 0xA1,
	0x82, 0x28, 0x3D, 0x92, 0x5E, 0x7B, 0xE0, 0x08, 0x00, 0x3D, 0x0A, 0x7C,
	0xFB, 0xA8, 0x76, 0xA5, 0x74, 0xFF, 0xB8, 0x76, 0xA2, 0x2B, 0x3E, 0xB2,
	0x2B, 0x3F, 0xA0, 0xA3, 0x04, 0xF0, 0xBB, 0x11, 0x25, 0x5C, 0xFF, 0xC1,
	0x35, 0x2E, 0x8C, 0x73, 0x3D, 0x0C, 0xD8, 0x03, 0x8C, 0x1D, 0x66, 0x05,
	0x05, 0xA5, 0x64, 0xFF, 0x31, 0x31, 0x2E, 0xA8, 0x76, 0x72, 0x6A, 0xBD,
	0xA5, 0x44, 0xFF, 0xA8, 0x06, 0x0C, 0xAB, 0x0C, 0x7C, 0x0C, 0x1E, 0xE9,
	0x03, 0x65, 0x3F, 0xFF, 0xA8, 0x06, 0x0C, 0xBB, 0x0C, 0x7C, 0xE5, 0x3E,
	0xFF, 0xA8, 0x06, 0x0C, 0xCB, 0x0C, 0x7C, 0x65, 0x3E, 0xFF, 0xA8, 0x06,
	0x0C, 0xDB, 0x0C, 0x7C, 0xA5, 0x3D, 0xFF, 0xA8, 0x06, 0x0C, 0x0B, 0x1C,
	0x5C, 0x25, 0x3D, 0xFF, 0xA8, 0x06, 0x0C, 0x0B, 0x1C, 0x6C, 0xA5, 0x3C,
	0xFF, 0xE8, 0x76, 0xF2, 0x2E, 0x40, 0x49, 0xE1, 0x66, 0x2F, 0x2E, 0x41,
	0x19, 0x2E, 0x0C, 0x03, 0xA2, 0xAF, 0xBF, 0x0C, 0x0B, 0x88, 0x16, 0x0C,
	0x0C, 0x82, 0x28, 0x2C, 0xDD, 0x04, 0xE0, 0x08, 0x00, 0x0C, 0x0A, 0xBD,
	0x03, 0xE5, 0x60, 0xFF, 0x42, 0xC4, 0x10, 0x1B, 0x33, 0x66, 0x83, 0xDF,
	0xE8, 0x76, 0x0C, 0x39, 0x72, 0x6E, 0x42, 0x92, 0x6E, 0x40, 0xA2, 0x2E,
	0x46, 0x48, 0xE1, 0xA8, 0x3A, 0x0C, 0x1B, 0xA0, 0xAB, 0x93, 0xA9, 0x56,
	0x16, 0x2A, 0x0E, 0x88, 0x26, 0x88, 0xA8, 0xA8, 0xA6, 0xE0, 0x08, 0x00,
	0x88, 0x26, 0xA8, 0xA6, 0x88, 0xC8, 0x7C, 0xFB, 0xE0, 0x08, 0x00, 0x31,
	0xC5, 0x2D, 0xA1, 0xC5, 0x2D, 0x0C, 0x0B, 0xC2, 0xA6, 0x40, 0x65, 0x95,
	0x01, 0xAD, 0x03, 0x0C, 0x0B, 0xC2, 0xA6, 0x40, 0xA5, 0x94, 0x01, 0xE8,
	0x76, 0x0C, 0x1A, 0xB2, 0x2E, 0x37, 0x0C, 0x09, 0xB2, 0xCB, 0xF8, 0xB0,
	0x9A, 0x83, 0x99, 0x96, 0x72, 0x6E, 0xC7, 0x40, 0xE6, 0x13, 0x20, 0x20,
	0x00, 0x1D, 0xF0, 0xA1, 0x62, 0x2D, 0xA7, 0xA4, 0x02, 0xC6, 0x38, 0x00,
	0x47, 0xAA, 0x02, 0x06, 0x3F, 0x00, 0x92, 0x23, 0x2C, 0x99, 0x05, 0x1D,
	0xF0, 0xA9, 0x01, 0xC2, 0x26, 0x90, 0x92, 0x06, 0x40, 0xC2, 0xCC, 0xFE,
	0xC2, 0x66, 0x90, 0x90, 0xA0, 0x24, 0xBC, 0xEA, 0x0B, 0xDA, 0x16, 0xDD,
	0x17, 0x38, 0x01, 0x06, 0x16, 0x00, 0xE2, 0xD4, 0xFE, 0x56, 0xDE, 0xB1,
	0xE8, 0x76, 0xF2, 0xAD, 0xFF, 0x92, 0x2E, 0x3E, 0x50, 0xB0, 0x04, 0xF0,
	0x99, 0x10, 0x70, 0xFB, 0x11, 0xF0, 0x99, 0x20, 0xF8, 0x3E, 0x92, 0x6E,
	0x3E, 0xC0, 0xFF, 0xC0, 0x56, 0xEF, 0xAF, 0xD0, 0xCB, 0x11, 0xD0, 0x89,
	0x10, 0xC0, 0x88, 0x20, 0xA0, 0x88, 0x20, 0x82, 0x6E, 0x3E, 0x1D, 0xF0,
	0x7C, 0xFA, 0xB1, 0xE1, 0x2D, 0x4B, 0xC1, 0xA5, 0xFE, 0xFD, 0xD8, 0x11,
	0x3D, 0x0A, 0x9C, 0x1D, 0xA8, 0x76, 0xC2, 0xA0, 0x93, 0x88, 0x16, 0xB1,
	0x58, 0x2D, 0x82, 0x28, 0x3D, 0xB2, 0x2B, 0x85, 0xE0, 0x08, 0x00, 0xCD,
	0x03, 0x88, 0x06, 0x1C, 0x8A, 0x88, 0xF8, 0x0C, 0x7B, 0xE0, 0x08, 0x00,
	0x1D, 0xF0, 0x9D, 0x07, 0x86, 0xD4, 0xFF, 0xA8, 0x76, 0xA2, 0x2A, 0x3F,
	0xF0, 0xAA, 0x11, 0xE5, 0x47, 0xFF, 0x1D, 0xF0, 0xB2, 0xD4, 0xFC, 0x56,
	0x3B, 0xAA, 0xC0, 0xE5, 0xC0, 0x16, 0xDE, 0x1D, 0xF1, 0x85, 0x2D, 0xF0,
	0xF5, 0xC0, 0x16, 0x4F, 0x1D, 0xE8, 0x76, 0x38, 0x3E, 0x92, 0x2E, 0x3E,
	0x81, 0x81, 0x2D, 0x80, 0x83, 0xC0, 0x56, 0x78, 0x08, 0xD0, 0xA9, 0x10,
	0xA2, 0x6E, 0x3E, 0x1D, 0xF0, 0xA1, 0xC6, 0x2D, 0xA7, 0x24, 0x1D, 0x47,
	0xAA, 0x02, 0x06, 0x2E, 0x00, 0xAD, 0x05, 0x65, 0xF3, 0xFD, 0x1D, 0xF0,
	0xA1, 0x28, 0x2D, 0xA7, 0x24, 0x2E, 0x47, 0x2A, 0x38, 0x98, 0x76, 0x92,
	0x29, 0x45, 0xC6, 0xC4, 0xFF, 0xA2, 0xD4, 0xF9, 0x56, 0x2A, 0xA5, 0x52,
	0x66, 0x90, 0x72, 0x66, 0x91, 0x1D, 0xF0, 0xA1, 0xBB, 0x2D, 0xA7, 0x24,
	0x2A, 0x47, 0xAA, 0x02, 0x86, 0x8F, 0xFE, 0xA8, 0x76, 0x72, 0x6A, 0xBD,
	0xE5, 0x25, 0xFF, 0x1D, 0xF0, 0xB2, 0xD4, 0xF4, 0x56, 0xEB, 0xA2, 0xC8,
	0x76, 0x52, 0x6C, 0x45, 0x1D, 0xF0, 0xD2, 0xD4, 0xF2, 0x56, 0x1D, 0xA2,
	0x98, 0x76, 0x92, 0x29, 0x40, 0x06, 0xB5, 0xFF, 0xA2, 0xD4, 0xF0, 0x56,
	0x3A, 0xA1, 0x52, 0x63, 0x2C, 0x0C, 0x1A, 0x1C, 0x9B, 0x7C, 0xFC, 0x88,
	0x06, 0x98, 0x76, 0x88, 0xF8, 0x52, 0x69, 0x36, 0xE0, 0x08, 0x00, 0x1D,
	0xF0, 0x90, 0xA4, 0x04, 0x56, 0x6A, 0x9F, 0x90, 0xA9, 0x04, 0xD0, 0xAA,
	0x11, 0x86, 0x3C, 0xFF, 0x50, 0x84, 0x35, 0x50, 0xD0, 0xF4, 0xF2, 0x6E,
	0x40, 0xF2, 0x6E, 0x42, 0xCD, 0x0B, 0xC2, 0x2C, 0x86, 0x50, 0xB0, 0x35,
	0x80, 0xCD, 0x83, 0xC2, 0x6E, 0x41, 0x8C, 0x7B, 0xF2, 0x6E, 0x43, 0x50,
	0xD8, 0x75, 0xD2, 0x6E, 0x44, 0x0C, 0x03, 0xA2, 0xAF, 0xBF, 0xBD, 0x03,
	0xA5, 0x40, 0xFF, 0x1B, 0x33, 0x66, 0x83, 0xF2, 0x1D, 0xF0, 0xE2, 0xD4,
	0xF7, 0x56, 0x1E, 0x9B, 0xF8, 0x76, 0x52, 0x6F, 0x3F, 0x1D, 0xF0, 0x32,
	0xA0, 0xEF, 0x30, 0x39, 0x10, 0x32, 0x46, 0x40, 0x0C, 0x03, 0x46, 0xB4,
	0xFF, 0x88, 0x16, 0xAD, 0x0E, 0x82, 0x28, 0x39, 0xBD, 0x04, 0xE0, 0x08,
	0x00, 0xEC, 0x9A, 0x88, 0x16, 0xA8, 0x76, 0x82, 0x28, 0x38, 0xBD, 0x04,
	0xE0, 0x08, 0x00, 0xDC, 0xBA, 0x88, 0x16, 0x82, 0x28, 0x45, 0xA8, 0x76,
	0xE0, 0x08, 0x00, 0x47, 0x1A, 0x0F, 0xA8, 0x76, 0x88, 0x16, 0xBD, 0x04,
	0x82, 0x28, 0x3A, 0x7C, 0xFC, 0xE0, 0x08, 0x00, 0x1D, 0xF0, 0xB1, 0x82,
	0x2D, 0xE8, 0x76, 0xE0, 0xA4, 0x11, 0xA9, 0x81, 0x92, 0x2E, 0xC8, 0xBA,
	0xAA, 0x52, 0x6A, 0x7F, 0xAC, 0x09, 0x88, 0x16, 0xAD, 0x0E, 0x82, 0x28,
	0x38, 0xBD, 0x04, 0xE0, 0x08, 0x00, 0xE8, 0x76, 0xDC, 0x0A, 0x88, 0x16,
	0x82, 0x28, 0x45, 0xAD, 0x0E, 0xE0, 0x08, 0x00, 0xE8, 0x76, 0x40, 0x9A,
	0xC0, 0x56, 0xB9, 0x2D, 0xCD, 0x05, 0x88, 0x16, 0xAD, 0x0E, 0x82, 0x28,
	0x49, 0xBD, 0x04, 0xE0, 0x08, 0x00, 0x96, 0xCA, 0x91, 0xE8, 0x76, 0x88,
	0x16, 0xA2, 0x2E, 0xD7, 0x82, 0x28, 0x28, 0x1B, 0xAA, 0xE0, 0x08, 0x00,
	0xBD, 0x0A, 0x88, 0x16, 0xA8, 0x76, 0x82, 0x28, 0x25, 0xA2, 0x2A, 0xD6,
	0xE0, 0x08, 0x00, 0xC8, 0x81, 0xB8, 0x76, 0x88, 0x16, 0xB2, 0x2B, 0x25,
	0x82, 0x28, 0x26, 0xCA, 0xBB, 0xB2, 0xDB, 0xFF, 0xB2, 0x2B, 0x36, 0xE0,
	0x08, 0x00, 0x88, 0x16, 0x82, 0x28, 0x29, 0xE0, 0x08, 0x00, 0x91, 0x63,
	0x2D, 0xE8, 0x76, 0xB1, 0x61, 0x2D, 0xC8, 0x81, 0xBA, 0xBA, 0xEA, 0xCC,
	0xB7, 0xB9, 0x02, 0x06, 0x8A, 0x00, 0xD1, 0x12, 0x2D, 0x91, 0x11, 0x2D,
	0x92, 0x6C, 0xBF, 0xC6, 0x06, 0x00, 0xE8, 0x76, 0x38, 0x3E, 0x50, 0xF3,
	0xC0, 0x56, 0x6F, 0x22, 0x92, 0x2E, 0x3E, 0xA2, 0xAB, 0xFF, 0xA0, 0x99,
	0x10, 0x92, 0x6E, 0x3E, 0x06, 0x86, 0xFF, 0xD2, 0x2C, 0xBF, 0x66, 0xB4,
	0x0B, 0xD2, 0x6E, 0xD3, 0xB2, 0x2C, 0xBF, 0xB2, 0x6E, 0xD4, 0xD2, 0x2C,
	0xBF, 0xF2, 0x2C, 0xC3, 0xD7, 0x9F, 0x08, 0x92, 0x2E, 0xD5, 0x82, 0x2E,
	0x37, 0x97, 0x18, 0x11, 0xD2, 0x6C, 0xC3, 0xB8, 0x51, 0xA2, 0x2E, 0x37,
	0xA2, 0x6E, 0xD5, 0xAD, 0x0E, 0xE5, 0x36, 0xFF, 0xE8, 0x76, 0x88, 0x16,
	0x82, 0x28, 0x4A, 0xAD, 0x0E, 0xE0, 0x08, 0x00, 0x88, 0x16, 0x82, 0x28,
	0x4B, 0xA8, 0x76, 0xE0, 0x08, 0x00, 0xA8, 0x76, 0x8B, 0xB1, 0xCB, 0xC1,
	0xD2, 0xC1, 0x10, 0x65, 0xC0, 0xFE, 0xE8, 0x76, 0x92, 0x2E, 0xC8, 0xA2,
	0x6E, 0xC7, 0xA6, 0x19, 0x16, 0x88, 0x16, 0x82, 0x28, 0x45, 0xAD, 0x0E,
	0xE0, 0x08, 0x00, 0x47, 0x9A, 0x09, 0xA8, 0x76, 0x92, 0x2A, 0xC8, 0x0B,
	0x99, 0x92, 0x6A, 0xC8, 0xA8, 0x21, 0x16, 0xFA, 0x0A, 0xB2, 0x23, 0x2E,
	0xA6, 0x1B, 0x33, 0x0B, 0xBB, 0xB2, 0x63, 0x2E, 0x65, 0xB3, 0xFE, 0xD1,
	0x2A, 0x2D, 0xE8, 0x76, 0x82, 0xA0, 0xB0, 0xC2, 0x2E, 0x3F, 0xF2, 0x2E,
	0x34, 0x82, 0x5D, 0x70, 0x82, 0x5D, 0x80, 0xF2, 0x5D, 0x6D, 0xF2, 0x5D,
	0x7D, 0xF2, 0x5D, 0x6E, 0xF2, 0x5D, 0x7E, 0xC2, 0xCC, 0x10, 0xC2, 0x5D,
	0x6F, 0xC2, 0x5D, 0x7F, 0x46, 0x00, 0x00, 0xE8, 0x76, 0x92, 0x2E, 0x46,
	0x98, 0x39, 0x9C, 0xF9, 0x41, 0xDD, 0x2C, 0xE2, 0x2E, 0x11, 0xD2, 0x23,
	0xCD, 0xE2, 0x9E, 0x03, 0xC2, 0xA0, 0xA0, 0xC7, 0xAE, 0x02, 0x86, 0x54,
	0x00, 0xBD, 0x0D, 0xAD, 0x04, 0xA5, 0x38, 0x00, 0xE8, 0x76, 0x72, 0x6E,
	0xDC, 0x88, 0x16, 0x82, 0x28, 0x34, 0xAD, 0x0E, 0xE0, 0x08, 0x00, 0xA8,
	0x76, 0xA5, 0xA2, 0xFE, 0xE8, 0x76, 0x92, 0x2E, 0xC7, 0xEC, 0x09, 0x1C,
	0x5A, 0x88, 0x06, 0x0C, 0x0B, 0x88, 0xF8, 0x0C, 0x0C, 0xE0, 0x08, 0x00,
	0x88, 0x16, 0x82, 0x28, 0x50, 0xA8, 0x76, 0xE0, 0x08, 0x00, 0x0C, 0x19,
	0x92, 0x66, 0x95, 0x86, 0x05, 0x00, 0x00, 0x00, 0x00, 0x88, 0x16, 0x82,
	0x28, 0x50, 0xAD, 0x0E, 0xE0, 0x08, 0x00, 0x88, 0x16, 0x82, 0x28, 0x4E,
	0xA8, 0x76, 0xE0, 0x08, 0x00, 0x98, 0x31, 0xCC, 0x19, 0x46, 0xDD, 0xFD,
	0x41, 0x90, 0x2C, 0x51, 0xFF, 0x2C, 0x72, 0xC4, 0xE0, 0xB2, 0x23, 0x2E,
	0xA6, 0x1B, 0x07, 0x0B, 0xAB, 0xA2, 0x63, 0x2E, 0x65, 0xA7, 0xFE, 0xA8,
	0x76, 0xB2, 0xC1, 0x10, 0xA5, 0x76, 0xFE, 0xF2, 0x23, 0xD2, 0xE8, 0x76,
	0xA2, 0x23, 0xCE, 0xB2, 0x2E, 0x3E, 0xA9, 0xD1, 0x47, 0xEB, 0x0D, 0xCD,
	0x0F, 0xB2, 0x23, 0xCF, 0xD2, 0x23, 0xD3, 0x25, 0x73, 0xFE, 0xC6, 0x05,
	0x00, 0xAD, 0x0F, 0xB8, 0xD1, 0xC2, 0x2E, 0x32, 0xA5, 0x2E, 0x00, 0xA2,
	0x23, 0xD3, 0xC8, 0x76, 0xB2, 0x23, 0xCF, 0xC2, 0x2C, 0x32, 0xE5, 0x2D,
	0x00, 0xB2, 0xC1, 0x10, 0xF2, 0x95, 0x72, 0xE2, 0x95, 0x91, 0xD2, 0x95,
	0x92, 0x98, 0x76, 0x82, 0x95, 0x71, 0xAD, 0x09, 0x92, 0x29, 0x32, 0x99,
	0x41, 0x9A, 0x88, 0x90, 0xDD, 0xC0, 0x90, 0xEE, 0xC0, 0x9A, 0xFF, 0xF2,
	0x55, 0x72, 0xE2, 0x55, 0x91, 0xD2, 0x55, 0x92, 0x82, 0x55, 0x71, 0x25,
	0x49, 0xFE, 0xA8, 0x76, 0xB8, 0x41, 0xE5, 0x36, 0xFE, 0xA8, 0x76, 0x0C,
	0x09, 0x99, 0x31, 0xA2, 0x2A, 0x36, 0xBD, 0x04, 0x66, 0x8A, 0x30, 0xAD,
	0x07, 0xC2, 0x2A, 0x7F, 0xC2, 0xCC, 0xFC, 0xF6, 0x2C, 0x1C, 0xB9, 0xB1,
	0xD2, 0x2B, 0x7F, 0xA9, 0xC1, 0xD2, 0xCD, 0xF8, 0xF6, 0x2D, 0x0F, 0xA8,
	0x76, 0x8B, 0xB1, 0xCB, 0xC1, 0xD2, 0xC1, 0x10, 0x65, 0xA6, 0xFE, 0xB8,
	0xB1, 0xA8, 0xC1, 0x4B, 0xBB, 0x4B, 0xAA, 0x47, 0x9A, 0xD2, 0x98, 0x31,
	0x56, 0x99, 0xF3, 0x1D, 0xF0, 0x00, 0x00, 0x81, 0xD5, 0x2C, 0xF1, 0xD5,
	0x2C, 0x8A, 0x8A, 0x87, 0x3F, 0x2E, 0x91, 0x83, 0x2C, 0xD1, 0x82, 0x2C,
	0x06, 0x72, 0xFF, 0x59, 0x3E, 0x92, 0x2E, 0x3E, 0x3D, 0x05, 0xA0, 0x99,
	0x20, 0x06, 0x75, 0xFF, 0xAD, 0x0D, 0xE0, 0xCE, 0x11, 0x0C, 0x0B, 0x25,
	0x45, 0x01, 0xAD, 0x04, 0x0C, 0x0B, 0xC2, 0xA6, 0x40, 0x65, 0x44, 0x01,
	0x0C, 0x17, 0x86, 0xA6, 0xFF, 0xD1, 0xC8, 0x2C, 0xB2, 0xA6, 0x40, 0xDA,
	0xDA, 0xD7, 0xBB, 0x02, 0xC6, 0x6C, 0xFF, 0x91, 0x72, 0x2C, 0xD1, 0x71,
	0x2C, 0xC6, 0x62, 0xFF, 0x88, 0x81, 0xF2, 0x2E, 0x27, 0x8A, 0xFF, 0xF2,
	0xDF, 0xFF, 0x52, 0x6F, 0x36, 0x86, 0x49, 0xFF, 0x36, 0x41, 0x00, 0x61,
	0xBF, 0x2C, 0x7C, 0xF5, 0x82, 0xA0, 0x93, 0x1B, 0x55, 0x72, 0x96, 0x87,
	0x62, 0xC6, 0x10, 0x27, 0x17, 0x02, 0x87, 0x97, 0xF1, 0x20, 0x37, 0xC0,
	0x7C, 0xF2, 0x30, 0x25, 0x83, 0x1D, 0xF0, 0x00, 0x36, 0x41, 0x00, 0x21,
	0x11, 0x2C, 0xAC, 0xE3, 0x82, 0xC3, 0xFE, 0x16, 0x08, 0x0A, 0x92, 0xC3,
	0xFD, 0x16, 0x89, 0x09, 0xA2, 0xC3, 0xF4, 0x56, 0x2A, 0x09, 0x0C, 0x6A,
	0x0C, 0x0B, 0x0C, 0xDC, 0x88, 0x02, 0xD8, 0x62, 0x82, 0x28, 0x10, 0xE1,
	0xAE, 0x2C, 0xE0, 0x08, 0x00, 0x98, 0x62, 0x7C, 0xFA, 0xA0, 0x99, 0x30,
	0x99, 0x62, 0x1D, 0xF0, 0x31, 0xAB, 0x2C, 0xB2, 0x23, 0x28, 0x66, 0x0B,
	0x13, 0xA2, 0x23, 0x27, 0x65, 0xF9, 0xFF, 0xA2, 0x63, 0x28, 0x66, 0x0A,
	0x07, 0x0C, 0x0C, 0xC2, 0x63, 0x28, 0xC2, 0x63, 0x27, 0x0C, 0x1A, 0x88,
	0x02, 0x0C, 0x1B, 0x88, 0xF8, 0xC1, 0xA2, 0x2C, 0xE0, 0x08, 0x00, 0xC1,
	0x43, 0x2C, 0x0C, 0x09, 0x97, 0x1C, 0x0A, 0x88, 0x02, 0x0C, 0x1A, 0x88,
	0xF8, 0x0C, 0x7B, 0xE0, 0x08, 0x00, 0x0C, 0x1A, 0x88, 0x02, 0x1C, 0x6B,
	0x88, 0xF8, 0xC1, 0x9B, 0x2C, 0xE0, 0x08, 0x00, 0x0C, 0x1A, 0x88, 0x02,
	0x0C, 0x8B, 0x88, 0xF8, 0xC1, 0x99, 0x2C, 0xE0, 0x08, 0x00, 0x0C, 0x1A,
	0x88, 0x02, 0x0C, 0x6B, 0x88, 0xF8, 0xC1, 0x96, 0x2C, 0xE0, 0x08, 0x00,
	0x92, 0x23, 0x1E, 0xCC, 0x69, 0xB8, 0x02, 0xA1, 0x94, 0x2C, 0xA2, 0x6B,
	0x18, 0x1D, 0xF0, 0x0C, 0x1A, 0x88, 0x02, 0xB2, 0xA0, 0x80, 0x88, 0xF8,
	0xC1, 0x91, 0x2C, 0xE0, 0x08, 0x00, 0x1D, 0xF0, 0x36, 0x41, 0x00, 0x20,
	0xEA, 0x03, 0x1D, 0xF0, 0x36, 0x61, 0x00, 0x98, 0x02, 0x81, 0x31, 0x2C,
	0xCC, 0x69, 0xB1, 0x2E, 0x2C, 0x06, 0x02, 0x00, 0x00, 0x00, 0x0B, 0xA9,
	0x0C, 0x0B, 0xA0, 0xB8, 0x83, 0xA6, 0x1B, 0x7F, 0x31, 0xD9, 0x2B, 0xF8,
	0x33, 0x0C, 0x02, 0xC8, 0xCF, 0xAD, 0x0F, 0x8C, 0xFC, 0x76, 0x9C, 0x0A,
	0xD2, 0x2A, 0x10, 0xA2, 0xCA, 0x10, 0xB7, 0x1D, 0x06, 0x1B, 0x22, 0x46,
	0x00, 0x00, 0x0C, 0x02, 0xC7, 0xB2, 0x5C, 0xE2, 0x2F, 0x45, 0x27, 0x1E,
	0x52, 0x1C, 0x9A, 0x0C, 0x0B, 0x0C, 0x4C, 0xD1, 0xD0, 0x2B, 0xED, 0x01,
	0x22, 0x6F, 0x45, 0x88, 0x03, 0x0C, 0x19, 0x82, 0x28, 0x10, 0x99, 0x01,
	0xE0, 0x08, 0x00, 0xA8, 0x01, 0xF8, 0x03, 0x9C, 0x9A, 0x1C, 0x9A, 0x0C,
	0x0B, 0x0C, 0x4C, 0x81, 0x73, 0x2C, 0x80, 0xE2, 0x01, 0x80, 0xEE, 0x20,
	0x82, 0x2F, 0x10, 0xD1, 0xC6, 0x2B, 0xE0, 0x08, 0x00, 0xC6, 0x05, 0x00,
	0xBD, 0x02, 0x1C, 0xFA, 0x88, 0xFF, 0x0C, 0x0C, 0xE0, 0x08, 0x00, 0x0C,
	0x1A, 0x88, 0x03, 0x1C, 0x9B, 0x88, 0xF8, 0x7C, 0xFC, 0xE0, 0x08, 0x00,
	0x0C, 0x72, 0x1D, 0xF0, 0x0C, 0x82, 0x1D, 0xF0, 0x36, 0x41, 0x00, 0x51,
	0xB7, 0x2B, 0x0C, 0x16, 0x58, 0x35, 0x7C, 0xF4, 0x82, 0x25, 0x45, 0x31,
	0x05, 0x2C, 0xC0, 0x88, 0x11, 0x8A, 0x55, 0x52, 0x25, 0x10, 0x81, 0x04,
	0x2C, 0x37, 0x95, 0x04, 0x0C, 0x04, 0x46, 0x01, 0x00, 0x80, 0x85, 0xC0,
	0x80, 0x46, 0x83, 0x26, 0x04, 0x05, 0x49, 0x02, 0x0C, 0x72, 0x1D, 0xF0,
	0x0C, 0x82, 0x1D, 0xF0, 0x36, 0x41, 0x00, 0xCC, 0x72, 0x8C, 0x53, 0x4C,
	0xFA, 0x0C, 0x1B, 0xE5, 0x03, 0x00, 0x1D, 0xF0, 0x36, 0x41, 0x00, 0x1D,
	0xF0, 0x00, 0x00, 0x00, 0x36, 0x41, 0x00, 0xBD, 0x02, 0x31, 0x51, 0x2C,
	0xAD, 0x05, 0xC2, 0x23, 0x7F, 0x25, 0x01, 0x00, 0xBD, 0x04, 0xAD, 0x06,
	0xC2, 0x23, 0x7F, 0xA5, 0x00, 0x00, 0x0C, 0x02, 0x1D, 0xF0, 0x00, 0x00,
	0x36, 0x41, 0x00, 0x76, 0xA4, 0x07, 0x58, 0x03, 0x59, 0x02, 0x4B, 0x33,
	0x4B, 0x22, 0x1D, 0xF0, 0x36, 0x61, 0x00, 0x41, 0x97, 0x2B, 0x61, 0xAE,
	0x2B, 0x88, 0x34, 0x0C, 0x05, 0x59, 0x78, 0x66, 0x22, 0x1B, 0x96, 0x83,
	0x01, 0xE6, 0x73, 0x15, 0x60, 0x93, 0xA0, 0x92, 0x29, 0x87, 0x96, 0xC9,
	0x00, 0x0C, 0x1A, 0x88, 0x04, 0x1C, 0x9B, 0x88, 0xF8, 0x7C, 0xFC, 0xE0,
	0x08, 0x00, 0x4C, 0xF9, 0x97, 0x92, 0x61, 0xF6, 0x33, 0x17, 0xED, 0x03,
	0x1C, 0x9A, 0x0C, 0x0B, 0x0C, 0x4C, 0xD2, 0xA2, 0x00, 0x88, 0x04, 0x98,
	0x34, 0x82, 0x28, 0x10, 0x32, 0x69, 0x43, 0xE0, 0x08, 0x00, 0xA2, 0x26,
	0x85, 0x25, 0xDA, 0xFF, 0x2D, 0x0A, 0x26, 0x0A, 0x22, 0x59, 0x01, 0x1C,
	0x9A, 0x0C, 0x0B, 0x0C, 0x4C, 0x88, 0x04, 0xD1, 0x81, 0x2B, 0x82, 0x28,
	0x10, 0xED, 0x01, 0xE0, 0x08, 0x00, 0xAD, 0x02, 0xE5, 0xDE, 0xFA, 0xAC,
	0x2A, 0x98, 0x01, 0x2C, 0xCA, 0xA7, 0x99, 0x1C, 0x0C, 0x89, 0x06, 0x03,
	0x00, 0xCD, 0x02, 0x0C, 0x1A, 0x88, 0xFF, 0x1C, 0x9B, 0xE0, 0x08, 0x00,
	0x0C, 0x79, 0x26, 0x79, 0x03, 0x7C, 0xF2, 0x1D, 0xF0, 0x0C, 0x02, 0x1D,
	0xF0, 0x1C, 0x9A, 0x0C, 0x0B, 0x0C, 0x4C, 0xD1, 0x73, 0x2B, 0x4B, 0xE1,
	0x88, 0x04, 0x0C, 0x19, 0x82, 0x28, 0x10, 0x99, 0x11, 0xE0, 0x08, 0x00,
	0xA8, 0x11, 0xF8, 0x04, 0x16, 0x9A, 0xFC, 0xED, 0x02, 0x1C, 0x9A, 0x0C,
	0x0B, 0x0C, 0x4C, 0x82, 0x2F, 0x10, 0xD1, 0x6B, 0x2B, 0xE0, 0x08, 0x00,
	0x06, 0xF0, 0xFF, 0x00, 0x36, 0x41, 0x00, 0x0C, 0x4C, 0xD2, 0xA3, 0x00,
	0x0C, 0x0B, 0x81, 0x62, 0x2B, 0x0C, 0x1A, 0x0C, 0x0E, 0x20, 0xEA, 0x83,
	0x98, 0x38, 0x1C, 0x9A, 0x88, 0x08, 0xE9, 0x39, 0x82, 0x28, 0x10, 0xB9,
	0x79, 0xE0, 0x08, 0x00, 0x1D, 0xF0, 0x00, 0x00, 0x36, 0x41, 0x00, 0x41,
	0x0A, 0x2C, 0x32, 0xA0, 0x88, 0x76, 0xA3, 0x09, 0x82, 0x04, 0x00, 0x82,
	0x42, 0x00, 0x1B, 0x44, 0x1B, 0x22, 0x0C, 0x02, 0x1D, 0xF0, 0x00, 0x00,
	0x36, 0xA1, 0x00, 0x29, 0x01, 0x0C, 0x0D, 0x51, 0x52, 0x2B, 0x71, 0x02,
	0x2C, 0x68, 0x32, 0x16, 0x53, 0x06, 0x82, 0xC3, 0xFE, 0x16, 0xC8, 0x24,
	0x92, 0xC3, 0xEB, 0x16, 0xE9, 0x13, 0xA2, 0xC3, 0xE1, 0x56, 0x6A, 0x13,
	0xAD, 0x04, 0xC8, 0x35, 0xB2, 0x26, 0x43, 0x42, 0x6C, 0x44, 0xA5, 0xE8,
	0xFF, 0xA8, 0x35, 0xB2, 0x26, 0x43, 0xA2, 0x2A, 0x44, 0xE5, 0xE6, 0xFF,
	0x1C, 0x9A, 0x0C, 0x0B, 0x0C, 0x4C, 0xD2, 0xA4, 0x00, 0x98, 0x35, 0x88,
	0x05, 0xE2, 0x29, 0x44, 0x82, 0x28, 0x10, 0xC0, 0xEE, 0x11, 0xEA, 0x99,
	0xE2, 0x29, 0x10, 0xE2, 0x67, 0x39, 0x98, 0xF9, 0x92, 0x67, 0x38, 0xE0,
	0x08, 0x00, 0xE2, 0x27, 0x38, 0x1C, 0x9A, 0x0C, 0x0B, 0x88, 0x05, 0x0C,
	0x4C, 0x82, 0x28, 0x10, 0xD1, 0xEA, 0x2B, 0xE0, 0x08, 0x00, 0x1D, 0xF0,
	0x88, 0x05, 0xA2, 0xA1, 0x1C, 0x82, 0x28, 0x1D, 0x0C, 0x8B, 0xE0, 0x08,
	0x00, 0x0C, 0x4B, 0x0C, 0x52, 0x91, 0xE4, 0x2B, 0x92, 0x6A, 0x3B, 0x00,
	0x50, 0x00, 0x88, 0x05, 0x3D, 0x0A, 0x82, 0x28, 0x1D, 0x0C, 0x0A, 0xE0,
	0x08, 0x00, 0xA0, 0xA0, 0x60, 0xBD, 0x02, 0xA9, 0x45, 0xA2, 0xC3, 0x30,
	0xA5, 0xF3, 0xFF, 0x88, 0x05, 0x0C, 0x0A, 0x82, 0x28, 0x1D, 0x0C, 0x4B,
	0xE0, 0x08, 0x00, 0xB8, 0x01, 0x0C, 0x62, 0xF8, 0x45, 0xE2, 0x23, 0x10,
	0xD8, 0xF3, 0x0C, 0x09, 0x92, 0x63, 0x44, 0x92, 0x63, 0x45, 0xD2, 0x67,
	0x38, 0xE2, 0x67, 0x39, 0x99, 0x83, 0xAA, 0xFF, 0xA2, 0xA0, 0x64, 0xF9,
	0x45, 0x00, 0x50, 0x00, 0x39, 0x35, 0x22, 0x63, 0x3C, 0x39, 0x3B, 0xB2,
	0x63, 0x46, 0x99, 0x73, 0xA9, 0x23, 0x99, 0x63, 0x0C, 0x0A, 0xE5, 0xEC,
	0xFF, 0x0C, 0x0B, 0x0C, 0x4C, 0xD2, 0xA4, 0x00, 0xE2, 0x27, 0x39, 0x88,
	0x05, 0x0C, 0x0A, 0x0C, 0x29, 0x92, 0x63, 0x3D, 0xA9, 0x43, 0xA9, 0x53,
	0xA2, 0x63, 0x3E, 0xA2, 0x63, 0x3F, 0xA2, 0x63, 0x40, 0xA2, 0x63, 0x42,
	0xA2, 0x63, 0x43, 0x82, 0x28, 0x10, 0x1C, 0x9A, 0xE0, 0x08, 0x00, 0xE2,
	0x27, 0x38, 0x1C, 0x9A, 0x0C, 0x0B, 0x88, 0x05, 0x0C, 0x4C, 0x82, 0x28,
	0x10, 0xD1, 0xBA, 0x2B, 0xE0, 0x08, 0x00, 0x1C, 0x9A, 0x0C, 0x0B, 0x0C,
	0x4C, 0x88, 0x05, 0xD2, 0xA5, 0x00, 0x82, 0x28, 0x10, 0xE1, 0xB7, 0x2B,
	0xE0, 0x08, 0x00, 0x1C, 0x9A, 0x0C, 0x0B, 0x0C, 0x4C, 0x88, 0x05, 0xD2,
	0xA5, 0x00, 0x82, 0x28, 0x10, 0xE1, 0xB3, 0x2B, 0xE0, 0x08, 0x00, 0x1D,
	0xF0, 0x32, 0x27, 0xDF, 0xF2, 0x27, 0xDC, 0x42, 0x27, 0xDE, 0xE2, 0x27,
	0xE1, 0xC8, 0x55, 0xB1, 0x52, 0x2B, 0xAD, 0x0D, 0x98, 0x86, 0xC0, 0xAB,
	0x93, 0xC2, 0x27, 0xDA, 0xA9, 0x71, 0xB2, 0x27, 0xDD, 0xA2, 0x27, 0xE0,
	0x56, 0x79, 0xFD, 0xF9, 0x61, 0xB9, 0x51, 0xA9, 0x41, 0xE9, 0x31, 0x82,
	0x27, 0x39, 0x0C, 0x19, 0x99, 0x86, 0x91, 0x40, 0x2B, 0xC9, 0x21, 0x97,
	0x98, 0x08, 0xA2, 0x26, 0x43, 0x66, 0x1A, 0x02, 0x31, 0x48, 0x2B, 0xC0,
	0xEA, 0x03, 0xC9, 0x11, 0xD9, 0x96, 0xE2, 0x27, 0xD8, 0xB8, 0x36, 0xE9,
	0x91, 0xAC, 0x7B, 0xBD, 0x0E, 0xAD, 0x04, 0xC2, 0x27, 0x38, 0x65, 0xD2,
	0xFF, 0xB8, 0x21, 0xAD, 0x03, 0xC2, 0x27, 0x38, 0xA5, 0xD1, 0xFF, 0xA8,
	0x41, 0xB8, 0x61, 0x5C, 0x0C, 0x25, 0xD1, 0xFF, 0xA8, 0x31, 0xB8, 0x51,
	0x5C, 0x0C, 0xA5, 0xD0, 0xFF, 0xC6, 0x03, 0x00, 0xA8, 0x91, 0xB2, 0x27,
	0xD9, 0xC8, 0x21, 0xDD, 0x04, 0xED, 0x03, 0xF8, 0x71, 0x65, 0xCD, 0xFF,
	0x90, 0xEA, 0x03, 0xD8, 0x46, 0x99, 0x81, 0x9C, 0x5D, 0xAD, 0x04, 0xBD,
	0x03, 0xC2, 0x27, 0x38, 0x88, 0x15, 0xE2, 0x27, 0x39, 0x82, 0x28, 0x2E,
	0xF2, 0xC6, 0x14, 0xE0, 0x08, 0x00, 0x98, 0x81, 0xA8, 0x76, 0xB8, 0x66,
	0x38, 0x11, 0x88, 0x96, 0x30, 0x39, 0xC0, 0x80, 0x33, 0xC0, 0x30, 0xBB,
	0x53, 0xB9, 0x66, 0xCC, 0x2A, 0x39, 0x76, 0xAD, 0x03, 0x88, 0x15, 0x82,
	0x28, 0x28, 0xE0, 0x08, 0x00, 0x88, 0x15, 0x4D, 0x0A, 0x82, 0x28, 0x28,
	0xAD, 0x03, 0xE0, 0x08, 0x00, 0xC1, 0x7B, 0x2B, 0x88, 0x15, 0xBD, 0x0A,
	0x82, 0x28, 0x2A, 0xAD, 0x04, 0xE0, 0x08, 0x00, 0x88, 0x15, 0x82, 0x28,
	0x29, 0x0C, 0x03, 0xE0, 0x08, 0x00, 0x39, 0x86, 0x0C, 0x0B, 0x0C, 0x0C,
	0x88, 0x05, 0xA9, 0x76, 0x88, 0xF8, 0x1C, 0x6A, 0xE0, 0x08, 0x00, 0x1D,
	0xF0, 0xB2, 0x26, 0x43, 0x4C, 0xFA, 0x65, 0xC8, 0xFF, 0x1C, 0x9A, 0x0C,
	0x0B, 0x0C, 0x4C, 0x88, 0x05, 0xD2, 0xA2, 0x00, 0x82, 0x28, 0x10, 0x0C,
	0x0E, 0xE0, 0x08, 0x00, 0x1D, 0xF0, 0x00, 0x00, 0x36, 0x41, 0x00, 0x0C,
	0x48, 0xF0, 0x64, 0x00, 0x0C, 0xF7, 0x80, 0x87, 0x10, 0xF0, 0x77, 0x10,
	0xF0, 0xF7, 0x30, 0xF0, 0xF8, 0x20, 0xF0, 0xE6, 0x13, 0x10, 0x20, 0x00,
	0x88, 0x12, 0x68, 0x22, 0x0C, 0x09, 0x87, 0x96, 0x1B, 0x3D, 0x09, 0xF0,
	0x64, 0x00, 0x0C, 0xFA, 0x30, 0x3A, 0x10, 0xF0, 0xAA, 0x10, 0xF0, 0xFA,
	0x30, 0xF0, 0xF3, 0x20, 0xF0, 0xE6, 0x13, 0x10, 0x20, 0x00, 0x86, 0x0F,
	0x00, 0x8C, 0x53, 0xB8, 0x08, 0xB0, 0xB0, 0xF5, 0xB9, 0x03, 0x8C, 0x54,
	0xC8, 0x08, 0xC0, 0xC0, 0xF4, 0xC9, 0x04, 0x38, 0x02, 0x8C, 0x25, 0xD8,
	0x18, 0xD9, 0x05, 0xE2, 0xD3, 0x04, 0x8B, 0x88, 0xE7, 0x98, 0x01, 0x8D,
	0x03, 0x0C, 0x13, 0x89, 0x12, 0xF0, 0x64, 0x00, 0x0C, 0xF6, 0x90, 0x96,
	0x10, 0xF0, 0x66, 0x10, 0xF0, 0xF6, 0x30, 0xF0, 0xF9, 0x20, 0xF0, 0xE6,
	0x13, 0x10, 0x20, 0x00, 0x2D, 0x03, 0x1D, 0xF0, 0x36, 0x81, 0x00, 0xA0,
	0xEA, 0x03, 0x0C, 0x07, 0x0C, 0x06, 0x0C, 0x04, 0x1C, 0xF5, 0x31, 0x8E,
	0x2A, 0x0C, 0x08, 0x0C, 0x0C, 0x0C, 0x0D, 0xD9, 0x51, 0xC9, 0x31, 0x89,
	0x41, 0x89, 0x01, 0x89, 0x11, 0x98, 0x33, 0x89, 0x21, 0x88, 0x99, 0x38,
	0x03, 0xA0, 0x88, 0xC0, 0x89, 0x99, 0xBD, 0x01, 0x4B, 0xC1, 0xA2, 0x23,
	0x1C, 0x8B, 0xD1, 0xA8, 0x0A, 0x25, 0xF4, 0xFF, 0x16, 0x7A, 0x07, 0xB8,
	0x01, 0xDC, 0x14, 0x66, 0x7B, 0x0F, 0xC8, 0x11, 0x66, 0x7C, 0x0A, 0x0C,
	0x0A, 0x0C, 0x14, 0xD8, 0x21, 0xD9, 0x31, 0x46, 0x00, 0x00, 0x0C, 0x1A,
	0x66, 0x1B, 0x10, 0xE8, 0x11, 0x1C, 0x9F, 0xF7, 0x9E, 0x09, 0x0C, 0x0A,
	0x0C, 0x18, 0x98, 0x21, 0x99, 0x41, 0x89, 0x51, 0x57, 0x9B, 0x05, 0x78,
	0x11, 0x0C, 0x0A, 0x0C, 0x16, 0x16, 0x5A, 0xFB, 0x22, 0x23, 0x1A, 0x28,
	0x02, 0x9C, 0x02, 0xAD, 0x02, 0xB8, 0x01, 0xC8, 0x11, 0x88, 0x02, 0xD8,
	0x21, 0xE0, 0x08, 0x00, 0x28, 0x42, 0x56, 0xD2, 0xFE, 0x22, 0x23, 0x1B,
	0x28, 0x02, 0x16, 0x42, 0xF9, 0xB8, 0x01, 0xE8, 0x02, 0x66, 0x7B, 0x05,
	0x81, 0x21, 0x2B, 0x87, 0x1E, 0x08, 0xAD, 0x02, 0xC8, 0x11, 0xD8, 0x21,
	0xE0, 0x0E, 0x00, 0x28, 0x42, 0x56, 0x42, 0xFE, 0x86, 0xDD, 0xFF, 0x8C,
	0x94, 0xC8, 0x31, 0x0C, 0x7A, 0x88, 0xF3, 0x0C, 0x7B, 0xE0, 0x08, 0x00,
	0x98, 0x51, 0x8C, 0x99, 0xC8, 0x41, 0x0C, 0x1A, 0x88, 0xF3, 0x1C, 0x9B,
	0xE0, 0x08, 0x00, 0x8C, 0x96, 0xBD, 0x07, 0x1C, 0xFA, 0x88, 0xF3, 0x0C,
	0x0C, 0xE0, 0x08, 0x00, 0xB0, 0xEA, 0x03, 0xA1, 0x59, 0x2A, 0xA8, 0x3A,
	0x98, 0x9A, 0xBA, 0x99, 0x99, 0x9A, 0x1D, 0xF0, 0x36, 0x41, 0x00, 0x65,
	0x2E, 0x00, 0x0C, 0x32, 0x00, 0x50, 0x00, 0x1D, 0xF0, 0x00, 0x00, 0x00,
	0x36, 0x61, 0x00, 0x21, 0x51, 0x2A, 0x88, 0x02, 0x88, 0x18, 0x0C, 0x1A,
	0xE0, 0x08, 0x00, 0x88, 0x02, 0x88, 0x18, 0x0C, 0x2A, 0xE0, 0x08, 0x00,
	0x88, 0x02, 0x88, 0x18, 0x0C, 0x3A, 0xE0, 0x08, 0x00, 0x88, 0x02, 0x88,
	0x18, 0x0C, 0x4A, 0xE0, 0x08, 0x00, 0x88, 0x02, 0x88, 0x18, 0x0C, 0x5A,
	0xE0, 0x08, 0x00, 0x88, 0x02, 0x88, 0x18, 0x0C, 0x6A, 0xE0, 0x08, 0x00,
	0x88, 0x02, 0x88, 0x18, 0xA1, 0xFA, 0x2A, 0xE0, 0x08, 0x00, 0x3D, 0x02,
	0x41, 0xF9, 0x2A, 0x0C, 0x0C, 0x9D, 0x0A, 0x0C, 0x8A, 0x76, 0xAA, 0x04,
	0xC2, 0x63, 0xB4, 0x4B, 0x33, 0x3D, 0x02, 0x92, 0x61, 0x01, 0xB2, 0xA0,
	0x08, 0x76, 0xAB, 0x04, 0xC2, 0x63, 0xBC, 0x4B, 0x33, 0x88, 0x02, 0x88,
	0x18, 0x0C, 0xAA, 0xE0, 0x08, 0x00, 0x88, 0x02, 0x3D, 0x0A, 0x88, 0x18,
	0x0C, 0xBA, 0xE0, 0x08, 0x00, 0x39, 0x01, 0x88, 0x02, 0x7D, 0x0A, 0x88,
	0x18, 0x0C, 0xCA, 0xE0, 0x08, 0x00, 0x88, 0x02, 0x6D, 0x0A, 0x88, 0x18,
	0x0C, 0xDA, 0xE0, 0x08, 0x00, 0x5D, 0x0A, 0x3D, 0x02, 0x88, 0x02, 0x88,
	0x58, 0xE0, 0x08, 0x00, 0xA2, 0x63, 0xB4, 0x4B, 0x33, 0x47, 0x93, 0xF0,
	0x3D, 0x02, 0x88, 0x02, 0x88, 0x58, 0xE0, 0x08, 0x00, 0xA2, 0x63, 0xBC,
	0x4B, 0x33, 0x47, 0x93, 0xF0, 0x88, 0x02, 0xA8, 0x01, 0x88, 0x48, 0xB2,
	0x22, 0xB4, 0xE0, 0x08, 0x00, 0xB2, 0x22, 0xB5, 0x88, 0x02, 0x38, 0x01,
	0x88, 0x48, 0xAD, 0x03, 0xE0, 0x08, 0x00, 0x88, 0x02, 0xAD, 0x03, 0x88,
	0x38, 0xB2, 0x22, 0xBC, 0xE0, 0x08, 0x00, 0x88, 0x02, 0xAD, 0x03, 0x88,
	0x38, 0xB2, 0x22, 0xBD, 0xE0, 0x08, 0x00, 0x88, 0x02, 0xAD, 0x07, 0x88,
	0x48, 0xB2, 0x22, 0xB6, 0xE0, 0x08, 0x00, 0x88, 0x02, 0xAD, 0x07, 0x88,
	0x48, 0xB2, 0x22, 0xB7, 0xE0, 0x08, 0x00, 0x88, 0x02, 0xAD, 0x07, 0x88,
	0x38, 0xB2, 0x22, 0xBE, 0xE0, 0x08, 0x00, 0x88, 0x02, 0xAD, 0x07, 0x88,
	0x38, 0xB2, 0x22, 0xBF, 0xE0, 0x08, 0x00, 0x88, 0x02, 0xAD, 0x06, 0x88,
	0x48, 0xB2, 0x22, 0xB8, 0xE0, 0x08, 0x00, 0x88, 0x02, 0xAD, 0x06, 0x88,
	0x38, 0xB2, 0x22, 0xC0, 0xE0, 0x08, 0x00, 0x88, 0x02, 0xAD, 0x06, 0x88,
	0x48, 0xB2, 0x22, 0xB9, 0xE0, 0x08, 0x00, 0x88, 0x02, 0xAD, 0x06, 0x88,
	0x38, 0xB2, 0x22, 0xC1, 0xE0, 0x08, 0x00, 0x88, 0x02, 0xAD, 0x05, 0x88,
	0x48, 0xB2, 0x22, 0xBA, 0xE0, 0x08, 0x00, 0x88, 0x02, 0xAD, 0x05, 0x88,
	0x48, 0xB2, 0x22, 0xBB, 0xE0, 0x08, 0x00, 0x88, 0x02, 0xAD, 0x05, 0x88,
	0x38, 0xB2, 0x22, 0xC2, 0xE0, 0x08, 0x00, 0x88, 0x02, 0xAD, 0x05, 0x88,
	0x38, 0xB2, 0x22, 0xC3, 0xE0, 0x08, 0x00, 0x88, 0x02, 0x88, 0x18, 0x0C,
	0x8A, 0xE0, 0x08, 0x00, 0x88, 0x02, 0x88, 0x08, 0xA2, 0xA0, 0x80, 0xE0,
	0x08, 0x00, 0x88, 0x02, 0x6D, 0x0A, 0x88, 0x18, 0xA1, 0xA7, 0x2A, 0xE0,
	0x08, 0x00, 0x88, 0x02, 0x7D, 0x0A, 0x88, 0x08, 0xA1, 0xA5, 0x2A, 0xE0,
	0x08, 0x00, 0x88, 0x02, 0x88, 0x08, 0xA1, 0xA3, 0x2A, 0xE0, 0x08, 0x00,
	0x88, 0x02, 0x88, 0x58, 0xE0, 0x08, 0x00, 0x88, 0x02, 0x88, 0x58, 0x5D,
	0x0A, 0xE0, 0x08, 0x00, 0xBD, 0x05, 0x4D, 0x0A, 0x88, 0x02, 0x38, 0x11,
	0x88, 0x48, 0xAD, 0x03, 0xE0, 0x08, 0x00, 0x88, 0x02, 0xAD, 0x03, 0x88,
	0x38, 0xBD, 0x04, 0xE0, 0x08, 0x00, 0x88, 0x02, 0xBD, 0x05, 0x88, 0x38,
	0xAD, 0x06, 0xE0, 0x08, 0x00, 0x88, 0x02, 0xBD, 0x04, 0x88, 0x48, 0xAD,
	0x06, 0xE0, 0x08, 0x00, 0x88, 0x02, 0x88, 0x18, 0xA1, 0x92, 0x2A, 0xE0,
	0x08, 0x00, 0x88, 0x02, 0xBD, 0x0A, 0x88, 0x28, 0x1C, 0x7A, 0xE0, 0x08,
	0x00, 0x88, 0x02, 0xBD, 0x07, 0x88, 0x28, 0x1C, 0x9A, 0xE0, 0x08, 0x00,
	0x88, 0x02, 0xBD, 0x03, 0x88, 0x28, 0x0C, 0x7A, 0xE0, 0x08, 0x00, 0x1D,
	0xF0, 0x00, 0x00, 0x00, 0x36, 0x61, 0x00, 0x25, 0x12, 0x00, 0xA1, 0x86,
	0x2A, 0xB1, 0x86, 0x2A, 0xC1, 0x87, 0x2A, 0xD1, 0x87, 0x2A, 0xE1, 0x87,
	0x2A, 0xF1, 0x87, 0x2A, 0x0C, 0x42, 0x00, 0x50, 0x00, 0xE0, 0x02, 0x00,
	0xBD, 0x0A, 0x31, 0xC1, 0x29, 0xA1, 0x84, 0x2A, 0xB9, 0x03, 0xA2, 0x6B,
	0x15, 0x91, 0xDD, 0x29, 0xC0, 0x20, 0x00, 0x92, 0x29, 0x98, 0x0C, 0x02,
	0x27, 0x69, 0x01, 0x1D, 0xF0, 0xAD, 0x01, 0x0C, 0x0C, 0x41, 0x0F, 0x2A,
	0x0C, 0x62, 0xF8, 0x04, 0xE1, 0x7D, 0x2A, 0xE9, 0x0F, 0x00, 0x50, 0x00,
	0x29, 0x13, 0xE2, 0x2B, 0x1D, 0xF2, 0x22, 0x14, 0xD2, 0x22, 0x13, 0xD9,
	0x23, 0xF8, 0x0F, 0xF9, 0x11, 0xE9, 0x31, 0xD9, 0x21, 0xC9, 0x01, 0xA5,
	0x0F, 0x00, 0x65, 0xD7, 0xFF, 0x51, 0xBA, 0x29, 0x88, 0x05, 0xCC, 0xF8,
	0xA1, 0x73, 0x2A, 0x88, 0x64, 0xB1, 0x72, 0x2A, 0xE0, 0x08, 0x00, 0xA9,
	0x15, 0x0C, 0x19, 0x99, 0x05, 0xA8, 0x03, 0x82, 0x2A, 0x17, 0xE0, 0x08,
	0x00, 0x0C, 0x12, 0x1D, 0xF0, 0x00, 0x00, 0x00, 0x4C, 0x69, 0x08, 0x20,
	0x68, 0x6B, 0x08, 0x20, 0x40, 0x1A, 0x05, 0x20, 0x00, 0x80, 0x05, 0x20,
	0x50, 0x69, 0x08, 0x20, 0x00, 0x00, 0x04, 0x00, 0x00, 0x80, 0xFF, 0xFF,
	0x43, 0x9A, 0xFF, 0xFF, 0x00, 0x01, 0x05, 0x20, 0x36, 0x41, 0x00, 0x71,
	0xFA, 0xFF, 0x31, 0xF7, 0xFF, 0x51, 0xF7, 0xFF, 0x7C, 0xC6, 0x41, 0xF3,
	0xFF, 0x21, 0xF3, 0xFF, 0x29, 0x04, 0x3B, 0x22, 0x60, 0x22, 0x10, 0x29,
	0x04, 0x37, 0x35, 0x0B, 0x0C, 0x03, 0x39, 0x07, 0x0C, 0x12, 0x1D, 0xF0,
	0x0C, 0x02, 0x1D, 0xF0, 0x91, 0xF1, 0xFF, 0xA1, 0xF1, 0xFF, 0x81, 0xF1,
	0xFF, 0x41, 0xF1, 0xFF, 0x60, 0x68, 0x10, 0xA0, 0x44, 0x10, 0x20, 0x44,
	0xC0, 0x9A, 0x44, 0x67, 0x24, 0xE1, 0x69, 0x07, 0x80, 0xB2, 0x41, 0x16,
	0x5B, 0xFD, 0x0C, 0x06, 0x1B, 0x66, 0xD8, 0x05, 0x4B, 0x55, 0xD9, 0x02,
	0xC8, 0x07, 0x4B, 0x22, 0xC0, 0xC2, 0x41, 0xC7, 0x36, 0xED, 0x86, 0xEF,
	0xFF, 0x00, 0x00, 0x00, 0xFE, 0xFE, 0xFE, 0xFE, 0x36, 0x41, 0x00, 0xD1,
	0xDF, 0xFF, 0x81, 0xFD, 0xFF, 0xA8, 0x0D, 0xB1, 0xD9, 0xFF, 0x87, 0x9A,
	0x06, 0x25, 0xF8, 0xFF, 0x2D, 0x0A, 0x1D, 0xF0, 0xA0, 0x92, 0x41, 0xA8,
	0x0B, 0x9C, 0x59, 0xB1, 0xD7, 0xFF, 0x0C, 0x0C, 0x1B, 0xCC, 0xF8, 0x0A,
	0x4B, 0xAA, 0xF9, 0x0B, 0xE8, 0x0D, 0x4B, 0xBB, 0xE0, 0xE2, 0x41, 0xE7,
	0x3C, 0xED, 0x0C, 0x12, 0x1D, 0xF0, 0x00, 0x00, 0x36, 0x41, 0x00, 0x31,
	0x39, 0x2A, 0xC8, 0x03, 0x8C, 0x7C, 0x88, 0x2C, 0x8C, 0x38, 0x1D, 0xF0,
	0x00, 0x00, 0x00, 0xC8, 0x22, 0xC9, 0x03, 0x16, 0xE2, 0x04, 0xA8, 0x02,
	0x98, 0x12, 0x16, 0xEA, 0x04, 0xA9, 0x1C, 0xD8, 0x32, 0x8C, 0x09, 0x99,
	0x4C, 0x16, 0x8D, 0x04, 0xD9, 0x5C, 0x91, 0x2F, 0x2A, 0xB1, 0x32, 0x2A,
	0x81, 0x2F, 0x2A, 0xE1, 0x30, 0x2A, 0xF1, 0x2E, 0x2A, 0xF2, 0x6C, 0x12,
	0xE2, 0x6C, 0x13, 0x82, 0x6C, 0x11, 0xB2, 0x6C, 0x15, 0x99, 0xFC, 0x1C,
	0x0B, 0x91, 0x2C, 0x2A, 0x92, 0x6C, 0x16, 0xE0, 0x0D, 0x00, 0x88, 0x03,
	0xA9, 0x28, 0xA8, 0x18, 0x88, 0x58, 0x1C, 0x0B, 0xE0, 0x08, 0x00, 0x98,
	0x03, 0xA9, 0x39, 0x1D, 0xF0, 0xA8, 0x1C, 0xD8, 0x5C, 0x46, 0xEF, 0xFF,
	0xA8, 0x1C, 0x46, 0xEB, 0xFF, 0xD8, 0x5C, 0xC6, 0xEC, 0xFF, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x36, 0x81, 0x00, 0x39, 0x22, 0x39, 0x51, 0xD2,
	0xC1, 0x14, 0xD0, 0x80, 0x0C, 0x1C, 0xF6, 0xAF, 0xE0, 0x0A, 0x22, 0x82,
	0x29, 0x04, 0x00, 0xAF, 0xE0, 0x0A, 0x22, 0x82, 0x29, 0x05, 0x00, 0xAF,
	0xE0, 0x0A, 0x22, 0x82, 0x29, 0x06, 0x00, 0x8F, 0x9D, 0xBF, 0x42, 0x82,
	0x29, 0x07, 0x00, 0x0F, 0x62, 0x01, 0x82, 0x2E, 0x2B, 0x11, 0x00, 0x00,
	0x8B, 0x0D, 0xB0, 0x00, 0x0C, 0x4B, 0xA2, 0x00, 0x0A, 0x0D, 0x82, 0x92,
	0x08, 0x80, 0x58, 0x01, 0x40, 0x98, 0x01, 0x90, 0x9C, 0x31, 0x50, 0x5C,
	0x31, 0xC0, 0x88, 0x01, 0x80, 0x8C, 0x31, 0x9A, 0x55, 0x8A, 0x55, 0x0F,
	0x84, 0x40, 0x82, 0x6E, 0x09, 0x01, 0x00, 0x8F, 0x20, 0x04, 0x28, 0x44,
	0x0C, 0x0C, 0x11, 0x8F, 0xA4, 0x1C, 0x82, 0x48, 0x10, 0x08, 0x01, 0x2F,
	0x20, 0x64, 0x43, 0x44, 0x0C, 0x0C, 0x11, 0x00, 0x44, 0x0D, 0x58, 0x22,
	0x38, 0xE2, 0x59, 0x92, 0x2F, 0x66, 0xE0, 0x22, 0xC0, 0x10, 0x0C, 0x00,
	0x00, 0x13, 0x40, 0x00, 0xE5, 0xA1, 0xE9, 0x92, 0x42, 0xC2, 0x28, 0x91,
	0xF4, 0x29, 0xA2, 0x22, 0x06, 0x92, 0x29, 0x00, 0x82, 0x92, 0x08, 0x92,
	0x29, 0x01, 0x80, 0x8C, 0x21, 0x90, 0x92, 0x41, 0xA0, 0x99, 0xC0, 0x92,
	0xC9, 0xF0, 0x92, 0x62, 0x0A, 0x76, 0x00, 0x07, 0x0F, 0x20, 0x84, 0x28,
	0x44, 0x0C, 0x0C, 0x11, 0xAF, 0x81, 0x00, 0xA2, 0x2E, 0x4A, 0x01, 0x00,
	0xAF, 0xE0, 0x0A, 0x22, 0x48, 0x40, 0x20, 0x01, 0xAF, 0xE0, 0x0A, 0x22,
	0x82, 0x39, 0x04, 0x00, 0xAF, 0xE0, 0x0A, 0x22, 0xA4, 0x30, 0x18, 0x02,
	0xAF, 0xE0, 0x0A, 0x22, 0x82, 0x31, 0x04, 0x11, 0x00, 0xC4, 0x0D, 0xF8,
	0xA2, 0x7C, 0xC3, 0x30, 0xFF, 0x10, 0xF9, 0xA2, 0x1D, 0xF0, 0x00, 0x00,
	0xD6, 0x83, 0xF9, 0x30, 0xB0, 0x60, 0x00, 0x0B, 0x40, 0x50, 0xA0, 0x91,
	0xA9, 0x92, 0x86, 0xE2, 0xFF, 0x00, 0x00, 0x00, 0x36, 0x61, 0x00, 0xAD,
	0x03, 0x81, 0xD5, 0x29, 0x49, 0x21, 0x7C, 0xC6, 0x3B, 0xC5, 0x7D, 0x02,
	0xB8, 0x67, 0x21, 0xD9, 0x29, 0x98, 0x97, 0x60, 0xCC, 0x10, 0x48, 0x77,
	0x92, 0x61, 0x01, 0x82, 0x28, 0x00, 0x28, 0x02, 0x88, 0x78, 0x30, 0xBB,
	0xA0, 0xE0, 0x08, 0x00, 0x81, 0xCC, 0x29, 0xA8, 0x57, 0x88, 0x08, 0xBD,
	0x03, 0x88, 0x78, 0xC2, 0x27, 0x06, 0xE0, 0x08, 0x00, 0x6C, 0xDB, 0x1C,
	0xFC, 0xED, 0x01, 0xF2, 0xC5, 0x15, 0xC0, 0xFF, 0x01, 0x40, 0xFF, 0xC0,
	0xF0, 0xF1, 0x41, 0xF9, 0x01, 0xE0, 0x00, 0x0C, 0x0F, 0xAE, 0x41, 0x82,
	0x2A, 0x31, 0x80, 0x10, 0xAF, 0xA0, 0x01, 0xA2, 0x02, 0x0B, 0x04, 0x00,
	0x2F, 0x01, 0x81, 0x49, 0xEE, 0x0A, 0x01, 0x00, 0x2F, 0x49, 0x01, 0x42,
	0xA4, 0x00, 0x80, 0x00, 0xA0, 0xA5, 0x41, 0xEF, 0x45, 0x92, 0x43, 0x6C,
	0x0C, 0x83, 0x00, 0x00, 0x0E, 0x0D, 0xD8, 0x01, 0x1B, 0xCB, 0xD0, 0xBC,
	0x93, 0x60, 0xBB, 0x10, 0xB9, 0x31, 0xE6, 0x1B, 0x02, 0x06, 0x34, 0x00,
	0x0B, 0xBB, 0x0C, 0x16, 0xE8, 0x11, 0xB0, 0x99, 0x11, 0x30, 0xAA, 0xA0,
	0x8F, 0xF4, 0x02, 0x22, 0x44, 0x0C, 0x0C, 0x11, 0x9A, 0x92, 0xEA, 0xC4,
	0x90, 0x03, 0xBC, 0x4F, 0xF5, 0x92, 0x22, 0x44, 0x0C, 0x0C, 0x11, 0xCF,
	0xF4, 0x82, 0x22, 0x44, 0x0C, 0x0C, 0x11, 0x90, 0xE6, 0xA7, 0xAF, 0x22,
	0x55, 0xA2, 0x22, 0x33, 0x80, 0x10, 0x4F, 0x99, 0x93, 0x43, 0xE0, 0x40,
	0x5D, 0x0E, 0xEF, 0x83, 0x05, 0x62, 0xC0, 0x40, 0x5E, 0x0E, 0x90, 0x26,
	0xA7, 0x8F, 0x54, 0x93, 0x43, 0x0A, 0x58, 0x51, 0x02, 0x2F, 0x09, 0x01,
	0x42, 0xE0, 0x40, 0xC5, 0x0C, 0x0F, 0x0B, 0x9F, 0x43, 0xC0, 0x40, 0xC6,
	0x0C, 0x76, 0x9B, 0x59, 0xB0, 0x99, 0x11, 0x8F, 0xC8, 0x69, 0x43, 0x02,
	0x58, 0x09, 0x02, 0x2F, 0x01, 0x81, 0x49, 0x2E, 0x31, 0x80, 0x10, 0x2F,
	0x3F, 0x69, 0x43, 0x30, 0x5C, 0xA9, 0x02, 0x30, 0x88, 0xA0, 0x10, 0x4C,
	0x9D, 0x90, 0x03, 0x8C, 0x90, 0xA6, 0x87, 0x8F, 0xF0, 0x02, 0x22, 0x44,
	0x0C, 0x0C, 0x11, 0xCF, 0xF0, 0x82, 0x22, 0xE0, 0x40, 0x15, 0x08, 0x2F,
	0x22, 0x45, 0xA2, 0xC0, 0x40, 0x16, 0x08, 0x90, 0xA6, 0x87, 0xCF, 0xF0,
	0x82, 0x22, 0x0A, 0x58, 0x09, 0x02, 0x2F, 0x69, 0x01, 0x42, 0xE0, 0x40,
	0x15, 0x08, 0x0F, 0x6B, 0x9F, 0x43, 0xC0, 0x40, 0x16, 0x08, 0xAF, 0xE0,
	0x0A, 0x22, 0x02, 0x58, 0x09, 0x02, 0xAF, 0xE0, 0x0A, 0x22, 0x30, 0x5C,
	0xA9, 0x02, 0x10, 0x4C, 0x9D, 0x81, 0x7D, 0x29, 0x30, 0xA5, 0xA0, 0x88,
	0x08, 0xB8, 0x57, 0x88, 0x88, 0xC8, 0x67, 0xE0, 0x08, 0x00, 0x28, 0x31,
	0xC0, 0x95, 0x01, 0x90, 0x94, 0xC0, 0x99, 0x77, 0x1D, 0xF0, 0x00, 0x00,
	0x36, 0x81, 0x00, 0x5D, 0x07, 0x0C, 0x08, 0x89, 0x07, 0xAC, 0x12, 0x9C,
	0xB3, 0x9C, 0x94, 0xA1, 0x72, 0x29, 0xF8, 0x0A, 0x98, 0x1F, 0x90, 0x92,
	0x41, 0x67, 0x39, 0x0D, 0x8C, 0xA7, 0xB1, 0x76, 0x29, 0xA8, 0x02, 0xB7,
	0x1A, 0x0B, 0x0C, 0x12, 0x1D, 0xF0, 0x0C, 0x32, 0x1D, 0xF0, 0x0C, 0x12,
	0x1D, 0xF0, 0xAD, 0x03, 0xB8, 0x2F, 0x88, 0x8F, 0xCD, 0x06, 0xE0, 0x08,
	0x00, 0xF1, 0x66, 0x29, 0xF8, 0x0F, 0x78, 0x3F, 0x38, 0x2F, 0x69, 0x01,
	0xA8, 0xB2, 0x6D, 0x03, 0xBC, 0x0A, 0x88, 0xBF, 0xE0, 0x08, 0x00, 0xF1,
	0x61, 0x29, 0xF8, 0x0F, 0xAC, 0x4A, 0xBD, 0x03, 0x39, 0x21, 0xA8, 0xB2,
	0xCD, 0x07, 0xD2, 0x11, 0x00, 0x88, 0xEF, 0xED, 0x01, 0xE0, 0x08, 0x00,
	0x8C, 0x2A, 0x0C, 0x62, 0x1D, 0xF0, 0x38, 0x01, 0x16, 0xD3, 0x0D, 0x6D,
	0x07, 0xF1, 0x57, 0x29, 0x78, 0x21, 0xF8, 0x0F, 0xA8, 0xC2, 0xAC, 0x5A,
	0x88, 0xBF, 0xE0, 0x08, 0x00, 0xF1, 0x53, 0x29, 0x38, 0x01, 0xF8, 0x0F,
	0x9C, 0x9A, 0xBD, 0x06, 0x69, 0x11, 0x30, 0xD0, 0xF4, 0xA8, 0xC2, 0xCD,
	0x07, 0x88, 0xEF, 0xED, 0x01, 0xE0, 0x08, 0x00, 0x16, 0x2A, 0x09, 0x0C,
	0x62, 0x1D, 0xF0, 0x38, 0x01, 0xB8, 0x62, 0xA8, 0x1F, 0x3A, 0xBB, 0xA0,
	0xA2, 0x41, 0xB7, 0xBA, 0x03, 0x0C, 0x72, 0x1D, 0xF0, 0xCD, 0x07, 0xBD,
	0x06, 0x69, 0x31, 0x79, 0x41, 0x30, 0xD0, 0xF4, 0x82, 0x2F, 0x11, 0xAD,
	0x02, 0xE0, 0x08, 0x00, 0x78, 0x41, 0x3D, 0x0A, 0xA9, 0x01, 0x16, 0x0A,
	0x07, 0xA8, 0xD2, 0x6D, 0x07, 0xAC, 0xFA, 0x81, 0x3E, 0x29, 0x88, 0x08,
	0x88, 0xB8, 0xE0, 0x08, 0x00, 0x38, 0x01, 0xAC, 0x1A, 0xBD, 0x07, 0xA8,
	0xD2, 0x81, 0x39, 0x29, 0x30, 0xD0, 0xF4, 0x88, 0x08, 0xC8, 0x31, 0x88,
	0xE8, 0xED, 0x01, 0xE0, 0x08, 0x00, 0x8C, 0x3A, 0x0C, 0x62, 0x1D, 0xF0,
	0x00, 0x38, 0x01, 0x16, 0x23, 0x05, 0x68, 0x31, 0xA2, 0x21, 0x10, 0x26,
	0x0A, 0x39, 0x37, 0xBA, 0x08, 0xA9, 0x01, 0x3D, 0x0A, 0x0C, 0x82, 0x46,
	0x00, 0x00, 0x0C, 0x02, 0x81, 0x2D, 0x29, 0xAD, 0x06, 0x88, 0x08, 0xBD,
	0x04, 0x88, 0x88, 0xCD, 0x03, 0xE0, 0x08, 0x00, 0x98, 0x01, 0x99, 0x05,
	0x1D, 0xF0, 0x38, 0x01, 0x9C, 0xB3, 0x6D, 0x07, 0xF1, 0x26, 0x29, 0x78,
	0x11, 0xF8, 0x0F, 0x86, 0xD8, 0xFF, 0xA9, 0x05, 0x0C, 0x02, 0x1D, 0xF0,
	0x0C, 0x02, 0x86, 0xF3, 0xFF, 0x39, 0x05, 0x0C, 0x02, 0x1D, 0xF0, 0x39,
	0x05, 0x0C, 0x02, 0x1D, 0xF0, 0x39, 0x05, 0x0C, 0x02, 0x1D, 0xF0, 0x00,
	0x36, 0x81, 0x00, 0x29, 0x41, 0xCC, 0x25, 0x0C, 0x12, 0x1D, 0xF0, 0x61,
	0x19, 0x29, 0x88, 0x06, 0x3C, 0xCA, 0x88, 0x58, 0x0C, 0x4B, 0xE0, 0x08,
	0x00, 0x2D, 0x0A, 0xCC, 0x2A, 0x0C, 0x42, 0x1D, 0xF0, 0xF2, 0xC1, 0x10,
	0x91, 0x1C, 0x29, 0xA1, 0x1C, 0x29, 0x88, 0x41, 0xB1, 0x19, 0x29, 0xB9,
	0x02, 0xA0, 0x88, 0x73, 0x90, 0x88, 0x63, 0x89, 0x41, 0x89, 0x22, 0xF0,
	0x00, 0x0C, 0x1C, 0xFE, 0x0F, 0x82, 0x01, 0x82, 0x82, 0x0B, 0x04, 0x00,
	0x8F, 0xBD, 0xBF, 0x42, 0x82, 0x0B, 0x05, 0x00, 0x0F, 0x62, 0xA1, 0x42,
	0x82, 0x0B, 0x06, 0x00, 0x0F, 0x4E, 0xA1, 0x42, 0x82, 0x0B, 0x07, 0x00,
	0x8F, 0x23, 0xA1, 0x42, 0x6E, 0x0B, 0x01, 0x00, 0x00, 0x0C, 0x0D, 0x88,
	0x06, 0x39, 0x32, 0x88, 0x58, 0x99, 0x62, 0xE0, 0x08, 0x00, 0xA9, 0x52,
	0x16, 0xAA, 0x06, 0x16, 0xF4, 0x08, 0x92, 0x14, 0x00, 0x92, 0x52, 0x08,
	0x88, 0x06, 0xAD, 0x02, 0x88, 0xF8, 0xB2, 0x21, 0x04, 0xE0, 0x08, 0x00,
	0xC2, 0x92, 0x08, 0xD8, 0x32, 0x0C, 0x03, 0x39, 0xB2, 0x39, 0xC2, 0x39,
	0xD2, 0xD0, 0x90, 0x04, 0x40, 0xAC, 0x01, 0xA0, 0xAC, 0x31, 0x07, 0x6D,
	0x04, 0x0C, 0x13, 0x46, 0x00, 0x00, 0x9C, 0x8A, 0x88, 0x06, 0xBD, 0x03,
	0x88, 0x98, 0xC2, 0xC2, 0x2C, 0xE0, 0x08, 0x00, 0x8C, 0x2A, 0x0C, 0x52,
	0x1D, 0xF0, 0x98, 0x32, 0xC2, 0x92, 0x08, 0x90, 0x90, 0x04, 0x80, 0xAC,
	0x01, 0xA0, 0xAC, 0x31, 0xCC, 0x09, 0x9C, 0xCA, 0x88, 0x06, 0xBD, 0x03,
	0x88, 0x98, 0xC2, 0xC2, 0x30, 0xE0, 0x08, 0x00, 0x8C, 0x6A, 0x0C, 0x52,
	0x1D, 0xF0, 0x0C, 0x42, 0x1D, 0xF0, 0x98, 0x32, 0xC2, 0x92, 0x08, 0x90,
	0x90, 0x04, 0xC0, 0xAC, 0x01, 0xA0, 0xAC, 0x31, 0xCC, 0x09, 0xAC, 0x7A,
	0x88, 0x06, 0xBD, 0x03, 0x88, 0x98, 0xC2, 0xC2, 0x34, 0xE0, 0x08, 0x00,
	0x9C, 0x9A, 0x0C, 0x52, 0x1D, 0xF0, 0x88, 0x06, 0x82, 0x28, 0x10, 0xA8,
	0x01, 0xE0, 0x08, 0x00, 0xA9, 0x11, 0x4B, 0x91, 0x92, 0x19, 0x00, 0x92,
	0x52, 0x08, 0x86, 0xD7, 0xFF, 0x91, 0xD9, 0x28, 0xA8, 0x09, 0xCC, 0xAA,
	0xB8, 0x06, 0xB8, 0x4B, 0xB9, 0x09, 0x29, 0x05, 0x0C, 0x02, 0x1D, 0xF0,
	0x29, 0x05, 0x0C, 0x02, 0x1D, 0xF0, 0x00, 0x00, 0x36, 0x41, 0x00, 0x8C,
	0x62, 0x91, 0xD2, 0x28, 0x88, 0x02, 0x97, 0x18, 0x03, 0x0C, 0x12, 0x1D,
	0xF0, 0xB1, 0xD2, 0x28, 0xA8, 0x62, 0xB9, 0x72, 0xA6, 0x1A, 0x1A, 0x0C,
	0x0B, 0x0C, 0x0A, 0x0C, 0x0C, 0x76, 0x80, 0x0E, 0xE8, 0x52, 0x1B, 0xAA,
	0xBA, 0xEE, 0xC9, 0x0E, 0xD8, 0x62, 0x4B, 0xBB, 0xD7, 0xAA, 0x02, 0x86,
	0xFA, 0xFF, 0xCB, 0x32, 0x41, 0xBE, 0x28, 0xA8, 0xB2, 0x8C, 0x5A, 0x88,
	0x04, 0x88, 0xA8, 0xE0, 0x08, 0x00, 0x4B, 0x22, 0x37, 0x92, 0xEF, 0x0C,
	0x02, 0x1D, 0xF0, 0x00, 0x36, 0xE1, 0x00, 0xA2, 0xC1, 0x3C, 0x59, 0xF1,
	0x16, 0x42, 0x0C, 0x8C, 0xE3, 0x8C, 0xC4, 0x8C, 0xA7, 0xC1, 0xBB, 0x28,
	0xB8, 0x02, 0xC7, 0x1B, 0x07, 0x0C, 0x12, 0x1D, 0xF0, 0x0C, 0x32, 0x1D,
	0xF0, 0xB1, 0xB9, 0x28, 0xC1, 0xB8, 0x28, 0xB0, 0xB5, 0x73, 0xC0, 0xBB,
	0x63, 0xB9, 0xF1, 0xB9, 0x22, 0xA0, 0x00, 0x0C, 0x1C, 0xF9, 0xAF, 0xE0,
	0x0A, 0x22, 0x42, 0x0A, 0x04, 0x00, 0xAF, 0xE0, 0x0A, 0x22, 0x42, 0x0A,
	0x05, 0x00, 0xCF, 0xD4, 0x51, 0x02, 0x42, 0x0A, 0x06, 0x00, 0x8F, 0x1D,
	0xBF, 0x42, 0x42, 0x0A, 0x07, 0x00, 0x0F, 0xE2, 0x21, 0x82, 0x2E, 0x0A,
	0x01, 0x00, 0x00, 0x0F, 0x0D, 0xA8, 0x41, 0xD8, 0x12, 0xC8, 0x32, 0xA7,
	0x1D, 0x11, 0x07, 0xEC, 0x6A, 0x81, 0x9C, 0x28, 0x88, 0x08, 0xAD, 0x02,
	0x88, 0xF8, 0xB2, 0x21, 0x0F, 0xE0, 0x08, 0x00, 0x0C, 0x09, 0x99, 0x07,
	0x16, 0x06, 0x05, 0x52, 0x21, 0x1C, 0xAD, 0x02, 0xBD, 0x03, 0xCD, 0x04,
	0xF2, 0xC1, 0x1C, 0x81, 0x94, 0x28, 0xE8, 0xA2, 0xD8, 0x41, 0xE0, 0xE6,
	0x63, 0x59, 0x01, 0x88, 0x08, 0xE9, 0x91, 0x82, 0x28, 0x15, 0xE0, 0xE0,
	0xF4, 0xE0, 0x08, 0x00, 0x8C, 0x2A, 0x2D, 0x0A, 0x1D, 0xF0, 0x98, 0x71,
	0xA8, 0x91, 0x88, 0x07, 0x30, 0x3A, 0xA0, 0xA0, 0x66, 0xC0, 0x9A, 0x88,
	0x89, 0x07, 0x98, 0x71, 0x60, 0x60, 0xF4, 0x40, 0x49, 0xA0, 0x90, 0x55,
	0xC0, 0x56, 0x96, 0xFB, 0x06, 0x01, 0x00, 0x00, 0x0C, 0x12, 0x1D, 0xF0,
	0x0C, 0x02, 0x1D, 0xF0, 0x8D, 0x0E, 0x88, 0x08, 0x82, 0x28, 0x10, 0xE0,
	0x08, 0x00, 0xB2, 0xC1, 0x18, 0xA9, 0x51, 0xD2, 0x92, 0x08, 0xA2, 0xC1,
	0x14, 0x40, 0x9D, 0x01, 0xA2, 0x1A, 0x00, 0xA2, 0x5B, 0x00, 0xC2, 0x91,
	0x0C, 0x90, 0x9C, 0x31, 0x40, 0xBC, 0x01, 0x80, 0x5C, 0x01, 0x50, 0x5C,
	0x31, 0xB0, 0xBC, 0x31, 0x97, 0x9B, 0x21, 0xC0, 0xAC, 0x01, 0x80, 0xED,
	0x01, 0xE0, 0xEC, 0x31, 0xA0, 0xAC, 0x31, 0xA9, 0x81, 0xE7, 0x95, 0x18,
	0xC0, 0xCD, 0x01, 0xC0, 0xCC, 0x31, 0xC0, 0xCA, 0xC0, 0x16, 0x4C, 0xF4,
	0xA9, 0x81, 0xC6, 0x01, 0x00, 0xC0, 0xDC, 0x01, 0xD0, 0xDC, 0x31, 0xD9,
	0x81, 0xA8, 0xB2, 0x81, 0x6A, 0x28, 0x92, 0xC1, 0x14, 0x82, 0x28, 0x00,
	0x92, 0x19, 0x00, 0x82, 0x28, 0x0C, 0x92, 0x52, 0x08, 0xE0, 0x08, 0x00,
	0x81, 0x65, 0x28, 0x3D, 0xF0, 0x82, 0x28, 0x00, 0x82, 0x28, 0x0A, 0xA2,
	0x22, 0x0B, 0xE0, 0x08, 0x00, 0x81, 0x60, 0x28, 0x88, 0x08, 0xBD, 0x05,
	0x88, 0xC8, 0xA2, 0x22, 0x0C, 0xE0, 0x08, 0x00, 0x81, 0x5D, 0x28, 0x88,
	0x08, 0x58, 0x81, 0x88, 0xA8, 0xA8, 0xC2, 0xE0, 0x08, 0x00, 0x81, 0x59,
	0x28, 0x88, 0x08, 0xBD, 0x05, 0x88, 0xC8, 0xA8, 0xD2, 0xE0, 0x08, 0x00,
	0x81, 0x56, 0x28, 0x88, 0x08, 0x88, 0xA8, 0xA8, 0xD2, 0xE0, 0x08, 0x00,
	0xAD, 0x02, 0xA5, 0xE1, 0xFF, 0x06, 0xB4, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE,
	0xFE, 0xFE, 0xFE, 0xFE, 0x36, 0x21, 0x00, 0x30, 0x72, 0x30, 0x20, 0x61,
	0x60, 0x30, 0x31, 0x60, 0xB6, 0x23, 0x34, 0x60, 0x51, 0x41, 0x37, 0x35,
	0x3A, 0x50, 0xF6, 0x40, 0x40, 0xF3, 0x40, 0x50, 0x44, 0xC0, 0x00, 0x14,
	0x40, 0x00, 0x33, 0xA1, 0x0C, 0x02, 0x76, 0x94, 0x0D, 0x37, 0x36, 0x04,
	0x30, 0x66, 0xC0, 0x1B, 0x22, 0xF0, 0x22, 0x11, 0x30, 0x31, 0x41, 0x37,
	0x36, 0x01, 0x1B, 0x22, 0x20, 0x50, 0x60, 0x70, 0x25, 0xA3, 0x1D, 0xF0,
	0x9C, 0x53, 0x60, 0x20, 0x60, 0x70, 0x26, 0xB3, 0x1D, 0xF0, 0x00, 0x00,
	0x37, 0x36, 0x10, 0x0C, 0x12, 0x7C, 0xF4, 0x70, 0x24, 0xA3, 0x1D, 0xF0,
	0x00, 0x00, 0x00, 0x00, 0x44, 0x49, 0x56, 0x30, 0x0C, 0x02, 0x1D, 0xF0,
	0x00, 0x76, 0x94, 0x09, 0x62, 0x03, 0x00, 0x1B, 0x33, 0x62, 0x45, 0x00,
	0x1B, 0x55, 0x1D, 0xF0, 0xB6, 0x74, 0xED, 0x62, 0x03, 0x00, 0x1B, 0x33,
	0x42, 0xC4, 0xFF, 0x62, 0x45, 0x00, 0x52, 0xC5, 0x01, 0x17, 0x65, 0x27,
	0xB6, 0x64, 0xD9, 0x62, 0x03, 0x00, 0x72, 0x03, 0x01, 0x2B, 0x33, 0x42,
	0xC4, 0xFE, 0x62, 0x45, 0x00, 0x72, 0x45, 0x01, 0x2B, 0x55, 0x86, 0x03,
	0x00, 0x00, 0x00, 0x00, 0x36, 0x21, 0x00, 0x20, 0x52, 0x20, 0x07, 0xE2,
	0xC6, 0x17, 0xE2, 0xD7, 0x40, 0x74, 0x41, 0x82, 0xA0, 0x03, 0x87, 0x83,
	0x5A, 0x76, 0x97, 0x15, 0x68, 0x03, 0x78, 0x13, 0x69, 0x05, 0x68, 0x23,
	0x79, 0x15, 0x78, 0x33, 0x69, 0x25, 0x32, 0xC3, 0x10, 0x79, 0x35, 0x52,
	0xC5, 0x10, 0x37, 0x64, 0x0B, 0x68, 0x03, 0x78, 0x13, 0x8B, 0x33, 0x69,
	0x05, 0x79, 0x15, 0x8B, 0x55, 0x27, 0xE4, 0x07, 0x17, 0xE4, 0x14, 0x07,
	0xE4, 0x21, 0x1D, 0xF0, 0x68, 0x03, 0x4B, 0x33, 0x69, 0x05, 0x4B, 0x55,
	0x17, 0xE4, 0x04, 0x07, 0xE4, 0x11, 0x1D, 0xF0, 0x62, 0x13, 0x00, 0x2B,
	0x33, 0x62, 0x55, 0x00, 0x2B, 0x55, 0x07, 0xE4, 0x02, 0x1D, 0xF0, 0x00,
	0x62, 0x03, 0x00, 0x62, 0x45, 0x00, 0x1D, 0xF0, 0x16, 0xA4, 0xFF, 0x00,
	0x23, 0x40, 0x80, 0xB3, 0x10, 0xB0, 0x33, 0xC0, 0x68, 0x03, 0x76, 0x97,
	0x21, 0x78, 0x13, 0x88, 0x23, 0x60, 0x67, 0x81, 0x69, 0x05, 0x98, 0x33,
	0x70, 0x78, 0x81, 0x79, 0x15, 0x68, 0x43, 0x80, 0x89, 0x81, 0x89, 0x25,
	0x32, 0xC3, 0x10, 0x90, 0x96, 0x81, 0x99, 0x35, 0x52, 0xC5, 0x10, 0x37,
	0x64, 0x15, 0x78, 0x13, 0x88, 0x23, 0x60, 0x67, 0x81, 0x69, 0x05, 0x8B,
	0x33, 0x70, 0x78, 0x81, 0x79, 0x15, 0x52, 0xC5, 0x08, 0x80, 0x68, 0x20,
	0x27, 0x64, 0x0C, 0x78, 0x13, 0x4B, 0x33, 0x60, 0x67, 0x81, 0x69, 0x05,
	0x4B, 0x55, 0x6D, 0x07, 0xBA, 0x33, 0x17, 0xE4, 0x06, 0x07, 0xE4, 0x18,
	0x1D, 0xF0, 0x00, 0x00, 0x62, 0x03, 0x00, 0x72, 0x03, 0x01, 0x2B, 0x33,
	0x62, 0x45, 0x00, 0x72, 0x45, 0x01, 0x2B, 0x55, 0x07, 0xE4, 0x01, 0x1D,
	0xF0, 0x62, 0x03, 0x00, 0x62, 0x45, 0x00, 0x1D, 0xF0, 0x00, 0x00, 0x00,
	0x00, 0x76, 0x94, 0x04, 0x32, 0x45, 0x00, 0x1B, 0x55, 0x1D, 0xF0, 0x00,
	0xB6, 0x84, 0xF1, 0x32, 0x45, 0x00, 0x1B, 0x55, 0x0B, 0x44, 0x17, 0x65,
	0x28, 0xB6, 0x84, 0xE4, 0x32, 0x55, 0x00, 0x2B, 0x55, 0x42, 0xC4, 0xFE,
	0x86, 0x06, 0x00, 0x00, 0x36, 0x21, 0x00, 0x30, 0x30, 0x74, 0x80, 0x73,
	0x11, 0x70, 0x33, 0x20, 0x00, 0x73, 0x11, 0x70, 0x33, 0x20, 0x5D, 0x02,
	0x07, 0xE2, 0xCC, 0x17, 0xE2, 0xD6, 0x40, 0x74, 0x41, 0x76, 0x97, 0x0A,
	0x39, 0x05, 0x39, 0x15, 0x39, 0x25, 0x39, 0x35, 0x52, 0xC5, 0x10, 0x37,
	0x64, 0x06, 0x39, 0x05, 0x39, 0x15, 0x52, 0xC5, 0x08, 0x27, 0x64, 0x03,
	0x39, 0x05, 0x4B, 0x55, 0x17, 0x64, 0x04, 0x32, 0x55, 0x00, 0x2B, 0x55,
	0x07, 0x64, 0x02, 0x32, 0x45, 0x00, 0x1D, 0xF0, 0x00, 0x00, 0x00, 0x00,
	0x1B, 0xCA, 0x83, 0x22,
};

unsigned char suspend_mode[] = {
	0x80, 0x10, 0x00, 0x01
};

#endif /* __A2220_FW_H_ */


