/*
 *  linux/drivers/mmc/host/uhs2i.h - Ultra High Speed II interface driver
 *
 * Header file for Host Controller registers and I/O accessors.
 *
 *  Copyright (C) 2011-2012 NVIDIA Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 */
#ifndef __UHS2I_HW_H
#define __UHS2I_HW_H

/*
 * Controller registers
 */

#define UHS2I_PRESET_DDR50_AND_SDR104	0x74
#define  UHS2I_SDCLK_FREQ_VAL_LOW_SHIFT	0
#define  UHS2I_SDCLK_FREQ_VAL_LOW_MASK	0x000003FF
#define  UHS2I_SDCLK_FREQ_VAL_HIGH_SHIFT	16
#define  UHS2I_SDCLK_FREQ_VAL_HIGH_MASK	0x03FF0000
#define  UHS2I_CLK_GEN_VAL_LOW_SHIFT	10
#define  UHS2I_CLK_GEN_VAL_LOW_MASK	0x00000400
#define  UHS2I_CLK_GEN_VAL_HIGH_SHIFT	26
#define  UHS2I_CLK_GEN_VAL_HIGH_MASK	0x04000000

#define UHS2I_BLOCK_SIZE	0x80
#define  UHS2I_BLOCK_SIZE_SHIFT	0
#define  UHS2I_BLOCK_SIZE_MASK	0x0FFF
#define  UHS2I_SDMA_BUFFER_BOUNDARY_SHIFT	12
#define  UHS2I_SDMA_BUFFER_BOUNDARY_MASK	0x7000

#define UHS2I_BLOCK_COUNT	0x84

#define UHS2I_COMMAND_PACKET_BYTE_3_to_0	0x88
#define UHS2I_COMMAND_PACKET_BYTE_7_to_4	0x8C
#define UHS2I_COMMAND_PACKET_BYTE_11_to_8	0x90
#define UHS2I_COMMAND_PACKET_BYTE_15_to_12	0x94
#define UHS2I_COMMAND_PACKET_BYTE_19_to_16	0x98

#define UHS2I_TRANSFER_MODE_COMMAND	0x9C
#define  UHS2I_DMA_ENABLE	0x00000001
#define  UHS2I_BLOCK_COUNT_ENABLE	0x00000002
#define  UHS2I_DATA_XFER_DIR_WRITE	0x00000010
#define  UHS2I_BYTE_MODE	0x00000020
#define  UHS2I_RES_TYPE_R5	0x00000040
#define  UHS2I_RES_ERR_CHK_ENABLE	0x00000080
#define  UHS2I_RES_INT_ENABLE	0x00000100
#define  UHS2I_EBSY_WAIT	0x00004000
#define  UHS2I_HALF_DUPLEX	0x00008000
#define  UHS2I_DATA_PRESENT	0x00200000
#define  UHS2I_COMMAND_TYPE_SHIFT	22
#define  UHS2I_COMMAND_TYPE_MASK	0x00C00000
#define   UHS2I_COMMAND_NORMAL	0
#define   UHS2I_COMMAND_CM_TRAN_ABORT	1
#define   UHS2I_COMMAND_SD_TRAN_ABORT	2
#define   UHS2I_COMMAND_GO_DORMANT	3
#define  UHS2I_PACKET_LENGTH_SHIFT	24
#define  UHS2I_PACKET_LENGTH_MASK	0x1F000000

#define UHS2I_RESPONSE_PACKET_BYTE_3_to_0 0xA0
#define UHS2I_RESPONSE_PACKET_BYTE_7_to_4 0xA4
#define UHS2I_RESPONSE_PACKET_BYTE_11_to_8 0xA8
#define UHS2I_RESPONSE_PACKET_BYTE_15_to_12 0xAC
#define UHS2I_RESPONSE_PACKET_BYTE_19_to_16 0xB0

#define UHS2I_MSG_SEL	0xB4
#define  UHS2I_MSG_SEL_MASK	0x00000003
#define  UHS2I_LATEST_MSG	0
#define  UHS2I_ONE_MSG_BEFORE	1
#define  UHS2I_TWO_MSG_BEFORE	2
#define  UHS2I_THREE_MSGS_BEFORE	3

#define UHS2I_MSG	0xB8

#define UHS2I_INT_STATUS	0xBC
#define  UHS2I_INT_STATUS_DEVID_SHIFT	0
#define  UHS2I_INT_STATUS_DEVID_MASK	0x0000FFFF
#define  UHS2I_DEV_SEL_SHIFT	16
#define  UHS2I_DEV_SEL_MASK	0x000F0000
#define  UHS2I_INT_MSG_EN	0x00800000
#define  UHS2I_INT_CODE_SHIFT	24
#define  UHS2I_INT_CODE_MASK	0xFF000000

#define UHS2I_SOFT_RST_TIMER_CNTL	0xC0
#define  UHS2I_HOST_FULL_RST	0x00000001
#define  UHS2I_HOST_SD_TRAN_RST	0x00000002
#define  UHS2I_CMD_RES_TIME_OUT_CNT_SHIFT	16
#define  UHS2I_CMD_RES_TIME_OUT_CNT_MASK	0x000F0000
#define  UHS2I_DEAD_LOCK_TIME_OUT_CNT_SHIFT	20
#define  UHS2I_DEAD_LOCK_TIME_OUT_CNT_MASK	0x00F00000

#define UHS2I_HOST_ERR_INT_STATUS	0xC4
#define UHS2I_HOST_ERR_INT_STATUS_EN	0xC8
#define UHS2I_HOST_ERR_INT_SIG_EN	0xCC
#define  UHS2I_INT_HEADER_ERR	0x00000001
#define  UHS2I_INT_RES_PKT_ERR	0x00000002
#define  UHS2I_INT_RETRY_EXP	0x00000004
#define  UHS2I_INT_CRC_ERR	0x00000008
#define  UHS2I_INT_FRAMING_ERR	0x00000010
#define  UHS2I_INT_TID_ERR	0x00000020
#define  UHS2I_INT_UN_RECOV_ERR	0x00000080
#define  UHS2I_INT_ADMA2_3_ERR	0x00008000
#define  UHS2I_INT_CMD_RES_TIME_OUT	0x00010000
#define  UHS2I_INT_DEAD_LOCK_TIME_OUT	0x00020000
#define  UHS2I_INT_VENDOR_SPECIFIC_ERR_SHIFT	27
#define  UHS2I_INT_VENDOR_SPECIFIC_ERR_MASK	0xF8000000

#define UHS2I_SETTINGS_CAPABILITIES_REGS_PTR	0xE0
#define  UHS2I_SETTINGS_PTR_SHIFT	0
#define  UHS2I_SETTINGS_PTR_MASK	0x000000FF
#define  UHS2I_CAPABILITIES_PTR_SHIFT	16
#define  UHS2I_CAPABILITIES_PTR_MASK	0x00FF0000

#define UHS2I_SHARED_BUS_TEST_REGS_PTR	0xE4
#define  UHS2I_TEST_PTR_SHIFT	0
#define  UHS2I_TEST_PTR_MASK	0x000000FF
#define  UHS2I_SHARED_BUS_PTR_SHIFT	16
#define  UHS2I_SHARED_BUS_PTR_MASK	0x00FF0000

#define UHS2I_VENDOR_REGS_PTR	0xE8
#define  UHS2I_VENDOR_PTR_SHIFT	0
#define  UHS2I_VENDOR_PTR_MASK	0x000000FF

#define UHS2I_GEN_SETTINGS	0x130
#define  UHS2I_LOW_POWER_MODE	0x00000001
#define  UHS2I_NUM_OF_LANES_SHIFT	8
#define  UHS2I_NUM_OF_LANES_MASK	0x00000F00

#define UHS2I_PHY_SETTINGS	0x134
#define  UHS2I_PHY_HYBERNATE_EN	0x00008000

#define UHS2I_LINK_TRAN_SETTINGS1	0x138
#define  UHS2I_N_FCU_MASK	0x0000FF00
#define  UHS2I_RETRY_CNT_SHIFT	16
#define  UHS2I_RETRY_CNT_MASK	0x00030000
#define   UHS2I_RETRY_ONE_TIMES	1
#define   UHS2I_RETRY_TWO_TIMES	2
#define   UHS2I_RETRY_THREE_TIMES	3
#define  UHS2I_MAX_BLK_LEN_SHIFT	20
#define  UHS2I_MAX_BLK_LEN_MASK	0xFFF00000

#define UHS2I_LINK_TRAN_SETTINGS2	0x13C
#define  UHS2I_N_DATA_GAP_MASK	0x000000FF

#define UHS2I_GEN_CAPABILITES	0x140
#define  UHS2I_DAP_MASK	0x0000000F
#define  UHS2I_GAP_SHIFT	4
#define  UHS2I_GAP_MASK	0x000000F0
#define  UHS2I_NUM_OF_LANES_SHIFT	8
#define  UHS2I_NUM_OF_LANES_MASK	0x00003F00
#define  UHS2I_32_AND_64_BIT_ADDRESSING	0x00004000
#define  UHS2I_REMOVABLE_EMBEDDED_SHIFT	16
#define  UHS2I_REMOVABLE_EMBEDDED_MASK	0x00030000
#define   UHS2I_REMOVABLE_CARD	0
#define   UHS2I_EMBEDDED_DEVICES	1
#define   UHS2I_EMBEDDED_REMOVABLE_CARD	2
#define  UHS2I_NUM_DEV_SUPPORTED_SHIFT	18
#define  UHS2I_NUM_DEV_SUPPORTED_MASK	0x003C0000
#define  UHS2I_BUS_TOPOLOGY_SHIFT	22
#define  UHS2I_BUS_TOPOLOGY_MASK	0x00C00000
#define   UHS2I_P2P	0
#define   UHS2I_RING	1
#define   UHS2I_HUB	2
#define   UHS2I_HUB_IN_RING	3

#define UHS2I_PHY_CAPABILITIES	0x144
#define  UHS2I_PHY_REV_MASK	0X0000003F
#define  UHS2I_SPEED_RANGE_SHIFT	6
#define  UHS2I_SPEED_RANGE_MASK	0x000000C0
#define  UHS2I_N_LSS_SYN_SHIFT	16
#define  UHS2I_N_LSS_SYN_MASK	0x000F0000
#define  UHS2I_N_LSS_DIR_SHIFT	20
#define  UHS2I_N_LSS_DIR_MASK	0x00F00000

#define UHS2I_LINK_TRAN_CAPABILITIES1	0x148
#define  UHS2I_LINK_REV_MASK	0x0000003F
#define  UHS2I_CAN_N_FCU_SHIFT	8
#define  UHS2I_CAN_N_FCU_MASK	0x0000FF00
#define  UHS2I_CAN_MAX_BLOCK_LENGTH_SHIFT	20
#define  UHS2I_CAN_MAX_BLOCK_LENGTH_MASK	0xFFF00000

#define UHS2I_LINK_TRAN_CAPABILITIES2	0x14C
#define  UHS2I_CAN_N_DAT_GAP_MASK	0x000000FF

#define UHS2I_FORCE_EVENT_ERR_INT	0x150

#endif /* __UHS2I_HW_H */
