/*
 * drivers/video/tegra/host/gk20a/hw_sim_gk20a.h
 *
 * Copyright (c) 2012, NVIDIA Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

 /*
  * Function naming determines intended use:
  *
  *     <x>_r(void) : Returns the offset for register <x>.
  *
  *     <x>_w(void) : Returns the word offset for word (4 byte) element <x>.
  *
  *     <x>_<y>_s(void) : Returns size of field <y> of register <x> in bits.
  *
  *     <x>_<y>_f(u32 v) : Returns a value based on 'v' which has been shifted
  *         and masked to place it at field <y> of register <x>.  This value
  *         can be |'d with others to produce a full register value for
  *         register <x>.
  *
  *     <x>_<y>_m(void) : Returns a mask for field <y> of register <x>.  This
  *         value can be ~'d and then &'d to clear the value of field <y> for
  *         register <x>.
  *
  *     <x>_<y>_<z>_f(void) : Returns the constant value <z> after being shifted
  *         to place it at field <y> of register <x>.  This value can be |'d
  *         with others to produce a full register value for <x>.
  *
  *     <x>_<y>_v(u32 r) : Returns the value of field <y> from a full register
  *         <x> value 'r' after being shifted to place its LSB at bit 0.
  *         This value is suitable for direct comparison with other unshifted
  *         values appropriate for use in field <y> of register <x>.
  *
  *     <x>_<y>_<z>_v(void) : Returns the constant value for <z> defined for
  *         field <y> of register <x>.  This value is suitable for direct
  *         comparison with unshifted values appropriate for use in field <y>
  *         of register <x>.
  */

#ifndef __hw_sim_gk20a_h__
#define __hw_sim_gk20a_h__
/*This file is autogenerated.  Do not edit. */

static inline u32 sim_send_ring_r(void)
{
	return 0x00000000;
}
static inline u32 sim_send_ring_target_s(void)
{
	return 2;
}
static inline u32 sim_send_ring_target_f(u32 v)
{
	return (v & 0x3) << 0;
}
static inline u32 sim_send_ring_target_m(void)
{
	return 0x3 << 0;
}
static inline u32 sim_send_ring_target_v(u32 r)
{
	return (r >> 0) & 0x3;
}
static inline u32 sim_send_ring_target_phys_init_v(void)
{
	return 0x00000001;
}
static inline u32 sim_send_ring_target_phys_init_f(void)
{
	return 0x1;
}
static inline u32 sim_send_ring_target_phys__init_v(void)
{
	return 0x00000001;
}
static inline u32 sim_send_ring_target_phys__init_f(void)
{
	return 0x1;
}
static inline u32 sim_send_ring_target_phys__prod_v(void)
{
	return 0x00000001;
}
static inline u32 sim_send_ring_target_phys__prod_f(void)
{
	return 0x1;
}
static inline u32 sim_send_ring_target_phys_nvm_v(void)
{
	return 0x00000001;
}
static inline u32 sim_send_ring_target_phys_nvm_f(void)
{
	return 0x1;
}
static inline u32 sim_send_ring_target_phys_pci_v(void)
{
	return 0x00000002;
}
static inline u32 sim_send_ring_target_phys_pci_f(void)
{
	return 0x2;
}
static inline u32 sim_send_ring_target_phys_pci_coherent_v(void)
{
	return 0x00000003;
}
static inline u32 sim_send_ring_target_phys_pci_coherent_f(void)
{
	return 0x3;
}
static inline u32 sim_send_ring_status_s(void)
{
	return 1;
}
static inline u32 sim_send_ring_status_f(u32 v)
{
	return (v & 0x1) << 3;
}
static inline u32 sim_send_ring_status_m(void)
{
	return 0x1 << 3;
}
static inline u32 sim_send_ring_status_v(u32 r)
{
	return (r >> 3) & 0x1;
}
static inline u32 sim_send_ring_status_init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_send_ring_status_init_f(void)
{
	return 0x0;
}
static inline u32 sim_send_ring_status__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_send_ring_status__init_f(void)
{
	return 0x0;
}
static inline u32 sim_send_ring_status__prod_v(void)
{
	return 0x00000000;
}
static inline u32 sim_send_ring_status__prod_f(void)
{
	return 0x0;
}
static inline u32 sim_send_ring_status_invalid_v(void)
{
	return 0x00000000;
}
static inline u32 sim_send_ring_status_invalid_f(void)
{
	return 0x0;
}
static inline u32 sim_send_ring_status_valid_v(void)
{
	return 0x00000001;
}
static inline u32 sim_send_ring_status_valid_f(void)
{
	return 0x8;
}
static inline u32 sim_send_ring_size_s(void)
{
	return 2;
}
static inline u32 sim_send_ring_size_f(u32 v)
{
	return (v & 0x3) << 4;
}
static inline u32 sim_send_ring_size_m(void)
{
	return 0x3 << 4;
}
static inline u32 sim_send_ring_size_v(u32 r)
{
	return (r >> 4) & 0x3;
}
static inline u32 sim_send_ring_size_init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_send_ring_size_init_f(void)
{
	return 0x0;
}
static inline u32 sim_send_ring_size__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_send_ring_size__init_f(void)
{
	return 0x0;
}
static inline u32 sim_send_ring_size__prod_v(void)
{
	return 0x00000000;
}
static inline u32 sim_send_ring_size__prod_f(void)
{
	return 0x0;
}
static inline u32 sim_send_ring_size_4kb_v(void)
{
	return 0x00000000;
}
static inline u32 sim_send_ring_size_4kb_f(void)
{
	return 0x0;
}
static inline u32 sim_send_ring_size_8kb_v(void)
{
	return 0x00000001;
}
static inline u32 sim_send_ring_size_8kb_f(void)
{
	return 0x10;
}
static inline u32 sim_send_ring_size_12kb_v(void)
{
	return 0x00000002;
}
static inline u32 sim_send_ring_size_12kb_f(void)
{
	return 0x20;
}
static inline u32 sim_send_ring_size_16kb_v(void)
{
	return 0x00000003;
}
static inline u32 sim_send_ring_size_16kb_f(void)
{
	return 0x30;
}
static inline u32 sim_send_ring_gp_in_ring_s(void)
{
	return 1;
}
static inline u32 sim_send_ring_gp_in_ring_f(u32 v)
{
	return (v & 0x1) << 11;
}
static inline u32 sim_send_ring_gp_in_ring_m(void)
{
	return 0x1 << 11;
}
static inline u32 sim_send_ring_gp_in_ring_v(u32 r)
{
	return (r >> 11) & 0x1;
}
static inline u32 sim_send_ring_gp_in_ring__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_send_ring_gp_in_ring__init_f(void)
{
	return 0x0;
}
static inline u32 sim_send_ring_gp_in_ring__prod_v(void)
{
	return 0x00000000;
}
static inline u32 sim_send_ring_gp_in_ring__prod_f(void)
{
	return 0x0;
}
static inline u32 sim_send_ring_gp_in_ring_no_v(void)
{
	return 0x00000000;
}
static inline u32 sim_send_ring_gp_in_ring_no_f(void)
{
	return 0x0;
}
static inline u32 sim_send_ring_gp_in_ring_yes_v(void)
{
	return 0x00000001;
}
static inline u32 sim_send_ring_gp_in_ring_yes_f(void)
{
	return 0x800;
}
static inline u32 sim_send_ring_addr_lo_s(void)
{
	return 20;
}
static inline u32 sim_send_ring_addr_lo_f(u32 v)
{
	return (v & 0xfffff) << 12;
}
static inline u32 sim_send_ring_addr_lo_m(void)
{
	return 0xfffff << 12;
}
static inline u32 sim_send_ring_addr_lo_v(u32 r)
{
	return (r >> 12) & 0xfffff;
}
static inline u32 sim_send_ring_addr_lo__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_send_ring_addr_lo__init_f(void)
{
	return 0x0;
}
static inline u32 sim_send_ring_addr_lo__prod_v(void)
{
	return 0x00000000;
}
static inline u32 sim_send_ring_addr_lo__prod_f(void)
{
	return 0x0;
}
static inline u32 sim_send_ring_hi_r(void)
{
	return 0x00000004;
}
static inline u32 sim_send_ring_hi_addr_s(void)
{
	return 20;
}
static inline u32 sim_send_ring_hi_addr_f(u32 v)
{
	return (v & 0xfffff) << 0;
}
static inline u32 sim_send_ring_hi_addr_m(void)
{
	return 0xfffff << 0;
}
static inline u32 sim_send_ring_hi_addr_v(u32 r)
{
	return (r >> 0) & 0xfffff;
}
static inline u32 sim_send_ring_hi_addr__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_send_ring_hi_addr__init_f(void)
{
	return 0x0;
}
static inline u32 sim_send_ring_hi_addr__prod_v(void)
{
	return 0x00000000;
}
static inline u32 sim_send_ring_hi_addr__prod_f(void)
{
	return 0x0;
}
static inline u32 sim_send_put_r(void)
{
	return 0x00000008;
}
static inline u32 sim_send_put_pointer_s(void)
{
	return 29;
}
static inline u32 sim_send_put_pointer_f(u32 v)
{
	return (v & 0x1fffffff) << 3;
}
static inline u32 sim_send_put_pointer_m(void)
{
	return 0x1fffffff << 3;
}
static inline u32 sim_send_put_pointer_v(u32 r)
{
	return (r >> 3) & 0x1fffffff;
}
static inline u32 sim_send_get_r(void)
{
	return 0x0000000c;
}
static inline u32 sim_send_get_pointer_s(void)
{
	return 29;
}
static inline u32 sim_send_get_pointer_f(u32 v)
{
	return (v & 0x1fffffff) << 3;
}
static inline u32 sim_send_get_pointer_m(void)
{
	return 0x1fffffff << 3;
}
static inline u32 sim_send_get_pointer_v(u32 r)
{
	return (r >> 3) & 0x1fffffff;
}
static inline u32 sim_recv_ring_r(void)
{
	return 0x00000010;
}
static inline u32 sim_recv_ring_target_s(void)
{
	return 2;
}
static inline u32 sim_recv_ring_target_f(u32 v)
{
	return (v & 0x3) << 0;
}
static inline u32 sim_recv_ring_target_m(void)
{
	return 0x3 << 0;
}
static inline u32 sim_recv_ring_target_v(u32 r)
{
	return (r >> 0) & 0x3;
}
static inline u32 sim_recv_ring_target_phys_init_v(void)
{
	return 0x00000001;
}
static inline u32 sim_recv_ring_target_phys_init_f(void)
{
	return 0x1;
}
static inline u32 sim_recv_ring_target_phys__init_v(void)
{
	return 0x00000001;
}
static inline u32 sim_recv_ring_target_phys__init_f(void)
{
	return 0x1;
}
static inline u32 sim_recv_ring_target_phys__prod_v(void)
{
	return 0x00000001;
}
static inline u32 sim_recv_ring_target_phys__prod_f(void)
{
	return 0x1;
}
static inline u32 sim_recv_ring_target_phys_nvm_v(void)
{
	return 0x00000001;
}
static inline u32 sim_recv_ring_target_phys_nvm_f(void)
{
	return 0x1;
}
static inline u32 sim_recv_ring_target_phys_pci_v(void)
{
	return 0x00000002;
}
static inline u32 sim_recv_ring_target_phys_pci_f(void)
{
	return 0x2;
}
static inline u32 sim_recv_ring_target_phys_pci_coherent_v(void)
{
	return 0x00000003;
}
static inline u32 sim_recv_ring_target_phys_pci_coherent_f(void)
{
	return 0x3;
}
static inline u32 sim_recv_ring_status_s(void)
{
	return 1;
}
static inline u32 sim_recv_ring_status_f(u32 v)
{
	return (v & 0x1) << 3;
}
static inline u32 sim_recv_ring_status_m(void)
{
	return 0x1 << 3;
}
static inline u32 sim_recv_ring_status_v(u32 r)
{
	return (r >> 3) & 0x1;
}
static inline u32 sim_recv_ring_status_init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_recv_ring_status_init_f(void)
{
	return 0x0;
}
static inline u32 sim_recv_ring_status__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_recv_ring_status__init_f(void)
{
	return 0x0;
}
static inline u32 sim_recv_ring_status__prod_v(void)
{
	return 0x00000000;
}
static inline u32 sim_recv_ring_status__prod_f(void)
{
	return 0x0;
}
static inline u32 sim_recv_ring_status_invalid_v(void)
{
	return 0x00000000;
}
static inline u32 sim_recv_ring_status_invalid_f(void)
{
	return 0x0;
}
static inline u32 sim_recv_ring_status_valid_v(void)
{
	return 0x00000001;
}
static inline u32 sim_recv_ring_status_valid_f(void)
{
	return 0x8;
}
static inline u32 sim_recv_ring_size_s(void)
{
	return 2;
}
static inline u32 sim_recv_ring_size_f(u32 v)
{
	return (v & 0x3) << 4;
}
static inline u32 sim_recv_ring_size_m(void)
{
	return 0x3 << 4;
}
static inline u32 sim_recv_ring_size_v(u32 r)
{
	return (r >> 4) & 0x3;
}
static inline u32 sim_recv_ring_size_init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_recv_ring_size_init_f(void)
{
	return 0x0;
}
static inline u32 sim_recv_ring_size__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_recv_ring_size__init_f(void)
{
	return 0x0;
}
static inline u32 sim_recv_ring_size__prod_v(void)
{
	return 0x00000000;
}
static inline u32 sim_recv_ring_size__prod_f(void)
{
	return 0x0;
}
static inline u32 sim_recv_ring_size_4kb_v(void)
{
	return 0x00000000;
}
static inline u32 sim_recv_ring_size_4kb_f(void)
{
	return 0x0;
}
static inline u32 sim_recv_ring_size_8kb_v(void)
{
	return 0x00000001;
}
static inline u32 sim_recv_ring_size_8kb_f(void)
{
	return 0x10;
}
static inline u32 sim_recv_ring_size_12kb_v(void)
{
	return 0x00000002;
}
static inline u32 sim_recv_ring_size_12kb_f(void)
{
	return 0x20;
}
static inline u32 sim_recv_ring_size_16kb_v(void)
{
	return 0x00000003;
}
static inline u32 sim_recv_ring_size_16kb_f(void)
{
	return 0x30;
}
static inline u32 sim_recv_ring_gp_in_ring_s(void)
{
	return 1;
}
static inline u32 sim_recv_ring_gp_in_ring_f(u32 v)
{
	return (v & 0x1) << 11;
}
static inline u32 sim_recv_ring_gp_in_ring_m(void)
{
	return 0x1 << 11;
}
static inline u32 sim_recv_ring_gp_in_ring_v(u32 r)
{
	return (r >> 11) & 0x1;
}
static inline u32 sim_recv_ring_gp_in_ring__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_recv_ring_gp_in_ring__init_f(void)
{
	return 0x0;
}
static inline u32 sim_recv_ring_gp_in_ring__prod_v(void)
{
	return 0x00000000;
}
static inline u32 sim_recv_ring_gp_in_ring__prod_f(void)
{
	return 0x0;
}
static inline u32 sim_recv_ring_gp_in_ring_no_v(void)
{
	return 0x00000000;
}
static inline u32 sim_recv_ring_gp_in_ring_no_f(void)
{
	return 0x0;
}
static inline u32 sim_recv_ring_gp_in_ring_yes_v(void)
{
	return 0x00000001;
}
static inline u32 sim_recv_ring_gp_in_ring_yes_f(void)
{
	return 0x800;
}
static inline u32 sim_recv_ring_addr_lo_s(void)
{
	return 20;
}
static inline u32 sim_recv_ring_addr_lo_f(u32 v)
{
	return (v & 0xfffff) << 12;
}
static inline u32 sim_recv_ring_addr_lo_m(void)
{
	return 0xfffff << 12;
}
static inline u32 sim_recv_ring_addr_lo_v(u32 r)
{
	return (r >> 12) & 0xfffff;
}
static inline u32 sim_recv_ring_addr_lo__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_recv_ring_addr_lo__init_f(void)
{
	return 0x0;
}
static inline u32 sim_recv_ring_addr_lo__prod_v(void)
{
	return 0x00000000;
}
static inline u32 sim_recv_ring_addr_lo__prod_f(void)
{
	return 0x0;
}
static inline u32 sim_recv_ring_hi_r(void)
{
	return 0x00000014;
}
static inline u32 sim_recv_ring_hi_addr_s(void)
{
	return 20;
}
static inline u32 sim_recv_ring_hi_addr_f(u32 v)
{
	return (v & 0xfffff) << 0;
}
static inline u32 sim_recv_ring_hi_addr_m(void)
{
	return 0xfffff << 0;
}
static inline u32 sim_recv_ring_hi_addr_v(u32 r)
{
	return (r >> 0) & 0xfffff;
}
static inline u32 sim_recv_ring_hi_addr__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_recv_ring_hi_addr__init_f(void)
{
	return 0x0;
}
static inline u32 sim_recv_ring_hi_addr__prod_v(void)
{
	return 0x00000000;
}
static inline u32 sim_recv_ring_hi_addr__prod_f(void)
{
	return 0x0;
}
static inline u32 sim_recv_put_r(void)
{
	return 0x00000018;
}
static inline u32 sim_recv_put_pointer_s(void)
{
	return 11;
}
static inline u32 sim_recv_put_pointer_f(u32 v)
{
	return (v & 0x7ff) << 3;
}
static inline u32 sim_recv_put_pointer_m(void)
{
	return 0x7ff << 3;
}
static inline u32 sim_recv_put_pointer_v(u32 r)
{
	return (r >> 3) & 0x7ff;
}
static inline u32 sim_recv_get_r(void)
{
	return 0x0000001c;
}
static inline u32 sim_recv_get_pointer_s(void)
{
	return 11;
}
static inline u32 sim_recv_get_pointer_f(u32 v)
{
	return (v & 0x7ff) << 3;
}
static inline u32 sim_recv_get_pointer_m(void)
{
	return 0x7ff << 3;
}
static inline u32 sim_recv_get_pointer_v(u32 r)
{
	return (r >> 3) & 0x7ff;
}
static inline u32 sim_config_r(void)
{
	return 0x00000020;
}
static inline u32 sim_config_mode_s(void)
{
	return 1;
}
static inline u32 sim_config_mode_f(u32 v)
{
	return (v & 0x1) << 0;
}
static inline u32 sim_config_mode_m(void)
{
	return 0x1 << 0;
}
static inline u32 sim_config_mode_v(u32 r)
{
	return (r >> 0) & 0x1;
}
static inline u32 sim_config_mode_disabled_v(void)
{
	return 0x00000000;
}
static inline u32 sim_config_mode_disabled_f(void)
{
	return 0x0;
}
static inline u32 sim_config_mode_enabled_v(void)
{
	return 0x00000001;
}
static inline u32 sim_config_mode_enabled_f(void)
{
	return 0x1;
}
static inline u32 sim_config_channels_s(void)
{
	return 7;
}
static inline u32 sim_config_channels_f(u32 v)
{
	return (v & 0x7f) << 1;
}
static inline u32 sim_config_channels_m(void)
{
	return 0x7f << 1;
}
static inline u32 sim_config_channels_v(u32 r)
{
	return (r >> 1) & 0x7f;
}
static inline u32 sim_config_channels_none_v(void)
{
	return 0x00000000;
}
static inline u32 sim_config_channels_none_f(void)
{
	return 0x0;
}
static inline u32 sim_config_cached_only_s(void)
{
	return 1;
}
static inline u32 sim_config_cached_only_f(u32 v)
{
	return (v & 0x1) << 8;
}
static inline u32 sim_config_cached_only_m(void)
{
	return 0x1 << 8;
}
static inline u32 sim_config_cached_only_v(u32 r)
{
	return (r >> 8) & 0x1;
}
static inline u32 sim_config_cached_only_disabled_v(void)
{
	return 0x00000000;
}
static inline u32 sim_config_cached_only_disabled_f(void)
{
	return 0x0;
}
static inline u32 sim_config_cached_only_enabled_v(void)
{
	return 0x00000001;
}
static inline u32 sim_config_cached_only_enabled_f(void)
{
	return 0x100;
}
static inline u32 sim_config_validity_s(void)
{
	return 2;
}
static inline u32 sim_config_validity_f(u32 v)
{
	return (v & 0x3) << 9;
}
static inline u32 sim_config_validity_m(void)
{
	return 0x3 << 9;
}
static inline u32 sim_config_validity_v(u32 r)
{
	return (r >> 9) & 0x3;
}
static inline u32 sim_config_validity__init_v(void)
{
	return 0x00000001;
}
static inline u32 sim_config_validity__init_f(void)
{
	return 0x200;
}
static inline u32 sim_config_validity_valid_v(void)
{
	return 0x00000001;
}
static inline u32 sim_config_validity_valid_f(void)
{
	return 0x200;
}
static inline u32 sim_config_simulation_s(void)
{
	return 2;
}
static inline u32 sim_config_simulation_f(u32 v)
{
	return (v & 0x3) << 12;
}
static inline u32 sim_config_simulation_m(void)
{
	return 0x3 << 12;
}
static inline u32 sim_config_simulation_v(u32 r)
{
	return (r >> 12) & 0x3;
}
static inline u32 sim_config_simulation_disabled_v(void)
{
	return 0x00000000;
}
static inline u32 sim_config_simulation_disabled_f(void)
{
	return 0x0;
}
static inline u32 sim_config_simulation_fmodel_v(void)
{
	return 0x00000001;
}
static inline u32 sim_config_simulation_fmodel_f(void)
{
	return 0x1000;
}
static inline u32 sim_config_simulation_rtlsim_v(void)
{
	return 0x00000002;
}
static inline u32 sim_config_simulation_rtlsim_f(void)
{
	return 0x2000;
}
static inline u32 sim_config_secondary_display_s(void)
{
	return 1;
}
static inline u32 sim_config_secondary_display_f(u32 v)
{
	return (v & 0x1) << 14;
}
static inline u32 sim_config_secondary_display_m(void)
{
	return 0x1 << 14;
}
static inline u32 sim_config_secondary_display_v(u32 r)
{
	return (r >> 14) & 0x1;
}
static inline u32 sim_config_secondary_display_disabled_v(void)
{
	return 0x00000000;
}
static inline u32 sim_config_secondary_display_disabled_f(void)
{
	return 0x0;
}
static inline u32 sim_config_secondary_display_enabled_v(void)
{
	return 0x00000001;
}
static inline u32 sim_config_secondary_display_enabled_f(void)
{
	return 0x4000;
}
static inline u32 sim_config_num_heads_s(void)
{
	return 8;
}
static inline u32 sim_config_num_heads_f(u32 v)
{
	return (v & 0xff) << 17;
}
static inline u32 sim_config_num_heads_m(void)
{
	return 0xff << 17;
}
static inline u32 sim_config_num_heads_v(u32 r)
{
	return (r >> 17) & 0xff;
}
static inline u32 sim_event_ring_r(void)
{
	return 0x00000030;
}
static inline u32 sim_event_ring_target_s(void)
{
	return 2;
}
static inline u32 sim_event_ring_target_f(u32 v)
{
	return (v & 0x3) << 0;
}
static inline u32 sim_event_ring_target_m(void)
{
	return 0x3 << 0;
}
static inline u32 sim_event_ring_target_v(u32 r)
{
	return (r >> 0) & 0x3;
}
static inline u32 sim_event_ring_target_phys_init_v(void)
{
	return 0x00000001;
}
static inline u32 sim_event_ring_target_phys_init_f(void)
{
	return 0x1;
}
static inline u32 sim_event_ring_target_phys__init_v(void)
{
	return 0x00000001;
}
static inline u32 sim_event_ring_target_phys__init_f(void)
{
	return 0x1;
}
static inline u32 sim_event_ring_target_phys__prod_v(void)
{
	return 0x00000001;
}
static inline u32 sim_event_ring_target_phys__prod_f(void)
{
	return 0x1;
}
static inline u32 sim_event_ring_target_phys_nvm_v(void)
{
	return 0x00000001;
}
static inline u32 sim_event_ring_target_phys_nvm_f(void)
{
	return 0x1;
}
static inline u32 sim_event_ring_target_phys_pci_v(void)
{
	return 0x00000002;
}
static inline u32 sim_event_ring_target_phys_pci_f(void)
{
	return 0x2;
}
static inline u32 sim_event_ring_target_phys_pci_coherent_v(void)
{
	return 0x00000003;
}
static inline u32 sim_event_ring_target_phys_pci_coherent_f(void)
{
	return 0x3;
}
static inline u32 sim_event_ring_status_s(void)
{
	return 1;
}
static inline u32 sim_event_ring_status_f(u32 v)
{
	return (v & 0x1) << 3;
}
static inline u32 sim_event_ring_status_m(void)
{
	return 0x1 << 3;
}
static inline u32 sim_event_ring_status_v(u32 r)
{
	return (r >> 3) & 0x1;
}
static inline u32 sim_event_ring_status_init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_event_ring_status_init_f(void)
{
	return 0x0;
}
static inline u32 sim_event_ring_status__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_event_ring_status__init_f(void)
{
	return 0x0;
}
static inline u32 sim_event_ring_status__prod_v(void)
{
	return 0x00000000;
}
static inline u32 sim_event_ring_status__prod_f(void)
{
	return 0x0;
}
static inline u32 sim_event_ring_status_invalid_v(void)
{
	return 0x00000000;
}
static inline u32 sim_event_ring_status_invalid_f(void)
{
	return 0x0;
}
static inline u32 sim_event_ring_status_valid_v(void)
{
	return 0x00000001;
}
static inline u32 sim_event_ring_status_valid_f(void)
{
	return 0x8;
}
static inline u32 sim_event_ring_size_s(void)
{
	return 2;
}
static inline u32 sim_event_ring_size_f(u32 v)
{
	return (v & 0x3) << 4;
}
static inline u32 sim_event_ring_size_m(void)
{
	return 0x3 << 4;
}
static inline u32 sim_event_ring_size_v(u32 r)
{
	return (r >> 4) & 0x3;
}
static inline u32 sim_event_ring_size_init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_event_ring_size_init_f(void)
{
	return 0x0;
}
static inline u32 sim_event_ring_size__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_event_ring_size__init_f(void)
{
	return 0x0;
}
static inline u32 sim_event_ring_size__prod_v(void)
{
	return 0x00000000;
}
static inline u32 sim_event_ring_size__prod_f(void)
{
	return 0x0;
}
static inline u32 sim_event_ring_size_4kb_v(void)
{
	return 0x00000000;
}
static inline u32 sim_event_ring_size_4kb_f(void)
{
	return 0x0;
}
static inline u32 sim_event_ring_size_8kb_v(void)
{
	return 0x00000001;
}
static inline u32 sim_event_ring_size_8kb_f(void)
{
	return 0x10;
}
static inline u32 sim_event_ring_size_12kb_v(void)
{
	return 0x00000002;
}
static inline u32 sim_event_ring_size_12kb_f(void)
{
	return 0x20;
}
static inline u32 sim_event_ring_size_16kb_v(void)
{
	return 0x00000003;
}
static inline u32 sim_event_ring_size_16kb_f(void)
{
	return 0x30;
}
static inline u32 sim_event_ring_gp_in_ring_s(void)
{
	return 1;
}
static inline u32 sim_event_ring_gp_in_ring_f(u32 v)
{
	return (v & 0x1) << 11;
}
static inline u32 sim_event_ring_gp_in_ring_m(void)
{
	return 0x1 << 11;
}
static inline u32 sim_event_ring_gp_in_ring_v(u32 r)
{
	return (r >> 11) & 0x1;
}
static inline u32 sim_event_ring_gp_in_ring__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_event_ring_gp_in_ring__init_f(void)
{
	return 0x0;
}
static inline u32 sim_event_ring_gp_in_ring__prod_v(void)
{
	return 0x00000000;
}
static inline u32 sim_event_ring_gp_in_ring__prod_f(void)
{
	return 0x0;
}
static inline u32 sim_event_ring_gp_in_ring_no_v(void)
{
	return 0x00000000;
}
static inline u32 sim_event_ring_gp_in_ring_no_f(void)
{
	return 0x0;
}
static inline u32 sim_event_ring_gp_in_ring_yes_v(void)
{
	return 0x00000001;
}
static inline u32 sim_event_ring_gp_in_ring_yes_f(void)
{
	return 0x800;
}
static inline u32 sim_event_ring_addr_lo_s(void)
{
	return 20;
}
static inline u32 sim_event_ring_addr_lo_f(u32 v)
{
	return (v & 0xfffff) << 12;
}
static inline u32 sim_event_ring_addr_lo_m(void)
{
	return 0xfffff << 12;
}
static inline u32 sim_event_ring_addr_lo_v(u32 r)
{
	return (r >> 12) & 0xfffff;
}
static inline u32 sim_event_ring_addr_lo__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_event_ring_addr_lo__init_f(void)
{
	return 0x0;
}
static inline u32 sim_event_ring_addr_lo__prod_v(void)
{
	return 0x00000000;
}
static inline u32 sim_event_ring_addr_lo__prod_f(void)
{
	return 0x0;
}
static inline u32 sim_event_ring_hi_v(void)
{
	return 0x00000034;
}
static inline u32 sim_event_ring_hi_addr_s(void)
{
	return 20;
}
static inline u32 sim_event_ring_hi_addr_f(u32 v)
{
	return (v & 0xfffff) << 0;
}
static inline u32 sim_event_ring_hi_addr_m(void)
{
	return 0xfffff << 0;
}
static inline u32 sim_event_ring_hi_addr_v(u32 r)
{
	return (r >> 0) & 0xfffff;
}
static inline u32 sim_event_ring_hi_addr__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_event_ring_hi_addr__init_f(void)
{
	return 0x0;
}
static inline u32 sim_event_ring_hi_addr__prod_v(void)
{
	return 0x00000000;
}
static inline u32 sim_event_ring_hi_addr__prod_f(void)
{
	return 0x0;
}
static inline u32 sim_event_put_r(void)
{
	return 0x00000038;
}
static inline u32 sim_event_put_pointer_s(void)
{
	return 30;
}
static inline u32 sim_event_put_pointer_f(u32 v)
{
	return (v & 0x3fffffff) << 2;
}
static inline u32 sim_event_put_pointer_m(void)
{
	return 0x3fffffff << 2;
}
static inline u32 sim_event_put_pointer_v(u32 r)
{
	return (r >> 2) & 0x3fffffff;
}
static inline u32 sim_event_get_r(void)
{
	return 0x0000003c;
}
static inline u32 sim_event_get_pointer_s(void)
{
	return 30;
}
static inline u32 sim_event_get_pointer_f(u32 v)
{
	return (v & 0x3fffffff) << 2;
}
static inline u32 sim_event_get_pointer_m(void)
{
	return 0x3fffffff << 2;
}
static inline u32 sim_event_get_pointer_v(u32 r)
{
	return (r >> 2) & 0x3fffffff;
}
static inline u32 sim_status_r(void)
{
	return 0x00000028;
}
static inline u32 sim_status_send_put_s(void)
{
	return 1;
}
static inline u32 sim_status_send_put_f(u32 v)
{
	return (v & 0x1) << 0;
}
static inline u32 sim_status_send_put_m(void)
{
	return 0x1 << 0;
}
static inline u32 sim_status_send_put_v(u32 r)
{
	return (r >> 0) & 0x1;
}
static inline u32 sim_status_send_put__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_status_send_put__init_f(void)
{
	return 0x0;
}
static inline u32 sim_status_send_put_idle_v(void)
{
	return 0x00000000;
}
static inline u32 sim_status_send_put_idle_f(void)
{
	return 0x0;
}
static inline u32 sim_status_send_put_pending_v(void)
{
	return 0x00000001;
}
static inline u32 sim_status_send_put_pending_f(void)
{
	return 0x1;
}
static inline u32 sim_status_send_get_s(void)
{
	return 1;
}
static inline u32 sim_status_send_get_f(u32 v)
{
	return (v & 0x1) << 1;
}
static inline u32 sim_status_send_get_m(void)
{
	return 0x1 << 1;
}
static inline u32 sim_status_send_get_v(u32 r)
{
	return (r >> 1) & 0x1;
}
static inline u32 sim_status_send_get__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_status_send_get__init_f(void)
{
	return 0x0;
}
static inline u32 sim_status_send_get_idle_v(void)
{
	return 0x00000000;
}
static inline u32 sim_status_send_get_idle_f(void)
{
	return 0x0;
}
static inline u32 sim_status_send_get_pending_v(void)
{
	return 0x00000001;
}
static inline u32 sim_status_send_get_pending_f(void)
{
	return 0x2;
}
static inline u32 sim_status_send_get_clear_v(void)
{
	return 0x00000001;
}
static inline u32 sim_status_send_get_clear_f(void)
{
	return 0x2;
}
static inline u32 sim_status_recv_put_s(void)
{
	return 1;
}
static inline u32 sim_status_recv_put_f(u32 v)
{
	return (v & 0x1) << 2;
}
static inline u32 sim_status_recv_put_m(void)
{
	return 0x1 << 2;
}
static inline u32 sim_status_recv_put_v(u32 r)
{
	return (r >> 2) & 0x1;
}
static inline u32 sim_status_recv_put__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_status_recv_put__init_f(void)
{
	return 0x0;
}
static inline u32 sim_status_recv_put_idle_v(void)
{
	return 0x00000000;
}
static inline u32 sim_status_recv_put_idle_f(void)
{
	return 0x0;
}
static inline u32 sim_status_recv_put_pending_v(void)
{
	return 0x00000001;
}
static inline u32 sim_status_recv_put_pending_f(void)
{
	return 0x4;
}
static inline u32 sim_status_recv_put_clear_v(void)
{
	return 0x00000001;
}
static inline u32 sim_status_recv_put_clear_f(void)
{
	return 0x4;
}
static inline u32 sim_status_recv_get_s(void)
{
	return 1;
}
static inline u32 sim_status_recv_get_f(u32 v)
{
	return (v & 0x1) << 3;
}
static inline u32 sim_status_recv_get_m(void)
{
	return 0x1 << 3;
}
static inline u32 sim_status_recv_get_v(u32 r)
{
	return (r >> 3) & 0x1;
}
static inline u32 sim_status_recv_get__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_status_recv_get__init_f(void)
{
	return 0x0;
}
static inline u32 sim_status_recv_get_idle_v(void)
{
	return 0x00000000;
}
static inline u32 sim_status_recv_get_idle_f(void)
{
	return 0x0;
}
static inline u32 sim_status_recv_get_pending_v(void)
{
	return 0x00000001;
}
static inline u32 sim_status_recv_get_pending_f(void)
{
	return 0x8;
}
static inline u32 sim_status_event_put_s(void)
{
	return 1;
}
static inline u32 sim_status_event_put_f(u32 v)
{
	return (v & 0x1) << 4;
}
static inline u32 sim_status_event_put_m(void)
{
	return 0x1 << 4;
}
static inline u32 sim_status_event_put_v(u32 r)
{
	return (r >> 4) & 0x1;
}
static inline u32 sim_status_event_put__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_status_event_put__init_f(void)
{
	return 0x0;
}
static inline u32 sim_status_event_put_idle_v(void)
{
	return 0x00000000;
}
static inline u32 sim_status_event_put_idle_f(void)
{
	return 0x0;
}
static inline u32 sim_status_event_put_pending_v(void)
{
	return 0x00000001;
}
static inline u32 sim_status_event_put_pending_f(void)
{
	return 0x10;
}
static inline u32 sim_status_event_put_clear_v(void)
{
	return 0x00000001;
}
static inline u32 sim_status_event_put_clear_f(void)
{
	return 0x10;
}
static inline u32 sim_status_event_get_s(void)
{
	return 1;
}
static inline u32 sim_status_event_get_f(u32 v)
{
	return (v & 0x1) << 5;
}
static inline u32 sim_status_event_get_m(void)
{
	return 0x1 << 5;
}
static inline u32 sim_status_event_get_v(u32 r)
{
	return (r >> 5) & 0x1;
}
static inline u32 sim_status_event_get__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_status_event_get__init_f(void)
{
	return 0x0;
}
static inline u32 sim_status_event_get_idle_v(void)
{
	return 0x00000000;
}
static inline u32 sim_status_event_get_idle_f(void)
{
	return 0x0;
}
static inline u32 sim_status_event_get_pending_v(void)
{
	return 0x00000001;
}
static inline u32 sim_status_event_get_pending_f(void)
{
	return 0x20;
}
static inline u32 sim_control_r(void)
{
	return 0x0000002c;
}
static inline u32 sim_control_send_put_s(void)
{
	return 1;
}
static inline u32 sim_control_send_put_f(u32 v)
{
	return (v & 0x1) << 0;
}
static inline u32 sim_control_send_put_m(void)
{
	return 0x1 << 0;
}
static inline u32 sim_control_send_put_v(u32 r)
{
	return (r >> 0) & 0x1;
}
static inline u32 sim_control_send_put__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_control_send_put__init_f(void)
{
	return 0x0;
}
static inline u32 sim_control_send_put_disabled_v(void)
{
	return 0x00000000;
}
static inline u32 sim_control_send_put_disabled_f(void)
{
	return 0x0;
}
static inline u32 sim_control_send_put_enabled_v(void)
{
	return 0x00000001;
}
static inline u32 sim_control_send_put_enabled_f(void)
{
	return 0x1;
}
static inline u32 sim_control_send_get_s(void)
{
	return 1;
}
static inline u32 sim_control_send_get_f(u32 v)
{
	return (v & 0x1) << 1;
}
static inline u32 sim_control_send_get_m(void)
{
	return 0x1 << 1;
}
static inline u32 sim_control_send_get_v(u32 r)
{
	return (r >> 1) & 0x1;
}
static inline u32 sim_control_send_get__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_control_send_get__init_f(void)
{
	return 0x0;
}
static inline u32 sim_control_send_get_disabled_v(void)
{
	return 0x00000000;
}
static inline u32 sim_control_send_get_disabled_f(void)
{
	return 0x0;
}
static inline u32 sim_control_send_get_enabled_v(void)
{
	return 0x00000001;
}
static inline u32 sim_control_send_get_enabled_f(void)
{
	return 0x2;
}
static inline u32 sim_control_recv_put_s(void)
{
	return 1;
}
static inline u32 sim_control_recv_put_f(u32 v)
{
	return (v & 0x1) << 2;
}
static inline u32 sim_control_recv_put_m(void)
{
	return 0x1 << 2;
}
static inline u32 sim_control_recv_put_v(u32 r)
{
	return (r >> 2) & 0x1;
}
static inline u32 sim_control_recv_put__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_control_recv_put__init_f(void)
{
	return 0x0;
}
static inline u32 sim_control_recv_put_disabled_v(void)
{
	return 0x00000000;
}
static inline u32 sim_control_recv_put_disabled_f(void)
{
	return 0x0;
}
static inline u32 sim_control_recv_put_enabled_v(void)
{
	return 0x00000001;
}
static inline u32 sim_control_recv_put_enabled_f(void)
{
	return 0x4;
}
static inline u32 sim_control_recv_get_s(void)
{
	return 1;
}
static inline u32 sim_control_recv_get_f(u32 v)
{
	return (v & 0x1) << 3;
}
static inline u32 sim_control_recv_get_m(void)
{
	return 0x1 << 3;
}
static inline u32 sim_control_recv_get_v(u32 r)
{
	return (r >> 3) & 0x1;
}
static inline u32 sim_control_recv_get__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_control_recv_get__init_f(void)
{
	return 0x0;
}
static inline u32 sim_control_recv_get_disabled_v(void)
{
	return 0x00000000;
}
static inline u32 sim_control_recv_get_disabled_f(void)
{
	return 0x0;
}
static inline u32 sim_control_recv_get_enabled_v(void)
{
	return 0x00000001;
}
static inline u32 sim_control_recv_get_enabled_f(void)
{
	return 0x8;
}
static inline u32 sim_control_event_put_s(void)
{
	return 1;
}
static inline u32 sim_control_event_put_f(u32 v)
{
	return (v & 0x1) << 4;
}
static inline u32 sim_control_event_put_m(void)
{
	return 0x1 << 4;
}
static inline u32 sim_control_event_put_v(u32 r)
{
	return (r >> 4) & 0x1;
}
static inline u32 sim_control_event_put__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_control_event_put__init_f(void)
{
	return 0x0;
}
static inline u32 sim_control_event_put_disabled_v(void)
{
	return 0x00000000;
}
static inline u32 sim_control_event_put_disabled_f(void)
{
	return 0x0;
}
static inline u32 sim_control_event_put_enabled_v(void)
{
	return 0x00000001;
}
static inline u32 sim_control_event_put_enabled_f(void)
{
	return 0x10;
}
static inline u32 sim_control_event_get_s(void)
{
	return 1;
}
static inline u32 sim_control_event_get_f(u32 v)
{
	return (v & 0x1) << 5;
}
static inline u32 sim_control_event_get_m(void)
{
	return 0x1 << 5;
}
static inline u32 sim_control_event_get_v(u32 r)
{
	return (r >> 5) & 0x1;
}
static inline u32 sim_control_event_get__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_control_event_get__init_f(void)
{
	return 0x0;
}
static inline u32 sim_control_event_get_disabled_v(void)
{
	return 0x00000000;
}
static inline u32 sim_control_event_get_disabled_f(void)
{
	return 0x0;
}
static inline u32 sim_control_event_get_enabled_v(void)
{
	return 0x00000001;
}
static inline u32 sim_control_event_get_enabled_f(void)
{
	return 0x20;
}
static inline u32 sim_dma_r(void)
{
	return 0x00000000;
}
static inline u32 sim_dma_target_s(void)
{
	return 2;
}
static inline u32 sim_dma_target_f(u32 v)
{
	return (v & 0x3) << 0;
}
static inline u32 sim_dma_target_m(void)
{
	return 0x3 << 0;
}
static inline u32 sim_dma_target_v(u32 r)
{
	return (r >> 0) & 0x3;
}
static inline u32 sim_dma_target_phys_init_v(void)
{
	return 0x00000001;
}
static inline u32 sim_dma_target_phys_init_f(void)
{
	return 0x1;
}
static inline u32 sim_dma_target_phys__init_v(void)
{
	return 0x00000001;
}
static inline u32 sim_dma_target_phys__init_f(void)
{
	return 0x1;
}
static inline u32 sim_dma_target_phys__prod_v(void)
{
	return 0x00000001;
}
static inline u32 sim_dma_target_phys__prod_f(void)
{
	return 0x1;
}
static inline u32 sim_dma_target_phys_nvm_v(void)
{
	return 0x00000001;
}
static inline u32 sim_dma_target_phys_nvm_f(void)
{
	return 0x1;
}
static inline u32 sim_dma_target_phys_pci_v(void)
{
	return 0x00000002;
}
static inline u32 sim_dma_target_phys_pci_f(void)
{
	return 0x2;
}
static inline u32 sim_dma_target_phys_pci_coherent_v(void)
{
	return 0x00000003;
}
static inline u32 sim_dma_target_phys_pci_coherent_f(void)
{
	return 0x3;
}
static inline u32 sim_dma_status_s(void)
{
	return 1;
}
static inline u32 sim_dma_status_f(u32 v)
{
	return (v & 0x1) << 3;
}
static inline u32 sim_dma_status_m(void)
{
	return 0x1 << 3;
}
static inline u32 sim_dma_status_v(u32 r)
{
	return (r >> 3) & 0x1;
}
static inline u32 sim_dma_status_init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_dma_status_init_f(void)
{
	return 0x0;
}
static inline u32 sim_dma_status__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_dma_status__init_f(void)
{
	return 0x0;
}
static inline u32 sim_dma_status__prod_v(void)
{
	return 0x00000000;
}
static inline u32 sim_dma_status__prod_f(void)
{
	return 0x0;
}
static inline u32 sim_dma_status_invalid_v(void)
{
	return 0x00000000;
}
static inline u32 sim_dma_status_invalid_f(void)
{
	return 0x0;
}
static inline u32 sim_dma_status_valid_v(void)
{
	return 0x00000001;
}
static inline u32 sim_dma_status_valid_f(void)
{
	return 0x8;
}
static inline u32 sim_dma_size_s(void)
{
	return 2;
}
static inline u32 sim_dma_size_f(u32 v)
{
	return (v & 0x3) << 4;
}
static inline u32 sim_dma_size_m(void)
{
	return 0x3 << 4;
}
static inline u32 sim_dma_size_v(u32 r)
{
	return (r >> 4) & 0x3;
}
static inline u32 sim_dma_size_init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_dma_size_init_f(void)
{
	return 0x0;
}
static inline u32 sim_dma_size__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_dma_size__init_f(void)
{
	return 0x0;
}
static inline u32 sim_dma_size__prod_v(void)
{
	return 0x00000000;
}
static inline u32 sim_dma_size__prod_f(void)
{
	return 0x0;
}
static inline u32 sim_dma_size_4kb_v(void)
{
	return 0x00000000;
}
static inline u32 sim_dma_size_4kb_f(void)
{
	return 0x0;
}
static inline u32 sim_dma_size_8kb_v(void)
{
	return 0x00000001;
}
static inline u32 sim_dma_size_8kb_f(void)
{
	return 0x10;
}
static inline u32 sim_dma_size_12kb_v(void)
{
	return 0x00000002;
}
static inline u32 sim_dma_size_12kb_f(void)
{
	return 0x20;
}
static inline u32 sim_dma_size_16kb_v(void)
{
	return 0x00000003;
}
static inline u32 sim_dma_size_16kb_f(void)
{
	return 0x30;
}
static inline u32 sim_dma_addr_lo_s(void)
{
	return 20;
}
static inline u32 sim_dma_addr_lo_f(u32 v)
{
	return (v & 0xfffff) << 12;
}
static inline u32 sim_dma_addr_lo_m(void)
{
	return 0xfffff << 12;
}
static inline u32 sim_dma_addr_lo_v(u32 r)
{
	return (r >> 12) & 0xfffff;
}
static inline u32 sim_dma_addr_lo__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_dma_addr_lo__init_f(void)
{
	return 0x0;
}
static inline u32 sim_dma_addr_lo__prod_v(void)
{
	return 0x00000000;
}
static inline u32 sim_dma_addr_lo__prod_f(void)
{
	return 0x0;
}
static inline u32 sim_dma_hi_r(void)
{
	return 0x00000004;
}
static inline u32 sim_dma_hi_addr_s(void)
{
	return 20;
}
static inline u32 sim_dma_hi_addr_f(u32 v)
{
	return (v & 0xfffff) << 0;
}
static inline u32 sim_dma_hi_addr_m(void)
{
	return 0xfffff << 0;
}
static inline u32 sim_dma_hi_addr_v(u32 r)
{
	return (r >> 0) & 0xfffff;
}
static inline u32 sim_dma_hi_addr__init_v(void)
{
	return 0x00000000;
}
static inline u32 sim_dma_hi_addr__init_f(void)
{
	return 0x0;
}
static inline u32 sim_dma_hi_addr__prod_v(void)
{
	return 0x00000000;
}
static inline u32 sim_dma_hi_addr__prod_f(void)
{
	return 0x0;
}
static inline u32 sim_msg_signature_r(void)
{
	return 0x00000000;
}
static inline u32 sim_msg_signature_valid_v(void)
{
	return 0x43505256;
}
static inline u32 sim_msg_length_r(void)
{
	return 0x00000004;
}
static inline u32 sim_msg_function_r(void)
{
	return 0x00000008;
}
static inline u32 sim_msg_function_sim_escape_read_v(void)
{
	return 0x00000023;
}
static inline u32 sim_msg_function_sim_escape_write_v(void)
{
	return 0x00000024;
}
static inline u32 sim_msg_result_r(void)
{
	return 0x0000000c;
}
static inline u32 sim_msg_result_success_v(void)
{
	return 0x00000000;
}
static inline u32 sim_msg_result_rpc_pending_v(void)
{
	return 0xFFFFFFFF;
}
static inline u32 sim_msg_sequence_r(void)
{
	return 0x00000010;
}
static inline u32 sim_msg_spare_r(void)
{
	return 0x00000014;
}
static inline u32 sim_msg_spare__init_v(void)
{
	return 0x00000000;
}

#endif /* __hw_sim_gk20a_h__ */
