/*
 * linux/arch/arm/mach-tegra/include/mach/pinmux-t14.h
 *
 * Copyright (C) 2012 NVIDIA Corporation.
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef __MACH_TEGRA_PINMUX_T14_H
#define __MACH_TEGRA_PINMUX_T14_H

#define TEGRA_PINMUX_HAS_IO_DIRECTION	1

void tegra14x_default_pinmux(void);

enum tegra_pingroup {
	TEGRA_PINGROUP_SDMMC1_CLK,
	TEGRA_PINGROUP_SDMMC1_CMD,
	TEGRA_PINGROUP_SDMMC1_DAT3,
	TEGRA_PINGROUP_SDMMC1_DAT2,
	TEGRA_PINGROUP_SDMMC1_DAT1,
	TEGRA_PINGROUP_SDMMC1_DAT0,
	TEGRA_PINGROUP_DDC_SCL,
	TEGRA_PINGROUP_DDC_SDA,
	TEGRA_PINGROUP_UART2_RXD,
	TEGRA_PINGROUP_UART2_TXD,
	TEGRA_PINGROUP_UART2_RTS_N,
	TEGRA_PINGROUP_UART2_CTS_N,
	TEGRA_PINGROUP_UART3_TXD,
	TEGRA_PINGROUP_UART3_RXD,
	TEGRA_PINGROUP_UART3_CTS_N,
	TEGRA_PINGROUP_UART3_RTS_N,
	TEGRA_PINGROUP_GEN2_I2C_SDA,
	TEGRA_PINGROUP_GEN2_I2C_SCL,
	TEGRA_PINGROUP_SDMMC4_CLK,
	TEGRA_PINGROUP_SDMMC4_CMD,
	TEGRA_PINGROUP_SDMMC4_DAT0,
	TEGRA_PINGROUP_SDMMC4_DAT1,
	TEGRA_PINGROUP_SDMMC4_DAT2,
	TEGRA_PINGROUP_SDMMC4_DAT3,
	TEGRA_PINGROUP_SDMMC4_DAT4,
	TEGRA_PINGROUP_SDMMC4_DAT5,
	TEGRA_PINGROUP_SDMMC4_DAT6,
	TEGRA_PINGROUP_SDMMC4_DAT7,
	TEGRA_PINGROUP_CAM_I2C_SCL,
	TEGRA_PINGROUP_CAM_I2C_SDA,
	TEGRA_PINGROUP_JTAG_RTCK,
	TEGRA_PINGROUP_PWR_I2C_SCL,
	TEGRA_PINGROUP_PWR_I2C_SDA,
	TEGRA_PINGROUP_KB_ROW0,
	TEGRA_PINGROUP_KB_ROW1,
	TEGRA_PINGROUP_KB_ROW2,
	TEGRA_PINGROUP_KB_COL0,
	TEGRA_PINGROUP_KB_COL1,
	TEGRA_PINGROUP_KB_COL2,
	TEGRA_PINGROUP_RF_CLK_REQ,
	TEGRA_PINGROUP_SOC_PWR_REQ,
	TEGRA_PINGROUP_CPU_PWR_REQ,
	TEGRA_PINGROUP_PWR_INT_N,
	TEGRA_PINGROUP_CLK_32K_IN,
	TEGRA_PINGROUP_OWR,
	TEGRA_PINGROUP_DAP1_FS,
	TEGRA_PINGROUP_DAP1_DIN,
	TEGRA_PINGROUP_DAP1_DOUT,
	TEGRA_PINGROUP_DAP1_SCLK,
	TEGRA_PINGROUP_CLK1_OUT,
	TEGRA_PINGROUP_DAP2_FS,
	TEGRA_PINGROUP_DAP2_DIN,
	TEGRA_PINGROUP_DAP2_DOUT,
	TEGRA_PINGROUP_DAP2_SCLK,
	TEGRA_PINGROUP_SPI2_MOSI,
	TEGRA_PINGROUP_SPI2_MISO,
	TEGRA_PINGROUP_SPI2_CS0_N,
	TEGRA_PINGROUP_SPI2_SCK,
	TEGRA_PINGROUP_SPI2_CS1_N,
	TEGRA_PINGROUP_SPI2_CS2_N,
	TEGRA_PINGROUP_SDMMC3_CLK,
	TEGRA_PINGROUP_SDMMC3_CMD,
	TEGRA_PINGROUP_SDMMC3_DAT0,
	TEGRA_PINGROUP_SDMMC3_DAT1,
	TEGRA_PINGROUP_SDMMC3_DAT2,
	TEGRA_PINGROUP_SDMMC3_DAT3,
	TEGRA_PINGROUP_RESET_OUT_N,
	TEGRA_PINGROUP_ALS_PROX_INT_L,
	TEGRA_PINGROUP_AP_GPS_EN,
	TEGRA_PINGROUP_AP_GPS_RST,
	TEGRA_PINGROUP_AP_WAKE_BT,
	TEGRA_PINGROUP_AP_WIFI_EN,
	TEGRA_PINGROUP_AP_WIFI_RST,
	TEGRA_PINGROUP_BT_RESET_L,
	TEGRA_PINGROUP_BT_WAKE_AP,
	TEGRA_PINGROUP_DAP5_DIN,
	TEGRA_PINGROUP_DAP5_DOUT,
	TEGRA_PINGROUP_DAP5_FS,
	TEGRA_PINGROUP_DAP5_SCLK,
	TEGRA_PINGROUP_DCA_LPM,
	TEGRA_PINGROUP_DCA_LSC,
	TEGRA_PINGROUP_DCA_LSPII,
	TEGRA_PINGROUP_DCA_LVS,
	TEGRA_PINGROUP_DMIC0_CLK,
	TEGRA_PINGROUP_DMIC0_DATA,
	TEGRA_PINGROUP_DMIC1_CLK,
	TEGRA_PINGROUP_DMIC1_DATA,
	TEGRA_PINGROUP_GPS_AP_INT,
	TEGRA_PINGROUP_AP_READY,
	TEGRA_PINGROUP_HDMI_CEC,
	TEGRA_PINGROUP_I2C1_SCL,
	TEGRA_PINGROUP_I2C1_SDA,
	TEGRA_PINGROUP_I2C6_SCL,
	TEGRA_PINGROUP_I2C6_SDA,
	TEGRA_PINGROUP_MODEM_WAKE_AP,
	TEGRA_PINGROUP_MOTION_INT_L,
	TEGRA_PINGROUP_NFC_DATA_EN,
	TEGRA_PINGROUP_NFC_EN,
	TEGRA_PINGROUP_NFC_INT_L,
	TEGRA_PINGROUP_SPI3_CS0_N,
	TEGRA_PINGROUP_SPI3_CS1_N,
	TEGRA_PINGROUP_SPI3_MISO,
	TEGRA_PINGROUP_SPI3_MOSI,
	TEGRA_PINGROUP_SPI3_SCK,
	TEGRA_PINGROUP_TOUCH_INT_L,
	TEGRA_PINGROUP_TOUCH_RESET_L,
	TEGRA_PINGROUP_GPIO_PO0,
	TEGRA_PINGROUP_GPIO_PO1,
	TEGRA_PINGROUP_GPIO_PO2,
	TEGRA_PINGROUP_GPIO_PO3,
	TEGRA_PINGROUP_CAM1_MCLK,
	TEGRA_PINGROUP_CAM2_MCLK,
	TEGRA_PINGROUP_GPIO_PS0,
	TEGRA_PINGROUP_GPIO_PS1,
	TEGRA_PINGROUP_GPIO_PS2,
	TEGRA_PINGROUP_GPIO_PS3,
	TEGRA_PINGROUP_GPIO_PS4,
	TEGRA_PINGROUP_GPIO_PS5,
	TEGRA_PINGROUP_DDR0_A0,
	TEGRA_PINGROUP_DDR0_A1,
	TEGRA_PINGROUP_DDR0_A2,
	TEGRA_PINGROUP_DDR0_A3,
	TEGRA_PINGROUP_UART1_RXD,
	TEGRA_PINGROUP_UART1_TXD,
	TEGRA_PINGROUP_UART1_RTS_N,
	TEGRA_PINGROUP_UART1_CTS_N,
	TEGRA_PINGROUP_GPIO_PO4,
	TEGRA_PINGROUP_GPIO_PO5,
	TEGRA_PINGROUP_GPIO_PO6,
	TEGRA_PINGROUP_PG_OC,
	TEGRA_PINGROUP_BCL,
	TEGRA_MAX_PINGROUP,
};

enum tegra_drive_pingroup {
	TEGRA_DRIVE_PINGROUP_AO1 = 0,
	TEGRA_DRIVE_PINGROUP_AO2,
	TEGRA_DRIVE_PINGROUP_CDEV1,
	TEGRA_DRIVE_PINGROUP_CDEV2,
	TEGRA_DRIVE_PINGROUP_CSUS,
	TEGRA_DRIVE_PINGROUP_DAP1,
	TEGRA_DRIVE_PINGROUP_DAP2,
	TEGRA_DRIVE_PINGROUP_DBG,
	TEGRA_DRIVE_PINGROUP_SDIO3,
	TEGRA_DRIVE_PINGROUP_UART2,
	TEGRA_DRIVE_PINGROUP_UART3,
	TEGRA_DRIVE_PINGROUP_PAD,
	TEGRA_DRIVE_PINGROUP_SDIO1,
	TEGRA_DRIVE_PINGROUP_DDC,
	TEGRA_DRIVE_PINGROUP_GMA,
	TEGRA_DRIVE_PINGROUP_GME,
	TEGRA_DRIVE_PINGROUP_OWR,
	TEGRA_DRIVE_PINGROUP_UAD,
	TEGRA_DRIVE_PINGROUP_CEC,
	TEGRA_DRIVE_PINGROUP_DAP5,
	TEGRA_DRIVE_PINGROUP_DMIC0,
	TEGRA_DRIVE_PINGROUP_DMIC1,
	TEGRA_DRIVE_PINGROUP_AO3,
	TEGRA_DRIVE_PINGROUP_SPI2,
	TEGRA_DRIVE_PINGROUP_AO0,
	TEGRA_DRIVE_PINGROUP_DCA,
	TEGRA_DRIVE_PINGROUP_SPI3,
	TEGRA_MAX_DRIVE_PINGROUP,
};

#endif
