/*
 * Copyright (c) 2013-2014, NVIDIA CORPORATION.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307, USA
 */

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/platform_data/tegra_emc_pdata.h>

#include "board.h"
#include "board-ardbeg.h"
#include "tegra-board-id.h"
#include "tegra12_emc.h"
#include "devices.h"

static struct tegra12_emc_table norrin_emc_table[] = {
	{
		0x19,       /* V6.0.4 */
		"04_12750_NoCfgVersion_V6.0.4_V1.1", /* DVFS table version */
		12750,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x4000003e, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000000, /* EMC_RC */
			0x00000003, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000000, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000060, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000018, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000005, /* EMC_TXSR */
			0x00000005, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000064, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x106aa298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000007, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f2f3, /* EMC_CFG_PIPE */
			0x800001c5, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x40040001, /* MC_EMEM_ARB_CFG */
			0x8000000a, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0502, /* MC_EMEM_ARB_DA_COVERS */
			0x77e30303, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000007, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		57820,      /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"04_20400_NoCfgVersion_V6.0.4_V1.1", /* DVFS table version */
		20400,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000026, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000000, /* EMC_RC */
			0x00000005, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000000, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x0000009a, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000026, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000006, /* EMC_TXSR */
			0x00000006, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x000000a0, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x106aa298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x0000000b, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f2f3, /* EMC_CFG_PIPE */
			0x8000023a, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x40020001, /* MC_EMEM_ARB_CFG */
			0x80000012, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0502, /* MC_EMEM_ARB_DA_COVERS */
			0x76230303, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x0000000a, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		35610,      /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"04_40800_NoCfgVersion_V6.0.4_V1.1", /* DVFS table version */
		40800,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000012, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000001, /* EMC_RC */
			0x0000000a, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000001, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000134, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x0000004d, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000008, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000000c, /* EMC_TXSR */
			0x0000000c, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x0000013f, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x106aa298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000015, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f2f3, /* EMC_CFG_PIPE */
			0x80000370, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0xa0000001, /* MC_EMEM_ARB_CFG */
			0x80000017, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0502, /* MC_EMEM_ARB_DA_COVERS */
			0x74a30303, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000014, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		20850,      /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"04_68000_NoCfgVersion_V6.0.4_V1.1", /* DVFS table version */
		68000,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x4000000a, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000003, /* EMC_RC */
			0x00000011, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000202, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000080, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x0000000f, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000013, /* EMC_TXSR */
			0x00000013, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000001, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000213, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x106aa298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000022, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f2f3, /* EMC_CFG_PIPE */
			0x8000050e, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x00000001, /* MC_EMEM_ARB_CFG */
			0x8000001e, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0502, /* MC_EMEM_ARB_DA_COVERS */
			0x74230403, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000021, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00b0, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ec, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ec, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00e90049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00a3, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ef, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ef, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ee00ef, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		10720,      /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"04_102000_NoCfgVersion_V6.0.4_V1.1", /* DVFS table version */
		102000,     /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000006, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000004, /* EMC_RC */
			0x0000001a, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000003, /* EMC_RAS */
			0x00000001, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000001, /* EMC_RD_RCD */
			0x00000001, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000304, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000000c1, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000018, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000001c, /* EMC_TXSR */
			0x0000001c, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000003, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x0000031c, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x106aa298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000033, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f2f3, /* EMC_CFG_PIPE */
			0x80000713, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x08000001, /* MC_EMEM_ARB_CFG */
			0x80000026, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000003, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0503, /* MC_EMEM_ARB_DA_COVERS */
			0x73c30504, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000031, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff0075, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff009d, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff009d, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x009b0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ad, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00c6, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00d6, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x0000009f, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x0000009f, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x009f00a0, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		6890,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"04_204000_NoCfgVersion_V6.0.4_V1.1", /* DVFS table version */
		204000,     /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000002, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000009, /* EMC_RC */
			0x00000035, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000006, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000005, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000004, /* EMC_EINPUT */
			0x00000006, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000003, /* EMC_QRST */
			0x0000000d, /* EMC_QSAFE */
			0x0000000f, /* EMC_RDV */
			0x00000011, /* EMC_RDV_MASK */
			0x00000607, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000181, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000032, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000038, /* EMC_TXSR */
			0x00000038, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000007, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000638, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x106aa298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00008000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00008000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00090000, /* EMC_DLL_XFORM_DQ0 */
			0x00090000, /* EMC_DLL_XFORM_DQ1 */
			0x00090000, /* EMC_DLL_XFORM_DQ2 */
			0x00090000, /* EMC_DLL_XFORM_DQ3 */
			0x00009000, /* EMC_DLL_XFORM_DQ4 */
			0x00009000, /* EMC_DLL_XFORM_DQ5 */
			0x00009000, /* EMC_DLL_XFORM_DQ6 */
			0x00009000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000707, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000066, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000d2b3, /* EMC_CFG_PIPE */
			0x80000d22, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x01000003, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000004, /* MC_EMEM_ARB_TIMING_RC */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000004, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06040203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0504, /* MC_EMEM_ARB_DA_COVERS */
			0x73840a05, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000062, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00af, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff004f, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00af, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff004f, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x004e0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080057, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0063, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff0036, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff006b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000050, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000050, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510050, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00c6, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x0000088d, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		3420,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"04_300000_NoCfgVersion_V6.0.4_V1.1", /* DVFS table version */
		300000,     /* SDRAM frequency */
		820,        /* min voltage */
		820,        /* gpu min voltage */
		"pllc_out0", /* clock source id */
		0x20000002, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000000d, /* EMC_RC */
			0x0000004d, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000009, /* EMC_RAS */
			0x00000003, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x00000009, /* EMC_W2P */
			0x00000003, /* EMC_RD_RCD */
			0x00000003, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000002, /* EMC_EINPUT */
			0x00000007, /* EMC_EINPUT_DURATION */
			0x00020000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000001, /* EMC_QRST */
			0x0000000e, /* EMC_QSAFE */
			0x00000010, /* EMC_RDV */
			0x00000012, /* EMC_RDV_MASK */
			0x000008e4, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000239, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000008, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x0000004b, /* EMC_AR2PDEN */
			0x0000000e, /* EMC_RW2PDEN */
			0x00000052, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000009, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000924, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x104ab098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00030000, /* EMC_DLL_XFORM_DQS0 */
			0x00030000, /* EMC_DLL_XFORM_DQS1 */
			0x00030000, /* EMC_DLL_XFORM_DQS2 */
			0x00030000, /* EMC_DLL_XFORM_DQS3 */
			0x00030000, /* EMC_DLL_XFORM_DQS4 */
			0x00030000, /* EMC_DLL_XFORM_DQS5 */
			0x00030000, /* EMC_DLL_XFORM_DQS6 */
			0x00030000, /* EMC_DLL_XFORM_DQS7 */
			0x00030000, /* EMC_DLL_XFORM_DQS8 */
			0x00030000, /* EMC_DLL_XFORM_DQS9 */
			0x00030000, /* EMC_DLL_XFORM_DQS10 */
			0x00030000, /* EMC_DLL_XFORM_DQS11 */
			0x00030000, /* EMC_DLL_XFORM_DQS12 */
			0x00030000, /* EMC_DLL_XFORM_DQS13 */
			0x00030000, /* EMC_DLL_XFORM_DQS14 */
			0x00030000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00098000, /* EMC_DLL_XFORM_ADDR0 */
			0x00098000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00098000, /* EMC_DLL_XFORM_ADDR3 */
			0x00098000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00040000, /* EMC_DLL_XFORM_DQ0 */
			0x00040000, /* EMC_DLL_XFORM_DQ1 */
			0x00040000, /* EMC_DLL_XFORM_DQ2 */
			0x00040000, /* EMC_DLL_XFORM_DQ3 */
			0x00004000, /* EMC_DLL_XFORM_DQ4 */
			0x00004000, /* EMC_DLL_XFORM_DQ5 */
			0x00004000, /* EMC_DLL_XFORM_DQ6 */
			0x00004000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x01231339, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000505, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000096, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x0173000e, /* EMC_MRS_WAIT_CNT */
			0x0173000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x000052a3, /* EMC_CFG_PIPE */
			0x800012d7, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x08000004, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RP */
			0x00000007, /* MC_EMEM_ARB_TIMING_RC */
			0x00000004, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000005, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06040202, /* MC_EMEM_ARB_DA_TURNS */
			0x000b0607, /* MC_EMEM_ARB_DA_COVERS */
			0x77450e08, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000004, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000090, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00350049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008003b, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0043, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff002d, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510036, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff0087, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73340000, /* EMC_CFG */
		0x000008d5, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000321, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200000, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		2680,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"04_396000_NoCfgVersion_V6.0.4_V1.1", /* DVFS table version */
		396000,     /* SDRAM frequency */
		850,        /* min voltage */
		850,        /* gpu min voltage */
		"pllm_out0", /* clock source id */
		0x00000002, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000011, /* EMC_RC */
			0x00000066, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x0000000c, /* EMC_RAS */
			0x00000004, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000004, /* EMC_RD_RCD */
			0x00000004, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000001, /* EMC_EINPUT */
			0x00000008, /* EMC_EINPUT_DURATION */
			0x00020000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000000, /* EMC_QRST */
			0x0000000f, /* EMC_QSAFE */
			0x00000010, /* EMC_RDV */
			0x00000012, /* EMC_RDV_MASK */
			0x00000bd1, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000002f4, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000008, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000063, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000006c, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x0000000d, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000c11, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x104ab098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00030000, /* EMC_DLL_XFORM_DQS0 */
			0x00030000, /* EMC_DLL_XFORM_DQS1 */
			0x00030000, /* EMC_DLL_XFORM_DQS2 */
			0x00030000, /* EMC_DLL_XFORM_DQS3 */
			0x00030000, /* EMC_DLL_XFORM_DQS4 */
			0x00030000, /* EMC_DLL_XFORM_DQS5 */
			0x00030000, /* EMC_DLL_XFORM_DQS6 */
			0x00030000, /* EMC_DLL_XFORM_DQS7 */
			0x00030000, /* EMC_DLL_XFORM_DQS8 */
			0x00030000, /* EMC_DLL_XFORM_DQS9 */
			0x00030000, /* EMC_DLL_XFORM_DQS10 */
			0x00030000, /* EMC_DLL_XFORM_DQS11 */
			0x00030000, /* EMC_DLL_XFORM_DQS12 */
			0x00030000, /* EMC_DLL_XFORM_DQS13 */
			0x00030000, /* EMC_DLL_XFORM_DQS14 */
			0x00030000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00070000, /* EMC_DLL_XFORM_ADDR0 */
			0x00070000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00070000, /* EMC_DLL_XFORM_ADDR3 */
			0x00070000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00038000, /* EMC_DLL_XFORM_DQ0 */
			0x00038000, /* EMC_DLL_XFORM_DQ1 */
			0x00038000, /* EMC_DLL_XFORM_DQ2 */
			0x00038000, /* EMC_DLL_XFORM_DQ3 */
			0x00003800, /* EMC_DLL_XFORM_DQ4 */
			0x00003800, /* EMC_DLL_XFORM_DQ5 */
			0x00003800, /* EMC_DLL_XFORM_DQ6 */
			0x00003800, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x01231339, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000505, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x000000c6, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x015b000e, /* EMC_MRS_WAIT_CNT */
			0x015b000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x000052a3, /* EMC_CFG_PIPE */
			0x8000188b, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x0f000005, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RP */
			0x00000009, /* MC_EMEM_ARB_TIMING_RC */
			0x00000005, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000007, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06040202, /* MC_EMEM_ARB_DA_TURNS */
			0x000d0709, /* MC_EMEM_ARB_DA_COVERS */
			0x7586120a, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000a, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000000be, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00280049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008002d, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0033, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff0022, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff0037, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff0066, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73340000, /* EMC_CFG */
		0x00000895, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000521, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200000, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		2180,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"04_528000_NoCfgVersion_V6.0.4_V1.1", /* DVFS table version */
		528000,     /* SDRAM frequency */
		880,        /* min voltage */
		870,        /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000018, /* EMC_RC */
			0x00000088, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000010, /* EMC_RAS */
			0x00000006, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000009, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x0000000d, /* EMC_W2P */
			0x00000006, /* EMC_RD_RCD */
			0x00000006, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000001, /* EMC_EINPUT */
			0x00000009, /* EMC_EINPUT_DURATION */
			0x00030000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000000, /* EMC_QRST */
			0x00000010, /* EMC_QSAFE */
			0x00000012, /* EMC_RDV */
			0x00000014, /* EMC_RDV_MASK */
			0x00000fd6, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000003f5, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x0000000b, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000085, /* EMC_AR2PDEN */
			0x00000012, /* EMC_RW2PDEN */
			0x00000090, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000013, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000006, /* EMC_TCLKSTABLE */
			0x00000006, /* EMC_TCLKSTOP */
			0x00001017, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x104ab098, /* EMC_FBIO_CFG5 */
			0xe01200b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000000a, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_DLL_XFORM_DQS1 */
			0x0000000a, /* EMC_DLL_XFORM_DQS2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS3 */
			0x0000000a, /* EMC_DLL_XFORM_DQS4 */
			0x0000000a, /* EMC_DLL_XFORM_DQS5 */
			0x0000000a, /* EMC_DLL_XFORM_DQS6 */
			0x0000000a, /* EMC_DLL_XFORM_DQS7 */
			0x0000000a, /* EMC_DLL_XFORM_DQS8 */
			0x0000000a, /* EMC_DLL_XFORM_DQS9 */
			0x0000000a, /* EMC_DLL_XFORM_DQS10 */
			0x0000000a, /* EMC_DLL_XFORM_DQS11 */
			0x0000000a, /* EMC_DLL_XFORM_DQS12 */
			0x0000000a, /* EMC_DLL_XFORM_DQS13 */
			0x0000000a, /* EMC_DLL_XFORM_DQS14 */
			0x0000000a, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00054000, /* EMC_DLL_XFORM_ADDR0 */
			0x00054000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00054000, /* EMC_DLL_XFORM_ADDR3 */
			0x00054000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000a, /* EMC_DLL_XFORM_DQ0 */
			0x0000000a, /* EMC_DLL_XFORM_DQ1 */
			0x0000000a, /* EMC_DLL_XFORM_DQ2 */
			0x0000000a, /* EMC_DLL_XFORM_DQ3 */
			0x0000000a, /* EMC_DLL_XFORM_DQ4 */
			0x0000000a, /* EMC_DLL_XFORM_DQ5 */
			0x0000000a, /* EMC_DLL_XFORM_DQ6 */
			0x0000000a, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0123133d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000505, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x0139000e, /* EMC_MRS_WAIT_CNT */
			0x0139000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x000042a0, /* EMC_CFG_PIPE */
			0x80002062, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x0f000007, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000002, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RP */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RC */
			0x00000007, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000a, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000009, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06050202, /* MC_EMEM_ARB_DA_TURNS */
			0x0010090c, /* MC_EMEM_ARB_DA_COVERS */
			0x7428180d, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000d, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000000fd, /* MC_PTSA_GRANT_DECREMENT */
			0x00c10038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00c10038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00c1003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00c10090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00c10041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00c10090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00c10041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00c10080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080021, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000c1, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00c10026, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00c1001a, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00c10024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00c10029, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000c1, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00c10065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00c1002a, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x0000089d, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0xe0120069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000941, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		1440,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"04_600000_NoCfgVersion_V6.0.4_V1.1", /* DVFS table version */
		600000,     /* SDRAM frequency */
		910,        /* min voltage */
		910,        /* gpu min voltage */
		"pllc_ud",  /* clock source id */
		0xe0000000, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000001b, /* EMC_RC */
			0x0000009b, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000013, /* EMC_RAS */
			0x00000007, /* EMC_RP */
			0x00000007, /* EMC_R2W */
			0x0000000b, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x00000010, /* EMC_W2P */
			0x00000007, /* EMC_RD_RCD */
			0x00000007, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x0000000a, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x0000000b, /* EMC_EINPUT_DURATION */
			0x00070000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x00000012, /* EMC_QSAFE */
			0x00000016, /* EMC_RDV */
			0x00000018, /* EMC_RDV_MASK */
			0x00001208, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000482, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x0000000d, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000097, /* EMC_AR2PDEN */
			0x00000015, /* EMC_RW2PDEN */
			0x000000a3, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000015, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000006, /* EMC_TCLKSTABLE */
			0x00000006, /* EMC_TCLKSTOP */
			0x00001248, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x104ab098, /* EMC_FBIO_CFG5 */
			0xe00e00b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000009, /* EMC_DLL_XFORM_DQS0 */
			0x00000009, /* EMC_DLL_XFORM_DQS1 */
			0x00000009, /* EMC_DLL_XFORM_DQS2 */
			0x00000009, /* EMC_DLL_XFORM_DQS3 */
			0x00000009, /* EMC_DLL_XFORM_DQS4 */
			0x00000009, /* EMC_DLL_XFORM_DQS5 */
			0x00000009, /* EMC_DLL_XFORM_DQS6 */
			0x00000009, /* EMC_DLL_XFORM_DQS7 */
			0x00000009, /* EMC_DLL_XFORM_DQS8 */
			0x00000009, /* EMC_DLL_XFORM_DQS9 */
			0x00000009, /* EMC_DLL_XFORM_DQS10 */
			0x00000009, /* EMC_DLL_XFORM_DQS11 */
			0x00000009, /* EMC_DLL_XFORM_DQS12 */
			0x00000009, /* EMC_DLL_XFORM_DQS13 */
			0x00000009, /* EMC_DLL_XFORM_DQS14 */
			0x00000009, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00048000, /* EMC_DLL_XFORM_ADDR0 */
			0x00048000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00048000, /* EMC_DLL_XFORM_ADDR3 */
			0x00048000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000a, /* EMC_DLL_XFORM_DQ0 */
			0x0000000a, /* EMC_DLL_XFORM_DQ1 */
			0x0000000a, /* EMC_DLL_XFORM_DQ2 */
			0x0000000a, /* EMC_DLL_XFORM_DQ3 */
			0x0000000a, /* EMC_DLL_XFORM_DQ4 */
			0x0000000a, /* EMC_DLL_XFORM_DQ5 */
			0x0000000a, /* EMC_DLL_XFORM_DQ6 */
			0x0000000a, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0121113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000505, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x0127000e, /* EMC_MRS_WAIT_CNT */
			0x0127000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x000040a0, /* EMC_CFG_PIPE */
			0x800024a9, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000e, /* EMC_QPOP */
			0x00000009, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000003, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RP */
			0x0000000e, /* MC_EMEM_ARB_TIMING_RC */
			0x00000009, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000b, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000b, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_W2R */
			0x07050202, /* MC_EMEM_ARB_DA_TURNS */
			0x00130b0e, /* MC_EMEM_ARB_DA_COVERS */
			0x73a91b0f, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000f, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000120, /* MC_PTSA_GRANT_DECREMENT */
			0x00aa0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00aa0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00aa003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00aa0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00aa0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00aa0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00aa0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00aa0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008001d, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000aa, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00aa0022, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00aa0018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00aa0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00aa0024, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000aa, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00aa0065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00aa0025, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x0000089d, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0xe00e0069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000b61, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200010, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		1440,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"04_792000_02_V6.0.4_V1.1", /* DVFS table version */
		792000,     /* SDRAM frequency */
		980,        /* min voltage */
		980,        /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000024, /* EMC_RC */
			0x000000cd, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000019, /* EMC_RAS */
			0x0000000a, /* EMC_RP */
			0x00000008, /* EMC_R2W */
			0x0000000d, /* EMC_W2R */
			0x00000004, /* EMC_R2P */
			0x00000013, /* EMC_W2P */
			0x0000000a, /* EMC_RD_RCD */
			0x0000000a, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x0000000b, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000002, /* EMC_EINPUT */
			0x0000000d, /* EMC_EINPUT_DURATION */
			0x00080000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000001, /* EMC_QRST */
			0x00000014, /* EMC_QSAFE */
			0x00000018, /* EMC_RDV */
			0x0000001a, /* EMC_RDV_MASK */
			0x000017e2, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000005f8, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000003, /* EMC_PDEX2WR */
			0x00000011, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x000000c7, /* EMC_AR2PDEN */
			0x00000018, /* EMC_RW2PDEN */
			0x000000d7, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000005, /* EMC_TCKE */
			0x00000006, /* EMC_TCKESR */
			0x00000005, /* EMC_TPD */
			0x0000001d, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000008, /* EMC_TCLKSTABLE */
			0x00000008, /* EMC_TCLKSTOP */
			0x00001822, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x104ab098, /* EMC_FBIO_CFG5 */
			0xe00700b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000008, /* EMC_DLL_XFORM_DQS0 */
			0x00000008, /* EMC_DLL_XFORM_DQS1 */
			0x00000008, /* EMC_DLL_XFORM_DQS2 */
			0x00000008, /* EMC_DLL_XFORM_DQS3 */
			0x00000008, /* EMC_DLL_XFORM_DQS4 */
			0x00000008, /* EMC_DLL_XFORM_DQS5 */
			0x00000008, /* EMC_DLL_XFORM_DQS6 */
			0x00000008, /* EMC_DLL_XFORM_DQS7 */
			0x00000008, /* EMC_DLL_XFORM_DQS8 */
			0x00000008, /* EMC_DLL_XFORM_DQS9 */
			0x00000008, /* EMC_DLL_XFORM_DQS10 */
			0x00000008, /* EMC_DLL_XFORM_DQS11 */
			0x00000008, /* EMC_DLL_XFORM_DQS12 */
			0x00000008, /* EMC_DLL_XFORM_DQS13 */
			0x00000008, /* EMC_DLL_XFORM_DQS14 */
			0x00000008, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00034000, /* EMC_DLL_XFORM_ADDR0 */
			0x00034000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00034000, /* EMC_DLL_XFORM_ADDR3 */
			0x00034000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000a, /* EMC_DLL_XFORM_DQ0 */
			0x0000000a, /* EMC_DLL_XFORM_DQ1 */
			0x0000000a, /* EMC_DLL_XFORM_DQ2 */
			0x0000000a, /* EMC_DLL_XFORM_DQ3 */
			0x0000000a, /* EMC_DLL_XFORM_DQ4 */
			0x0000000a, /* EMC_DLL_XFORM_DQ5 */
			0x0000000a, /* EMC_DLL_XFORM_DQ6 */
			0x0000000a, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0120113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000000, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x61861820, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x61861800, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x00f7000e, /* EMC_MRS_WAIT_CNT */
			0x00f7000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x00004080, /* EMC_CFG_PIPE */
			0x80003012, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000f, /* EMC_QPOP */
			0x0e00000b, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000004, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000005, /* MC_EMEM_ARB_TIMING_RP */
			0x00000013, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000f, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000c, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_W2R */
			0x08060202, /* MC_EMEM_ARB_DA_TURNS */
			0x00170e13, /* MC_EMEM_ARB_DA_COVERS */
			0x736c2414, /* MC_EMEM_ARB_MISC0 */
			0x70000f02, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000013, /* MC_MLL_MPCORER_PTSA_RATE */
			0x0000017c, /* MC_PTSA_GRANT_DECREMENT */
			0x00810038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00810038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x0081003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00810090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00810041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00810090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00810041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00810080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080016, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x00000081, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00810019, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00810018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00810024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x0081001c, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x00000081, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00810065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x0081001c, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x0000089d, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0xe0070069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430808, /* EMC_AUTO_CAL_CONFIG */
		0x80000d71, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200018, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		1200,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"04_924000_04_V6.0.4_V1.1", /* DVFS table version */
		924000,     /* SDRAM frequency */
		1010,       /* min voltage */
		1010,       /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000002b, /* EMC_RC */
			0x000000f0, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x0000001e, /* EMC_RAS */
			0x0000000b, /* EMC_RP */
			0x00000009, /* EMC_R2W */
			0x0000000f, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x00000016, /* EMC_W2P */
			0x0000000b, /* EMC_RD_RCD */
			0x0000000b, /* EMC_WR_RCD */
			0x00000004, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000007, /* EMC_WDV */
			0x00000007, /* EMC_WDV_MASK */
			0x0000000d, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000002, /* EMC_EINPUT */
			0x0000000f, /* EMC_EINPUT_DURATION */
			0x000a0000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000001, /* EMC_QRST */
			0x00000016, /* EMC_QSAFE */
			0x0000001a, /* EMC_RDV */
			0x0000001c, /* EMC_RDV_MASK */
			0x00001be7, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000006f9, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000004, /* EMC_PDEX2WR */
			0x00000015, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x000000e7, /* EMC_AR2PDEN */
			0x0000001b, /* EMC_RW2PDEN */
			0x000000fb, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000006, /* EMC_TCKE */
			0x00000007, /* EMC_TCKESR */
			0x00000006, /* EMC_TPD */
			0x00000022, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x0000000a, /* EMC_TCLKSTABLE */
			0x0000000a, /* EMC_TCLKSTOP */
			0x00001c28, /* EMC_TREFBW */
			0x00000002, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x104ab898, /* EMC_FBIO_CFG5 */
			0xe00400b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x007f800a, /* EMC_DLL_XFORM_DQS0 */
			0x007f800a, /* EMC_DLL_XFORM_DQS1 */
			0x007fc008, /* EMC_DLL_XFORM_DQS2 */
			0x007fc008, /* EMC_DLL_XFORM_DQS3 */
			0x007fc008, /* EMC_DLL_XFORM_DQS4 */
			0x007fc008, /* EMC_DLL_XFORM_DQS5 */
			0x007fc008, /* EMC_DLL_XFORM_DQS6 */
			0x00000005, /* EMC_DLL_XFORM_DQS7 */
			0x007fc00a, /* EMC_DLL_XFORM_DQS8 */
			0x007fc00a, /* EMC_DLL_XFORM_DQS9 */
			0x007fc008, /* EMC_DLL_XFORM_DQS10 */
			0x007fc008, /* EMC_DLL_XFORM_DQS11 */
			0x007fc008, /* EMC_DLL_XFORM_DQS12 */
			0x007fc008, /* EMC_DLL_XFORM_DQS13 */
			0x007fc008, /* EMC_DLL_XFORM_DQS14 */
			0x007fc008, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0002c000, /* EMC_DLL_XFORM_ADDR0 */
			0x0002c000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0002c000, /* EMC_DLL_XFORM_ADDR3 */
			0x0002c000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000005, /* EMC_DLI_TRIM_TXDQS15 */
			0x00000008, /* EMC_DLL_XFORM_DQ0 */
			0x00000008, /* EMC_DLL_XFORM_DQ1 */
			0x00000008, /* EMC_DLL_XFORM_DQ2 */
			0x00000008, /* EMC_DLL_XFORM_DQ3 */
			0x00000008, /* EMC_DLL_XFORM_DQ4 */
			0x00000008, /* EMC_DLL_XFORM_DQ5 */
			0x00000008, /* EMC_DLL_XFORM_DQ6 */
			0x00000008, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0120113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000000, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x69869a20, /* EMC_XM2DQSPADCTRL3 */
			0x00512514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x69a69a00, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000128, /* EMC_ZCAL_WAIT_CNT */
			0x00cd000e, /* EMC_MRS_WAIT_CNT */
			0x00cd000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x00004080, /* EMC_CFG_PIPE */
			0x800037ea, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000011, /* EMC_QPOP */
			0x0e00000d, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000005, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000006, /* MC_EMEM_ARB_TIMING_RP */
			0x00000016, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000e, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000011, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000e, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000009, /* MC_EMEM_ARB_TIMING_W2R */
			0x09060202, /* MC_EMEM_ARB_DA_TURNS */
			0x001a1016, /* MC_EMEM_ARB_DA_COVERS */
			0x734e2a17, /* MC_EMEM_ARB_MISC0 */
			0x70000f02, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000017, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000001bb, /* MC_PTSA_GRANT_DECREMENT */
			0x006e0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x006e0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x006e003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x006e0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x006e0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x006e0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x006e0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x006e0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080016, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x0000006e, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x006e0019, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x006e0018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x006e0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x006e001b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x0000006e, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x006e0065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x006e001c, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x0000004c, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x0000089d, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0xe0040069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430f0f, /* EMC_AUTO_CAL_CONFIG */
		0x80000f15, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200020, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		1180,       /* expected dvfs latency (ns) */
	},
};

static struct tegra12_emc_table bowmore_emc_table[] = {
	{
		0x19,       /* V6.0.3 */
		"05_12750_01_V6.0.3_V1.1", /* DVFS table version */
		12750,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x4000003e, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000000, /* EMC_RC */
			0x00000003, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000030, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x0000000c, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x00000003, /* EMC_TXSR */
			0x00000002, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000003, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000006, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000036, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a296, /* EMC_FBIO_CFG5 */
			0x005800a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00048000, /* EMC_DLL_XFORM_DQS0 */
			0x00048000, /* EMC_DLL_XFORM_DQS1 */
			0x00048000, /* EMC_DLL_XFORM_DQS2 */
			0x00048000, /* EMC_DLL_XFORM_DQS3 */
			0x00048000, /* EMC_DLL_XFORM_DQS4 */
			0x00048000, /* EMC_DLL_XFORM_DQS5 */
			0x00048000, /* EMC_DLL_XFORM_DQS6 */
			0x00048000, /* EMC_DLL_XFORM_DQS7 */
			0x00048000, /* EMC_DLL_XFORM_DQS8 */
			0x00048000, /* EMC_DLL_XFORM_DQS9 */
			0x00048000, /* EMC_DLL_XFORM_DQS10 */
			0x00048000, /* EMC_DLL_XFORM_DQS11 */
			0x00048000, /* EMC_DLL_XFORM_DQS12 */
			0x00048000, /* EMC_DLL_XFORM_DQS13 */
			0x00048000, /* EMC_DLL_XFORM_DQS14 */
			0x00048000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR0 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR3 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x0002c000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x00000200, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x0130b018, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc000, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000011, /* EMC_ZCAL_WAIT_CNT */
			0x000d0011, /* EMC_MRS_WAIT_CNT */
			0x000d0011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f3f3, /* EMC_CFG_PIPE */
			0x80000164, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x40040001, /* MC_EMEM_ARB_CFG */
			0x8000000a, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040102, /* MC_EMEM_ARB_DA_TURNS */
			0x00090402, /* MC_EMEM_ARB_DA_COVERS */
			0x77c30303, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000007, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000015, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3200000, /* EMC_CFG */
		0x000008c7, /* EMC_CFG_2 */
		0x0004013c, /* EMC_SEL_DPD_CTRL */
		0x00580068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		57820,      /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_20400_02_V6.0.3_V1.1", /* DVFS table version */
		20400,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000026, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000001, /* EMC_RC */
			0x00000003, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x0000004d, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000013, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x00000003, /* EMC_TXSR */
			0x00000003, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000003, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000006, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000055, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a296, /* EMC_FBIO_CFG5 */
			0x005800a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00048000, /* EMC_DLL_XFORM_DQS0 */
			0x00048000, /* EMC_DLL_XFORM_DQS1 */
			0x00048000, /* EMC_DLL_XFORM_DQS2 */
			0x00048000, /* EMC_DLL_XFORM_DQS3 */
			0x00048000, /* EMC_DLL_XFORM_DQS4 */
			0x00048000, /* EMC_DLL_XFORM_DQS5 */
			0x00048000, /* EMC_DLL_XFORM_DQS6 */
			0x00048000, /* EMC_DLL_XFORM_DQS7 */
			0x00048000, /* EMC_DLL_XFORM_DQS8 */
			0x00048000, /* EMC_DLL_XFORM_DQS9 */
			0x00048000, /* EMC_DLL_XFORM_DQS10 */
			0x00048000, /* EMC_DLL_XFORM_DQS11 */
			0x00048000, /* EMC_DLL_XFORM_DQS12 */
			0x00048000, /* EMC_DLL_XFORM_DQS13 */
			0x00048000, /* EMC_DLL_XFORM_DQS14 */
			0x00048000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR0 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR3 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x0002c000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x00000200, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x0130b018, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc000, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000011, /* EMC_ZCAL_WAIT_CNT */
			0x00150011, /* EMC_MRS_WAIT_CNT */
			0x00150011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f3f3, /* EMC_CFG_PIPE */
			0x8000019f, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x40020001, /* MC_EMEM_ARB_CFG */
			0x80000012, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040102, /* MC_EMEM_ARB_DA_TURNS */
			0x00090402, /* MC_EMEM_ARB_DA_COVERS */
			0x74e30303, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x0000000a, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000015, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3200000, /* EMC_CFG */
		0x000008c7, /* EMC_CFG_2 */
		0x0004013c, /* EMC_SEL_DPD_CTRL */
		0x00580068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		35610,      /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_40800_02_V6.0.3_V1.1", /* DVFS table version */
		40800,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000012, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000002, /* EMC_RC */
			0x00000005, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x0000009a, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000026, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x00000006, /* EMC_TXSR */
			0x00000006, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000003, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000006, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x000000aa, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a296, /* EMC_FBIO_CFG5 */
			0x005800a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00048000, /* EMC_DLL_XFORM_DQS0 */
			0x00048000, /* EMC_DLL_XFORM_DQS1 */
			0x00048000, /* EMC_DLL_XFORM_DQS2 */
			0x00048000, /* EMC_DLL_XFORM_DQS3 */
			0x00048000, /* EMC_DLL_XFORM_DQS4 */
			0x00048000, /* EMC_DLL_XFORM_DQS5 */
			0x00048000, /* EMC_DLL_XFORM_DQS6 */
			0x00048000, /* EMC_DLL_XFORM_DQS7 */
			0x00048000, /* EMC_DLL_XFORM_DQS8 */
			0x00048000, /* EMC_DLL_XFORM_DQS9 */
			0x00048000, /* EMC_DLL_XFORM_DQS10 */
			0x00048000, /* EMC_DLL_XFORM_DQS11 */
			0x00048000, /* EMC_DLL_XFORM_DQS12 */
			0x00048000, /* EMC_DLL_XFORM_DQS13 */
			0x00048000, /* EMC_DLL_XFORM_DQS14 */
			0x00048000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR0 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR3 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x0002c000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x00000200, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x0130b018, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc000, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000011, /* EMC_ZCAL_WAIT_CNT */
			0x00290011, /* EMC_MRS_WAIT_CNT */
			0x00290011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f3f3, /* EMC_CFG_PIPE */
			0x8000023a, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0xa0000001, /* MC_EMEM_ARB_CFG */
			0x80000017, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040102, /* MC_EMEM_ARB_DA_TURNS */
			0x00090402, /* MC_EMEM_ARB_DA_COVERS */
			0x73030303, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000014, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000015, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3200000, /* EMC_CFG */
		0x000008c7, /* EMC_CFG_2 */
		0x0004013c, /* EMC_SEL_DPD_CTRL */
		0x00580068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		20850,      /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_68000_02_V6.0.3_V1.1", /* DVFS table version */
		68000,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x4000000a, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000004, /* EMC_RC */
			0x00000008, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000101, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000040, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x0000000a, /* EMC_TXSR */
			0x0000000a, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000003, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000006, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x0000011b, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a296, /* EMC_FBIO_CFG5 */
			0x005800a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00048000, /* EMC_DLL_XFORM_DQS0 */
			0x00048000, /* EMC_DLL_XFORM_DQS1 */
			0x00048000, /* EMC_DLL_XFORM_DQS2 */
			0x00048000, /* EMC_DLL_XFORM_DQS3 */
			0x00048000, /* EMC_DLL_XFORM_DQS4 */
			0x00048000, /* EMC_DLL_XFORM_DQS5 */
			0x00048000, /* EMC_DLL_XFORM_DQS6 */
			0x00048000, /* EMC_DLL_XFORM_DQS7 */
			0x00048000, /* EMC_DLL_XFORM_DQS8 */
			0x00048000, /* EMC_DLL_XFORM_DQS9 */
			0x00048000, /* EMC_DLL_XFORM_DQS10 */
			0x00048000, /* EMC_DLL_XFORM_DQS11 */
			0x00048000, /* EMC_DLL_XFORM_DQS12 */
			0x00048000, /* EMC_DLL_XFORM_DQS13 */
			0x00048000, /* EMC_DLL_XFORM_DQS14 */
			0x00048000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR0 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR3 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x0002c000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x00000200, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x0130b018, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc000, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000019, /* EMC_ZCAL_WAIT_CNT */
			0x00440011, /* EMC_MRS_WAIT_CNT */
			0x00440011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f3f3, /* EMC_CFG_PIPE */
			0x80000309, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x00000001, /* MC_EMEM_ARB_CFG */
			0x8000001e, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040102, /* MC_EMEM_ARB_DA_TURNS */
			0x00090402, /* MC_EMEM_ARB_DA_COVERS */
			0x72630403, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000021, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00b0, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ec, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ec, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00e90049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00a3, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ef, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ef, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ee00ef, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000015, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3200000, /* EMC_CFG */
		0x000008c7, /* EMC_CFG_2 */
		0x0004013c, /* EMC_SEL_DPD_CTRL */
		0x00580068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		10720,      /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_102000_03_V6.0.3_V1.1", /* DVFS table version */
		102000,     /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000006, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000006, /* EMC_RC */
			0x0000000d, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000004, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000182, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000060, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x0000000f, /* EMC_TXSR */
			0x0000000f, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000003, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000006, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x000001a9, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a296, /* EMC_FBIO_CFG5 */
			0x005800a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00048000, /* EMC_DLL_XFORM_DQS0 */
			0x00048000, /* EMC_DLL_XFORM_DQS1 */
			0x00048000, /* EMC_DLL_XFORM_DQS2 */
			0x00048000, /* EMC_DLL_XFORM_DQS3 */
			0x00048000, /* EMC_DLL_XFORM_DQS4 */
			0x00048000, /* EMC_DLL_XFORM_DQS5 */
			0x00048000, /* EMC_DLL_XFORM_DQS6 */
			0x00048000, /* EMC_DLL_XFORM_DQS7 */
			0x00048000, /* EMC_DLL_XFORM_DQS8 */
			0x00048000, /* EMC_DLL_XFORM_DQS9 */
			0x00048000, /* EMC_DLL_XFORM_DQS10 */
			0x00048000, /* EMC_DLL_XFORM_DQS11 */
			0x00048000, /* EMC_DLL_XFORM_DQS12 */
			0x00048000, /* EMC_DLL_XFORM_DQS13 */
			0x00048000, /* EMC_DLL_XFORM_DQS14 */
			0x00048000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR0 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR3 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x00000200, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x0130b018, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc000, /* EMC_XM2CLKPADCTRL */
			0x00000404, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000025, /* EMC_ZCAL_WAIT_CNT */
			0x00660011, /* EMC_MRS_WAIT_CNT */
			0x00660011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f3f3, /* EMC_CFG_PIPE */
			0x8000040b, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x08000001, /* MC_EMEM_ARB_CFG */
			0x80000026, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000003, /* MC_EMEM_ARB_TIMING_RC */
			0x00000001, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040102, /* MC_EMEM_ARB_DA_TURNS */
			0x00090403, /* MC_EMEM_ARB_DA_COVERS */
			0x72430504, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000031, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff0075, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff009d, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff009d, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x009b0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ad, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00c6, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00d6, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x0000009f, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x0000009f, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x009f00a0, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000015, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3200000, /* EMC_CFG */
		0x000008c7, /* EMC_CFG_2 */
		0x0004013c, /* EMC_SEL_DPD_CTRL */
		0x00580068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		6890,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_204000_04_V6.0.3_V1.1", /* DVFS table version */
		204000,     /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000002, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000000c, /* EMC_RC */
			0x0000001a, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000008, /* EMC_RAS */
			0x00000003, /* EMC_RP */
			0x00000007, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000003, /* EMC_RD_RCD */
			0x00000003, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000002, /* EMC_WDV */
			0x00000002, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000003, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x00000007, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x0000000e, /* EMC_QSAFE */
			0x0000000f, /* EMC_RDV */
			0x00000011, /* EMC_RDV_MASK */
			0x00000304, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000000c1, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000003, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x0000001d, /* EMC_TXSR */
			0x0000001d, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000004, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000009, /* EMC_TFAW */
			0x00000005, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000351, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a296, /* EMC_FBIO_CFG5 */
			0x005800a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00048000, /* EMC_DLL_XFORM_DQS0 */
			0x00048000, /* EMC_DLL_XFORM_DQS1 */
			0x00048000, /* EMC_DLL_XFORM_DQS2 */
			0x00048000, /* EMC_DLL_XFORM_DQS3 */
			0x00048000, /* EMC_DLL_XFORM_DQS4 */
			0x00048000, /* EMC_DLL_XFORM_DQS5 */
			0x00048000, /* EMC_DLL_XFORM_DQS6 */
			0x00048000, /* EMC_DLL_XFORM_DQS7 */
			0x00048000, /* EMC_DLL_XFORM_DQS8 */
			0x00048000, /* EMC_DLL_XFORM_DQS9 */
			0x00048000, /* EMC_DLL_XFORM_DQS10 */
			0x00048000, /* EMC_DLL_XFORM_DQS11 */
			0x00048000, /* EMC_DLL_XFORM_DQS12 */
			0x00048000, /* EMC_DLL_XFORM_DQS13 */
			0x00048000, /* EMC_DLL_XFORM_DQS14 */
			0x00048000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00090000, /* EMC_DLL_XFORM_ADDR0 */
			0x00090000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00090000, /* EMC_DLL_XFORM_ADDR3 */
			0x00090000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0008c000, /* EMC_DLL_XFORM_DQ0 */
			0x0008c000, /* EMC_DLL_XFORM_DQ1 */
			0x00070000, /* EMC_DLL_XFORM_DQ2 */
			0x0008c000, /* EMC_DLL_XFORM_DQ3 */
			0x00008c00, /* EMC_DLL_XFORM_DQ4 */
			0x00008c00, /* EMC_DLL_XFORM_DQ5 */
			0x00008800, /* EMC_DLL_XFORM_DQ6 */
			0x00009400, /* EMC_DLL_XFORM_DQ7 */
			0x00000200, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x0130b018, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc000, /* EMC_XM2CLKPADCTRL */
			0x00000202, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000004a, /* EMC_ZCAL_WAIT_CNT */
			0x00cc0011, /* EMC_MRS_WAIT_CNT */
			0x00cc0011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x0000d3b3, /* EMC_CFG_PIPE */
			0x80000713, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x01000003, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000006, /* MC_EMEM_ARB_TIMING_RC */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000005, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05050103, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0506, /* MC_EMEM_ARB_DA_COVERS */
			0x71e40a07, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000062, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00af, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff004f, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00af, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff004f, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x004e0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080057, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0063, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff0036, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff006b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000050, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000050, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510050, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00c6, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000017, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3200000, /* EMC_CFG */
		0x000008cf, /* EMC_CFG_2 */
		0x0004013c, /* EMC_SEL_DPD_CTRL */
		0x00580068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		3420,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_300000_03_V6.0.3_V1.1", /* DVFS table version */
		300000,     /* SDRAM frequency */
		820,        /* min voltage */
		820,        /* gpu min voltage */
		"pllc_out0", /* clock source id */
		0x20000002, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000011, /* EMC_RC */
			0x00000026, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x0000000c, /* EMC_RAS */
			0x00000005, /* EMC_RP */
			0x00000007, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000005, /* EMC_RD_RCD */
			0x00000005, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000002, /* EMC_WDV */
			0x00000002, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000003, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x00000008, /* EMC_EINPUT_DURATION */
			0x00030000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x0000000f, /* EMC_QSAFE */
			0x00000012, /* EMC_RDV */
			0x00000014, /* EMC_RDV_MASK */
			0x0000046e, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x0000011b, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000005, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x0000002a, /* EMC_TXSR */
			0x0000002a, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x0000000d, /* EMC_TFAW */
			0x00000007, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x000004e0, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a096, /* EMC_FBIO_CFG5 */
			0x005800a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00020000, /* EMC_DLL_XFORM_DQS0 */
			0x00020000, /* EMC_DLL_XFORM_DQS1 */
			0x00020000, /* EMC_DLL_XFORM_DQS2 */
			0x00020000, /* EMC_DLL_XFORM_DQS3 */
			0x00020000, /* EMC_DLL_XFORM_DQS4 */
			0x00020000, /* EMC_DLL_XFORM_DQS5 */
			0x00020000, /* EMC_DLL_XFORM_DQS6 */
			0x00020000, /* EMC_DLL_XFORM_DQS7 */
			0x00020000, /* EMC_DLL_XFORM_DQS8 */
			0x00020000, /* EMC_DLL_XFORM_DQS9 */
			0x00020000, /* EMC_DLL_XFORM_DQS10 */
			0x00020000, /* EMC_DLL_XFORM_DQS11 */
			0x00020000, /* EMC_DLL_XFORM_DQS12 */
			0x00020000, /* EMC_DLL_XFORM_DQS13 */
			0x00020000, /* EMC_DLL_XFORM_DQS14 */
			0x00020000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00060000, /* EMC_DLL_XFORM_ADDR0 */
			0x00060000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00060000, /* EMC_DLL_XFORM_ADDR3 */
			0x00060000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0005c000, /* EMC_DLL_XFORM_DQ0 */
			0x0005c000, /* EMC_DLL_XFORM_DQ1 */
			0x0003c000, /* EMC_DLL_XFORM_DQ2 */
			0x0005c000, /* EMC_DLL_XFORM_DQ3 */
			0x00005c00, /* EMC_DLL_XFORM_DQ4 */
			0x00005c00, /* EMC_DLL_XFORM_DQ5 */
			0x00005800, /* EMC_DLL_XFORM_DQ6 */
			0x00006000, /* EMC_DLL_XFORM_DQ7 */
			0x00000200, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x01231239, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc000, /* EMC_XM2CLKPADCTRL */
			0x00000202, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000006c, /* EMC_ZCAL_WAIT_CNT */
			0x012c0011, /* EMC_MRS_WAIT_CNT */
			0x012c0011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x000052a3, /* EMC_CFG_PIPE */
			0x800009ed, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000b, /* EMC_QPOP */
			0x08000004, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RP */
			0x00000009, /* MC_EMEM_ARB_TIMING_RC */
			0x00000005, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000007, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05050103, /* MC_EMEM_ARB_DA_TURNS */
			0x000c0709, /* MC_EMEM_ARB_DA_COVERS */
			0x71c50e0a, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000004, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000090, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00350049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008003b, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0043, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff002d, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510036, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff0087, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x0000001f, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3300000, /* EMC_CFG */
		0x000008d7, /* EMC_CFG_2 */
		0x0004013c, /* EMC_SEL_DPD_CTRL */
		0x00580068, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		2680,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_396000_03_V6.0.3_V1.1", /* DVFS table version */
		396000,     /* SDRAM frequency */
		850,        /* min voltage */
		850,        /* gpu min voltage */
		"pllm_out0", /* clock source id */
		0x00000002, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000017, /* EMC_RC */
			0x00000033, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000010, /* EMC_RAS */
			0x00000007, /* EMC_RP */
			0x00000008, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000007, /* EMC_RD_RCD */
			0x00000007, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000002, /* EMC_WDV */
			0x00000002, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000003, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000002, /* EMC_EINPUT */
			0x00000009, /* EMC_EINPUT_DURATION */
			0x00030000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000001, /* EMC_QRST */
			0x00000010, /* EMC_QSAFE */
			0x00000012, /* EMC_RDV */
			0x00000014, /* EMC_RDV_MASK */
			0x000005d9, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000176, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000007, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000e, /* EMC_RW2PDEN */
			0x00000038, /* EMC_TXSR */
			0x00000038, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000006, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000012, /* EMC_TFAW */
			0x00000009, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000670, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a096, /* EMC_FBIO_CFG5 */
			0x005800a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000000, /* EMC_DLL_XFORM_DQS0 */
			0x00000000, /* EMC_DLL_XFORM_DQS1 */
			0x00000000, /* EMC_DLL_XFORM_DQS2 */
			0x00000000, /* EMC_DLL_XFORM_DQS3 */
			0x00000000, /* EMC_DLL_XFORM_DQS4 */
			0x00000000, /* EMC_DLL_XFORM_DQS5 */
			0x00000000, /* EMC_DLL_XFORM_DQS6 */
			0x00000000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_DQS8 */
			0x00000000, /* EMC_DLL_XFORM_DQS9 */
			0x00000000, /* EMC_DLL_XFORM_DQS10 */
			0x00000000, /* EMC_DLL_XFORM_DQS11 */
			0x00000000, /* EMC_DLL_XFORM_DQS12 */
			0x00000000, /* EMC_DLL_XFORM_DQS13 */
			0x00000000, /* EMC_DLL_XFORM_DQS14 */
			0x00000000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00058000, /* EMC_DLL_XFORM_ADDR0 */
			0x00058000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00058000, /* EMC_DLL_XFORM_ADDR3 */
			0x00058000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00038000, /* EMC_DLL_XFORM_DQ0 */
			0x00038000, /* EMC_DLL_XFORM_DQ1 */
			0x00038000, /* EMC_DLL_XFORM_DQ2 */
			0x00038000, /* EMC_DLL_XFORM_DQ3 */
			0x00003800, /* EMC_DLL_XFORM_DQ4 */
			0x00003800, /* EMC_DLL_XFORM_DQ5 */
			0x00003800, /* EMC_DLL_XFORM_DQ6 */
			0x00003800, /* EMC_DLL_XFORM_DQ7 */
			0x00000200, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x01231239, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc000, /* EMC_XM2CLKPADCTRL */
			0x00000202, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000008f, /* EMC_ZCAL_WAIT_CNT */
			0x018c0011, /* EMC_MRS_WAIT_CNT */
			0x018c0011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x000052a3, /* EMC_CFG_PIPE */
			0x80000cc7, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000b, /* EMC_QPOP */
			0x0f000005, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000002, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RP */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RC */
			0x00000007, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000009, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05050103, /* MC_EMEM_ARB_DA_TURNS */
			0x000e090c, /* MC_EMEM_ARB_DA_COVERS */
			0x71c6120d, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000a, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000000be, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00280049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008002d, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0033, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff0022, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff0037, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff0066, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000028, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3300000, /* EMC_CFG */
		0x00000897, /* EMC_CFG_2 */
		0x0004001c, /* EMC_SEL_DPD_CTRL */
		0x00580068, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		2180,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_528000_03_V6.0.3_V1.1", /* DVFS table version */
		528000,     /* SDRAM frequency */
		880,        /* min voltage */
		870,        /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000001f, /* EMC_RC */
			0x00000044, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000016, /* EMC_RAS */
			0x00000009, /* EMC_RP */
			0x0000000a, /* EMC_R2W */
			0x00000009, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000d, /* EMC_W2P */
			0x00000009, /* EMC_RD_RCD */
			0x00000009, /* EMC_WR_RCD */
			0x00000005, /* EMC_RRD */
			0x00000004, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000002, /* EMC_WDV */
			0x00000002, /* EMC_WDV_MASK */
			0x00000008, /* EMC_QUSE */
			0x00000003, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x0000000a, /* EMC_EINPUT_DURATION */
			0x00050000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x00000011, /* EMC_QSAFE */
			0x00000015, /* EMC_RDV */
			0x00000017, /* EMC_RDV_MASK */
			0x000007cd, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000001f3, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000003, /* EMC_PDEX2WR */
			0x00000003, /* EMC_PDEX2RD */
			0x00000009, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000011, /* EMC_RW2PDEN */
			0x0000004a, /* EMC_TXSR */
			0x0000004a, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000008, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000019, /* EMC_TFAW */
			0x0000000c, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000895, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a096, /* EMC_FBIO_CFG5 */
			0xe01200b9, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000000a, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_DLL_XFORM_DQS1 */
			0x0000000a, /* EMC_DLL_XFORM_DQS2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS3 */
			0x0000000a, /* EMC_DLL_XFORM_DQS4 */
			0x0000000a, /* EMC_DLL_XFORM_DQS5 */
			0x0000000a, /* EMC_DLL_XFORM_DQS6 */
			0x0000000a, /* EMC_DLL_XFORM_DQS7 */
			0x0000000a, /* EMC_DLL_XFORM_DQS8 */
			0x0000000a, /* EMC_DLL_XFORM_DQS9 */
			0x0000000a, /* EMC_DLL_XFORM_DQS10 */
			0x0000000a, /* EMC_DLL_XFORM_DQS11 */
			0x0000000a, /* EMC_DLL_XFORM_DQS12 */
			0x0000000a, /* EMC_DLL_XFORM_DQS13 */
			0x0000000a, /* EMC_DLL_XFORM_DQS14 */
			0x0000000a, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0000000f, /* EMC_DLL_XFORM_ADDR0 */
			0x0000000f, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0000000f, /* EMC_DLL_XFORM_ADDR3 */
			0x0000000f, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00000008, /* EMC_DLL_XFORM_DQ0 */
			0x00000008, /* EMC_DLL_XFORM_DQ1 */
			0x00000008, /* EMC_DLL_XFORM_DQ2 */
			0x00000008, /* EMC_DLL_XFORM_DQ3 */
			0x00000008, /* EMC_DLL_XFORM_DQ4 */
			0x00000008, /* EMC_DLL_XFORM_DQ5 */
			0x00000008, /* EMC_DLL_XFORM_DQ6 */
			0x00000008, /* EMC_DLL_XFORM_DQ7 */
			0x00000220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x0123123d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x00000202, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x000000bf, /* EMC_ZCAL_WAIT_CNT */
			0x02100013, /* EMC_MRS_WAIT_CNT */
			0x02100013, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x000042a0, /* EMC_CFG_PIPE */
			0x800010b3, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000d, /* EMC_QPOP */
			0x0f000007, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000003, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RP */
			0x00000010, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000a, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000d, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000009, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06060103, /* MC_EMEM_ARB_DA_TURNS */
			0x00120b10, /* MC_EMEM_ARB_DA_COVERS */
			0x71c81811, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000d, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000000fd, /* MC_PTSA_GRANT_DECREMENT */
			0x00c10038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00c10038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00c1003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00c10090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00c10041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00c10090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00c10041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00c10080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080021, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000c1, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00c10026, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00c1001a, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00c10024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00c10029, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000c1, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00c10065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00c1002a, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000034, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3300000, /* EMC_CFG */
		0x0000089f, /* EMC_CFG_2 */
		0x0004001c, /* EMC_SEL_DPD_CTRL */
		0xe0120069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x000100c3, /* Mode Register 1 */
		0x00020006, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		1440,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_600000_02_V6.0.3_V1.1", /* DVFS table version */
		600000,     /* SDRAM frequency */
		910,        /* min voltage */
		910,        /* gpu min voltage */
		"pllc_ud",  /* clock source id */
		0xe0000000, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000023, /* EMC_RC */
			0x0000004d, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000019, /* EMC_RAS */
			0x0000000a, /* EMC_RP */
			0x0000000a, /* EMC_R2W */
			0x0000000b, /* EMC_W2R */
			0x00000004, /* EMC_R2P */
			0x0000000f, /* EMC_W2P */
			0x0000000a, /* EMC_RD_RCD */
			0x0000000a, /* EMC_WR_RCD */
			0x00000005, /* EMC_RRD */
			0x00000004, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000004, /* EMC_WDV */
			0x00000004, /* EMC_WDV_MASK */
			0x0000000a, /* EMC_QUSE */
			0x00000004, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x0000000d, /* EMC_EINPUT_DURATION */
			0x00070000, /* EMC_PUTERM_EXTRA */
			0x00000005, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x00000014, /* EMC_QSAFE */
			0x00000018, /* EMC_RDV */
			0x0000001a, /* EMC_RDV_MASK */
			0x000008e4, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000239, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000004, /* EMC_PDEX2WR */
			0x00000004, /* EMC_PDEX2RD */
			0x0000000a, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000013, /* EMC_RW2PDEN */
			0x00000054, /* EMC_TXSR */
			0x00000054, /* EMC_TXSRDLL */
			0x00000005, /* EMC_TCKE */
			0x00000009, /* EMC_TCKESR */
			0x00000005, /* EMC_TPD */
			0x0000001c, /* EMC_TFAW */
			0x0000000d, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x000009c1, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a096, /* EMC_FBIO_CFG5 */
			0xe00e00b9, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000000a, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_DLL_XFORM_DQS1 */
			0x0000000a, /* EMC_DLL_XFORM_DQS2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS3 */
			0x0000000a, /* EMC_DLL_XFORM_DQS4 */
			0x0000000a, /* EMC_DLL_XFORM_DQS5 */
			0x0000000a, /* EMC_DLL_XFORM_DQS6 */
			0x0000000a, /* EMC_DLL_XFORM_DQS7 */
			0x0000000a, /* EMC_DLL_XFORM_DQS8 */
			0x0000000a, /* EMC_DLL_XFORM_DQS9 */
			0x0000000a, /* EMC_DLL_XFORM_DQS10 */
			0x0000000a, /* EMC_DLL_XFORM_DQS11 */
			0x0000000a, /* EMC_DLL_XFORM_DQS12 */
			0x0000000a, /* EMC_DLL_XFORM_DQS13 */
			0x0000000a, /* EMC_DLL_XFORM_DQS14 */
			0x0000000a, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0000000e, /* EMC_DLL_XFORM_ADDR0 */
			0x0000000e, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0000000e, /* EMC_DLL_XFORM_ADDR3 */
			0x0000000e, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00000009, /* EMC_DLL_XFORM_DQ0 */
			0x00000009, /* EMC_DLL_XFORM_DQ1 */
			0x00000009, /* EMC_DLL_XFORM_DQ2 */
			0x00000009, /* EMC_DLL_XFORM_DQ3 */
			0x00000009, /* EMC_DLL_XFORM_DQ4 */
			0x00000009, /* EMC_DLL_XFORM_DQ5 */
			0x00000009, /* EMC_DLL_XFORM_DQ6 */
			0x00000009, /* EMC_DLL_XFORM_DQ7 */
			0x00000220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x0121103d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x00000202, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x49249220, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x49249200, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x000000d8, /* EMC_ZCAL_WAIT_CNT */
			0x02580014, /* EMC_MRS_WAIT_CNT */
			0x02580014, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000005, /* EMC_CTT_DURATION */
			0x000040a0, /* EMC_CFG_PIPE */
			0x800012d7, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000010, /* EMC_QPOP */
			0x00000009, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000004, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000005, /* MC_EMEM_ARB_TIMING_RP */
			0x00000012, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000b, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000e, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000a, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_W2R */
			0x07060103, /* MC_EMEM_ARB_DA_TURNS */
			0x00140d12, /* MC_EMEM_ARB_DA_COVERS */
			0x71a91b13, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000f, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000120, /* MC_PTSA_GRANT_DECREMENT */
			0x00aa0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00aa0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00aa003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00aa0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00aa0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00aa0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00aa0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00aa0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008001d, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000aa, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00aa0022, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00aa0018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00aa0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00aa0024, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000aa, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00aa0065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00aa0025, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x0000003a, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3300000, /* EMC_CFG */
		0x0000089f, /* EMC_CFG_2 */
		0x0004001c, /* EMC_SEL_DPD_CTRL */
		0xe00e0069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x000100e3, /* Mode Register 1 */
		0x00020007, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		1440,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_792000_03_V6.0.3_V1.1", /* DVFS table version */
		792000,     /* SDRAM frequency */
		980,        /* min voltage */
		980,        /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000002f, /* EMC_RC */
			0x00000066, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000021, /* EMC_RAS */
			0x0000000e, /* EMC_RP */
			0x0000000d, /* EMC_R2W */
			0x0000000d, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x00000013, /* EMC_W2P */
			0x0000000e, /* EMC_RD_RCD */
			0x0000000e, /* EMC_WR_RCD */
			0x00000007, /* EMC_RRD */
			0x00000004, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x0000000e, /* EMC_QUSE */
			0x00000004, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x0000000f, /* EMC_EINPUT_DURATION */
			0x000b0000, /* EMC_PUTERM_EXTRA */
			0x00000006, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x00000016, /* EMC_QSAFE */
			0x0000001d, /* EMC_RDV */
			0x0000001f, /* EMC_RDV_MASK */
			0x00000bd1, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000002f4, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000005, /* EMC_PDEX2WR */
			0x00000005, /* EMC_PDEX2RD */
			0x0000000e, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000017, /* EMC_RW2PDEN */
			0x0000006f, /* EMC_TXSR */
			0x0000006f, /* EMC_TXSRDLL */
			0x00000006, /* EMC_TCKE */
			0x0000000c, /* EMC_TCKESR */
			0x00000006, /* EMC_TPD */
			0x00000026, /* EMC_TFAW */
			0x00000011, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000cdf, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a096, /* EMC_FBIO_CFG5 */
			0xe00700b9, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000007, /* EMC_DLL_XFORM_DQS0 */
			0x00000006, /* EMC_DLL_XFORM_DQS1 */
			0x00000006, /* EMC_DLL_XFORM_DQS2 */
			0x00000007, /* EMC_DLL_XFORM_DQS3 */
			0x00000008, /* EMC_DLL_XFORM_DQS4 */
			0x00000008, /* EMC_DLL_XFORM_DQS5 */
			0x00000008, /* EMC_DLL_XFORM_DQS6 */
			0x00000008, /* EMC_DLL_XFORM_DQS7 */
			0x00000007, /* EMC_DLL_XFORM_DQS8 */
			0x00000006, /* EMC_DLL_XFORM_DQS9 */
			0x00000006, /* EMC_DLL_XFORM_DQS10 */
			0x00000007, /* EMC_DLL_XFORM_DQS11 */
			0x00000008, /* EMC_DLL_XFORM_DQS12 */
			0x00000008, /* EMC_DLL_XFORM_DQS13 */
			0x00000008, /* EMC_DLL_XFORM_DQS14 */
			0x00000008, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0000000b, /* EMC_DLL_XFORM_ADDR0 */
			0x0000000b, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0000000b, /* EMC_DLL_XFORM_ADDR3 */
			0x0000000b, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00000009, /* EMC_DLL_XFORM_DQ0 */
			0x00000009, /* EMC_DLL_XFORM_DQ1 */
			0x00000009, /* EMC_DLL_XFORM_DQ2 */
			0x00000009, /* EMC_DLL_XFORM_DQ3 */
			0x00000009, /* EMC_DLL_XFORM_DQ4 */
			0x00000009, /* EMC_DLL_XFORM_DQ5 */
			0x00000009, /* EMC_DLL_XFORM_DQ6 */
			0x00000009, /* EMC_DLL_XFORM_DQ7 */
			0x00000220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x0120103d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x00000000, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00618618, /* EMC_XM2DQSPADCTRL4 */
			0x00618618, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000011e, /* EMC_ZCAL_WAIT_CNT */
			0x03180017, /* EMC_MRS_WAIT_CNT */
			0x03180017, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000006, /* EMC_CTT_DURATION */
			0x00004080, /* EMC_CFG_PIPE */
			0x8000188b, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000014, /* EMC_QPOP */
			0x0e00000b, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000006, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000007, /* MC_EMEM_ARB_TIMING_RP */
			0x00000018, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000f, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000013, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000003, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000c, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_W2R */
			0x08080103, /* MC_EMEM_ARB_DA_TURNS */
			0x001a1118, /* MC_EMEM_ARB_DA_COVERS */
			0x71ac2419, /* MC_EMEM_ARB_MISC0 */
			0x70000f02, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000013, /* MC_MLL_MPCORER_PTSA_RATE */
			0x0000017c, /* MC_PTSA_GRANT_DECREMENT */
			0x00810038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00810038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x0081003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00810090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00810041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00810090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00810041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00810080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080016, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x00000081, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00810019, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00810018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00810024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x0081001c, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x00000081, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00810065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x0081001c, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x0000004c, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3300000, /* EMC_CFG */
		0x0000089f, /* EMC_CFG_2 */
		0x0004001c, /* EMC_SEL_DPD_CTRL */
		0xe0070069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x00010043, /* Mode Register 1 */
		0x0002001a, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		1200,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_924000_05_V6.0.3_V1.1", /* DVFS table version */
		924000,     /* SDRAM frequency */
		1010,       /* min voltage */
		1010,       /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000037, /* EMC_RC */
			0x00000078, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000026, /* EMC_RAS */
			0x00000010, /* EMC_RP */
			0x0000000f, /* EMC_R2W */
			0x00000010, /* EMC_W2R */
			0x00000006, /* EMC_R2P */
			0x00000017, /* EMC_W2P */
			0x00000010, /* EMC_RD_RCD */
			0x00000010, /* EMC_WR_RCD */
			0x00000009, /* EMC_RRD */
			0x00000005, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000007, /* EMC_WDV */
			0x00000007, /* EMC_WDV_MASK */
			0x00000010, /* EMC_QUSE */
			0x00000005, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000012, /* EMC_EINPUT_DURATION */
			0x000d0000, /* EMC_PUTERM_EXTRA */
			0x00000007, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x00000019, /* EMC_QSAFE */
			0x00000020, /* EMC_RDV */
			0x00000022, /* EMC_RDV_MASK */
			0x00000dd4, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000375, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000006, /* EMC_PDEX2WR */
			0x00000006, /* EMC_PDEX2RD */
			0x00000010, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000001b, /* EMC_RW2PDEN */
			0x00000082, /* EMC_TXSR */
			0x00000082, /* EMC_TXSRDLL */
			0x00000007, /* EMC_TCKE */
			0x0000000e, /* EMC_TCKESR */
			0x00000007, /* EMC_TPD */
			0x0000002d, /* EMC_TFAW */
			0x00000014, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000f04, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a896, /* EMC_FBIO_CFG5 */
			0xe00400b9, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x007f800c, /* EMC_DLL_XFORM_DQS0 */
			0x00000007, /* EMC_DLL_XFORM_DQS1 */
			0x00000003, /* EMC_DLL_XFORM_DQS2 */
			0x00000003, /* EMC_DLL_XFORM_DQS3 */
			0x00000003, /* EMC_DLL_XFORM_DQS4 */
			0x00000005, /* EMC_DLL_XFORM_DQS5 */
			0x00000006, /* EMC_DLL_XFORM_DQS6 */
			0x00000005, /* EMC_DLL_XFORM_DQS7 */
			0x007f800c, /* EMC_DLL_XFORM_DQS8 */
			0x00000007, /* EMC_DLL_XFORM_DQS9 */
			0x00000003, /* EMC_DLL_XFORM_DQS10 */
			0x00000003, /* EMC_DLL_XFORM_DQS11 */
			0x00000003, /* EMC_DLL_XFORM_DQS12 */
			0x00000005, /* EMC_DLL_XFORM_DQS13 */
			0x00000006, /* EMC_DLL_XFORM_DQS14 */
			0x00000005, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0000000f, /* EMC_DLL_XFORM_ADDR0 */
			0x0000000f, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0000000f, /* EMC_DLL_XFORM_ADDR3 */
			0x0000000f, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00000009, /* EMC_DLL_XFORM_DQ0 */
			0x00000009, /* EMC_DLL_XFORM_DQ1 */
			0x00000009, /* EMC_DLL_XFORM_DQ2 */
			0x00000009, /* EMC_DLL_XFORM_DQ3 */
			0x00000009, /* EMC_DLL_XFORM_DQ4 */
			0x00000009, /* EMC_DLL_XFORM_DQ5 */
			0x00000009, /* EMC_DLL_XFORM_DQ6 */
			0x00000009, /* EMC_DLL_XFORM_DQ7 */
			0x00000220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x0120103d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x00000000, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x5d75d720, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x5d75d700, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000014d, /* EMC_ZCAL_WAIT_CNT */
			0x039c0019, /* EMC_MRS_WAIT_CNT */
			0x039c0019, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000007, /* EMC_CTT_DURATION */
			0x00004080, /* EMC_CFG_PIPE */
			0x80001c77, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000017, /* EMC_QPOP */
			0x0e00000d, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000007, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000008, /* MC_EMEM_ARB_TIMING_RP */
			0x0000001b, /* MC_EMEM_ARB_TIMING_RC */
			0x00000012, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000017, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000004, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000e, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000009, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000009, /* MC_EMEM_ARB_TIMING_W2R */
			0x09090104, /* MC_EMEM_ARB_DA_TURNS */
			0x001e141b, /* MC_EMEM_ARB_DA_COVERS */
			0x71ae2a1c, /* MC_EMEM_ARB_MISC0 */
			0x70000f02, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000017, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000001bb, /* MC_PTSA_GRANT_DECREMENT */
			0x006e0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x006e0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x006e003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x006e0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x006e0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x006e0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x006e0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x006e0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080016, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x0000006e, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x006e0019, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x006e0018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x006e0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x006e001b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x0000006e, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x006e0065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x006e001c, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000058, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3300000, /* EMC_CFG */
		0x0000089f, /* EMC_CFG_2 */
		0x0004001c, /* EMC_SEL_DPD_CTRL */
		0xe0040069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430808, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x0002001c, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		1180,       /* expected dvfs latency (ns) */
	},
};

static struct tegra12_emc_table bowmore_emc_table_der[] = {
	{
		0x19,       /* V6.0.3 */
		"05_12750_02_V6.0.3_V1.1", /* DVFS table version */
		12750,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x4000003e, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000000, /* EMC_RC */
			0x00000003, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x0000000b, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000002, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x00000003, /* EMC_TXSR */
			0x00000002, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000003, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000006, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000036, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a296, /* EMC_FBIO_CFG5 */
			0x005800a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00048000, /* EMC_DLL_XFORM_DQS0 */
			0x00048000, /* EMC_DLL_XFORM_DQS1 */
			0x00048000, /* EMC_DLL_XFORM_DQS2 */
			0x00048000, /* EMC_DLL_XFORM_DQS3 */
			0x00048000, /* EMC_DLL_XFORM_DQS4 */
			0x00048000, /* EMC_DLL_XFORM_DQS5 */
			0x00048000, /* EMC_DLL_XFORM_DQS6 */
			0x00048000, /* EMC_DLL_XFORM_DQS7 */
			0x00048000, /* EMC_DLL_XFORM_DQS8 */
			0x00048000, /* EMC_DLL_XFORM_DQS9 */
			0x00048000, /* EMC_DLL_XFORM_DQS10 */
			0x00048000, /* EMC_DLL_XFORM_DQS11 */
			0x00048000, /* EMC_DLL_XFORM_DQS12 */
			0x00048000, /* EMC_DLL_XFORM_DQS13 */
			0x00048000, /* EMC_DLL_XFORM_DQS14 */
			0x00048000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR0 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR3 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x0002c000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x00000200, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x0130b018, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc000, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000011, /* EMC_ZCAL_WAIT_CNT */
			0x000d0011, /* EMC_MRS_WAIT_CNT */
			0x000d0011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f3f3, /* EMC_CFG_PIPE */
			0x8000011c, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x40040001, /* MC_EMEM_ARB_CFG */
			0x8000000a, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040102, /* MC_EMEM_ARB_DA_TURNS */
			0x00090402, /* MC_EMEM_ARB_DA_COVERS */
			0x77c30303, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000007, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000015, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3200000, /* EMC_CFG */
		0x000008c7, /* EMC_CFG_2 */
		0x0004013c, /* EMC_SEL_DPD_CTRL */
		0x00580068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		57820,      /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_20400_02_V6.0.3_V1.1", /* DVFS table version */
		20400,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000026, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000001, /* EMC_RC */
			0x00000003, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000013, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000004, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x00000003, /* EMC_TXSR */
			0x00000003, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000003, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000006, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000055, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a296, /* EMC_FBIO_CFG5 */
			0x005800a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00048000, /* EMC_DLL_XFORM_DQS0 */
			0x00048000, /* EMC_DLL_XFORM_DQS1 */
			0x00048000, /* EMC_DLL_XFORM_DQS2 */
			0x00048000, /* EMC_DLL_XFORM_DQS3 */
			0x00048000, /* EMC_DLL_XFORM_DQS4 */
			0x00048000, /* EMC_DLL_XFORM_DQS5 */
			0x00048000, /* EMC_DLL_XFORM_DQS6 */
			0x00048000, /* EMC_DLL_XFORM_DQS7 */
			0x00048000, /* EMC_DLL_XFORM_DQS8 */
			0x00048000, /* EMC_DLL_XFORM_DQS9 */
			0x00048000, /* EMC_DLL_XFORM_DQS10 */
			0x00048000, /* EMC_DLL_XFORM_DQS11 */
			0x00048000, /* EMC_DLL_XFORM_DQS12 */
			0x00048000, /* EMC_DLL_XFORM_DQS13 */
			0x00048000, /* EMC_DLL_XFORM_DQS14 */
			0x00048000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR0 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR3 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x0002c000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x00000200, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x0130b018, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc000, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000011, /* EMC_ZCAL_WAIT_CNT */
			0x00150011, /* EMC_MRS_WAIT_CNT */
			0x00150011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f3f3, /* EMC_CFG_PIPE */
			0x8000012a, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x40020001, /* MC_EMEM_ARB_CFG */
			0x80000012, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040102, /* MC_EMEM_ARB_DA_TURNS */
			0x00090402, /* MC_EMEM_ARB_DA_COVERS */
			0x74e30303, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x0000000a, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000015, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3200000, /* EMC_CFG */
		0x000008c7, /* EMC_CFG_2 */
		0x0004013c, /* EMC_SEL_DPD_CTRL */
		0x00580068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		35610,      /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_40800_02_V6.0.3_V1.1", /* DVFS table version */
		40800,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000012, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000002, /* EMC_RC */
			0x00000005, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000026, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000009, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x00000006, /* EMC_TXSR */
			0x00000006, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000003, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000006, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x000000aa, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a296, /* EMC_FBIO_CFG5 */
			0x005800a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00048000, /* EMC_DLL_XFORM_DQS0 */
			0x00048000, /* EMC_DLL_XFORM_DQS1 */
			0x00048000, /* EMC_DLL_XFORM_DQS2 */
			0x00048000, /* EMC_DLL_XFORM_DQS3 */
			0x00048000, /* EMC_DLL_XFORM_DQS4 */
			0x00048000, /* EMC_DLL_XFORM_DQS5 */
			0x00048000, /* EMC_DLL_XFORM_DQS6 */
			0x00048000, /* EMC_DLL_XFORM_DQS7 */
			0x00048000, /* EMC_DLL_XFORM_DQS8 */
			0x00048000, /* EMC_DLL_XFORM_DQS9 */
			0x00048000, /* EMC_DLL_XFORM_DQS10 */
			0x00048000, /* EMC_DLL_XFORM_DQS11 */
			0x00048000, /* EMC_DLL_XFORM_DQS12 */
			0x00048000, /* EMC_DLL_XFORM_DQS13 */
			0x00048000, /* EMC_DLL_XFORM_DQS14 */
			0x00048000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR0 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR3 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x0002c000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x00000200, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x0130b018, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc000, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000011, /* EMC_ZCAL_WAIT_CNT */
			0x00290011, /* EMC_MRS_WAIT_CNT */
			0x00290011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f3f3, /* EMC_CFG_PIPE */
			0x80000151, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0xa0000001, /* MC_EMEM_ARB_CFG */
			0x80000017, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040102, /* MC_EMEM_ARB_DA_TURNS */
			0x00090402, /* MC_EMEM_ARB_DA_COVERS */
			0x73030303, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000014, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000015, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3200000, /* EMC_CFG */
		0x000008c7, /* EMC_CFG_2 */
		0x0004013c, /* EMC_SEL_DPD_CTRL */
		0x00580068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		20850,      /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_68000_02_V6.0.3_V1.1", /* DVFS table version */
		68000,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x4000000a, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000004, /* EMC_RC */
			0x00000008, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000040, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000010, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x0000000a, /* EMC_TXSR */
			0x0000000a, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000003, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000006, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x0000011b, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a296, /* EMC_FBIO_CFG5 */
			0x005800a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00048000, /* EMC_DLL_XFORM_DQS0 */
			0x00048000, /* EMC_DLL_XFORM_DQS1 */
			0x00048000, /* EMC_DLL_XFORM_DQS2 */
			0x00048000, /* EMC_DLL_XFORM_DQS3 */
			0x00048000, /* EMC_DLL_XFORM_DQS4 */
			0x00048000, /* EMC_DLL_XFORM_DQS5 */
			0x00048000, /* EMC_DLL_XFORM_DQS6 */
			0x00048000, /* EMC_DLL_XFORM_DQS7 */
			0x00048000, /* EMC_DLL_XFORM_DQS8 */
			0x00048000, /* EMC_DLL_XFORM_DQS9 */
			0x00048000, /* EMC_DLL_XFORM_DQS10 */
			0x00048000, /* EMC_DLL_XFORM_DQS11 */
			0x00048000, /* EMC_DLL_XFORM_DQS12 */
			0x00048000, /* EMC_DLL_XFORM_DQS13 */
			0x00048000, /* EMC_DLL_XFORM_DQS14 */
			0x00048000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR0 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR3 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x0002c000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x00000200, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x0130b018, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc000, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000019, /* EMC_ZCAL_WAIT_CNT */
			0x00440011, /* EMC_MRS_WAIT_CNT */
			0x00440011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f3f3, /* EMC_CFG_PIPE */
			0x80000185, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x00000001, /* MC_EMEM_ARB_CFG */
			0x8000001e, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040102, /* MC_EMEM_ARB_DA_TURNS */
			0x00090402, /* MC_EMEM_ARB_DA_COVERS */
			0x72630403, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000021, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00b0, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ec, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ec, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00e90049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00a3, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ef, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ef, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ee00ef, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000015, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3200000, /* EMC_CFG */
		0x000008c7, /* EMC_CFG_2 */
		0x0004013c, /* EMC_SEL_DPD_CTRL */
		0x00580068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		10720,      /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_102000_03_V6.0.3_V1.1", /* DVFS table version */
		102000,     /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000006, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000006, /* EMC_RC */
			0x0000000d, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000004, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000060, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000018, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x0000000f, /* EMC_TXSR */
			0x0000000f, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000003, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000006, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x000001a9, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a296, /* EMC_FBIO_CFG5 */
			0x005800a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00048000, /* EMC_DLL_XFORM_DQS0 */
			0x00048000, /* EMC_DLL_XFORM_DQS1 */
			0x00048000, /* EMC_DLL_XFORM_DQS2 */
			0x00048000, /* EMC_DLL_XFORM_DQS3 */
			0x00048000, /* EMC_DLL_XFORM_DQS4 */
			0x00048000, /* EMC_DLL_XFORM_DQS5 */
			0x00048000, /* EMC_DLL_XFORM_DQS6 */
			0x00048000, /* EMC_DLL_XFORM_DQS7 */
			0x00048000, /* EMC_DLL_XFORM_DQS8 */
			0x00048000, /* EMC_DLL_XFORM_DQS9 */
			0x00048000, /* EMC_DLL_XFORM_DQS10 */
			0x00048000, /* EMC_DLL_XFORM_DQS11 */
			0x00048000, /* EMC_DLL_XFORM_DQS12 */
			0x00048000, /* EMC_DLL_XFORM_DQS13 */
			0x00048000, /* EMC_DLL_XFORM_DQS14 */
			0x00048000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR0 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR3 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x00000200, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x0130b018, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc000, /* EMC_XM2CLKPADCTRL */
			0x00000404, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000025, /* EMC_ZCAL_WAIT_CNT */
			0x00660011, /* EMC_MRS_WAIT_CNT */
			0x00660011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f3f3, /* EMC_CFG_PIPE */
			0x800001c5, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x08000001, /* MC_EMEM_ARB_CFG */
			0x80000026, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000003, /* MC_EMEM_ARB_TIMING_RC */
			0x00000001, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040102, /* MC_EMEM_ARB_DA_TURNS */
			0x00090403, /* MC_EMEM_ARB_DA_COVERS */
			0x72430504, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000031, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff0075, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff009d, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff009d, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x009b0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ad, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00c6, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00d6, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x0000009f, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x0000009f, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x009f00a0, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000015, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3200000, /* EMC_CFG */
		0x000008c7, /* EMC_CFG_2 */
		0x0004013c, /* EMC_SEL_DPD_CTRL */
		0x00580068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		6890,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_204000_04_V6.0.3_V1.1", /* DVFS table version */
		204000,     /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000002, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000000c, /* EMC_RC */
			0x0000001a, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000008, /* EMC_RAS */
			0x00000004, /* EMC_RP */
			0x00000007, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000004, /* EMC_RD_RCD */
			0x00000004, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000002, /* EMC_WDV */
			0x00000002, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000003, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x00000007, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x0000000e, /* EMC_QSAFE */
			0x0000000f, /* EMC_RDV */
			0x00000011, /* EMC_RDV_MASK */
			0x000000c1, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000030, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000004, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x0000001d, /* EMC_TXSR */
			0x0000001d, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000004, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000009, /* EMC_TFAW */
			0x00000005, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000351, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a296, /* EMC_FBIO_CFG5 */
			0x005800a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00048000, /* EMC_DLL_XFORM_DQS0 */
			0x00048000, /* EMC_DLL_XFORM_DQS1 */
			0x00048000, /* EMC_DLL_XFORM_DQS2 */
			0x00048000, /* EMC_DLL_XFORM_DQS3 */
			0x00048000, /* EMC_DLL_XFORM_DQS4 */
			0x00048000, /* EMC_DLL_XFORM_DQS5 */
			0x00048000, /* EMC_DLL_XFORM_DQS6 */
			0x00048000, /* EMC_DLL_XFORM_DQS7 */
			0x00048000, /* EMC_DLL_XFORM_DQS8 */
			0x00048000, /* EMC_DLL_XFORM_DQS9 */
			0x00048000, /* EMC_DLL_XFORM_DQS10 */
			0x00048000, /* EMC_DLL_XFORM_DQS11 */
			0x00048000, /* EMC_DLL_XFORM_DQS12 */
			0x00048000, /* EMC_DLL_XFORM_DQS13 */
			0x00048000, /* EMC_DLL_XFORM_DQS14 */
			0x00048000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00090000, /* EMC_DLL_XFORM_ADDR0 */
			0x00090000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00090000, /* EMC_DLL_XFORM_ADDR3 */
			0x00090000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0008c000, /* EMC_DLL_XFORM_DQ0 */
			0x0008c000, /* EMC_DLL_XFORM_DQ1 */
			0x00070000, /* EMC_DLL_XFORM_DQ2 */
			0x0008c000, /* EMC_DLL_XFORM_DQ3 */
			0x00008c00, /* EMC_DLL_XFORM_DQ4 */
			0x00008c00, /* EMC_DLL_XFORM_DQ5 */
			0x00008800, /* EMC_DLL_XFORM_DQ6 */
			0x00009400, /* EMC_DLL_XFORM_DQ7 */
			0x00000200, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x0130b018, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc000, /* EMC_XM2CLKPADCTRL */
			0x00000202, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000004a, /* EMC_ZCAL_WAIT_CNT */
			0x00cc0011, /* EMC_MRS_WAIT_CNT */
			0x00cc0011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x0000d3b3, /* EMC_CFG_PIPE */
			0x80000287, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x01000003, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RP */
			0x00000006, /* MC_EMEM_ARB_TIMING_RC */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000005, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05050103, /* MC_EMEM_ARB_DA_TURNS */
			0x000b0606, /* MC_EMEM_ARB_DA_COVERS */
			0x71e40a07, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000062, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00af, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff004f, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00af, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff004f, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x004e0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080057, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0063, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff0036, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff006b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000050, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000050, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510050, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00c6, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000017, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3200000, /* EMC_CFG */
		0x000008cf, /* EMC_CFG_2 */
		0x0004013c, /* EMC_SEL_DPD_CTRL */
		0x00580068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		3420,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_300000_03_V6.0.3_V1.1", /* DVFS table version */
		300000,     /* SDRAM frequency */
		820,        /* min voltage */
		820,        /* gpu min voltage */
		"pllc_out0", /* clock source id */
		0x20000002, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000012, /* EMC_RC */
			0x00000026, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x0000000d, /* EMC_RAS */
			0x00000005, /* EMC_RP */
			0x00000007, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000005, /* EMC_RD_RCD */
			0x00000005, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000002, /* EMC_WDV */
			0x00000002, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000003, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x00000008, /* EMC_EINPUT_DURATION */
			0x00030000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x0000000f, /* EMC_QSAFE */
			0x00000012, /* EMC_RDV */
			0x00000014, /* EMC_RDV_MASK */
			0x0000011c, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000047, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000005, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x0000002a, /* EMC_TXSR */
			0x0000002a, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x0000000d, /* EMC_TFAW */
			0x00000007, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x000004e0, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a096, /* EMC_FBIO_CFG5 */
			0x005800a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00020000, /* EMC_DLL_XFORM_DQS0 */
			0x00020000, /* EMC_DLL_XFORM_DQS1 */
			0x00020000, /* EMC_DLL_XFORM_DQS2 */
			0x00020000, /* EMC_DLL_XFORM_DQS3 */
			0x00020000, /* EMC_DLL_XFORM_DQS4 */
			0x00020000, /* EMC_DLL_XFORM_DQS5 */
			0x00020000, /* EMC_DLL_XFORM_DQS6 */
			0x00020000, /* EMC_DLL_XFORM_DQS7 */
			0x00020000, /* EMC_DLL_XFORM_DQS8 */
			0x00020000, /* EMC_DLL_XFORM_DQS9 */
			0x00020000, /* EMC_DLL_XFORM_DQS10 */
			0x00020000, /* EMC_DLL_XFORM_DQS11 */
			0x00020000, /* EMC_DLL_XFORM_DQS12 */
			0x00020000, /* EMC_DLL_XFORM_DQS13 */
			0x00020000, /* EMC_DLL_XFORM_DQS14 */
			0x00020000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00060000, /* EMC_DLL_XFORM_ADDR0 */
			0x00060000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00060000, /* EMC_DLL_XFORM_ADDR3 */
			0x00060000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0005c000, /* EMC_DLL_XFORM_DQ0 */
			0x0005c000, /* EMC_DLL_XFORM_DQ1 */
			0x0003c000, /* EMC_DLL_XFORM_DQ2 */
			0x0005c000, /* EMC_DLL_XFORM_DQ3 */
			0x00005c00, /* EMC_DLL_XFORM_DQ4 */
			0x00005c00, /* EMC_DLL_XFORM_DQ5 */
			0x00005800, /* EMC_DLL_XFORM_DQ6 */
			0x00006000, /* EMC_DLL_XFORM_DQ7 */
			0x00000200, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x01231239, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc000, /* EMC_XM2CLKPADCTRL */
			0x00000202, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000006c, /* EMC_ZCAL_WAIT_CNT */
			0x012c0011, /* EMC_MRS_WAIT_CNT */
			0x012c0011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x000052a3, /* EMC_CFG_PIPE */
			0x8000033e, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000b, /* EMC_QPOP */
			0x08000004, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RP */
			0x00000009, /* MC_EMEM_ARB_TIMING_RC */
			0x00000005, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000007, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05050103, /* MC_EMEM_ARB_DA_TURNS */
			0x000c0709, /* MC_EMEM_ARB_DA_COVERS */
			0x71c50e0a, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000004, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000090, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00350049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008003b, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0043, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff002d, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510036, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff0087, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x0000001f, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3300000, /* EMC_CFG */
		0x000008d7, /* EMC_CFG_2 */
		0x0004013c, /* EMC_SEL_DPD_CTRL */
		0x00580068, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		2680,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_396000_03_V6.0.3_V1.1", /* DVFS table version */
		396000,     /* SDRAM frequency */
		850,        /* min voltage */
		850,        /* gpu min voltage */
		"pllm_out0", /* clock source id */
		0x00000002, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000018, /* EMC_RC */
			0x00000033, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000011, /* EMC_RAS */
			0x00000007, /* EMC_RP */
			0x00000008, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000007, /* EMC_RD_RCD */
			0x00000007, /* EMC_WR_RCD */
			0x00000004, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000002, /* EMC_WDV */
			0x00000002, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000003, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000002, /* EMC_EINPUT */
			0x00000009, /* EMC_EINPUT_DURATION */
			0x00030000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000001, /* EMC_QRST */
			0x00000010, /* EMC_QSAFE */
			0x00000012, /* EMC_RDV */
			0x00000014, /* EMC_RDV_MASK */
			0x00000176, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x0000005d, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000007, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000e, /* EMC_RW2PDEN */
			0x00000038, /* EMC_TXSR */
			0x00000038, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000006, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000012, /* EMC_TFAW */
			0x0000000a, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000670, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a096, /* EMC_FBIO_CFG5 */
			0x005800a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000000, /* EMC_DLL_XFORM_DQS0 */
			0x00000000, /* EMC_DLL_XFORM_DQS1 */
			0x00000000, /* EMC_DLL_XFORM_DQS2 */
			0x00000000, /* EMC_DLL_XFORM_DQS3 */
			0x00000000, /* EMC_DLL_XFORM_DQS4 */
			0x00000000, /* EMC_DLL_XFORM_DQS5 */
			0x00000000, /* EMC_DLL_XFORM_DQS6 */
			0x00000000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_DQS8 */
			0x00000000, /* EMC_DLL_XFORM_DQS9 */
			0x00000000, /* EMC_DLL_XFORM_DQS10 */
			0x00000000, /* EMC_DLL_XFORM_DQS11 */
			0x00000000, /* EMC_DLL_XFORM_DQS12 */
			0x00000000, /* EMC_DLL_XFORM_DQS13 */
			0x00000000, /* EMC_DLL_XFORM_DQS14 */
			0x00000000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00058000, /* EMC_DLL_XFORM_ADDR0 */
			0x00058000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00058000, /* EMC_DLL_XFORM_ADDR3 */
			0x00058000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00038000, /* EMC_DLL_XFORM_DQ0 */
			0x00038000, /* EMC_DLL_XFORM_DQ1 */
			0x00038000, /* EMC_DLL_XFORM_DQ2 */
			0x00038000, /* EMC_DLL_XFORM_DQ3 */
			0x00003800, /* EMC_DLL_XFORM_DQ4 */
			0x00003800, /* EMC_DLL_XFORM_DQ5 */
			0x00003800, /* EMC_DLL_XFORM_DQ6 */
			0x00003800, /* EMC_DLL_XFORM_DQ7 */
			0x00000200, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x01231239, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc000, /* EMC_XM2CLKPADCTRL */
			0x00000202, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000008f, /* EMC_ZCAL_WAIT_CNT */
			0x018c0011, /* EMC_MRS_WAIT_CNT */
			0x018c0011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x000052a3, /* EMC_CFG_PIPE */
			0x800003f4, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000b, /* EMC_QPOP */
			0x0f000005, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000002, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RP */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RC */
			0x00000007, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000009, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05050103, /* MC_EMEM_ARB_DA_TURNS */
			0x000e090c, /* MC_EMEM_ARB_DA_COVERS */
			0x71c6120d, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000a, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000000be, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00280049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008002d, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0033, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff0022, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff0037, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff0066, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000028, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3300000, /* EMC_CFG */
		0x00000897, /* EMC_CFG_2 */
		0x0004001c, /* EMC_SEL_DPD_CTRL */
		0x00580068, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		2180,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_528000_03_V6.0.3_V1.1", /* DVFS table version */
		528000,     /* SDRAM frequency */
		880,        /* min voltage */
		870,        /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000020, /* EMC_RC */
			0x00000044, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000017, /* EMC_RAS */
			0x0000000a, /* EMC_RP */
			0x0000000a, /* EMC_R2W */
			0x00000009, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000d, /* EMC_W2P */
			0x0000000a, /* EMC_RD_RCD */
			0x0000000a, /* EMC_WR_RCD */
			0x00000006, /* EMC_RRD */
			0x00000004, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000002, /* EMC_WDV */
			0x00000002, /* EMC_WDV_MASK */
			0x00000008, /* EMC_QUSE */
			0x00000003, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x0000000a, /* EMC_EINPUT_DURATION */
			0x00050000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x00000011, /* EMC_QSAFE */
			0x00000015, /* EMC_RDV */
			0x00000017, /* EMC_RDV_MASK */
			0x000001f3, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x0000007c, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000003, /* EMC_PDEX2WR */
			0x00000003, /* EMC_PDEX2RD */
			0x0000000a, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000011, /* EMC_RW2PDEN */
			0x0000004a, /* EMC_TXSR */
			0x0000004a, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000008, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000019, /* EMC_TFAW */
			0x0000000d, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000895, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a096, /* EMC_FBIO_CFG5 */
			0xe01200b9, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000000a, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_DLL_XFORM_DQS1 */
			0x0000000a, /* EMC_DLL_XFORM_DQS2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS3 */
			0x0000000a, /* EMC_DLL_XFORM_DQS4 */
			0x0000000a, /* EMC_DLL_XFORM_DQS5 */
			0x0000000a, /* EMC_DLL_XFORM_DQS6 */
			0x0000000a, /* EMC_DLL_XFORM_DQS7 */
			0x0000000a, /* EMC_DLL_XFORM_DQS8 */
			0x0000000a, /* EMC_DLL_XFORM_DQS9 */
			0x0000000a, /* EMC_DLL_XFORM_DQS10 */
			0x0000000a, /* EMC_DLL_XFORM_DQS11 */
			0x0000000a, /* EMC_DLL_XFORM_DQS12 */
			0x0000000a, /* EMC_DLL_XFORM_DQS13 */
			0x0000000a, /* EMC_DLL_XFORM_DQS14 */
			0x0000000a, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0000000f, /* EMC_DLL_XFORM_ADDR0 */
			0x0000000f, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0000000f, /* EMC_DLL_XFORM_ADDR3 */
			0x0000000f, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00000008, /* EMC_DLL_XFORM_DQ0 */
			0x00000008, /* EMC_DLL_XFORM_DQ1 */
			0x00000008, /* EMC_DLL_XFORM_DQ2 */
			0x00000008, /* EMC_DLL_XFORM_DQ3 */
			0x00000008, /* EMC_DLL_XFORM_DQ4 */
			0x00000008, /* EMC_DLL_XFORM_DQ5 */
			0x00000008, /* EMC_DLL_XFORM_DQ6 */
			0x00000008, /* EMC_DLL_XFORM_DQ7 */
			0x00000220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x0123123d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x00000202, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x000000bf, /* EMC_ZCAL_WAIT_CNT */
			0x02100013, /* EMC_MRS_WAIT_CNT */
			0x02100013, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x000042a0, /* EMC_CFG_PIPE */
			0x800004ef, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000d, /* EMC_QPOP */
			0x0f000007, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000004, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000005, /* MC_EMEM_ARB_TIMING_RP */
			0x00000011, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000a, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000d, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000003, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000009, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06060103, /* MC_EMEM_ARB_DA_TURNS */
			0x00130c11, /* MC_EMEM_ARB_DA_COVERS */
			0x71c81812, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000d, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000000fd, /* MC_PTSA_GRANT_DECREMENT */
			0x00c10038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00c10038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00c1003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00c10090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00c10041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00c10090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00c10041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00c10080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080021, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000c1, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00c10026, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00c1001a, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00c10024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00c10029, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000c1, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00c10065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00c1002a, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000034, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3300000, /* EMC_CFG */
		0x0000089f, /* EMC_CFG_2 */
		0x0004001c, /* EMC_SEL_DPD_CTRL */
		0xe0120069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x000100c3, /* Mode Register 1 */
		0x00020006, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		1440,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_600000_02_V6.0.3_V1.1", /* DVFS table version */
		600000,     /* SDRAM frequency */
		910,        /* min voltage */
		910,        /* gpu min voltage */
		"pllc_ud",  /* clock source id */
		0xe0000000, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000025, /* EMC_RC */
			0x0000004d, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x0000001a, /* EMC_RAS */
			0x0000000b, /* EMC_RP */
			0x0000000a, /* EMC_R2W */
			0x0000000b, /* EMC_W2R */
			0x00000004, /* EMC_R2P */
			0x0000000f, /* EMC_W2P */
			0x0000000b, /* EMC_RD_RCD */
			0x0000000b, /* EMC_WR_RCD */
			0x00000007, /* EMC_RRD */
			0x00000004, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000004, /* EMC_WDV */
			0x00000004, /* EMC_WDV_MASK */
			0x0000000a, /* EMC_QUSE */
			0x00000004, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x0000000d, /* EMC_EINPUT_DURATION */
			0x00070000, /* EMC_PUTERM_EXTRA */
			0x00000005, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x00000014, /* EMC_QSAFE */
			0x00000018, /* EMC_RDV */
			0x0000001a, /* EMC_RDV_MASK */
			0x00000237, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x0000008d, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000004, /* EMC_PDEX2WR */
			0x00000004, /* EMC_PDEX2RD */
			0x0000000b, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000013, /* EMC_RW2PDEN */
			0x00000054, /* EMC_TXSR */
			0x00000054, /* EMC_TXSRDLL */
			0x00000005, /* EMC_TCKE */
			0x00000009, /* EMC_TCKESR */
			0x00000005, /* EMC_TPD */
			0x0000001c, /* EMC_TFAW */
			0x0000000e, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x000009c1, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a096, /* EMC_FBIO_CFG5 */
			0xe00e00b9, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000000a, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_DLL_XFORM_DQS1 */
			0x0000000a, /* EMC_DLL_XFORM_DQS2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS3 */
			0x0000000a, /* EMC_DLL_XFORM_DQS4 */
			0x0000000a, /* EMC_DLL_XFORM_DQS5 */
			0x0000000a, /* EMC_DLL_XFORM_DQS6 */
			0x0000000a, /* EMC_DLL_XFORM_DQS7 */
			0x0000000a, /* EMC_DLL_XFORM_DQS8 */
			0x0000000a, /* EMC_DLL_XFORM_DQS9 */
			0x0000000a, /* EMC_DLL_XFORM_DQS10 */
			0x0000000a, /* EMC_DLL_XFORM_DQS11 */
			0x0000000a, /* EMC_DLL_XFORM_DQS12 */
			0x0000000a, /* EMC_DLL_XFORM_DQS13 */
			0x0000000a, /* EMC_DLL_XFORM_DQS14 */
			0x0000000a, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0000000e, /* EMC_DLL_XFORM_ADDR0 */
			0x0000000e, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0000000e, /* EMC_DLL_XFORM_ADDR3 */
			0x0000000e, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00000009, /* EMC_DLL_XFORM_DQ0 */
			0x00000009, /* EMC_DLL_XFORM_DQ1 */
			0x00000009, /* EMC_DLL_XFORM_DQ2 */
			0x00000009, /* EMC_DLL_XFORM_DQ3 */
			0x00000009, /* EMC_DLL_XFORM_DQ4 */
			0x00000009, /* EMC_DLL_XFORM_DQ5 */
			0x00000009, /* EMC_DLL_XFORM_DQ6 */
			0x00000009, /* EMC_DLL_XFORM_DQ7 */
			0x00000220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x0121103d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x00000202, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x49249220, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x49249200, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x000000d8, /* EMC_ZCAL_WAIT_CNT */
			0x02580014, /* EMC_MRS_WAIT_CNT */
			0x02580014, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000005, /* EMC_CTT_DURATION */
			0x000040a0, /* EMC_CFG_PIPE */
			0x80000578, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000010, /* EMC_QPOP */
			0x00000009, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000004, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000005, /* MC_EMEM_ARB_TIMING_RP */
			0x00000013, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000e, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000003, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000a, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_W2R */
			0x07060103, /* MC_EMEM_ARB_DA_TURNS */
			0x00150e13, /* MC_EMEM_ARB_DA_COVERS */
			0x71a91b14, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000f, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000120, /* MC_PTSA_GRANT_DECREMENT */
			0x00aa0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00aa0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00aa003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00aa0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00aa0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00aa0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00aa0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00aa0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008001d, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000aa, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00aa0022, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00aa0018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00aa0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00aa0024, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000aa, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00aa0065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00aa0025, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x0000003a, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3300000, /* EMC_CFG */
		0x0000089f, /* EMC_CFG_2 */
		0x0004001c, /* EMC_SEL_DPD_CTRL */
		0xe00e0069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x000100e3, /* Mode Register 1 */
		0x00020007, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		1440,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_792000_03_V6.0.3_V1.1", /* DVFS table version */
		792000,     /* SDRAM frequency */
		980,        /* min voltage */
		980,        /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000030, /* EMC_RC */
			0x00000066, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000022, /* EMC_RAS */
			0x0000000f, /* EMC_RP */
			0x0000000e, /* EMC_R2W */
			0x0000000d, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x00000013, /* EMC_W2P */
			0x0000000f, /* EMC_RD_RCD */
			0x0000000f, /* EMC_WR_RCD */
			0x00000009, /* EMC_RRD */
			0x00000004, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x0000000e, /* EMC_QUSE */
			0x00000004, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x0000000f, /* EMC_EINPUT_DURATION */
			0x000b0000, /* EMC_PUTERM_EXTRA */
			0x00000006, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x00000016, /* EMC_QSAFE */
			0x0000001d, /* EMC_RDV */
			0x0000001f, /* EMC_RDV_MASK */
			0x000002ec, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000000bb, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000005, /* EMC_PDEX2WR */
			0x00000005, /* EMC_PDEX2RD */
			0x0000000f, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000017, /* EMC_RW2PDEN */
			0x0000006f, /* EMC_TXSR */
			0x0000006f, /* EMC_TXSRDLL */
			0x00000006, /* EMC_TCKE */
			0x0000000c, /* EMC_TCKESR */
			0x00000006, /* EMC_TPD */
			0x00000026, /* EMC_TFAW */
			0x00000013, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000cdf, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a096, /* EMC_FBIO_CFG5 */
			0xe00700b9, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000007, /* EMC_DLL_XFORM_DQS0 */
			0x00000006, /* EMC_DLL_XFORM_DQS1 */
			0x00000006, /* EMC_DLL_XFORM_DQS2 */
			0x00000007, /* EMC_DLL_XFORM_DQS3 */
			0x00000008, /* EMC_DLL_XFORM_DQS4 */
			0x00000008, /* EMC_DLL_XFORM_DQS5 */
			0x00000008, /* EMC_DLL_XFORM_DQS6 */
			0x00000008, /* EMC_DLL_XFORM_DQS7 */
			0x00000007, /* EMC_DLL_XFORM_DQS8 */
			0x00000006, /* EMC_DLL_XFORM_DQS9 */
			0x00000006, /* EMC_DLL_XFORM_DQS10 */
			0x00000007, /* EMC_DLL_XFORM_DQS11 */
			0x00000008, /* EMC_DLL_XFORM_DQS12 */
			0x00000008, /* EMC_DLL_XFORM_DQS13 */
			0x00000008, /* EMC_DLL_XFORM_DQS14 */
			0x00000008, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0000000b, /* EMC_DLL_XFORM_ADDR0 */
			0x0000000b, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0000000b, /* EMC_DLL_XFORM_ADDR3 */
			0x0000000b, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00000009, /* EMC_DLL_XFORM_DQ0 */
			0x00000009, /* EMC_DLL_XFORM_DQ1 */
			0x00000009, /* EMC_DLL_XFORM_DQ2 */
			0x00000009, /* EMC_DLL_XFORM_DQ3 */
			0x00000009, /* EMC_DLL_XFORM_DQ4 */
			0x00000009, /* EMC_DLL_XFORM_DQ5 */
			0x00000009, /* EMC_DLL_XFORM_DQ6 */
			0x00000009, /* EMC_DLL_XFORM_DQ7 */
			0x00000220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x0120103d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x00000000, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00618618, /* EMC_XM2DQSPADCTRL4 */
			0x00618618, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000011e, /* EMC_ZCAL_WAIT_CNT */
			0x03180017, /* EMC_MRS_WAIT_CNT */
			0x03180017, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000006, /* EMC_CTT_DURATION */
			0x00004080, /* EMC_CFG_PIPE */
			0x800006e5, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000014, /* EMC_QPOP */
			0x0e00000b, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000006, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000007, /* MC_EMEM_ARB_TIMING_RP */
			0x00000019, /* MC_EMEM_ARB_TIMING_RC */
			0x00000010, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000013, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000004, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000c, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_W2R */
			0x08080103, /* MC_EMEM_ARB_DA_TURNS */
			0x001b1219, /* MC_EMEM_ARB_DA_COVERS */
			0x71ac241a, /* MC_EMEM_ARB_MISC0 */
			0x70000f02, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000013, /* MC_MLL_MPCORER_PTSA_RATE */
			0x0000017c, /* MC_PTSA_GRANT_DECREMENT */
			0x00810038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00810038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x0081003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00810090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00810041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00810090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00810041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00810080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080016, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x00000081, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00810019, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00810018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00810024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x0081001c, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x00000081, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00810065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x0081001c, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x0000004c, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3300000, /* EMC_CFG */
		0x0000089f, /* EMC_CFG_2 */
		0x0004001c, /* EMC_SEL_DPD_CTRL */
		0xe0070069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x00010043, /* Mode Register 1 */
		0x0002001a, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		1200,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.3 */
		"05_924000_05_V6.0.3_V1.1", /* DVFS table version */
		924000,     /* SDRAM frequency */
		1010,       /* min voltage */
		1010,       /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000039, /* EMC_RC */
			0x00000078, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000028, /* EMC_RAS */
			0x00000012, /* EMC_RP */
			0x00000010, /* EMC_R2W */
			0x00000010, /* EMC_W2R */
			0x00000006, /* EMC_R2P */
			0x00000017, /* EMC_W2P */
			0x00000012, /* EMC_RD_RCD */
			0x00000012, /* EMC_WR_RCD */
			0x0000000a, /* EMC_RRD */
			0x00000005, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000007, /* EMC_WDV */
			0x00000007, /* EMC_WDV_MASK */
			0x00000010, /* EMC_QUSE */
			0x00000005, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000012, /* EMC_EINPUT_DURATION */
			0x000d0000, /* EMC_PUTERM_EXTRA */
			0x00000007, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x00000019, /* EMC_QSAFE */
			0x00000020, /* EMC_RDV */
			0x00000022, /* EMC_RDV_MASK */
			0x00000369, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000000da, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000006, /* EMC_PDEX2WR */
			0x00000006, /* EMC_PDEX2RD */
			0x00000012, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000001b, /* EMC_RW2PDEN */
			0x00000082, /* EMC_TXSR */
			0x00000082, /* EMC_TXSRDLL */
			0x00000007, /* EMC_TCKE */
			0x0000000e, /* EMC_TCKESR */
			0x00000007, /* EMC_TPD */
			0x0000002d, /* EMC_TFAW */
			0x00000016, /* EMC_TRPAB */
			0x00000003, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000f04, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1363a896, /* EMC_FBIO_CFG5 */
			0xe00400b9, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x007f800c, /* EMC_DLL_XFORM_DQS0 */
			0x00000007, /* EMC_DLL_XFORM_DQS1 */
			0x00000003, /* EMC_DLL_XFORM_DQS2 */
			0x00000003, /* EMC_DLL_XFORM_DQS3 */
			0x00000003, /* EMC_DLL_XFORM_DQS4 */
			0x00000005, /* EMC_DLL_XFORM_DQS5 */
			0x00000006, /* EMC_DLL_XFORM_DQS6 */
			0x00000005, /* EMC_DLL_XFORM_DQS7 */
			0x007f800c, /* EMC_DLL_XFORM_DQS8 */
			0x00000007, /* EMC_DLL_XFORM_DQS9 */
			0x00000003, /* EMC_DLL_XFORM_DQS10 */
			0x00000003, /* EMC_DLL_XFORM_DQS11 */
			0x00000003, /* EMC_DLL_XFORM_DQS12 */
			0x00000005, /* EMC_DLL_XFORM_DQS13 */
			0x00000006, /* EMC_DLL_XFORM_DQS14 */
			0x00000005, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0000000f, /* EMC_DLL_XFORM_ADDR0 */
			0x0000000f, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0000000f, /* EMC_DLL_XFORM_ADDR3 */
			0x0000000f, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00000009, /* EMC_DLL_XFORM_DQ0 */
			0x00000009, /* EMC_DLL_XFORM_DQ1 */
			0x00000009, /* EMC_DLL_XFORM_DQ2 */
			0x00000009, /* EMC_DLL_XFORM_DQ3 */
			0x00000009, /* EMC_DLL_XFORM_DQ4 */
			0x00000009, /* EMC_DLL_XFORM_DQ5 */
			0x00000009, /* EMC_DLL_XFORM_DQ6 */
			0x00000009, /* EMC_DLL_XFORM_DQ7 */
			0x00000220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00100100, /* EMC_XM2CMDPADCTRL5 */
			0x0120103d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x00000000, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x07070000, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x015ddddd, /* EMC_XM2VTTGENPADCTRL3 */
			0x5d75d720, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x5d75d700, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000014d, /* EMC_ZCAL_WAIT_CNT */
			0x039c0019, /* EMC_MRS_WAIT_CNT */
			0x039c0019, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000007, /* EMC_CTT_DURATION */
			0x00004080, /* EMC_CFG_PIPE */
			0x800007e0, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000017, /* EMC_QPOP */
			0x0e00000d, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000008, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000009, /* MC_EMEM_ARB_TIMING_RP */
			0x0000001d, /* MC_EMEM_ARB_TIMING_RC */
			0x00000013, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000017, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000005, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000e, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000009, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000009, /* MC_EMEM_ARB_TIMING_W2R */
			0x09090104, /* MC_EMEM_ARB_DA_TURNS */
			0x0020161d, /* MC_EMEM_ARB_DA_COVERS */
			0x71ae2a1e, /* MC_EMEM_ARB_MISC0 */
			0x70000f02, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000017, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000001bb, /* MC_PTSA_GRANT_DECREMENT */
			0x006e0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x006e0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x006e003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x006e0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x006e0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x006e0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x006e0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x006e0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080016, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x0000006e, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x006e0019, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x006e0018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x006e0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x006e001b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x0000006e, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x006e0065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x006e001c, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000058, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0xf3300000, /* EMC_CFG */
		0x0000089f, /* EMC_CFG_2 */
		0x0004001c, /* EMC_SEL_DPD_CTRL */
		0xe0040069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430808, /* EMC_AUTO_CAL_CONFIG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x0002001c, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		1180,       /* expected dvfs latency (ns) */
	},
};

static struct tegra12_emc_table bowmore_emc_table_2GB[] = {
	{
		0x19,       /* V6.0.4 */
		"04_204000_01_V6.0.4_V1.1", /* DVFS table version */
		204000,     /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000002, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000009, /* EMC_RC */
			0x00000035, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000006, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000005, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000004, /* EMC_EINPUT */
			0x00000006, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000003, /* EMC_QRST */
			0x0000000d, /* EMC_QSAFE */
			0x0000000f, /* EMC_RDV */
			0x00000011, /* EMC_RDV_MASK */
			0x00000607, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000181, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000032, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000038, /* EMC_TXSR */
			0x00000038, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000007, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000638, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1069a298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00008000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00008000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0007c000, /* EMC_DLL_XFORM_DQ0 */
			0x0007c000, /* EMC_DLL_XFORM_DQ1 */
			0x0007c000, /* EMC_DLL_XFORM_DQ2 */
			0x0007c000, /* EMC_DLL_XFORM_DQ3 */
			0x00007c00, /* EMC_DLL_XFORM_DQ4 */
			0x00007c00, /* EMC_DLL_XFORM_DQ5 */
			0x00007c00, /* EMC_DLL_XFORM_DQ6 */
			0x00007c00, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000707, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000066, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000d2b3, /* EMC_CFG_PIPE */
			0x80000d22, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x01000003, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000004, /* MC_EMEM_ARB_TIMING_RC */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000004, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06040203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0504, /* MC_EMEM_ARB_DA_COVERS */
			0x73840a05, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000062, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00af, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff004f, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00af, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff004f, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x004e0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080057, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0063, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff0036, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff006b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000050, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000050, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510050, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00c6, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008cd, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		3420,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"04_744000_01_V6.0.4_V1.1", /* DVFS table version */
		744000,     /* SDRAM frequency */
		980,        /* min voltage */
		980,        /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000022, /* EMC_RC */
			0x000000c1, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000018, /* EMC_RAS */
			0x00000009, /* EMC_RP */
			0x00000008, /* EMC_R2W */
			0x0000000d, /* EMC_W2R */
			0x00000004, /* EMC_R2P */
			0x00000013, /* EMC_W2P */
			0x00000009, /* EMC_RD_RCD */
			0x00000009, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x0000000b, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000002, /* EMC_EINPUT */
			0x0000000d, /* EMC_EINPUT_DURATION */
			0x00080000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000001, /* EMC_QRST */
			0x00000014, /* EMC_QSAFE */
			0x00000018, /* EMC_RDV */
			0x0000001a, /* EMC_RDV_MASK */
			0x0000166b, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x0000059a, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000003, /* EMC_PDEX2WR */
			0x00000010, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x000000bb, /* EMC_AR2PDEN */
			0x00000018, /* EMC_RW2PDEN */
			0x000000ca, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000005, /* EMC_TCKE */
			0x00000006, /* EMC_TCKESR */
			0x00000005, /* EMC_TPD */
			0x0000001b, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000008, /* EMC_TCLKSTABLE */
			0x00000008, /* EMC_TCLKSTOP */
			0x000016ac, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1049b098, /* EMC_FBIO_CFG5 */
			0xe00800b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000006, /* EMC_DLL_XFORM_DQS0 */
			0x00000004, /* EMC_DLL_XFORM_DQS1 */
			0x00000006, /* EMC_DLL_XFORM_DQS2 */
			0x00000004, /* EMC_DLL_XFORM_DQS3 */
			0x00000006, /* EMC_DLL_XFORM_DQS4 */
			0x00000006, /* EMC_DLL_XFORM_DQS5 */
			0x00000006, /* EMC_DLL_XFORM_DQS6 */
			0x00000006, /* EMC_DLL_XFORM_DQS7 */
			0x00000006, /* EMC_DLL_XFORM_DQS8 */
			0x00000004, /* EMC_DLL_XFORM_DQS9 */
			0x00000006, /* EMC_DLL_XFORM_DQS10 */
			0x00000004, /* EMC_DLL_XFORM_DQS11 */
			0x00000006, /* EMC_DLL_XFORM_DQS12 */
			0x00000006, /* EMC_DLL_XFORM_DQS13 */
			0x00000006, /* EMC_DLL_XFORM_DQS14 */
			0x00000006, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00034000, /* EMC_DLL_XFORM_ADDR0 */
			0x00034000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00034000, /* EMC_DLL_XFORM_ADDR3 */
			0x00034000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00000009, /* EMC_DLL_XFORM_DQ0 */
			0x00000009, /* EMC_DLL_XFORM_DQ1 */
			0x00000009, /* EMC_DLL_XFORM_DQ2 */
			0x00000009, /* EMC_DLL_XFORM_DQ3 */
			0x00000009, /* EMC_DLL_XFORM_DQ4 */
			0x00000009, /* EMC_DLL_XFORM_DQ5 */
			0x00000009, /* EMC_DLL_XFORM_DQ6 */
			0x00000009, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0121113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000505, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x61861820, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x61861800, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x0103000e, /* EMC_MRS_WAIT_CNT */
			0x0103000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x00004080, /* EMC_CFG_PIPE */
			0x80002d38, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000f, /* EMC_QPOP */
			0x0300000b, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000004, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000005, /* MC_EMEM_ARB_TIMING_RP */
			0x00000012, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000b, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000e, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000c, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_W2R */
			0x08060202, /* MC_EMEM_ARB_DA_TURNS */
			0x00160d12, /* MC_EMEM_ARB_DA_COVERS */
			0x736c2213, /* MC_EMEM_ARB_MISC0 */
			0x70000f02, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000012, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000165, /* MC_PTSA_GRANT_DECREMENT */
			0x00890038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00890038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x0089003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00890090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00890041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00890090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00890041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00890080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00890004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00890004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080018, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x00000089, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00890004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x0089001b, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00890018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00890024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x0089001d, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x00000089, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00890089, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00890089, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00890089, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00890089, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00890065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x0089001e, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x0000089d, /* EMC_CFG_2 */
		0x00040008, /* EMC_SEL_DPD_CTRL */
		0xe0080069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430808, /* EMC_AUTO_CAL_CONFIG */
		0x80000d71, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200018, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		1200,       /* expected dvfs latency (ns) */
	},
};

static struct tegra12_emc_table e1991_emc_table[] = {
	{
		0x19,       /* V6.0.4 */
		"03_12750_01_V6.0.4_V1.1", /* DVFS table version */
		12750,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x4000003e, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000000, /* EMC_RC */
			0x00000003, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000000, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000060, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000018, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000005, /* EMC_TXSR */
			0x00000005, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000064, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1069a298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00014000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00014000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000007, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f2f3, /* EMC_CFG_PIPE */
			0x800001c5, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x40040001, /* MC_EMEM_ARB_CFG */
			0x8000000a, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0502, /* MC_EMEM_ARB_DA_COVERS */
			0x77e30303, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000007, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		57820,      /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"03_20400_01_V6.0.4_V1.1", /* DVFS table version */
		20400,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000026, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000000, /* EMC_RC */
			0x00000005, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000000, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x0000009a, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000026, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000006, /* EMC_TXSR */
			0x00000006, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x000000a0, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1069a298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00014000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00014000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x0000000b, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f2f3, /* EMC_CFG_PIPE */
			0x8000023a, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x40020001, /* MC_EMEM_ARB_CFG */
			0x80000012, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0502, /* MC_EMEM_ARB_DA_COVERS */
			0x76230303, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x0000000a, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		35610,      /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"03_40800_01_V6.0.4_V1.1", /* DVFS table version */
		40800,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000012, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000001, /* EMC_RC */
			0x0000000a, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000001, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000134, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x0000004d, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000008, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000000c, /* EMC_TXSR */
			0x0000000c, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x0000013f, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1069a298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00014000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00014000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000015, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f2f3, /* EMC_CFG_PIPE */
			0x80000370, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0xa0000001, /* MC_EMEM_ARB_CFG */
			0x80000017, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0502, /* MC_EMEM_ARB_DA_COVERS */
			0x74a30303, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000014, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		20850,      /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"03_68000_01_V6.0.4_V1.1", /* DVFS table version */
		68000,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x4000000a, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000003, /* EMC_RC */
			0x00000011, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000202, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000080, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x0000000f, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000013, /* EMC_TXSR */
			0x00000013, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000001, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000213, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1069a298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00014000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00014000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000022, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f2f3, /* EMC_CFG_PIPE */
			0x8000050e, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x00000001, /* MC_EMEM_ARB_CFG */
			0x8000001e, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0502, /* MC_EMEM_ARB_DA_COVERS */
			0x74230403, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000021, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00b0, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ec, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ec, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00e90049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00a3, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ef, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ef, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ee00ef, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		10720,      /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"03_102000_01_V6.0.4_V1.1", /* DVFS table version */
		102000,     /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000006, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000004, /* EMC_RC */
			0x0000001a, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000003, /* EMC_RAS */
			0x00000001, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000001, /* EMC_RD_RCD */
			0x00000001, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000304, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000000c1, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000018, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000001c, /* EMC_TXSR */
			0x0000001c, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000002, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x0000031c, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1069a298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00014000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00014000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000033, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f2f3, /* EMC_CFG_PIPE */
			0x80000713, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x08000001, /* MC_EMEM_ARB_CFG */
			0x80000026, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000003, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0503, /* MC_EMEM_ARB_DA_COVERS */
			0x73c30504, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000031, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff0075, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff009d, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff009d, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x009b0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ad, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00c6, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00d6, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x0000009f, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x0000009f, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x009f00a0, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		6890,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"03_204000_01_V6.0.4_V1.1", /* DVFS table version */
		204000,     /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000002, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000009, /* EMC_RC */
			0x00000035, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000006, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000005, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000004, /* EMC_EINPUT */
			0x00000006, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000003, /* EMC_QRST */
			0x0000000d, /* EMC_QSAFE */
			0x0000000f, /* EMC_RDV */
			0x00000011, /* EMC_RDV_MASK */
			0x00000607, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000181, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000032, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000038, /* EMC_TXSR */
			0x00000038, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000006, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000638, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1069a298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00014000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00014000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00078000, /* EMC_DLL_XFORM_DQ0 */
			0x00078000, /* EMC_DLL_XFORM_DQ1 */
			0x00078000, /* EMC_DLL_XFORM_DQ2 */
			0x00078000, /* EMC_DLL_XFORM_DQ3 */
			0x00007800, /* EMC_DLL_XFORM_DQ4 */
			0x00007800, /* EMC_DLL_XFORM_DQ5 */
			0x00007800, /* EMC_DLL_XFORM_DQ6 */
			0x00007800, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000066, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000d2b3, /* EMC_CFG_PIPE */
			0x80000d22, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x01000003, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000004, /* MC_EMEM_ARB_TIMING_RC */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06040203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0504, /* MC_EMEM_ARB_DA_COVERS */
			0x73840a05, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000062, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00af, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff004f, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00af, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff004f, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x004e0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080057, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0063, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff0036, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff006b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000050, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000050, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510050, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00c6, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008cd, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		3420,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"03_300000_00_V6.0.4_V1.1", /* DVFS table version */
		300000,     /* SDRAM frequency */
		820,        /* min voltage */
		820,        /* gpu min voltage */
		"pllc_out0", /* clock source id */
		0x20000002, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000000d, /* EMC_RC */
			0x0000004d, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000009, /* EMC_RAS */
			0x00000003, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x00000009, /* EMC_W2P */
			0x00000003, /* EMC_RD_RCD */
			0x00000003, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000002, /* EMC_EINPUT */
			0x00000007, /* EMC_EINPUT_DURATION */
			0x00020000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000001, /* EMC_QRST */
			0x0000000e, /* EMC_QSAFE */
			0x00000010, /* EMC_RDV */
			0x00000012, /* EMC_RDV_MASK */
			0x000008e4, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000239, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000008, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x0000004b, /* EMC_AR2PDEN */
			0x0000000e, /* EMC_RW2PDEN */
			0x00000052, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000008, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000924, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1049b098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00070000, /* EMC_DLL_XFORM_DQS0 */
			0x00070000, /* EMC_DLL_XFORM_DQS1 */
			0x00070000, /* EMC_DLL_XFORM_DQS2 */
			0x00070000, /* EMC_DLL_XFORM_DQS3 */
			0x00070000, /* EMC_DLL_XFORM_DQS4 */
			0x00070000, /* EMC_DLL_XFORM_DQS5 */
			0x00070000, /* EMC_DLL_XFORM_DQS6 */
			0x00070000, /* EMC_DLL_XFORM_DQS7 */
			0x00070000, /* EMC_DLL_XFORM_DQS8 */
			0x00070000, /* EMC_DLL_XFORM_DQS9 */
			0x00070000, /* EMC_DLL_XFORM_DQS10 */
			0x00070000, /* EMC_DLL_XFORM_DQS11 */
			0x00070000, /* EMC_DLL_XFORM_DQS12 */
			0x00070000, /* EMC_DLL_XFORM_DQS13 */
			0x00070000, /* EMC_DLL_XFORM_DQS14 */
			0x00070000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0008c000, /* EMC_DLL_XFORM_ADDR0 */
			0x0008c000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0008c000, /* EMC_DLL_XFORM_ADDR3 */
			0x0008c000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00050000, /* EMC_DLL_XFORM_DQ0 */
			0x00050000, /* EMC_DLL_XFORM_DQ1 */
			0x00050000, /* EMC_DLL_XFORM_DQ2 */
			0x00050000, /* EMC_DLL_XFORM_DQ3 */
			0x00005000, /* EMC_DLL_XFORM_DQ4 */
			0x00005000, /* EMC_DLL_XFORM_DQ5 */
			0x00005000, /* EMC_DLL_XFORM_DQ6 */
			0x00005000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x01231339, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000303, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000096, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x0173000e, /* EMC_MRS_WAIT_CNT */
			0x0173000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x000052a3, /* EMC_CFG_PIPE */
			0x800012d7, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x08000004, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RP */
			0x00000007, /* MC_EMEM_ARB_TIMING_RC */
			0x00000004, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000004, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06040202, /* MC_EMEM_ARB_DA_TURNS */
			0x000b0607, /* MC_EMEM_ARB_DA_COVERS */
			0x77450e08, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000004, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000090, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00350049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008003b, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0043, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff002d, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510036, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff0087, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73340000, /* EMC_CFG */
		0x000008d5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000321, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200000, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		2680,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"03_396000_01_V6.0.4_V1.1", /* DVFS table version */
		396000,     /* SDRAM frequency */
		850,        /* min voltage */
		850,        /* gpu min voltage */
		"pllm_out0", /* clock source id */
		0x00000002, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000011, /* EMC_RC */
			0x00000066, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x0000000c, /* EMC_RAS */
			0x00000004, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000004, /* EMC_RD_RCD */
			0x00000004, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000001, /* EMC_EINPUT */
			0x00000008, /* EMC_EINPUT_DURATION */
			0x00020000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000000, /* EMC_QRST */
			0x0000000f, /* EMC_QSAFE */
			0x00000010, /* EMC_RDV */
			0x00000012, /* EMC_RDV_MASK */
			0x00000bd1, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000002f4, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000008, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000063, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000006c, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x0000000b, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000c11, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1049b098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00070000, /* EMC_DLL_XFORM_DQS0 */
			0x00070000, /* EMC_DLL_XFORM_DQS1 */
			0x00070000, /* EMC_DLL_XFORM_DQS2 */
			0x00070000, /* EMC_DLL_XFORM_DQS3 */
			0x00070000, /* EMC_DLL_XFORM_DQS4 */
			0x00070000, /* EMC_DLL_XFORM_DQS5 */
			0x00070000, /* EMC_DLL_XFORM_DQS6 */
			0x00070000, /* EMC_DLL_XFORM_DQS7 */
			0x00070000, /* EMC_DLL_XFORM_DQS8 */
			0x00070000, /* EMC_DLL_XFORM_DQS9 */
			0x00070000, /* EMC_DLL_XFORM_DQS10 */
			0x00070000, /* EMC_DLL_XFORM_DQS11 */
			0x00070000, /* EMC_DLL_XFORM_DQS12 */
			0x00070000, /* EMC_DLL_XFORM_DQS13 */
			0x00070000, /* EMC_DLL_XFORM_DQS14 */
			0x00070000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00064000, /* EMC_DLL_XFORM_ADDR0 */
			0x00064000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00064000, /* EMC_DLL_XFORM_ADDR3 */
			0x00064000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00038000, /* EMC_DLL_XFORM_DQ0 */
			0x00038000, /* EMC_DLL_XFORM_DQ1 */
			0x00038000, /* EMC_DLL_XFORM_DQ2 */
			0x00038000, /* EMC_DLL_XFORM_DQ3 */
			0x00003800, /* EMC_DLL_XFORM_DQ4 */
			0x00003800, /* EMC_DLL_XFORM_DQ5 */
			0x00003800, /* EMC_DLL_XFORM_DQ6 */
			0x00003800, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x01231339, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000303, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x000000c6, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x015b000e, /* EMC_MRS_WAIT_CNT */
			0x015b000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x000052a3, /* EMC_CFG_PIPE */
			0x8000188b, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x0f000005, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RP */
			0x00000009, /* MC_EMEM_ARB_TIMING_RC */
			0x00000005, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000006, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06040202, /* MC_EMEM_ARB_DA_TURNS */
			0x000d0709, /* MC_EMEM_ARB_DA_COVERS */
			0x7586120a, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000a, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000000be, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00280049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008002d, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0033, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff0022, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff0037, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff0066, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73340000, /* EMC_CFG */
		0x00000895, /* EMC_CFG_2 */
		0x00040008, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000521, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200000, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		2180,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"03_528000_01_V6.0.4_V1.1", /* DVFS table version */
		528000,     /* SDRAM frequency */
		880,        /* min voltage */
		870,        /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000018, /* EMC_RC */
			0x00000088, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000010, /* EMC_RAS */
			0x00000006, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000009, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x0000000d, /* EMC_W2P */
			0x00000006, /* EMC_RD_RCD */
			0x00000006, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000001, /* EMC_EINPUT */
			0x00000009, /* EMC_EINPUT_DURATION */
			0x00030000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000000, /* EMC_QRST */
			0x00000010, /* EMC_QSAFE */
			0x00000012, /* EMC_RDV */
			0x00000014, /* EMC_RDV_MASK */
			0x00000fd6, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000003f5, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x0000000b, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000085, /* EMC_AR2PDEN */
			0x00000012, /* EMC_RW2PDEN */
			0x00000090, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000010, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000006, /* EMC_TCLKSTABLE */
			0x00000006, /* EMC_TCLKSTOP */
			0x00001017, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1049b098, /* EMC_FBIO_CFG5 */
			0xe01200b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000000e, /* EMC_DLL_XFORM_DQS0 */
			0x0000000e, /* EMC_DLL_XFORM_DQS1 */
			0x0000000e, /* EMC_DLL_XFORM_DQS2 */
			0x0000000e, /* EMC_DLL_XFORM_DQS3 */
			0x0000000e, /* EMC_DLL_XFORM_DQS4 */
			0x0000000e, /* EMC_DLL_XFORM_DQS5 */
			0x0000000e, /* EMC_DLL_XFORM_DQS6 */
			0x0000000e, /* EMC_DLL_XFORM_DQS7 */
			0x0000000e, /* EMC_DLL_XFORM_DQS8 */
			0x0000000e, /* EMC_DLL_XFORM_DQS9 */
			0x0000000e, /* EMC_DLL_XFORM_DQS10 */
			0x0000000e, /* EMC_DLL_XFORM_DQS11 */
			0x0000000e, /* EMC_DLL_XFORM_DQS12 */
			0x0000000e, /* EMC_DLL_XFORM_DQS13 */
			0x0000000e, /* EMC_DLL_XFORM_DQS14 */
			0x0000000e, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00044000, /* EMC_DLL_XFORM_ADDR0 */
			0x00044000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00044000, /* EMC_DLL_XFORM_ADDR3 */
			0x00044000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000002, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000002, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000002, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000002, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000004, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000004, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000004, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000004, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000002, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000002, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000002, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000002, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000004, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000004, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000004, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000004, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000c, /* EMC_DLL_XFORM_DQ0 */
			0x0000000c, /* EMC_DLL_XFORM_DQ1 */
			0x0000000c, /* EMC_DLL_XFORM_DQ2 */
			0x0000000c, /* EMC_DLL_XFORM_DQ3 */
			0x0000000c, /* EMC_DLL_XFORM_DQ4 */
			0x0000000c, /* EMC_DLL_XFORM_DQ5 */
			0x0000000c, /* EMC_DLL_XFORM_DQ6 */
			0x0000000c, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0123133d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000303, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x0139000e, /* EMC_MRS_WAIT_CNT */
			0x0139000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x000042a0, /* EMC_CFG_PIPE */
			0x80002062, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x0f000007, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000002, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RP */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RC */
			0x00000007, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000008, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000009, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06050202, /* MC_EMEM_ARB_DA_TURNS */
			0x0010090c, /* MC_EMEM_ARB_DA_COVERS */
			0x7428180d, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000d, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000000fd, /* MC_PTSA_GRANT_DECREMENT */
			0x00c10038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00c10038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00c1003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00c10090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00c10041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00c10090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00c10041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00c10080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080021, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000c1, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00c10026, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00c1001a, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00c10024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00c10029, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000c1, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00c10065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00c1002a, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x0000089d, /* EMC_CFG_2 */
		0x00040008, /* EMC_SEL_DPD_CTRL */
		0xe0120069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000941, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		1440,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"03_600000_00_V6.0.4_V1.1", /* DVFS table version */
		600000,     /* SDRAM frequency */
		910,        /* min voltage */
		910,        /* gpu min voltage */
		"pllc_ud",  /* clock source id */
		0xe0000000, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000001b, /* EMC_RC */
			0x0000009b, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000013, /* EMC_RAS */
			0x00000007, /* EMC_RP */
			0x00000007, /* EMC_R2W */
			0x0000000b, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x00000010, /* EMC_W2P */
			0x00000007, /* EMC_RD_RCD */
			0x00000007, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x0000000a, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x0000000b, /* EMC_EINPUT_DURATION */
			0x00070000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x00000012, /* EMC_QSAFE */
			0x00000016, /* EMC_RDV */
			0x00000018, /* EMC_RDV_MASK */
			0x00001208, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000482, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x0000000d, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000097, /* EMC_AR2PDEN */
			0x00000015, /* EMC_RW2PDEN */
			0x000000a3, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000013, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000006, /* EMC_TCLKSTABLE */
			0x00000006, /* EMC_TCLKSTOP */
			0x00001248, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1049b098, /* EMC_FBIO_CFG5 */
			0xe00e00b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000000a, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_DLL_XFORM_DQS1 */
			0x0000000a, /* EMC_DLL_XFORM_DQS2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS3 */
			0x0000000a, /* EMC_DLL_XFORM_DQS4 */
			0x0000000a, /* EMC_DLL_XFORM_DQS5 */
			0x0000000a, /* EMC_DLL_XFORM_DQS6 */
			0x0000000a, /* EMC_DLL_XFORM_DQS7 */
			0x0000000a, /* EMC_DLL_XFORM_DQS8 */
			0x0000000a, /* EMC_DLL_XFORM_DQS9 */
			0x0000000a, /* EMC_DLL_XFORM_DQS10 */
			0x0000000a, /* EMC_DLL_XFORM_DQS11 */
			0x0000000a, /* EMC_DLL_XFORM_DQS12 */
			0x0000000a, /* EMC_DLL_XFORM_DQS13 */
			0x0000000a, /* EMC_DLL_XFORM_DQS14 */
			0x0000000a, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0003c000, /* EMC_DLL_XFORM_ADDR0 */
			0x0003c000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0003c000, /* EMC_DLL_XFORM_ADDR3 */
			0x0003c000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000004, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000004, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000004, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000004, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000004, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000004, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000004, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000004, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000c, /* EMC_DLL_XFORM_DQ0 */
			0x0000000c, /* EMC_DLL_XFORM_DQ1 */
			0x0000000c, /* EMC_DLL_XFORM_DQ2 */
			0x0000000c, /* EMC_DLL_XFORM_DQ3 */
			0x0000000c, /* EMC_DLL_XFORM_DQ4 */
			0x0000000c, /* EMC_DLL_XFORM_DQ5 */
			0x0000000c, /* EMC_DLL_XFORM_DQ6 */
			0x0000000c, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0121113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000303, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x0127000e, /* EMC_MRS_WAIT_CNT */
			0x0127000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x000040a0, /* EMC_CFG_PIPE */
			0x800024a9, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000e, /* EMC_QPOP */
			0x00000009, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000003, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RP */
			0x0000000e, /* MC_EMEM_ARB_TIMING_RC */
			0x00000009, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000a, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000b, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_W2R */
			0x07050202, /* MC_EMEM_ARB_DA_TURNS */
			0x00130b0e, /* MC_EMEM_ARB_DA_COVERS */
			0x73a91b0f, /* MC_EMEM_ARB_MISC0 */
			0x70000f03, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000f, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000120, /* MC_PTSA_GRANT_DECREMENT */
			0x00aa0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00aa0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00aa003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00aa0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00aa0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00aa0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00aa0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00aa0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008001d, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000aa, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00aa0022, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00aa0018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00aa0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00aa0024, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000aa, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00aa0065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00aa0025, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x0000089d, /* EMC_CFG_2 */
		0x00040008, /* EMC_SEL_DPD_CTRL */
		0xe00e0069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000b61, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200010, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		1440,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"03_792000_01_V6.0.4_V1.1", /* DVFS table version */
		792000,     /* SDRAM frequency */
		980,        /* min voltage */
		980,        /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000024, /* EMC_RC */
			0x000000cd, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000019, /* EMC_RAS */
			0x0000000a, /* EMC_RP */
			0x00000008, /* EMC_R2W */
			0x0000000d, /* EMC_W2R */
			0x00000004, /* EMC_R2P */
			0x00000013, /* EMC_W2P */
			0x0000000a, /* EMC_RD_RCD */
			0x0000000a, /* EMC_WR_RCD */
			0x00000004, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x0000000b, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000002, /* EMC_EINPUT */
			0x0000000d, /* EMC_EINPUT_DURATION */
			0x00080000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000001, /* EMC_QRST */
			0x00000014, /* EMC_QSAFE */
			0x00000018, /* EMC_RDV */
			0x0000001a, /* EMC_RDV_MASK */
			0x000017e2, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000005f8, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000003, /* EMC_PDEX2WR */
			0x00000011, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x000000c7, /* EMC_AR2PDEN */
			0x00000018, /* EMC_RW2PDEN */
			0x000000d7, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000005, /* EMC_TCKE */
			0x00000006, /* EMC_TCKESR */
			0x00000005, /* EMC_TPD */
			0x00000019, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000008, /* EMC_TCLKSTABLE */
			0x00000008, /* EMC_TCLKSTOP */
			0x00001822, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1049b098, /* EMC_FBIO_CFG5 */
			0xe00700b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x007fc007, /* EMC_DLL_XFORM_DQS0 */
			0x007fc007, /* EMC_DLL_XFORM_DQS1 */
			0x007fc007, /* EMC_DLL_XFORM_DQS2 */
			0x007fc007, /* EMC_DLL_XFORM_DQS3 */
			0x007fc007, /* EMC_DLL_XFORM_DQS4 */
			0x007fc007, /* EMC_DLL_XFORM_DQS5 */
			0x007fc007, /* EMC_DLL_XFORM_DQS6 */
			0x007fc007, /* EMC_DLL_XFORM_DQS7 */
			0x007fc007, /* EMC_DLL_XFORM_DQS8 */
			0x007fc007, /* EMC_DLL_XFORM_DQS9 */
			0x007fc007, /* EMC_DLL_XFORM_DQS10 */
			0x007fc007, /* EMC_DLL_XFORM_DQS11 */
			0x007fc007, /* EMC_DLL_XFORM_DQS12 */
			0x007fc007, /* EMC_DLL_XFORM_DQS13 */
			0x007fc007, /* EMC_DLL_XFORM_DQS14 */
			0x007fc007, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00028000, /* EMC_DLL_XFORM_ADDR0 */
			0x00028000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00028000, /* EMC_DLL_XFORM_ADDR3 */
			0x00028000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000007, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000007, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000007, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000007, /* EMC_DLI_TRIM_TXDQS3 */
			0x0000000a, /* EMC_DLI_TRIM_TXDQS4 */
			0x0000000a, /* EMC_DLI_TRIM_TXDQS5 */
			0x0000000a, /* EMC_DLI_TRIM_TXDQS6 */
			0x0000000a, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000007, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000007, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000007, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000007, /* EMC_DLI_TRIM_TXDQS11 */
			0x0000000a, /* EMC_DLI_TRIM_TXDQS12 */
			0x0000000a, /* EMC_DLI_TRIM_TXDQS13 */
			0x0000000a, /* EMC_DLI_TRIM_TXDQS14 */
			0x0000000a, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000a, /* EMC_DLL_XFORM_DQ0 */
			0x0000000a, /* EMC_DLL_XFORM_DQ1 */
			0x0000000a, /* EMC_DLL_XFORM_DQ2 */
			0x0000000a, /* EMC_DLL_XFORM_DQ3 */
			0x0000000a, /* EMC_DLL_XFORM_DQ4 */
			0x0000000a, /* EMC_DLL_XFORM_DQ5 */
			0x0000000a, /* EMC_DLL_XFORM_DQ6 */
			0x0000000a, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0120113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x61861820, /* EMC_XM2DQSPADCTRL3 */
			0x00555555, /* EMC_XM2DQSPADCTRL4 */
			0x00555555, /* EMC_XM2DQSPADCTRL5 */
			0x61861800, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x00f7000e, /* EMC_MRS_WAIT_CNT */
			0x00f7000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x00004080, /* EMC_CFG_PIPE */
			0x80003012, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000f, /* EMC_QPOP */
			0x0e00000b, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000004, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000005, /* MC_EMEM_ARB_TIMING_RP */
			0x00000013, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000d, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000c, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_W2R */
			0x08060202, /* MC_EMEM_ARB_DA_TURNS */
			0x00170e13, /* MC_EMEM_ARB_DA_COVERS */
			0x736c2414, /* MC_EMEM_ARB_MISC0 */
			0x70000f02, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000013, /* MC_MLL_MPCORER_PTSA_RATE */
			0x0000017c, /* MC_PTSA_GRANT_DECREMENT */
			0x00810038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00810038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x0081003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00810090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00810041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00810090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00810041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00810080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080016, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x00000081, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00810019, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00810018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00810024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x0081001c, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x00000081, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00810065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x0081001c, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x0000089d, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0xe0070069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000d71, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200018, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		1200,       /* expected dvfs latency (ns) */
	},
	{
		0x19,       /* V6.0.4 */
		"03_924000_01_V6.0.4_V1.1", /* DVFS table version */
		924000,     /* SDRAM frequency */
		1010,       /* min voltage */
		1010,       /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		165,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000002b, /* EMC_RC */
			0x000000f0, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x0000001e, /* EMC_RAS */
			0x0000000b, /* EMC_RP */
			0x00000009, /* EMC_R2W */
			0x0000000f, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x00000016, /* EMC_W2P */
			0x0000000b, /* EMC_RD_RCD */
			0x0000000b, /* EMC_WR_RCD */
			0x00000004, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000007, /* EMC_WDV */
			0x00000007, /* EMC_WDV_MASK */
			0x0000000d, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000002, /* EMC_EINPUT */
			0x0000000f, /* EMC_EINPUT_DURATION */
			0x000a0000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000001, /* EMC_QRST */
			0x00000016, /* EMC_QSAFE */
			0x0000001a, /* EMC_RDV */
			0x0000001c, /* EMC_RDV_MASK */
			0x00001be7, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000006f9, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000004, /* EMC_PDEX2WR */
			0x00000015, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x000000e7, /* EMC_AR2PDEN */
			0x0000001b, /* EMC_RW2PDEN */
			0x000000fb, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000006, /* EMC_TCKE */
			0x00000007, /* EMC_TCKESR */
			0x00000006, /* EMC_TPD */
			0x0000001e, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x0000000a, /* EMC_TCLKSTABLE */
			0x0000000a, /* EMC_TCLKSTOP */
			0x00001c28, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1049b898, /* EMC_FBIO_CFG5 */
			0xe00400b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x007f8008, /* EMC_DLL_XFORM_DQS0 */
			0x007f8008, /* EMC_DLL_XFORM_DQS1 */
			0x007f8008, /* EMC_DLL_XFORM_DQS2 */
			0x007f8008, /* EMC_DLL_XFORM_DQS3 */
			0x007f8008, /* EMC_DLL_XFORM_DQS4 */
			0x007f8008, /* EMC_DLL_XFORM_DQS5 */
			0x007f8008, /* EMC_DLL_XFORM_DQS6 */
			0x007f8008, /* EMC_DLL_XFORM_DQS7 */
			0x007f8008, /* EMC_DLL_XFORM_DQS8 */
			0x007f8008, /* EMC_DLL_XFORM_DQS9 */
			0x007f8008, /* EMC_DLL_XFORM_DQS10 */
			0x007f8008, /* EMC_DLL_XFORM_DQS11 */
			0x007f8008, /* EMC_DLL_XFORM_DQS12 */
			0x007f8008, /* EMC_DLL_XFORM_DQS13 */
			0x007f8008, /* EMC_DLL_XFORM_DQS14 */
			0x007f8008, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0001c000, /* EMC_DLL_XFORM_ADDR0 */
			0x0001c000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0001c000, /* EMC_DLL_XFORM_ADDR3 */
			0x0001c000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000006, /* EMC_DLI_TRIM_TXDQS15 */
			0x00004008, /* EMC_DLL_XFORM_DQ0 */
			0x00004008, /* EMC_DLL_XFORM_DQ1 */
			0x00004008, /* EMC_DLL_XFORM_DQ2 */
			0x00004008, /* EMC_DLL_XFORM_DQ3 */
			0x00000408, /* EMC_DLL_XFORM_DQ4 */
			0x00000408, /* EMC_DLL_XFORM_DQ5 */
			0x00000408, /* EMC_DLL_XFORM_DQ6 */
			0x00000408, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0120113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000202, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x5d75d720, /* EMC_XM2DQSPADCTRL3 */
			0x00555555, /* EMC_XM2DQSPADCTRL4 */
			0x00555555, /* EMC_XM2DQSPADCTRL5 */
			0x5d75d700, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000128, /* EMC_ZCAL_WAIT_CNT */
			0x00cd000e, /* EMC_MRS_WAIT_CNT */
			0x00cd000e, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x00004080, /* EMC_CFG_PIPE */
			0x800037ea, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000011, /* EMC_QPOP */
			0x0e00000d, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000005, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000006, /* MC_EMEM_ARB_TIMING_RP */
			0x00000016, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000e, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000f, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000e, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000009, /* MC_EMEM_ARB_TIMING_W2R */
			0x09060202, /* MC_EMEM_ARB_DA_TURNS */
			0x001a1016, /* MC_EMEM_ARB_DA_COVERS */
			0x734e2a17, /* MC_EMEM_ARB_MISC0 */
			0x70000f02, /* MC_EMEM_ARB_MISC1 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000017, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000001bb, /* MC_PTSA_GRANT_DECREMENT */
			0x006e0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x006e0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x006e003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x006e0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x006e0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x006e0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x006e0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x006e0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080016, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x0000006e, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x006e0019, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x006e0018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x006e0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x006e001b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x0000006e, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x006e0065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x006e001c, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x0000004c, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x0000089d, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0xe0040069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000f15, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200020, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
		1180,       /* expected dvfs latency (ns) */
	},
};

static struct tegra12_emc_pdata norrin_emc_pdata = {
	.description = "norrin_emc_tables",
	.tables = norrin_emc_table,
	.num_tables = ARRAY_SIZE(norrin_emc_table),
};

/*
static struct tegra12_emc_pdata norrin_4GB_emc_pdata = {
	.description = "norrin_emc_tables",
	.tables = norrin_emc_table,
	.num_tables = ARRAY_SIZE(norrin_emc_table),
};
*/

static struct tegra12_emc_pdata bowmore_4GB_emc_pdata = {
	.description = "bowmore_emc_tables",
	.tables = bowmore_emc_table,
	.tables_derated = bowmore_emc_table_der,
	.num_tables = ARRAY_SIZE(bowmore_emc_table),
};

static struct tegra12_emc_pdata bowmore_2GB_emc_pdata = {
	.description = "bowmore_emc_tables_2GB",
	.tables = bowmore_emc_table_2GB,
	.num_tables = ARRAY_SIZE(bowmore_emc_table_2GB),
};

static struct tegra12_emc_pdata e1991_emc_pdata = {
	.description = "e1991_emc_tables",
	.tables = e1991_emc_table,
	.num_tables = ARRAY_SIZE(e1991_emc_table),
};

int __init norrin_emc_init(void)
{
	struct board_info bi;

	/* If Device Tree Partition contains emc-tables, load them */
	if (of_find_compatible_node(NULL, NULL, "nvidia,tegra12-emc")) {
		pr_info("Loading EMC tables from DeviceTree.\n");
	} else {
		tegra_get_board_info(&bi);

		switch (bi.board_id) {
		case BOARD_PM374:
			/* Norrin only has 2G board */
			pr_info("Loading Norrin EMC tables.\n");
			tegra_emc_device.dev.platform_data =
				&norrin_emc_pdata;
			break;
		case BOARD_E1971:
		case BOARD_E1973:
			if (tegra_get_memory_type()) {
				pr_info("Loading Bowmore 4GB EMC tables.\n");
				tegra_emc_device.dev.platform_data =
					&bowmore_4GB_emc_pdata;
			} else {
				pr_info("Loading Bowmore 2GB EMC tables.\n");
				tegra_emc_device.dev.platform_data =
					&bowmore_2GB_emc_pdata;
			}
			break;
		case BOARD_E1991:
			pr_info("Loading E1991 EMC tables.\n");
			tegra_emc_device.dev.platform_data =
					&e1991_emc_pdata;
			break;
		default:
			WARN(1, "Invalid board ID: %u\n", bi.board_id);
			return -EINVAL;
		}

		platform_device_register(&tegra_emc_device);
	}

	tegra12_emc_init();
	return 0;
}
