/*
 * Copyright (c) 2013-2014, NVIDIA CORPORATION.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/platform_data/tegra_emc_pdata.h>

#include "board.h"
#include "board-loki.h"
#include "tegra-board-id.h"
#include "tegra12_emc.h"
#include "devices.h"

static struct tegra12_emc_table loki_b00_sku0_emc_table[] = {
	{
		0x18,       /* V5.0.6 */
		"06_12750_01_V5.0.6_V0.8", /* DVFS table version */
		12750,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x4000003e, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000000, /* EMC_RC */
			0x00000003, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000000, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000003, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000000, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000004, /* EMC_EINPUT */
			0x00000004, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000001, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000003, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000c, /* EMC_RDV */
			0x0000000e, /* EMC_RDV_MASK */
			0x00000060, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000018, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000005, /* EMC_TXSR */
			0x00000005, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000064, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x10604098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0030a118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000007, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000001, /* EMC_CTT_DURATION */
			0x0000f3f3, /* EMC_CFG_PIPE */
			0x800001c5, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x40040001, /* MC_EMEM_ARB_CFG */
			0x8000000a, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x77e30303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000007, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"06_20400_01_V5.0.6_V0.8", /* DVFS table version */
		20400,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000026, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000000, /* EMC_RC */
			0x00000005, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000000, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000003, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000000, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000004, /* EMC_EINPUT */
			0x00000004, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000001, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000003, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000c, /* EMC_RDV */
			0x0000000e, /* EMC_RDV_MASK */
			0x0000009a, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000026, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000006, /* EMC_TXSR */
			0x00000006, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x000000a0, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x10604098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0030a118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x0000000b, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000001, /* EMC_CTT_DURATION */
			0x0000f3f3, /* EMC_CFG_PIPE */
			0x8000023a, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x40020001, /* MC_EMEM_ARB_CFG */
			0x80000012, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x76230303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x0000000a, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"06_40800_01_V5.0.6_V0.8", /* DVFS table version */
		40800,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000012, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000001, /* EMC_RC */
			0x0000000a, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000001, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000003, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000000, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000004, /* EMC_EINPUT */
			0x00000004, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000001, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000003, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000c, /* EMC_RDV */
			0x0000000e, /* EMC_RDV_MASK */
			0x00000134, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x0000004d, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000008, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000000c, /* EMC_TXSR */
			0x0000000c, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x0000013f, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x10604098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0030a118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000015, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000001, /* EMC_CTT_DURATION */
			0x0000f3f3, /* EMC_CFG_PIPE */
			0x80000370, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0xa0000001, /* MC_EMEM_ARB_CFG */
			0x80000017, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x74a30303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000014, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"06_68000_01_V5.0.6_V0.8", /* DVFS table version */
		68000,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x4000000a, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000003, /* EMC_RC */
			0x00000011, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000003, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000000, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000004, /* EMC_EINPUT */
			0x00000004, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000001, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000003, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000c, /* EMC_RDV */
			0x0000000e, /* EMC_RDV_MASK */
			0x00000202, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000080, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x0000000f, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000013, /* EMC_TXSR */
			0x00000013, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000213, /* EMC_TREFBW */
			0x00000002, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x10604098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0030a118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000022, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000001, /* EMC_CTT_DURATION */
			0x0000f3f3, /* EMC_CFG_PIPE */
			0x8000050e, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x00000001, /* MC_EMEM_ARB_CFG */
			0x8000001e, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x74230403, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000021, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00b0, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ec, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ec, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00e90049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00a3, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ef, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ef, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ee00ef, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"06_102000_01_V5.0.6_V0.8", /* DVFS table version */
		102000,     /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000006, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000004, /* EMC_RC */
			0x0000001a, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000003, /* EMC_RAS */
			0x00000001, /* EMC_RP */
			0x00000003, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000001, /* EMC_RD_RCD */
			0x00000001, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000000, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000004, /* EMC_EINPUT */
			0x00000004, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000001, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000003, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000c, /* EMC_RDV */
			0x0000000e, /* EMC_RDV_MASK */
			0x00000304, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000000c1, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000018, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000001c, /* EMC_TXSR */
			0x0000001c, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000001, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x0000031c, /* EMC_TREFBW */
			0x00000002, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x10604098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0030a118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000033, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000001, /* EMC_CTT_DURATION */
			0x0000f3f3, /* EMC_CFG_PIPE */
			0x80000713, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x08000001, /* MC_EMEM_ARB_CFG */
			0x80000026, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000003, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0403, /* MC_EMEM_ARB_DA_COVERS */
			0x73c30504, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000031, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff0075, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff009d, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff009d, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x009b0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ad, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00c6, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00d6, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x0000009f, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x0000009f, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x009f00a0, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"06_204000_01_V5.0.6_V0.8", /* DVFS table version */
		204000,     /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000002, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000009, /* EMC_RC */
			0x00000035, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000006, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000004, /* EMC_WDV */
			0x00000004, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000000, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000001, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x0000000d, /* EMC_QSAFE */
			0x0000000e, /* EMC_RDV */
			0x00000010, /* EMC_RDV_MASK */
			0x00000607, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000181, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000032, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000038, /* EMC_TXSR */
			0x00000038, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000004, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000638, /* EMC_TREFBW */
			0x00000002, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x10604098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00090000, /* EMC_DLL_XFORM_DQ0 */
			0x00090000, /* EMC_DLL_XFORM_DQ1 */
			0x00090000, /* EMC_DLL_XFORM_DQ2 */
			0x00090000, /* EMC_DLL_XFORM_DQ3 */
			0x00009000, /* EMC_DLL_XFORM_DQ4 */
			0x00009000, /* EMC_DLL_XFORM_DQ5 */
			0x00009000, /* EMC_DLL_XFORM_DQ6 */
			0x00009000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0030a118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000066, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000001, /* EMC_CTT_DURATION */
			0x0000d3b3, /* EMC_CFG_PIPE */
			0x80000d22, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x01000003, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000004, /* MC_EMEM_ARB_TIMING_RC */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0404, /* MC_EMEM_ARB_DA_COVERS */
			0x73840a05, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000062, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00af, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff004f, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00af, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff004f, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x004e0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080057, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0063, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff0036, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff006b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000050, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000050, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510050, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00c6, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008cd, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"06_300000_01_V5.0.6_V0.8", /* DVFS table version */
		300000,     /* SDRAM frequency */
		810,        /* min voltage */
		800,        /* gpu min voltage */
		"pllc_out0", /* clock source id */
		0x20000002, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000000c, /* EMC_RC */
			0x0000004c, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000008, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x00000009, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x00000006, /* EMC_EINPUT_DURATION */
			0x00030000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x0000000d, /* EMC_QSAFE */
			0x0000000e, /* EMC_RDV */
			0x00000010, /* EMC_RDV_MASK */
			0x000008e4, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000239, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000008, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x0000004a, /* EMC_AR2PDEN */
			0x0000000e, /* EMC_RW2PDEN */
			0x00000051, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000005, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000924, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00030000, /* EMC_DLL_XFORM_DQS0 */
			0x00030000, /* EMC_DLL_XFORM_DQS1 */
			0x00030000, /* EMC_DLL_XFORM_DQS2 */
			0x00030000, /* EMC_DLL_XFORM_DQS3 */
			0x00030000, /* EMC_DLL_XFORM_DQS4 */
			0x00030000, /* EMC_DLL_XFORM_DQS5 */
			0x00030000, /* EMC_DLL_XFORM_DQS6 */
			0x00030000, /* EMC_DLL_XFORM_DQS7 */
			0x00030000, /* EMC_DLL_XFORM_DQS8 */
			0x00030000, /* EMC_DLL_XFORM_DQS9 */
			0x00030000, /* EMC_DLL_XFORM_DQS10 */
			0x00030000, /* EMC_DLL_XFORM_DQS11 */
			0x00030000, /* EMC_DLL_XFORM_DQS12 */
			0x00030000, /* EMC_DLL_XFORM_DQS13 */
			0x00030000, /* EMC_DLL_XFORM_DQS14 */
			0x00030000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0009c000, /* EMC_DLL_XFORM_ADDR0 */
			0x0009c000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0009c000, /* EMC_DLL_XFORM_ADDR3 */
			0x0009c000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00060000, /* EMC_DLL_XFORM_DQ0 */
			0x00060000, /* EMC_DLL_XFORM_DQ1 */
			0x00060000, /* EMC_DLL_XFORM_DQ2 */
			0x00060000, /* EMC_DLL_XFORM_DQ3 */
			0x00006000, /* EMC_DLL_XFORM_DQ4 */
			0x00006000, /* EMC_DLL_XFORM_DQ5 */
			0x00006000, /* EMC_DLL_XFORM_DQ6 */
			0x00006000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x01231339, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000096, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x01740010, /* EMC_MRS_WAIT_CNT */
			0x01740010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000d3b3, /* EMC_CFG_PIPE */
			0x800012d7, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x08000004, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000006, /* MC_EMEM_ARB_TIMING_RC */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06040202, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0506, /* MC_EMEM_ARB_DA_COVERS */
			0x77450e07, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000004, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000090, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00350049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008003b, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0043, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff002d, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510036, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff0087, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73340000, /* EMC_CFG */
		0x000008cd, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000321, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200000, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"06_396000_01_V5.0.6_V0.8", /* DVFS table version */
		396000,     /* SDRAM frequency */
		860,        /* min voltage */
		900,        /* gpu min voltage */
		"pllm_out0", /* clock source id */
		0x00000002, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000011, /* EMC_RC */
			0x00000065, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x0000000c, /* EMC_RAS */
			0x00000004, /* EMC_RP */
			0x00000005, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000004, /* EMC_RD_RCD */
			0x00000004, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x00000006, /* EMC_EINPUT_DURATION */
			0x00030000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x0000000d, /* EMC_QSAFE */
			0x0000000e, /* EMC_RDV */
			0x00000010, /* EMC_RDV_MASK */
			0x00000bd1, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000002f4, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000008, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000063, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000006b, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000007, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000c11, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00030000, /* EMC_DLL_XFORM_DQS0 */
			0x00030000, /* EMC_DLL_XFORM_DQS1 */
			0x00030000, /* EMC_DLL_XFORM_DQS2 */
			0x00030000, /* EMC_DLL_XFORM_DQS3 */
			0x00030000, /* EMC_DLL_XFORM_DQS4 */
			0x00030000, /* EMC_DLL_XFORM_DQS5 */
			0x00030000, /* EMC_DLL_XFORM_DQS6 */
			0x00030000, /* EMC_DLL_XFORM_DQS7 */
			0x00030000, /* EMC_DLL_XFORM_DQS8 */
			0x00030000, /* EMC_DLL_XFORM_DQS9 */
			0x00030000, /* EMC_DLL_XFORM_DQS10 */
			0x00030000, /* EMC_DLL_XFORM_DQS11 */
			0x00030000, /* EMC_DLL_XFORM_DQS12 */
			0x00030000, /* EMC_DLL_XFORM_DQS13 */
			0x00030000, /* EMC_DLL_XFORM_DQS14 */
			0x00030000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00074000, /* EMC_DLL_XFORM_ADDR0 */
			0x00074000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00074000, /* EMC_DLL_XFORM_ADDR3 */
			0x00074000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00044000, /* EMC_DLL_XFORM_DQ0 */
			0x00044000, /* EMC_DLL_XFORM_DQ1 */
			0x00044000, /* EMC_DLL_XFORM_DQ2 */
			0x00044000, /* EMC_DLL_XFORM_DQ3 */
			0x00004400, /* EMC_DLL_XFORM_DQ4 */
			0x00004400, /* EMC_DLL_XFORM_DQ5 */
			0x00004400, /* EMC_DLL_XFORM_DQ6 */
			0x00004400, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x01231339, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x000000c6, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x015b0010, /* EMC_MRS_WAIT_CNT */
			0x015b0010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000d3b3, /* EMC_CFG_PIPE */
			0x8000188b, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x0f000005, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RP */
			0x00000009, /* MC_EMEM_ARB_TIMING_RC */
			0x00000005, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000004, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06040202, /* MC_EMEM_ARB_DA_TURNS */
			0x000d0709, /* MC_EMEM_ARB_DA_COVERS */
			0x7586120a, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000a, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000000be, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00280049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008002d, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0033, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff0022, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff0037, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff0066, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73340000, /* EMC_CFG */
		0x0000088d, /* EMC_CFG_2 */
		0x00040008, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000521, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200000, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"06_528000_01_V5.0.6_V0.8", /* DVFS table version */
		528000,     /* SDRAM frequency */
		920,        /* min voltage */
		900,        /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000017, /* EMC_RC */
			0x00000088, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000010, /* EMC_RAS */
			0x00000005, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000009, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x0000000d, /* EMC_W2P */
			0x00000005, /* EMC_RD_RCD */
			0x00000005, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000004, /* EMC_WDV */
			0x00000004, /* EMC_WDV_MASK */
			0x00000008, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000007, /* EMC_EINPUT_DURATION */
			0x00060000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000e, /* EMC_QSAFE */
			0x00000013, /* EMC_RDV */
			0x00000015, /* EMC_RDV_MASK */
			0x00000fd6, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000003f5, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x0000000b, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000084, /* EMC_AR2PDEN */
			0x00000012, /* EMC_RW2PDEN */
			0x0000008f, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x0000000b, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000006, /* EMC_TCLKSTABLE */
			0x00000006, /* EMC_TCLKSTOP */
			0x00001017, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b098, /* EMC_FBIO_CFG5 */
			0xe01200b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000000a, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_DLL_XFORM_DQS1 */
			0x0000000a, /* EMC_DLL_XFORM_DQS2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS3 */
			0x0000000a, /* EMC_DLL_XFORM_DQS4 */
			0x0000000a, /* EMC_DLL_XFORM_DQS5 */
			0x0000000a, /* EMC_DLL_XFORM_DQS6 */
			0x0000000a, /* EMC_DLL_XFORM_DQS7 */
			0x0000000a, /* EMC_DLL_XFORM_DQS8 */
			0x0000000a, /* EMC_DLL_XFORM_DQS9 */
			0x0000000a, /* EMC_DLL_XFORM_DQS10 */
			0x0000000a, /* EMC_DLL_XFORM_DQS11 */
			0x0000000a, /* EMC_DLL_XFORM_DQS12 */
			0x0000000a, /* EMC_DLL_XFORM_DQS13 */
			0x0000000a, /* EMC_DLL_XFORM_DQS14 */
			0x0000000a, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00058000, /* EMC_DLL_XFORM_ADDR0 */
			0x00058000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00058000, /* EMC_DLL_XFORM_ADDR3 */
			0x00058000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000e, /* EMC_DLL_XFORM_DQ0 */
			0x0000000e, /* EMC_DLL_XFORM_DQ1 */
			0x0000000e, /* EMC_DLL_XFORM_DQ2 */
			0x0000000e, /* EMC_DLL_XFORM_DQ3 */
			0x0000000e, /* EMC_DLL_XFORM_DQ4 */
			0x0000000e, /* EMC_DLL_XFORM_DQ5 */
			0x0000000e, /* EMC_DLL_XFORM_DQ6 */
			0x0000000e, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0123133d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x013a0010, /* EMC_MRS_WAIT_CNT */
			0x013a0010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x000052a0, /* EMC_CFG_PIPE */
			0x80002062, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000c, /* EMC_QPOP */
			0x0f000007, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000002, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RP */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RC */
			0x00000007, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000006, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000009, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06050202, /* MC_EMEM_ARB_DA_TURNS */
			0x000f080c, /* MC_EMEM_ARB_DA_COVERS */
			0x7428180d, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000d, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000000fd, /* MC_PTSA_GRANT_DECREMENT */
			0x00c10038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00c10038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00c1003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00c10090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00c10041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00c10090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00c10041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00c10080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080021, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000c1, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00c10026, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00c1001a, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00c10024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00c10029, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000c1, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00c10065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00c1002a, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x00000895, /* EMC_CFG_2 */
		0x00040008, /* EMC_SEL_DPD_CTRL */
		0xe0120069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000941, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"06_600000_01_V5.0.6_V0.8", /* DVFS table version */
		600000,     /* SDRAM frequency */
		920,        /* min voltage */
		900,        /* gpu min voltage */
		"pllc_ud",  /* clock source id */
		0xe0000000, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000001a, /* EMC_RC */
			0x0000009a, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000012, /* EMC_RAS */
			0x00000006, /* EMC_RP */
			0x00000007, /* EMC_R2W */
			0x0000000b, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x00000010, /* EMC_W2P */
			0x00000006, /* EMC_RD_RCD */
			0x00000006, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x0000000a, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x0000000b, /* EMC_EINPUT_DURATION */
			0x00070000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x00000012, /* EMC_QSAFE */
			0x00000016, /* EMC_RDV */
			0x00000018, /* EMC_RDV_MASK */
			0x00001208, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000482, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x0000000d, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000096, /* EMC_AR2PDEN */
			0x00000015, /* EMC_RW2PDEN */
			0x000000a2, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x0000000c, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000006, /* EMC_TCLKSTABLE */
			0x00000006, /* EMC_TCLKSTOP */
			0x00001248, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b098, /* EMC_FBIO_CFG5 */
			0xe00e00b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000000a, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_DLL_XFORM_DQS1 */
			0x0000000a, /* EMC_DLL_XFORM_DQS2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS3 */
			0x0000000a, /* EMC_DLL_XFORM_DQS4 */
			0x0000000a, /* EMC_DLL_XFORM_DQS5 */
			0x0000000a, /* EMC_DLL_XFORM_DQS6 */
			0x0000000a, /* EMC_DLL_XFORM_DQS7 */
			0x0000000a, /* EMC_DLL_XFORM_DQS8 */
			0x0000000a, /* EMC_DLL_XFORM_DQS9 */
			0x0000000a, /* EMC_DLL_XFORM_DQS10 */
			0x0000000a, /* EMC_DLL_XFORM_DQS11 */
			0x0000000a, /* EMC_DLL_XFORM_DQS12 */
			0x0000000a, /* EMC_DLL_XFORM_DQS13 */
			0x0000000a, /* EMC_DLL_XFORM_DQS14 */
			0x0000000a, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0004c000, /* EMC_DLL_XFORM_ADDR0 */
			0x0004c000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0004c000, /* EMC_DLL_XFORM_ADDR3 */
			0x0004c000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000d, /* EMC_DLL_XFORM_DQ0 */
			0x0000000d, /* EMC_DLL_XFORM_DQ1 */
			0x0000000d, /* EMC_DLL_XFORM_DQ2 */
			0x0000000d, /* EMC_DLL_XFORM_DQ3 */
			0x0000000d, /* EMC_DLL_XFORM_DQ4 */
			0x0000000d, /* EMC_DLL_XFORM_DQ5 */
			0x0000000d, /* EMC_DLL_XFORM_DQ6 */
			0x0000000d, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0121113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x01280010, /* EMC_MRS_WAIT_CNT */
			0x01280010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x000040a0, /* EMC_CFG_PIPE */
			0x800024aa, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000e, /* EMC_QPOP */
			0x00000009, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000002, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RP */
			0x0000000d, /* MC_EMEM_ARB_TIMING_RC */
			0x00000008, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000006, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000b, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_W2R */
			0x07050202, /* MC_EMEM_ARB_DA_TURNS */
			0x00120a0d, /* MC_EMEM_ARB_DA_COVERS */
			0x73a91b0e, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000f, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000120, /* MC_PTSA_GRANT_DECREMENT */
			0x00aa0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00aa0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00aa003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00aa0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00aa0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00aa0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00aa0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00aa0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008001d, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000aa, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00aa0022, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00aa0018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00aa0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00aa0024, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000aa, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00aa0065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00aa0025, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x0000089d, /* EMC_CFG_2 */
		0x00040008, /* EMC_SEL_DPD_CTRL */
		0xe00e0069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000b61, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200010, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"06_792000_01_V5.0.6_V0.8", /* DVFS table version */
		792000,     /* SDRAM frequency */
		1000,       /* min voltage */
		1100,       /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000023, /* EMC_RC */
			0x000000cc, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000019, /* EMC_RAS */
			0x00000009, /* EMC_RP */
			0x00000008, /* EMC_R2W */
			0x0000000d, /* EMC_W2R */
			0x00000004, /* EMC_R2P */
			0x00000013, /* EMC_W2P */
			0x00000009, /* EMC_RD_RCD */
			0x00000009, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x0000000b, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000002, /* EMC_EINPUT */
			0x0000000d, /* EMC_EINPUT_DURATION */
			0x00080000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000001, /* EMC_QRST */
			0x00000014, /* EMC_QSAFE */
			0x00000017, /* EMC_RDV */
			0x00000019, /* EMC_RDV_MASK */
			0x000017e2, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000005f8, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000003, /* EMC_PDEX2WR */
			0x00000011, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x000000c6, /* EMC_AR2PDEN */
			0x00000018, /* EMC_RW2PDEN */
			0x000000d6, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000005, /* EMC_TCKE */
			0x00000006, /* EMC_TCKESR */
			0x00000005, /* EMC_TPD */
			0x00000011, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000008, /* EMC_TCLKSTABLE */
			0x00000008, /* EMC_TCLKSTOP */
			0x00001822, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b098, /* EMC_FBIO_CFG5 */
			0xe00700b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000008, /* EMC_DLL_XFORM_DQS0 */
			0x00000008, /* EMC_DLL_XFORM_DQS1 */
			0x00000008, /* EMC_DLL_XFORM_DQS2 */
			0x00000008, /* EMC_DLL_XFORM_DQS3 */
			0x00000008, /* EMC_DLL_XFORM_DQS4 */
			0x00000008, /* EMC_DLL_XFORM_DQS5 */
			0x00000008, /* EMC_DLL_XFORM_DQS6 */
			0x00000008, /* EMC_DLL_XFORM_DQS7 */
			0x00000008, /* EMC_DLL_XFORM_DQS8 */
			0x00000008, /* EMC_DLL_XFORM_DQS9 */
			0x00000008, /* EMC_DLL_XFORM_DQS10 */
			0x00000008, /* EMC_DLL_XFORM_DQS11 */
			0x00000008, /* EMC_DLL_XFORM_DQS12 */
			0x00000008, /* EMC_DLL_XFORM_DQS13 */
			0x00000008, /* EMC_DLL_XFORM_DQS14 */
			0x00000008, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00038000, /* EMC_DLL_XFORM_ADDR0 */
			0x00038000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00038000, /* EMC_DLL_XFORM_ADDR3 */
			0x00038000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000d, /* EMC_DLL_XFORM_DQ0 */
			0x0000000d, /* EMC_DLL_XFORM_DQ1 */
			0x0000000d, /* EMC_DLL_XFORM_DQ2 */
			0x0000000d, /* EMC_DLL_XFORM_DQ3 */
			0x0000000d, /* EMC_DLL_XFORM_DQ4 */
			0x0000000d, /* EMC_DLL_XFORM_DQ5 */
			0x0000000d, /* EMC_DLL_XFORM_DQ6 */
			0x0000000d, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0120113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x61861820, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x61861800, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x00f80010, /* EMC_MRS_WAIT_CNT */
			0x00f80010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x000040a0, /* EMC_CFG_PIPE */
			0x80003012, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000f, /* EMC_QPOP */
			0x0e00000b, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000004, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000005, /* MC_EMEM_ARB_TIMING_RP */
			0x00000012, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000009, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000c, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_W2R */
			0x08060202, /* MC_EMEM_ARB_DA_TURNS */
			0x00160d12, /* MC_EMEM_ARB_DA_COVERS */
			0x734c2413, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000013, /* MC_MLL_MPCORER_PTSA_RATE */
			0x0000017c, /* MC_PTSA_GRANT_DECREMENT */
			0x00810038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00810038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x0081003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00810090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00810041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00810090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00810041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00810080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080016, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x00000081, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00810019, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00810018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00810024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x0081001c, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x00000081, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00810065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x0081001c, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x0000089d, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0xe0070069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430606, /* EMC_AUTO_CAL_CONFIG */
		0x80000d71, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200018, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"06_924000_01_V5.0.6_V0.8", /* DVFS table version */
		924000,     /* SDRAM frequency */
		1010,       /* min voltage */
		1100,       /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000029, /* EMC_RC */
			0x000000ef, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x0000001d, /* EMC_RAS */
			0x0000000b, /* EMC_RP */
			0x0000000a, /* EMC_R2W */
			0x0000000f, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x00000016, /* EMC_W2P */
			0x0000000b, /* EMC_RD_RCD */
			0x0000000b, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000007, /* EMC_WDV */
			0x00000007, /* EMC_WDV_MASK */
			0x0000000d, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000002, /* EMC_EINPUT */
			0x0000000f, /* EMC_EINPUT_DURATION */
			0x000a0000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000001, /* EMC_QRST */
			0x00000016, /* EMC_QSAFE */
			0x0000001a, /* EMC_RDV */
			0x0000001c, /* EMC_RDV_MASK */
			0x00001be7, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000006f9, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000004, /* EMC_PDEX2WR */
			0x00000015, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x000000e6, /* EMC_AR2PDEN */
			0x0000001b, /* EMC_RW2PDEN */
			0x000000fa, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000006, /* EMC_TCKE */
			0x00000007, /* EMC_TCKESR */
			0x00000006, /* EMC_TPD */
			0x00000015, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x0000000a, /* EMC_TCLKSTABLE */
			0x0000000a, /* EMC_TCLKSTOP */
			0x00001c28, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b898, /* EMC_FBIO_CFG5 */
			0xe00400b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x007f400a, /* EMC_DLL_XFORM_DQS0 */
			0x007f400a, /* EMC_DLL_XFORM_DQS1 */
			0x007f400a, /* EMC_DLL_XFORM_DQS2 */
			0x007f400a, /* EMC_DLL_XFORM_DQS3 */
			0x007f400a, /* EMC_DLL_XFORM_DQS4 */
			0x007f400a, /* EMC_DLL_XFORM_DQS5 */
			0x007f400a, /* EMC_DLL_XFORM_DQS6 */
			0x007f400a, /* EMC_DLL_XFORM_DQS7 */
			0x007f400a, /* EMC_DLL_XFORM_DQS8 */
			0x007f400a, /* EMC_DLL_XFORM_DQS9 */
			0x007f400a, /* EMC_DLL_XFORM_DQS10 */
			0x007f400a, /* EMC_DLL_XFORM_DQS11 */
			0x007f400a, /* EMC_DLL_XFORM_DQS12 */
			0x007f400a, /* EMC_DLL_XFORM_DQS13 */
			0x007f400a, /* EMC_DLL_XFORM_DQS14 */
			0x007f400a, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00028000, /* EMC_DLL_XFORM_ADDR0 */
			0x00028000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00028000, /* EMC_DLL_XFORM_ADDR3 */
			0x00028000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x007f800d, /* EMC_DLL_XFORM_DQ0 */
			0x007f800d, /* EMC_DLL_XFORM_DQ1 */
			0x007f800d, /* EMC_DLL_XFORM_DQ2 */
			0x007f800d, /* EMC_DLL_XFORM_DQ3 */
			0x0007f80d, /* EMC_DLL_XFORM_DQ4 */
			0x0007f80d, /* EMC_DLL_XFORM_DQ5 */
			0x0007f80d, /* EMC_DLL_XFORM_DQ6 */
			0x0007f80d, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0120113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000808, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x55555520, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x55555500, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000128, /* EMC_ZCAL_WAIT_CNT */
			0x00ce0010, /* EMC_MRS_WAIT_CNT */
			0x00ce0010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x00004080, /* EMC_CFG_PIPE */
			0x800037ea, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000011, /* EMC_QPOP */
			0x0e00000d, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000005, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000006, /* MC_EMEM_ARB_TIMING_RP */
			0x00000015, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000e, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000b, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000e, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000009, /* MC_EMEM_ARB_TIMING_W2R */
			0x09070202, /* MC_EMEM_ARB_DA_TURNS */
			0x001a1015, /* MC_EMEM_ARB_DA_COVERS */
			0x734e2a16, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000017, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000001bb, /* MC_PTSA_GRANT_DECREMENT */
			0x006e0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x006e0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x006e003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x006e0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x006e0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x006e0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x006e0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x006e0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080016, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x0000006e, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x006e0019, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x006e0018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x006e0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x006e001b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x0000006e, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x006e0065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x006e001c, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x0000004c, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x0000089d, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0xe0040069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430606, /* EMC_AUTO_CAL_CONFIG */
		0x80000f15, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200020, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"06_1056000_01_V5.0.6_V0.8", /* DVFS table version */
		1056000,    /* SDRAM frequency */
		1100,       /* min voltage */
		1100,       /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000002f, /* EMC_RC */
			0x00000111, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000021, /* EMC_RAS */
			0x0000000c, /* EMC_RP */
			0x0000000a, /* EMC_R2W */
			0x00000011, /* EMC_W2R */
			0x00000006, /* EMC_R2P */
			0x00000019, /* EMC_W2P */
			0x0000000c, /* EMC_RD_RCD */
			0x0000000c, /* EMC_WR_RCD */
			0x00000004, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000007, /* EMC_WDV */
			0x00000007, /* EMC_WDV_MASK */
			0x0000000e, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000002, /* EMC_EINPUT */
			0x00000010, /* EMC_EINPUT_DURATION */
			0x000b0000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000001, /* EMC_QRST */
			0x00000017, /* EMC_QSAFE */
			0x0000001d, /* EMC_RDV */
			0x0000001f, /* EMC_RDV_MASK */
			0x00001fed, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000007fb, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000005, /* EMC_PDEX2WR */
			0x00000018, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000106, /* EMC_AR2PDEN */
			0x0000001e, /* EMC_RW2PDEN */
			0x0000011e, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000007, /* EMC_TCKE */
			0x00000008, /* EMC_TCKESR */
			0x00000007, /* EMC_TPD */
			0x00000018, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x0000000b, /* EMC_TCLKSTABLE */
			0x0000000b, /* EMC_TCLKSTOP */
			0x0000202d, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b898, /* EMC_FBIO_CFG5 */
			0xe00400b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000002, /* EMC_DLL_XFORM_DQS0 */
			0x00000002, /* EMC_DLL_XFORM_DQS1 */
			0x00000002, /* EMC_DLL_XFORM_DQS2 */
			0x00000002, /* EMC_DLL_XFORM_DQS3 */
			0x00000002, /* EMC_DLL_XFORM_DQS4 */
			0x00000002, /* EMC_DLL_XFORM_DQS5 */
			0x00000002, /* EMC_DLL_XFORM_DQS6 */
			0x00000002, /* EMC_DLL_XFORM_DQS7 */
			0x00000002, /* EMC_DLL_XFORM_DQS8 */
			0x00000002, /* EMC_DLL_XFORM_DQS9 */
			0x00000002, /* EMC_DLL_XFORM_DQS10 */
			0x00000002, /* EMC_DLL_XFORM_DQS11 */
			0x00000002, /* EMC_DLL_XFORM_DQS12 */
			0x00000002, /* EMC_DLL_XFORM_DQS13 */
			0x00000002, /* EMC_DLL_XFORM_DQS14 */
			0x00000002, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0000000a, /* EMC_DLL_XFORM_ADDR0 */
			0x0000000a, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0000000a, /* EMC_DLL_XFORM_ADDR3 */
			0x0000000a, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000a, /* EMC_DLL_XFORM_DQ0 */
			0x0000000a, /* EMC_DLL_XFORM_DQ1 */
			0x0000000a, /* EMC_DLL_XFORM_DQ2 */
			0x0000000a, /* EMC_DLL_XFORM_DQ3 */
			0x0000000a, /* EMC_DLL_XFORM_DQ4 */
			0x0000000a, /* EMC_DLL_XFORM_DQ5 */
			0x0000000a, /* EMC_DLL_XFORM_DQ6 */
			0x0000000a, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0120113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000808, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x55555520, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x55555500, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000152, /* EMC_ZCAL_WAIT_CNT */
			0x00a30010, /* EMC_MRS_WAIT_CNT */
			0x00a30010, /* EMC_MRS_WAIT_CNT2 */
			0x0000000a, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x00000000, /* EMC_CFG_PIPE */
			0x80003fc1, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000012, /* EMC_QPOP */
			0x0d00000f, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000005, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000006, /* MC_EMEM_ARB_TIMING_RP */
			0x00000018, /* MC_EMEM_ARB_TIMING_RC */
			0x00000010, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000c, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000f, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_R2W */
			0x0000000a, /* MC_EMEM_ARB_TIMING_W2R */
			0x0a070202, /* MC_EMEM_ARB_DA_TURNS */
			0x001c1118, /* MC_EMEM_ARB_DA_COVERS */
			0x73503019, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000001a, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000001fa, /* MC_PTSA_GRANT_DECREMENT */
			0x00600038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00600038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x0060003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00600090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00600041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00600090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00600041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00600080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00600004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00600004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080016, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x00000060, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00600004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00600019, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00600018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00600024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x0060001b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x00000060, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00600060, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00600060, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00600060, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00600060, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00600065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x0060001c, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000057, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x000008a5, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0xe0040069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x06060606, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000606, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430606, /* EMC_AUTO_CAL_CONFIG */
		0x80000125, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200028, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
};

static struct tegra12_emc_table thor_195_b00_emc_table[] = {
	{
		0x18,       /* V5.0.6 */
		"03_12750_01_V5.0.6_V0.8", /* DVFS table version */
		12750,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x4000003e, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000000, /* EMC_RC */
			0x00000003, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000000, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000003, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000000, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000004, /* EMC_EINPUT */
			0x00000004, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000001, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000003, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000c, /* EMC_RDV */
			0x0000000e, /* EMC_RDV_MASK */
			0x00000060, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000018, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000005, /* EMC_TXSR */
			0x00000005, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000064, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x10604098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00078000, /* EMC_DLL_XFORM_DQS8 */
			0x00078000, /* EMC_DLL_XFORM_DQS9 */
			0x00078000, /* EMC_DLL_XFORM_DQS10 */
			0x00078000, /* EMC_DLL_XFORM_DQS11 */
			0x00078000, /* EMC_DLL_XFORM_DQS12 */
			0x00078000, /* EMC_DLL_XFORM_DQS13 */
			0x00078000, /* EMC_DLL_XFORM_DQS14 */
			0x00078000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x00008000, /* EMC_DLL_XFORM_DQ4 */
			0x00008000, /* EMC_DLL_XFORM_DQ5 */
			0x00008000, /* EMC_DLL_XFORM_DQ6 */
			0x00008000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0030a118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000007, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000001, /* EMC_CTT_DURATION */
			0x0000f3f3, /* EMC_CFG_PIPE */
			0x800001c5, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x40040001, /* MC_EMEM_ARB_CFG */
			0x8000000a, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x77e30303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000007, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"03_20400_01_V5.0.6_V0.8", /* DVFS table version */
		20400,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000026, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000000, /* EMC_RC */
			0x00000005, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000000, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000003, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000000, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000004, /* EMC_EINPUT */
			0x00000004, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000001, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000003, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000c, /* EMC_RDV */
			0x0000000e, /* EMC_RDV_MASK */
			0x0000009a, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000026, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000006, /* EMC_TXSR */
			0x00000006, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x000000a0, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x10604098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00078000, /* EMC_DLL_XFORM_DQS8 */
			0x00078000, /* EMC_DLL_XFORM_DQS9 */
			0x00078000, /* EMC_DLL_XFORM_DQS10 */
			0x00078000, /* EMC_DLL_XFORM_DQS11 */
			0x00078000, /* EMC_DLL_XFORM_DQS12 */
			0x00078000, /* EMC_DLL_XFORM_DQS13 */
			0x00078000, /* EMC_DLL_XFORM_DQS14 */
			0x00078000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x00008000, /* EMC_DLL_XFORM_DQ4 */
			0x00008000, /* EMC_DLL_XFORM_DQ5 */
			0x00008000, /* EMC_DLL_XFORM_DQ6 */
			0x00008000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0030a118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x0000000b, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000001, /* EMC_CTT_DURATION */
			0x0000f3f3, /* EMC_CFG_PIPE */
			0x8000023a, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x40020001, /* MC_EMEM_ARB_CFG */
			0x80000012, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x76230303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x0000000a, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"03_40800_01_V5.0.6_V0.8", /* DVFS table version */
		40800,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000012, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000001, /* EMC_RC */
			0x0000000a, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000001, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000003, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000000, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000004, /* EMC_EINPUT */
			0x00000004, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000001, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000003, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000c, /* EMC_RDV */
			0x0000000e, /* EMC_RDV_MASK */
			0x00000134, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x0000004d, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000008, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000000c, /* EMC_TXSR */
			0x0000000c, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x0000013f, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x10604098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00078000, /* EMC_DLL_XFORM_DQS8 */
			0x00078000, /* EMC_DLL_XFORM_DQS9 */
			0x00078000, /* EMC_DLL_XFORM_DQS10 */
			0x00078000, /* EMC_DLL_XFORM_DQS11 */
			0x00078000, /* EMC_DLL_XFORM_DQS12 */
			0x00078000, /* EMC_DLL_XFORM_DQS13 */
			0x00078000, /* EMC_DLL_XFORM_DQS14 */
			0x00078000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x00008000, /* EMC_DLL_XFORM_DQ4 */
			0x00008000, /* EMC_DLL_XFORM_DQ5 */
			0x00008000, /* EMC_DLL_XFORM_DQ6 */
			0x00008000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0030a118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000015, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000001, /* EMC_CTT_DURATION */
			0x0000f3f3, /* EMC_CFG_PIPE */
			0x80000370, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0xa0000001, /* MC_EMEM_ARB_CFG */
			0x80000017, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x74a30303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000014, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"03_68000_01_V5.0.6_V0.8", /* DVFS table version */
		68000,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x4000000a, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000003, /* EMC_RC */
			0x00000011, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000003, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000000, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000004, /* EMC_EINPUT */
			0x00000004, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000001, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000003, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000c, /* EMC_RDV */
			0x0000000e, /* EMC_RDV_MASK */
			0x00000202, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000080, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x0000000f, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000013, /* EMC_TXSR */
			0x00000013, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000213, /* EMC_TREFBW */
			0x00000002, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x10604098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00078000, /* EMC_DLL_XFORM_DQS8 */
			0x00078000, /* EMC_DLL_XFORM_DQS9 */
			0x00078000, /* EMC_DLL_XFORM_DQS10 */
			0x00078000, /* EMC_DLL_XFORM_DQS11 */
			0x00078000, /* EMC_DLL_XFORM_DQS12 */
			0x00078000, /* EMC_DLL_XFORM_DQS13 */
			0x00078000, /* EMC_DLL_XFORM_DQS14 */
			0x00078000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x00008000, /* EMC_DLL_XFORM_DQ4 */
			0x00008000, /* EMC_DLL_XFORM_DQ5 */
			0x00008000, /* EMC_DLL_XFORM_DQ6 */
			0x00008000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0030a118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000022, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000001, /* EMC_CTT_DURATION */
			0x0000f3f3, /* EMC_CFG_PIPE */
			0x8000050e, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x00000001, /* MC_EMEM_ARB_CFG */
			0x8000001e, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x74230403, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000021, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00b0, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ec, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ec, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00e90049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00a3, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ef, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ef, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ee00ef, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"03_102000_01_V5.0.6_V0.8", /* DVFS table version */
		102000,     /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000006, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000004, /* EMC_RC */
			0x0000001a, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000003, /* EMC_RAS */
			0x00000001, /* EMC_RP */
			0x00000003, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000001, /* EMC_RD_RCD */
			0x00000001, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000000, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000004, /* EMC_EINPUT */
			0x00000004, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000001, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000003, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000c, /* EMC_RDV */
			0x0000000e, /* EMC_RDV_MASK */
			0x00000304, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000000c1, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000018, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000001c, /* EMC_TXSR */
			0x0000001c, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000001, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x0000031c, /* EMC_TREFBW */
			0x00000002, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x10604098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00078000, /* EMC_DLL_XFORM_DQS8 */
			0x00078000, /* EMC_DLL_XFORM_DQS9 */
			0x00078000, /* EMC_DLL_XFORM_DQS10 */
			0x00078000, /* EMC_DLL_XFORM_DQS11 */
			0x00078000, /* EMC_DLL_XFORM_DQS12 */
			0x00078000, /* EMC_DLL_XFORM_DQS13 */
			0x00078000, /* EMC_DLL_XFORM_DQS14 */
			0x00078000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x00008000, /* EMC_DLL_XFORM_DQ4 */
			0x00008000, /* EMC_DLL_XFORM_DQ5 */
			0x00008000, /* EMC_DLL_XFORM_DQ6 */
			0x00008000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0030a118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000033, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000001, /* EMC_CTT_DURATION */
			0x0000f3f3, /* EMC_CFG_PIPE */
			0x80000713, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x08000001, /* MC_EMEM_ARB_CFG */
			0x80000026, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000003, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0403, /* MC_EMEM_ARB_DA_COVERS */
			0x73c30504, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000031, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff0075, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff009d, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff009d, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x009b0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ad, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00c6, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00d6, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x0000009f, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x0000009f, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x009f00a0, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"03_204000_01_V5.0.6_V0.8", /* DVFS table version */
		204000,     /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000002, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000009, /* EMC_RC */
			0x00000035, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000006, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000004, /* EMC_WDV */
			0x00000004, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000000, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000001, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x0000000d, /* EMC_QSAFE */
			0x0000000e, /* EMC_RDV */
			0x00000010, /* EMC_RDV_MASK */
			0x00000607, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000181, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000032, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000038, /* EMC_TXSR */
			0x00000038, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000004, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000638, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x10604098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00078000, /* EMC_DLL_XFORM_DQS8 */
			0x00078000, /* EMC_DLL_XFORM_DQS9 */
			0x00078000, /* EMC_DLL_XFORM_DQS10 */
			0x00078000, /* EMC_DLL_XFORM_DQS11 */
			0x00078000, /* EMC_DLL_XFORM_DQS12 */
			0x00078000, /* EMC_DLL_XFORM_DQS13 */
			0x00078000, /* EMC_DLL_XFORM_DQS14 */
			0x00078000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00078000, /* EMC_DLL_XFORM_ADDR0 */
			0x00078000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00078000, /* EMC_DLL_XFORM_ADDR3 */
			0x00078000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x00008000, /* EMC_DLL_XFORM_DQ4 */
			0x00008000, /* EMC_DLL_XFORM_DQ5 */
			0x00008000, /* EMC_DLL_XFORM_DQ6 */
			0x00008000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0030a118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000066, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000001, /* EMC_CTT_DURATION */
			0x0000d3b3, /* EMC_CFG_PIPE */
			0x80000d22, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x01000003, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000004, /* MC_EMEM_ARB_TIMING_RC */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0404, /* MC_EMEM_ARB_DA_COVERS */
			0x73840a05, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000062, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00af, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff004f, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00af, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff004f, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x004e0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080057, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0063, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff0036, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff006b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000050, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000050, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510050, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00c6, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008cd, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"03_300000_01_V5.0.6_V0.8", /* DVFS table version */
		300000,     /* SDRAM frequency */
		810,        /* min voltage */
		800,        /* gpu min voltage */
		"pllc_out0", /* clock source id */
		0x20000002, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000000c, /* EMC_RC */
			0x0000004c, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000008, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x00000009, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x00000006, /* EMC_EINPUT_DURATION */
			0x00030000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x0000000d, /* EMC_QSAFE */
			0x0000000e, /* EMC_RDV */
			0x00000010, /* EMC_RDV_MASK */
			0x000008e4, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000239, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000008, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x0000004a, /* EMC_AR2PDEN */
			0x0000000e, /* EMC_RW2PDEN */
			0x00000051, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000005, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000924, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00030000, /* EMC_DLL_XFORM_DQS0 */
			0x00030000, /* EMC_DLL_XFORM_DQS1 */
			0x00030000, /* EMC_DLL_XFORM_DQS2 */
			0x00030000, /* EMC_DLL_XFORM_DQS3 */
			0x00030000, /* EMC_DLL_XFORM_DQS4 */
			0x00030000, /* EMC_DLL_XFORM_DQS5 */
			0x00030000, /* EMC_DLL_XFORM_DQS6 */
			0x00030000, /* EMC_DLL_XFORM_DQS7 */
			0x00030000, /* EMC_DLL_XFORM_DQS8 */
			0x00030000, /* EMC_DLL_XFORM_DQS9 */
			0x00030000, /* EMC_DLL_XFORM_DQS10 */
			0x00030000, /* EMC_DLL_XFORM_DQS11 */
			0x00030000, /* EMC_DLL_XFORM_DQS12 */
			0x00030000, /* EMC_DLL_XFORM_DQS13 */
			0x00030000, /* EMC_DLL_XFORM_DQS14 */
			0x00030000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00070000, /* EMC_DLL_XFORM_ADDR0 */
			0x00070000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00070000, /* EMC_DLL_XFORM_ADDR3 */
			0x00070000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00060000, /* EMC_DLL_XFORM_DQ0 */
			0x00060000, /* EMC_DLL_XFORM_DQ1 */
			0x00060000, /* EMC_DLL_XFORM_DQ2 */
			0x00060000, /* EMC_DLL_XFORM_DQ3 */
			0x00006000, /* EMC_DLL_XFORM_DQ4 */
			0x00006000, /* EMC_DLL_XFORM_DQ5 */
			0x00006000, /* EMC_DLL_XFORM_DQ6 */
			0x00006000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x01231339, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000096, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x01740010, /* EMC_MRS_WAIT_CNT */
			0x01740010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000d3b3, /* EMC_CFG_PIPE */
			0x800012d7, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x08000004, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000006, /* MC_EMEM_ARB_TIMING_RC */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06040202, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0506, /* MC_EMEM_ARB_DA_COVERS */
			0x77450e07, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000004, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000090, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00350049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008003b, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0043, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff002d, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510036, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff0087, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73340000, /* EMC_CFG */
		0x000008cd, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000321, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200000, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"03_396000_01_V5.0.6_V0.8", /* DVFS table version */
		396000,     /* SDRAM frequency */
		860,        /* min voltage */
		900,        /* gpu min voltage */
		"pllm_out0", /* clock source id */
		0x00000002, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000011, /* EMC_RC */
			0x00000065, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x0000000c, /* EMC_RAS */
			0x00000004, /* EMC_RP */
			0x00000005, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000004, /* EMC_RD_RCD */
			0x00000004, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x00000006, /* EMC_EINPUT_DURATION */
			0x00030000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x0000000d, /* EMC_QSAFE */
			0x0000000e, /* EMC_RDV */
			0x00000010, /* EMC_RDV_MASK */
			0x00000bd1, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000002f4, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000008, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000063, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000006b, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000007, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000c11, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00030000, /* EMC_DLL_XFORM_DQS0 */
			0x00030000, /* EMC_DLL_XFORM_DQS1 */
			0x00030000, /* EMC_DLL_XFORM_DQS2 */
			0x00030000, /* EMC_DLL_XFORM_DQS3 */
			0x00030000, /* EMC_DLL_XFORM_DQS4 */
			0x00030000, /* EMC_DLL_XFORM_DQS5 */
			0x00030000, /* EMC_DLL_XFORM_DQS6 */
			0x00030000, /* EMC_DLL_XFORM_DQS7 */
			0x00030000, /* EMC_DLL_XFORM_DQS8 */
			0x00030000, /* EMC_DLL_XFORM_DQS9 */
			0x00030000, /* EMC_DLL_XFORM_DQS10 */
			0x00030000, /* EMC_DLL_XFORM_DQS11 */
			0x00030000, /* EMC_DLL_XFORM_DQS12 */
			0x00030000, /* EMC_DLL_XFORM_DQS13 */
			0x00030000, /* EMC_DLL_XFORM_DQS14 */
			0x00030000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00060000, /* EMC_DLL_XFORM_ADDR0 */
			0x00060000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00060000, /* EMC_DLL_XFORM_ADDR3 */
			0x00060000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00050000, /* EMC_DLL_XFORM_DQ0 */
			0x00050000, /* EMC_DLL_XFORM_DQ1 */
			0x00050000, /* EMC_DLL_XFORM_DQ2 */
			0x00050000, /* EMC_DLL_XFORM_DQ3 */
			0x00005000, /* EMC_DLL_XFORM_DQ4 */
			0x00005000, /* EMC_DLL_XFORM_DQ5 */
			0x00005000, /* EMC_DLL_XFORM_DQ6 */
			0x00005000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x01231339, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x000000c6, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x015b0010, /* EMC_MRS_WAIT_CNT */
			0x015b0010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000d3b3, /* EMC_CFG_PIPE */
			0x8000188b, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x0f000005, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RP */
			0x00000009, /* MC_EMEM_ARB_TIMING_RC */
			0x00000005, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000004, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06040202, /* MC_EMEM_ARB_DA_TURNS */
			0x000d0709, /* MC_EMEM_ARB_DA_COVERS */
			0x7586120a, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000a, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000000be, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00280049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008002d, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0033, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff0022, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff0037, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff0066, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73340000, /* EMC_CFG */
		0x0000088d, /* EMC_CFG_2 */
		0x00040008, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000521, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200000, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"03_528000_01_V5.0.6_V0.8", /* DVFS table version */
		528000,     /* SDRAM frequency */
		920,        /* min voltage */
		900,        /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000017, /* EMC_RC */
			0x00000088, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000010, /* EMC_RAS */
			0x00000005, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000009, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x0000000d, /* EMC_W2P */
			0x00000005, /* EMC_RD_RCD */
			0x00000005, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000004, /* EMC_WDV */
			0x00000004, /* EMC_WDV_MASK */
			0x00000008, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000007, /* EMC_EINPUT_DURATION */
			0x00060000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000e, /* EMC_QSAFE */
			0x00000013, /* EMC_RDV */
			0x00000015, /* EMC_RDV_MASK */
			0x00000fd6, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000003f5, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x0000000b, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000084, /* EMC_AR2PDEN */
			0x00000012, /* EMC_RW2PDEN */
			0x0000008f, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x0000000b, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000006, /* EMC_TCLKSTABLE */
			0x00000006, /* EMC_TCLKSTOP */
			0x00001017, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b098, /* EMC_FBIO_CFG5 */
			0xe01200b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000000a, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_DLL_XFORM_DQS1 */
			0x0000000a, /* EMC_DLL_XFORM_DQS2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS3 */
			0x0000000a, /* EMC_DLL_XFORM_DQS4 */
			0x0000000a, /* EMC_DLL_XFORM_DQS5 */
			0x0000000a, /* EMC_DLL_XFORM_DQS6 */
			0x0000000a, /* EMC_DLL_XFORM_DQS7 */
			0x0000000a, /* EMC_DLL_XFORM_DQS8 */
			0x0000000a, /* EMC_DLL_XFORM_DQS9 */
			0x0000000a, /* EMC_DLL_XFORM_DQS10 */
			0x0000000a, /* EMC_DLL_XFORM_DQS11 */
			0x0000000a, /* EMC_DLL_XFORM_DQS12 */
			0x0000000a, /* EMC_DLL_XFORM_DQS13 */
			0x0000000a, /* EMC_DLL_XFORM_DQS14 */
			0x0000000a, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00050000, /* EMC_DLL_XFORM_ADDR0 */
			0x00050000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00050000, /* EMC_DLL_XFORM_ADDR3 */
			0x00050000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000e, /* EMC_DLL_XFORM_DQ0 */
			0x0000000e, /* EMC_DLL_XFORM_DQ1 */
			0x0000000e, /* EMC_DLL_XFORM_DQ2 */
			0x0000000e, /* EMC_DLL_XFORM_DQ3 */
			0x0000000e, /* EMC_DLL_XFORM_DQ4 */
			0x0000000e, /* EMC_DLL_XFORM_DQ5 */
			0x0000000e, /* EMC_DLL_XFORM_DQ6 */
			0x0000000e, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0123133d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x013a0010, /* EMC_MRS_WAIT_CNT */
			0x013a0010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x000052a0, /* EMC_CFG_PIPE */
			0x80002062, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000c, /* EMC_QPOP */
			0x0f000007, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000002, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RP */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RC */
			0x00000007, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000006, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000009, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06050202, /* MC_EMEM_ARB_DA_TURNS */
			0x000f080c, /* MC_EMEM_ARB_DA_COVERS */
			0x7428180d, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000d, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000000fd, /* MC_PTSA_GRANT_DECREMENT */
			0x00c10038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00c10038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00c1003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00c10090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00c10041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00c10090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00c10041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00c10080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080021, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000c1, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00c10026, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00c1001a, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00c10024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00c10029, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000c1, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00c10065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00c1002a, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x00000895, /* EMC_CFG_2 */
		0x00040008, /* EMC_SEL_DPD_CTRL */
		0xe0120069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000941, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"03_600000_01_V5.0.6_V0.8", /* DVFS table version */
		600000,     /* SDRAM frequency */
		920,        /* min voltage */
		900,        /* gpu min voltage */
		"pllc_out0", /* clock source id */
		0x20000000, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000001a, /* EMC_RC */
			0x0000009a, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000012, /* EMC_RAS */
			0x00000006, /* EMC_RP */
			0x00000007, /* EMC_R2W */
			0x0000000b, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x00000010, /* EMC_W2P */
			0x00000006, /* EMC_RD_RCD */
			0x00000006, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x0000000a, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x0000000b, /* EMC_EINPUT_DURATION */
			0x00070000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x00000012, /* EMC_QSAFE */
			0x00000016, /* EMC_RDV */
			0x00000018, /* EMC_RDV_MASK */
			0x00001208, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000482, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x0000000d, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000096, /* EMC_AR2PDEN */
			0x00000015, /* EMC_RW2PDEN */
			0x000000a2, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x0000000c, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000006, /* EMC_TCLKSTABLE */
			0x00000006, /* EMC_TCLKSTOP */
			0x00001248, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b098, /* EMC_FBIO_CFG5 */
			0xe00e00b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000000a, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_DLL_XFORM_DQS1 */
			0x0000000a, /* EMC_DLL_XFORM_DQS2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS3 */
			0x0000000a, /* EMC_DLL_XFORM_DQS4 */
			0x0000000a, /* EMC_DLL_XFORM_DQS5 */
			0x0000000a, /* EMC_DLL_XFORM_DQS6 */
			0x0000000a, /* EMC_DLL_XFORM_DQS7 */
			0x0000000a, /* EMC_DLL_XFORM_DQS8 */
			0x0000000a, /* EMC_DLL_XFORM_DQS9 */
			0x0000000a, /* EMC_DLL_XFORM_DQS10 */
			0x0000000a, /* EMC_DLL_XFORM_DQS11 */
			0x0000000a, /* EMC_DLL_XFORM_DQS12 */
			0x0000000a, /* EMC_DLL_XFORM_DQS13 */
			0x0000000a, /* EMC_DLL_XFORM_DQS14 */
			0x0000000a, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0004c000, /* EMC_DLL_XFORM_ADDR0 */
			0x0004c000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0004c000, /* EMC_DLL_XFORM_ADDR3 */
			0x0004c000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000d, /* EMC_DLL_XFORM_DQ0 */
			0x0000000d, /* EMC_DLL_XFORM_DQ1 */
			0x0000000d, /* EMC_DLL_XFORM_DQ2 */
			0x0000000d, /* EMC_DLL_XFORM_DQ3 */
			0x0000000d, /* EMC_DLL_XFORM_DQ4 */
			0x0000000d, /* EMC_DLL_XFORM_DQ5 */
			0x0000000d, /* EMC_DLL_XFORM_DQ6 */
			0x0000000d, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0121113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x01280010, /* EMC_MRS_WAIT_CNT */
			0x01280010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x000040a0, /* EMC_CFG_PIPE */
			0x800024aa, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000e, /* EMC_QPOP */
			0x00000009, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000002, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RP */
			0x0000000d, /* MC_EMEM_ARB_TIMING_RC */
			0x00000008, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000006, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000b, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_W2R */
			0x07050202, /* MC_EMEM_ARB_DA_TURNS */
			0x00120a0d, /* MC_EMEM_ARB_DA_COVERS */
			0x73a91b0e, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000f, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000120, /* MC_PTSA_GRANT_DECREMENT */
			0x00aa0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00aa0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00aa003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00aa0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00aa0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00aa0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00aa0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00aa0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008001d, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000aa, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00aa0022, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00aa0018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00aa0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00aa0024, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000aa, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00aa0065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00aa0025, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x0000089d, /* EMC_CFG_2 */
		0x00040008, /* EMC_SEL_DPD_CTRL */
		0xe00e0069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000b61, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200010, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"03_792000_01_V5.0.6_V0.8", /* DVFS table version */
		792000,     /* SDRAM frequency */
		1000,       /* min voltage */
		1100,       /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000023, /* EMC_RC */
			0x000000cc, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000019, /* EMC_RAS */
			0x00000009, /* EMC_RP */
			0x00000008, /* EMC_R2W */
			0x0000000d, /* EMC_W2R */
			0x00000004, /* EMC_R2P */
			0x00000013, /* EMC_W2P */
			0x00000009, /* EMC_RD_RCD */
			0x00000009, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x0000000b, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000002, /* EMC_EINPUT */
			0x0000000d, /* EMC_EINPUT_DURATION */
			0x00080000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000001, /* EMC_QRST */
			0x00000014, /* EMC_QSAFE */
			0x00000017, /* EMC_RDV */
			0x00000019, /* EMC_RDV_MASK */
			0x000017e2, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000005f8, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000003, /* EMC_PDEX2WR */
			0x00000011, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x000000c6, /* EMC_AR2PDEN */
			0x00000018, /* EMC_RW2PDEN */
			0x000000d6, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000005, /* EMC_TCKE */
			0x00000006, /* EMC_TCKESR */
			0x00000005, /* EMC_TPD */
			0x00000011, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000008, /* EMC_TCLKSTABLE */
			0x00000008, /* EMC_TCLKSTOP */
			0x00001822, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b098, /* EMC_FBIO_CFG5 */
			0xe00700b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000008, /* EMC_DLL_XFORM_DQS0 */
			0x00000008, /* EMC_DLL_XFORM_DQS1 */
			0x00000008, /* EMC_DLL_XFORM_DQS2 */
			0x00000008, /* EMC_DLL_XFORM_DQS3 */
			0x00000008, /* EMC_DLL_XFORM_DQS4 */
			0x00000008, /* EMC_DLL_XFORM_DQS5 */
			0x00000008, /* EMC_DLL_XFORM_DQS6 */
			0x00000008, /* EMC_DLL_XFORM_DQS7 */
			0x00000008, /* EMC_DLL_XFORM_DQS8 */
			0x00000008, /* EMC_DLL_XFORM_DQS9 */
			0x00000008, /* EMC_DLL_XFORM_DQS10 */
			0x00000008, /* EMC_DLL_XFORM_DQS11 */
			0x00000008, /* EMC_DLL_XFORM_DQS12 */
			0x00000008, /* EMC_DLL_XFORM_DQS13 */
			0x00000008, /* EMC_DLL_XFORM_DQS14 */
			0x00000008, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0003c000, /* EMC_DLL_XFORM_ADDR0 */
			0x0003c000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0003c000, /* EMC_DLL_XFORM_ADDR3 */
			0x0003c000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000b, /* EMC_DLL_XFORM_DQ0 */
			0x0000000b, /* EMC_DLL_XFORM_DQ1 */
			0x0000000b, /* EMC_DLL_XFORM_DQ2 */
			0x0000000b, /* EMC_DLL_XFORM_DQ3 */
			0x0000000b, /* EMC_DLL_XFORM_DQ4 */
			0x0000000b, /* EMC_DLL_XFORM_DQ5 */
			0x0000000b, /* EMC_DLL_XFORM_DQ6 */
			0x0000000b, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0120113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x61861820, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x61861800, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x00f80010, /* EMC_MRS_WAIT_CNT */
			0x00f80010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x000040a0, /* EMC_CFG_PIPE */
			0x80003012, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000f, /* EMC_QPOP */
			0x0e00000b, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000004, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000005, /* MC_EMEM_ARB_TIMING_RP */
			0x00000012, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000009, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000c, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_W2R */
			0x08060202, /* MC_EMEM_ARB_DA_TURNS */
			0x00160d12, /* MC_EMEM_ARB_DA_COVERS */
			0x734c2413, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000013, /* MC_MLL_MPCORER_PTSA_RATE */
			0x0000017c, /* MC_PTSA_GRANT_DECREMENT */
			0x00810038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00810038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x0081003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00810090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00810041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00810090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00810041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00810080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080016, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x00000081, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00810019, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00810018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00810024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x0081001c, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x00000081, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00810065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x0081001c, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x0000089d, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0xe0070069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000d71, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200018, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"03_924000_01_V5.0.6_V0.8", /* DVFS table version */
		924000,     /* SDRAM frequency */
		1010,       /* min voltage */
		1100,       /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000029, /* EMC_RC */
			0x000000ef, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x0000001d, /* EMC_RAS */
			0x0000000b, /* EMC_RP */
			0x0000000a, /* EMC_R2W */
			0x0000000f, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x00000016, /* EMC_W2P */
			0x0000000b, /* EMC_RD_RCD */
			0x0000000b, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000007, /* EMC_WDV */
			0x00000007, /* EMC_WDV_MASK */
			0x0000000d, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000002, /* EMC_EINPUT */
			0x0000000f, /* EMC_EINPUT_DURATION */
			0x000a0000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000001, /* EMC_QRST */
			0x00000016, /* EMC_QSAFE */
			0x0000001a, /* EMC_RDV */
			0x0000001c, /* EMC_RDV_MASK */
			0x00001be7, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000006f9, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000004, /* EMC_PDEX2WR */
			0x00000015, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x000000e6, /* EMC_AR2PDEN */
			0x0000001b, /* EMC_RW2PDEN */
			0x000000fa, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000006, /* EMC_TCKE */
			0x00000007, /* EMC_TCKESR */
			0x00000006, /* EMC_TPD */
			0x00000015, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x0000000a, /* EMC_TCLKSTABLE */
			0x0000000a, /* EMC_TCLKSTOP */
			0x00001c28, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b898, /* EMC_FBIO_CFG5 */
			0xe00400b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x007fc00a, /* EMC_DLL_XFORM_DQS0 */
			0x007fc00a, /* EMC_DLL_XFORM_DQS1 */
			0x007fc00a, /* EMC_DLL_XFORM_DQS2 */
			0x007fc00a, /* EMC_DLL_XFORM_DQS3 */
			0x007fc00a, /* EMC_DLL_XFORM_DQS4 */
			0x007fc00a, /* EMC_DLL_XFORM_DQS5 */
			0x007fc00a, /* EMC_DLL_XFORM_DQS6 */
			0x007fc00a, /* EMC_DLL_XFORM_DQS7 */
			0x007fc00a, /* EMC_DLL_XFORM_DQS8 */
			0x007fc00a, /* EMC_DLL_XFORM_DQS9 */
			0x007fc00a, /* EMC_DLL_XFORM_DQS10 */
			0x007fc00a, /* EMC_DLL_XFORM_DQS11 */
			0x007fc00a, /* EMC_DLL_XFORM_DQS12 */
			0x007fc00a, /* EMC_DLL_XFORM_DQS13 */
			0x007fc00a, /* EMC_DLL_XFORM_DQS14 */
			0x007fc00a, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00030000, /* EMC_DLL_XFORM_ADDR0 */
			0x00030000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00030000, /* EMC_DLL_XFORM_ADDR3 */
			0x00030000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000a, /* EMC_DLL_XFORM_DQ0 */
			0x0000000a, /* EMC_DLL_XFORM_DQ1 */
			0x0000000a, /* EMC_DLL_XFORM_DQ2 */
			0x0000000a, /* EMC_DLL_XFORM_DQ3 */
			0x0000000a, /* EMC_DLL_XFORM_DQ4 */
			0x0000000a, /* EMC_DLL_XFORM_DQ5 */
			0x0000000a, /* EMC_DLL_XFORM_DQ6 */
			0x0000000a, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0120113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x55555520, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x55555500, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000128, /* EMC_ZCAL_WAIT_CNT */
			0x00ce0010, /* EMC_MRS_WAIT_CNT */
			0x00ce0010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x00004080, /* EMC_CFG_PIPE */
			0x800037ea, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000011, /* EMC_QPOP */
			0x0e00000d, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000005, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000006, /* MC_EMEM_ARB_TIMING_RP */
			0x00000015, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000e, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000b, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000e, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000009, /* MC_EMEM_ARB_TIMING_W2R */
			0x09070202, /* MC_EMEM_ARB_DA_TURNS */
			0x001a1015, /* MC_EMEM_ARB_DA_COVERS */
			0x734e2a16, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000017, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000001bb, /* MC_PTSA_GRANT_DECREMENT */
			0x006e0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x006e0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x006e003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x006e0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x006e0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x006e0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x006e0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x006e0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080016, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x0000006e, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x006e0019, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x006e0018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x006e0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x006e001b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x0000006e, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x006e0065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x006e001c, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x0000004c, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x0000089d, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0xe0040069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000f15, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200020, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.6 */
		"03_1056000_01_V5.0.6_V0.8", /* DVFS table version */
		1056000,    /* SDRAM frequency */
		1100,       /* min voltage */
		1100,       /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000002f, /* EMC_RC */
			0x00000111, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000021, /* EMC_RAS */
			0x0000000c, /* EMC_RP */
			0x0000000a, /* EMC_R2W */
			0x00000011, /* EMC_W2R */
			0x00000006, /* EMC_R2P */
			0x00000019, /* EMC_W2P */
			0x0000000c, /* EMC_RD_RCD */
			0x0000000c, /* EMC_WR_RCD */
			0x00000004, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000007, /* EMC_WDV */
			0x00000007, /* EMC_WDV_MASK */
			0x0000000d, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000002, /* EMC_EINPUT */
			0x00000010, /* EMC_EINPUT_DURATION */
			0x000b0000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000001, /* EMC_QRST */
			0x00000017, /* EMC_QSAFE */
			0x0000001d, /* EMC_RDV */
			0x0000001f, /* EMC_RDV_MASK */
			0x00001fed, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000007fb, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000005, /* EMC_PDEX2WR */
			0x00000018, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000106, /* EMC_AR2PDEN */
			0x0000001e, /* EMC_RW2PDEN */
			0x0000011e, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000007, /* EMC_TCKE */
			0x00000008, /* EMC_TCKESR */
			0x00000007, /* EMC_TPD */
			0x00000018, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x0000000b, /* EMC_TCLKSTABLE */
			0x0000000b, /* EMC_TCLKSTOP */
			0x0000202d, /* EMC_TREFBW */
			0x00000002, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b8d8, /* EMC_FBIO_CFG5 */
			0xd00100b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000004, /* EMC_DLL_XFORM_DQS0 */
			0x00000004, /* EMC_DLL_XFORM_DQS1 */
			0x00000004, /* EMC_DLL_XFORM_DQS2 */
			0x00000004, /* EMC_DLL_XFORM_DQS3 */
			0x00000004, /* EMC_DLL_XFORM_DQS4 */
			0x00000004, /* EMC_DLL_XFORM_DQS5 */
			0x00000004, /* EMC_DLL_XFORM_DQS6 */
			0x00000004, /* EMC_DLL_XFORM_DQS7 */
			0x00000004, /* EMC_DLL_XFORM_DQS8 */
			0x00000004, /* EMC_DLL_XFORM_DQS9 */
			0x00000004, /* EMC_DLL_XFORM_DQS10 */
			0x00000004, /* EMC_DLL_XFORM_DQS11 */
			0x00000004, /* EMC_DLL_XFORM_DQS12 */
			0x00000004, /* EMC_DLL_XFORM_DQS13 */
			0x00000004, /* EMC_DLL_XFORM_DQS14 */
			0x00000004, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0002c000, /* EMC_DLL_XFORM_ADDR0 */
			0x0002c000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0002c000, /* EMC_DLL_XFORM_ADDR3 */
			0x0002c000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00000008, /* EMC_DLL_XFORM_DQ0 */
			0x00000008, /* EMC_DLL_XFORM_DQ1 */
			0x00000008, /* EMC_DLL_XFORM_DQ2 */
			0x00000008, /* EMC_DLL_XFORM_DQ3 */
			0x00000008, /* EMC_DLL_XFORM_DQ4 */
			0x00000008, /* EMC_DLL_XFORM_DQ5 */
			0x00000008, /* EMC_DLL_XFORM_DQ6 */
			0x00000008, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0120113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000808, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x4d34d320, /* EMC_XM2DQSPADCTRL3 */
			0x00451451, /* EMC_XM2DQSPADCTRL4 */
			0x00451451, /* EMC_XM2DQSPADCTRL5 */
			0x4d34d320, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000152, /* EMC_ZCAL_WAIT_CNT */
			0x00a30010, /* EMC_MRS_WAIT_CNT */
			0x00a30010, /* EMC_MRS_WAIT_CNT2 */
			0x0000000a, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x00000000, /* EMC_CFG_PIPE */
			0x80003fc1, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000012, /* EMC_QPOP */
			0x0d00000f, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000005, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000006, /* MC_EMEM_ARB_TIMING_RP */
			0x00000018, /* MC_EMEM_ARB_TIMING_RC */
			0x00000010, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000c, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000f, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_R2W */
			0x0000000a, /* MC_EMEM_ARB_TIMING_W2R */
			0x0a070202, /* MC_EMEM_ARB_DA_TURNS */
			0x001c1118, /* MC_EMEM_ARB_DA_COVERS */
			0x73503019, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000001a, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000001fa, /* MC_PTSA_GRANT_DECREMENT */
			0x00600038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00600038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x0060003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00600090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00600041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00600090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00600041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00600080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00600004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00600004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080016, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x00000060, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00600004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00600019, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00600018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00600024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x0060001b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x00000060, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00600060, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00600060, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00600060, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00600060, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00600065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x0060001c, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000057, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x000008a5, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0xd0010069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430606, /* EMC_AUTO_CAL_CONFIG */
		0x80000125, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200028, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
};

static struct tegra12_emc_table loki_ffd_sku0_emc_table[] = {
	{
		0x18,       /* V5.0.9 */
		"05_12750_01_V5.0.9_V0.8", /* DVFS table version */
		12750,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x4000003e, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000000, /* EMC_RC */
			0x00000003, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000000, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000060, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000018, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000005, /* EMC_TXSR */
			0x00000005, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000064, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1060a298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000007, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x00110011, /* EMC_MRS_WAIT_CNT */
			0x00110011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f2f3, /* EMC_CFG_PIPE */
			0x800001c5, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x40040001, /* MC_EMEM_ARB_CFG */
			0x8000000a, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x77e30303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000007, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"05_20400_01_V5.0.9_V0.8", /* DVFS table version */
		20400,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000026, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000000, /* EMC_RC */
			0x00000005, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000000, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x0000009a, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000026, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000006, /* EMC_TXSR */
			0x00000006, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x000000a0, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1060a298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x0000000b, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x00110011, /* EMC_MRS_WAIT_CNT */
			0x00110011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f2f3, /* EMC_CFG_PIPE */
			0x8000023a, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x40020001, /* MC_EMEM_ARB_CFG */
			0x80000012, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x76230303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x0000000a, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"05_40800_01_V5.0.9_V0.8", /* DVFS table version */
		40800,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000012, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000001, /* EMC_RC */
			0x0000000a, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000001, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000134, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x0000004d, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000008, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000000c, /* EMC_TXSR */
			0x0000000c, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x0000013f, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1060a298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000015, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x00110011, /* EMC_MRS_WAIT_CNT */
			0x00110011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f2f3, /* EMC_CFG_PIPE */
			0x80000370, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0xa0000001, /* MC_EMEM_ARB_CFG */
			0x80000017, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x74a30303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000014, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"05_68000_01_V5.0.9_V0.8", /* DVFS table version */
		68000,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x4000000a, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000003, /* EMC_RC */
			0x00000011, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000202, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000080, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x0000000f, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000013, /* EMC_TXSR */
			0x00000013, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000213, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1060a298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000022, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x00110011, /* EMC_MRS_WAIT_CNT */
			0x00110011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f2f3, /* EMC_CFG_PIPE */
			0x8000050e, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x00000001, /* MC_EMEM_ARB_CFG */
			0x8000001e, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x74230403, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000021, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00b0, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ec, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ec, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00e90049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00a3, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ef, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ef, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ee00ef, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"05_102000_01_V5.0.9_V0.8", /* DVFS table version */
		102000,     /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000006, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000004, /* EMC_RC */
			0x0000001a, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000003, /* EMC_RAS */
			0x00000001, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000001, /* EMC_RD_RCD */
			0x00000001, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000304, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000000c1, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000018, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000001c, /* EMC_TXSR */
			0x0000001c, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000001, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x0000031c, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1060a298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ4 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ5 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ6 */
			0x0000fc00, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000033, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x00110011, /* EMC_MRS_WAIT_CNT */
			0x00110011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f2f3, /* EMC_CFG_PIPE */
			0x80000713, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x08000001, /* MC_EMEM_ARB_CFG */
			0x80000026, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000003, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0403, /* MC_EMEM_ARB_DA_COVERS */
			0x73c30504, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000031, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff0075, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff009d, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff009d, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x009b0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ad, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00c6, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00d6, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x0000009f, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x0000009f, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x009f00a0, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"05_204000_01_V5.0.9_V0.8", /* DVFS table version */
		204000,     /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000002, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000009, /* EMC_RC */
			0x00000035, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000006, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000005, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000004, /* EMC_EINPUT */
			0x00000006, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000003, /* EMC_QRST */
			0x0000000d, /* EMC_QSAFE */
			0x0000000f, /* EMC_RDV */
			0x00000011, /* EMC_RDV_MASK */
			0x00000607, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000181, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000032, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000038, /* EMC_TXSR */
			0x00000038, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000004, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000638, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1060a298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00064000, /* EMC_DLL_XFORM_DQS0 */
			0x00064000, /* EMC_DLL_XFORM_DQS1 */
			0x00064000, /* EMC_DLL_XFORM_DQS2 */
			0x00064000, /* EMC_DLL_XFORM_DQS3 */
			0x00064000, /* EMC_DLL_XFORM_DQS4 */
			0x00064000, /* EMC_DLL_XFORM_DQS5 */
			0x00064000, /* EMC_DLL_XFORM_DQS6 */
			0x00064000, /* EMC_DLL_XFORM_DQS7 */
			0x00064000, /* EMC_DLL_XFORM_DQS8 */
			0x00064000, /* EMC_DLL_XFORM_DQS9 */
			0x00064000, /* EMC_DLL_XFORM_DQS10 */
			0x00064000, /* EMC_DLL_XFORM_DQS11 */
			0x00064000, /* EMC_DLL_XFORM_DQS12 */
			0x00064000, /* EMC_DLL_XFORM_DQS13 */
			0x00064000, /* EMC_DLL_XFORM_DQS14 */
			0x00064000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00090000, /* EMC_DLL_XFORM_DQ0 */
			0x00090000, /* EMC_DLL_XFORM_DQ1 */
			0x00090000, /* EMC_DLL_XFORM_DQ2 */
			0x00090000, /* EMC_DLL_XFORM_DQ3 */
			0x00009000, /* EMC_DLL_XFORM_DQ4 */
			0x00009000, /* EMC_DLL_XFORM_DQ5 */
			0x00009000, /* EMC_DLL_XFORM_DQ6 */
			0x00009000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000066, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x00110011, /* EMC_MRS_WAIT_CNT */
			0x00110011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000d2b3, /* EMC_CFG_PIPE */
			0x80000d22, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x01000003, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000004, /* MC_EMEM_ARB_TIMING_RC */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06040203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0404, /* MC_EMEM_ARB_DA_COVERS */
			0x73840a05, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000062, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00af, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff004f, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00af, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff004f, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x004e0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080057, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0063, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff0036, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff006b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000050, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000050, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510050, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00c6, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008cd, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"05_300000_01_V5.0.9_V0.8", /* DVFS table version */
		300000,     /* SDRAM frequency */
		810,        /* min voltage */
		800,        /* gpu min voltage */
		"pllc_out0", /* clock source id */
		0x20000002, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000000c, /* EMC_RC */
			0x0000004c, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000008, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x00000009, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x00000006, /* EMC_EINPUT_DURATION */
			0x00030000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x0000000d, /* EMC_QSAFE */
			0x0000000e, /* EMC_RDV */
			0x00000010, /* EMC_RDV_MASK */
			0x000008e4, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000239, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000008, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x0000004a, /* EMC_AR2PDEN */
			0x0000000e, /* EMC_RW2PDEN */
			0x00000051, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000005, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000924, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00030000, /* EMC_DLL_XFORM_DQS0 */
			0x00030000, /* EMC_DLL_XFORM_DQS1 */
			0x00030000, /* EMC_DLL_XFORM_DQS2 */
			0x00030000, /* EMC_DLL_XFORM_DQS3 */
			0x00030000, /* EMC_DLL_XFORM_DQS4 */
			0x00030000, /* EMC_DLL_XFORM_DQS5 */
			0x00030000, /* EMC_DLL_XFORM_DQS6 */
			0x00030000, /* EMC_DLL_XFORM_DQS7 */
			0x00030000, /* EMC_DLL_XFORM_DQS8 */
			0x00030000, /* EMC_DLL_XFORM_DQS9 */
			0x00030000, /* EMC_DLL_XFORM_DQS10 */
			0x00030000, /* EMC_DLL_XFORM_DQS11 */
			0x00030000, /* EMC_DLL_XFORM_DQS12 */
			0x00030000, /* EMC_DLL_XFORM_DQS13 */
			0x00030000, /* EMC_DLL_XFORM_DQS14 */
			0x00030000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00060000, /* EMC_DLL_XFORM_DQ0 */
			0x00060000, /* EMC_DLL_XFORM_DQ1 */
			0x00060000, /* EMC_DLL_XFORM_DQ2 */
			0x00060000, /* EMC_DLL_XFORM_DQ3 */
			0x00006000, /* EMC_DLL_XFORM_DQ4 */
			0x00006000, /* EMC_DLL_XFORM_DQ5 */
			0x00006000, /* EMC_DLL_XFORM_DQ6 */
			0x00006000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x01231339, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000096, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x01740011, /* EMC_MRS_WAIT_CNT */
			0x01740011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000d3b3, /* EMC_CFG_PIPE */
			0x800012d7, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x08000004, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000006, /* MC_EMEM_ARB_TIMING_RC */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06040202, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0506, /* MC_EMEM_ARB_DA_COVERS */
			0x77450e07, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000004, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000090, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00350049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008003b, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0043, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff002d, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510036, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff0087, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73340000, /* EMC_CFG */
		0x000008cd, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000321, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200000, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"05_396000_01_V5.0.9_V0.8", /* DVFS table version */
		396000,     /* SDRAM frequency */
		860,        /* min voltage */
		900,        /* gpu min voltage */
		"pllm_out0", /* clock source id */
		0x00000002, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000011, /* EMC_RC */
			0x00000065, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x0000000c, /* EMC_RAS */
			0x00000004, /* EMC_RP */
			0x00000005, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000004, /* EMC_RD_RCD */
			0x00000004, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x00000006, /* EMC_EINPUT_DURATION */
			0x00030000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x0000000d, /* EMC_QSAFE */
			0x0000000e, /* EMC_RDV */
			0x00000010, /* EMC_RDV_MASK */
			0x00000bd1, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000002f4, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000008, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000063, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000006b, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000007, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000c11, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00030000, /* EMC_DLL_XFORM_DQS0 */
			0x00030000, /* EMC_DLL_XFORM_DQS1 */
			0x00030000, /* EMC_DLL_XFORM_DQS2 */
			0x00030000, /* EMC_DLL_XFORM_DQS3 */
			0x00030000, /* EMC_DLL_XFORM_DQS4 */
			0x00030000, /* EMC_DLL_XFORM_DQS5 */
			0x00030000, /* EMC_DLL_XFORM_DQS6 */
			0x00030000, /* EMC_DLL_XFORM_DQS7 */
			0x00030000, /* EMC_DLL_XFORM_DQS8 */
			0x00030000, /* EMC_DLL_XFORM_DQS9 */
			0x00030000, /* EMC_DLL_XFORM_DQS10 */
			0x00030000, /* EMC_DLL_XFORM_DQS11 */
			0x00030000, /* EMC_DLL_XFORM_DQS12 */
			0x00030000, /* EMC_DLL_XFORM_DQS13 */
			0x00030000, /* EMC_DLL_XFORM_DQS14 */
			0x00030000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00044000, /* EMC_DLL_XFORM_DQ0 */
			0x00044000, /* EMC_DLL_XFORM_DQ1 */
			0x00044000, /* EMC_DLL_XFORM_DQ2 */
			0x00044000, /* EMC_DLL_XFORM_DQ3 */
			0x00004400, /* EMC_DLL_XFORM_DQ4 */
			0x00004400, /* EMC_DLL_XFORM_DQ5 */
			0x00004400, /* EMC_DLL_XFORM_DQ6 */
			0x00004400, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x01231339, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x000000c6, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x015b0011, /* EMC_MRS_WAIT_CNT */
			0x015b0011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000d3b3, /* EMC_CFG_PIPE */
			0x8000188b, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x0f000005, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RP */
			0x00000009, /* MC_EMEM_ARB_TIMING_RC */
			0x00000005, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000004, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06040202, /* MC_EMEM_ARB_DA_TURNS */
			0x000d0709, /* MC_EMEM_ARB_DA_COVERS */
			0x7586120a, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000a, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000000be, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00280049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008002d, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0033, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff0022, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff0037, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff0066, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73340000, /* EMC_CFG */
		0x0000088d, /* EMC_CFG_2 */
		0x00040008, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000521, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200000, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"05_528000_01_V5.0.9_V0.8", /* DVFS table version */
		528000,     /* SDRAM frequency */
		920,        /* min voltage */
		900,        /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000017, /* EMC_RC */
			0x00000088, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000010, /* EMC_RAS */
			0x00000005, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000009, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x0000000d, /* EMC_W2P */
			0x00000005, /* EMC_RD_RCD */
			0x00000005, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000004, /* EMC_WDV */
			0x00000004, /* EMC_WDV_MASK */
			0x00000008, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000007, /* EMC_EINPUT_DURATION */
			0x00060000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000e, /* EMC_QSAFE */
			0x00000013, /* EMC_RDV */
			0x00000015, /* EMC_RDV_MASK */
			0x00000fd6, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000003f5, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x0000000b, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000084, /* EMC_AR2PDEN */
			0x00000012, /* EMC_RW2PDEN */
			0x0000008f, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x0000000b, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000006, /* EMC_TCLKSTABLE */
			0x00000006, /* EMC_TCLKSTOP */
			0x00001017, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b098, /* EMC_FBIO_CFG5 */
			0xe01d00b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000008, /* EMC_DLL_XFORM_DQS0 */
			0x00000008, /* EMC_DLL_XFORM_DQS1 */
			0x00000008, /* EMC_DLL_XFORM_DQS2 */
			0x00000008, /* EMC_DLL_XFORM_DQS3 */
			0x00000008, /* EMC_DLL_XFORM_DQS4 */
			0x00000008, /* EMC_DLL_XFORM_DQS5 */
			0x00000008, /* EMC_DLL_XFORM_DQS6 */
			0x00000008, /* EMC_DLL_XFORM_DQS7 */
			0x00000008, /* EMC_DLL_XFORM_DQS8 */
			0x00000008, /* EMC_DLL_XFORM_DQS9 */
			0x00000008, /* EMC_DLL_XFORM_DQS10 */
			0x00000008, /* EMC_DLL_XFORM_DQS11 */
			0x00000008, /* EMC_DLL_XFORM_DQS12 */
			0x00000008, /* EMC_DLL_XFORM_DQS13 */
			0x00000008, /* EMC_DLL_XFORM_DQS14 */
			0x00000008, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00058000, /* EMC_DLL_XFORM_ADDR0 */
			0x00058000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00058000, /* EMC_DLL_XFORM_ADDR3 */
			0x00058000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000c, /* EMC_DLL_XFORM_DQ0 */
			0x0000000c, /* EMC_DLL_XFORM_DQ1 */
			0x0000000c, /* EMC_DLL_XFORM_DQ2 */
			0x0000000c, /* EMC_DLL_XFORM_DQ3 */
			0x0000000c, /* EMC_DLL_XFORM_DQ4 */
			0x0000000c, /* EMC_DLL_XFORM_DQ5 */
			0x0000000c, /* EMC_DLL_XFORM_DQ6 */
			0x0000000c, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0123133d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x013a0011, /* EMC_MRS_WAIT_CNT */
			0x013a0011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x000052a0, /* EMC_CFG_PIPE */
			0x80002062, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000c, /* EMC_QPOP */
			0x0f000007, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000002, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RP */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RC */
			0x00000007, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000006, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000009, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06050202, /* MC_EMEM_ARB_DA_TURNS */
			0x000f080c, /* MC_EMEM_ARB_DA_COVERS */
			0x7428180d, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000d, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000000fd, /* MC_PTSA_GRANT_DECREMENT */
			0x00c10038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00c10038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00c1003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00c10090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00c10041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00c10090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00c10041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00c10080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080021, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000c1, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00c10026, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00c1001a, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00c10024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00c10029, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000c1, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00c10065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00c1002a, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x00000895, /* EMC_CFG_2 */
		0x00040008, /* EMC_SEL_DPD_CTRL */
		0xe01d0069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000941, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"05_600000_01_V5.0.9_V0.8", /* DVFS table version */
		600000,     /* SDRAM frequency */
		920,        /* min voltage */
		900,        /* gpu min voltage */
		"pllc_ud",  /* clock source id */
		0xe0000000, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000001a, /* EMC_RC */
			0x0000009a, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000012, /* EMC_RAS */
			0x00000006, /* EMC_RP */
			0x00000007, /* EMC_R2W */
			0x0000000b, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x00000010, /* EMC_W2P */
			0x00000006, /* EMC_RD_RCD */
			0x00000006, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x0000000a, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x0000000b, /* EMC_EINPUT_DURATION */
			0x00070000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x00000012, /* EMC_QSAFE */
			0x00000016, /* EMC_RDV */
			0x00000018, /* EMC_RDV_MASK */
			0x00001208, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000482, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x0000000d, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000096, /* EMC_AR2PDEN */
			0x00000015, /* EMC_RW2PDEN */
			0x000000a2, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x0000000c, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000006, /* EMC_TCLKSTABLE */
			0x00000006, /* EMC_TCLKSTOP */
			0x00001248, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b098, /* EMC_FBIO_CFG5 */
			0xe01900b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000008, /* EMC_DLL_XFORM_DQS0 */
			0x00000008, /* EMC_DLL_XFORM_DQS1 */
			0x00000008, /* EMC_DLL_XFORM_DQS2 */
			0x00000008, /* EMC_DLL_XFORM_DQS3 */
			0x00000008, /* EMC_DLL_XFORM_DQS4 */
			0x00000008, /* EMC_DLL_XFORM_DQS5 */
			0x00000008, /* EMC_DLL_XFORM_DQS6 */
			0x00000008, /* EMC_DLL_XFORM_DQS7 */
			0x00000008, /* EMC_DLL_XFORM_DQS8 */
			0x00000008, /* EMC_DLL_XFORM_DQS9 */
			0x00000008, /* EMC_DLL_XFORM_DQS10 */
			0x00000008, /* EMC_DLL_XFORM_DQS11 */
			0x00000008, /* EMC_DLL_XFORM_DQS12 */
			0x00000008, /* EMC_DLL_XFORM_DQS13 */
			0x00000008, /* EMC_DLL_XFORM_DQS14 */
			0x00000008, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0004c000, /* EMC_DLL_XFORM_ADDR0 */
			0x0004c000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0004c000, /* EMC_DLL_XFORM_ADDR3 */
			0x0004c000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000b, /* EMC_DLL_XFORM_DQ0 */
			0x0000000b, /* EMC_DLL_XFORM_DQ1 */
			0x0000000b, /* EMC_DLL_XFORM_DQ2 */
			0x0000000b, /* EMC_DLL_XFORM_DQ3 */
			0x0000000b, /* EMC_DLL_XFORM_DQ4 */
			0x0000000b, /* EMC_DLL_XFORM_DQ5 */
			0x0000000b, /* EMC_DLL_XFORM_DQ6 */
			0x0000000b, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0121113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x01280011, /* EMC_MRS_WAIT_CNT */
			0x01280011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x000040a0, /* EMC_CFG_PIPE */
			0x800024aa, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000e, /* EMC_QPOP */
			0x00000009, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000002, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RP */
			0x0000000d, /* MC_EMEM_ARB_TIMING_RC */
			0x00000008, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000006, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000b, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_W2R */
			0x07050202, /* MC_EMEM_ARB_DA_TURNS */
			0x00120a0d, /* MC_EMEM_ARB_DA_COVERS */
			0x73a91b0e, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000f, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000120, /* MC_PTSA_GRANT_DECREMENT */
			0x00aa0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00aa0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00aa003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00aa0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00aa0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00aa0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00aa0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00aa0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008001d, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000aa, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00aa0022, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00aa0018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00aa0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00aa0024, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000aa, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00aa0065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00aa0025, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x0000089d, /* EMC_CFG_2 */
		0x00040008, /* EMC_SEL_DPD_CTRL */
		0xe0190069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000b61, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200010, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"05_792000_01_V5.0.9_V0.8", /* DVFS table version */
		792000,     /* SDRAM frequency */
		1000,       /* min voltage */
		1100,       /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000023, /* EMC_RC */
			0x000000cc, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000019, /* EMC_RAS */
			0x00000009, /* EMC_RP */
			0x00000008, /* EMC_R2W */
			0x0000000d, /* EMC_W2R */
			0x00000004, /* EMC_R2P */
			0x00000013, /* EMC_W2P */
			0x00000009, /* EMC_RD_RCD */
			0x00000009, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x0000000b, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000002, /* EMC_EINPUT */
			0x0000000d, /* EMC_EINPUT_DURATION */
			0x00080000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000001, /* EMC_QRST */
			0x00000014, /* EMC_QSAFE */
			0x00000017, /* EMC_RDV */
			0x00000019, /* EMC_RDV_MASK */
			0x000017e2, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000005f8, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000003, /* EMC_PDEX2WR */
			0x00000011, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x000000c6, /* EMC_AR2PDEN */
			0x00000018, /* EMC_RW2PDEN */
			0x000000d6, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000005, /* EMC_TCKE */
			0x00000006, /* EMC_TCKESR */
			0x00000005, /* EMC_TPD */
			0x00000011, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000008, /* EMC_TCLKSTABLE */
			0x00000008, /* EMC_TCLKSTOP */
			0x00001822, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b098, /* EMC_FBIO_CFG5 */
			0xe01100b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000006, /* EMC_DLL_XFORM_DQS0 */
			0x00000006, /* EMC_DLL_XFORM_DQS1 */
			0x00000006, /* EMC_DLL_XFORM_DQS2 */
			0x00000006, /* EMC_DLL_XFORM_DQS3 */
			0x00000006, /* EMC_DLL_XFORM_DQS4 */
			0x00000006, /* EMC_DLL_XFORM_DQS5 */
			0x00000006, /* EMC_DLL_XFORM_DQS6 */
			0x00000006, /* EMC_DLL_XFORM_DQS7 */
			0x00000006, /* EMC_DLL_XFORM_DQS8 */
			0x00000006, /* EMC_DLL_XFORM_DQS9 */
			0x00000006, /* EMC_DLL_XFORM_DQS10 */
			0x00000006, /* EMC_DLL_XFORM_DQS11 */
			0x00000006, /* EMC_DLL_XFORM_DQS12 */
			0x00000006, /* EMC_DLL_XFORM_DQS13 */
			0x00000006, /* EMC_DLL_XFORM_DQS14 */
			0x00000006, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0003c000, /* EMC_DLL_XFORM_ADDR0 */
			0x0003c000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0003c000, /* EMC_DLL_XFORM_ADDR3 */
			0x0003c000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000b, /* EMC_DLL_XFORM_DQ0 */
			0x0000000b, /* EMC_DLL_XFORM_DQ1 */
			0x0000000b, /* EMC_DLL_XFORM_DQ2 */
			0x0000000b, /* EMC_DLL_XFORM_DQ3 */
			0x0000000b, /* EMC_DLL_XFORM_DQ4 */
			0x0000000b, /* EMC_DLL_XFORM_DQ5 */
			0x0000000b, /* EMC_DLL_XFORM_DQ6 */
			0x0000000b, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0120113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x61861820, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x61861800, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x00f80011, /* EMC_MRS_WAIT_CNT */
			0x00f80011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x000040a0, /* EMC_CFG_PIPE */
			0x80003012, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000f, /* EMC_QPOP */
			0x0e00000b, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000004, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000005, /* MC_EMEM_ARB_TIMING_RP */
			0x00000012, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000009, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000c, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_W2R */
			0x08060202, /* MC_EMEM_ARB_DA_TURNS */
			0x00160d12, /* MC_EMEM_ARB_DA_COVERS */
			0x734c2413, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000013, /* MC_MLL_MPCORER_PTSA_RATE */
			0x0000017c, /* MC_PTSA_GRANT_DECREMENT */
			0x00810038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00810038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x0081003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00810090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00810041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00810090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00810041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00810080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080016, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x00000081, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00810019, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00810018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00810024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x0081001c, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x00000081, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00810065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x0081001c, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x0000089d, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0xe0110069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000d71, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200018, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"05_924000_01_V5.0.9_V0.8", /* DVFS table version */
		924000,     /* SDRAM frequency */
		1010,       /* min voltage */
		1100,       /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000029, /* EMC_RC */
			0x000000ef, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x0000001d, /* EMC_RAS */
			0x0000000b, /* EMC_RP */
			0x0000000a, /* EMC_R2W */
			0x0000000f, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x00000016, /* EMC_W2P */
			0x0000000b, /* EMC_RD_RCD */
			0x0000000b, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000007, /* EMC_WDV */
			0x00000007, /* EMC_WDV_MASK */
			0x0000000d, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000002, /* EMC_EINPUT */
			0x0000000f, /* EMC_EINPUT_DURATION */
			0x000a0000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000001, /* EMC_QRST */
			0x00000016, /* EMC_QSAFE */
			0x0000001a, /* EMC_RDV */
			0x0000001c, /* EMC_RDV_MASK */
			0x00001be7, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000006f9, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000004, /* EMC_PDEX2WR */
			0x00000015, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x000000e6, /* EMC_AR2PDEN */
			0x0000001b, /* EMC_RW2PDEN */
			0x000000fa, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000006, /* EMC_TCKE */
			0x00000007, /* EMC_TCKESR */
			0x00000006, /* EMC_TPD */
			0x00000015, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x0000000a, /* EMC_TCLKSTABLE */
			0x0000000a, /* EMC_TCLKSTOP */
			0x00001c28, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b898, /* EMC_FBIO_CFG5 */
			0xe00d00b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000006, /* EMC_DLL_XFORM_DQS0 */
			0x00000006, /* EMC_DLL_XFORM_DQS1 */
			0x00000006, /* EMC_DLL_XFORM_DQS2 */
			0x00000006, /* EMC_DLL_XFORM_DQS3 */
			0x00000006, /* EMC_DLL_XFORM_DQS4 */
			0x00000006, /* EMC_DLL_XFORM_DQS5 */
			0x00000006, /* EMC_DLL_XFORM_DQS6 */
			0x00000006, /* EMC_DLL_XFORM_DQS7 */
			0x00000006, /* EMC_DLL_XFORM_DQS8 */
			0x00000006, /* EMC_DLL_XFORM_DQS9 */
			0x00000006, /* EMC_DLL_XFORM_DQS10 */
			0x00000006, /* EMC_DLL_XFORM_DQS11 */
			0x00000006, /* EMC_DLL_XFORM_DQS12 */
			0x00000006, /* EMC_DLL_XFORM_DQS13 */
			0x00000006, /* EMC_DLL_XFORM_DQS14 */
			0x00000006, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00030000, /* EMC_DLL_XFORM_ADDR0 */
			0x00030000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00030000, /* EMC_DLL_XFORM_ADDR3 */
			0x00030000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000a, /* EMC_DLL_XFORM_DQ0 */
			0x0000000a, /* EMC_DLL_XFORM_DQ1 */
			0x0000000a, /* EMC_DLL_XFORM_DQ2 */
			0x0000000a, /* EMC_DLL_XFORM_DQ3 */
			0x0000000a, /* EMC_DLL_XFORM_DQ4 */
			0x0000000a, /* EMC_DLL_XFORM_DQ5 */
			0x0000000a, /* EMC_DLL_XFORM_DQ6 */
			0x0000000a, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0120113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x5d75d720, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x5d75d700, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000128, /* EMC_ZCAL_WAIT_CNT */
			0x00ce0011, /* EMC_MRS_WAIT_CNT */
			0x00ce0011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x00004080, /* EMC_CFG_PIPE */
			0x800037ea, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000011, /* EMC_QPOP */
			0x0e00000d, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000005, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000006, /* MC_EMEM_ARB_TIMING_RP */
			0x00000015, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000e, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000b, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000e, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000009, /* MC_EMEM_ARB_TIMING_W2R */
			0x09070202, /* MC_EMEM_ARB_DA_TURNS */
			0x001a1015, /* MC_EMEM_ARB_DA_COVERS */
			0x734e2a16, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000017, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000001bb, /* MC_PTSA_GRANT_DECREMENT */
			0x006e0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x006e0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x006e003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x006e0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x006e0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x006e0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x006e0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x006e0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080016, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x0000006e, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x006e0019, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x006e0018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x006e0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x006e001b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x0000006e, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x006e0065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x006e001c, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x0000004c, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x0000089d, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0xe00d0069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000f15, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200020, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"05_1056000_01_V5.0.9_V0.8", /* DVFS table version */
		1056000,    /* SDRAM frequency */
		1100,       /* min voltage */
		1100,       /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000002f, /* EMC_RC */
			0x00000111, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000021, /* EMC_RAS */
			0x0000000c, /* EMC_RP */
			0x0000000a, /* EMC_R2W */
			0x00000011, /* EMC_W2R */
			0x00000006, /* EMC_R2P */
			0x00000019, /* EMC_W2P */
			0x0000000c, /* EMC_RD_RCD */
			0x0000000c, /* EMC_WR_RCD */
			0x00000004, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000007, /* EMC_WDV */
			0x00000007, /* EMC_WDV_MASK */
			0x0000000e, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000002, /* EMC_EINPUT */
			0x00000010, /* EMC_EINPUT_DURATION */
			0x000b0000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000001, /* EMC_QRST */
			0x00000017, /* EMC_QSAFE */
			0x0000001d, /* EMC_RDV */
			0x0000001f, /* EMC_RDV_MASK */
			0x00001fed, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000007fb, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000005, /* EMC_PDEX2WR */
			0x00000018, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000106, /* EMC_AR2PDEN */
			0x0000001e, /* EMC_RW2PDEN */
			0x0000011e, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000007, /* EMC_TCKE */
			0x00000008, /* EMC_TCKESR */
			0x00000007, /* EMC_TPD */
			0x00000018, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x0000000b, /* EMC_TCLKSTABLE */
			0x0000000b, /* EMC_TCLKSTOP */
			0x0000202d, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b8d8, /* EMC_FBIO_CFG5 */
			0xd00a00b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000002, /* EMC_DLL_XFORM_DQS0 */
			0x00000002, /* EMC_DLL_XFORM_DQS1 */
			0x00000002, /* EMC_DLL_XFORM_DQS2 */
			0x00000002, /* EMC_DLL_XFORM_DQS3 */
			0x00000002, /* EMC_DLL_XFORM_DQS4 */
			0x00000002, /* EMC_DLL_XFORM_DQS5 */
			0x00000002, /* EMC_DLL_XFORM_DQS6 */
			0x00000002, /* EMC_DLL_XFORM_DQS7 */
			0x00000002, /* EMC_DLL_XFORM_DQS8 */
			0x00000002, /* EMC_DLL_XFORM_DQS9 */
			0x00000002, /* EMC_DLL_XFORM_DQS10 */
			0x00000002, /* EMC_DLL_XFORM_DQS11 */
			0x00000002, /* EMC_DLL_XFORM_DQS12 */
			0x00000002, /* EMC_DLL_XFORM_DQS13 */
			0x00000002, /* EMC_DLL_XFORM_DQS14 */
			0x00000002, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0002c000, /* EMC_DLL_XFORM_ADDR0 */
			0x0002c000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0002c000, /* EMC_DLL_XFORM_ADDR3 */
			0x0002c000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00000008, /* EMC_DLL_XFORM_DQ0 */
			0x00000008, /* EMC_DLL_XFORM_DQ1 */
			0x00000008, /* EMC_DLL_XFORM_DQ2 */
			0x00000008, /* EMC_DLL_XFORM_DQ3 */
			0x00000008, /* EMC_DLL_XFORM_DQ4 */
			0x00000008, /* EMC_DLL_XFORM_DQ5 */
			0x00000008, /* EMC_DLL_XFORM_DQ6 */
			0x00000008, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0120113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x41041020, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x41041000, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000152, /* EMC_ZCAL_WAIT_CNT */
			0x00a30011, /* EMC_MRS_WAIT_CNT */
			0x00a30011, /* EMC_MRS_WAIT_CNT2 */
			0x0000000a, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x00000000, /* EMC_CFG_PIPE */
			0x80003fc1, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000012, /* EMC_QPOP */
			0x0d00000f, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000005, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000006, /* MC_EMEM_ARB_TIMING_RP */
			0x00000018, /* MC_EMEM_ARB_TIMING_RC */
			0x00000010, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000c, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000f, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_R2W */
			0x0000000a, /* MC_EMEM_ARB_TIMING_W2R */
			0x0a070202, /* MC_EMEM_ARB_DA_TURNS */
			0x001c1118, /* MC_EMEM_ARB_DA_COVERS */
			0x73503019, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000001a, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000001fa, /* MC_PTSA_GRANT_DECREMENT */
			0x00600038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00600038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x0060003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00600090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00600041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00600090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00600041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00600080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00600004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00600004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080016, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x00000060, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00600004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00600019, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00600018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00600024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x0060001b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x00000060, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00600060, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00600060, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00600060, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00600060, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00600065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x0060001c, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000057, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x000008a5, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0xd00a0069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x06060606, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000606, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000125, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200028, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"05_1200000_01_V5.0.9_V0.8", /* DVFS table version */
		1200000,    /* SDRAM frequency */
		1100,       /* min voltage */
		1100,       /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000036, /* EMC_RC */
			0x00000136, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000026, /* EMC_RAS */
			0x0000000e, /* EMC_RP */
			0x0000000a, /* EMC_R2W */
			0x00000012, /* EMC_W2R */
			0x00000007, /* EMC_R2P */
			0x00000019, /* EMC_W2P */
			0x0000000e, /* EMC_RD_RCD */
			0x0000000e, /* EMC_WR_RCD */
			0x00000004, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000007, /* EMC_WDV */
			0x00000007, /* EMC_WDV_MASK */
			0x0000000e, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000000, /* EMC_EINPUT */
			0x00000012, /* EMC_EINPUT_DURATION */
			0x000b0000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000000, /* EMC_QRST */
			0x00000018, /* EMC_QSAFE */
			0x0000001d, /* EMC_RDV */
			0x0000001f, /* EMC_RDV_MASK */
			0x00002450, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000914, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000006, /* EMC_PDEX2WR */
			0x0000001b, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000129, /* EMC_AR2PDEN */
			0x0000001e, /* EMC_RW2PDEN */
			0x00000144, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000008, /* EMC_TCKE */
			0x00000009, /* EMC_TCKESR */
			0x00000008, /* EMC_TPD */
			0x0000001b, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x0000000c, /* EMC_TCLKSTABLE */
			0x0000000c, /* EMC_TCLKSTOP */
			0x00002490, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b8d8, /* EMC_FBIO_CFG5 */
			0xd00a00b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000002, /* EMC_DLL_XFORM_DQS0 */
			0x00000002, /* EMC_DLL_XFORM_DQS1 */
			0x00000002, /* EMC_DLL_XFORM_DQS2 */
			0x00000002, /* EMC_DLL_XFORM_DQS3 */
			0x00000002, /* EMC_DLL_XFORM_DQS4 */
			0x00000002, /* EMC_DLL_XFORM_DQS5 */
			0x00000002, /* EMC_DLL_XFORM_DQS6 */
			0x00000002, /* EMC_DLL_XFORM_DQS7 */
			0x00000002, /* EMC_DLL_XFORM_DQS8 */
			0x00000002, /* EMC_DLL_XFORM_DQS9 */
			0x00000002, /* EMC_DLL_XFORM_DQS10 */
			0x00000002, /* EMC_DLL_XFORM_DQS11 */
			0x00000002, /* EMC_DLL_XFORM_DQS12 */
			0x00000002, /* EMC_DLL_XFORM_DQS13 */
			0x00000002, /* EMC_DLL_XFORM_DQS14 */
			0x00000002, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00024000, /* EMC_DLL_XFORM_ADDR0 */
			0x00024000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00024000, /* EMC_DLL_XFORM_ADDR3 */
			0x00024000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00000008, /* EMC_DLL_XFORM_DQ0 */
			0x00000008, /* EMC_DLL_XFORM_DQ1 */
			0x00000008, /* EMC_DLL_XFORM_DQ2 */
			0x00000008, /* EMC_DLL_XFORM_DQ3 */
			0x00000008, /* EMC_DLL_XFORM_DQ4 */
			0x00000008, /* EMC_DLL_XFORM_DQ5 */
			0x00000008, /* EMC_DLL_XFORM_DQ6 */
			0x00000008, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0120113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000808, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016fffff, /* EMC_XM2VTTGENPADCTRL3 */
			0x49249220, /* EMC_XM2DQSPADCTRL3 */
			0x00596596, /* EMC_XM2DQSPADCTRL4 */
			0x00596596, /* EMC_XM2DQSPADCTRL5 */
			0x49249200, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000180, /* EMC_ZCAL_WAIT_CNT */
			0x00750011, /* EMC_MRS_WAIT_CNT */
			0x00750011, /* EMC_MRS_WAIT_CNT2 */
			0x0000000a, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x00000000, /* EMC_CFG_PIPE */
			0x80004850, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000012, /* EMC_QPOP */
			0x00000012, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000006, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000007, /* MC_EMEM_ARB_TIMING_RP */
			0x0000001b, /* MC_EMEM_ARB_TIMING_RC */
			0x00000012, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000e, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000005, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000f, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_R2W */
			0x0000000b, /* MC_EMEM_ARB_TIMING_W2R */
			0x0b070202, /* MC_EMEM_ARB_DA_TURNS */
			0x001e141b, /* MC_EMEM_ARB_DA_COVERS */
			0x7352361c, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000001a, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000001ff, /* MC_PTSA_GRANT_DECREMENT */
			0x00550038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00550038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x0055003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00550090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00550041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00550090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00550041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00550080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00550004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00550004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080016, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x00000055, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00550004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00550019, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00550018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00550024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x0055001b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x00000055, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00550055, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00550055, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00550055, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00550055, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00550065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x0055001c, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000062, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x000008a5, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0xd00a0069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x06060606, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000606, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000125, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200028, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
};

static struct tegra12_emc_table loki_ffd_sku100_emc_table[] = {
	{
		0x18,       /* V5.0.9 */
		"02_12750_01_V5.0.9_V0.8", /* DVFS table version */
		12750,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x4000003e, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000000, /* EMC_RC */
			0x00000003, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000000, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000060, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000018, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000005, /* EMC_TXSR */
			0x00000005, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000064, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1060a298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00078000, /* EMC_DLL_XFORM_DQS8 */
			0x00078000, /* EMC_DLL_XFORM_DQS9 */
			0x00078000, /* EMC_DLL_XFORM_DQS10 */
			0x00078000, /* EMC_DLL_XFORM_DQS11 */
			0x00078000, /* EMC_DLL_XFORM_DQS12 */
			0x00078000, /* EMC_DLL_XFORM_DQS13 */
			0x00078000, /* EMC_DLL_XFORM_DQS14 */
			0x00078000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x00008000, /* EMC_DLL_XFORM_DQ4 */
			0x00008000, /* EMC_DLL_XFORM_DQ5 */
			0x00008000, /* EMC_DLL_XFORM_DQ6 */
			0x00008000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000007, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x000f000f, /* EMC_MRS_WAIT_CNT */
			0x000f000f, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f2f3, /* EMC_CFG_PIPE */
			0x800001c5, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x40040001, /* MC_EMEM_ARB_CFG */
			0x8000000a, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x77e30303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000007, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"02_20400_01_V5.0.9_V0.8", /* DVFS table version */
		20400,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000026, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000000, /* EMC_RC */
			0x00000005, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000000, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x0000009a, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000026, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000007, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000006, /* EMC_TXSR */
			0x00000006, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x000000a0, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1060a298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00078000, /* EMC_DLL_XFORM_DQS8 */
			0x00078000, /* EMC_DLL_XFORM_DQS9 */
			0x00078000, /* EMC_DLL_XFORM_DQS10 */
			0x00078000, /* EMC_DLL_XFORM_DQS11 */
			0x00078000, /* EMC_DLL_XFORM_DQS12 */
			0x00078000, /* EMC_DLL_XFORM_DQS13 */
			0x00078000, /* EMC_DLL_XFORM_DQS14 */
			0x00078000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x00008000, /* EMC_DLL_XFORM_DQ4 */
			0x00008000, /* EMC_DLL_XFORM_DQ5 */
			0x00008000, /* EMC_DLL_XFORM_DQ6 */
			0x00008000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x0000000b, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x000f000f, /* EMC_MRS_WAIT_CNT */
			0x000f000f, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f2f3, /* EMC_CFG_PIPE */
			0x8000023a, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x40020001, /* MC_EMEM_ARB_CFG */
			0x80000012, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x76230303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x0000000a, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"02_40800_01_V5.0.9_V0.8", /* DVFS table version */
		40800,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000012, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000001, /* EMC_RC */
			0x0000000a, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000001, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000134, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x0000004d, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000008, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000000c, /* EMC_TXSR */
			0x0000000c, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x0000013f, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1060a298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00078000, /* EMC_DLL_XFORM_DQS8 */
			0x00078000, /* EMC_DLL_XFORM_DQS9 */
			0x00078000, /* EMC_DLL_XFORM_DQS10 */
			0x00078000, /* EMC_DLL_XFORM_DQS11 */
			0x00078000, /* EMC_DLL_XFORM_DQS12 */
			0x00078000, /* EMC_DLL_XFORM_DQS13 */
			0x00078000, /* EMC_DLL_XFORM_DQS14 */
			0x00078000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x00008000, /* EMC_DLL_XFORM_DQ4 */
			0x00008000, /* EMC_DLL_XFORM_DQ5 */
			0x00008000, /* EMC_DLL_XFORM_DQ6 */
			0x00008000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000015, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x000f000f, /* EMC_MRS_WAIT_CNT */
			0x000f000f, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f2f3, /* EMC_CFG_PIPE */
			0x80000370, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0xa0000001, /* MC_EMEM_ARB_CFG */
			0x80000017, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x74a30303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000014, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"02_68000_01_V5.0.9_V0.8", /* DVFS table version */
		68000,      /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x4000000a, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000003, /* EMC_RC */
			0x00000011, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000000, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000000, /* EMC_RD_RCD */
			0x00000000, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000202, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000080, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x0000000f, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000013, /* EMC_TXSR */
			0x00000013, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000000, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000213, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1060a298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00078000, /* EMC_DLL_XFORM_DQS8 */
			0x00078000, /* EMC_DLL_XFORM_DQS9 */
			0x00078000, /* EMC_DLL_XFORM_DQS10 */
			0x00078000, /* EMC_DLL_XFORM_DQS11 */
			0x00078000, /* EMC_DLL_XFORM_DQS12 */
			0x00078000, /* EMC_DLL_XFORM_DQS13 */
			0x00078000, /* EMC_DLL_XFORM_DQS14 */
			0x00078000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x00008000, /* EMC_DLL_XFORM_DQ4 */
			0x00008000, /* EMC_DLL_XFORM_DQ5 */
			0x00008000, /* EMC_DLL_XFORM_DQ6 */
			0x00008000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000022, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x000f000f, /* EMC_MRS_WAIT_CNT */
			0x000f000f, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f2f3, /* EMC_CFG_PIPE */
			0x8000050e, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x00000001, /* MC_EMEM_ARB_CFG */
			0x8000001e, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0402, /* MC_EMEM_ARB_DA_COVERS */
			0x74230403, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000021, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff00b0, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff00ec, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff00ec, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00e90049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ff, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff00a3, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x000000ef, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x000000ef, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00ee00ef, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"02_102000_01_V5.0.9_V0.8", /* DVFS table version */
		102000,     /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000006, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000004, /* EMC_RC */
			0x0000001a, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000003, /* EMC_RAS */
			0x00000001, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000001, /* EMC_RD_RCD */
			0x00000001, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000d, /* EMC_RDV */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000304, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000000c1, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000018, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000001c, /* EMC_TXSR */
			0x0000001c, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000001, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x0000031c, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1060a298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00078000, /* EMC_DLL_XFORM_DQS8 */
			0x00078000, /* EMC_DLL_XFORM_DQS9 */
			0x00078000, /* EMC_DLL_XFORM_DQS10 */
			0x00078000, /* EMC_DLL_XFORM_DQS11 */
			0x00078000, /* EMC_DLL_XFORM_DQS12 */
			0x00078000, /* EMC_DLL_XFORM_DQS13 */
			0x00078000, /* EMC_DLL_XFORM_DQS14 */
			0x00078000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x00008000, /* EMC_DLL_XFORM_DQ4 */
			0x00008000, /* EMC_DLL_XFORM_DQ5 */
			0x00008000, /* EMC_DLL_XFORM_DQ6 */
			0x00008000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000e0e, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000033, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000042, /* EMC_ZCAL_WAIT_CNT */
			0x000f000f, /* EMC_MRS_WAIT_CNT */
			0x000f000f, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000f2f3, /* EMC_CFG_PIPE */
			0x80000713, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x08000001, /* MC_EMEM_ARB_CFG */
			0x80000026, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000003, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06030203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0403, /* MC_EMEM_ARB_DA_COVERS */
			0x73c30504, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000031, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff0075, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff009d, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff009d, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x009b0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x000800ad, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff00c6, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff00d6, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x0000009f, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x0000009f, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x009f00a0, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff00da, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008c5, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"02_204000_01_V5.0.9_V0.8", /* DVFS table version */
		204000,     /* SDRAM frequency */
		800,        /* min voltage */
		800,        /* gpu min voltage */
		"pllp_out0", /* clock source id */
		0x40000002, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000009, /* EMC_RC */
			0x00000035, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000006, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000005, /* EMC_R2W */
			0x0000000a, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000b, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x00000006, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000004, /* EMC_EINPUT */
			0x00000006, /* EMC_EINPUT_DURATION */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000003, /* EMC_QRST */
			0x0000000d, /* EMC_QSAFE */
			0x0000000f, /* EMC_RDV */
			0x00000011, /* EMC_RDV_MASK */
			0x00000607, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000181, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000032, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x00000038, /* EMC_TXSR */
			0x00000038, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000004, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000638, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1060a298, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00078000, /* EMC_DLL_XFORM_DQS8 */
			0x00078000, /* EMC_DLL_XFORM_DQS9 */
			0x00078000, /* EMC_DLL_XFORM_DQS10 */
			0x00078000, /* EMC_DLL_XFORM_DQS11 */
			0x00078000, /* EMC_DLL_XFORM_DQS12 */
			0x00078000, /* EMC_DLL_XFORM_DQS13 */
			0x00078000, /* EMC_DLL_XFORM_DQS14 */
			0x00078000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00000000, /* EMC_DLL_XFORM_ADDR3 */
			0x00000000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00080000, /* EMC_DLL_XFORM_DQ0 */
			0x00080000, /* EMC_DLL_XFORM_DQ1 */
			0x00080000, /* EMC_DLL_XFORM_DQ2 */
			0x00080000, /* EMC_DLL_XFORM_DQ3 */
			0x00008000, /* EMC_DLL_XFORM_DQ4 */
			0x00008000, /* EMC_DLL_XFORM_DQ5 */
			0x00008000, /* EMC_DLL_XFORM_DQ6 */
			0x00008000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0130b118, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451400, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000066, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x000f000f, /* EMC_MRS_WAIT_CNT */
			0x000f000f, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000d2b3, /* EMC_CFG_PIPE */
			0x80000d22, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000a, /* EMC_QPOP */
			0x01000003, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000004, /* MC_EMEM_ARB_TIMING_RC */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000002, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06040203, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0404, /* MC_EMEM_ARB_DA_COVERS */
			0x73840a05, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000001, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000062, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff00af, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff004f, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff00af, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff004f, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x004e0049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080057, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0063, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff0036, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff006b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000050, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000050, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510050, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff00c6, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff006d, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73240000, /* EMC_CFG */
		0x000008cd, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000008, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80001221, /* Mode Register 0 */
		0x80100003, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"02_300000_01_V5.0.9_V0.8", /* DVFS table version */
		300000,     /* SDRAM frequency */
		810,        /* min voltage */
		800,        /* gpu min voltage */
		"pllc_out0", /* clock source id */
		0x20000002, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000000c, /* EMC_RC */
			0x0000004c, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000009, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x00000009, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x00000006, /* EMC_EINPUT_DURATION */
			0x00030000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x0000000d, /* EMC_QSAFE */
			0x0000000e, /* EMC_RDV */
			0x00000010, /* EMC_RDV_MASK */
			0x000008e4, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000239, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000008, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x0000004a, /* EMC_AR2PDEN */
			0x0000000e, /* EMC_RW2PDEN */
			0x00000051, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000005, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000924, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00080000, /* EMC_DLL_XFORM_DQS0 */
			0x00080000, /* EMC_DLL_XFORM_DQS1 */
			0x00080000, /* EMC_DLL_XFORM_DQS2 */
			0x00080000, /* EMC_DLL_XFORM_DQS3 */
			0x00080000, /* EMC_DLL_XFORM_DQS4 */
			0x00080000, /* EMC_DLL_XFORM_DQS5 */
			0x00080000, /* EMC_DLL_XFORM_DQS6 */
			0x00080000, /* EMC_DLL_XFORM_DQS7 */
			0x00080000, /* EMC_DLL_XFORM_DQS8 */
			0x00080000, /* EMC_DLL_XFORM_DQS9 */
			0x00080000, /* EMC_DLL_XFORM_DQS10 */
			0x00080000, /* EMC_DLL_XFORM_DQS11 */
			0x00080000, /* EMC_DLL_XFORM_DQS12 */
			0x00080000, /* EMC_DLL_XFORM_DQS13 */
			0x00080000, /* EMC_DLL_XFORM_DQS14 */
			0x00080000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00060000, /* EMC_DLL_XFORM_ADDR0 */
			0x00060000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00060000, /* EMC_DLL_XFORM_ADDR3 */
			0x00060000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00060000, /* EMC_DLL_XFORM_DQ0 */
			0x00060000, /* EMC_DLL_XFORM_DQ1 */
			0x00060000, /* EMC_DLL_XFORM_DQ2 */
			0x00060000, /* EMC_DLL_XFORM_DQ3 */
			0x00006000, /* EMC_DLL_XFORM_DQ4 */
			0x00006000, /* EMC_DLL_XFORM_DQ5 */
			0x00006000, /* EMC_DLL_XFORM_DQ6 */
			0x00006000, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x01231339, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000096, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x0174000f, /* EMC_MRS_WAIT_CNT */
			0x0174000f, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000d3b3, /* EMC_CFG_PIPE */
			0x800012d7, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x08000004, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000007, /* MC_EMEM_ARB_TIMING_RC */
			0x00000004, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06040202, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0507, /* MC_EMEM_ARB_DA_COVERS */
			0x77450e08, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000004, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000090, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00350049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008003b, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0043, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff002d, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff0049, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510036, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff0087, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff004a, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73340000, /* EMC_CFG */
		0x000008cd, /* EMC_CFG_2 */
		0x00040128, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000321, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200000, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"02_396000_01_V5.0.9_V0.8", /* DVFS table version */
		396000,     /* SDRAM frequency */
		860,        /* min voltage */
		900,        /* gpu min voltage */
		"pllm_out0", /* clock source id */
		0x00000002, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000011, /* EMC_RC */
			0x00000065, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x0000000c, /* EMC_RAS */
			0x00000004, /* EMC_RP */
			0x00000005, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000004, /* EMC_RD_RCD */
			0x00000004, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000005, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x00000006, /* EMC_EINPUT_DURATION */
			0x00030000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x0000000d, /* EMC_QSAFE */
			0x0000000e, /* EMC_RDV */
			0x00000010, /* EMC_RDV_MASK */
			0x00000bd1, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000002f4, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000008, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000063, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000006b, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x00000007, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000005, /* EMC_TCLKSTABLE */
			0x00000005, /* EMC_TCLKSTOP */
			0x00000c11, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b098, /* EMC_FBIO_CFG5 */
			0x002c00a0, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00080000, /* EMC_DLL_XFORM_DQS0 */
			0x00080000, /* EMC_DLL_XFORM_DQS1 */
			0x00080000, /* EMC_DLL_XFORM_DQS2 */
			0x00080000, /* EMC_DLL_XFORM_DQS3 */
			0x00080000, /* EMC_DLL_XFORM_DQS4 */
			0x00080000, /* EMC_DLL_XFORM_DQS5 */
			0x00080000, /* EMC_DLL_XFORM_DQS6 */
			0x00080000, /* EMC_DLL_XFORM_DQS7 */
			0x00080000, /* EMC_DLL_XFORM_DQS8 */
			0x00080000, /* EMC_DLL_XFORM_DQS9 */
			0x00080000, /* EMC_DLL_XFORM_DQS10 */
			0x00080000, /* EMC_DLL_XFORM_DQS11 */
			0x00080000, /* EMC_DLL_XFORM_DQS12 */
			0x00080000, /* EMC_DLL_XFORM_DQS13 */
			0x00080000, /* EMC_DLL_XFORM_DQS14 */
			0x00080000, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00050000, /* EMC_DLL_XFORM_ADDR0 */
			0x00050000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00050000, /* EMC_DLL_XFORM_ADDR3 */
			0x00050000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x00044000, /* EMC_DLL_XFORM_DQ0 */
			0x00044000, /* EMC_DLL_XFORM_DQ1 */
			0x00044000, /* EMC_DLL_XFORM_DQ2 */
			0x00044000, /* EMC_DLL_XFORM_DQ3 */
			0x00004400, /* EMC_DLL_XFORM_DQ4 */
			0x00004400, /* EMC_DLL_XFORM_DQ5 */
			0x00004400, /* EMC_DLL_XFORM_DQ6 */
			0x00004400, /* EMC_DLL_XFORM_DQ7 */
			0x10000280, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x01231339, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc081, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x000000c6, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x015b000f, /* EMC_MRS_WAIT_CNT */
			0x015b000f, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x0000d3b3, /* EMC_CFG_PIPE */
			0x8000188b, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000009, /* EMC_QPOP */
			0x0f000005, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RP */
			0x00000009, /* MC_EMEM_ARB_TIMING_RC */
			0x00000005, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000004, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06040202, /* MC_EMEM_ARB_DA_TURNS */
			0x000d0709, /* MC_EMEM_ARB_DA_COVERS */
			0x7586120a, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000a, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000000be, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00ff003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00ff0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00ff0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00280049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00ff0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008002d, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00ff0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00ff0033, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00ff0022, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00ff0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00ff0037, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00ff0066, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00ff0038, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73340000, /* EMC_CFG */
		0x0000088d, /* EMC_CFG_2 */
		0x00040008, /* EMC_SEL_DPD_CTRL */
		0x002c0068, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000521, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200000, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"02_528000_01_V5.0.9_V0.8", /* DVFS table version */
		528000,     /* SDRAM frequency */
		920,        /* min voltage */
		900,        /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000017, /* EMC_RC */
			0x00000088, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000010, /* EMC_RAS */
			0x00000005, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000009, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x0000000d, /* EMC_W2P */
			0x00000005, /* EMC_RD_RCD */
			0x00000005, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000004, /* EMC_WDV */
			0x00000004, /* EMC_WDV_MASK */
			0x00000008, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000005, /* EMC_EINPUT */
			0x00000007, /* EMC_EINPUT_DURATION */
			0x00060000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000004, /* EMC_QRST */
			0x0000000e, /* EMC_QSAFE */
			0x00000013, /* EMC_RDV */
			0x00000015, /* EMC_RDV_MASK */
			0x00000fd6, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000003f5, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x0000000b, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000084, /* EMC_AR2PDEN */
			0x00000012, /* EMC_RW2PDEN */
			0x0000008f, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x0000000b, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000006, /* EMC_TCLKSTABLE */
			0x00000006, /* EMC_TCLKSTOP */
			0x00001017, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b098, /* EMC_FBIO_CFG5 */
			0xe01d00b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000000a, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_DLL_XFORM_DQS1 */
			0x0000000a, /* EMC_DLL_XFORM_DQS2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS3 */
			0x0000000a, /* EMC_DLL_XFORM_DQS4 */
			0x0000000a, /* EMC_DLL_XFORM_DQS5 */
			0x0000000a, /* EMC_DLL_XFORM_DQS6 */
			0x0000000a, /* EMC_DLL_XFORM_DQS7 */
			0x0000000a, /* EMC_DLL_XFORM_DQS8 */
			0x0000000a, /* EMC_DLL_XFORM_DQS9 */
			0x0000000a, /* EMC_DLL_XFORM_DQS10 */
			0x0000000a, /* EMC_DLL_XFORM_DQS11 */
			0x0000000a, /* EMC_DLL_XFORM_DQS12 */
			0x0000000a, /* EMC_DLL_XFORM_DQS13 */
			0x0000000a, /* EMC_DLL_XFORM_DQS14 */
			0x0000000a, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00050000, /* EMC_DLL_XFORM_ADDR0 */
			0x00050000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00050000, /* EMC_DLL_XFORM_ADDR3 */
			0x00050000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000e, /* EMC_DLL_XFORM_DQ0 */
			0x0000000e, /* EMC_DLL_XFORM_DQ1 */
			0x0000000e, /* EMC_DLL_XFORM_DQ2 */
			0x0000000e, /* EMC_DLL_XFORM_DQ3 */
			0x0000000e, /* EMC_DLL_XFORM_DQ4 */
			0x0000000e, /* EMC_DLL_XFORM_DQ5 */
			0x0000000e, /* EMC_DLL_XFORM_DQ6 */
			0x0000000e, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0123133d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x013a000f, /* EMC_MRS_WAIT_CNT */
			0x013a000f, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x000052a0, /* EMC_CFG_PIPE */
			0x80002062, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000c, /* EMC_QPOP */
			0x0f000007, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000002, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RP */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RC */
			0x00000007, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000006, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000009, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06050202, /* MC_EMEM_ARB_DA_TURNS */
			0x000f080c, /* MC_EMEM_ARB_DA_COVERS */
			0x7428180d, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000d, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000000fd, /* MC_PTSA_GRANT_DECREMENT */
			0x00c10038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00c10038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00c1003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00c10090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00c10041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00c10090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00c10041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00c10080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080021, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000c1, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00c10004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00c10026, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00c1001a, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00c10024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00c10029, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000c1, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00c100c1, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00c10065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00c1002a, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x00000895, /* EMC_CFG_2 */
		0x00040008, /* EMC_SEL_DPD_CTRL */
		0xe01d0069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000941, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200008, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"02_600000_01_V5.0.9_V0.8", /* DVFS table version */
		600000,     /* SDRAM frequency */
		920,        /* min voltage */
		900,        /* gpu min voltage */
		"pllc_ud",  /* clock source id */
		0xe0000000, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000001a, /* EMC_RC */
			0x0000009a, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000013, /* EMC_RAS */
			0x00000006, /* EMC_RP */
			0x00000007, /* EMC_R2W */
			0x0000000b, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x00000010, /* EMC_W2P */
			0x00000006, /* EMC_RD_RCD */
			0x00000006, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x00000005, /* EMC_WDV_MASK */
			0x0000000a, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000003, /* EMC_EINPUT */
			0x0000000b, /* EMC_EINPUT_DURATION */
			0x00070000, /* EMC_PUTERM_EXTRA */
			0x00000003, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000002, /* EMC_QRST */
			0x00000012, /* EMC_QSAFE */
			0x00000016, /* EMC_RDV */
			0x00000018, /* EMC_RDV_MASK */
			0x00001208, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000482, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x0000000d, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000096, /* EMC_AR2PDEN */
			0x00000015, /* EMC_RW2PDEN */
			0x000000a2, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x0000000c, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000006, /* EMC_TCLKSTABLE */
			0x00000006, /* EMC_TCLKSTOP */
			0x00001248, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b098, /* EMC_FBIO_CFG5 */
			0xe01900b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000008, /* EMC_DLL_XFORM_DQS0 */
			0x00000008, /* EMC_DLL_XFORM_DQS1 */
			0x00000008, /* EMC_DLL_XFORM_DQS2 */
			0x00000008, /* EMC_DLL_XFORM_DQS3 */
			0x00000008, /* EMC_DLL_XFORM_DQS4 */
			0x00000008, /* EMC_DLL_XFORM_DQS5 */
			0x00000008, /* EMC_DLL_XFORM_DQS6 */
			0x00000008, /* EMC_DLL_XFORM_DQS7 */
			0x00000008, /* EMC_DLL_XFORM_DQS8 */
			0x00000008, /* EMC_DLL_XFORM_DQS9 */
			0x00000008, /* EMC_DLL_XFORM_DQS10 */
			0x00000008, /* EMC_DLL_XFORM_DQS11 */
			0x00000008, /* EMC_DLL_XFORM_DQS12 */
			0x00000008, /* EMC_DLL_XFORM_DQS13 */
			0x00000008, /* EMC_DLL_XFORM_DQS14 */
			0x00000008, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0004c000, /* EMC_DLL_XFORM_ADDR0 */
			0x0004c000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0004c000, /* EMC_DLL_XFORM_ADDR3 */
			0x0004c000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000b, /* EMC_DLL_XFORM_DQ0 */
			0x0000000b, /* EMC_DLL_XFORM_DQ1 */
			0x0000000b, /* EMC_DLL_XFORM_DQ2 */
			0x0000000b, /* EMC_DLL_XFORM_DQ3 */
			0x0000000b, /* EMC_DLL_XFORM_DQ4 */
			0x0000000b, /* EMC_DLL_XFORM_DQ5 */
			0x0000000b, /* EMC_DLL_XFORM_DQ6 */
			0x0000000b, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0121113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x51451420, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x51451400, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x0128000f, /* EMC_MRS_WAIT_CNT */
			0x0128000f, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000003, /* EMC_CTT_DURATION */
			0x000040a0, /* EMC_CFG_PIPE */
			0x800024aa, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000e, /* EMC_QPOP */
			0x00000009, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000002, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RP */
			0x0000000e, /* MC_EMEM_ARB_TIMING_RC */
			0x00000009, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000006, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000b, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_W2R */
			0x07050202, /* MC_EMEM_ARB_DA_TURNS */
			0x00120a0e, /* MC_EMEM_ARB_DA_COVERS */
			0x73a91b0f, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000000f, /* MC_MLL_MPCORER_PTSA_RATE */
			0x00000120, /* MC_PTSA_GRANT_DECREMENT */
			0x00aa0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00aa0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x00aa003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00aa0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00aa0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00aa0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00aa0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00aa0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x0008001d, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x000000aa, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00aa0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00aa0022, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00aa0018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00aa0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x00aa0024, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x000000aa, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00aa00aa, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00aa0065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x00aa0025, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x0000089d, /* EMC_CFG_2 */
		0x00040008, /* EMC_SEL_DPD_CTRL */
		0xe0190069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000b61, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200010, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"02_792000_01_V5.0.9_V0.8", /* DVFS table version */
		792000,     /* SDRAM frequency */
		1000,       /* min voltage */
		1100,       /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000023, /* EMC_RC */
			0x000000cc, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000019, /* EMC_RAS */
			0x00000009, /* EMC_RP */
			0x00000008, /* EMC_R2W */
			0x0000000d, /* EMC_W2R */
			0x00000004, /* EMC_R2P */
			0x00000013, /* EMC_W2P */
			0x00000009, /* EMC_RD_RCD */
			0x00000009, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000006, /* EMC_WDV */
			0x00000006, /* EMC_WDV_MASK */
			0x0000000b, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000002, /* EMC_EINPUT */
			0x0000000d, /* EMC_EINPUT_DURATION */
			0x00080000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000001, /* EMC_QRST */
			0x00000014, /* EMC_QSAFE */
			0x00000017, /* EMC_RDV */
			0x00000019, /* EMC_RDV_MASK */
			0x000017e2, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000005f8, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000003, /* EMC_PDEX2WR */
			0x00000011, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x000000c6, /* EMC_AR2PDEN */
			0x00000018, /* EMC_RW2PDEN */
			0x000000d6, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000005, /* EMC_TCKE */
			0x00000006, /* EMC_TCKESR */
			0x00000005, /* EMC_TPD */
			0x00000011, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x00000008, /* EMC_TCLKSTABLE */
			0x00000008, /* EMC_TCLKSTOP */
			0x00001822, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b098, /* EMC_FBIO_CFG5 */
			0xe01100b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000006, /* EMC_DLL_XFORM_DQS0 */
			0x00000006, /* EMC_DLL_XFORM_DQS1 */
			0x00000006, /* EMC_DLL_XFORM_DQS2 */
			0x00000006, /* EMC_DLL_XFORM_DQS3 */
			0x00000006, /* EMC_DLL_XFORM_DQS4 */
			0x00000006, /* EMC_DLL_XFORM_DQS5 */
			0x00000006, /* EMC_DLL_XFORM_DQS6 */
			0x00000006, /* EMC_DLL_XFORM_DQS7 */
			0x00000006, /* EMC_DLL_XFORM_DQS8 */
			0x00000006, /* EMC_DLL_XFORM_DQS9 */
			0x00000006, /* EMC_DLL_XFORM_DQS10 */
			0x00000006, /* EMC_DLL_XFORM_DQS11 */
			0x00000006, /* EMC_DLL_XFORM_DQS12 */
			0x00000006, /* EMC_DLL_XFORM_DQS13 */
			0x00000006, /* EMC_DLL_XFORM_DQS14 */
			0x00000006, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0003c000, /* EMC_DLL_XFORM_ADDR0 */
			0x0003c000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0003c000, /* EMC_DLL_XFORM_ADDR3 */
			0x0003c000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000b, /* EMC_DLL_XFORM_DQ0 */
			0x0000000b, /* EMC_DLL_XFORM_DQ1 */
			0x0000000b, /* EMC_DLL_XFORM_DQ2 */
			0x0000000b, /* EMC_DLL_XFORM_DQ3 */
			0x0000000b, /* EMC_DLL_XFORM_DQ4 */
			0x0000000b, /* EMC_DLL_XFORM_DQ5 */
			0x0000000b, /* EMC_DLL_XFORM_DQ6 */
			0x0000000b, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0120113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000606, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x49249220, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x49249200, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000100, /* EMC_ZCAL_WAIT_CNT */
			0x00f8000f, /* EMC_MRS_WAIT_CNT */
			0x00f8000f, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x000040a0, /* EMC_CFG_PIPE */
			0x80003012, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000f, /* EMC_QPOP */
			0x0e00000b, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000004, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000005, /* MC_EMEM_ARB_TIMING_RP */
			0x00000012, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000009, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000c, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_W2R */
			0x08060202, /* MC_EMEM_ARB_DA_TURNS */
			0x00160d12, /* MC_EMEM_ARB_DA_COVERS */
			0x734c2413, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000013, /* MC_MLL_MPCORER_PTSA_RATE */
			0x0000017c, /* MC_PTSA_GRANT_DECREMENT */
			0x00810038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00810038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x0081003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00810090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00810041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00810090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00810041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00810080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080016, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x00000081, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00810004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00810019, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00810018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00810024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x0081001c, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x00000081, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00810081, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00810065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x0081001c, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000042, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x0000089d, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0xe0110069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000d71, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200018, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"02_924000_01_V5.0.9_V0.8", /* DVFS table version */
		924000,     /* SDRAM frequency */
		1010,       /* min voltage */
		1100,       /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x00000029, /* EMC_RC */
			0x000000ef, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x0000001e, /* EMC_RAS */
			0x0000000b, /* EMC_RP */
			0x0000000a, /* EMC_R2W */
			0x0000000f, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x00000016, /* EMC_W2P */
			0x0000000b, /* EMC_RD_RCD */
			0x0000000b, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000007, /* EMC_WDV */
			0x00000007, /* EMC_WDV_MASK */
			0x0000000d, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000002, /* EMC_EINPUT */
			0x0000000f, /* EMC_EINPUT_DURATION */
			0x000a0000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000001, /* EMC_QRST */
			0x00000016, /* EMC_QSAFE */
			0x0000001a, /* EMC_RDV */
			0x0000001c, /* EMC_RDV_MASK */
			0x00001be7, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000006f9, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000004, /* EMC_PDEX2WR */
			0x00000015, /* EMC_PDEX2RD */
			0x00000001, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x000000e6, /* EMC_AR2PDEN */
			0x0000001b, /* EMC_RW2PDEN */
			0x000000fa, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000006, /* EMC_TCKE */
			0x00000007, /* EMC_TCKESR */
			0x00000006, /* EMC_TPD */
			0x00000015, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x0000000a, /* EMC_TCLKSTABLE */
			0x0000000a, /* EMC_TCLKSTOP */
			0x00001c28, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b898, /* EMC_FBIO_CFG5 */
			0xe00d00b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000008, /* EMC_DLL_XFORM_DQS0 */
			0x00000008, /* EMC_DLL_XFORM_DQS1 */
			0x00000008, /* EMC_DLL_XFORM_DQS2 */
			0x00000008, /* EMC_DLL_XFORM_DQS3 */
			0x00000008, /* EMC_DLL_XFORM_DQS4 */
			0x00000008, /* EMC_DLL_XFORM_DQS5 */
			0x00000008, /* EMC_DLL_XFORM_DQS6 */
			0x00000008, /* EMC_DLL_XFORM_DQS7 */
			0x00000008, /* EMC_DLL_XFORM_DQS8 */
			0x00000008, /* EMC_DLL_XFORM_DQS9 */
			0x00000008, /* EMC_DLL_XFORM_DQS10 */
			0x00000008, /* EMC_DLL_XFORM_DQS11 */
			0x00000008, /* EMC_DLL_XFORM_DQS12 */
			0x00000008, /* EMC_DLL_XFORM_DQS13 */
			0x00000008, /* EMC_DLL_XFORM_DQS14 */
			0x00000008, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00030000, /* EMC_DLL_XFORM_ADDR0 */
			0x00030000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x00030000, /* EMC_DLL_XFORM_ADDR3 */
			0x00030000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000c, /* EMC_DLL_XFORM_DQ0 */
			0x0000000d, /* EMC_DLL_XFORM_DQ1 */
			0x0000000d, /* EMC_DLL_XFORM_DQ2 */
			0x0000000d, /* EMC_DLL_XFORM_DQ3 */
			0x0000000d, /* EMC_DLL_XFORM_DQ4 */
			0x0000000d, /* EMC_DLL_XFORM_DQ5 */
			0x0000000d, /* EMC_DLL_XFORM_DQ6 */
			0x0000000d, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0120113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000808, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x4d34d320, /* EMC_XM2DQSPADCTRL3 */
			0x00514514, /* EMC_XM2DQSPADCTRL4 */
			0x00514514, /* EMC_XM2DQSPADCTRL5 */
			0x4d34d300, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000128, /* EMC_ZCAL_WAIT_CNT */
			0x00ce000f, /* EMC_MRS_WAIT_CNT */
			0x00ce000f, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x00004080, /* EMC_CFG_PIPE */
			0x800037ea, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000011, /* EMC_QPOP */
			0x0e00000d, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000005, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000006, /* MC_EMEM_ARB_TIMING_RP */
			0x00000016, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000e, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000b, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000e, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000009, /* MC_EMEM_ARB_TIMING_W2R */
			0x09070202, /* MC_EMEM_ARB_DA_TURNS */
			0x001a1016, /* MC_EMEM_ARB_DA_COVERS */
			0x734e2a17, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000017, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000001bb, /* MC_PTSA_GRANT_DECREMENT */
			0x006e0038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x006e0038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x006e003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x006e0090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x006e0041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x006e0090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x006e0041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x006e0080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080016, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x0000006e, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x006e0004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x006e0019, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x006e0018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x006e0024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x006e001b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x0000006e, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x006e006e, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x006e0065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x006e001c, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x0000004c, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x0000089d, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0xe00d0069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000f15, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200020, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
	{
		0x18,       /* V5.0.9 */
		"02_1056000_01_V5.0.9_V0.8", /* DVFS table version */
		1056000,    /* SDRAM frequency */
		1100,       /* min voltage */
		1100,       /* gpu min voltage */
		"pllm_ud",  /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		164,        /* number of burst_regs */
		31,         /* number of up_down_regs */
		{
			0x0000002f, /* EMC_RC */
			0x00000111, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000022, /* EMC_RAS */
			0x0000000c, /* EMC_RP */
			0x0000000a, /* EMC_R2W */
			0x00000011, /* EMC_W2R */
			0x00000006, /* EMC_R2P */
			0x00000019, /* EMC_W2P */
			0x0000000c, /* EMC_RD_RCD */
			0x0000000c, /* EMC_WR_RCD */
			0x00000004, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000007, /* EMC_WDV */
			0x00000007, /* EMC_WDV_MASK */
			0x0000000e, /* EMC_QUSE */
			0x00000002, /* EMC_QUSE_WIDTH */
			0x00000000, /* EMC_IBDLY */
			0x00000002, /* EMC_EINPUT */
			0x00000010, /* EMC_EINPUT_DURATION */
			0x000b0000, /* EMC_PUTERM_EXTRA */
			0x00000004, /* EMC_PUTERM_WIDTH */
			0x00000000, /* EMC_PUTERM_ADJ */
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000000, /* EMC_CDB_CNTL_3 */
			0x00000001, /* EMC_QRST */
			0x00000017, /* EMC_QSAFE */
			0x0000001d, /* EMC_RDV */
			0x0000001f, /* EMC_RDV_MASK */
			0x00001fed, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000007fb, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000005, /* EMC_PDEX2WR */
			0x00000018, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000106, /* EMC_AR2PDEN */
			0x0000001e, /* EMC_RW2PDEN */
			0x0000011e, /* EMC_TXSR */
			0x00000200, /* EMC_TXSRDLL */
			0x00000007, /* EMC_TCKE */
			0x00000008, /* EMC_TCKESR */
			0x00000007, /* EMC_TPD */
			0x00000018, /* EMC_TFAW */
			0x00000000, /* EMC_TRPAB */
			0x0000000b, /* EMC_TCLKSTABLE */
			0x0000000b, /* EMC_TCLKSTOP */
			0x0000202d, /* EMC_TREFBW */
			0x00000000, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x1040b898, /* EMC_FBIO_CFG5 */
			0xd00a00b1, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000002, /* EMC_DLL_XFORM_DQS0 */
			0x00000002, /* EMC_DLL_XFORM_DQS1 */
			0x00000002, /* EMC_DLL_XFORM_DQS2 */
			0x00000002, /* EMC_DLL_XFORM_DQS3 */
			0x00000002, /* EMC_DLL_XFORM_DQS4 */
			0x00000002, /* EMC_DLL_XFORM_DQS5 */
			0x00000002, /* EMC_DLL_XFORM_DQS6 */
			0x00000002, /* EMC_DLL_XFORM_DQS7 */
			0x00000002, /* EMC_DLL_XFORM_DQS8 */
			0x00000002, /* EMC_DLL_XFORM_DQS9 */
			0x00000002, /* EMC_DLL_XFORM_DQS10 */
			0x00000002, /* EMC_DLL_XFORM_DQS11 */
			0x00000002, /* EMC_DLL_XFORM_DQS12 */
			0x00000002, /* EMC_DLL_XFORM_DQS13 */
			0x00000002, /* EMC_DLL_XFORM_DQS14 */
			0x00000002, /* EMC_DLL_XFORM_DQS15 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x0002c000, /* EMC_DLL_XFORM_ADDR0 */
			0x0002c000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0002c000, /* EMC_DLL_XFORM_ADDR3 */
			0x0002c000, /* EMC_DLL_XFORM_ADDR4 */
			0x00000000, /* EMC_DLL_XFORM_ADDR5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE8 */
			0x00000000, /* EMC_DLL_XFORM_QUSE9 */
			0x00000000, /* EMC_DLL_XFORM_QUSE10 */
			0x00000000, /* EMC_DLL_XFORM_QUSE11 */
			0x00000000, /* EMC_DLL_XFORM_QUSE12 */
			0x00000000, /* EMC_DLL_XFORM_QUSE13 */
			0x00000000, /* EMC_DLL_XFORM_QUSE14 */
			0x00000000, /* EMC_DLL_XFORM_QUSE15 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS8 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS9 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS10 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS11 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS12 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS13 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS14 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS15 */
			0x0000000a, /* EMC_DLL_XFORM_DQ0 */
			0x0000000a, /* EMC_DLL_XFORM_DQ1 */
			0x0000000a, /* EMC_DLL_XFORM_DQ2 */
			0x0000000a, /* EMC_DLL_XFORM_DQ3 */
			0x0000000a, /* EMC_DLL_XFORM_DQ4 */
			0x0000000a, /* EMC_DLL_XFORM_DQ5 */
			0x0000000a, /* EMC_DLL_XFORM_DQ6 */
			0x0000000a, /* EMC_DLL_XFORM_DQ7 */
			0x100002a0, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x00111111, /* EMC_XM2CMDPADCTRL5 */
			0x0120113d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL3 */
			0x77ffc085, /* EMC_XM2CLKPADCTRL */
			0x00000808, /* EMC_XM2CLKPADCTRL2 */
			0x81f1f108, /* EMC_XM2COMPPADCTRL */
			0x07070004, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x016eeeee, /* EMC_XM2VTTGENPADCTRL3 */
			0x49249220, /* EMC_XM2DQSPADCTRL3 */
			0x00596596, /* EMC_XM2DQSPADCTRL4 */
			0x00596596, /* EMC_XM2DQSPADCTRL5 */
			0x49249200, /* EMC_XM2DQSPADCTRL6 */
			0x0606003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x00000000, /* EMC_FBIO_SPARE */
			0x00020000, /* EMC_ZCAL_INTERVAL */
			0x00000152, /* EMC_ZCAL_WAIT_CNT */
			0x00a3000f, /* EMC_MRS_WAIT_CNT */
			0x00a3000f, /* EMC_MRS_WAIT_CNT2 */
			0x0000000a, /* EMC_CTT */
			0x00000004, /* EMC_CTT_DURATION */
			0x00000000, /* EMC_CFG_PIPE */
			0x80003fc1, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000012, /* EMC_QPOP */
			0x0d00000f, /* MC_EMEM_ARB_CFG */
			0x80000040, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000005, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000006, /* MC_EMEM_ARB_TIMING_RP */
			0x00000018, /* MC_EMEM_ARB_TIMING_RC */
			0x00000010, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000c, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000f, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_R2W */
			0x0000000a, /* MC_EMEM_ARB_TIMING_W2R */
			0x0a070202, /* MC_EMEM_ARB_DA_TURNS */
			0x001c1118, /* MC_EMEM_ARB_DA_COVERS */
			0x73503019, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x0000001a, /* MC_MLL_MPCORER_PTSA_RATE */
			0x000001fa, /* MC_PTSA_GRANT_DECREMENT */
			0x00600038, /* MC_LATENCY_ALLOWANCE_XUSB_0 */
			0x00600038, /* MC_LATENCY_ALLOWANCE_XUSB_1 */
			0x0060003c, /* MC_LATENCY_ALLOWANCE_TSEC_0 */
			0x00600090, /* MC_LATENCY_ALLOWANCE_SDMMCA_0 */
			0x00600041, /* MC_LATENCY_ALLOWANCE_SDMMCAA_0 */
			0x00600090, /* MC_LATENCY_ALLOWANCE_SDMMC_0 */
			0x00600041, /* MC_LATENCY_ALLOWANCE_SDMMCAB_0 */
			0x00270049, /* MC_LATENCY_ALLOWANCE_PPCS_0 */
			0x00600080, /* MC_LATENCY_ALLOWANCE_PPCS_1 */
			0x00600004, /* MC_LATENCY_ALLOWANCE_MPCORE_0 */
			0x00600004, /* MC_LATENCY_ALLOWANCE_MPCORELP_0 */
			0x00080016, /* MC_LATENCY_ALLOWANCE_HC_0 */
			0x00000060, /* MC_LATENCY_ALLOWANCE_HC_1 */
			0x00600004, /* MC_LATENCY_ALLOWANCE_AVPC_0 */
			0x00600019, /* MC_LATENCY_ALLOWANCE_GPU_0 */
			0x00600018, /* MC_LATENCY_ALLOWANCE_MSENC_0 */
			0x00600024, /* MC_LATENCY_ALLOWANCE_HDA_0 */
			0x0060001b, /* MC_LATENCY_ALLOWANCE_VIC_0 */
			0x00000060, /* MC_LATENCY_ALLOWANCE_VI2_0 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2_0 */
			0x00600060, /* MC_LATENCY_ALLOWANCE_ISP2_1 */
			0x00000036, /* MC_LATENCY_ALLOWANCE_ISP2B_0 */
			0x00600060, /* MC_LATENCY_ALLOWANCE_ISP2B_1 */
			0x00d400ff, /* MC_LATENCY_ALLOWANCE_VDE_0 */
			0x00510029, /* MC_LATENCY_ALLOWANCE_VDE_1 */
			0x00600060, /* MC_LATENCY_ALLOWANCE_VDE_2 */
			0x00600060, /* MC_LATENCY_ALLOWANCE_VDE_3 */
			0x00600065, /* MC_LATENCY_ALLOWANCE_SATA_0 */
			0x0060001c, /* MC_LATENCY_ALLOWANCE_AFI_0 */
		},
		0x00000057, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000802, /* EMC_CTT_TERM_CTRL */
		0x73300000, /* EMC_CFG */
		0x000008a5, /* EMC_CFG_2 */
		0x00040000, /* EMC_SEL_DPD_CTRL */
		0xd00a0069, /* EMC_CFG_DIG_DLL */
		0x00000000, /* EMC_BGBIAS_CTL0 */
		0x06060606, /* EMC_AUTO_CAL_CONFIG2 */
		0x00000606, /* EMC_AUTO_CAL_CONFIG3 */
		0xa1430000, /* EMC_AUTO_CAL_CONFIG */
		0x80000125, /* Mode Register 0 */
		0x80100002, /* Mode Register 1 */
		0x80200028, /* Mode Register 2 */
		0x00000000, /* Mode Register 4 */
	},
};

static struct tegra12_emc_pdata loki_b00_sku0_emc_pdata = {
	.description = "loki_b00_sku0_emc_tables",
	.tables = loki_b00_sku0_emc_table,
	.num_tables = ARRAY_SIZE(loki_b00_sku0_emc_table),
};

static struct tegra12_emc_pdata thor_195_b00_emc_pdata = {
	.description = "thor_195_b00_emc_tables",
	.tables = thor_195_b00_emc_table,
	.num_tables = ARRAY_SIZE(thor_195_b00_emc_table),
};

static struct tegra12_emc_pdata loki_ffd_sku0_emc_pdata = {
	.description = "loki_ffd_sku0_emc_tables",
	.tables = loki_ffd_sku0_emc_table,
	.num_tables = ARRAY_SIZE(loki_ffd_sku0_emc_table),
};

static struct tegra12_emc_pdata loki_ffd_sku100_emc_pdata = {
	.description = "loki_ffd_sku100_emc_tables",
	.tables = loki_ffd_sku100_emc_table,
	.num_tables = ARRAY_SIZE(loki_ffd_sku100_emc_table),
};

int __init loki_emc_init(void)
{
	struct board_info bi;

	if (of_find_compatible_node(NULL, NULL, "nvidia,tegra12-emc")) {
		pr_info("Loading EMC tables from DeviceTree.\n");
	} else {
		tegra_get_board_info(&bi);

		if (bi.board_id == BOARD_E2548) {
			if (bi.fab == 0x0) {
				pr_info("Loki a02 EMC is not supported\n");
				return -EINVAL;
			}
			switch (bi.sku) {
			case BOARD_SKU_0:
				pr_info("Loading Loki B00 sku0 EMC table.\n");
				tegra_emc_device.dev.platform_data =
					&loki_b00_sku0_emc_pdata;
				break;
			case BOARD_SKU_100:
			default:
				WARN(1, "EMC for this loki sku not supported: %u\n",
						bi.sku);
				return -EINVAL;
			}
		} else if (bi.board_id == BOARD_E2549) {
			pr_info("Loading Thor 1.95 EMC table: 0x%08x\n", bi.sku);
			tegra_emc_device.dev.platform_data =
				&thor_195_b00_emc_pdata;
		} else if (bi.board_id == BOARD_P2530) {
			switch (bi.sku) {
			case BOARD_SKU_FOSTER:
			case BOARD_SKU_0:
				pr_info("Loading Loki FFD sku0 EMC table: 0x%08x\n",
					bi.sku);
				tegra_emc_device.dev.platform_data =
					&loki_ffd_sku0_emc_pdata;
				break;
			case BOARD_SKU_100:
				pr_info("Loading Loki FFD sku100 EMC table: 0x%08x\n",
					bi.sku);
				tegra_emc_device.dev.platform_data =
					&loki_ffd_sku100_emc_pdata;
				break;
			default:
				WARN(1, "EMC for this loki sku not supported: %u\n",
						bi.sku);
				return -EINVAL;
			}
		} else {
			WARN(1, "EMC on this board not yet supported: 0x%08x\n",
					bi.board_id);
			return -EINVAL;
		}

		platform_device_register(&tegra_emc_device);
	}

	tegra12_emc_init();
	return 0;
}
